"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiExpression", {
  enumerable: true,
  get: function get() {
    return _expression.EuiExpression;
  }
});

var _expression = require("./expression");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiExpression.__docgenInfo = {
    description: '',
    displayName: 'EuiExpression',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      description: {
        defaultValue: null,
        description: 'First part of the expression',
        name: 'description',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      descriptionProps: {
        defaultValue: null,
        description: '',
        name: 'descriptionProps',
        parent: undefined,
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement>'
        }
      },
      value: {
        defaultValue: null,
        description: 'Second part of the expression',
        name: 'value',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      valueProps: {
        defaultValue: null,
        description: '',
        name: 'valueProps',
        parent: undefined,
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement>'
        }
      },
      color: {
        defaultValue: null,
        description: 'Color of the `description`',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"primary" | "secondary" | "warning" | "danger" | "accent" | "subdued"',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"accent"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      uppercase: {
        defaultValue: null,
        description: 'Should the `description` auto-uppercase?',
        name: 'uppercase',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isActive: {
        defaultValue: null,
        description: 'Adds an solid border at the bottom',
        name: 'isActive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: 'Turns the component into a button and adds an editable style border at the bottom',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | (((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) & ((event: MouseEvent<...>) => void))'
        }
      },
      display: {
        defaultValue: null,
        description: 'Sets the display style for the expression. Defaults to `inline`',
        name: 'display',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"inline" | "columns"',
          value: [{
            value: '"inline"'
          }, {
            value: '"columns"'
          }]
        }
      },
      isInvalid: {
        defaultValue: null,
        description: 'Forces color to display as `danger` and shows an `alert` icon',
        name: 'isInvalid',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      descriptionWidth: {
        defaultValue: null,
        description: 'Sets a custom width for the description when using the columns layout.\nSet to a number for a custom width in `px`.\nSet to a string for a custom width in custom measurement.\nDefaults to `20%`',
        name: 'descriptionWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      },
      textWrap: {
        defaultValue: null,
        description: 'Sets how to handle the wrapping of long text.',
        name: 'textWrap',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"truncate" | "break-word"',
          value: [{
            value: '"truncate"'
          }, {
            value: '"break-word"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}