"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlexGrid = exports.COLUMNS = exports.GUTTER_SIZES = exports.DIRECTIONS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var directionToClassNameMap = {
  row: null,
  column: 'euiFlexGrid--directionColumn'
};
var DIRECTIONS = (0, _common.keysOf)(directionToClassNameMap);
exports.DIRECTIONS = DIRECTIONS;
var gutterSizeToClassNameMap = {
  none: 'euiFlexGrid--gutterNone',
  s: 'euiFlexGrid--gutterSmall',
  m: 'euiFlexGrid--gutterMedium',
  l: 'euiFlexGrid--gutterLarge',
  xl: 'euiFlexGrid--gutterXLarge'
};
var GUTTER_SIZES = (0, _common.keysOf)(gutterSizeToClassNameMap);
exports.GUTTER_SIZES = GUTTER_SIZES;
var columnsToClassNameMap = {
  0: 'euiFlexGrid--wrap',
  1: 'euiFlexGrid--single',
  2: 'euiFlexGrid--halves',
  3: 'euiFlexGrid--thirds',
  4: 'euiFlexGrid--fourths'
};
var COLUMNS = Object.keys(columnsToClassNameMap).map(function (columns) {
  return parseInt(columns, 10);
});
exports.COLUMNS = COLUMNS;

var EuiFlexGrid = function EuiFlexGrid(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'row' : _ref$direction,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? true : _ref$responsive,
      _ref$columns = _ref.columns,
      columns = _ref$columns === void 0 ? 0 : _ref$columns,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? 'div' : _ref$component,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "gutterSize", "direction", "responsive", "columns", "component"]);
  var classes = (0, _classnames.default)('euiFlexGrid', gutterSize ? gutterSizeToClassNameMap[gutterSize] : undefined, columns != null ? columnsToClassNameMap[columns] : undefined, direction ? directionToClassNameMap[direction] : undefined, {
    'euiFlexGrid--responsive': responsive
  }, className);
  return (// @ts-ignore difficult to verify `rest` applies to `Component`
    _react.default.createElement(Component, (0, _extends2.default)({
      className: classes
    }, rest), children)
  );
};

exports.EuiFlexGrid = EuiFlexGrid;
EuiFlexGrid.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node,

  /**
     * Number of columns `1-4`, pass `0` for normal display
     */
  columns: _propTypes.default.oneOf([0, 1, 2, 3, 4]),

  /**
     * Flex layouts default to left-right then top-down (`row`).
     * Change this prop to `column` to create a top-down then left-right display.
     * Only works with column count of `1-4`.
     */
  direction: _propTypes.default.oneOf(["row", "column"]),

  /**
     * Space between flex items
     */
  gutterSize: _propTypes.default.oneOf(["none", "s", "m", "l", "xl"]),

  /**
     * Force each item to be display block on smaller screens
     */
  responsive: _propTypes.default.bool,

  /**
     * The tag to render
     */
  component: _propTypes.default.any
};

try {
  EuiFlexGrid.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexGrid',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      columns: {
        defaultValue: {
          value: '0'
        },
        description: 'Number of columns `1-4`, pass `0` for normal display',
        name: 'columns',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'FlexGridColumns'
        }
      },
      direction: {
        defaultValue: {
          value: 'row'
        },
        description: 'Flex layouts default to left-right then top-down (`row`).\nChange this prop to `column` to create a top-down then left-right display.\nOnly works with column count of `1-4`.',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"column" | "row"',
          value: [{
            value: '"column"'
          }, {
            value: '"row"'
          }]
        }
      },
      gutterSize: {
        defaultValue: {
          value: 'l'
        },
        description: 'Space between flex items',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      responsive: {
        defaultValue: {
          value: 'true'
        },
        description: 'Force each item to be display block on smaller screens',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      component: {
        defaultValue: null,
        description: 'The tag to render',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'any HTML Element',
          raw: '"symbol" | "object" | "slot" | "style" | "title" | "form" | "text" | "s" | "filter" | "image" | "link" | "menu" | "stop" | "button" | "time" | "dialog" | "clipPath" | "mask" | "path" | ... 155 more ... | "view"',
          value: [{
            value: '"symbol"'
          }, {
            value: '"object"'
          }, {
            value: '"slot"'
          }, {
            value: '"style"'
          }, {
            value: '"title"'
          }, {
            value: '"form"'
          }, {
            value: '"text"'
          }, {
            value: '"s"'
          }, {
            value: '"filter"'
          }, {
            value: '"image"'
          }, {
            value: '"link"'
          }, {
            value: '"menu"'
          }, {
            value: '"stop"'
          }, {
            value: '"button"'
          }, {
            value: '"time"'
          }, {
            value: '"dialog"'
          }, {
            value: '"clipPath"'
          }, {
            value: '"mask"'
          }, {
            value: '"path"'
          }, {
            value: '"label"'
          }, {
            value: '"summary"'
          }, {
            value: '"legend"'
          }, {
            value: '"h1"'
          }, {
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"p"'
          }, {
            value: '"footer"'
          }, {
            value: '"span"'
          }, {
            value: '"pattern"'
          }, {
            value: '"pre"'
          }, {
            value: '"a"'
          }, {
            value: '"abbr"'
          }, {
            value: '"address"'
          }, {
            value: '"area"'
          }, {
            value: '"article"'
          }, {
            value: '"aside"'
          }, {
            value: '"audio"'
          }, {
            value: '"b"'
          }, {
            value: '"base"'
          }, {
            value: '"bdi"'
          }, {
            value: '"bdo"'
          }, {
            value: '"big"'
          }, {
            value: '"blockquote"'
          }, {
            value: '"body"'
          }, {
            value: '"br"'
          }, {
            value: '"canvas"'
          }, {
            value: '"caption"'
          }, {
            value: '"cite"'
          }, {
            value: '"code"'
          }, {
            value: '"col"'
          }, {
            value: '"colgroup"'
          }, {
            value: '"data"'
          }, {
            value: '"datalist"'
          }, {
            value: '"dd"'
          }, {
            value: '"del"'
          }, {
            value: '"details"'
          }, {
            value: '"dfn"'
          }, {
            value: '"div"'
          }, {
            value: '"dl"'
          }, {
            value: '"dt"'
          }, {
            value: '"em"'
          }, {
            value: '"embed"'
          }, {
            value: '"fieldset"'
          }, {
            value: '"figcaption"'
          }, {
            value: '"figure"'
          }, {
            value: '"head"'
          }, {
            value: '"header"'
          }, {
            value: '"hgroup"'
          }, {
            value: '"hr"'
          }, {
            value: '"html"'
          }, {
            value: '"i"'
          }, {
            value: '"iframe"'
          }, {
            value: '"img"'
          }, {
            value: '"input"'
          }, {
            value: '"ins"'
          }, {
            value: '"kbd"'
          }, {
            value: '"keygen"'
          }, {
            value: '"li"'
          }, {
            value: '"main"'
          }, {
            value: '"map"'
          }, {
            value: '"mark"'
          }, {
            value: '"menuitem"'
          }, {
            value: '"meta"'
          }, {
            value: '"meter"'
          }, {
            value: '"nav"'
          }, {
            value: '"noindex"'
          }, {
            value: '"noscript"'
          }, {
            value: '"ol"'
          }, {
            value: '"optgroup"'
          }, {
            value: '"option"'
          }, {
            value: '"output"'
          }, {
            value: '"param"'
          }, {
            value: '"picture"'
          }, {
            value: '"progress"'
          }, {
            value: '"q"'
          }, {
            value: '"rp"'
          }, {
            value: '"rt"'
          }, {
            value: '"ruby"'
          }, {
            value: '"samp"'
          }, {
            value: '"script"'
          }, {
            value: '"section"'
          }, {
            value: '"select"'
          }, {
            value: '"small"'
          }, {
            value: '"source"'
          }, {
            value: '"strong"'
          }, {
            value: '"sub"'
          }, {
            value: '"sup"'
          }, {
            value: '"table"'
          }, {
            value: '"template"'
          }, {
            value: '"tbody"'
          }, {
            value: '"td"'
          }, {
            value: '"textarea"'
          }, {
            value: '"tfoot"'
          }, {
            value: '"th"'
          }, {
            value: '"thead"'
          }, {
            value: '"tr"'
          }, {
            value: '"track"'
          }, {
            value: '"u"'
          }, {
            value: '"ul"'
          }, {
            value: '"var"'
          }, {
            value: '"video"'
          }, {
            value: '"wbr"'
          }, {
            value: '"webview"'
          }, {
            value: '"svg"'
          }, {
            value: '"animate"'
          }, {
            value: '"animateMotion"'
          }, {
            value: '"animateTransform"'
          }, {
            value: '"circle"'
          }, {
            value: '"defs"'
          }, {
            value: '"desc"'
          }, {
            value: '"ellipse"'
          }, {
            value: '"feBlend"'
          }, {
            value: '"feColorMatrix"'
          }, {
            value: '"feComponentTransfer"'
          }, {
            value: '"feComposite"'
          }, {
            value: '"feConvolveMatrix"'
          }, {
            value: '"feDiffuseLighting"'
          }, {
            value: '"feDisplacementMap"'
          }, {
            value: '"feDistantLight"'
          }, {
            value: '"feDropShadow"'
          }, {
            value: '"feFlood"'
          }, {
            value: '"feFuncA"'
          }, {
            value: '"feFuncB"'
          }, {
            value: '"feFuncG"'
          }, {
            value: '"feFuncR"'
          }, {
            value: '"feGaussianBlur"'
          }, {
            value: '"feImage"'
          }, {
            value: '"feMerge"'
          }, {
            value: '"feMergeNode"'
          }, {
            value: '"feMorphology"'
          }, {
            value: '"feOffset"'
          }, {
            value: '"fePointLight"'
          }, {
            value: '"feSpecularLighting"'
          }, {
            value: '"feSpotLight"'
          }, {
            value: '"feTile"'
          }, {
            value: '"feTurbulence"'
          }, {
            value: '"foreignObject"'
          }, {
            value: '"g"'
          }, {
            value: '"line"'
          }, {
            value: '"linearGradient"'
          }, {
            value: '"marker"'
          }, {
            value: '"metadata"'
          }, {
            value: '"mpath"'
          }, {
            value: '"polygon"'
          }, {
            value: '"polyline"'
          }, {
            value: '"radialGradient"'
          }, {
            value: '"rect"'
          }, {
            value: '"switch"'
          }, {
            value: '"textPath"'
          }, {
            value: '"tspan"'
          }, {
            value: '"use"'
          }, {
            value: '"view"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}