"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlexGroup = exports.DIRECTIONS = exports.JUSTIFY_CONTENTS = exports.ALIGN_ITEMS = exports.GUTTER_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var gutterSizeToClassNameMap = {
  none: null,
  xs: 'euiFlexGroup--gutterExtraSmall',
  s: 'euiFlexGroup--gutterSmall',
  m: 'euiFlexGroup--gutterMedium',
  l: 'euiFlexGroup--gutterLarge',
  xl: 'euiFlexGroup--gutterExtraLarge'
};
var GUTTER_SIZES = (0, _common.keysOf)(gutterSizeToClassNameMap);
exports.GUTTER_SIZES = GUTTER_SIZES;
var alignItemsToClassNameMap = {
  stretch: null,
  flexStart: 'euiFlexGroup--alignItemsFlexStart',
  flexEnd: 'euiFlexGroup--alignItemsFlexEnd',
  center: 'euiFlexGroup--alignItemsCenter',
  baseline: 'euiFlexGroup--alignItemsBaseline'
};
var ALIGN_ITEMS = (0, _common.keysOf)(alignItemsToClassNameMap);
exports.ALIGN_ITEMS = ALIGN_ITEMS;
var justifyContentToClassNameMap = {
  flexStart: null,
  flexEnd: 'euiFlexGroup--justifyContentFlexEnd',
  center: 'euiFlexGroup--justifyContentCenter',
  spaceBetween: 'euiFlexGroup--justifyContentSpaceBetween',
  spaceAround: 'euiFlexGroup--justifyContentSpaceAround',
  spaceEvenly: 'euiFlexGroup--justifyContentSpaceEvenly'
};
var JUSTIFY_CONTENTS = (0, _common.keysOf)(justifyContentToClassNameMap);
exports.JUSTIFY_CONTENTS = JUSTIFY_CONTENTS;
var directionToClassNameMap = {
  row: 'euiFlexGroup--directionRow',
  rowReverse: 'euiFlexGroup--directionRowReverse',
  column: 'euiFlexGroup--directionColumn',
  columnReverse: 'euiFlexGroup--directionColumnReverse'
};
var DIRECTIONS = (0, _common.keysOf)(directionToClassNameMap);
exports.DIRECTIONS = DIRECTIONS;

var isValidElement = function isValidElement(component) {
  return ['div', 'span'].includes(component);
};

var EuiFlexGroup = (0, _react.forwardRef)(function (_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$alignItems = _ref.alignItems,
      alignItems = _ref$alignItems === void 0 ? 'stretch' : _ref$alignItems,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? true : _ref$responsive,
      _ref$justifyContent = _ref.justifyContent,
      justifyContent = _ref$justifyContent === void 0 ? 'flexStart' : _ref$justifyContent,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'row' : _ref$direction,
      _ref$wrap = _ref.wrap,
      wrap = _ref$wrap === void 0 ? false : _ref$wrap,
      _ref$component = _ref.component,
      component = _ref$component === void 0 ? 'div' : _ref$component,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "gutterSize", "alignItems", "responsive", "justifyContent", "direction", "wrap", "component"]);
  var classes = (0, _classnames.default)('euiFlexGroup', gutterSizeToClassNameMap[gutterSize], alignItemsToClassNameMap[alignItems], justifyContentToClassNameMap[justifyContent], directionToClassNameMap[direction], {
    'euiFlexGroup--responsive': responsive,
    'euiFlexGroup--wrap': wrap
  }, className);

  if (!isValidElement(component)) {
    throw new Error("".concat(component, " is not a valid element type. Use `div` or `span`."));
  }

  return component === 'span' ? _react.default.createElement("span", (0, _extends2.default)({
    className: classes,
    ref: ref
  }, rest), children) : _react.default.createElement("div", (0, _extends2.default)({
    className: classes,
    ref: ref
  }, rest), children);
});
exports.EuiFlexGroup = EuiFlexGroup;
EuiFlexGroup.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  alignItems: _propTypes.default.oneOf(["stretch", "flexStart", "flexEnd", "center", "baseline"]),
  component: _propTypes.default.oneOf(["div", "span"]),
  direction: _propTypes.default.oneOf(["row", "rowReverse", "column", "columnReverse"]),
  gutterSize: _propTypes.default.oneOf(["none", "xs", "s", "m", "l", "xl"]),
  justifyContent: _propTypes.default.oneOf(["flexStart", "flexEnd", "center", "spaceBetween", "spaceAround", "spaceEvenly"]),
  responsive: _propTypes.default.bool,
  wrap: _propTypes.default.bool
};
EuiFlexGroup.displayName = 'EuiFlexGroup';

try {
  EuiFlexGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      alignItems: {
        defaultValue: null,
        description: '',
        name: 'alignItems',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"baseline" | "center" | "stretch" | "flexStart" | "flexEnd"',
          value: [{
            value: '"baseline"'
          }, {
            value: '"center"'
          }, {
            value: '"stretch"'
          }, {
            value: '"flexStart"'
          }, {
            value: '"flexEnd"'
          }]
        }
      },
      component: {
        defaultValue: null,
        description: '',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'FlexGroupComponentType',
          value: [{
            value: '"span"'
          }, {
            value: '"div"'
          }]
        }
      },
      direction: {
        defaultValue: null,
        description: '',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"column" | "row" | "rowReverse" | "columnReverse"',
          value: [{
            value: '"column"'
          }, {
            value: '"row"'
          }, {
            value: '"rowReverse"'
          }, {
            value: '"columnReverse"'
          }]
        }
      },
      gutterSize: {
        defaultValue: null,
        description: '',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "xs" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      justifyContent: {
        defaultValue: null,
        description: '',
        name: 'justifyContent',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"center" | "flexStart" | "flexEnd" | "spaceBetween" | "spaceAround" | "spaceEvenly"',
          value: [{
            value: '"center"'
          }, {
            value: '"flexStart"'
          }, {
            value: '"flexEnd"'
          }, {
            value: '"spaceBetween"'
          }, {
            value: '"spaceAround"'
          }, {
            value: '"spaceEvenly"'
          }]
        }
      },
      responsive: {
        defaultValue: null,
        description: '',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      wrap: {
        defaultValue: null,
        description: '',
        name: 'wrap',
        parent: {
          fileName: 'eui/src/components/flex/flex_group.tsx',
          name: 'EuiFlexGroupProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}