"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFocusTrap", {
  enumerable: true,
  get: function get() {
    return _focus_trap.EuiFocusTrap;
  }
});

var _focus_trap = require("./focus_trap");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiFocusTrap.__docgenInfo = {
    description: '',
    displayName: 'EuiFocusTrap',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      clickOutsideDisables: {
        defaultValue: null,
        description: 'Clicking outside the trap area will disable the trap',
        name: 'clickOutsideDisables',
        parent: {
          fileName: 'eui/src/components/focus_trap/focus_trap.tsx',
          name: 'EuiFocusTrapInterface'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      initialFocus: {
        defaultValue: null,
        description: 'Reference to element that will get focus when the trap is initiated',
        name: 'initialFocus',
        parent: {
          fileName: 'eui/src/components/focus_trap/focus_trap.tsx',
          name: 'EuiFocusTrapInterface'
        },
        required: false,
        type: {
          name: 'FocusTarget'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/focus_trap/focus_trap.tsx',
          name: 'EuiFocusTrapInterface'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}