"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCheckbox = exports.TYPES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../../common");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var typeToClassNameMap = {
  inList: 'euiCheckbox--inList'
};
var TYPES = (0, _common.keysOf)(typeToClassNameMap);
exports.TYPES = TYPES;

var EuiCheckbox =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiCheckbox, _Component);

  function EuiCheckbox() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiCheckbox);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiCheckbox)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "inputRef", undefined);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setInputRef", function (input) {
      _this.inputRef = input;

      if (_this.props.inputRef) {
        _this.props.inputRef(input);
      }

      _this.invalidateIndeterminate();
    });
    return _this;
  }

  (0, _createClass2.default)(EuiCheckbox, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.invalidateIndeterminate();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.invalidateIndeterminate();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          id = _this$props.id,
          checked = _this$props.checked,
          label = _this$props.label,
          onChange = _this$props.onChange,
          type = _this$props.type,
          disabled = _this$props.disabled,
          compressed = _this$props.compressed,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "id", "checked", "label", "onChange", "type", "disabled", "compressed"]);
      var indeterminate = rest.indeterminate,
          inputProps = (0, _objectWithoutProperties2.default)(rest, ["indeterminate"]); // `indeterminate` is set dynamically later

      var classes = (0, _classnames.default)('euiCheckbox', type && typeToClassNameMap[type], {
        'euiCheckbox--noLabel': !label,
        'euiCheckbox--compressed': compressed
      }, className);
      var optionalLabel;

      if (label) {
        optionalLabel = _react.default.createElement("label", {
          className: "euiCheckbox__label",
          htmlFor: id
        }, label);
      }

      return _react.default.createElement("div", {
        className: classes
      }, _react.default.createElement("input", (0, _extends2.default)({
        className: "euiCheckbox__input",
        type: "checkbox",
        id: id,
        checked: checked,
        onChange: onChange,
        disabled: disabled,
        ref: this.setInputRef
      }, inputProps)), _react.default.createElement("div", {
        className: "euiCheckbox__square"
      }), optionalLabel);
    }
  }, {
    key: "invalidateIndeterminate",
    value: function invalidateIndeterminate() {
      if (this.inputRef) {
        this.inputRef.indeterminate = this.props.indeterminate;
      }
    }
  }]);
  return EuiCheckbox;
}(_react.Component);

exports.EuiCheckbox = EuiCheckbox;
(0, _defineProperty2.default)(EuiCheckbox, "defaultProps", {
  checked: false,
  disabled: false,
  indeterminate: false,
  compressed: false
});
EuiCheckbox.propTypes = {
  id: _propTypes.default.string.isRequired,
  checked: _propTypes.default.bool,
  onChange: _propTypes.default.any.isRequired,
  // overriding to make it required
  inputRef: _propTypes.default.func,
  label: _propTypes.default.node,
  type: _propTypes.default.oneOf(["inList"]),
  disabled: _propTypes.default.bool,

  /**
     * when `true` creates a shorter height checkbox row
     */
  compressed: _propTypes.default.bool,
  indeterminate: _propTypes.default.bool,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiCheckbox.__docgenInfo = {
    description: '',
    displayName: 'EuiCheckbox',
    methods: [],
    props: {
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      checked: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'checked',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: true,
        type: {
          name: '(event: ChangeEvent<HTMLInputElement>) => void'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: '(element: HTMLInputElement) => void'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: '"inList"'
        }
      },
      disabled: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: {
          value: 'false'
        },
        description: 'when `true` creates a shorter height checkbox row',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      indeterminate: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'indeterminate',
        parent: {
          fileName: 'eui/src/components/form/checkbox/checkbox.tsx',
          name: 'EuiCheckboxProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}