"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFilePicker", {
  enumerable: true,
  get: function get() {
    return _file_picker.EuiFilePicker;
  }
});

var _file_picker = require("./file_picker");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiFilePicker.__docgenInfo = {
    description: '',
    displayName: 'EuiFilePicker',
    methods: [],
    props: {
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      initialPromptText: {
        defaultValue: null,
        description: 'The content that appears in the dropzone if no file is attached',
        name: 'initialPromptText',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Use as a callback to access the HTML FileList API',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: '(files: FileList) => void'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'Reduces the size to a typical (compressed) input',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      display: {
        defaultValue: null,
        description: 'Size or type of display;\n`default` for normal height, similar to other controls;\n`large` for taller size',
        name: 'display',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "large"',
          value: [{
            value: '"default"'
          }, {
            value: '"large"'
          }]
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/form/file_picker/file_picker.tsx',
          name: 'EuiFilePickerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}