"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiFormControlLayout", {
  enumerable: true,
  get: function get() {
    return _form_control_layout.EuiFormControlLayout;
  }
});
Object.defineProperty(exports, "EuiFormControlLayoutDelimited", {
  enumerable: true,
  get: function get() {
    return _form_control_layout_delimited.EuiFormControlLayoutDelimited;
  }
});

var _form_control_layout = require("./form_control_layout");

var _form_control_layout_delimited = require("./form_control_layout_delimited");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiFormControlLayout.__docgenInfo = {
    description: '',
    displayName: 'EuiFormControlLayout',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before children.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after children.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ComponentClass<{}, any> | FunctionComponent<{}> | (Pick<CommonProps & DisambiguateSet<Pick<ButtonHTMLAttributes<HTMLButtonElement>, "children" | ... 262 more ... | "value">, HTMLAttributes<...>> & HTMLAttributes<...> & { ...; }, "children" | ... 263 more ... | "value"> & { ...; }) | (Pick<...> & { ...; })'
        }
      },
      clear: {
        defaultValue: null,
        description: '',
        name: 'clear',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiFormControlLayoutClearButtonProps'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputId: {
        defaultValue: null,
        description: 'Connects the prepend and append labels to the input',
        name: 'inputId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFormControlLayoutDelimited.__docgenInfo = {
    description: '',
    displayName: 'EuiFormControlLayoutDelimited',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before children.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after children.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ComponentClass<{}, any> | FunctionComponent<{}> | (Pick<CommonProps & DisambiguateSet<Pick<ButtonHTMLAttributes<HTMLButtonElement>, "children" | ... 262 more ... | "value">, HTMLAttributes<...>> & HTMLAttributes<...> & { ...; }, "children" | ... 263 more ... | "value"> & { ...; }) | (Pick<...> & { ...; })'
        }
      },
      clear: {
        defaultValue: null,
        description: '',
        name: 'clear',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiFormControlLayoutClearButtonProps'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputId: {
        defaultValue: null,
        description: 'Connects the prepend and append labels to the input',
        name: 'inputId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      startControl: {
        defaultValue: null,
        description: 'Left side control',
        name: 'startControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      endControl: {
        defaultValue: null,
        description: 'Right side control',
        name: 'endControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      delimiter: {
        defaultValue: null,
        description: 'The center content. Accepts a string to be wrapped in a subdued EuiText\nor a single ReactElement',
        name: 'delimiter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}