"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiDualRange", {
  enumerable: true,
  get: function get() {
    return _dual_range.EuiDualRange;
  }
});
Object.defineProperty(exports, "EuiRange", {
  enumerable: true,
  get: function get() {
    return _range.EuiRange;
  }
});

var _dual_range = require("./dual_range");

var _range = require("./range");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiDualRange.__docgenInfo = {
    description: '',
    displayName: 'EuiDualRange',
    methods: [],
    props: {
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: true,
        type: {
          name: '[ReactText, ReactText]'
        }
      },
      onBlur: {
        defaultValue: null,
        description: '',
        name: 'onBlur',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: '(event: any) => void'
        }
      },
      onFocus: {
        defaultValue: null,
        description: '',
        name: 'onFocus',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: '(event: any) => void'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: true,
        type: {
          name: '(values: [ReactText, ReactText], isValid: boolean, event: any) => void'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      levels: {
        defaultValue: null,
        description: 'Create colored indicators for certain intervals',
        name: 'levels',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'EuiRangeLevel[]'
        }
      },
      showLabels: {
        defaultValue: null,
        description: 'Shows static min/max labels on the sides of the range slider',
        name: 'showLabels',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showInput: {
        defaultValue: null,
        description: 'Pass `true` to displays an extra input control for direct manipulation.\nPass `\'inputWithPopover\'` to only show the input but show the range in a dropdown.',
        name: 'showInput',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'boolean | "inputWithPopover"'
        }
      },
      tickInterval: {
        defaultValue: null,
        description: 'Modifies the number of tick marks and at what interval',
        name: 'tickInterval',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      ticks: {
        defaultValue: null,
        description: 'Specified ticks at specified values',
        name: 'ticks',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'EuiRangeTick[]'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input.  Will only show if `showInput = inputWithPopver`.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input. Will only show if `showInput = inputWithPopver`.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      minInputProps: {
        defaultValue: null,
        description: 'Intended to be uses with aria attributes. Some attributes may be overwritten.',
        name: 'minInputProps',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'Partial<EuiRangeInputProps>'
        }
      },
      maxInputProps: {
        defaultValue: null,
        description: 'Intended to be uses with aria attributes. Some attributes may be overwritten.',
        name: 'maxInputProps',
        parent: {
          fileName: 'eui/src/components/form/range/dual_range.tsx',
          name: 'EuiDualRangeProps'
        },
        required: false,
        type: {
          name: 'Partial<EuiRangeInputProps>'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasFocus: {
        defaultValue: null,
        description: '',
        name: 'hasFocus',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showRange: {
        defaultValue: null,
        description: '',
        name: 'showRange',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTicks: {
        defaultValue: null,
        description: '',
        name: 'showTicks',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiRange.__docgenInfo = {
    description: '',
    displayName: 'EuiRange',
    methods: [],
    props: {
      compressed: {
        defaultValue: null,
        description: 'when `true` creates a shorter height input',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      levels: {
        defaultValue: null,
        description: 'Create colored indicators for certain intervals',
        name: 'levels',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'EuiRangeLevel[]'
        }
      },
      step: {
        defaultValue: null,
        description: 'Specifies the granularity that the value must adhere to.\nAccepts a `number` or the string `\'any\'` for no stepping to allow for any value.\nDefaults to `1`',
        name: 'step',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      showInput: {
        defaultValue: null,
        description: 'Pass `true` to displays an extra input control for direct manipulation.\nPass `\'inputWithPopover\'` to only show the input but show the range in a dropdown.',
        name: 'showInput',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean | "inputWithPopover"'
        }
      },
      showLabels: {
        defaultValue: null,
        description: 'Shows static min/max labels on the sides of the range slider',
        name: 'showLabels',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showRange: {
        defaultValue: null,
        description: 'Shows a thick line from min to value',
        name: 'showRange',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTicks: {
        defaultValue: null,
        description: 'Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)',
        name: 'showTicks',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showValue: {
        defaultValue: null,
        description: 'Shows a tooltip styled value',
        name: 'showValue',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ticks: {
        defaultValue: null,
        description: 'Specified ticks at specified values',
        name: 'ticks',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'EuiRangeTick[]'
        }
      },
      tickInterval: {
        defaultValue: null,
        description: 'Modifies the number of tick marks and at what interval',
        name: 'tickInterval',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      valueAppend: {
        defaultValue: null,
        description: 'Appends to the tooltip',
        name: 'valueAppend',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      valuePrepend: {
        defaultValue: null,
        description: 'Prepends to the tooltip',
        name: 'valuePrepend',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: '(event: any, isValid: boolean) => void'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: true,
        type: {
          name: 'string | number'
        }
      },
      max: {
        defaultValue: null,
        description: '',
        name: 'max',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      min: {
        defaultValue: null,
        description: '',
        name: 'min',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: undefined,
        required: false,
        type: {
          name: 'Ref<HTMLInputElement>'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      controlOnly: {
        defaultValue: null,
        description: 'Completely removes form control layout wrapper and ignores\nicon, prepend, and append. Best used inside EuiFormControlLayoutDelimited.',
        name: 'controlOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      autoSize: {
        defaultValue: null,
        description: '',
        name: 'autoSize',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      side: {
        defaultValue: null,
        description: '',
        name: 'side',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"max" | "min"',
          value: [{
            value: '"max"'
          }, {
            value: '"min"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}