"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRange = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _number = require("../../../services/number");

var _popover = require("../../popover");

var _accessibility = require("../../../services/accessibility");

var _range_highlight = require("./range_highlight");

var _range_input = require("./range_input");

var _range_label = require("./range_label");

var _range_slider = require("./range_slider");

var _range_tooltip = require("./range_tooltip");

var _range_track = require("./range_track");

var _range_wrapper = require("./range_wrapper");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiRange =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiRange, _Component);

  function EuiRange() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiRange);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiRange)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "preventPopoverClose", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      id: _this.props.id || (0, _accessibility.htmlIdGenerator)()(),
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnChange", function (e) {
      var isValid = (0, _number.isWithinRange)(_this.props.min, _this.props.max, e.currentTarget.value);

      if (_this.props.onChange) {
        _this.props.onChange(e, isValid);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onInputFocus", function (e) {
      if (_this.props.onFocus) {
        _this.props.onFocus(e);
      }

      _this.setState({
        isPopoverOpen: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onInputBlur", function (e) {
      return setTimeout(function () {
        // Safari does not recognize any focus-related eventing for input[type=range]
        // making it impossible to capture its state using active/focus/relatedTarget
        // Instead, a prevention flag is set on mousedown, with a waiting period here.
        // Mousedown is viable because in the popover case, it is inaccessable via keyboard (intentionally)
        if (_this.preventPopoverClose) {
          _this.preventPopoverClose = false;
          return;
        }

        if (_this.props.onBlur) {
          _this.props.onBlur(e);
        }

        _this.closePopover();
      }, 200);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closePopover", function () {
      _this.preventPopoverClose = false;

      _this.setState({
        isPopoverOpen: false
      });
    });
    return _this;
  }

  (0, _createClass2.default)(EuiRange, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          compressed = _this$props.compressed,
          disabled = _this$props.disabled,
          fullWidth = _this$props.fullWidth,
          isLoading = _this$props.isLoading,
          readOnly = _this$props.readOnly,
          propsId = _this$props.id,
          max = _this$props.max,
          min = _this$props.min,
          name = _this$props.name,
          step = _this$props.step,
          showLabels = _this$props.showLabels,
          showInput = _this$props.showInput,
          showTicks = _this$props.showTicks,
          tickInterval = _this$props.tickInterval,
          ticks = _this$props.ticks,
          levels = _this$props.levels,
          showRange = _this$props.showRange,
          showValue = _this$props.showValue,
          valueAppend = _this$props.valueAppend,
          valuePrepend = _this$props.valuePrepend,
          onBlur = _this$props.onBlur,
          onChange = _this$props.onChange,
          onFocus = _this$props.onFocus,
          value = _this$props.value,
          style = _this$props.style,
          tabIndex = _this$props.tabIndex,
          isInvalid = _this$props.isInvalid,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "compressed", "disabled", "fullWidth", "isLoading", "readOnly", "id", "max", "min", "name", "step", "showLabels", "showInput", "showTicks", "tickInterval", "ticks", "levels", "showRange", "showValue", "valueAppend", "valuePrepend", "onBlur", "onChange", "onFocus", "value", "style", "tabIndex", "isInvalid"]);
      var id = this.state.id;
      var digitTolerance = Math.max(String(min).length, String(max).length);
      var showInputOnly = showInput === 'inputWithPopover';
      var canShowDropdown = showInputOnly && !readOnly && !disabled;
      var theInput = !!showInput ? _react.default.createElement(_range_input.EuiRangeInput, (0, _extends2.default)({
        id: id,
        min: min,
        max: max,
        digitTolerance: digitTolerance,
        step: step,
        value: value,
        readOnly: readOnly,
        disabled: disabled,
        compressed: compressed,
        onChange: this.handleOnChange,
        name: name,
        onFocus: canShowDropdown ? this.onInputFocus : onFocus,
        onBlur: canShowDropdown ? this.onInputBlur : onBlur,
        fullWidth: showInputOnly && fullWidth,
        isLoading: showInputOnly && isLoading,
        isInvalid: isInvalid,
        autoSize: !showInputOnly
      }, rest)) : null;
      var classes = (0, _classnames.default)('euiRange', className);

      var theRange = _react.default.createElement(_range_wrapper.EuiRangeWrapper, {
        className: classes,
        fullWidth: fullWidth,
        compressed: compressed
      }, showLabels && _react.default.createElement(_range_label.EuiRangeLabel, {
        side: "min",
        disabled: disabled
      }, min), _react.default.createElement(_range_track.EuiRangeTrack, {
        disabled: disabled,
        compressed: compressed,
        max: max,
        min: min,
        step: step,
        showTicks: showTicks,
        tickInterval: tickInterval,
        ticks: ticks,
        levels: levels,
        onChange: this.handleOnChange,
        value: value,
        "aria-hidden": showInput === true
      }, showRange && this.isValid && _react.default.createElement(_range_highlight.EuiRangeHighlight, {
        compressed: compressed,
        showTicks: showTicks,
        min: Number(min),
        max: Number(max),
        lowerValue: Number(min),
        upperValue: Number(value)
      }), _react.default.createElement(_range_slider.EuiRangeSlider, (0, _extends2.default)({
        id: showInput ? undefined : id // Attach id only to the input if there is one
        ,
        name: name,
        min: min,
        max: max,
        step: step,
        value: value,
        disabled: disabled,
        compressed: compressed,
        onChange: this.handleOnChange,
        style: style,
        showTicks: showTicks,
        showRange: showRange,
        tabIndex: showInput ? -1 : tabIndex,
        onMouseDown: showInputOnly ? function () {
          return _this2.preventPopoverClose = true;
        } : undefined,
        onFocus: showInput === true ? undefined : onFocus,
        onBlur: showInputOnly ? this.onInputBlur : onBlur,
        "aria-hidden": showInput === true ? true : false
      }, rest)), showValue && !!String(value).length && _react.default.createElement(_range_tooltip.EuiRangeTooltip, {
        compressed: compressed,
        value: value,
        max: max,
        min: min,
        name: name,
        showTicks: showTicks,
        valuePrepend: valuePrepend,
        valueAppend: valueAppend
      })), showLabels && _react.default.createElement(_range_label.EuiRangeLabel, {
        side: "max",
        disabled: disabled
      }, max), !showInputOnly && _react.default.createElement(_react.default.Fragment, null, _react.default.createElement("div", {
        className: "euiRange__horizontalSpacer"
      }), theInput));

      var thePopover = showInputOnly ? _react.default.createElement(_popover.EuiInputPopover, {
        className: "euiRange__popover",
        input: theInput // `showInputOnly` confirms existence
        ,
        fullWidth: fullWidth,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        disableFocusTrap: true
      }, theRange) : undefined;
      return thePopover ? thePopover : theRange;
    }
  }, {
    key: "isValid",
    get: function get() {
      return (0, _number.isWithinRange)(this.props.min, this.props.max, this.props.value || '');
    }
  }]);
  return EuiRange;
}(_react.Component);

exports.EuiRange = EuiRange;
(0, _defineProperty2.default)(EuiRange, "defaultProps", {
  min: 0,
  max: 100,
  step: 1,
  fullWidth: false,
  compressed: false,
  isLoading: false,
  showLabels: false,
  showInput: false,
  showRange: false,
  showTicks: false,
  showValue: false,
  levels: []
});
EuiRange.propTypes = {
  compressed: _propTypes.default.bool,
  readOnly: _propTypes.default.bool,
  fullWidth: _propTypes.default.bool,
  id: _propTypes.default.string,

  /**
     * Create colored indicators for certain intervals
     */
  levels: _propTypes.default.arrayOf(_propTypes.default.shape({
    min: _propTypes.default.number.isRequired,
    max: _propTypes.default.number.isRequired,
    color: _propTypes.default.oneOf(["primary", "success", "warning", "danger"]).isRequired
  }).isRequired),
  step: _propTypes.default.number,

  /**
     * Pass `true` to displays an extra input control for direct manipulation.
     * Pass `'inputWithPopover'` to only show the input but show the range in a dropdown.
     */
  showInput: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.oneOf(["inputWithPopover"])]),

  /**
     * Shows static min/max labels on the sides of the range slider
     */
  showLabels: _propTypes.default.bool,

  /**
     * Shows a thick line from min to value
     */
  showRange: _propTypes.default.bool,

  /**
     * Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)
     */
  showTicks: _propTypes.default.bool,

  /**
     * Shows a tooltip styled value
     */
  showValue: _propTypes.default.bool,

  /**
     * Specified ticks at specified values
     */
  ticks: _propTypes.default.arrayOf(_propTypes.default.shape({
    value: _propTypes.default.number.isRequired,
    label: _propTypes.default.node.isRequired
  }).isRequired),

  /**
     * Modifies the number of tick marks and at what interval
     */
  tickInterval: _propTypes.default.number,

  /**
     * Appends to the tooltip
     */
  valueAppend: _propTypes.default.node,

  /**
     * Prepends to the tooltip
     */
  valuePrepend: _propTypes.default.node,
  onChange: _propTypes.default.func,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiRange.__docgenInfo = {
    description: '',
    displayName: 'EuiRange',
    methods: [],
    props: {
      compressed: {
        defaultValue: {
          value: 'false'
        },
        description: 'when `true` creates a shorter height input',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      levels: {
        defaultValue: {
          value: '[]'
        },
        description: 'Create colored indicators for certain intervals',
        name: 'levels',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'EuiRangeLevel[]'
        }
      },
      step: {
        defaultValue: {
          value: '1'
        },
        description: 'Specifies the granularity that the value must adhere to.\nAccepts a `number` or the string `\'any\'` for no stepping to allow for any value.\nDefaults to `1`',
        name: 'step',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      showInput: {
        defaultValue: {
          value: 'false'
        },
        description: 'Pass `true` to displays an extra input control for direct manipulation.\nPass `\'inputWithPopover\'` to only show the input but show the range in a dropdown.',
        name: 'showInput',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean | "inputWithPopover"'
        }
      },
      showLabels: {
        defaultValue: {
          value: 'false'
        },
        description: 'Shows static min/max labels on the sides of the range slider',
        name: 'showLabels',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showRange: {
        defaultValue: {
          value: 'false'
        },
        description: 'Shows a thick line from min to value',
        name: 'showRange',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTicks: {
        defaultValue: {
          value: 'false'
        },
        description: 'Shows clickable tick marks and labels at the given interval (`step`/`tickInterval`)',
        name: 'showTicks',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showValue: {
        defaultValue: {
          value: 'false'
        },
        description: 'Shows a tooltip styled value',
        name: 'showValue',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ticks: {
        defaultValue: null,
        description: 'Specified ticks at specified values',
        name: 'ticks',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'EuiRangeTick[]'
        }
      },
      tickInterval: {
        defaultValue: null,
        description: 'Modifies the number of tick marks and at what interval',
        name: 'tickInterval',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      valueAppend: {
        defaultValue: null,
        description: 'Appends to the tooltip',
        name: 'valueAppend',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      valuePrepend: {
        defaultValue: null,
        description: 'Prepends to the tooltip',
        name: 'valuePrepend',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/range/range.tsx',
          name: 'EuiRangeProps'
        },
        required: false,
        type: {
          name: '(event: any, isValid: boolean) => void'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isLoading: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: true,
        type: {
          name: 'string | number'
        }
      },
      max: {
        defaultValue: {
          value: '100'
        },
        description: '',
        name: 'max',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      min: {
        defaultValue: {
          value: '0'
        },
        description: '',
        name: 'min',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: undefined,
        required: false,
        type: {
          name: 'Ref<HTMLInputElement>'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      controlOnly: {
        defaultValue: null,
        description: 'Completely removes form control layout wrapper and ignores\nicon, prepend, and append. Best used inside EuiFormControlLayoutDelimited.',
        name: 'controlOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      autoSize: {
        defaultValue: null,
        description: '',
        name: 'autoSize',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      side: {
        defaultValue: null,
        description: '',
        name: 'side',
        parent: {
          fileName: 'eui/src/components/form/range/range_input.tsx',
          name: 'EuiRangeInputProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"max" | "min"',
          value: [{
            value: '"max"'
          }, {
            value: '"min"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}