"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiValidatableControl = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("react");

var _propTypes = _interopRequireDefault(require("prop-types"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function isMutableRef(ref) {
  return ref != null && ref.hasOwnProperty('current');
}

var EuiValidatableControl =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiValidatableControl, _Component);

  function EuiValidatableControl() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiValidatableControl);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiValidatableControl)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "control", void 0);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setRef", function (element) {
      _this.control = element; // Call the original ref, if any

      var ref = _this.props.children.ref;

      if (typeof ref === 'function') {
        ref(element);
      } else if (isMutableRef(ref)) {
        ref.current = element;
      }
    });
    return _this;
  }

  (0, _createClass2.default)(EuiValidatableControl, [{
    key: "updateValidity",
    value: function updateValidity() {
      if (this.control == null || typeof this.control.setCustomValidity !== 'function') {
        return; // jsdom doesn't polyfill this for the server-side
      }

      if (this.props.isInvalid) {
        this.control.setCustomValidity('Invalid');
      } else {
        this.control.setCustomValidity('');
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.updateValidity();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.updateValidity();
    }
  }, {
    key: "render",
    value: function render() {
      var child = _react.Children.only(this.props.children);

      return (0, _react.cloneElement)(child, {
        ref: this.setRef
      });
    }
  }]);
  return EuiValidatableControl;
}(_react.Component);

exports.EuiValidatableControl = EuiValidatableControl;
EuiValidatableControl.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  isInvalid: _propTypes.default.bool,

  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.shape({
    ref: _propTypes.default.any
  }).isRequired
};

try {
  EuiValidatableControl.__docgenInfo = {
    description: '',
    displayName: 'EuiValidatableControl',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/validatable_control/validatable_control.tsx',
          name: 'EuiValidatableControlProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/form/validatable_control/validatable_control.tsx',
          name: 'EuiValidatableControlProps'
        },
        required: true,
        type: {
          name: 'ReactElementWithRef'
        }
      }
    },
    extends: []
  };
} catch (e) {}