"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHeaderSectionItem = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var borderToClassNameMap = {
  left: 'euiHeaderSectionItem--borderLeft',
  right: 'euiHeaderSectionItem--borderRight',
  none: undefined
};

var EuiHeaderSectionItem = function EuiHeaderSectionItem(_ref) {
  var _ref$border = _ref.border,
      border = _ref$border === void 0 ? 'left' : _ref$border,
      children = _ref.children,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["border", "children", "className"]);
  var classes = (0, _classnames.default)('euiHeaderSectionItem', borderToClassNameMap[border], className);
  return _react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), children);
};

exports.EuiHeaderSectionItem = EuiHeaderSectionItem;
EuiHeaderSectionItem.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Side to display a short border on.
     * Not supported in Amsterdam theme.
     */
  border: _propTypes.default.oneOf(["left", "right", "none"]),

  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node
};

try {
  EuiHeaderSectionItem.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderSectionItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      border: {
        defaultValue: {
          value: 'left'
        },
        description: 'Side to display a short border on.\nNot supported in Amsterdam theme.',
        name: 'border',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "right" | "none"',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"none"'
          }]
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: []
  };
} catch (e) {}