"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiHeader", {
  enumerable: true,
  get: function get() {
    return _header.EuiHeader;
  }
});
Object.defineProperty(exports, "EuiHeaderAlert", {
  enumerable: true,
  get: function get() {
    return _header_alert.EuiHeaderAlert;
  }
});
Object.defineProperty(exports, "EuiHeaderBreadcrumbs", {
  enumerable: true,
  get: function get() {
    return _header_breadcrumbs.EuiHeaderBreadcrumbs;
  }
});
Object.defineProperty(exports, "EuiHeaderLink", {
  enumerable: true,
  get: function get() {
    return _header_links.EuiHeaderLink;
  }
});
Object.defineProperty(exports, "EuiHeaderLinks", {
  enumerable: true,
  get: function get() {
    return _header_links.EuiHeaderLinks;
  }
});
Object.defineProperty(exports, "EuiHeaderLogo", {
  enumerable: true,
  get: function get() {
    return _header_logo.EuiHeaderLogo;
  }
});
Object.defineProperty(exports, "EuiHeaderSection", {
  enumerable: true,
  get: function get() {
    return _header_section.EuiHeaderSection;
  }
});
Object.defineProperty(exports, "EuiHeaderSectionItem", {
  enumerable: true,
  get: function get() {
    return _header_section.EuiHeaderSectionItem;
  }
});
Object.defineProperty(exports, "EuiHeaderSectionItemButton", {
  enumerable: true,
  get: function get() {
    return _header_section.EuiHeaderSectionItemButton;
  }
});

var _header = require("./header");

var _header_alert = require("./header_alert");

var _header_breadcrumbs = require("./header_breadcrumbs");

var _header_links = require("./header_links");

var _header_logo = require("./header_logo");

var _header_section = require("./header_section");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiHeader.__docgenInfo = {
    description: '',
    displayName: 'EuiHeader',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      sections: {
        defaultValue: null,
        description: 'An array of objects to wrap in a #EuiHeaderSection.\nEach section is spaced using `space-between`.\nSee #EuiHeaderSectionsProp for object details.\nThis prop disregards the prop `children` if both are passed.',
        name: 'sections',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiHeaderSections[]'
        }
      },
      position: {
        defaultValue: null,
        description: 'Helper that positions the header against the window body and\nadds the correct amount of top padding to the window when in `fixed` mode',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"static" | "fixed"',
          value: [{
            value: '"static"'
          }, {
            value: '"fixed"'
          }]
        }
      },
      theme: {
        defaultValue: null,
        description: 'The `default` will inherit its coloring from the light or dark theme.\nOr, force the header into pseudo `dark` theme for all themes.',
        name: 'theme',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "dark"',
          value: [{
            value: '"default"'
          }, {
            value: '"dark"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderAlert.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderAlert',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      action: {
        defaultValue: null,
        description: 'Adds a link to the alert.',
        name: 'action',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      date: {
        defaultValue: null,
        description: '',
        name: 'date',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      text: {
        defaultValue: null,
        description: '',
        name: 'text',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      badge: {
        defaultValue: null,
        description: 'Accepts an `EuiBadge` that displays on the alert',
        name: 'badge',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderBreadcrumbs.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderBreadcrumbs',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      responsive: {
        defaultValue: null,
        description: 'Hides extra (above the max) breadcrumbs under a collapsed item as the window gets smaller.\nPass a custom #EuiBreadcrumbResponsiveMaxCount object to change the number of breadcrumbs to show at the particular breakpoints.\nOmitting or passing a `0` value will show all breadcrumbs.\n\nPass `false` to turn this behavior off.\n\nDefault: `{ xs: 1, s: 2, m: 4 }`',
        name: 'responsive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | EuiBreadcrumbResponsiveMaxCount'
        }
      },
      truncate: {
        defaultValue: null,
        description: 'Forces all breadcrumbs to single line and\ntruncates each breadcrumb to a particular width,\nexcept for the last item',
        name: 'truncate',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      max: {
        defaultValue: null,
        description: 'Collapses the inner items past the maximum set here\ninto a single ellipses item',
        name: 'max',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      breadcrumbs: {
        defaultValue: null,
        description: 'The array of individual #EuiBreadcrumb items',
        name: 'breadcrumbs',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiBreadcrumb[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderLink.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderLink',
    methods: [],
    props: {
      color: {
        defaultValue: null,
        description: 'Any of our named colors',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiButtonEmptyColor',
          value: [{
            value: '"disabled"'
          }, {
            value: '"primary"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "xs" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      flush: {
        defaultValue: null,
        description: 'Ensure the text of the button sits flush to the left or right side of its container',
        name: 'flush',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '`disabled` is also allowed',
        name: 'isDisabled',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Force disables the button and changes the icon to a loading spinner',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"submit" | "button"',
          value: [{
            value: '"submit"'
          }, {
            value: '"button"'
          }]
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: '(ref: HTMLAnchorElement | HTMLButtonElement) => void'
        }
      },
      contentProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the button\'s content',
        name: 'contentProps',
        parent: {
          fileName: 'eui/src/components/button/button_empty/button_empty.tsx',
          name: 'CommonEuiButtonEmptyProps'
        },
        required: false,
        type: {
          name: 'EuiButtonContentType'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconSide: {
        defaultValue: null,
        description: '',
        name: 'iconSide',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      textProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the content\'s text/children only (not icon)',
        name: 'textProps',
        parent: {
          fileName: 'eui/src/components/button/button_content.tsx',
          name: 'EuiButtonContentProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement> & CommonProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      isActive: {
        defaultValue: null,
        description: '',
        name: 'isActive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderLinks.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderLinks',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderLogo.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderLogo',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      iconTitle: {
        defaultValue: null,
        description: '',
        name: 'iconTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderSection.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderSection',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      side: {
        defaultValue: null,
        description: '',
        name: 'side',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: '',
        name: 'grow',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderSectionItem.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderSectionItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      border: {
        defaultValue: null,
        description: 'Side to display a short border on.\nNot supported in Amsterdam theme.',
        name: 'border',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "right" | "none"',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"none"'
          }]
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}