"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHorizontalRule = exports.MARGINS = exports.SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  full: 'euiHorizontalRule--full',
  half: 'euiHorizontalRule--half',
  quarter: 'euiHorizontalRule--quarter'
};
var SIZES = Object.keys(sizeToClassNameMap);
exports.SIZES = SIZES;
var marginToClassNameMap = {
  none: null,
  xs: 'euiHorizontalRule--marginXSmall',
  s: 'euiHorizontalRule--marginSmall',
  m: 'euiHorizontalRule--marginMedium',
  l: 'euiHorizontalRule--marginLarge',
  xl: 'euiHorizontalRule--marginXLarge',
  xxl: 'euiHorizontalRule--marginXXLarge'
};
var MARGINS = Object.keys(marginToClassNameMap);
exports.MARGINS = MARGINS;

var EuiHorizontalRule = function EuiHorizontalRule(_ref) {
  var className = _ref.className,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'full' : _ref$size,
      _ref$margin = _ref.margin,
      margin = _ref$margin === void 0 ? 'l' : _ref$margin,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "size", "margin"]);
  var classes = (0, _classnames.default)('euiHorizontalRule', sizeToClassNameMap[size], marginToClassNameMap[margin], className);
  return _react.default.createElement("hr", (0, _extends2.default)({
    className: classes
  }, rest));
};

exports.EuiHorizontalRule = EuiHorizontalRule;
EuiHorizontalRule.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Defines the width of the HR.
     */
  size: _propTypes.default.oneOf(["full", "half", "quarter"]),
  margin: _propTypes.default.oneOf(["none", "xs", "s", "m", "l", "xl", "xxl"])
};

try {
  EuiHorizontalRule.__docgenInfo = {
    description: '',
    displayName: 'EuiHorizontalRule',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: {
          value: 'full'
        },
        description: 'Defines the width of the HR.',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/horizontal_rule/horizontal_rule.tsx',
          name: 'EuiHorizontalRuleProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"full" | "half" | "quarter"',
          value: [{
            value: '"full"'
          }, {
            value: '"half"'
          }, {
            value: '"quarter"'
          }]
        }
      },
      margin: {
        defaultValue: {
          value: 'l'
        },
        description: '',
        name: 'margin',
        parent: {
          fileName: 'eui/src/components/horizontal_rule/horizontal_rule.tsx',
          name: 'EuiHorizontalRuleProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "xs" | "l" | "xl" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"xxl"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}