"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMarkdownFormat = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _unified = _interopRequireDefault(require("unified"));

var _markdown_default_plugins = require("./plugins/markdown_default_plugins");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiMarkdownFormat = function EuiMarkdownFormat(_ref) {
  var children = _ref.children,
      _ref$parsingPluginLis = _ref.parsingPluginList,
      parsingPluginList = _ref$parsingPluginLis === void 0 ? _markdown_default_plugins.defaultParsingPlugins : _ref$parsingPluginLis,
      _ref$processingPlugin = _ref.processingPluginList,
      processingPluginList = _ref$processingPlugin === void 0 ? _markdown_default_plugins.defaultProcessingPlugins : _ref$processingPlugin;
  var processor = (0, _react.useMemo)(function () {
    return (0, _unified.default)().use(parsingPluginList).use(processingPluginList);
  }, [parsingPluginList, processingPluginList]);
  var result = (0, _react.useMemo)(function () {
    try {
      return processor.processSync(children).contents;
    } catch (e) {
      return children;
    }
  }, [children, processor]);
  return _react.default.createElement("div", {
    className: "euiMarkdownFormat"
  }, result);
};

exports.EuiMarkdownFormat = EuiMarkdownFormat;
EuiMarkdownFormat.propTypes = {
  children: _propTypes.default.string.isRequired,

  /** array of unified plugins to parse content into an AST */
  parsingPluginList: _propTypes.default.any,

  /** array of unified plugins to convert the AST into a ReactNode */
  processingPluginList: _propTypes.default.any
};

try {
  EuiMarkdownFormat.__docgenInfo = {
    description: '',
    displayName: 'EuiMarkdownFormat',
    methods: [],
    props: {
      parsingPluginList: {
        defaultValue: {
          value: null
        },
        description: 'array of unified plugins to parse content into an AST',
        name: 'parsingPluginList',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_format.tsx',
          name: 'EuiMarkdownFormatProps'
        },
        required: false,
        type: {
          name: 'PluggableList<Settings>'
        }
      },
      processingPluginList: {
        defaultValue: {
          value: null
        },
        description: 'array of unified plugins to convert the AST into a ReactNode',
        name: 'processingPluginList',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_format.tsx',
          name: 'EuiMarkdownFormatProps'
        },
        required: false,
        type: {
          name: 'PluggableList<Settings>'
        }
      }
    },
    extends: []
  };
} catch (e) {}