"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiConfirmModal = exports.CANCEL_BUTTON = exports.CONFIRM_BUTTON = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _modal = require("./modal");

var _modal_footer = require("./modal_footer");

var _modal_header = require("./modal_header");

var _modal_header_title = require("./modal_header_title");

var _modal_body = require("./modal_body");

var _button = require("../button");

var _text = require("../text");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var CONFIRM_BUTTON = 'confirm';
exports.CONFIRM_BUTTON = CONFIRM_BUTTON;
var CANCEL_BUTTON = 'cancel';
exports.CANCEL_BUTTON = CANCEL_BUTTON;

var EuiConfirmModal = function EuiConfirmModal(_ref) {
  var children = _ref.children,
      title = _ref.title,
      onCancel = _ref.onCancel,
      onConfirm = _ref.onConfirm,
      cancelButtonText = _ref.cancelButtonText,
      confirmButtonText = _ref.confirmButtonText,
      confirmButtonDisabled = _ref.confirmButtonDisabled,
      className = _ref.className,
      _ref$buttonColor = _ref.buttonColor,
      buttonColor = _ref$buttonColor === void 0 ? 'primary' : _ref$buttonColor,
      defaultFocusedButton = _ref.defaultFocusedButton,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "title", "onCancel", "onConfirm", "cancelButtonText", "confirmButtonText", "confirmButtonDisabled", "className", "buttonColor", "defaultFocusedButton"]);

  var _useState = (0, _react.useState)(null),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      cancelButton = _useState2[0],
      setCancelButton = _useState2[1];

  var _useState3 = (0, _react.useState)(null),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      confirmButton = _useState4[0],
      setConfirmButton = _useState4[1];

  (0, _react.useEffect)(function () {
    // We have to do this instead of using `autoFocus` because React's polyfill for auto-focusing
    // elements conflicts with the focus-trap logic we have on EuiModal.
    // Wait a beat for the focus-trap to complete, and then set focus to the right button. Check that
    // the buttons exist first, because it's possible the modal has been closed already.
    requestAnimationFrame(function () {
      if (defaultFocusedButton === CANCEL_BUTTON && cancelButton) {
        cancelButton.focus();
      } else if (defaultFocusedButton === CONFIRM_BUTTON && confirmButton) {
        confirmButton.focus();
      }
    });
  });

  var confirmRef = function confirmRef(node) {
    return setConfirmButton(node);
  };

  var cancelRef = function cancelRef(node) {
    return setCancelButton(node);
  };

  var classes = (0, _classnames.default)('euiModal--confirmation', className);
  var modalTitle;

  if (title) {
    modalTitle = _react.default.createElement(_modal_header.EuiModalHeader, null, _react.default.createElement(_modal_header_title.EuiModalHeaderTitle, {
      "data-test-subj": "confirmModalTitleText"
    }, title));
  }

  var message;

  if (typeof children === 'string' && children.length > 0) {
    message = _react.default.createElement("p", null, children);
  } else {
    message = children;
  }

  return _react.default.createElement(_modal.EuiModal, (0, _extends2.default)({
    className: classes,
    onClose: onCancel
  }, rest), modalTitle, message && _react.default.createElement(_modal_body.EuiModalBody, null, _react.default.createElement(_text.EuiText, {
    "data-test-subj": "confirmModalBodyText"
  }, message)), _react.default.createElement(_modal_footer.EuiModalFooter, null, _react.default.createElement(_button.EuiButtonEmpty, {
    "data-test-subj": "confirmModalCancelButton",
    onClick: onCancel,
    buttonRef: cancelRef
  }, cancelButtonText), _react.default.createElement(_button.EuiButton, {
    "data-test-subj": "confirmModalConfirmButton",
    onClick: onConfirm,
    fill: true,
    buttonRef: confirmRef,
    color: buttonColor,
    isDisabled: confirmButtonDisabled
  }, confirmButtonText)));
};

exports.EuiConfirmModal = EuiConfirmModal;
EuiConfirmModal.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: _propTypes.default.node,
  title: _propTypes.default.node,
  cancelButtonText: _propTypes.default.node,
  confirmButtonText: _propTypes.default.node,
  onCancel: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func,
  confirmButtonDisabled: _propTypes.default.bool,
  className: _propTypes.default.string,
  defaultFocusedButton: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.any.isRequired]),
  buttonColor: _propTypes.default.oneOf(["primary", "text", "danger", "ghost", "secondary", "warning"]),
  // For docs only, will get passed with ...rest

  /**
     * Sets the max-width of the modal.
     * Set to `true` to use the default (`euiBreakpoints 'm'`),
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  maxWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired])
};

try {
  EuiConfirmModal.__docgenInfo = {
    description: '',
    displayName: 'EuiConfirmModal',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      cancelButtonText: {
        defaultValue: null,
        description: '',
        name: 'cancelButtonText',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      confirmButtonText: {
        defaultValue: null,
        description: '',
        name: 'confirmButtonText',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onCancel: {
        defaultValue: null,
        description: '',
        name: 'onCancel',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: true,
        type: {
          name: '(event?: any) => void'
        }
      },
      onConfirm: {
        defaultValue: null,
        description: '',
        name: 'onConfirm',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: '(event: any) => void'
        }
      },
      confirmButtonDisabled: {
        defaultValue: null,
        description: '',
        name: 'confirmButtonDisabled',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      defaultFocusedButton: {
        defaultValue: null,
        description: '',
        name: 'defaultFocusedButton',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"confirm" | "cancel"',
          value: [{
            value: '"confirm"'
          }, {
            value: '"cancel"'
          }]
        }
      },
      buttonColor: {
        defaultValue: {
          value: 'primary'
        },
        description: '',
        name: 'buttonColor',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the modal.\nSet to `true` to use the default (`euiBreakpoints \'m\'`),\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}