"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiNavDrawer", {
  enumerable: true,
  get: function get() {
    return _nav_drawer.EuiNavDrawer;
  }
});
Object.defineProperty(exports, "EuiNavDrawerGroup", {
  enumerable: true,
  get: function get() {
    return _nav_drawer_group.EuiNavDrawerGroup;
  }
});
Object.defineProperty(exports, "EuiNavDrawerFlyout", {
  enumerable: true,
  get: function get() {
    return _nav_drawer_flyout.EuiNavDrawerFlyout;
  }
});

var _nav_drawer = require("./nav_drawer");

var _nav_drawer_group = require("./nav_drawer_group");

var _nav_drawer_flyout = require("./nav_drawer_flyout");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiNavDrawer.__docgenInfo = {
    description: '',
    displayName: 'EuiNavDrawer',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'One or more ReactNodes to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactNodeArray | ReactPortal | ReactNode[]'
        }
      },
      isLocked: {
        defaultValue: null,
        description: 'Keep drawer locked open by default',
        name: 'isLocked',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onIsLockedUpdate: {
        defaultValue: null,
        description: 'Returns the current state of isLocked',
        name: 'onIsLockedUpdate',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: '(isLocked: boolean) => void'
        }
      },
      showExpandButton: {
        defaultValue: null,
        description: 'Adds fixed toggle button to bottom of menu area',
        name: 'showExpandButton',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showToolTips: {
        defaultValue: null,
        description: 'Display tooltips on side nav items',
        name: 'showToolTips',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiNavDrawerGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiNavDrawerGroup',
    methods: [],
    props: {
      listItems: {
        defaultValue: null,
        description: 'Items to display in this group. See #EuiListGroupItem',
        name: 'listItems',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_group.tsx',
          name: 'EuiNavDrawerGroupProps'
        },
        required: false,
        type: {
          name: 'FlyoutMenuItem[]'
        }
      },
      flyoutMenuButtonClick: {
        defaultValue: null,
        description: 'While not normally required, it is required to pass a function for handling\nof the flyout menu button click',
        name: 'flyoutMenuButtonClick',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_group.tsx',
          name: 'EuiNavDrawerGroupProps'
        },
        required: false,
        type: {
          name: '(links: FlyoutMenuItem[], title: string, item: FlyoutMenuItem) => void'
        }
      },
      onClose: {
        defaultValue: null,
        description: 'Passthrough function to be called when the flyout is closing\n@see `EuiNavDrawer`',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_group.tsx',
          name: 'EuiNavDrawerGroupProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      bordered: {
        defaultValue: null,
        description: 'Add a border to the list container',
        name: 'bordered',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      flush: {
        defaultValue: null,
        description: 'Remove container padding, stretching list items to the edges',
        name: 'flush',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Spacing between list items',
        name: 'gutterSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'GutterSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: 'Change the colors of all `listItems` at once',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Color',
          value: [{
            value: '"primary"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"inherit"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Change the size of all `listItems` at once',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      showToolTips: {
        defaultValue: null,
        description: 'Display tooltips on all list items',
        name: 'showToolTips',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      wrapText: {
        defaultValue: null,
        description: 'Allow link text to wrap vs truncated',
        name: 'wrapText',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ariaLabelledby: {
        defaultValue: null,
        description: '',
        name: 'ariaLabelledby',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiNavDrawerFlyout.__docgenInfo = {
    description: '',
    displayName: 'EuiNavDrawerFlyout',
    methods: [],
    props: {
      isCollapsed: {
        defaultValue: null,
        description: 'Toggle the nav drawer between collapsed and expanded',
        name: 'isCollapsed',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_flyout.tsx',
          name: 'EuiNavDrawerFlyoutProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listItems: {
        defaultValue: null,
        description: '',
        name: 'listItems',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_flyout.tsx',
          name: 'EuiNavDrawerFlyoutProps'
        },
        required: false,
        type: {
          name: 'FlyoutMenuItem[]'
        }
      },
      onClose: {
        defaultValue: null,
        description: 'Passthrough function to be called when the flyout is closing\n@see `EuiNavDrawer`',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_flyout.tsx',
          name: 'EuiNavDrawerFlyoutProps'
        },
        required: false,
        type: {
          name: '(shouldReturnFocus?: boolean) => void'
        }
      },
      title: {
        defaultValue: null,
        description: 'Display a title atop the flyout',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_flyout.tsx',
          name: 'EuiNavDrawerFlyoutProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      wrapText: {
        defaultValue: null,
        description: '',
        name: 'wrapText',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer_flyout.tsx',
          name: 'EuiNavDrawerFlyoutProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}