"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiMutationObserver = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _observer = require("../observer");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var EuiMutationObserver =
/*#__PURE__*/
function (_EuiObserver) {
  (0, _inherits2.default)(EuiMutationObserver, _EuiObserver);

  function EuiMutationObserver() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiMutationObserver);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiMutationObserver)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "name", 'EuiMutationObserver');
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMutation", function (records, observer) {
      _this.props.onMutation(records, observer);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "beginObserve", function () {
      // IE11 and the MutationObserver polyfill used in Kibana (for Jest) implement
      // an older spec in which specifying `attributeOldValue` or `attributeFilter`
      // without specifying `attributes` results in a `SyntaxError`.
      // The following logic patches the newer spec in which `attributes: true` can be
      // implied when appropriate (`attributeOldValue` or `attributeFilter` is specified).
      var observerOptions = _objectSpread({}, _this.props.observerOptions);

      var needsAttributes = observerOptions.hasOwnProperty('attributeOldValue') || observerOptions.hasOwnProperty('attributeFilter');

      if (needsAttributes && !observerOptions.hasOwnProperty('attributes')) {
        observerOptions.attributes = true;
      }

      _this.observer = new MutationObserver(_this.onMutation);

      _this.observer.observe(_this.childNode, observerOptions);
    });
    return _this;
  }

  return EuiMutationObserver;
}(_observer.EuiObserver);

exports.EuiMutationObserver = EuiMutationObserver;

try {
  EuiMutationObserver.__docgenInfo = {
    description: '',
    displayName: 'EuiMutationObserver',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/observer/mutation_observer/mutation_observer.ts',
          name: 'Props'
        },
        required: true,
        type: {
          name: '(ref: (e: HTMLElement) => void) => ReactNode'
        }
      },
      onMutation: {
        defaultValue: null,
        description: '',
        name: 'onMutation',
        parent: {
          fileName: 'eui/src/components/observer/mutation_observer/mutation_observer.ts',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'MutationCallback'
        }
      },
      observerOptions: {
        defaultValue: null,
        description: '',
        name: 'observerOptions',
        parent: {
          fileName: 'eui/src/components/observer/mutation_observer/mutation_observer.ts',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'MutationObserverInit'
        }
      }
    },
    extends: []
  };
} catch (e) {}