"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiObserver = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("react");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiObserver =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiObserver, _Component);

  function EuiObserver() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiObserver);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiObserver)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "name", 'EuiObserver');
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "childNode", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "observer", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateChildNode", function (ref) {
      if (_this.childNode === ref) return; // node hasn't changed
      // if there's an existing observer disconnect it

      if (_this.observer != null) {
        _this.observer.disconnect();

        _this.observer = null;
      }

      _this.childNode = ref;

      if (_this.childNode != null) {
        _this.beginObserve();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "beginObserve", function () {
      throw new Error('EuiObserver has no default observation method');
    });
    return _this;
  }

  (0, _createClass2.default)(EuiObserver, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.childNode == null) {
        throw new Error("".concat(this.name, " did not receive a ref"));
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.observer != null) {
        this.observer.disconnect();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var props = this.props;
      return props.children(this.updateChildNode);
    }
  }]);
  return EuiObserver;
}(_react.Component);

exports.EuiObserver = EuiObserver;

try {
  EuiObserver.__docgenInfo = {
    description: '',
    displayName: 'EuiObserver',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/observer/observer.ts',
          name: 'BaseProps'
        },
        required: true,
        type: {
          name: '(ref: any) => ReactNode'
        }
      }
    },
    extends: []
  };
} catch (e) {}