"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResizeObserver = exports.EuiResizeObserver = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = require("react");

var _observer = require("../observer");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// IE11 and Safari don't support the `ResizeObserver` API at the time of writing
var hasResizeObserver = typeof window !== 'undefined' && typeof window.ResizeObserver !== 'undefined';
var mutationObserverOptions = {
  // [MutationObserverInit](https://developer.mozilla.org/en-US/docs/Web/API/MutationObserverInit)
  attributes: true,
  // Account for style changes from `className` or `style`
  characterData: true,
  // Account for text content size differences
  childList: true,
  // Account for adding/removing child nodes
  subtree: true // Account for deep child nodes

};

var EuiResizeObserver =
/*#__PURE__*/
function (_EuiObserver) {
  (0, _inherits2.default)(EuiResizeObserver, _EuiObserver);

  function EuiResizeObserver() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiResizeObserver);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiResizeObserver)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "name", 'EuiResizeObserver');
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      height: 0,
      width: 0
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onResize", function () {
      if (_this.childNode != null) {
        // Eventually use `clientRect` on the `entries[]` returned natively
        var _this$childNode$getBo = _this.childNode.getBoundingClientRect(),
            height = _this$childNode$getBo.height,
            width = _this$childNode$getBo.width; // Check for actual resize event


        if (_this.state.height === height && _this.state.width === width) {
          return;
        }

        _this.props.onResize({
          height: height,
          width: width
        });

        _this.setState({
          height: height,
          width: width
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "beginObserve", function () {
      // The superclass checks that childNode is not null before invoking
      // beginObserve()
      var childNode = _this.childNode;
      _this.observer = makeResizeObserver(childNode, _this.onResize);
    });
    return _this;
  }

  return EuiResizeObserver;
}(_observer.EuiObserver);

exports.EuiResizeObserver = EuiResizeObserver;

var makeCompatibleObserver = function makeCompatibleObserver(node, callback) {
  var observer = new MutationObserver(callback);
  observer.observe(node, mutationObserverOptions);
  window.addEventListener('resize', callback);

  var _disconnect = observer.disconnect.bind(observer);

  observer.disconnect = function () {
    _disconnect();

    window.removeEventListener('resize', callback);
  };

  return observer;
};

var makeResizeObserver = function makeResizeObserver(node, callback) {
  var observer;

  if (hasResizeObserver) {
    observer = new window.ResizeObserver(callback);
    observer.observe(node);
  } else {
    observer = makeCompatibleObserver(node, callback);
    requestAnimationFrame(callback); // Mimic ResizeObserver behavior of triggering a resize event on init
  }

  return observer;
};

var useResizeObserver = function useResizeObserver(container, dimension) {
  var _useState = (0, _react.useState)({
    width: 0,
    height: 0
  }),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      size = _useState2[0],
      _setSize = _useState2[1]; // _currentDimensions and _setSize are used to only store the
  // new state (and trigger a re-render) when the new dimensions actually differ


  var _currentDimensions = (0, _react.useRef)(size);

  var setSize = (0, _react.useCallback)(function (dimensions) {
    var doesWidthMatter = dimension !== 'height';
    var doesHeightMatter = dimension !== 'width';

    if (doesWidthMatter && _currentDimensions.current.width !== dimensions.width || doesHeightMatter && _currentDimensions.current.height !== dimensions.height) {
      _currentDimensions.current = dimensions;

      _setSize(dimensions);
    }
  }, [dimension]);
  (0, _react.useEffect)(function () {
    if (container != null) {
      // ResizeObserver's first call to the observation callback is scheduled in the future
      // so find the container's initial dimensions now
      var boundingRect = container.getBoundingClientRect();
      setSize({
        width: boundingRect.width,
        height: boundingRect.height
      });
      var observer = makeResizeObserver(container, function () {
        var boundingRect = container.getBoundingClientRect();
        setSize({
          width: boundingRect.width,
          height: boundingRect.height
        });
      });
      return function () {
        return observer.disconnect();
      };
    } else {
      setSize({
        width: 0,
        height: 0
      });
    }
  }, [container, setSize]);
  return size;
};

exports.useResizeObserver = useResizeObserver;

try {
  EuiResizeObserver.__docgenInfo = {
    description: '',
    displayName: 'EuiResizeObserver',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/observer/resize_observer/resize_observer.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: '(ref: (e: HTMLElement) => void) => ReactNode'
        }
      },
      onResize: {
        defaultValue: null,
        description: '',
        name: 'onResize',
        parent: {
          fileName: 'eui/src/components/observer/resize_observer/resize_observer.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: '(dimensions: { height: number; width: number; }) => void'
        }
      }
    },
    extends: []
  };
} catch (e) {}