"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiPage", {
  enumerable: true,
  get: function get() {
    return _page.EuiPage;
  }
});
Object.defineProperty(exports, "EuiPageBody", {
  enumerable: true,
  get: function get() {
    return _page_body.EuiPageBody;
  }
});
Object.defineProperty(exports, "EuiPageContent", {
  enumerable: true,
  get: function get() {
    return _page_content.EuiPageContent;
  }
});
Object.defineProperty(exports, "EuiPageContentBody", {
  enumerable: true,
  get: function get() {
    return _page_content.EuiPageContentBody;
  }
});
Object.defineProperty(exports, "EuiPageContentHeader", {
  enumerable: true,
  get: function get() {
    return _page_content.EuiPageContentHeader;
  }
});
Object.defineProperty(exports, "EuiPageContentHeaderSection", {
  enumerable: true,
  get: function get() {
    return _page_content.EuiPageContentHeaderSection;
  }
});
Object.defineProperty(exports, "EuiPageHeader", {
  enumerable: true,
  get: function get() {
    return _page_header.EuiPageHeader;
  }
});
Object.defineProperty(exports, "EuiPageHeaderSection", {
  enumerable: true,
  get: function get() {
    return _page_header.EuiPageHeaderSection;
  }
});
Object.defineProperty(exports, "EuiPageSideBar", {
  enumerable: true,
  get: function get() {
    return _page_side_bar.EuiPageSideBar;
  }
});

var _page = require("./page");

var _page_body = require("./page_body");

var _page_content = require("./page_content");

var _page_header = require("./page_header");

var _page_side_bar = require("./page_side_bar");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiPage.__docgenInfo = {
    description: '',
    displayName: 'EuiPage',
    methods: [],
    props: {
      restrictWidth: {
        defaultValue: null,
        description: '',
        name: 'restrictWidth',
        parent: {
          fileName: 'eui/src/components/page/page.tsx',
          name: 'EuiPageProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageBody.__docgenInfo = {
    description: '',
    displayName: 'EuiPageBody',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      restrictWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'restrictWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      component: {
        defaultValue: null,
        description: 'Sets the HTML element for `EuiPageBody`.',
        name: 'component',
        parent: undefined,
        required: false,
        type: {
          name: 'T'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageContent.__docgenInfo = {
    description: '',
    displayName: 'EuiPageContent',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasShadow: {
        defaultValue: null,
        description: 'If active, adds a deeper shadow to the panel',
        name: 'hasShadow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      paddingSize: {
        defaultValue: null,
        description: 'Padding applied to the panel',
        name: 'paddingSize',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: 'When true the panel will grow to match `EuiFlexItem`',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      panelRef: {
        defaultValue: null,
        description: '',
        name: 'panelRef',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'Ref<HTMLDivElement>'
        }
      },
      betaBadgeLabel: {
        defaultValue: null,
        description: 'Add a badge to the panel to label it as "Beta" or other non-GA state',
        name: 'betaBadgeLabel',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      betaBadgeTooltipContent: {
        defaultValue: null,
        description: 'Add a description to the beta badge (will appear in a tooltip)',
        name: 'betaBadgeTooltipContent',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      betaBadgeTitle: {
        defaultValue: null,
        description: 'Optional title will be supplied as tooltip title or title attribute otherwise the label will be used',
        name: 'betaBadgeTitle',
        parent: {
          fileName: 'eui/src/components/panel/panel.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      panelPaddingSize: {
        defaultValue: null,
        description: '',
        name: 'panelPaddingSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      verticalPosition: {
        defaultValue: null,
        description: '',
        name: 'verticalPosition',
        parent: undefined,
        required: false,
        type: {
          name: '"center"'
        }
      },
      horizontalPosition: {
        defaultValue: null,
        description: '',
        name: 'horizontalPosition',
        parent: undefined,
        required: false,
        type: {
          name: '"center"'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageContentBody.__docgenInfo = {
    description: '',
    displayName: 'EuiPageContentBody',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageContentHeader.__docgenInfo = {
    description: '',
    displayName: 'EuiPageContentHeader',
    methods: [],
    props: {
      responsive: {
        defaultValue: null,
        description: 'Set to false if you don\'t want the children to stack\nat small screen sizes.',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/page/page_content/page_content_header.tsx',
          name: 'EuiPageContentHeaderProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageContentHeaderSection.__docgenInfo = {
    description: '',
    displayName: 'EuiPageContentHeaderSection',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageHeader.__docgenInfo = {
    description: '',
    displayName: 'EuiPageHeader',
    methods: [],
    props: {
      responsive: {
        defaultValue: null,
        description: 'Set to false if you don\'t want the children to stack\nat small screen sizes.',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/page/page_header/page_header.tsx',
          name: 'EuiPageHeaderProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageHeaderSection.__docgenInfo = {
    description: '',
    displayName: 'EuiPageHeaderSection',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPageSideBar.__docgenInfo = {
    description: '',
    displayName: 'EuiPageSideBar',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}