"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiProgress = exports.POSITIONS = exports.COLORS = exports.SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _i18n = require("../i18n");

var _predicate = require("../../services/predicate");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sizeToClassNameMap = {
  xs: 'euiProgress--xs',
  s: 'euiProgress--s',
  m: 'euiProgress--m',
  l: 'euiProgress--l'
};
var SIZES = Object.keys(sizeToClassNameMap);
exports.SIZES = SIZES;
var colorToClassNameMap = {
  primary: 'euiProgress--primary',
  secondary: 'euiProgress--secondary',
  danger: 'euiProgress--danger',
  subdued: 'euiProgress--subdued',
  accent: 'euiProgress--accent'
};
var COLORS = Object.keys(colorToClassNameMap);
exports.COLORS = COLORS;
var dataColorToClassNameMap = {
  primary: 'euiProgress__data--primary',
  secondary: 'euiProgress__data--secondary',
  danger: 'euiProgress__data--danger',
  subdued: 'euiProgress__data--subdued',
  accent: 'euiProgress__data--accent'
};
var positionsToClassNameMap = {
  fixed: 'euiProgress--fixed',
  absolute: 'euiProgress--absolute',
  static: ''
};
var POSITIONS = Object.keys(positionsToClassNameMap);
exports.POSITIONS = POSITIONS;

var EuiProgress = function EuiProgress(_ref) {
  var className = _ref.className,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'secondary' : _ref$color,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      max = _ref.max,
      _ref$valueText = _ref.valueText,
      valueText = _ref$valueText === void 0 ? false : _ref$valueText,
      label = _ref.label,
      value = _ref.value,
      labelProps = _ref.labelProps,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"]);
  var determinate = !(0, _predicate.isNil)(max);
  var classes = (0, _classnames.default)('euiProgress', {
    'euiProgress--indeterminate': !determinate,
    'euiProgress--native': determinate
  }, sizeToClassNameMap[size], colorToClassNameMap[color], positionsToClassNameMap[position], className);
  var dataClasses = (0, _classnames.default)('euiProgress__data', {
    'euiProgress__data--l': size === 'l'
  }, dataColorToClassNameMap[color]);
  var labelClasses = (0, _classnames.default)('euiProgress__label', labelProps && labelProps.className);
  var valueRender;

  if (typeof valueText === 'boolean' && valueText) {
    // valueText is a true boolean
    valueRender = _react.default.createElement(_i18n.EuiI18n, {
      token: "euiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  } // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/


  if (determinate) {
    return _react.default.createElement(_react.Fragment, null, label || valueText ? _react.default.createElement("div", {
      className: dataClasses
    }, label && _react.default.createElement("span", (0, _extends2.default)({}, labelProps, {
      className: labelClasses
    }), label), valueRender && _react.default.createElement("span", {
      className: "euiProgress__valueText"
    }, valueRender)) : undefined, _react.default.createElement("progress", (0, _extends2.default)({
      className: classes,
      max: max,
      value: value,
      "aria-hidden": label && valueText ? true : false
    }, rest)));
  } else {
    return _react.default.createElement("div", (0, _extends2.default)({
      className: classes
    }, rest));
  }
};

exports.EuiProgress = EuiProgress;
EuiProgress.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  size: _propTypes.default.oneOf(["xs", "s", "m", "l"]),
  color: _propTypes.default.oneOf(["primary", "secondary", "danger", "subdued", "accent"]),
  position: _propTypes.default.oneOf(["fixed", "absolute", "static"]),
  max: _propTypes.default.number,

  /*
       * If true, will render the percentage, otherwise pass a custom node
       */
  valueText: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.node.isRequired]),
  label: _propTypes.default.node,

  /**
       * Object of props passed to the <span/> wrapping the determinate progress's label
       */
  labelProps: _propTypes.default.any
};

try {
  EuiProgress.__docgenInfo = {
    description: '',
    displayName: 'EuiProgress',
    methods: [],
    props: {
      max: {
        defaultValue: null,
        description: '',
        name: 'max',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      valueText: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'valueText',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      labelProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the determinate progress\'s label',
        name: 'labelProps',
        parent: undefined,
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement>'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: {
          value: 'm'
        },
        description: '',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      color: {
        defaultValue: {
          value: 'secondary'
        },
        description: '',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"primary" | "secondary" | "danger" | "accent" | "subdued"',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"danger"'
          }, {
            value: '"accent"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      position: {
        defaultValue: {
          value: 'static'
        },
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Positions',
          value: [{
            value: '"static"'
          }, {
            value: '"fixed"'
          }, {
            value: '"absolute"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}