"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiResizableContainer", {
  enumerable: true,
  get: function get() {
    return _resizable_container.EuiResizableContainer;
  }
});

var _resizable_container = require("./resizable_container");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiResizableContainer.__docgenInfo = {
    description: '',
    displayName: 'EuiResizableContainer',
    methods: [],
    props: {
      direction: {
        defaultValue: null,
        description: 'Specify the container direction',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      children: {
        defaultValue: null,
        description: 'Pure function which accepts Panel and Resizer components in arguments\nand returns a component tree',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: '(Panel: ComponentType<EuiResizablePanelProps>, Resizer: ComponentType<EuiResizableButtonProps>) => ReactNode'
        }
      },
      onPanelWidthChange: {
        defaultValue: null,
        description: 'Pure function which accepts an object where keys are IDs of panels, which sizes were changed,\nand values are actual sizes in percents',
        name: 'onPanelWidthChange',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: '({}: { [key: string]: number; }) => any'
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}