"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiShowFor = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var responsiveSizesToClassNameMap = {
  xs: 'eui-showFor--xs',
  s: 'eui-showFor--s',
  m: 'eui-showFor--m',
  l: 'eui-showFor--l',
  xl: 'eui-showFor--xl'
};

var EuiShowFor = function EuiShowFor(_ref) {
  var children = _ref.children,
      sizes = _ref.sizes,
      display = _ref.display;
  var utilityClasses = sizes.map(function (item) {
    var append = display ? "--".concat(display) : '';
    return "".concat(responsiveSizesToClassNameMap[item]).concat(append);
  });

  if (_react.default.isValidElement(children)) {
    return _react.default.createElement(_react.default.Fragment, null, _react.default.Children.map(children, function (child) {
      return _react.default.cloneElement(child, {
        className: (0, _classnames.default)(child.props.className, utilityClasses)
      });
    }));
  } else {
    return _react.default.createElement("span", {
      className: (0, _classnames.default)(utilityClasses)
    }, children);
  }
};

exports.EuiShowFor = EuiShowFor;
EuiShowFor.propTypes = {
  children: _propTypes.default.node,

  /**
     * List of all the responsive sizes to show the children for.
     * Options are `'xs' | 's' | 'm' | 'l' | 'xl'`
     */
  sizes: _propTypes.default.arrayOf(_propTypes.default.oneOf(["xs", "s", "m", "l", "xl"]).isRequired).isRequired,

  /**
     * Optional display as property. Leaving as `undefined` renders as `inline`.
     */
  display: _propTypes.default.oneOf(["block", "inlineBlock", "flex"])
};

try {
  EuiShowFor.__docgenInfo = {
    description: '',
    displayName: 'EuiShowFor',
    methods: [],
    props: {
      sizes: {
        defaultValue: null,
        description: 'List of all the responsive sizes to show the children for.\nOptions are `\'xs\' | \'s\' | \'m\' | \'l\' | \'xl\'`',
        name: 'sizes',
        parent: {
          fileName: 'eui/src/components/responsive/show_for.tsx',
          name: 'EuiShowForProps'
        },
        required: true,
        type: {
          name: 'EuiBreakpointSize[]'
        }
      },
      display: {
        defaultValue: null,
        description: 'Optional display as property. Leaving as `undefined` renders as `inline`.',
        name: 'display',
        parent: {
          fileName: 'eui/src/components/responsive/show_for.tsx',
          name: 'EuiShowForProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiShowForDisplay',
          value: [{
            value: '"inlineBlock"'
          }, {
            value: '"block"'
          }, {
            value: '"flex"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}