"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSelectableList", {
  enumerable: true,
  get: function get() {
    return _selectable_list.EuiSelectableList;
  }
});
Object.defineProperty(exports, "EuiSelectableListItem", {
  enumerable: true,
  get: function get() {
    return _selectable_list_item.EuiSelectableListItem;
  }
});

var _selectable_list = require("./selectable_list");

var _selectable_list_item = require("./selectable_list_item");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiSelectableList.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableList',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      activeOptionIndex: {
        defaultValue: null,
        description: 'The index of the option to be highlighted as pseudo-focused;\nGood for use when only one selection is allowed and needing to open\ndirectly to that option',
        name: 'activeOptionIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      rowHeight: {
        defaultValue: null,
        description: 'The height of each option in pixels. Defaults to `32`',
        name: 'rowHeight',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      showIcons: {
        defaultValue: null,
        description: 'Show the check/cross selection indicator icons',
        name: 'showIcons',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: '',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      windowProps: {
        defaultValue: null,
        description: 'Any props to send specifically to the react-window `FixedSizeList`',
        name: 'windowProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<ListProps>'
        }
      },
      bordered: {
        defaultValue: null,
        description: 'Adds a border around the list to indicate the bounds;\nUseful when the list scrolls, otherwise use your own container',
        name: 'bordered',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onFocusBadge: {
        defaultValue: null,
        description: 'When enabled by setting to either `true` or passing custom text,\nshows a hollow badge as an append (far right) when the item is focused.\nThe default content when `true` is `↩ to select/deselect/include/exclude`',
        name: 'onFocusBadge',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | ({ iconType?: IconType; iconSide?: ButtonContentIconSide; color?: string; isDisabled?: boolean; closeButtonProps?: Partial<EuiIconProps>; } & CommonProps & DisambiguateSet<...> & DisambiguateSet<...> & Pick<...>) | ... 4 more ... | ({ ...; } & ... 6 more ... & Pick<...>)'
        }
      },
      options: {
        defaultValue: null,
        description: 'All possible options',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      visibleOptions: {
        defaultValue: null,
        description: 'Filtered options list (if applicable)',
        name: 'visibleOptions',
        parent: undefined,
        required: false,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      searchValue: {
        defaultValue: null,
        description: 'Search value to highlight on the option render',
        name: 'searchValue',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      onOptionClick: {
        defaultValue: null,
        description: 'Returns the array of options with altered checked state',
        name: 'onOptionClick',
        parent: undefined,
        required: true,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render for the label portion of the option;\nTakes (option, searchValue), returns ReactNode',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allow cycling through the on, off and undefined state of option.checked\nand not just on and undefined',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      searchable: {
        defaultValue: null,
        description: '',
        name: 'searchable',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      makeOptionId: {
        defaultValue: null,
        description: '',
        name: 'makeOptionId',
        parent: undefined,
        required: true,
        type: {
          name: '(index: number) => string'
        }
      },
      listId: {
        defaultValue: null,
        description: '',
        name: 'listId',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      setActiveOptionIndex: {
        defaultValue: null,
        description: '',
        name: 'setActiveOptionIndex',
        parent: undefined,
        required: true,
        type: {
          name: '(index: number, cb?: () => void) => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSelectableListItem.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableListItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      checked: {
        defaultValue: null,
        description: 'Applies an icon and visual styling to activated items',
        name: 'checked',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"on" | "off"',
          value: [{
            value: '"on"'
          }, {
            value: '"off"'
          }]
        }
      },
      showIcons: {
        defaultValue: null,
        description: 'Shows icons based on `checked` type',
        name: 'showIcons',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isFocused: {
        defaultValue: null,
        description: 'Highlights the item for pseudo focus',
        name: 'isFocused',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: '',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      append: {
        defaultValue: null,
        description: '',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: '',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onFocusBadge: {
        defaultValue: null,
        description: 'When enabled by setting to either `true` or passing custom a custom badge,\nshows a hollow badge as an append (far right) when the item is focused.\nThe default content when `true` is `↩ to select/deselect/include/exclude`',
        name: 'onFocusBadge',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | ({ iconType?: IconType; iconSide?: ButtonContentIconSide; color?: string; isDisabled?: boolean; closeButtonProps?: Partial<EuiIconProps>; } & CommonProps & DisambiguateSet<...> & DisambiguateSet<...> & Pick<...>) | ... 4 more ... | ({ ...; } & ... 6 more ... & Pick<...>)'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}