"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiSelectableSearch = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _form = require("../../form");

var _matching_options = require("../matching_options");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiSelectableSearch =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiSelectableSearch, _Component);

  function EuiSelectableSearch(props) {
    var _this;

    (0, _classCallCheck2.default)(this, EuiSelectableSearch);
    _this = (0, _possibleConstructorReturn2.default)(this, (0, _getPrototypeOf2.default)(EuiSelectableSearch).call(this, props));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSearchChange", function (value) {
      if (value !== _this.state.searchValue) {
        _this.setState({
          searchValue: value
        }, function () {
          var matchingOptions = (0, _matching_options.getMatchingOptions)(_this.props.options, value);

          _this.props.onChange(matchingOptions, value);
        });
      }
    });
    _this.state = {
      searchValue: props.defaultValue
    };
    return _this;
  }

  (0, _createClass2.default)(EuiSelectableSearch, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var searchValue = this.state.searchValue;
      var matchingOptions = (0, _matching_options.getMatchingOptions)(this.props.options, searchValue);
      this.props.onChange(matchingOptions, searchValue);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          className = _this$props.className,
          onChange = _this$props.onChange,
          options = _this$props.options,
          defaultValue = _this$props.defaultValue,
          listId = _this$props.listId,
          placeholder = _this$props.placeholder,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["className", "onChange", "options", "defaultValue", "listId", "placeholder"]);
      var classes = (0, _classnames.default)('euiSelectableSearch', className);
      var ariaPropsIfListIsPresent = listId ? {
        role: 'combobox',
        'aria-autocomplete': 'list',
        'aria-expanded': true,
        'aria-controls': listId,
        'aria-owns': listId // legacy attribute but shims support for nearly everything atm

      } : undefined;
      return _react.default.createElement(_form.EuiFieldSearch, (0, _extends2.default)({
        className: classes,
        placeholder: placeholder,
        onSearch: this.onSearchChange,
        incremental: true,
        defaultValue: defaultValue,
        fullWidth: true,
        autoComplete: "off",
        "aria-haspopup": "listbox"
      }, ariaPropsIfListIsPresent, rest));
    }
  }]);
  return EuiSelectableSearch;
}(_react.Component);

exports.EuiSelectableSearch = EuiSelectableSearch;
(0, _defineProperty2.default)(EuiSelectableSearch, "defaultProps", {
  defaultValue: ''
});
EuiSelectableSearch.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Passes back (matchingOptions, searchValue)
       */
  onChange: _propTypes.default.func.isRequired,
  options: _propTypes.default.arrayOf(_propTypes.default.shape({
    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: _propTypes.default.oneOfType([_propTypes.default.oneOf([true]).isRequired, _propTypes.default.oneOf([false])]),
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string,

    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: _propTypes.default.string,

    /**
       * Optionally change the searchable term by passing a different string other than the `label`.
       * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
       */
    searchableLabel: _propTypes.default.string,

    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: _propTypes.default.string,

    /**
       * Leave `undefined` to indicate not selected,
       * 'on' to indicate inclusion and
       * 'off' to indicate exclusion
       */
    checked: _propTypes.default.oneOf(["on", "off", undefined]),
    disabled: _propTypes.default.bool,

    /**
       * Node to add between the selection icon and the label
       */
    prepend: _propTypes.default.node,

    /**
       * Node to add to the far right of the item
       */
    append: _propTypes.default.node,
    ref: _propTypes.default.func
  }).isRequired).isRequired,
  defaultValue: _propTypes.default.string.isRequired,

  /**
       * The id of the visible list to create the appropriate aria controls
       */
  listId: _propTypes.default.string
};

try {
  EuiSelectableSearch.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableSearch',
    methods: [],
    props: {
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      placeholder: {
        defaultValue: null,
        description: '',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'when `true` creates a shorter height input',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: '(node: HTMLInputElement) => void'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      isClearable: {
        defaultValue: null,
        description: 'Shows a button that quickly clears any input',
        name: 'isClearable',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onSearch: {
        defaultValue: null,
        description: 'Called when the user presses [Enter] OR on change if the incremental prop is `true`.\nIf you don\'t need the on[Enter] functionality, prefer using onChange',
        name: 'onSearch',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: '(value: string) => void'
        }
      },
      incremental: {
        defaultValue: null,
        description: 'When `true` the search will be executed (that is, the `onSearch` will be called) as the\nuser types.',
        name: 'incremental',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back (matchingOptions, searchValue)',
        name: 'onChange',
        parent: undefined,
        required: true,
        type: {
          name: '(matchingOptions: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[], searchValue: string) => void'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      listId: {
        defaultValue: null,
        description: 'The id of the visible list to create the appropriate aria controls',
        name: 'listId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}