"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSelectableTemplateSitewide", {
  enumerable: true,
  get: function get() {
    return _selectable_template_sitewide.EuiSelectableTemplateSitewide;
  }
});
Object.defineProperty(exports, "euiSelectableTemplateSitewideFormatOptions", {
  enumerable: true,
  get: function get() {
    return _selectable_template_sitewide_option.euiSelectableTemplateSitewideFormatOptions;
  }
});
Object.defineProperty(exports, "euiSelectableTemplateSitewideRenderOptions", {
  enumerable: true,
  get: function get() {
    return _selectable_template_sitewide_option.euiSelectableTemplateSitewideRenderOptions;
  }
});

var _selectable_template_sitewide = require("./selectable_template_sitewide");

var _selectable_template_sitewide_option = require("./selectable_template_sitewide_option");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiSelectableTemplateSitewide.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableTemplateSitewide',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'Function that takes the `list` node and then\nthe `search` node (if `searchable` is applied)',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: '(list: ReactElement, search: ReactElement<...>) => ReactNode'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Show an loading indicator while you load and hook up your data',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back the altered `options` array with selected options as',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render function for each option.\nReturns `(option, searchValue)`',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: 'Sets the single selection policy of\n`false`: allows multiple selection\n`true`: only allows one selection\n`always`: can and must have only one selection',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      searchable: {
        defaultValue: null,
        description: 'Hooks up a search box to filter the list (boolean)',
        name: 'searchable',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      searchProps: {
        defaultValue: null,
        description: 'Passes props down to the `EuiFieldSearch`',
        name: 'searchProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<EuiSelectableSearchProps>'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allows marking options as `checked=\'off\'` as well as `\'on\'`',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listProps: {
        defaultValue: null,
        description: 'See #EuiSelectableOptionsList',
        name: 'listProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSelectableOptionsListPropsWithDefaults'
        }
      },
      loadingMessage: {
        defaultValue: null,
        description: 'Customize the loading message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'loadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      noMatchesMessage: {
        defaultValue: null,
        description: 'Customize the no matches message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'noMatchesMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      emptyMessage: {
        defaultValue: null,
        description: 'Customize the empty message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'emptyMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      options: {
        defaultValue: null,
        description: 'Extends the typical EuiSelectable #Options with the addition of pre-composed elements\nsuch as `icon`, `avatar`and `meta`',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiSelectableTemplateSitewideOption<{ [key: string]: any; }>[]'
        }
      },
      popoverProps: {
        defaultValue: null,
        description: 'Override some of the EuiPopover props housing the list.\nThe default width is `600`',
        name: 'popoverProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<Props> & { width?: ReactText; }'
        }
      },
      popoverTitle: {
        defaultValue: null,
        description: 'Optionally provide a title for the popover',
        name: 'popoverTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      popoverFooter: {
        defaultValue: null,
        description: 'Optionally provide a footer for the popover',
        name: 'popoverFooter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  euiSelectableTemplateSitewideFormatOptions.__docgenInfo = {
    description: '',
    displayName: 'euiSelectableTemplateSitewideFormatOptions',
    methods: [],
    props: {},
    extends: ['DOMAttributes']
  };
} catch (e) {}