"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiStat", {
  enumerable: true,
  get: function get() {
    return _stat.EuiStat;
  }
});

var _stat = require("./stat");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiStat.__docgenInfo = {
    description: '',
    displayName: 'EuiStat',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      description: {
        defaultValue: null,
        description: 'Set the description (label) text',
        name: 'description',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Will hide the title with an animation until false',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      reverse: {
        defaultValue: null,
        description: 'Flips the order of the description and title',
        name: 'reverse',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      textAlign: {
        defaultValue: null,
        description: '',
        name: 'textAlign',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'The (value) text',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      titleColor: {
        defaultValue: null,
        description: 'The color of the title text',
        name: 'titleColor',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      titleSize: {
        defaultValue: null,
        description: 'Size of the title. See EuiTitle for options (\'s\', \'m\', \'l\'... etc)',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs" | "l" | "xxxs" | "xxs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xxxs"'
          }, {
            value: '"xxs"'
          }]
        }
      },
      titleElement: {
        defaultValue: null,
        description: 'HTML Element to be used for title',
        name: 'titleElement',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      descriptionElement: {
        defaultValue: null,
        description: 'HTML Element to be used for description',
        name: 'descriptionElement',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}