"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStat = exports.ALIGNMENTS = exports.isColorClass = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _common = require("../common");

var _classnames = _interopRequireDefault(require("classnames"));

var _text = require("../text");

var _title = require("../title/title");

var _accessibility = require("../accessibility");

var _i18n = require("../i18n");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var colorToClassNameMap = {
  default: null,
  subdued: 'euiStat__title--subdued',
  primary: 'euiStat__title--primary',
  secondary: 'euiStat__title--secondary',
  danger: 'euiStat__title--danger',
  accent: 'euiStat__title--accent'
};
var COLORS = (0, _common.keysOf)(colorToClassNameMap);
exports.COLORS = COLORS;
var textAlignToClassNameMap = {
  left: 'euiStat--leftAligned',
  center: 'euiStat--centerAligned',
  right: 'euiStat--rightAligned'
};

var isColorClass = function isColorClass(input) {
  return colorToClassNameMap.hasOwnProperty(input);
};

exports.isColorClass = isColorClass;
var ALIGNMENTS = (0, _common.keysOf)(textAlignToClassNameMap);
exports.ALIGNMENTS = ALIGNMENTS;

var EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
      className = _ref.className,
      description = _ref.description,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$reverse = _ref.reverse,
      reverse = _ref$reverse === void 0 ? false : _ref$reverse,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
      title = _ref.title,
      _ref$titleColor = _ref.titleColor,
      titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
      _ref$descriptionEleme = _ref.descriptionElement,
      descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"]);
  var classes = (0, _classnames.default)('euiStat', textAlignToClassNameMap[textAlign], className);
  var titleClasses = (0, _classnames.default)('euiStat__title', isColorClass(titleColor) ? colorToClassNameMap[titleColor] : null, {
    'euiStat__title-isLoading': isLoading
  });
  var commonProps = {
    'aria-hidden': true
  };

  var descriptionDisplay = _react.default.createElement(_text.EuiText, {
    size: "s",
    className: "euiStat__description"
  }, (0, _react.createElement)(descriptionElement, commonProps, description));

  var titlePropsWithColor = {
    'aria-hidden': true,
    style: {
      color: "".concat(titleColor)
    }
  };
  var titleChildren = isLoading ? '--' : title;
  var titleDisplay = isColorClass(titleColor) ? _react.default.createElement(_title.EuiTitle, {
    size: titleSize,
    className: titleClasses
  }, (0, _react.createElement)(titleElement, commonProps, titleChildren)) : _react.default.createElement(_title.EuiTitle, {
    size: titleSize,
    className: titleClasses
  }, (0, _react.createElement)(titleElement, titlePropsWithColor, titleChildren));

  var screenReader = _react.default.createElement(_accessibility.EuiScreenReaderOnly, null, _react.default.createElement("p", null, isLoading ? _react.default.createElement(_i18n.EuiI18n, {
    token: "euiStat.loadingText",
    default: "Statistic is loading"
  }) : _react.default.createElement(_react.Fragment, null, reverse ? "".concat(title, " ").concat(description) : "".concat(description, " ").concat(title))));

  var statDisplay = _react.default.createElement(_react.Fragment, null, !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, typeof title === 'string' && typeof description === 'string' && screenReader);

  return _react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), statDisplay, children);
};

exports.EuiStat = EuiStat;
EuiStat.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Set the description (label) text
     */
  description: _propTypes.default.node.isRequired,

  /**
     * Will hide the title with an animation until false
     */
  isLoading: _propTypes.default.bool,

  /**
     * Flips the order of the description and title
     */
  reverse: _propTypes.default.bool,
  textAlign: _propTypes.default.oneOf(["left", "center", "right"]),

  /**
     * The (value) text
     */
  title: _propTypes.default.node.isRequired,

  /**
     * The color of the title text
     */
  titleColor: _propTypes.default.oneOfType([_propTypes.default.oneOf(["default", "subdued", "primary", "secondary", "danger", "accent"]).isRequired, _propTypes.default.string.isRequired]),

  /**
     * Size of the title. See EuiTitle for options ('s', 'm', 'l'... etc)
     */
  titleSize: _propTypes.default.oneOf(["xxxs", "xxs", "xs", "s", "m", "l"]),

  /**
     * HTML Element to be used for title
     */
  titleElement: _propTypes.default.string,

  /**
     * HTML Element to be used for description
     */
  descriptionElement: _propTypes.default.string
};

try {
  isColorClass.__docgenInfo = {
    description: '',
    displayName: 'isColorClass',
    methods: [],
    props: {},
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiStat.__docgenInfo = {
    description: '',
    displayName: 'EuiStat',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      description: {
        defaultValue: null,
        description: 'Set the description (label) text',
        name: 'description',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      isLoading: {
        defaultValue: {
          value: 'false'
        },
        description: 'Will hide the title with an animation until false',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      reverse: {
        defaultValue: {
          value: 'false'
        },
        description: 'Flips the order of the description and title',
        name: 'reverse',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      textAlign: {
        defaultValue: {
          value: 'left'
        },
        description: '',
        name: 'textAlign',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'The (value) text',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      titleColor: {
        defaultValue: {
          value: 'default'
        },
        description: 'The color of the title text',
        name: 'titleColor',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      titleSize: {
        defaultValue: {
          value: 'l'
        },
        description: 'Size of the title. See EuiTitle for options (\'s\', \'m\', \'l\'... etc)',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs" | "l" | "xxxs" | "xxs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xxxs"'
          }, {
            value: '"xxs"'
          }]
        }
      },
      titleElement: {
        defaultValue: {
          value: 'p'
        },
        description: 'HTML Element to be used for title',
        name: 'titleElement',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      descriptionElement: {
        defaultValue: {
          value: 'p'
        },
        description: 'HTML Element to be used for description',
        name: 'descriptionElement',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}