"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiStepsHorizontal = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _step_horizontal = require("./step_horizontal");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
function renderHorizontalSteps(steps) {
  return steps.map(function (step, index) {
    return _react.default.createElement(_step_horizontal.EuiStepHorizontal, (0, _extends2.default)({
      key: index,
      step: index + 1
    }, step));
  });
}

var EuiStepsHorizontal = function EuiStepsHorizontal(_ref) {
  var className = _ref.className,
      steps = _ref.steps,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "steps"]);
  var classes = (0, _classnames.default)('euiStepsHorizontal', className);
  return _react.default.createElement("div", (0, _extends2.default)({
    role: "tablist",
    className: classes
  }, rest), renderHorizontalSteps(steps));
};

exports.EuiStepsHorizontal = EuiStepsHorizontal;
EuiStepsHorizontal.propTypes = {
  /**
     * An array of `EuiStepHorizontal` objects excluding the `step` prop
     */
  steps: _propTypes.default.arrayOf(_propTypes.default.any.isRequired).isRequired,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiStepsHorizontal.__docgenInfo = {
    description: '',
    displayName: 'EuiStepsHorizontal',
    methods: [],
    props: {
      steps: {
        defaultValue: null,
        description: 'An array of `EuiStepHorizontal` objects excluding the `step` prop',
        name: 'steps',
        parent: {
          fileName: 'eui/src/components/steps/steps_horizontal.tsx',
          name: 'EuiStepsHorizontalProps'
        },
        required: true,
        type: {
          name: 'Pick<EuiStepHorizontalProps, "children" | "tabIndex" | "color" | "className" | "aria-label" | "data-test-subj" | "onClick" | "defaultChecked" | "defaultValue" | ... 249 more ... | "isComplete">[]'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}