"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiSuggestInput", {
  enumerable: true,
  get: function get() {
    return _suggest_input.EuiSuggestInput;
  }
});
Object.defineProperty(exports, "EuiSuggestItem", {
  enumerable: true,
  get: function get() {
    return _suggest_item.EuiSuggestItem;
  }
});
Object.defineProperty(exports, "EuiSuggest", {
  enumerable: true,
  get: function get() {
    return _suggest.EuiSuggest;
  }
});

var _suggest_input = require("./suggest_input");

var _suggest_item = require("./suggest_item");

var _suggest = require("./suggest");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiSuggestInput.__docgenInfo = {
    description: '',
    displayName: 'EuiSuggestInput',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      tooltipContent: {
        defaultValue: null,
        description: '',
        name: 'tooltipContent',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      status: {
        defaultValue: null,
        description: 'Status of the current query \'unsaved\', \'saved\', \'unchanged\' or \'loading\'.',
        name: 'status',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"loading" | "unsaved" | "saved" | "unchanged"',
          value: [{
            value: '"loading"'
          }, {
            value: '"unsaved"'
          }, {
            value: '"saved"'
          }, {
            value: '"unchanged"'
          }]
        }
      },
      append: {
        defaultValue: null,
        description: 'Element to be appended to the input bar.',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'Element'
        }
      },
      suggestions: {
        defaultValue: null,
        description: 'List of suggestions to display using \'suggestItem\'.',
        name: 'suggestions',
        parent: undefined,
        required: true,
        type: {
          name: 'Element[] | EuiSuggestItemProps[]'
        }
      },
      sendValue: {
        defaultValue: null,
        description: '',
        name: 'sendValue',
        parent: undefined,
        required: false,
        type: {
          name: 'Function'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSuggestItem.__docgenInfo = {
    description: '',
    displayName: 'EuiSuggestItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: 'Takes \'iconType\' for EuiIcon and \'color\'. \'color\' can be tint1 through tint9.',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/suggest/suggest_item.tsx',
          name: 'EuiSuggestItemPropsBase'
        },
        required: true,
        type: {
          name: 'Type'
        }
      },
      label: {
        defaultValue: null,
        description: 'Label or primary text.',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/suggest/suggest_item.tsx',
          name: 'EuiSuggestItemPropsBase'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      description: {
        defaultValue: null,
        description: 'Description or secondary text (optional).',
        name: 'description',
        parent: {
          fileName: 'eui/src/components/suggest/suggest_item.tsx',
          name: 'EuiSuggestItemPropsBase'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      labelDisplay: {
        defaultValue: null,
        description: 'Label display is \'fixed\' by default. Label will increase its width beyond 50% if needed with \'expand\'.',
        name: 'labelDisplay',
        parent: {
          fileName: 'eui/src/components/suggest/suggest_item.tsx',
          name: 'EuiSuggestItemPropsBase'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"fixed" | "expand"',
          value: [{
            value: '"fixed"'
          }, {
            value: '"expand"'
          }]
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSuggest.__docgenInfo = {
    description: '',
    displayName: 'EuiSuggest',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      tooltipContent: {
        defaultValue: null,
        description: '',
        name: 'tooltipContent',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      status: {
        defaultValue: null,
        description: 'Status of the current query \'unsaved\', \'saved\', \'unchanged\' or \'loading\'.',
        name: 'status',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"loading" | "unsaved" | "saved" | "unchanged"',
          value: [{
            value: '"loading"'
          }, {
            value: '"unsaved"'
          }, {
            value: '"saved"'
          }, {
            value: '"unchanged"'
          }]
        }
      },
      append: {
        defaultValue: null,
        description: 'Element to be appended to the input bar.',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'Element'
        }
      },
      suggestions: {
        defaultValue: null,
        description: 'List of suggestions to display using \'suggestItem\'.\nList of suggestions to display using \'suggestItem\'.',
        name: 'suggestions',
        parent: undefined,
        required: true,
        type: {
          name: 'Element[] | EuiSuggestItemProps[]'
        }
      },
      sendValue: {
        defaultValue: null,
        description: '',
        name: 'sendValue',
        parent: undefined,
        required: false,
        type: {
          name: 'Function'
        }
      },
      onItemClick: {
        defaultValue: null,
        description: 'Handler for click on a suggestItem.',
        name: 'onItemClick',
        parent: undefined,
        required: false,
        type: {
          name: '(item: EuiSuggestItemProps) => void'
        }
      },
      onInputChange: {
        defaultValue: null,
        description: '',
        name: 'onInputChange',
        parent: undefined,
        required: false,
        type: {
          name: '(target: EventTarget) => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}