"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTable", {
  enumerable: true,
  get: function get() {
    return _table.EuiTable;
  }
});
Object.defineProperty(exports, "EuiTableBody", {
  enumerable: true,
  get: function get() {
    return _table_body.EuiTableBody;
  }
});
Object.defineProperty(exports, "EuiTableFooter", {
  enumerable: true,
  get: function get() {
    return _table_footer.EuiTableFooter;
  }
});
Object.defineProperty(exports, "EuiTableFooterCell", {
  enumerable: true,
  get: function get() {
    return _table_footer_cell.EuiTableFooterCell;
  }
});
Object.defineProperty(exports, "EuiTableHeader", {
  enumerable: true,
  get: function get() {
    return _table_header.EuiTableHeader;
  }
});
Object.defineProperty(exports, "EuiTableHeaderButton", {
  enumerable: true,
  get: function get() {
    return _table_header_button.EuiTableHeaderButton;
  }
});
Object.defineProperty(exports, "EuiTableHeaderCell", {
  enumerable: true,
  get: function get() {
    return _table_header_cell.EuiTableHeaderCell;
  }
});
Object.defineProperty(exports, "EuiTableHeaderCellCheckbox", {
  enumerable: true,
  get: function get() {
    return _table_header_cell_checkbox.EuiTableHeaderCellCheckbox;
  }
});
Object.defineProperty(exports, "EuiTablePagination", {
  enumerable: true,
  get: function get() {
    return _table_pagination.EuiTablePagination;
  }
});
Object.defineProperty(exports, "EuiTableHeaderMobile", {
  enumerable: true,
  get: function get() {
    return _table_header_mobile.EuiTableHeaderMobile;
  }
});
Object.defineProperty(exports, "EuiTableSortMobile", {
  enumerable: true,
  get: function get() {
    return _table_sort_mobile.EuiTableSortMobile;
  }
});
Object.defineProperty(exports, "EuiTableSortMobileItem", {
  enumerable: true,
  get: function get() {
    return _table_sort_mobile_item.EuiTableSortMobileItem;
  }
});
Object.defineProperty(exports, "EuiTableRow", {
  enumerable: true,
  get: function get() {
    return _table_row.EuiTableRow;
  }
});
Object.defineProperty(exports, "EuiTableRowCell", {
  enumerable: true,
  get: function get() {
    return _table_row_cell.EuiTableRowCell;
  }
});
Object.defineProperty(exports, "EuiTableRowCellCheckbox", {
  enumerable: true,
  get: function get() {
    return _table_row_cell_checkbox.EuiTableRowCellCheckbox;
  }
});

var _table = require("./table");

var _table_body = require("./table_body");

var _table_footer = require("./table_footer");

var _table_footer_cell = require("./table_footer_cell");

var _table_header = require("./table_header");

var _table_header_button = require("./table_header_button");

var _table_header_cell = require("./table_header_cell");

var _table_header_cell_checkbox = require("./table_header_cell_checkbox");

var _table_pagination = require("./table_pagination");

var _table_header_mobile = require("./mobile/table_header_mobile");

var _table_sort_mobile = require("./mobile/table_sort_mobile");

var _table_sort_mobile_item = require("./mobile/table_sort_mobile_item");

var _table_row = require("./table_row");

var _table_row_cell = require("./table_row_cell");

var _table_row_cell_checkbox = require("./table_row_cell_checkbox");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiTable.__docgenInfo = {
    description: '',
    displayName: 'EuiTable',
    methods: [],
    props: {
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      responsive: {
        defaultValue: null,
        description: '',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      tableLayout: {
        defaultValue: null,
        description: 'Sets the table-layout CSS property',
        name: 'tableLayout',
        parent: {
          fileName: 'eui/src/components/table/table.tsx',
          name: 'EuiTableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"fixed" | "auto"',
          value: [{
            value: '"fixed"'
          }, {
            value: '"auto"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableBody.__docgenInfo = {
    description: '',
    displayName: 'EuiTableBody',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      bodyRef: {
        defaultValue: null,
        description: '',
        name: 'bodyRef',
        parent: undefined,
        required: false,
        type: {
          name: 'Ref<HTMLTableSectionElement>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableFooter.__docgenInfo = {
    description: '',
    displayName: 'EuiTableFooter',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableFooterCell.__docgenInfo = {
    description: '',
    displayName: 'EuiTableFooterCell',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableHeader.__docgenInfo = {
    description: '',
    displayName: 'EuiTableHeader',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableHeaderButton.__docgenInfo = {
    description: '',
    displayName: 'EuiTableHeaderButton',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableHeaderCell.__docgenInfo = {
    description: '',
    displayName: 'EuiTableHeaderCell',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      align: {
        defaultValue: null,
        description: '',
        name: 'align',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      },
      allowNeutralSort: {
        defaultValue: null,
        description: 'Set `allowNeutralSort` on EuiInMemoryTable to false to force column\nsorting.  EuiBasicTable always forces column sorting.',
        name: 'allowNeutralSort',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hideForMobile: {
        defaultValue: null,
        description: '_DEPRECATED: use `mobileOptions.show = false`_ Indicates if the\ncolumn should not show for mobile users (typically hidden because a\ncustom mobile header utilizes the column\'s contents)',
        name: 'hideForMobile',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isMobileHeader: {
        defaultValue: null,
        description: '_DEPRECATED: use `mobileOptions.only = true`_ Indicates if the\ncolumn was created to be the row\'s heading in mobile view (this\ncolumn will be hidden at larger screens)',
        name: 'isMobileHeader',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSortAscending: {
        defaultValue: null,
        description: '',
        name: 'isSortAscending',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSorted: {
        defaultValue: null,
        description: '',
        name: 'isSorted',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      mobileOptions: {
        defaultValue: null,
        description: 'Mobile options for displaying differently at small screens',
        name: 'mobileOptions',
        parent: undefined,
        required: false,
        type: {
          name: '{ show?: boolean; only?: boolean; }'
        }
      },
      onSort: {
        defaultValue: null,
        description: '',
        name: 'onSort',
        parent: undefined,
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      scope: {
        defaultValue: null,
        description: '',
        name: 'scope',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'TableHeaderCellScope',
          value: [{
            value: '"col"'
          }, {
            value: '"colgroup"'
          }, {
            value: '"row"'
          }, {
            value: '"rowgroup"'
          }]
        }
      },
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableHeaderCellCheckbox.__docgenInfo = {
    description: '',
    displayName: 'EuiTableHeaderCellCheckbox',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: {
          fileName: 'eui/src/components/table/table_header_cell_checkbox.tsx',
          name: 'EuiTableHeaderCellCheckboxProps'
        },
        required: false,
        type: {
          name: 'string | number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTablePagination.__docgenInfo = {
    description: '',
    displayName: 'EuiTablePagination',
    methods: [],
    props: {
      activePage: {
        defaultValue: null,
        description: '',
        name: 'activePage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      hidePerPageOptions: {
        defaultValue: null,
        description: '',
        name: 'hidePerPageOptions',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      itemsPerPage: {
        defaultValue: null,
        description: '',
        name: 'itemsPerPage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      itemsPerPageOptions: {
        defaultValue: null,
        description: '',
        name: 'itemsPerPageOptions',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number[]'
        }
      },
      onChangeItemsPerPage: {
        defaultValue: null,
        description: '',
        name: 'onChangeItemsPerPage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ItemsPerPageChangeHandler'
        }
      },
      onChangePage: {
        defaultValue: null,
        description: '',
        name: 'onChangePage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'PageChangeHandler'
        }
      },
      pageCount: {
        defaultValue: null,
        description: '',
        name: 'pageCount',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      'aria-controls': {
        defaultValue: null,
        description: 'id of the table being controlled',
        name: 'aria-controls',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableHeaderMobile.__docgenInfo = {
    description: '',
    displayName: 'EuiTableHeaderMobile',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableSortMobile.__docgenInfo = {
    description: '',
    displayName: 'EuiTableSortMobile',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile.tsx',
          name: 'EuiTableSortMobileProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      anchorPosition: {
        defaultValue: null,
        description: '',
        name: 'anchorPosition',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile.tsx',
          name: 'EuiTableSortMobileProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'PopoverAnchorPosition',
          value: [{
            value: '"upCenter"'
          }, {
            value: '"upLeft"'
          }, {
            value: '"upRight"'
          }, {
            value: '"downCenter"'
          }, {
            value: '"downLeft"'
          }, {
            value: '"downRight"'
          }, {
            value: '"leftCenter"'
          }, {
            value: '"leftUp"'
          }, {
            value: '"leftDown"'
          }, {
            value: '"rightCenter"'
          }, {
            value: '"rightUp"'
          }, {
            value: '"rightDown"'
          }]
        }
      },
      items: {
        defaultValue: null,
        description: '',
        name: 'items',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile.tsx',
          name: 'EuiTableSortMobileProps'
        },
        required: false,
        type: {
          name: 'ItemProps[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableSortMobileItem.__docgenInfo = {
    description: '',
    displayName: 'EuiTableSortMobileItem',
    methods: [],
    props: {
      onSort: {
        defaultValue: null,
        description: 'Callback to know when an item has been clicked',
        name: 'onSort',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      isSorted: {
        defaultValue: null,
        description: 'Indicates current option is the sorted on column',
        name: 'isSorted',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSortAscending: {
        defaultValue: null,
        description: 'Indicates which direction the current column is sorted on',
        name: 'isSortAscending',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ariaLabel: {
        defaultValue: null,
        description: '',
        name: 'ariaLabel',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableRow.__docgenInfo = {
    description: '',
    displayName: 'EuiTableRow',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isSelectable: {
        defaultValue: null,
        description: 'Indicates if the table has a single column of checkboxes for selecting\nrows (affects mobile only)',
        name: 'isSelectable',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Indicates the current row has been selected',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasActions: {
        defaultValue: null,
        description: 'Indicates if the table has a dedicated column for icon-only actions\n(affects mobile only)',
        name: 'hasActions',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandable: {
        defaultValue: null,
        description: 'Indicates if the row will have an expanded row',
        name: 'isExpandable',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandedRow: {
        defaultValue: null,
        description: 'Indicates if the row will be the expanded row',
        name: 'isExpandedRow',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableRowCell.__docgenInfo = {
    description: '',
    displayName: 'EuiTableRowCell',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      showOnHover: {
        defaultValue: null,
        description: 'Don\'t allow line breaks within cells',
        name: 'showOnHover',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellSharedPropsShape'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      textOnly: {
        defaultValue: null,
        description: 'Setting `textOnly` to `false` will break words unnecessarily on FF and\nIE.  To combat this problem on FF, wrap contents with the css utility\n`.eui-textBreakWord`.',
        name: 'textOnly',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellSharedPropsShape'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      truncateText: {
        defaultValue: null,
        description: '_Should only be used for action cells_',
        name: 'truncateText',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellSharedPropsShape'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      width: {
        defaultValue: null,
        description: '',
        name: 'width',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellSharedPropsShape'
        },
        required: false,
        type: {
          name: 'string | number'
        }
      },
      hasActions: {
        defaultValue: null,
        description: 'Indicates if the column is dedicated to icon-only actions (currently\naffects mobile only)',
        name: 'hasActions',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      header: {
        defaultValue: null,
        description: '_DEPRECATED: use `mobileOptions.header`_\nThe column\'s header title for use in mobile view (will be added as a\ndata-attr)',
        name: 'header',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hideForMobile: {
        defaultValue: null,
        description: '_DEPRECATED: use `mobileOptions.show = false`_\nIndicates if the column should not show for mobile users (typically\nhidden because a custom mobile header utilizes the column\'s contents)',
        name: 'hideForMobile',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpander: {
        defaultValue: null,
        description: 'Indicates if the column is dedicated as the expandable row toggle',
        name: 'isExpander',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isMobileFullWidth: {
        defaultValue: null,
        description: '_DEPRECATED: use `mobileOptions.fullWidth`_\nAllocates 100% of the width of the container in mobile view\n(typically cells are contained to 50%)',
        name: 'isMobileFullWidth',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isMobileHeader: {
        defaultValue: null,
        description: '_DEPRECATED: use `mobileOptions.only = true & mobileOptions.header = * false`_\nIndicates if the column was created to be the row\'s heading in mobile\nview.  It won\'t display column\'s header inline and it the column will\nbe hidden at larger screens)',
        name: 'isMobileHeader',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      mobileOptions: {
        defaultValue: null,
        description: 'Mobile options for displaying differently at small screens',
        name: 'mobileOptions',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'EuiTableRowCellMobileOptionsShape & EuiTableRowCellSharedPropsShape'
        }
      },
      setScopeRow: {
        defaultValue: null,
        description: 'Indicates whether the cell should be marked as the heading for its row',
        name: 'setScopeRow',
        parent: {
          fileName: 'eui/src/components/table/table_row_cell.tsx',
          name: 'EuiTableRowCellProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableRowCellCheckbox.__docgenInfo = {
    description: '',
    displayName: 'EuiTableRowCellCheckbox',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}