"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTableHeaderMobile", {
  enumerable: true,
  get: function get() {
    return _table_header_mobile.EuiTableHeaderMobile;
  }
});
Object.defineProperty(exports, "EuiTableSortMobile", {
  enumerable: true,
  get: function get() {
    return _table_sort_mobile.EuiTableSortMobile;
  }
});
Object.defineProperty(exports, "EuiTableSortMobileItem", {
  enumerable: true,
  get: function get() {
    return _table_sort_mobile_item.EuiTableSortMobileItem;
  }
});

var _table_header_mobile = require("./table_header_mobile");

var _table_sort_mobile = require("./table_sort_mobile");

var _table_sort_mobile_item = require("./table_sort_mobile_item");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiTableHeaderMobile.__docgenInfo = {
    description: '',
    displayName: 'EuiTableHeaderMobile',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableSortMobile.__docgenInfo = {
    description: '',
    displayName: 'EuiTableSortMobile',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile.tsx',
          name: 'EuiTableSortMobileProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      anchorPosition: {
        defaultValue: null,
        description: '',
        name: 'anchorPosition',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile.tsx',
          name: 'EuiTableSortMobileProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'PopoverAnchorPosition',
          value: [{
            value: '"upCenter"'
          }, {
            value: '"upLeft"'
          }, {
            value: '"upRight"'
          }, {
            value: '"downCenter"'
          }, {
            value: '"downLeft"'
          }, {
            value: '"downRight"'
          }, {
            value: '"leftCenter"'
          }, {
            value: '"leftUp"'
          }, {
            value: '"leftDown"'
          }, {
            value: '"rightCenter"'
          }, {
            value: '"rightUp"'
          }, {
            value: '"rightDown"'
          }]
        }
      },
      items: {
        defaultValue: null,
        description: '',
        name: 'items',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile.tsx',
          name: 'EuiTableSortMobileProps'
        },
        required: false,
        type: {
          name: 'ItemProps[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTableSortMobileItem.__docgenInfo = {
    description: '',
    displayName: 'EuiTableSortMobileItem',
    methods: [],
    props: {
      onSort: {
        defaultValue: null,
        description: 'Callback to know when an item has been clicked',
        name: 'onSort',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      isSorted: {
        defaultValue: null,
        description: 'Indicates current option is the sorted on column',
        name: 'isSorted',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSortAscending: {
        defaultValue: null,
        description: 'Indicates which direction the current column is sorted on',
        name: 'isSortAscending',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ariaLabel: {
        defaultValue: null,
        description: '',
        name: 'ariaLabel',
        parent: {
          fileName: 'eui/src/components/table/mobile/table_sort_mobile_item.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}