"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRow = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiTableRow = function EuiTableRow(_ref) {
  var children = _ref.children,
      className = _ref.className,
      isSelected = _ref.isSelected,
      isSelectable = _ref.isSelectable,
      hasActions = _ref.hasActions,
      isExpandedRow = _ref.isExpandedRow,
      isExpandable = _ref.isExpandable,
      onClick = _ref.onClick,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "isSelected", "isSelectable", "hasActions", "isExpandedRow", "isExpandable", "onClick"]);
  var classes = (0, _classnames.default)('euiTableRow', className, {
    'euiTableRow-isSelectable': isSelectable,
    'euiTableRow-isSelected': isSelected,
    'euiTableRow-hasActions': hasActions,
    'euiTableRow-isExpandedRow': isExpandedRow,
    'euiTableRow-isExpandable': isExpandable,
    'euiTableRow-isClickable': onClick
  });
  return _react.default.createElement("tr", (0, _extends2.default)({
    className: classes,
    onClick: onClick
  }, rest), children);
};

exports.EuiTableRow = EuiTableRow;
EuiTableRow.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * Indicates if the table has a single column of checkboxes for selecting
     * rows (affects mobile only)
     */
  isSelectable: _propTypes.default.bool,

  /**
     * Indicates the current row has been selected
     */
  isSelected: _propTypes.default.bool,

  /**
     * Indicates if the table has a dedicated column for icon-only actions
     * (affects mobile only)
     */
  hasActions: _propTypes.default.bool,

  /**
     * Indicates if the row will have an expanded row
     */
  isExpandable: _propTypes.default.bool,

  /**
     * Indicates if the row will be the expanded row
     */
  isExpandedRow: _propTypes.default.bool
};

try {
  EuiTableRow.__docgenInfo = {
    description: '',
    displayName: 'EuiTableRow',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isSelectable: {
        defaultValue: null,
        description: 'Indicates if the table has a single column of checkboxes for selecting\nrows (affects mobile only)',
        name: 'isSelectable',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Indicates the current row has been selected',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasActions: {
        defaultValue: null,
        description: 'Indicates if the table has a dedicated column for icon-only actions\n(affects mobile only)',
        name: 'hasActions',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandable: {
        defaultValue: null,
        description: 'Indicates if the row will have an expanded row',
        name: 'isExpandable',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandedRow: {
        defaultValue: null,
        description: 'Indicates if the row will be the expanded row',
        name: 'isExpandedRow',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}