"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiTabbedContent", {
  enumerable: true,
  get: function get() {
    return _tabbed_content.EuiTabbedContent;
  }
});

var _tabbed_content = require("./tabbed_content");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiTabbedContent.__docgenInfo = {
    description: '',
    displayName: 'EuiTabbedContent',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      autoFocus: {
        defaultValue: null,
        description: 'When tabbing into the tabs, set the focus on `initial` for the first tab,\nor `selected` for the currently selected tab. Best use case is for inside of\noverlay content like popovers or flyouts.',
        name: 'autoFocus',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"initial" | "selected"',
          value: [{
            value: '"initial"'
          }, {
            value: '"selected"'
          }]
        }
      },
      display: {
        defaultValue: null,
        description: 'Choose `default` or alternative `condensed` display styles',
        name: 'display',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "condensed"',
          value: [{
            value: '"default"'
          }, {
            value: '"condensed"'
          }]
        }
      },
      expand: {
        defaultValue: null,
        description: 'Evenly stretches each tab to fill the horizontal space',
        name: 'expand',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      initialSelectedTab: {
        defaultValue: null,
        description: 'Use this prop to set the initially selected tab while letting the tabbed content component\ncontrol selection state internally',
        name: 'initialSelectedTab',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiTabbedContentTab'
        }
      },
      onTabClick: {
        defaultValue: null,
        description: '',
        name: 'onTabClick',
        parent: undefined,
        required: false,
        type: {
          name: '(selectedTab: EuiTabbedContentTab) => void'
        }
      },
      selectedTab: {
        defaultValue: null,
        description: 'Use this prop if you want to control selection state within the owner component',
        name: 'selectedTab',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiTabbedContentTab'
        }
      },
      size: {
        defaultValue: null,
        description: '',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }]
        }
      },
      tabs: {
        defaultValue: null,
        description: 'Each tab needs id and content properties, so we can associate it with its panel for accessibility.\nThe name property (a node) is also required to display to the user.',
        name: 'tabs',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiTabbedContentTab[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}