"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEuiTextDiff = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _textDiff = _interopRequireDefault(require("text-diff"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var useEuiTextDiff = function useEuiTextDiff(_ref) {
  var className = _ref.className,
      _ref$insertComponent = _ref.insertComponent,
      insertComponent = _ref$insertComponent === void 0 ? 'ins' : _ref$insertComponent,
      _ref$deleteComponent = _ref.deleteComponent,
      deleteComponent = _ref$deleteComponent === void 0 ? 'del' : _ref$deleteComponent,
      sameComponent = _ref.sameComponent,
      _ref$beforeText = _ref.beforeText,
      beforeText = _ref$beforeText === void 0 ? '' : _ref$beforeText,
      _ref$afterText = _ref.afterText,
      afterText = _ref$afterText === void 0 ? '' : _ref$afterText,
      _ref$timeout = _ref.timeout,
      timeout = _ref$timeout === void 0 ? 0.1 : _ref$timeout,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "insertComponent", "deleteComponent", "sameComponent", "beforeText", "afterText", "timeout"]);
  var textDiff = (0, _react.useMemo)(function () {
    var diff = new _textDiff.default({
      timeout: timeout
    }); // options may be passed to constructor

    return diff.main(beforeText, afterText);
  }, [beforeText, afterText, timeout]); // produces diff array

  var classes = (0, _classnames.default)('euiTextDiff', className);
  var rendereredHtml = (0, _react.useMemo)(function () {
    var html = [];
    if (textDiff) for (var i = 0; i < textDiff.length; i++) {
      var Element = void 0;
      var el = textDiff[i];
      if (el[0] === 1) Element = insertComponent;else if (el[0] === -1) Element = deleteComponent;else if (sameComponent) Element = sameComponent;
      if (Element) html.push(_react.default.createElement(Element, {
        key: i
      }, el[1]));else html.push(el[1]);
    }
    return html;
  }, [textDiff, deleteComponent, insertComponent, sameComponent]); // produces diff array

  return [_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), rendereredHtml), textDiff];
};

exports.useEuiTextDiff = useEuiTextDiff;

try {
  useEuiTextDiff.__docgenInfo = {
    description: '',
    displayName: 'useEuiTextDiff',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      beforeText: {
        defaultValue: {
          value: ''
        },
        description: 'The starting string',
        name: 'beforeText',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      afterText: {
        defaultValue: {
          value: ''
        },
        description: 'The string used to compare against `beforeText`',
        name: 'afterText',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      insertComponent: {
        defaultValue: {
          value: 'ins'
        },
        description: 'HTML element to wrap insertion differences.\nDefaults to `ins`',
        name: 'insertComponent',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ElementType<any>'
        }
      },
      deleteComponent: {
        defaultValue: {
          value: 'del'
        },
        description: 'HTML element to wrap deletion differences.\nDefaults to `del`',
        name: 'deleteComponent',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ElementType<any>'
        }
      },
      sameComponent: {
        defaultValue: null,
        description: 'HTML element to wrap text with no differences.\nDoesn\'t wrap with anything by default',
        name: 'sameComponent',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ElementType<any>'
        }
      },
      timeout: {
        defaultValue: {
          value: '0.1'
        },
        description: 'Time in milliseconds. Passing a timeout of value \'0\' disables the timeout state',
        name: 'timeout',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}