"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiIconTip = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _icon = require("../icon");

var _tool_tip = require("./tool_tip");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiIconTip = function EuiIconTip(_ref) {
  var _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'questionInCircle' : _ref$type,
      _ref$ariaLabel = _ref['aria-label'],
      ariaLabel = _ref$ariaLabel === void 0 ? 'Info' : _ref$ariaLabel,
      color = _ref.color,
      size = _ref.size,
      iconProps = _ref.iconProps,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'top' : _ref$position,
      _ref$delay = _ref.delay,
      delay = _ref$delay === void 0 ? 'regular' : _ref$delay,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["type", "aria-label", "color", "size", "iconProps", "position", "delay"]);
  return _react.default.createElement(_tool_tip.EuiToolTip, (0, _extends2.default)({
    position: position,
    delay: delay
  }, rest), _react.default.createElement(_icon.EuiIcon, (0, _extends2.default)({
    tabIndex: 0,
    type: type,
    color: color,
    size: size,
    "aria-label": ariaLabel
  }, iconProps)));
};

exports.EuiIconTip = EuiIconTip;
EuiIconTip.propTypes = {
  /**
     * The icon color.
     */
  color: _propTypes.default.string,

  /**
     * The icon type.
     */
  type: _propTypes.default.oneOfType([_propTypes.default.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, _propTypes.default.string.isRequired, _propTypes.default.elementType.isRequired]),

  /**
     * The icon size.
     */
  size: _propTypes.default.oneOf(["original", "s", "m", "l", "xl", "xxl"]),

  /**
     * Explain what this icon means for screen readers.
     */
  "aria-label": _propTypes.default.string,

  /**
     * Pass certain props down to `EuiIcon`
     */
  // EuiIconTip's `type` is passed to EuiIcon, so we want to exclude `type` from
  // iconProps; however, due to TS's bivariant function arguments `type` could be
  // passed without any error/feedback so we explicitly set it to `never` type
  iconProps: _propTypes.default.any,
  // This are copied from EuiToolTipProps, but made optional. Defaults
  // are applied below.
  delay: _propTypes.default.any,
  position: _propTypes.default.any
};

try {
  EuiIconTip.__docgenInfo = {
    description: '',
    displayName: 'EuiIconTip',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: 'Passes onto the tooltip itself, not the trigger.',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      id: {
        defaultValue: null,
        description: 'Unless you provide one, this will be randomly generated.',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'An optional title for your tooltip.',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onMouseOut: {
        defaultValue: null,
        description: 'If supplied, called when mouse movement causes the tool tip to be\nhidden.',
        name: 'onMouseOut',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLSpanElement, MouseEvent>) => void'
        }
      },
      anchorClassName: {
        defaultValue: null,
        description: 'Passes onto the the trigger.',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      content: {
        defaultValue: null,
        description: 'The main content of your tooltip.',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      color: {
        defaultValue: null,
        description: 'The icon color.',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: {
          value: 'questionInCircle'
        },
        description: 'The icon type.',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      size: {
        defaultValue: null,
        description: 'The icon size.',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl" | "original" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"original"'
          }, {
            value: '"xxl"'
          }]
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Explain what this icon means for screen readers.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconProps: {
        defaultValue: null,
        description: 'Pass certain props down to `EuiIcon`',
        name: 'iconProps',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'Pick<EuiIconProps, "string" | "children" | "tabIndex" | "fill" | "color" | "size" | "className" | "aria-label" | "data-test-subj" | "href" | "onClick" | "media" | ... 459 more ... | "onIconLoad"> & { ...; }'
        }
      },
      delay: {
        defaultValue: {
          value: 'regular'
        },
        description: '',
        name: 'delay',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipDelay',
          value: [{
            value: '"regular"'
          }, {
            value: '"long"'
          }]
        }
      },
      position: {
        defaultValue: {
          value: 'top'
        },
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}