"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  EuiTour: true,
  EuiTourStep: true,
  EuiTourStepIndicator: true,
  useEuiTour: true
};
Object.defineProperty(exports, "EuiTour", {
  enumerable: true,
  get: function get() {
    return _tour.EuiTour;
  }
});
Object.defineProperty(exports, "EuiTourStep", {
  enumerable: true,
  get: function get() {
    return _tour_step.EuiTourStep;
  }
});
Object.defineProperty(exports, "EuiTourStepIndicator", {
  enumerable: true,
  get: function get() {
    return _tour_step_indicator.EuiTourStepIndicator;
  }
});
Object.defineProperty(exports, "useEuiTour", {
  enumerable: true,
  get: function get() {
    return _useEuiTour.useEuiTour;
  }
});

var _tour = require("./tour");

var _tour_step = require("./tour_step");

var _tour_step_indicator = require("./tour_step_indicator");

var _useEuiTour = require("./useEuiTour");

var _types = require("./types");

Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function get() {
      return _types[key];
    }
  });
});

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
try {
  EuiTour.__docgenInfo = {
    description: '',
    displayName: 'EuiTour',
    methods: [],
    props: {
      steps: {
        defaultValue: null,
        description: '',
        name: 'steps',
        parent: {
          fileName: 'eui/src/components/tour/tour.tsx',
          name: 'EuiTourProps'
        },
        required: true,
        type: {
          name: 'EuiStatelessTourStep[]'
        }
      },
      initialState: {
        defaultValue: null,
        description: '',
        name: 'initialState',
        parent: {
          fileName: 'eui/src/components/tour/tour.tsx',
          name: 'EuiTourProps'
        },
        required: true,
        type: {
          name: 'EuiTourState'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTourStep.__docgenInfo = {
    description: '',
    displayName: 'EuiTourStep',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'Element to which the tour step popover attaches when open',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      content: {
        defaultValue: null,
        description: 'Contents of the tour step popover',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      isStepOpen: {
        defaultValue: null,
        description: 'Step will display if set to `true`',
        name: 'isStepOpen',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      minWidth: {
        defaultValue: null,
        description: 'Sets the min-width of the tour popover,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'minWidth',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      onFinish: {
        defaultValue: null,
        description: 'Function to call for \'Skip tour\' and \'End tour\' actions',
        name: 'onFinish',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      step: {
        defaultValue: null,
        description: 'The number of the step within the parent tour. 1-based indexing.',
        name: 'step',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      stepsTotal: {
        defaultValue: null,
        description: 'The total number of steps in the tour',
        name: 'stepsTotal',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      style: {
        defaultValue: null,
        description: 'Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      subtitle: {
        defaultValue: null,
        description: 'Smaller title text that appears atop each step in the tour',
        name: 'subtitle',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'Larger title text specific to this step',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      decoration: {
        defaultValue: null,
        description: 'Extra visual indication of step location',
        name: 'decoration',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"none" | "beacon"',
          value: [{
            value: '"none"'
          }, {
            value: '"beacon"'
          }]
        }
      },
      footerAction: {
        defaultValue: null,
        description: 'Element to replace the \'Skip tour\' link in the footer',
        name: 'footerAction',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLDivElement) => void'
        }
      },
      display: {
        defaultValue: null,
        description: 'CSS display type for both the popover and anchor',
        name: 'display',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"inlineBlock" | "block"',
          value: [{
            value: '"inlineBlock"'
          }, {
            value: '"block"'
          }]
        }
      },
      offset: {
        defaultValue: null,
        description: 'Distance away from the anchor that the popover will render.',
        name: 'offset',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      isOpen: {
        defaultValue: null,
        description: '',
        name: 'isOpen',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      panelRef: {
        defaultValue: null,
        description: '',
        name: 'panelRef',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLElement) => void'
        }
      },
      zIndex: {
        defaultValue: null,
        description: 'By default, popover content inherits the z-index of the anchor\ncomponent; pass zIndex to override',
        name: 'zIndex',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      anchorClassName: {
        defaultValue: null,
        description: '',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      ownFocus: {
        defaultValue: null,
        description: '',
        name: 'ownFocus',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      initialFocus: {
        defaultValue: null,
        description: 'specifies what element should initially have focus; Can be a DOM\nnode, or a selector string (which will be passed to\ndocument.querySelector() to find the DOM node), or a function that\nreturns a DOM node.',
        name: 'initialFocus',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'FocusTarget'
        }
      },
      panelPaddingSize: {
        defaultValue: null,
        description: '',
        name: 'panelPaddingSize',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      anchorPosition: {
        defaultValue: null,
        description: '',
        name: 'anchorPosition',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'PopoverAnchorPosition',
          value: [{
            value: '"upCenter"'
          }, {
            value: '"upLeft"'
          }, {
            value: '"upRight"'
          }, {
            value: '"downCenter"'
          }, {
            value: '"downLeft"'
          }, {
            value: '"downRight"'
          }, {
            value: '"leftCenter"'
          }, {
            value: '"leftUp"'
          }, {
            value: '"leftDown"'
          }, {
            value: '"rightCenter"'
          }, {
            value: '"rightUp"'
          }, {
            value: '"rightDown"'
          }]
        }
      },
      attachToAnchor: {
        defaultValue: null,
        description: 'Style and position alteration for arrow-less, left-aligned\nattachment. Intended for use with inputs as anchors, à la\nEuiColorPicker',
        name: 'attachToAnchor',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      container: {
        defaultValue: null,
        description: '',
        name: 'container',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'HTMLElement'
        }
      },
      hasArrow: {
        defaultValue: null,
        description: '',
        name: 'hasArrow',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      insert: {
        defaultValue: null,
        description: 'Passed directly to EuiPortal for DOM positioning. Both properties are\nrequired if prop is specified *',
        name: 'insert',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '{ sibling: HTMLElement; position: "before" | "after"; }'
        }
      },
      panelClassName: {
        defaultValue: null,
        description: '',
        name: 'panelClassName',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      panelStyle: {
        defaultValue: null,
        description: 'Optional, standard DOM `style` attribute. Passed to the EuiPanel.',
        name: 'panelStyle',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      popoverRef: {
        defaultValue: null,
        description: '',
        name: 'popoverRef',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'Ref<HTMLDivElement>'
        }
      },
      repositionOnScroll: {
        defaultValue: null,
        description: 'When `true`, the popover\'s position is re-calculated when the user\nscrolls, this supports having fixed-position popover anchors.',
        name: 'repositionOnScroll',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      withTitle: {
        defaultValue: null,
        description: '',
        name: 'withTitle',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onTrapDeactivation: {
        defaultValue: null,
        description: 'Function callback for when the focus trap is deactivated',
        name: 'onTrapDeactivation',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      buffer: {
        defaultValue: null,
        description: 'Minimum distance between the popover and the bounding container.\nDefault is 16',
        name: 'buffer',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      arrowChildren: {
        defaultValue: null,
        description: 'Element to pass as the child element of the arrow. Use case is typically limited to an accompanying `EuiBeacon`',
        name: 'arrowChildren',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      button: {
        defaultValue: null,
        description: '',
        name: 'button',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      closePopover: {
        defaultValue: null,
        description: '',
        name: 'closePopover',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiTourStepIndicator.__docgenInfo = {
    description: '',
    displayName: 'EuiTourStepIndicator',
    methods: [],
    props: {
      number: {
        defaultValue: null,
        description: '',
        name: 'number',
        parent: {
          fileName: 'eui/src/components/tour/tour_step_indicator.tsx',
          name: 'EuiTourStepIndicatorProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      status: {
        defaultValue: null,
        description: '',
        name: 'status',
        parent: {
          fileName: 'eui/src/components/tour/tour_step_indicator.tsx',
          name: 'EuiTourStepIndicatorProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"complete" | "incomplete" | "active"',
          value: [{
            value: '"complete"'
          }, {
            value: '"incomplete"'
          }, {
            value: '"active"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}