"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStep = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _beacon = require("../beacon");

var _button = require("../button");

var _flex = require("../flex");

var _i18n = require("../i18n");

var _popover = require("../popover");

var _title = require("../title");

var _tour_step_indicator = require("./tour_step_indicator");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var EuiTourStep = function EuiTourStep(_ref) {
  var _ref$anchorPosition = _ref.anchorPosition,
      anchorPosition = _ref$anchorPosition === void 0 ? 'leftUp' : _ref$anchorPosition,
      children = _ref.children,
      className = _ref.className,
      _ref$closePopover = _ref.closePopover,
      closePopover = _ref$closePopover === void 0 ? function () {} : _ref$closePopover,
      content = _ref.content,
      _ref$isStepOpen = _ref.isStepOpen,
      isStepOpen = _ref$isStepOpen === void 0 ? false : _ref$isStepOpen,
      _ref$minWidth = _ref.minWidth,
      minWidth = _ref$minWidth === void 0 ? true : _ref$minWidth,
      onFinish = _ref.onFinish,
      _ref$step = _ref.step,
      step = _ref$step === void 0 ? 1 : _ref$step,
      stepsTotal = _ref.stepsTotal,
      style = _ref.style,
      subtitle = _ref.subtitle,
      title = _ref.title,
      _ref$decoration = _ref.decoration,
      decoration = _ref$decoration === void 0 ? 'beacon' : _ref$decoration,
      footerAction = _ref.footerAction,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["anchorPosition", "children", "className", "closePopover", "content", "isStepOpen", "minWidth", "onFinish", "step", "stepsTotal", "style", "subtitle", "title", "decoration", "footerAction"]);

  if (step === 0) {
    console.warn('EuiTourStep `step` should 1-based indexing. Please update to eliminate 0 indexes.');
  }

  var newStyle;
  var widthClassName;

  if (minWidth === true) {
    widthClassName = 'euiTour--minWidth-default';
  } else if (minWidth !== false) {
    var value = typeof minWidth === 'number' ? "".concat(minWidth, "px") : minWidth;
    newStyle = _objectSpread({}, style, {
      minWidth: value
    });
  }

  var classes = (0, _classnames.default)('euiTour', widthClassName, className);
  var finishButtonProps = {
    color: 'text',
    flush: 'right',
    size: 'xs'
  };

  var footer = _react.default.createElement(_flex.EuiFlexGroup, {
    responsive: false,
    justifyContent: stepsTotal > 1 ? 'spaceBetween' : 'flexEnd'
  }, stepsTotal > 1 && _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, _react.default.createElement("ul", {
    className: "euiTourFooter__stepList"
  }, (0, _toConsumableArray2.default)(Array(stepsTotal).keys()).map(function (_, i) {
    var status = 'complete';

    if (step === i + 1) {
      status = 'active';
    } else if (step <= i) {
      status = 'incomplete';
    }

    return _react.default.createElement(_tour_step_indicator.EuiTourStepIndicator, {
      key: i,
      number: i + 1,
      status: status
    });
  }))), footerAction ? _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, footerAction) : _react.default.createElement(_flex.EuiFlexItem, {
    grow: false
  }, _react.default.createElement(_i18n.EuiI18n, {
    tokens: ['euiTourStep.endTour', 'euiTourStep.skipTour', 'euiTourStep.closeTour'],
    defaults: ['End tour', 'Skip tour', 'Close']
  }, function (_ref2) {
    var _ref3 = (0, _slicedToArray2.default)(_ref2, 3),
        endTour = _ref3[0],
        skipTour = _ref3[1],
        closeTour = _ref3[2];

    var content = closeTour;

    if (stepsTotal > 1) {
      content = stepsTotal === step ? endTour : skipTour;
    }

    return _react.default.createElement(_button.EuiButtonEmpty, (0, _extends2.default)({
      onClick: onFinish
    }, finishButtonProps), content);
  })));

  var hasBeacon = decoration === 'beacon';
  return _react.default.createElement(_popover.EuiPopover, (0, _extends2.default)({
    anchorPosition: anchorPosition,
    button: children,
    closePopover: closePopover,
    isOpen: isStepOpen,
    panelClassName: classes,
    panelStyle: newStyle || style,
    offset: hasBeacon ? 10 : 0,
    arrowChildren: hasBeacon && _react.default.createElement(_beacon.EuiBeacon, {
      className: "euiTour__beacon"
    }),
    withTitle: true
  }, rest), _react.default.createElement(_popover.EuiPopoverTitle, {
    className: "euiTourHeader"
  }, _react.default.createElement(_title.EuiTitle, {
    size: "xxxs",
    className: "euiTourHeader__subtitle"
  }, _react.default.createElement("h1", null, subtitle)), _react.default.createElement(_title.EuiTitle, {
    size: "xxs",
    className: "euiTourHeader__title"
  }, _react.default.createElement("h2", null, title))), _react.default.createElement("div", {
    className: "euiTour__content"
  }, content), _react.default.createElement(_popover.EuiPopoverFooter, {
    className: "euiTourFooter"
  }, footer));
};

exports.EuiTourStep = EuiTourStep;
EuiTourStep.propTypes = {
  /**
     * Element to which the tour step popover attaches when open
     */
  children: _propTypes.default.element.isRequired,

  /**
     * Contents of the tour step popover
     */
  content: _propTypes.default.node.isRequired,

  /**
     * Step will display if set to `true`
     */
  isStepOpen: _propTypes.default.bool,

  /**
     * Sets the min-width of the tour popover,
     * set to `true` to use the default size,
     * set to `false` to not restrict the width,
     * set to a number for a custom width in px,
     * set to a string for a custom width in custom measurement.
     */
  minWidth: _propTypes.default.oneOfType([_propTypes.default.bool.isRequired, _propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Function to call for 'Skip tour' and 'End tour' actions
     */
  onFinish: _propTypes.default.func.isRequired,

  /**
     * The number of the step within the parent tour. 1-based indexing.
     */
  step: _propTypes.default.number.isRequired,

  /**
     * The total number of steps in the tour
     */
  stepsTotal: _propTypes.default.number.isRequired,

  /**
     * Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.
     */
  style: _propTypes.default.any,

  /**
     * Smaller title text that appears atop each step in the tour
     */
  subtitle: _propTypes.default.string.isRequired,

  /**
     * Larger title text specific to this step
     */
  title: _propTypes.default.string.isRequired,

  /**
     * Extra visual indication of step location
     */
  decoration: _propTypes.default.oneOf(["none", "beacon"]),

  /**
     * Element to replace the 'Skip tour' link in the footer
     */
  footerAction: _propTypes.default.element,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiTourStep.__docgenInfo = {
    description: '',
    displayName: 'EuiTourStep',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'Element to which the tour step popover attaches when open',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      content: {
        defaultValue: null,
        description: 'Contents of the tour step popover',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      isStepOpen: {
        defaultValue: {
          value: 'false'
        },
        description: 'Step will display if set to `true`',
        name: 'isStepOpen',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      minWidth: {
        defaultValue: {
          value: 'true'
        },
        description: 'Sets the min-width of the tour popover,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'minWidth',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      onFinish: {
        defaultValue: null,
        description: 'Function to call for \'Skip tour\' and \'End tour\' actions',
        name: 'onFinish',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      step: {
        defaultValue: {
          value: '1'
        },
        description: 'The number of the step within the parent tour. 1-based indexing.',
        name: 'step',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      stepsTotal: {
        defaultValue: null,
        description: 'The total number of steps in the tour',
        name: 'stepsTotal',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      style: {
        defaultValue: null,
        description: 'Optional, standard DOM `style` attribute. Passed to the EuiPopover panel.',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      subtitle: {
        defaultValue: null,
        description: 'Smaller title text that appears atop each step in the tour',
        name: 'subtitle',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'Larger title text specific to this step',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      decoration: {
        defaultValue: {
          value: 'beacon'
        },
        description: 'Extra visual indication of step location',
        name: 'decoration',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"none" | "beacon"',
          value: [{
            value: '"none"'
          }, {
            value: '"beacon"'
          }]
        }
      },
      footerAction: {
        defaultValue: null,
        description: 'Element to replace the \'Skip tour\' link in the footer',
        name: 'footerAction',
        parent: {
          fileName: 'eui/src/components/tour/tour_step.tsx',
          name: 'EuiTourStepProps'
        },
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLDivElement) => void'
        }
      },
      display: {
        defaultValue: null,
        description: 'CSS display type for both the popover and anchor',
        name: 'display',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"inlineBlock" | "block"',
          value: [{
            value: '"inlineBlock"'
          }, {
            value: '"block"'
          }]
        }
      },
      offset: {
        defaultValue: null,
        description: 'Distance away from the anchor that the popover will render.',
        name: 'offset',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      isOpen: {
        defaultValue: null,
        description: '',
        name: 'isOpen',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      panelRef: {
        defaultValue: null,
        description: '',
        name: 'panelRef',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '(instance: HTMLElement) => void'
        }
      },
      zIndex: {
        defaultValue: null,
        description: 'By default, popover content inherits the z-index of the anchor\ncomponent; pass zIndex to override',
        name: 'zIndex',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      anchorClassName: {
        defaultValue: null,
        description: '',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      ownFocus: {
        defaultValue: null,
        description: '',
        name: 'ownFocus',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      initialFocus: {
        defaultValue: null,
        description: 'specifies what element should initially have focus; Can be a DOM\nnode, or a selector string (which will be passed to\ndocument.querySelector() to find the DOM node), or a function that\nreturns a DOM node.',
        name: 'initialFocus',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'FocusTarget'
        }
      },
      panelPaddingSize: {
        defaultValue: null,
        description: '',
        name: 'panelPaddingSize',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      anchorPosition: {
        defaultValue: {
          value: 'leftUp'
        },
        description: '',
        name: 'anchorPosition',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'PopoverAnchorPosition',
          value: [{
            value: '"upCenter"'
          }, {
            value: '"upLeft"'
          }, {
            value: '"upRight"'
          }, {
            value: '"downCenter"'
          }, {
            value: '"downLeft"'
          }, {
            value: '"downRight"'
          }, {
            value: '"leftCenter"'
          }, {
            value: '"leftUp"'
          }, {
            value: '"leftDown"'
          }, {
            value: '"rightCenter"'
          }, {
            value: '"rightUp"'
          }, {
            value: '"rightDown"'
          }]
        }
      },
      attachToAnchor: {
        defaultValue: null,
        description: 'Style and position alteration for arrow-less, left-aligned\nattachment. Intended for use with inputs as anchors, à la\nEuiColorPicker',
        name: 'attachToAnchor',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      container: {
        defaultValue: null,
        description: '',
        name: 'container',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'HTMLElement'
        }
      },
      hasArrow: {
        defaultValue: null,
        description: '',
        name: 'hasArrow',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      insert: {
        defaultValue: null,
        description: 'Passed directly to EuiPortal for DOM positioning. Both properties are\nrequired if prop is specified *',
        name: 'insert',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '{ sibling: HTMLElement; position: "before" | "after"; }'
        }
      },
      panelClassName: {
        defaultValue: null,
        description: '',
        name: 'panelClassName',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      panelStyle: {
        defaultValue: null,
        description: 'Optional, standard DOM `style` attribute. Passed to the EuiPanel.',
        name: 'panelStyle',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      popoverRef: {
        defaultValue: null,
        description: '',
        name: 'popoverRef',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'Ref<HTMLDivElement>'
        }
      },
      repositionOnScroll: {
        defaultValue: null,
        description: 'When `true`, the popover\'s position is re-calculated when the user\nscrolls, this supports having fixed-position popover anchors.',
        name: 'repositionOnScroll',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      withTitle: {
        defaultValue: null,
        description: '',
        name: 'withTitle',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onTrapDeactivation: {
        defaultValue: null,
        description: 'Function callback for when the focus trap is deactivated',
        name: 'onTrapDeactivation',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      buffer: {
        defaultValue: null,
        description: 'Minimum distance between the popover and the bounding container.\nDefault is 16',
        name: 'buffer',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      arrowChildren: {
        defaultValue: null,
        description: 'Element to pass as the child element of the arrow. Use case is typically limited to an accompanying `EuiBeacon`',
        name: 'arrowChildren',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      button: {
        defaultValue: null,
        description: '',
        name: 'button',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      closePopover: {
        defaultValue: {
          value: '() => {}'
        },
        description: '',
        name: 'closePopover',
        parent: {
          fileName: 'eui/src/components/popover/popover.tsx',
          name: 'EuiPopoverProps'
        },
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      }
    },
    extends: []
  };
} catch (e) {}