"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTourStepIndicator = exports.STATUS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon = require("../icon");

var _i18n = require("../i18n");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var statusToClassNameMap = {
  complete: 'euiTourStepIndicator--complete',
  incomplete: 'euiTourStepIndicator--incomplete',
  active: 'euiTourStepIndicator--active'
};
var STATUS = (0, _common.keysOf)(statusToClassNameMap);
exports.STATUS = STATUS;

var EuiTourStepIndicator = function EuiTourStepIndicator(_ref) {
  var className = _ref.className,
      number = _ref.number,
      status = _ref.status,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "number", "status"]);
  var classes = (0, _classnames.default)('euiTourStepIndicator', status ? statusToClassNameMap[status] : undefined, className);
  var indicatorIcon;

  if (status === 'active') {
    indicatorIcon = _react.default.createElement(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isActive",
      default: "active"
    }, function (isActive) {
      return _react.default.createElement(_icon.EuiIcon, {
        type: "dot",
        className: "euiStepNumber__icon",
        "aria-label": isActive,
        color: "secondary",
        "aria-current": "step"
      });
    });
  } else if (status === 'complete') {
    indicatorIcon = _react.default.createElement(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isComplete",
      default: "complete"
    }, function (isComplete) {
      return _react.default.createElement(_icon.EuiIcon, {
        type: "dot",
        className: "euiStepNumber__icon",
        "aria-label": isComplete,
        color: "subdued"
      });
    });
  } else if (status === 'incomplete') {
    indicatorIcon = _react.default.createElement(_i18n.EuiI18n, {
      token: "euiTourStepIndicator.isIncomplete",
      default: "incomplete"
    }, function (isIncomplete) {
      return _react.default.createElement(_icon.EuiIcon, {
        type: "dot",
        className: "euiStepNumber__icon",
        "aria-label": isIncomplete,
        color: "subdued"
      });
    });
  }

  return _react.default.createElement(_i18n.EuiI18n, {
    token: "euiTourStepIndicator.ariaLabel",
    default: function _default(_ref2) {
      var status = _ref2.status;
      return "Step ".concat(number, " ").concat(status);
    },
    values: {
      status: status
    }
  }, function (ariaLabel) {
    return _react.default.createElement("li", (0, _extends2.default)({
      className: classes,
      "aria-label": ariaLabel
    }, rest), indicatorIcon);
  });
};

exports.EuiTourStepIndicator = EuiTourStepIndicator;
EuiTourStepIndicator.propTypes = {
  number: _propTypes.default.number.isRequired,
  status: _propTypes.default.oneOf(["complete", "incomplete", "active"]).isRequired,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};

try {
  EuiTourStepIndicator.__docgenInfo = {
    description: '',
    displayName: 'EuiTourStepIndicator',
    methods: [],
    props: {
      number: {
        defaultValue: null,
        description: '',
        name: 'number',
        parent: {
          fileName: 'eui/src/components/tour/tour_step_indicator.tsx',
          name: 'EuiTourStepIndicatorProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      status: {
        defaultValue: null,
        description: '',
        name: 'status',
        parent: {
          fileName: 'eui/src/components/tour/tour_step_indicator.tsx',
          name: 'EuiTourStepIndicatorProps'
        },
        required: true,
        type: {
          name: 'enum',
          raw: '"complete" | "incomplete" | "active"',
          value: [{
            value: '"complete"'
          }, {
            value: '"incomplete"'
          }, {
            value: '"active"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}