/*! Element Plus v2.1.0 */

(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('vue')) :
  typeof define === 'function' && define.amd ? define(['exports', 'vue'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.ElementPlus = {}, global.Vue));
})(this, (function (exports, vue) { 'use strict';

  var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
  var freeGlobal$1 = freeGlobal;

  var freeSelf = typeof self == "object" && self && self.Object === Object && self;
  var root = freeGlobal$1 || freeSelf || Function("return this")();
  var root$1 = root;

  var Symbol$1 = root$1.Symbol;
  var Symbol$2 = Symbol$1;

  var objectProto$e = Object.prototype;
  var hasOwnProperty$c = objectProto$e.hasOwnProperty;
  var nativeObjectToString$1 = objectProto$e.toString;
  var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function getRawTag(value) {
    var isOwn = hasOwnProperty$c.call(value, symToStringTag$1), tag = value[symToStringTag$1];
    try {
      value[symToStringTag$1] = void 0;
      var unmasked = true;
    } catch (e) {
    }
    var result = nativeObjectToString$1.call(value);
    if (unmasked) {
      if (isOwn) {
        value[symToStringTag$1] = tag;
      } else {
        delete value[symToStringTag$1];
      }
    }
    return result;
  }

  var objectProto$d = Object.prototype;
  var nativeObjectToString = objectProto$d.toString;
  function objectToString$1(value) {
    return nativeObjectToString.call(value);
  }

  var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
  var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function baseGetTag(value) {
    if (value == null) {
      return value === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value) ? getRawTag(value) : objectToString$1(value);
  }

  function isObjectLike(value) {
    return value != null && typeof value == "object";
  }

  var symbolTag$3 = "[object Symbol]";
  function isSymbol(value) {
    return typeof value == "symbol" || isObjectLike(value) && baseGetTag(value) == symbolTag$3;
  }

  function arrayMap(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length, result = Array(length);
    while (++index < length) {
      result[index] = iteratee(array[index], index, array);
    }
    return result;
  }

  var isArray$1 = Array.isArray;
  var isArray$2 = isArray$1;

  var INFINITY$3 = 1 / 0;
  var symbolProto$2 = Symbol$2 ? Symbol$2.prototype : void 0, symbolToString = symbolProto$2 ? symbolProto$2.toString : void 0;
  function baseToString(value) {
    if (typeof value == "string") {
      return value;
    }
    if (isArray$2(value)) {
      return arrayMap(value, baseToString) + "";
    }
    if (isSymbol(value)) {
      return symbolToString ? symbolToString.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY$3 ? "-0" : result;
  }

  var reWhitespace = /\s/;
  function trimmedEndIndex(string) {
    var index = string.length;
    while (index-- && reWhitespace.test(string.charAt(index))) {
    }
    return index;
  }

  var reTrimStart = /^\s+/;
  function baseTrim(string) {
    return string ? string.slice(0, trimmedEndIndex(string) + 1).replace(reTrimStart, "") : string;
  }

  function isObject$2(value) {
    var type = typeof value;
    return value != null && (type == "object" || type == "function");
  }

  var NAN = 0 / 0;
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
  var reIsBinary = /^0b[01]+$/i;
  var reIsOctal = /^0o[0-7]+$/i;
  var freeParseInt = parseInt;
  function toNumber(value) {
    if (typeof value == "number") {
      return value;
    }
    if (isSymbol(value)) {
      return NAN;
    }
    if (isObject$2(value)) {
      var other = typeof value.valueOf == "function" ? value.valueOf() : value;
      value = isObject$2(other) ? other + "" : other;
    }
    if (typeof value != "string") {
      return value === 0 ? value : +value;
    }
    value = baseTrim(value);
    var isBinary = reIsBinary.test(value);
    return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
  }

  function identity(value) {
    return value;
  }

  var asyncTag = "[object AsyncFunction]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
  function isFunction$1(value) {
    if (!isObject$2(value)) {
      return false;
    }
    var tag = baseGetTag(value);
    return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
  }

  var coreJsData = root$1["__core-js_shared__"];
  var coreJsData$1 = coreJsData;

  var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
  }();
  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }

  var funcProto$1 = Function.prototype;
  var funcToString$1 = funcProto$1.toString;
  function toSource(func) {
    if (func != null) {
      try {
        return funcToString$1.call(func);
      } catch (e) {
      }
      try {
        return func + "";
      } catch (e) {
      }
    }
    return "";
  }

  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  var funcProto = Function.prototype, objectProto$c = Object.prototype;
  var funcToString = funcProto.toString;
  var hasOwnProperty$b = objectProto$c.hasOwnProperty;
  var reIsNative = RegExp("^" + funcToString.call(hasOwnProperty$b).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
  function baseIsNative(value) {
    if (!isObject$2(value) || isMasked(value)) {
      return false;
    }
    var pattern = isFunction$1(value) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value));
  }

  function getValue$1(object, key) {
    return object == null ? void 0 : object[key];
  }

  function getNative(object, key) {
    var value = getValue$1(object, key);
    return baseIsNative(value) ? value : void 0;
  }

  var WeakMap = getNative(root$1, "WeakMap");
  var WeakMap$1 = WeakMap;

  var objectCreate = Object.create;
  var baseCreate = function() {
    function object() {
    }
    return function(proto) {
      if (!isObject$2(proto)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto);
      }
      object.prototype = proto;
      var result = new object();
      object.prototype = void 0;
      return result;
    };
  }();
  var baseCreate$1 = baseCreate;

  function apply(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }

  function noop$1() {
  }

  function copyArray(source, array) {
    var index = -1, length = source.length;
    array || (array = Array(length));
    while (++index < length) {
      array[index] = source[index];
    }
    return array;
  }

  var HOT_COUNT = 800, HOT_SPAN = 16;
  var nativeNow = Date.now;
  function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
      var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
      lastCalled = stamp;
      if (remaining > 0) {
        if (++count >= HOT_COUNT) {
          return arguments[0];
        }
      } else {
        count = 0;
      }
      return func.apply(void 0, arguments);
    };
  }

  function constant(value) {
    return function() {
      return value;
    };
  }

  var defineProperty = function() {
    try {
      var func = getNative(Object, "defineProperty");
      func({}, "", {});
      return func;
    } catch (e) {
    }
  }();
  var defineProperty$1 = defineProperty;

  var baseSetToString = !defineProperty$1 ? identity : function(func, string) {
    return defineProperty$1(func, "toString", {
      "configurable": true,
      "enumerable": false,
      "value": constant(string),
      "writable": true
    });
  };
  var baseSetToString$1 = baseSetToString;

  var setToString = shortOut(baseSetToString$1);
  var setToString$1 = setToString;

  function arrayEach(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length;
    while (++index < length) {
      if (iteratee(array[index], index, array) === false) {
        break;
      }
    }
    return array;
  }

  function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
    while (fromRight ? index-- : ++index < length) {
      if (predicate(array[index], index, array)) {
        return index;
      }
    }
    return -1;
  }

  function baseIsNaN(value) {
    return value !== value;
  }

  function strictIndexOf(array, value, fromIndex) {
    var index = fromIndex - 1, length = array.length;
    while (++index < length) {
      if (array[index] === value) {
        return index;
      }
    }
    return -1;
  }

  function baseIndexOf(array, value, fromIndex) {
    return value === value ? strictIndexOf(array, value, fromIndex) : baseFindIndex(array, baseIsNaN, fromIndex);
  }

  function arrayIncludes(array, value) {
    var length = array == null ? 0 : array.length;
    return !!length && baseIndexOf(array, value, 0) > -1;
  }

  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  var reIsUint = /^(?:0|[1-9]\d*)$/;
  function isIndex(value, length) {
    var type = typeof value;
    length = length == null ? MAX_SAFE_INTEGER$1 : length;
    return !!length && (type == "number" || type != "symbol" && reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
  }

  function baseAssignValue(object, key, value) {
    if (key == "__proto__" && defineProperty$1) {
      defineProperty$1(object, key, {
        "configurable": true,
        "enumerable": true,
        "value": value,
        "writable": true
      });
    } else {
      object[key] = value;
    }
  }

  function eq(value, other) {
    return value === other || value !== value && other !== other;
  }

  var objectProto$b = Object.prototype;
  var hasOwnProperty$a = objectProto$b.hasOwnProperty;
  function assignValue(object, key, value) {
    var objValue = object[key];
    if (!(hasOwnProperty$a.call(object, key) && eq(objValue, value)) || value === void 0 && !(key in object)) {
      baseAssignValue(object, key, value);
    }
  }

  function copyObject(source, props, object, customizer) {
    var isNew = !object;
    object || (object = {});
    var index = -1, length = props.length;
    while (++index < length) {
      var key = props[index];
      var newValue = customizer ? customizer(object[key], source[key], key, object, source) : void 0;
      if (newValue === void 0) {
        newValue = source[key];
      }
      if (isNew) {
        baseAssignValue(object, key, newValue);
      } else {
        assignValue(object, key, newValue);
      }
    }
    return object;
  }

  var nativeMax$1 = Math.max;
  function overRest(func, start, transform) {
    start = nativeMax$1(start === void 0 ? func.length - 1 : start, 0);
    return function() {
      var args = arguments, index = -1, length = nativeMax$1(args.length - start, 0), array = Array(length);
      while (++index < length) {
        array[index] = args[start + index];
      }
      index = -1;
      var otherArgs = Array(start + 1);
      while (++index < start) {
        otherArgs[index] = args[index];
      }
      otherArgs[start] = transform(array);
      return apply(func, this, otherArgs);
    };
  }

  function baseRest(func, start) {
    return setToString$1(overRest(func, start, identity), func + "");
  }

  var MAX_SAFE_INTEGER = 9007199254740991;
  function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
  }

  function isArrayLike(value) {
    return value != null && isLength(value.length) && !isFunction$1(value);
  }

  var objectProto$a = Object.prototype;
  function isPrototype(value) {
    var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$a;
    return value === proto;
  }

  function baseTimes(n, iteratee) {
    var index = -1, result = Array(n);
    while (++index < n) {
      result[index] = iteratee(index);
    }
    return result;
  }

  var argsTag$3 = "[object Arguments]";
  function baseIsArguments(value) {
    return isObjectLike(value) && baseGetTag(value) == argsTag$3;
  }

  var objectProto$9 = Object.prototype;
  var hasOwnProperty$9 = objectProto$9.hasOwnProperty;
  var propertyIsEnumerable$1 = objectProto$9.propertyIsEnumerable;
  var isArguments = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value) {
    return isObjectLike(value) && hasOwnProperty$9.call(value, "callee") && !propertyIsEnumerable$1.call(value, "callee");
  };
  var isArguments$1 = isArguments;

  function stubFalse() {
    return false;
  }

  var freeExports$2 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$2 = freeExports$2 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
  var Buffer$1 = moduleExports$2 ? root$1.Buffer : void 0;
  var nativeIsBuffer = Buffer$1 ? Buffer$1.isBuffer : void 0;
  var isBuffer = nativeIsBuffer || stubFalse;
  var isBuffer$1 = isBuffer;

  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", funcTag$1 = "[object Function]", mapTag$5 = "[object Map]", numberTag$3 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$3 = "[object RegExp]", setTag$5 = "[object Set]", stringTag$3 = "[object String]", weakMapTag$2 = "[object WeakMap]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$3] = typedArrayTags[boolTag$3] = typedArrayTags[dataViewTag$4] = typedArrayTags[dateTag$3] = typedArrayTags[errorTag$2] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag$5] = typedArrayTags[numberTag$3] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$3] = typedArrayTags[setTag$5] = typedArrayTags[stringTag$3] = typedArrayTags[weakMapTag$2] = false;
  function baseIsTypedArray(value) {
    return isObjectLike(value) && isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
  }

  function baseUnary(func) {
    return function(value) {
      return func(value);
    };
  }

  var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
  var freeProcess = moduleExports$1 && freeGlobal$1.process;
  var nodeUtil = function() {
    try {
      var types = freeModule$1 && freeModule$1.require && freeModule$1.require("util").types;
      if (types) {
        return types;
      }
      return freeProcess && freeProcess.binding && freeProcess.binding("util");
    } catch (e) {
    }
  }();
  var nodeUtil$1 = nodeUtil;

  var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
  var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
  var isTypedArray$1 = isTypedArray;

  var objectProto$8 = Object.prototype;
  var hasOwnProperty$8 = objectProto$8.hasOwnProperty;
  function arrayLikeKeys(value, inherited) {
    var isArr = isArray$2(value), isArg = !isArr && isArguments$1(value), isBuff = !isArr && !isArg && isBuffer$1(value), isType = !isArr && !isArg && !isBuff && isTypedArray$1(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value.length, String) : [], length = result.length;
    for (var key in value) {
      if ((inherited || hasOwnProperty$8.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || isIndex(key, length)))) {
        result.push(key);
      }
    }
    return result;
  }

  function overArg(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }

  var nativeKeys = overArg(Object.keys, Object);
  var nativeKeys$1 = nativeKeys;

  var objectProto$7 = Object.prototype;
  var hasOwnProperty$7 = objectProto$7.hasOwnProperty;
  function baseKeys(object) {
    if (!isPrototype(object)) {
      return nativeKeys$1(object);
    }
    var result = [];
    for (var key in Object(object)) {
      if (hasOwnProperty$7.call(object, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }

  function keys(object) {
    return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
  }

  function nativeKeysIn(object) {
    var result = [];
    if (object != null) {
      for (var key in Object(object)) {
        result.push(key);
      }
    }
    return result;
  }

  var objectProto$6 = Object.prototype;
  var hasOwnProperty$6 = objectProto$6.hasOwnProperty;
  function baseKeysIn(object) {
    if (!isObject$2(object)) {
      return nativeKeysIn(object);
    }
    var isProto = isPrototype(object), result = [];
    for (var key in object) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty$6.call(object, key)))) {
        result.push(key);
      }
    }
    return result;
  }

  function keysIn(object) {
    return isArrayLike(object) ? arrayLikeKeys(object, true) : baseKeysIn(object);
  }

  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
  function isKey(value, object) {
    if (isArray$2(value)) {
      return false;
    }
    var type = typeof value;
    if (type == "number" || type == "symbol" || type == "boolean" || value == null || isSymbol(value)) {
      return true;
    }
    return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
  }

  var nativeCreate = getNative(Object, "create");
  var nativeCreate$1 = nativeCreate;

  function hashClear() {
    this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
    this.size = 0;
  }

  function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }

  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  var objectProto$5 = Object.prototype;
  var hasOwnProperty$5 = objectProto$5.hasOwnProperty;
  function hashGet(key) {
    var data = this.__data__;
    if (nativeCreate$1) {
      var result = data[key];
      return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$5.call(data, key) ? data[key] : void 0;
  }

  var objectProto$4 = Object.prototype;
  var hasOwnProperty$4 = objectProto$4.hasOwnProperty;
  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate$1 ? data[key] !== void 0 : hasOwnProperty$4.call(data, key);
  }

  var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
  function hashSet(key, value) {
    var data = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data[key] = nativeCreate$1 && value === void 0 ? HASH_UNDEFINED$1 : value;
    return this;
  }

  function Hash(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  Hash.prototype.clear = hashClear;
  Hash.prototype["delete"] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;

  function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
  }

  function assocIndexOf(array, key) {
    var length = array.length;
    while (length--) {
      if (eq(array[length][0], key)) {
        return length;
      }
    }
    return -1;
  }

  var arrayProto = Array.prototype;
  var splice = arrayProto.splice;
  function listCacheDelete(key) {
    var data = this.__data__, index = assocIndexOf(data, key);
    if (index < 0) {
      return false;
    }
    var lastIndex = data.length - 1;
    if (index == lastIndex) {
      data.pop();
    } else {
      splice.call(data, index, 1);
    }
    --this.size;
    return true;
  }

  function listCacheGet(key) {
    var data = this.__data__, index = assocIndexOf(data, key);
    return index < 0 ? void 0 : data[index][1];
  }

  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }

  function listCacheSet(key, value) {
    var data = this.__data__, index = assocIndexOf(data, key);
    if (index < 0) {
      ++this.size;
      data.push([key, value]);
    } else {
      data[index][1] = value;
    }
    return this;
  }

  function ListCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype["delete"] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;

  var Map$1 = getNative(root$1, "Map");
  var Map$2 = Map$1;

  function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash(),
      "map": new (Map$2 || ListCache)(),
      "string": new Hash()
    };
  }

  function isKeyable(value) {
    var type = typeof value;
    return type == "string" || type == "number" || type == "symbol" || type == "boolean" ? value !== "__proto__" : value === null;
  }

  function getMapData(map, key) {
    var data = map.__data__;
    return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
  }

  function mapCacheDelete(key) {
    var result = getMapData(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }

  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }

  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }

  function mapCacheSet(key, value) {
    var data = getMapData(this, key), size = data.size;
    data.set(key, value);
    this.size += data.size == size ? 0 : 1;
    return this;
  }

  function MapCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while (++index < length) {
      var entry = entries[index];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype["delete"] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;

  var FUNC_ERROR_TEXT$2 = "Expected a function";
  function memoize(func, resolver) {
    if (typeof func != "function" || resolver != null && typeof resolver != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$2);
    }
    var memoized = function() {
      var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
      if (cache.has(key)) {
        return cache.get(key);
      }
      var result = func.apply(this, args);
      memoized.cache = cache.set(key, result) || cache;
      return result;
    };
    memoized.cache = new (memoize.Cache || MapCache)();
    return memoized;
  }
  memoize.Cache = MapCache;

  var MAX_MEMOIZE_SIZE = 500;
  function memoizeCapped(func) {
    var result = memoize(func, function(key) {
      if (cache.size === MAX_MEMOIZE_SIZE) {
        cache.clear();
      }
      return key;
    });
    var cache = result.cache;
    return result;
  }

  var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
  var reEscapeChar = /\\(\\)?/g;
  var stringToPath = memoizeCapped(function(string) {
    var result = [];
    if (string.charCodeAt(0) === 46) {
      result.push("");
    }
    string.replace(rePropName, function(match, number, quote, subString) {
      result.push(quote ? subString.replace(reEscapeChar, "$1") : number || match);
    });
    return result;
  });
  var stringToPath$1 = stringToPath;

  function toString(value) {
    return value == null ? "" : baseToString(value);
  }

  function castPath(value, object) {
    if (isArray$2(value)) {
      return value;
    }
    return isKey(value, object) ? [value] : stringToPath$1(toString(value));
  }

  var INFINITY$2 = 1 / 0;
  function toKey(value) {
    if (typeof value == "string" || isSymbol(value)) {
      return value;
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY$2 ? "-0" : result;
  }

  function baseGet(object, path) {
    path = castPath(path, object);
    var index = 0, length = path.length;
    while (object != null && index < length) {
      object = object[toKey(path[index++])];
    }
    return index && index == length ? object : void 0;
  }

  function get(object, path, defaultValue) {
    var result = object == null ? void 0 : baseGet(object, path);
    return result === void 0 ? defaultValue : result;
  }

  function arrayPush(array, values) {
    var index = -1, length = values.length, offset = array.length;
    while (++index < length) {
      array[offset + index] = values[index];
    }
    return array;
  }

  var spreadableSymbol = Symbol$2 ? Symbol$2.isConcatSpreadable : void 0;
  function isFlattenable(value) {
    return isArray$2(value) || isArguments$1(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }

  function baseFlatten(array, depth, predicate, isStrict, result) {
    var index = -1, length = array.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);
    while (++index < length) {
      var value = array[index];
      if (depth > 0 && predicate(value)) {
        if (depth > 1) {
          baseFlatten(value, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush(result, value);
        }
      } else if (!isStrict) {
        result[result.length] = value;
      }
    }
    return result;
  }

  var getPrototype = overArg(Object.getPrototypeOf, Object);
  var getPrototype$1 = getPrototype;

  function castArray$1() {
    if (!arguments.length) {
      return [];
    }
    var value = arguments[0];
    return isArray$2(value) ? value : [value];
  }

  function stackClear() {
    this.__data__ = new ListCache();
    this.size = 0;
  }

  function stackDelete(key) {
    var data = this.__data__, result = data["delete"](key);
    this.size = data.size;
    return result;
  }

  function stackGet(key) {
    return this.__data__.get(key);
  }

  function stackHas(key) {
    return this.__data__.has(key);
  }

  var LARGE_ARRAY_SIZE$1 = 200;
  function stackSet(key, value) {
    var data = this.__data__;
    if (data instanceof ListCache) {
      var pairs = data.__data__;
      if (!Map$2 || pairs.length < LARGE_ARRAY_SIZE$1 - 1) {
        pairs.push([key, value]);
        this.size = ++data.size;
        return this;
      }
      data = this.__data__ = new MapCache(pairs);
    }
    data.set(key, value);
    this.size = data.size;
    return this;
  }

  function Stack(entries) {
    var data = this.__data__ = new ListCache(entries);
    this.size = data.size;
  }
  Stack.prototype.clear = stackClear;
  Stack.prototype["delete"] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;

  function baseAssign(object, source) {
    return object && copyObject(source, keys(source), object);
  }

  function baseAssignIn(object, source) {
    return object && copyObject(source, keysIn(source), object);
  }

  var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports = freeModule && freeModule.exports === freeExports;
  var Buffer = moduleExports ? root$1.Buffer : void 0, allocUnsafe = Buffer ? Buffer.allocUnsafe : void 0;
  function cloneBuffer(buffer, isDeep) {
    if (isDeep) {
      return buffer.slice();
    }
    var length = buffer.length, result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
    buffer.copy(result);
    return result;
  }

  function arrayFilter(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
    while (++index < length) {
      var value = array[index];
      if (predicate(value, index, array)) {
        result[resIndex++] = value;
      }
    }
    return result;
  }

  function stubArray() {
    return [];
  }

  var objectProto$3 = Object.prototype;
  var propertyIsEnumerable = objectProto$3.propertyIsEnumerable;
  var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
  var getSymbols = !nativeGetSymbols$1 ? stubArray : function(object) {
    if (object == null) {
      return [];
    }
    object = Object(object);
    return arrayFilter(nativeGetSymbols$1(object), function(symbol) {
      return propertyIsEnumerable.call(object, symbol);
    });
  };
  var getSymbols$1 = getSymbols;

  function copySymbols(source, object) {
    return copyObject(source, getSymbols$1(source), object);
  }

  var nativeGetSymbols = Object.getOwnPropertySymbols;
  var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object) {
    var result = [];
    while (object) {
      arrayPush(result, getSymbols$1(object));
      object = getPrototype$1(object);
    }
    return result;
  };
  var getSymbolsIn$1 = getSymbolsIn;

  function copySymbolsIn(source, object) {
    return copyObject(source, getSymbolsIn$1(source), object);
  }

  function baseGetAllKeys(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return isArray$2(object) ? result : arrayPush(result, symbolsFunc(object));
  }

  function getAllKeys(object) {
    return baseGetAllKeys(object, keys, getSymbols$1);
  }

  function getAllKeysIn(object) {
    return baseGetAllKeys(object, keysIn, getSymbolsIn$1);
  }

  var DataView = getNative(root$1, "DataView");
  var DataView$1 = DataView;

  var Promise$1 = getNative(root$1, "Promise");
  var Promise$2 = Promise$1;

  var Set$1 = getNative(root$1, "Set");
  var Set$2 = Set$1;

  var mapTag$4 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$4 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
  var dataViewTag$3 = "[object DataView]";
  var dataViewCtorString = toSource(DataView$1), mapCtorString = toSource(Map$2), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$2), weakMapCtorString = toSource(WeakMap$1);
  var getTag = baseGetTag;
  if (DataView$1 && getTag(new DataView$1(new ArrayBuffer(1))) != dataViewTag$3 || Map$2 && getTag(new Map$2()) != mapTag$4 || Promise$2 && getTag(Promise$2.resolve()) != promiseTag || Set$2 && getTag(new Set$2()) != setTag$4 || WeakMap$1 && getTag(new WeakMap$1()) != weakMapTag$1) {
    getTag = function(value) {
      var result = baseGetTag(value), Ctor = result == objectTag$2 ? value.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$3;
          case mapCtorString:
            return mapTag$4;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$4;
          case weakMapCtorString:
            return weakMapTag$1;
        }
      }
      return result;
    };
  }
  var getTag$1 = getTag;

  var objectProto$2 = Object.prototype;
  var hasOwnProperty$3 = objectProto$2.hasOwnProperty;
  function initCloneArray(array) {
    var length = array.length, result = new array.constructor(length);
    if (length && typeof array[0] == "string" && hasOwnProperty$3.call(array, "index")) {
      result.index = array.index;
      result.input = array.input;
    }
    return result;
  }

  var Uint8Array = root$1.Uint8Array;
  var Uint8Array$1 = Uint8Array;

  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$1(result).set(new Uint8Array$1(arrayBuffer));
    return result;
  }

  function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
  }

  var reFlags = /\w*$/;
  function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
  }

  var symbolProto$1 = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf$1 = symbolProto$1 ? symbolProto$1.valueOf : void 0;
  function cloneSymbol(symbol) {
    return symbolValueOf$1 ? Object(symbolValueOf$1.call(symbol)) : {};
  }

  function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  }

  var boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", mapTag$3 = "[object Map]", numberTag$2 = "[object Number]", regexpTag$2 = "[object RegExp]", setTag$3 = "[object Set]", stringTag$2 = "[object String]", symbolTag$2 = "[object Symbol]";
  var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]", float32Tag$1 = "[object Float32Array]", float64Tag$1 = "[object Float64Array]", int8Tag$1 = "[object Int8Array]", int16Tag$1 = "[object Int16Array]", int32Tag$1 = "[object Int32Array]", uint8Tag$1 = "[object Uint8Array]", uint8ClampedTag$1 = "[object Uint8ClampedArray]", uint16Tag$1 = "[object Uint16Array]", uint32Tag$1 = "[object Uint32Array]";
  function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    switch (tag) {
      case arrayBufferTag$2:
        return cloneArrayBuffer(object);
      case boolTag$2:
      case dateTag$2:
        return new Ctor(+object);
      case dataViewTag$2:
        return cloneDataView(object, isDeep);
      case float32Tag$1:
      case float64Tag$1:
      case int8Tag$1:
      case int16Tag$1:
      case int32Tag$1:
      case uint8Tag$1:
      case uint8ClampedTag$1:
      case uint16Tag$1:
      case uint32Tag$1:
        return cloneTypedArray(object, isDeep);
      case mapTag$3:
        return new Ctor();
      case numberTag$2:
      case stringTag$2:
        return new Ctor(object);
      case regexpTag$2:
        return cloneRegExp(object);
      case setTag$3:
        return new Ctor();
      case symbolTag$2:
        return cloneSymbol(object);
    }
  }

  function initCloneObject(object) {
    return typeof object.constructor == "function" && !isPrototype(object) ? baseCreate$1(getPrototype$1(object)) : {};
  }

  var mapTag$2 = "[object Map]";
  function baseIsMap(value) {
    return isObjectLike(value) && getTag$1(value) == mapTag$2;
  }

  var nodeIsMap = nodeUtil$1 && nodeUtil$1.isMap;
  var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
  var isMap$1 = isMap;

  var setTag$2 = "[object Set]";
  function baseIsSet(value) {
    return isObjectLike(value) && getTag$1(value) == setTag$2;
  }

  var nodeIsSet = nodeUtil$1 && nodeUtil$1.isSet;
  var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
  var isSet$1 = isSet;

  var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG$1 = 4;
  var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag$1 = "[object Map]", numberTag$1 = "[object Number]", objectTag$1 = "[object Object]", regexpTag$1 = "[object RegExp]", setTag$1 = "[object Set]", stringTag$1 = "[object String]", symbolTag$1 = "[object Symbol]", weakMapTag = "[object WeakMap]";
  var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
  var cloneableTags = {};
  cloneableTags[argsTag$1] = cloneableTags[arrayTag$1] = cloneableTags[arrayBufferTag$1] = cloneableTags[dataViewTag$1] = cloneableTags[boolTag$1] = cloneableTags[dateTag$1] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag$1] = cloneableTags[numberTag$1] = cloneableTags[objectTag$1] = cloneableTags[regexpTag$1] = cloneableTags[setTag$1] = cloneableTags[stringTag$1] = cloneableTags[symbolTag$1] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag$1] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
  function baseClone(value, bitmask, customizer, key, object, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG$1;
    if (customizer) {
      result = object ? customizer(value, key, object, stack) : customizer(value);
    }
    if (result !== void 0) {
      return result;
    }
    if (!isObject$2(value)) {
      return value;
    }
    var isArr = isArray$2(value);
    if (isArr) {
      result = initCloneArray(value);
      if (!isDeep) {
        return copyArray(value, result);
      }
    } else {
      var tag = getTag$1(value), isFunc = tag == funcTag || tag == genTag;
      if (isBuffer$1(value)) {
        return cloneBuffer(value, isDeep);
      }
      if (tag == objectTag$1 || tag == argsTag$1 || isFunc && !object) {
        result = isFlat || isFunc ? {} : initCloneObject(value);
        if (!isDeep) {
          return isFlat ? copySymbolsIn(value, baseAssignIn(result, value)) : copySymbols(value, baseAssign(result, value));
        }
      } else {
        if (!cloneableTags[tag]) {
          return object ? value : {};
        }
        result = initCloneByTag(value, tag, isDeep);
      }
    }
    stack || (stack = new Stack());
    var stacked = stack.get(value);
    if (stacked) {
      return stacked;
    }
    stack.set(value, result);
    if (isSet$1(value)) {
      value.forEach(function(subValue) {
        result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
      });
    } else if (isMap$1(value)) {
      value.forEach(function(subValue, key2) {
        result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
      });
    }
    var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys;
    var props = isArr ? void 0 : keysFunc(value);
    arrayEach(props || value, function(subValue, key2) {
      if (props) {
        key2 = subValue;
        subValue = value[key2];
      }
      assignValue(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
  }

  var CLONE_SYMBOLS_FLAG = 4;
  function clone(value) {
    return baseClone(value, CLONE_SYMBOLS_FLAG);
  }

  var HASH_UNDEFINED = "__lodash_hash_undefined__";
  function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED);
    return this;
  }

  function setCacheHas(value) {
    return this.__data__.has(value);
  }

  function SetCache(values) {
    var index = -1, length = values == null ? 0 : values.length;
    this.__data__ = new MapCache();
    while (++index < length) {
      this.add(values[index]);
    }
  }
  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;

  function arraySome(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length;
    while (++index < length) {
      if (predicate(array[index], index, array)) {
        return true;
      }
    }
    return false;
  }

  function cacheHas(cache, key) {
    return cache.has(key);
  }

  var COMPARE_PARTIAL_FLAG$3 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
  function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, arrLength = array.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array;
    }
    var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$1 ? new SetCache() : void 0;
    stack.set(array, other);
    stack.set(other, array);
    while (++index < arrLength) {
      var arrValue = array[index], othValue = other[index];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome(other, function(othValue2, othIndex) {
          if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array);
    stack["delete"](other);
    return result;
  }

  function mapToArray(map) {
    var index = -1, result = Array(map.size);
    map.forEach(function(value, key) {
      result[++index] = [key, value];
    });
    return result;
  }

  function setToArray(set) {
    var index = -1, result = Array(set.size);
    set.forEach(function(value) {
      result[++index] = value;
    });
    return result;
  }

  var COMPARE_PARTIAL_FLAG$2 = 1, COMPARE_UNORDERED_FLAG = 2;
  var boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", mapTag = "[object Map]", numberTag = "[object Number]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]";
  var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]";
  var symbolProto = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
  function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag:
        if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
          return false;
        }
        object = object.buffer;
        other = other.buffer;
      case arrayBufferTag:
        if (object.byteLength != other.byteLength || !equalFunc(new Uint8Array$1(object), new Uint8Array$1(other))) {
          return false;
        }
        return true;
      case boolTag:
      case dateTag:
      case numberTag:
        return eq(+object, +other);
      case errorTag:
        return object.name == other.name && object.message == other.message;
      case regexpTag:
      case stringTag:
        return object == other + "";
      case mapTag:
        var convert = mapToArray;
      case setTag:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG$2;
        convert || (convert = setToArray);
        if (object.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG;
        stack.set(object, other);
        var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object);
        return result;
      case symbolTag:
        if (symbolValueOf) {
          return symbolValueOf.call(object) == symbolValueOf.call(other);
        }
    }
    return false;
  }

  var COMPARE_PARTIAL_FLAG$1 = 1;
  var objectProto$1 = Object.prototype;
  var hasOwnProperty$2 = objectProto$1.hasOwnProperty;
  function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$1, objProps = getAllKeys(object), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index = objLength;
    while (index--) {
      var key = objProps[index];
      if (!(isPartial ? key in other : hasOwnProperty$2.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object;
    }
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;
    while (++index < objLength) {
      key = objProps[index];
      var objValue = object[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object);
    stack["delete"](other);
    return result;
  }

  var COMPARE_PARTIAL_FLAG = 1;
  var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
  var objectProto = Object.prototype;
  var hasOwnProperty$1 = objectProto.hasOwnProperty;
  function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$2(object), othIsArr = isArray$2(other), objTag = objIsArr ? arrayTag : getTag$1(object), othTag = othIsArr ? arrayTag : getTag$1(other);
    objTag = objTag == argsTag ? objectTag : objTag;
    othTag = othTag == argsTag ? objectTag : othTag;
    var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$1(object)) {
      if (!isBuffer$1(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack());
      return objIsArr || isTypedArray$1(object) ? equalArrays(object, other, bitmask, customizer, equalFunc, stack) : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG)) {
      var objIsWrapped = objIsObj && hasOwnProperty$1.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$1.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack());
    return equalObjects(object, other, bitmask, customizer, equalFunc, stack);
  }

  function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) {
      return true;
    }
    if (value == null || other == null || !isObjectLike(value) && !isObjectLike(other)) {
      return value !== value && other !== other;
    }
    return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);
  }

  var now = function() {
    return root$1.Date.now();
  };
  var now$1 = now;

  var FUNC_ERROR_TEXT$1 = "Expected a function";
  var nativeMax = Math.max, nativeMin = Math.min;
  function debounce$1(func, wait, options) {
    var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
    if (typeof func != "function") {
      throw new TypeError(FUNC_ERROR_TEXT$1);
    }
    wait = toNumber(wait) || 0;
    if (isObject$2(options)) {
      leading = !!options.leading;
      maxing = "maxWait" in options;
      maxWait = maxing ? nativeMax(toNumber(options.maxWait) || 0, wait) : maxWait;
      trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    function invokeFunc(time) {
      var args = lastArgs, thisArg = lastThis;
      lastArgs = lastThis = void 0;
      lastInvokeTime = time;
      result = func.apply(thisArg, args);
      return result;
    }
    function leadingEdge(time) {
      lastInvokeTime = time;
      timerId = setTimeout(timerExpired, wait);
      return leading ? invokeFunc(time) : result;
    }
    function remainingWait(time) {
      var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
      return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
    }
    function shouldInvoke(time) {
      var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
      return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }
    function timerExpired() {
      var time = now$1();
      if (shouldInvoke(time)) {
        return trailingEdge(time);
      }
      timerId = setTimeout(timerExpired, remainingWait(time));
    }
    function trailingEdge(time) {
      timerId = void 0;
      if (trailing && lastArgs) {
        return invokeFunc(time);
      }
      lastArgs = lastThis = void 0;
      return result;
    }
    function cancel() {
      if (timerId !== void 0) {
        clearTimeout(timerId);
      }
      lastInvokeTime = 0;
      lastArgs = lastCallTime = lastThis = timerId = void 0;
    }
    function flush() {
      return timerId === void 0 ? result : trailingEdge(now$1());
    }
    function debounced() {
      var time = now$1(), isInvoking = shouldInvoke(time);
      lastArgs = arguments;
      lastThis = this;
      lastCallTime = time;
      if (isInvoking) {
        if (timerId === void 0) {
          return leadingEdge(lastCallTime);
        }
        if (maxing) {
          clearTimeout(timerId);
          timerId = setTimeout(timerExpired, wait);
          return invokeFunc(lastCallTime);
        }
      }
      if (timerId === void 0) {
        timerId = setTimeout(timerExpired, wait);
      }
      return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
  }

  function isArrayLikeObject(value) {
    return isObjectLike(value) && isArrayLike(value);
  }

  function arrayIncludesWith(array, value, comparator) {
    var index = -1, length = array == null ? 0 : array.length;
    while (++index < length) {
      if (comparator(value, array[index])) {
        return true;
      }
    }
    return false;
  }

  var INFINITY$1 = 1 / 0;
  function flattenDeep(array) {
    var length = array == null ? 0 : array.length;
    return length ? baseFlatten(array, INFINITY$1) : [];
  }

  function fromPairs(pairs) {
    var index = -1, length = pairs == null ? 0 : pairs.length, result = {};
    while (++index < length) {
      var pair = pairs[index];
      result[pair[0]] = pair[1];
    }
    return result;
  }

  function isEqual$1(value, other) {
    return baseIsEqual(value, other);
  }

  function isNil(value) {
    return value == null;
  }

  function baseSet(object, path, value, customizer) {
    if (!isObject$2(object)) {
      return object;
    }
    path = castPath(path, object);
    var index = -1, length = path.length, lastIndex = length - 1, nested = object;
    while (nested != null && ++index < length) {
      var key = toKey(path[index]), newValue = value;
      if (key === "__proto__" || key === "constructor" || key === "prototype") {
        return object;
      }
      if (index != lastIndex) {
        var objValue = nested[key];
        newValue = customizer ? customizer(objValue, key, nested) : void 0;
        if (newValue === void 0) {
          newValue = isObject$2(objValue) ? objValue : isIndex(path[index + 1]) ? [] : {};
        }
      }
      assignValue(nested, key, newValue);
      nested = nested[key];
    }
    return object;
  }

  function set(object, path, value) {
    return object == null ? object : baseSet(object, path, value);
  }

  var FUNC_ERROR_TEXT = "Expected a function";
  function throttle(func, wait, options) {
    var leading = true, trailing = true;
    if (typeof func != "function") {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    if (isObject$2(options)) {
      leading = "leading" in options ? !!options.leading : leading;
      trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    return debounce$1(func, wait, {
      "leading": leading,
      "maxWait": wait,
      "trailing": trailing
    });
  }

  var INFINITY = 1 / 0;
  var createSet = !(Set$2 && 1 / setToArray(new Set$2([, -0]))[1] == INFINITY) ? noop$1 : function(values) {
    return new Set$2(values);
  };
  var createSet$1 = createSet;

  var LARGE_ARRAY_SIZE = 200;
  function baseUniq(array, iteratee, comparator) {
    var index = -1, includes = arrayIncludes, length = array.length, isCommon = true, result = [], seen = result;
    if (comparator) {
      isCommon = false;
      includes = arrayIncludesWith;
    } else if (length >= LARGE_ARRAY_SIZE) {
      var set = iteratee ? null : createSet$1(array);
      if (set) {
        return setToArray(set);
      }
      isCommon = false;
      includes = cacheHas;
      seen = new SetCache();
    } else {
      seen = iteratee ? [] : result;
    }
    outer:
      while (++index < length) {
        var value = array[index], computed = iteratee ? iteratee(value) : value;
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value);
        } else if (!includes(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value);
        }
      }
    return result;
  }

  var union = baseRest(function(arrays) {
    return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
  });
  var union$1 = union;

  const FOCUSABLE_ELEMENT_SELECTORS = `a[href],button:not([disabled]),button:not([hidden]),:not([tabindex="-1"]),input:not([disabled]),input:not([type="hidden"]),select:not([disabled]),textarea:not([disabled])`;
  const isVisible = (element) => {
    const computed = getComputedStyle(element);
    return computed.position === "fixed" ? false : element.offsetParent !== null;
  };
  const obtainAllFocusableElements$1 = (element) => {
    return Array.from(element.querySelectorAll(FOCUSABLE_ELEMENT_SELECTORS)).filter((item) => isFocusable(item) && isVisible(item));
  };
  const isFocusable = (element) => {
    if (element.tabIndex > 0 || element.tabIndex === 0 && element.getAttribute("tabIndex") !== null) {
      return true;
    }
    if (element.disabled) {
      return false;
    }
    switch (element.nodeName) {
      case "A": {
        return !!element.href && element.rel !== "ignore";
      }
      case "INPUT": {
        return !(element.type === "hidden" || element.type === "file");
      }
      case "BUTTON":
      case "SELECT":
      case "TEXTAREA": {
        return true;
      }
      default: {
        return false;
      }
    }
  };
  const triggerEvent = function(elm, name, ...opts) {
    let eventName;
    if (name.includes("mouse") || name.includes("click")) {
      eventName = "MouseEvents";
    } else if (name.includes("key")) {
      eventName = "KeyboardEvent";
    } else {
      eventName = "HTMLEvents";
    }
    const evt = document.createEvent(eventName);
    evt.initEvent(name, ...opts);
    elm.dispatchEvent(evt);
    return elm;
  };
  const isLeaf = (el) => !el.getAttribute("aria-owns");
  const getSibling = (el, distance, elClass) => {
    const { parentNode } = el;
    if (!parentNode)
      return null;
    const siblings = parentNode.querySelectorAll(elClass);
    const index = Array.prototype.indexOf.call(siblings, el);
    return siblings[index + distance] || null;
  };
  const focusNode = (el) => {
    if (!el)
      return;
    el.focus();
    !isLeaf(el) && el.click();
  };

  const on = (element, event, handler, useCapture = false) => {
    if (element && event && handler) {
      element == null ? void 0 : element.addEventListener(event, handler, useCapture);
    }
  };
  const off = (element, event, handler, useCapture = false) => {
    if (element && event && handler) {
      element == null ? void 0 : element.removeEventListener(event, handler, useCapture);
    }
  };
  const once = (el, event, fn) => {
    const listener = function(...args) {
      if (fn) {
        fn.apply(this, args);
      }
      off(el, event, listener);
    };
    on(el, event, listener);
  };
  const composeEventHandlers = (theirsHandler, oursHandler, { checkForDefaultPrevented = true } = {}) => {
    const handleEvent = (event) => {
      const shouldPrevent = theirsHandler == null ? void 0 : theirsHandler(event);
      if (checkForDefaultPrevented === false || !shouldPrevent) {
        return oursHandler == null ? void 0 : oursHandler(event);
      }
    };
    return handleEvent;
  };
  const whenMouse = (handler) => {
    return (e) => e.pointerType === "mouse" ? handler(e) : void 0;
  };

  function tryOnScopeDispose(fn) {
    if (vue.getCurrentScope()) {
      vue.onScopeDispose(fn);
      return true;
    }
    return false;
  }

  const isClient = typeof window !== "undefined";
  const isBoolean = (val) => typeof val === "boolean";
  const isNumber = (val) => typeof val === "number";
  const isString$1 = (val) => typeof val === "string";
  const noop = () => {
  };

  function createFilterWrapper(filter, fn) {
    function wrapper(...args) {
      filter(() => fn.apply(this, args), { fn, thisArg: this, args });
    }
    return wrapper;
  }
  function throttleFilter(ms, trailing = true, leading = true) {
    let lastExec = 0;
    let timer;
    let preventLeading = !leading;
    const clear = () => {
      if (timer) {
        clearTimeout(timer);
        timer = void 0;
      }
    };
    const filter = (invoke) => {
      const duration = vue.unref(ms);
      const elapsed = Date.now() - lastExec;
      clear();
      if (duration <= 0) {
        lastExec = Date.now();
        return invoke();
      }
      if (elapsed > duration) {
        lastExec = Date.now();
        if (preventLeading)
          preventLeading = false;
        else
          invoke();
      }
      if (trailing) {
        timer = setTimeout(() => {
          lastExec = Date.now();
          if (!leading)
            preventLeading = true;
          clear();
          invoke();
        }, duration);
      }
      if (!leading && !timer)
        timer = setTimeout(() => preventLeading = true, duration);
    };
    return filter;
  }

  var __defProp$7 = Object.defineProperty;
  var __defProps$4 = Object.defineProperties;
  var __getOwnPropDescs$4 = Object.getOwnPropertyDescriptors;
  var __getOwnPropSymbols$8 = Object.getOwnPropertySymbols;
  var __hasOwnProp$8 = Object.prototype.hasOwnProperty;
  var __propIsEnum$8 = Object.prototype.propertyIsEnumerable;
  var __defNormalProp$7 = (obj, key, value) => key in obj ? __defProp$7(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues$7 = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp$8.call(b, prop))
        __defNormalProp$7(a, prop, b[prop]);
    if (__getOwnPropSymbols$8)
      for (var prop of __getOwnPropSymbols$8(b)) {
        if (__propIsEnum$8.call(b, prop))
          __defNormalProp$7(a, prop, b[prop]);
      }
    return a;
  };
  var __spreadProps$4 = (a, b) => __defProps$4(a, __getOwnPropDescs$4(b));
  function eagerComputed(fn, options) {
    var _a;
    const result = vue.shallowRef();
    vue.watchEffect(() => {
      result.value = fn();
    }, __spreadProps$4(__spreadValues$7({}, options), {
      flush: (_a = options == null ? void 0 : options.flush) != null ? _a : "sync"
    }));
    return vue.readonly(result);
  }

  function useThrottleFn(fn, ms = 200, trailing = true, leading = true) {
    return createFilterWrapper(throttleFilter(ms, trailing, leading), fn);
  }

  function tryOnMounted(fn, sync = true) {
    if (vue.getCurrentInstance())
      vue.onMounted(fn);
    else if (sync)
      fn();
    else
      vue.nextTick(fn);
  }

  function useTimeoutFn(cb, interval, options = {}) {
    const {
      immediate = true
    } = options;
    const isPending = vue.ref(false);
    let timer = null;
    function clear() {
      if (timer) {
        clearTimeout(timer);
        timer = null;
      }
    }
    function stop() {
      isPending.value = false;
      clear();
    }
    function start(...args) {
      clear();
      isPending.value = true;
      timer = setTimeout(() => {
        isPending.value = false;
        timer = null;
        cb(...args);
      }, vue.unref(interval));
    }
    if (immediate) {
      isPending.value = true;
      if (isClient)
        start();
    }
    tryOnScopeDispose(stop);
    return {
      isPending,
      start,
      stop
    };
  }

  function unrefElement(elRef) {
    var _a;
    const plain = vue.unref(elRef);
    return (_a = plain == null ? void 0 : plain.$el) != null ? _a : plain;
  }

  const defaultWindow = isClient ? window : void 0;
  const defaultDocument = isClient ? window.document : void 0;

  function useEventListener(...args) {
    let target;
    let event;
    let listener;
    let options;
    if (isString$1(args[0])) {
      [event, listener, options] = args;
      target = defaultWindow;
    } else {
      [target, event, listener, options] = args;
    }
    if (!target)
      return noop;
    let cleanup = noop;
    const stopWatch = vue.watch(() => vue.unref(target), (el) => {
      cleanup();
      if (!el)
        return;
      el.addEventListener(event, listener, options);
      cleanup = () => {
        el.removeEventListener(event, listener, options);
        cleanup = noop;
      };
    }, { immediate: true, flush: "post" });
    const stop = () => {
      stopWatch();
      cleanup();
    };
    tryOnScopeDispose(stop);
    return stop;
  }

  function onClickOutside(target, handler, options = {}) {
    const { window = defaultWindow, ignore } = options;
    if (!window)
      return;
    const shouldListen = vue.ref(true);
    const listener = (event) => {
      const el = unrefElement(target);
      const composedPath = event.composedPath();
      if (!el || el === event.target || composedPath.includes(el) || !shouldListen.value)
        return;
      if (ignore && ignore.length > 0) {
        if (ignore.some((target2) => {
          const el2 = unrefElement(target2);
          return el2 && (event.target === el2 || composedPath.includes(el2));
        }))
          return;
      }
      handler(event);
    };
    const cleanup = [
      useEventListener(window, "click", listener, { passive: true, capture: true }),
      useEventListener(window, "pointerdown", (e) => {
        const el = unrefElement(target);
        shouldListen.value = !!el && !e.composedPath().includes(el);
      }, { passive: true })
    ];
    const stop = () => cleanup.forEach((fn) => fn());
    return stop;
  }

  const _global = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  const globalKey = "__vueuse_ssr_handlers__";
  _global[globalKey] = _global[globalKey] || {};
  _global[globalKey];

  function useDocumentVisibility({ document = defaultDocument } = {}) {
    if (!document)
      return vue.ref("visible");
    const visibility = vue.ref(document.visibilityState);
    useEventListener(document, "visibilitychange", () => {
      visibility.value = document.visibilityState;
    });
    return visibility;
  }

  var __getOwnPropSymbols$c = Object.getOwnPropertySymbols;
  var __hasOwnProp$c = Object.prototype.hasOwnProperty;
  var __propIsEnum$c = Object.prototype.propertyIsEnumerable;
  var __objRest$2 = (source, exclude) => {
    var target = {};
    for (var prop in source)
      if (__hasOwnProp$c.call(source, prop) && exclude.indexOf(prop) < 0)
        target[prop] = source[prop];
    if (source != null && __getOwnPropSymbols$c)
      for (var prop of __getOwnPropSymbols$c(source)) {
        if (exclude.indexOf(prop) < 0 && __propIsEnum$c.call(source, prop))
          target[prop] = source[prop];
      }
    return target;
  };
  function useResizeObserver(target, callback, options = {}) {
    const _a = options, { window = defaultWindow } = _a, observerOptions = __objRest$2(_a, ["window"]);
    let observer;
    const isSupported = window && "ResizeObserver" in window;
    const cleanup = () => {
      if (observer) {
        observer.disconnect();
        observer = void 0;
      }
    };
    const stopWatch = vue.watch(() => unrefElement(target), (el) => {
      cleanup();
      if (isSupported && window && el) {
        observer = new window.ResizeObserver(callback);
        observer.observe(el, observerOptions);
      }
    }, { immediate: true, flush: "post" });
    const stop = () => {
      cleanup();
      stopWatch();
    };
    tryOnScopeDispose(stop);
    return {
      isSupported,
      stop
    };
  }

  function useElementBounding(target) {
    const height = vue.ref(0);
    const bottom = vue.ref(0);
    const left = vue.ref(0);
    const right = vue.ref(0);
    const top = vue.ref(0);
    const width = vue.ref(0);
    const x = vue.ref(0);
    const y = vue.ref(0);
    function update() {
      const el = unrefElement(target);
      if (!el) {
        height.value = 0;
        bottom.value = 0;
        left.value = 0;
        right.value = 0;
        top.value = 0;
        width.value = 0;
        x.value = 0;
        y.value = 0;
        return;
      }
      const rect = el.getBoundingClientRect();
      height.value = rect.height;
      bottom.value = rect.bottom;
      left.value = rect.left;
      right.value = rect.right;
      top.value = rect.top;
      width.value = rect.width;
      x.value = rect.x;
      y.value = rect.y;
    }
    useEventListener("scroll", update, true);
    useResizeObserver(target, update);
    vue.watch(() => unrefElement(target), (ele) => !ele && update());
    return {
      height,
      bottom,
      left,
      right,
      top,
      width,
      x,
      y,
      update
    };
  }

  var _a, _b;
  isClient && (window == null ? void 0 : window.navigator) && ((_a = window == null ? void 0 : window.navigator) == null ? void 0 : _a.platform) && /iP(ad|hone|od)/.test((_b = window == null ? void 0 : window.navigator) == null ? void 0 : _b.platform);

  var __defProp$3 = Object.defineProperty;
  var __getOwnPropSymbols$3 = Object.getOwnPropertySymbols;
  var __hasOwnProp$3 = Object.prototype.hasOwnProperty;
  var __propIsEnum$3 = Object.prototype.propertyIsEnumerable;
  var __defNormalProp$3 = (obj, key, value) => key in obj ? __defProp$3(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues$3 = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp$3.call(b, prop))
        __defNormalProp$3(a, prop, b[prop]);
    if (__getOwnPropSymbols$3)
      for (var prop of __getOwnPropSymbols$3(b)) {
        if (__propIsEnum$3.call(b, prop))
          __defNormalProp$3(a, prop, b[prop]);
      }
    return a;
  };
  const initialRect = {
    top: 0,
    left: 0,
    bottom: 0,
    right: 0,
    height: 0,
    width: 0
  };
  __spreadValues$3({
    text: ""
  }, initialRect);

  function useWindowFocus({ window = defaultWindow } = {}) {
    if (!window)
      return vue.ref(false);
    const focused = vue.ref(window.document.hasFocus());
    useEventListener(window, "blur", () => {
      focused.value = false;
    });
    useEventListener(window, "focus", () => {
      focused.value = true;
    });
    return focused;
  }

  function useWindowSize({ window = defaultWindow, initialWidth = Infinity, initialHeight = Infinity } = {}) {
    const width = vue.ref(initialWidth);
    const height = vue.ref(initialHeight);
    const update = () => {
      if (window) {
        width.value = window.innerWidth;
        height.value = window.innerHeight;
      }
    };
    update();
    tryOnMounted(update);
    useEventListener("resize", update, { passive: true });
    return { width, height };
  }

  const isInContainer = (el, container) => {
    if (!isClient || !el || !container)
      return false;
    const elRect = el.getBoundingClientRect();
    let containerRect;
    if (container instanceof Element) {
      containerRect = container.getBoundingClientRect();
    } else {
      containerRect = {
        top: 0,
        right: window.innerWidth,
        bottom: window.innerHeight,
        left: 0
      };
    }
    return elRect.top < containerRect.bottom && elRect.bottom > containerRect.top && elRect.right > containerRect.left && elRect.left < containerRect.right;
  };
  const getOffsetTop = (el) => {
    let offset = 0;
    let parent = el;
    while (parent) {
      offset += parent.offsetTop;
      parent = parent.offsetParent;
    }
    return offset;
  };
  const getOffsetTopDistance = (el, containerEl) => {
    return Math.abs(getOffsetTop(el) - getOffsetTop(containerEl));
  };
  const getClientXY = (event) => {
    let clientX;
    let clientY;
    if (event.type === "touchend") {
      clientY = event.changedTouches[0].clientY;
      clientX = event.changedTouches[0].clientX;
    } else if (event.type.startsWith("touch")) {
      clientY = event.touches[0].clientY;
      clientX = event.touches[0].clientX;
    } else {
      clientY = event.clientY;
      clientX = event.clientX;
    }
    return {
      clientX,
      clientY
    };
  };

  const resizeHandler = function(entries) {
    for (const entry of entries) {
      const listeners = entry.target.__resizeListeners__ || [];
      if (listeners.length) {
        listeners.forEach((fn) => {
          fn();
        });
      }
    }
  };
  const addResizeListener = function(element, fn) {
    if (!isClient || !element)
      return;
    if (!element.__resizeListeners__) {
      element.__resizeListeners__ = [];
      element.__ro__ = new ResizeObserver(resizeHandler);
      element.__ro__.observe(element);
    }
    element.__resizeListeners__.push(fn);
  };
  const removeResizeListener = function(element, fn) {
    var _a;
    if (!element || !element.__resizeListeners__)
      return;
    element.__resizeListeners__.splice(element.__resizeListeners__.indexOf(fn), 1);
    if (!element.__resizeListeners__.length) {
      (_a = element.__ro__) == null ? void 0 : _a.disconnect();
    }
  };

  const NOOP = () => {
  };
  const hasOwnProperty = Object.prototype.hasOwnProperty;
  const hasOwn = (val, key) => hasOwnProperty.call(val, key);
  const isArray = Array.isArray;
  const isFunction = (val) => typeof val === "function";
  const isString = (val) => typeof val === "string";
  const isObject$1 = (val) => val !== null && typeof val === "object";
  const isPromise = (val) => {
    return isObject$1(val) && isFunction(val.then) && isFunction(val.catch);
  };
  const objectToString = Object.prototype.toString;
  const toTypeString = (value) => objectToString.call(value);
  const toRawType = (value) => {
    return toTypeString(value).slice(8, -1);
  };
  const cacheStringFunction = (fn) => {
    const cache = /* @__PURE__ */ Object.create(null);
    return (str) => {
      const hit = cache[str];
      return hit || (cache[str] = fn(str));
    };
  };
  const camelizeRE = /-(\w)/g;
  const camelize = cacheStringFunction((str) => {
    return str.replace(camelizeRE, (_, c) => c ? c.toUpperCase() : "");
  });
  const hyphenateRE = /\B([A-Z])/g;
  const hyphenate = cacheStringFunction((str) => str.replace(hyphenateRE, "-$1").toLowerCase());
  const capitalize = cacheStringFunction((str) => str.charAt(0).toUpperCase() + str.slice(1));

  const isUndefined = (val) => val === void 0;
  const isEmpty = (val) => !val && val !== 0 || isArray(val) && val.length === 0 || isObject$1(val) && !Object.keys(val).length;
  const isElement$1 = (e) => e instanceof Element;

  const escapeStringRegexp = (string = "") => string.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&").replace(/-/g, "\\x2d");

  const keysOf = (arr) => Object.keys(arr);
  const entriesOf = (arr) => Object.entries(arr);
  const getProp = (obj, path, defaultValue) => {
    return {
      get value() {
        return get(obj, path, defaultValue);
      },
      set value(val) {
        set(obj, path, val);
      }
    };
  };

  const classNameToArray = (cls = "") => cls.split(" ").filter((item) => !!item.trim());
  const hasClass = (el, cls) => {
    if (!el || !cls)
      return false;
    if (cls.includes(" "))
      throw new Error("className should not contain space.");
    return el.classList.contains(cls);
  };
  const addClass = (el, cls) => {
    if (!el || !cls.trim())
      return;
    el.classList.add(...classNameToArray(cls));
  };
  const removeClass = (el, cls) => {
    if (!el || !cls.trim())
      return;
    el.classList.remove(...classNameToArray(cls));
  };
  const getStyle = (element, styleName) => {
    var _a;
    if (!isClient || !element || !styleName)
      return "";
    camelize(styleName);
    try {
      const style = element.style[styleName];
      if (style)
        return style;
      const computed = (_a = document.defaultView) == null ? void 0 : _a.getComputedStyle(element, "");
      return computed ? computed[styleName] : "";
    } catch (e) {
      return element.style[styleName];
    }
  };

  const isScroll = (el, isVertical) => {
    if (!isClient)
      return false;
    const key = {
      undefined: "overflow",
      true: "overflow-y",
      false: "overflow-x"
    }[String(isVertical)];
    const overflow = getStyle(el, key);
    return ["scroll", "auto", "overlay"].some((s) => overflow.includes(s));
  };
  const getScrollContainer = (el, isVertical) => {
    if (!isClient)
      return;
    let parent = el;
    while (parent) {
      if ([window, document, document.documentElement].includes(parent))
        return window;
      if (isScroll(parent, isVertical))
        return parent;
      parent = parent.parentNode;
    }
    return parent;
  };
  let scrollBarWidth;
  const getScrollBarWidth = () => {
    var _a;
    if (!isClient)
      return 0;
    if (scrollBarWidth !== void 0)
      return scrollBarWidth;
    const outer = document.createElement("div");
    outer.className = "el-scrollbar__wrap";
    outer.style.visibility = "hidden";
    outer.style.width = "100px";
    outer.style.position = "absolute";
    outer.style.top = "-9999px";
    document.body.appendChild(outer);
    const widthNoScroll = outer.offsetWidth;
    outer.style.overflow = "scroll";
    const inner = document.createElement("div");
    inner.style.width = "100%";
    outer.appendChild(inner);
    const widthWithScroll = inner.offsetWidth;
    (_a = outer.parentNode) == null ? void 0 : _a.removeChild(outer);
    scrollBarWidth = widthNoScroll - widthWithScroll;
    return scrollBarWidth;
  };
  function scrollIntoView(container, selected) {
    if (!isClient)
      return;
    if (!selected) {
      container.scrollTop = 0;
      return;
    }
    const offsetParents = [];
    let pointer = selected.offsetParent;
    while (pointer !== null && container !== pointer && container.contains(pointer)) {
      offsetParents.push(pointer);
      pointer = pointer.offsetParent;
    }
    const top = selected.offsetTop + offsetParents.reduce((prev, curr) => prev + curr.offsetTop, 0);
    const bottom = top + selected.offsetHeight;
    const viewRectTop = container.scrollTop;
    const viewRectBottom = viewRectTop + container.clientHeight;
    if (top < viewRectTop) {
      container.scrollTop = top;
    } else if (bottom > viewRectBottom) {
      container.scrollTop = bottom - container.clientHeight;
    }
  }

  let target = !isClient ? void 0 : document.body;
  function createGlobalNode(id) {
    const el = document.createElement("div");
    if (id !== void 0) {
      el.setAttribute("id", id);
    }
    target.appendChild(el);
    return el;
  }
  function removeGlobalNode(el) {
    el.remove();
  }

  var _export_sfc$1 = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };

  const _sfc_main$2N = vue.defineComponent({
    name: "ArrowDown"
  });
  const _hoisted_1$1C = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1i = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M831.872 340.864L512 652.672 192.128 340.864a30.592 30.592 0 00-42.752 0 29.12 29.12 0 000 41.6L489.664 714.24a32 32 0 0044.672 0l340.288-331.712a29.12 29.12 0 000-41.728 30.592 30.592 0 00-42.752 0z"
  }, null, -1);
  const _hoisted_3$$ = [
    _hoisted_2$1i
  ];
  function _sfc_render$2j(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1C, _hoisted_3$$);
  }
  var arrowDown = /* @__PURE__ */ _export_sfc$1(_sfc_main$2N, [["render", _sfc_render$2j]]);

  const _sfc_main$2M = vue.defineComponent({
    name: "ArrowLeft"
  });
  const _hoisted_1$1B = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1h = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M609.408 149.376L277.76 489.6a32 32 0 000 44.672l331.648 340.352a29.12 29.12 0 0041.728 0 30.592 30.592 0 000-42.752L339.264 511.936l311.872-319.872a30.592 30.592 0 000-42.688 29.12 29.12 0 00-41.728 0z"
  }, null, -1);
  const _hoisted_3$_ = [
    _hoisted_2$1h
  ];
  function _sfc_render$2i(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1B, _hoisted_3$_);
  }
  var arrowLeft = /* @__PURE__ */ _export_sfc$1(_sfc_main$2M, [["render", _sfc_render$2i]]);

  const _sfc_main$2L = vue.defineComponent({
    name: "ArrowRight"
  });
  const _hoisted_1$1A = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1g = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M340.864 149.312a30.592 30.592 0 000 42.752L652.736 512 340.864 831.872a30.592 30.592 0 000 42.752 29.12 29.12 0 0041.728 0L714.24 534.336a32 32 0 000-44.672L382.592 149.376a29.12 29.12 0 00-41.728 0z"
  }, null, -1);
  const _hoisted_3$Z = [
    _hoisted_2$1g
  ];
  function _sfc_render$2h(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1A, _hoisted_3$Z);
  }
  var arrowRight = /* @__PURE__ */ _export_sfc$1(_sfc_main$2L, [["render", _sfc_render$2h]]);

  const _sfc_main$2K = vue.defineComponent({
    name: "ArrowUp"
  });
  const _hoisted_1$1z = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1f = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M488.832 344.32l-339.84 356.672a32 32 0 000 44.16l.384.384a29.44 29.44 0 0042.688 0l320-335.872 319.872 335.872a29.44 29.44 0 0042.688 0l.384-.384a32 32 0 000-44.16L535.168 344.32a32 32 0 00-46.336 0z"
  }, null, -1);
  const _hoisted_3$Y = [
    _hoisted_2$1f
  ];
  function _sfc_render$2g(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1z, _hoisted_3$Y);
  }
  var arrowUp = /* @__PURE__ */ _export_sfc$1(_sfc_main$2K, [["render", _sfc_render$2g]]);

  const _sfc_main$2J = vue.defineComponent({
    name: "Back"
  });
  const _hoisted_1$1y = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1e = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M224 480h640a32 32 0 110 64H224a32 32 0 010-64z"
  }, null, -1);
  const _hoisted_3$X = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M237.248 512l265.408 265.344a32 32 0 01-45.312 45.312l-288-288a32 32 0 010-45.312l288-288a32 32 0 1145.312 45.312L237.248 512z"
  }, null, -1);
  const _hoisted_4$j = [
    _hoisted_2$1e,
    _hoisted_3$X
  ];
  function _sfc_render$2f(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1y, _hoisted_4$j);
  }
  var back = /* @__PURE__ */ _export_sfc$1(_sfc_main$2J, [["render", _sfc_render$2f]]);

  const _sfc_main$2I = vue.defineComponent({
    name: "Calendar"
  });
  const _hoisted_1$1x = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1d = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M128 384v512h768V192H768v32a32 32 0 11-64 0v-32H320v32a32 32 0 01-64 0v-32H128v128h768v64H128zm192-256h384V96a32 32 0 1164 0v32h160a32 32 0 0132 32v768a32 32 0 01-32 32H96a32 32 0 01-32-32V160a32 32 0 0132-32h160V96a32 32 0 0164 0v32zm-32 384h64a32 32 0 010 64h-64a32 32 0 010-64zm0 192h64a32 32 0 110 64h-64a32 32 0 110-64zm192-192h64a32 32 0 010 64h-64a32 32 0 010-64zm0 192h64a32 32 0 110 64h-64a32 32 0 110-64zm192-192h64a32 32 0 110 64h-64a32 32 0 110-64zm0 192h64a32 32 0 110 64h-64a32 32 0 110-64z"
  }, null, -1);
  const _hoisted_3$W = [
    _hoisted_2$1d
  ];
  function _sfc_render$2e(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1x, _hoisted_3$W);
  }
  var calendar = /* @__PURE__ */ _export_sfc$1(_sfc_main$2I, [["render", _sfc_render$2e]]);

  const _sfc_main$2H = vue.defineComponent({
    name: "CaretRight"
  });
  const _hoisted_1$1w = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1c = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M384 192v640l384-320.064z"
  }, null, -1);
  const _hoisted_3$V = [
    _hoisted_2$1c
  ];
  function _sfc_render$2d(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1w, _hoisted_3$V);
  }
  var caretRight = /* @__PURE__ */ _export_sfc$1(_sfc_main$2H, [["render", _sfc_render$2d]]);

  const _sfc_main$2G = vue.defineComponent({
    name: "CaretTop"
  });
  const _hoisted_1$1v = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1b = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 320L192 704h639.936z"
  }, null, -1);
  const _hoisted_3$U = [
    _hoisted_2$1b
  ];
  function _sfc_render$2c(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1v, _hoisted_3$U);
  }
  var caretTop = /* @__PURE__ */ _export_sfc$1(_sfc_main$2G, [["render", _sfc_render$2c]]);

  const _sfc_main$2F = vue.defineComponent({
    name: "Check"
  });
  const _hoisted_1$1u = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$1a = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M406.656 706.944L195.84 496.256a32 32 0 10-45.248 45.248l256 256 512-512a32 32 0 00-45.248-45.248L406.592 706.944z"
  }, null, -1);
  const _hoisted_3$T = [
    _hoisted_2$1a
  ];
  function _sfc_render$2b(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1u, _hoisted_3$T);
  }
  var check = /* @__PURE__ */ _export_sfc$1(_sfc_main$2F, [["render", _sfc_render$2b]]);

  const _sfc_main$2E = vue.defineComponent({
    name: "CircleCheckFilled"
  });
  const _hoisted_1$1t = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$19 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896 448 448 0 010-896zm-55.808 536.384l-99.52-99.584a38.4 38.4 0 10-54.336 54.336l126.72 126.72a38.272 38.272 0 0054.336 0l262.4-262.464a38.4 38.4 0 10-54.272-54.336L456.192 600.384z"
  }, null, -1);
  const _hoisted_3$S = [
    _hoisted_2$19
  ];
  function _sfc_render$2a(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1t, _hoisted_3$S);
  }
  var circleCheckFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2E, [["render", _sfc_render$2a]]);

  const _sfc_main$2D = vue.defineComponent({
    name: "CircleCheck"
  });
  const _hoisted_1$1s = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$18 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 896a384 384 0 100-768 384 384 0 000 768zm0 64a448 448 0 110-896 448 448 0 010 896z"
  }, null, -1);
  const _hoisted_3$R = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M745.344 361.344a32 32 0 0145.312 45.312l-288 288a32 32 0 01-45.312 0l-160-160a32 32 0 1145.312-45.312L480 626.752l265.344-265.408z"
  }, null, -1);
  const _hoisted_4$i = [
    _hoisted_2$18,
    _hoisted_3$R
  ];
  function _sfc_render$29(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1s, _hoisted_4$i);
  }
  var circleCheck = /* @__PURE__ */ _export_sfc$1(_sfc_main$2D, [["render", _sfc_render$29]]);

  const _sfc_main$2C = vue.defineComponent({
    name: "CircleCloseFilled"
  });
  const _hoisted_1$1r = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$17 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896 448 448 0 010-896zm0 393.664L407.936 353.6a38.4 38.4 0 10-54.336 54.336L457.664 512 353.6 616.064a38.4 38.4 0 1054.336 54.336L512 566.336 616.064 670.4a38.4 38.4 0 1054.336-54.336L566.336 512 670.4 407.936a38.4 38.4 0 10-54.336-54.336L512 457.664z"
  }, null, -1);
  const _hoisted_3$Q = [
    _hoisted_2$17
  ];
  function _sfc_render$28(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1r, _hoisted_3$Q);
  }
  var circleCloseFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2C, [["render", _sfc_render$28]]);

  const _sfc_main$2B = vue.defineComponent({
    name: "CircleClose"
  });
  const _hoisted_1$1q = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$16 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M466.752 512l-90.496-90.496a32 32 0 0145.248-45.248L512 466.752l90.496-90.496a32 32 0 1145.248 45.248L557.248 512l90.496 90.496a32 32 0 11-45.248 45.248L512 557.248l-90.496 90.496a32 32 0 01-45.248-45.248L466.752 512z"
  }, null, -1);
  const _hoisted_3$P = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 896a384 384 0 100-768 384 384 0 000 768zm0 64a448 448 0 110-896 448 448 0 010 896z"
  }, null, -1);
  const _hoisted_4$h = [
    _hoisted_2$16,
    _hoisted_3$P
  ];
  function _sfc_render$27(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1q, _hoisted_4$h);
  }
  var circleClose = /* @__PURE__ */ _export_sfc$1(_sfc_main$2B, [["render", _sfc_render$27]]);

  const _sfc_main$2A = vue.defineComponent({
    name: "Clock"
  });
  const _hoisted_1$1p = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$15 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 896a384 384 0 100-768 384 384 0 000 768zm0 64a448 448 0 110-896 448 448 0 010 896z"
  }, null, -1);
  const _hoisted_3$O = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M480 256a32 32 0 0132 32v256a32 32 0 01-64 0V288a32 32 0 0132-32z"
  }, null, -1);
  const _hoisted_4$g = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M480 512h256q32 0 32 32t-32 32H480q-32 0-32-32t32-32z"
  }, null, -1);
  const _hoisted_5$b = [
    _hoisted_2$15,
    _hoisted_3$O,
    _hoisted_4$g
  ];
  function _sfc_render$26(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1p, _hoisted_5$b);
  }
  var clock = /* @__PURE__ */ _export_sfc$1(_sfc_main$2A, [["render", _sfc_render$26]]);

  const _sfc_main$2z = vue.defineComponent({
    name: "Close"
  });
  const _hoisted_1$1o = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$14 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M764.288 214.592L512 466.88 259.712 214.592a31.936 31.936 0 00-45.12 45.12L466.752 512 214.528 764.224a31.936 31.936 0 1045.12 45.184L512 557.184l252.288 252.288a31.936 31.936 0 0045.12-45.12L557.12 512.064l252.288-252.352a31.936 31.936 0 10-45.12-45.184z"
  }, null, -1);
  const _hoisted_3$N = [
    _hoisted_2$14
  ];
  function _sfc_render$25(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1o, _hoisted_3$N);
  }
  var close$2 = /* @__PURE__ */ _export_sfc$1(_sfc_main$2z, [["render", _sfc_render$25]]);

  const _sfc_main$2y = vue.defineComponent({
    name: "DArrowLeft"
  });
  const _hoisted_1$1n = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$13 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M529.408 149.376a29.12 29.12 0 0141.728 0 30.592 30.592 0 010 42.688L259.264 511.936l311.872 319.936a30.592 30.592 0 01-.512 43.264 29.12 29.12 0 01-41.216-.512L197.76 534.272a32 32 0 010-44.672l331.648-340.224zm256 0a29.12 29.12 0 0141.728 0 30.592 30.592 0 010 42.688L515.264 511.936l311.872 319.936a30.592 30.592 0 01-.512 43.264 29.12 29.12 0 01-41.216-.512L453.76 534.272a32 32 0 010-44.672l331.648-340.224z"
  }, null, -1);
  const _hoisted_3$M = [
    _hoisted_2$13
  ];
  function _sfc_render$24(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1n, _hoisted_3$M);
  }
  var dArrowLeft = /* @__PURE__ */ _export_sfc$1(_sfc_main$2y, [["render", _sfc_render$24]]);

  const _sfc_main$2x = vue.defineComponent({
    name: "DArrowRight"
  });
  const _hoisted_1$1m = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$12 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M452.864 149.312a29.12 29.12 0 0141.728.064L826.24 489.664a32 32 0 010 44.672L494.592 874.624a29.12 29.12 0 01-41.728 0 30.592 30.592 0 010-42.752L764.736 512 452.864 192a30.592 30.592 0 010-42.688zm-256 0a29.12 29.12 0 0141.728.064L570.24 489.664a32 32 0 010 44.672L238.592 874.624a29.12 29.12 0 01-41.728 0 30.592 30.592 0 010-42.752L508.736 512 196.864 192a30.592 30.592 0 010-42.688z"
  }, null, -1);
  const _hoisted_3$L = [
    _hoisted_2$12
  ];
  function _sfc_render$23(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1m, _hoisted_3$L);
  }
  var dArrowRight = /* @__PURE__ */ _export_sfc$1(_sfc_main$2x, [["render", _sfc_render$23]]);

  const _sfc_main$2w = vue.defineComponent({
    name: "Delete"
  });
  const _hoisted_1$1l = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$11 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M160 256H96a32 32 0 010-64h256V95.936a32 32 0 0132-32h256a32 32 0 0132 32V192h256a32 32 0 110 64h-64v672a32 32 0 01-32 32H192a32 32 0 01-32-32V256zm448-64v-64H416v64h192zM224 896h576V256H224v640zm192-128a32 32 0 01-32-32V416a32 32 0 0164 0v320a32 32 0 01-32 32zm192 0a32 32 0 01-32-32V416a32 32 0 0164 0v320a32 32 0 01-32 32z"
  }, null, -1);
  const _hoisted_3$K = [
    _hoisted_2$11
  ];
  function _sfc_render$22(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1l, _hoisted_3$K);
  }
  var _delete = /* @__PURE__ */ _export_sfc$1(_sfc_main$2w, [["render", _sfc_render$22]]);

  const _sfc_main$2v = vue.defineComponent({
    name: "Document"
  });
  const _hoisted_1$1k = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$10 = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M832 384H576V128H192v768h640V384zm-26.496-64L640 154.496V320h165.504zM160 64h480l256 256v608a32 32 0 01-32 32H160a32 32 0 01-32-32V96a32 32 0 0132-32zm160 448h384v64H320v-64zm0-192h160v64H320v-64zm0 384h384v64H320v-64z"
  }, null, -1);
  const _hoisted_3$J = [
    _hoisted_2$10
  ];
  function _sfc_render$21(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1k, _hoisted_3$J);
  }
  var document$1 = /* @__PURE__ */ _export_sfc$1(_sfc_main$2v, [["render", _sfc_render$21]]);

  const _sfc_main$2u = vue.defineComponent({
    name: "FullScreen"
  });
  const _hoisted_1$1j = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$$ = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M160 96.064l192 .192a32 32 0 010 64l-192-.192V352a32 32 0 01-64 0V96h64v.064zm0 831.872V928H96V672a32 32 0 1164 0v191.936l192-.192a32 32 0 110 64l-192 .192zM864 96.064V96h64v256a32 32 0 11-64 0V160.064l-192 .192a32 32 0 110-64l192-.192zm0 831.872l-192-.192a32 32 0 010-64l192 .192V672a32 32 0 1164 0v256h-64v-.064z"
  }, null, -1);
  const _hoisted_3$I = [
    _hoisted_2$$
  ];
  function _sfc_render$20(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1j, _hoisted_3$I);
  }
  var fullScreen = /* @__PURE__ */ _export_sfc$1(_sfc_main$2u, [["render", _sfc_render$20]]);

  const _sfc_main$2t = vue.defineComponent({
    name: "InfoFilled"
  });
  const _hoisted_1$1i = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$_ = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896.064A448 448 0 01512 64zm67.2 275.072c33.28 0 60.288-23.104 60.288-57.344s-27.072-57.344-60.288-57.344c-33.28 0-60.16 23.104-60.16 57.344s26.88 57.344 60.16 57.344zM590.912 699.2c0-6.848 2.368-24.64 1.024-34.752l-52.608 60.544c-10.88 11.456-24.512 19.392-30.912 17.28a12.992 12.992 0 01-8.256-14.72l87.68-276.992c7.168-35.136-12.544-67.2-54.336-71.296-44.096 0-108.992 44.736-148.48 101.504 0 6.784-1.28 23.68.064 33.792l52.544-60.608c10.88-11.328 23.552-19.328 29.952-17.152a12.8 12.8 0 017.808 16.128L388.48 728.576c-10.048 32.256 8.96 63.872 55.04 71.04 67.84 0 107.904-43.648 147.456-100.416z"
  }, null, -1);
  const _hoisted_3$H = [
    _hoisted_2$_
  ];
  function _sfc_render$1$(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1i, _hoisted_3$H);
  }
  var infoFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2t, [["render", _sfc_render$1$]]);

  const _sfc_main$2s = vue.defineComponent({
    name: "Loading"
  });
  const _hoisted_1$1h = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$Z = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a32 32 0 0132 32v192a32 32 0 01-64 0V96a32 32 0 0132-32zm0 640a32 32 0 0132 32v192a32 32 0 11-64 0V736a32 32 0 0132-32zm448-192a32 32 0 01-32 32H736a32 32 0 110-64h192a32 32 0 0132 32zm-640 0a32 32 0 01-32 32H96a32 32 0 010-64h192a32 32 0 0132 32zM195.2 195.2a32 32 0 0145.248 0L376.32 331.008a32 32 0 01-45.248 45.248L195.2 240.448a32 32 0 010-45.248zm452.544 452.544a32 32 0 0145.248 0L828.8 783.552a32 32 0 01-45.248 45.248L647.744 692.992a32 32 0 010-45.248zM828.8 195.264a32 32 0 010 45.184L692.992 376.32a32 32 0 01-45.248-45.248l135.808-135.808a32 32 0 0145.248 0zm-452.544 452.48a32 32 0 010 45.248L240.448 828.8a32 32 0 01-45.248-45.248l135.808-135.808a32 32 0 0145.248 0z"
  }, null, -1);
  const _hoisted_3$G = [
    _hoisted_2$Z
  ];
  function _sfc_render$1_(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1h, _hoisted_3$G);
  }
  var loading = /* @__PURE__ */ _export_sfc$1(_sfc_main$2s, [["render", _sfc_render$1_]]);

  const _sfc_main$2r = vue.defineComponent({
    name: "Minus"
  });
  const _hoisted_1$1g = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$Y = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M128 544h768a32 32 0 100-64H128a32 32 0 000 64z"
  }, null, -1);
  const _hoisted_3$F = [
    _hoisted_2$Y
  ];
  function _sfc_render$1Z(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1g, _hoisted_3$F);
  }
  var minus = /* @__PURE__ */ _export_sfc$1(_sfc_main$2r, [["render", _sfc_render$1Z]]);

  const _sfc_main$2q = vue.defineComponent({
    name: "MoreFilled"
  });
  const _hoisted_1$1f = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$X = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M176 416a112 112 0 110 224 112 112 0 010-224zm336 0a112 112 0 110 224 112 112 0 010-224zm336 0a112 112 0 110 224 112 112 0 010-224z"
  }, null, -1);
  const _hoisted_3$E = [
    _hoisted_2$X
  ];
  function _sfc_render$1Y(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1f, _hoisted_3$E);
  }
  var moreFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2q, [["render", _sfc_render$1Y]]);

  const _sfc_main$2p = vue.defineComponent({
    name: "More"
  });
  const _hoisted_1$1e = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$W = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M176 416a112 112 0 100 224 112 112 0 000-224m0 64a48 48 0 110 96 48 48 0 010-96zm336-64a112 112 0 110 224 112 112 0 010-224zm0 64a48 48 0 100 96 48 48 0 000-96zm336-64a112 112 0 110 224 112 112 0 010-224zm0 64a48 48 0 100 96 48 48 0 000-96z"
  }, null, -1);
  const _hoisted_3$D = [
    _hoisted_2$W
  ];
  function _sfc_render$1X(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1e, _hoisted_3$D);
  }
  var more = /* @__PURE__ */ _export_sfc$1(_sfc_main$2p, [["render", _sfc_render$1X]]);

  const _sfc_main$2o = vue.defineComponent({
    name: "Plus"
  });
  const _hoisted_1$1d = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$V = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M480 480V128a32 32 0 0164 0v352h352a32 32 0 110 64H544v352a32 32 0 11-64 0V544H128a32 32 0 010-64h352z"
  }, null, -1);
  const _hoisted_3$C = [
    _hoisted_2$V
  ];
  function _sfc_render$1W(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1d, _hoisted_3$C);
  }
  var plus = /* @__PURE__ */ _export_sfc$1(_sfc_main$2o, [["render", _sfc_render$1W]]);

  const _sfc_main$2n = vue.defineComponent({
    name: "QuestionFilled"
  });
  const _hoisted_1$1c = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$U = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896 448 448 0 010-896zm23.744 191.488c-52.096 0-92.928 14.784-123.2 44.352-30.976 29.568-45.76 70.4-45.76 122.496h80.256c0-29.568 5.632-52.8 17.6-68.992 13.376-19.712 35.2-28.864 66.176-28.864 23.936 0 42.944 6.336 56.32 19.712 12.672 13.376 19.712 31.68 19.712 54.912 0 17.6-6.336 34.496-19.008 49.984l-8.448 9.856c-45.76 40.832-73.216 70.4-82.368 89.408-9.856 19.008-14.08 42.24-14.08 68.992v9.856h80.96v-9.856c0-16.896 3.52-31.68 10.56-45.76 6.336-12.672 15.488-24.64 28.16-35.2 33.792-29.568 54.208-48.576 60.544-55.616 16.896-22.528 26.048-51.392 26.048-86.592 0-42.944-14.08-76.736-42.24-101.376-28.16-25.344-65.472-37.312-111.232-37.312zm-12.672 406.208a54.272 54.272 0 00-38.72 14.784 49.408 49.408 0 00-15.488 38.016c0 15.488 4.928 28.16 15.488 38.016A54.848 54.848 0 00523.072 768c15.488 0 28.16-4.928 38.72-14.784a51.52 51.52 0 0016.192-38.72 51.968 51.968 0 00-15.488-38.016 55.936 55.936 0 00-39.424-14.784z"
  }, null, -1);
  const _hoisted_3$B = [
    _hoisted_2$U
  ];
  function _sfc_render$1V(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1c, _hoisted_3$B);
  }
  var questionFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2n, [["render", _sfc_render$1V]]);

  const _sfc_main$2m = vue.defineComponent({
    name: "RefreshLeft"
  });
  const _hoisted_1$1b = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$T = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M289.088 296.704h92.992a32 32 0 010 64H232.96a32 32 0 01-32-32V179.712a32 32 0 0164 0v50.56a384 384 0 01643.84 282.88 384 384 0 01-383.936 384 384 384 0 01-384-384h64a320 320 0 10640 0 320 320 0 00-555.712-216.448z"
  }, null, -1);
  const _hoisted_3$A = [
    _hoisted_2$T
  ];
  function _sfc_render$1U(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1b, _hoisted_3$A);
  }
  var refreshLeft = /* @__PURE__ */ _export_sfc$1(_sfc_main$2m, [["render", _sfc_render$1U]]);

  const _sfc_main$2l = vue.defineComponent({
    name: "RefreshRight"
  });
  const _hoisted_1$1a = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$S = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M784.512 230.272v-50.56a32 32 0 1164 0v149.056a32 32 0 01-32 32H667.52a32 32 0 110-64h92.992A320 320 0 10524.8 833.152a320 320 0 00320-320h64a384 384 0 01-384 384 384 384 0 01-384-384 384 384 0 01643.712-282.88z"
  }, null, -1);
  const _hoisted_3$z = [
    _hoisted_2$S
  ];
  function _sfc_render$1T(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$1a, _hoisted_3$z);
  }
  var refreshRight = /* @__PURE__ */ _export_sfc$1(_sfc_main$2l, [["render", _sfc_render$1T]]);

  const _sfc_main$2k = vue.defineComponent({
    name: "ScaleToOriginal"
  });
  const _hoisted_1$19 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$R = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M813.176 180.706a60.235 60.235 0 0160.236 60.235v481.883a60.235 60.235 0 01-60.236 60.235H210.824a60.235 60.235 0 01-60.236-60.235V240.94a60.235 60.235 0 0160.236-60.235h602.352zm0-60.235H210.824A120.47 120.47 0 0090.353 240.94v481.883a120.47 120.47 0 00120.47 120.47h602.353a120.47 120.47 0 00120.471-120.47V240.94a120.47 120.47 0 00-120.47-120.47zm-120.47 180.705a30.118 30.118 0 00-30.118 30.118v301.177a30.118 30.118 0 0060.236 0V331.294a30.118 30.118 0 00-30.118-30.118zm-361.412 0a30.118 30.118 0 00-30.118 30.118v301.177a30.118 30.118 0 1060.236 0V331.294a30.118 30.118 0 00-30.118-30.118zM512 361.412a30.118 30.118 0 00-30.118 30.117v30.118a30.118 30.118 0 0060.236 0V391.53A30.118 30.118 0 00512 361.412zM512 512a30.118 30.118 0 00-30.118 30.118v30.117a30.118 30.118 0 0060.236 0v-30.117A30.118 30.118 0 00512 512z"
  }, null, -1);
  const _hoisted_3$y = [
    _hoisted_2$R
  ];
  function _sfc_render$1S(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$19, _hoisted_3$y);
  }
  var scaleToOriginal = /* @__PURE__ */ _export_sfc$1(_sfc_main$2k, [["render", _sfc_render$1S]]);

  const _sfc_main$2j = vue.defineComponent({
    name: "Search"
  });
  const _hoisted_1$18 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$Q = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M795.904 750.72l124.992 124.928a32 32 0 01-45.248 45.248L750.656 795.904a416 416 0 1145.248-45.248zM480 832a352 352 0 100-704 352 352 0 000 704z"
  }, null, -1);
  const _hoisted_3$x = [
    _hoisted_2$Q
  ];
  function _sfc_render$1R(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$18, _hoisted_3$x);
  }
  var search = /* @__PURE__ */ _export_sfc$1(_sfc_main$2j, [["render", _sfc_render$1R]]);

  const _sfc_main$2i = vue.defineComponent({
    name: "StarFilled"
  });
  const _hoisted_1$17 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$P = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M283.84 867.84L512 747.776l228.16 119.936a6.4 6.4 0 009.28-6.72l-43.52-254.08 184.512-179.904a6.4 6.4 0 00-3.52-10.88l-255.104-37.12L517.76 147.904a6.4 6.4 0 00-11.52 0L392.192 379.072l-255.104 37.12a6.4 6.4 0 00-3.52 10.88L318.08 606.976l-43.584 254.08a6.4 6.4 0 009.28 6.72z"
  }, null, -1);
  const _hoisted_3$w = [
    _hoisted_2$P
  ];
  function _sfc_render$1Q(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$17, _hoisted_3$w);
  }
  var starFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2i, [["render", _sfc_render$1Q]]);

  const _sfc_main$2h = vue.defineComponent({
    name: "Star"
  });
  const _hoisted_1$16 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$O = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 747.84l228.16 119.936a6.4 6.4 0 009.28-6.72l-43.52-254.08 184.512-179.904a6.4 6.4 0 00-3.52-10.88l-255.104-37.12L517.76 147.904a6.4 6.4 0 00-11.52 0L392.192 379.072l-255.104 37.12a6.4 6.4 0 00-3.52 10.88L318.08 606.976l-43.584 254.08a6.4 6.4 0 009.28 6.72L512 747.84zM313.6 924.48a70.4 70.4 0 01-102.144-74.24l37.888-220.928L88.96 472.96A70.4 70.4 0 01128 352.896l221.76-32.256 99.2-200.96a70.4 70.4 0 01126.208 0l99.2 200.96 221.824 32.256a70.4 70.4 0 0139.04 120.064L774.72 629.376l37.888 220.928a70.4 70.4 0 01-102.144 74.24L512 820.096l-198.4 104.32z"
  }, null, -1);
  const _hoisted_3$v = [
    _hoisted_2$O
  ];
  function _sfc_render$1P(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$16, _hoisted_3$v);
  }
  var star = /* @__PURE__ */ _export_sfc$1(_sfc_main$2h, [["render", _sfc_render$1P]]);

  const _sfc_main$2g = vue.defineComponent({
    name: "SuccessFilled"
  });
  const _hoisted_1$15 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$N = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896 448 448 0 010-896zm-55.808 536.384l-99.52-99.584a38.4 38.4 0 10-54.336 54.336l126.72 126.72a38.272 38.272 0 0054.336 0l262.4-262.464a38.4 38.4 0 10-54.272-54.336L456.192 600.384z"
  }, null, -1);
  const _hoisted_3$u = [
    _hoisted_2$N
  ];
  function _sfc_render$1O(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$15, _hoisted_3$u);
  }
  var successFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2g, [["render", _sfc_render$1O]]);

  const _sfc_main$2f = vue.defineComponent({
    name: "View"
  });
  const _hoisted_1$14 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$M = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 160c320 0 512 352 512 352S832 864 512 864 0 512 0 512s192-352 512-352zm0 64c-225.28 0-384.128 208.064-436.8 288 52.608 79.872 211.456 288 436.8 288 225.28 0 384.128-208.064 436.8-288-52.608-79.872-211.456-288-436.8-288zm0 64a224 224 0 110 448 224 224 0 010-448zm0 64a160.192 160.192 0 00-160 160c0 88.192 71.744 160 160 160s160-71.808 160-160-71.744-160-160-160z"
  }, null, -1);
  const _hoisted_3$t = [
    _hoisted_2$M
  ];
  function _sfc_render$1N(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$14, _hoisted_3$t);
  }
  var view = /* @__PURE__ */ _export_sfc$1(_sfc_main$2f, [["render", _sfc_render$1N]]);

  const _sfc_main$2e = vue.defineComponent({
    name: "WarningFilled"
  });
  const _hoisted_1$13 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$L = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M512 64a448 448 0 110 896 448 448 0 010-896zm0 192a58.432 58.432 0 00-58.24 63.744l23.36 256.384a35.072 35.072 0 0069.76 0l23.296-256.384A58.432 58.432 0 00512 256zm0 512a51.2 51.2 0 100-102.4 51.2 51.2 0 000 102.4z"
  }, null, -1);
  const _hoisted_3$s = [
    _hoisted_2$L
  ];
  function _sfc_render$1M(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$13, _hoisted_3$s);
  }
  var warningFilled = /* @__PURE__ */ _export_sfc$1(_sfc_main$2e, [["render", _sfc_render$1M]]);

  const _sfc_main$2d = vue.defineComponent({
    name: "ZoomIn"
  });
  const _hoisted_1$12 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$K = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M795.904 750.72l124.992 124.928a32 32 0 01-45.248 45.248L750.656 795.904a416 416 0 1145.248-45.248zM480 832a352 352 0 100-704 352 352 0 000 704zm-32-384v-96a32 32 0 0164 0v96h96a32 32 0 010 64h-96v96a32 32 0 01-64 0v-96h-96a32 32 0 010-64h96z"
  }, null, -1);
  const _hoisted_3$r = [
    _hoisted_2$K
  ];
  function _sfc_render$1L(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$12, _hoisted_3$r);
  }
  var zoomIn = /* @__PURE__ */ _export_sfc$1(_sfc_main$2d, [["render", _sfc_render$1L]]);

  const _sfc_main$2c = vue.defineComponent({
    name: "ZoomOut"
  });
  const _hoisted_1$11 = {
    class: "icon",
    width: "200",
    height: "200",
    viewBox: "0 0 1024 1024",
    xmlns: "http://www.w3.org/2000/svg"
  };
  const _hoisted_2$J = /* @__PURE__ */ vue.createElementVNode("path", {
    fill: "currentColor",
    d: "M795.904 750.72l124.992 124.928a32 32 0 01-45.248 45.248L750.656 795.904a416 416 0 1145.248-45.248zM480 832a352 352 0 100-704 352 352 0 000 704zM352 448h256a32 32 0 010 64H352a32 32 0 010-64z"
  }, null, -1);
  const _hoisted_3$q = [
    _hoisted_2$J
  ];
  function _sfc_render$1K(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$11, _hoisted_3$q);
  }
  var zoomOut = /* @__PURE__ */ _export_sfc$1(_sfc_main$2c, [["render", _sfc_render$1K]]);

  const wrapperKey = Symbol();
  const propKey = "__elPropsReservedKey";
  function buildProp(option, key) {
    if (!isObject$1(option) || !!option[propKey])
      return option;
    const { values, required, default: defaultValue, type, validator } = option;
    const _validator = values || validator ? (val) => {
      let valid = false;
      let allowedValues = [];
      if (values) {
        allowedValues = Array.from(values);
        if (hasOwn(option, "default")) {
          allowedValues.push(defaultValue);
        }
        valid || (valid = allowedValues.includes(val));
      }
      if (validator)
        valid || (valid = validator(val));
      if (!valid && allowedValues.length > 0) {
        const allowValuesText = [...new Set(allowedValues)].map((value) => JSON.stringify(value)).join(", ");
        vue.warn(`Invalid prop: validation failed${key ? ` for prop "${key}"` : ""}. Expected one of [${allowValuesText}], got value ${JSON.stringify(val)}.`);
      }
      return valid;
    } : void 0;
    const prop = {
      type: isObject$1(type) && Object.getOwnPropertySymbols(type).includes(wrapperKey) ? type[wrapperKey] : type,
      required: !!required,
      validator: _validator,
      [propKey]: true
    };
    if (hasOwn(option, "default"))
      prop.default = defaultValue;
    return prop;
  }
  const buildProps = (props) => fromPairs(Object.entries(props).map(([key, option]) => [
    key,
    buildProp(option, key)
  ]));
  const definePropType = (val) => ({ [wrapperKey]: val });

  const iconPropType = definePropType([
    String,
    Object,
    Function
  ]);
  const CloseComponents = {
    Close: close$2
  };
  const TypeComponents = {
    Close: close$2,
    SuccessFilled: successFilled,
    InfoFilled: infoFilled,
    WarningFilled: warningFilled,
    CircleCloseFilled: circleCloseFilled
  };
  const TypeComponentsMap = {
    success: successFilled,
    warning: warningFilled,
    error: circleCloseFilled,
    info: infoFilled
  };
  const ValidateComponentsMap = {
    validating: loading,
    success: circleCheck,
    error: circleClose
  };

  const withInstall = (main, extra) => {
    main.install = (app) => {
      for (const comp of [main, ...Object.values(extra != null ? extra : {})]) {
        app.component(comp.name, comp);
      }
    };
    if (extra) {
      for (const [key, comp] of Object.entries(extra)) {
        main[key] = comp;
      }
    }
    return main;
  };
  const withInstallFunction = (fn, name) => {
    fn.install = (app) => {
      fn._context = app._context;
      app.config.globalProperties[name] = fn;
    };
    return fn;
  };
  const withNoopInstall = (component) => {
    component.install = NOOP;
    return component;
  };

  const composeRefs = (...refs) => {
    return (el) => {
      refs.forEach((ref) => {
        ref.value = el;
      });
    };
  };

  class ElementPlusError extends Error {
    constructor(m) {
      super(m);
      this.name = "ElementPlusError";
    }
  }
  function throwError(scope, m) {
    throw new ElementPlusError(`[${scope}] ${m}`);
  }
  function debugWarn(scope, message) {
  }

  function addUnit(value, defaultUnit = "px") {
    if (!value)
      return "";
    if (isString(value)) {
      return value;
    } else if (isNumber(value)) {
      return `${value}${defaultUnit}`;
    }
  }

  const EVENT_CODE = {
    tab: "Tab",
    enter: "Enter",
    space: "Space",
    left: "ArrowLeft",
    up: "ArrowUp",
    right: "ArrowRight",
    down: "ArrowDown",
    esc: "Escape",
    delete: "Delete",
    backspace: "Backspace",
    numpadEnter: "NumpadEnter",
    pageUp: "PageUp",
    pageDown: "PageDown",
    home: "Home",
    end: "End"
  };

  const datePickTypes = [
    "year",
    "month",
    "date",
    "dates",
    "week",
    "datetime",
    "datetimerange",
    "daterange",
    "monthrange"
  ];

  const UPDATE_MODEL_EVENT = "update:modelValue";
  const CHANGE_EVENT = "change";
  const INPUT_EVENT = "input";

  const componentSizes = ["default", "small", "large"];

  const isValidComponentSize = (val) => ["", ...componentSizes].includes(val);
  const isValidDatePickType = (val) => [...datePickTypes].includes(val);

  var PatchFlags = /* @__PURE__ */ ((PatchFlags2) => {
    PatchFlags2[PatchFlags2["TEXT"] = 1] = "TEXT";
    PatchFlags2[PatchFlags2["CLASS"] = 2] = "CLASS";
    PatchFlags2[PatchFlags2["STYLE"] = 4] = "STYLE";
    PatchFlags2[PatchFlags2["PROPS"] = 8] = "PROPS";
    PatchFlags2[PatchFlags2["FULL_PROPS"] = 16] = "FULL_PROPS";
    PatchFlags2[PatchFlags2["HYDRATE_EVENTS"] = 32] = "HYDRATE_EVENTS";
    PatchFlags2[PatchFlags2["STABLE_FRAGMENT"] = 64] = "STABLE_FRAGMENT";
    PatchFlags2[PatchFlags2["KEYED_FRAGMENT"] = 128] = "KEYED_FRAGMENT";
    PatchFlags2[PatchFlags2["UNKEYED_FRAGMENT"] = 256] = "UNKEYED_FRAGMENT";
    PatchFlags2[PatchFlags2["NEED_PATCH"] = 512] = "NEED_PATCH";
    PatchFlags2[PatchFlags2["DYNAMIC_SLOTS"] = 1024] = "DYNAMIC_SLOTS";
    PatchFlags2[PatchFlags2["HOISTED"] = -1] = "HOISTED";
    PatchFlags2[PatchFlags2["BAIL"] = -2] = "BAIL";
    return PatchFlags2;
  })(PatchFlags || {});
  function isFragment(node) {
    return vue.isVNode(node) && node.type === vue.Fragment;
  }
  function isComment(node) {
    return vue.isVNode(node) && node.type === vue.Comment;
  }
  function isValidElementNode(node) {
    return vue.isVNode(node) && !isFragment(node) && !isComment(node);
  }
  const getNormalizedProps = (node) => {
    if (!vue.isVNode(node)) {
      return {};
    }
    const raw = node.props || {};
    const type = (vue.isVNode(node.type) ? node.type.props : void 0) || {};
    const props = {};
    Object.keys(type).forEach((key) => {
      if (hasOwn(type[key], "default")) {
        props[key] = type[key].default;
      }
    });
    Object.keys(raw).forEach((key) => {
      props[vue.camelize(key)] = raw[key];
    });
    return props;
  };

  const cubic = (value) => value ** 3;
  const easeInOutCubic = (value) => value < 0.5 ? cubic(value * 2) / 2 : 1 - cubic((1 - value) * 2) / 2;

  const unique = (arr) => [...new Set(arr)];
  const castArray = (arr) => {
    if (!arr && arr !== 0)
      return [];
    return Array.isArray(arr) ? arr : [arr];
  };

  const isFirefox = () => isClient && /firefox/i.test(window.navigator.userAgent);

  const isKorean = (text) => /([(\uAC00-\uD7AF)|(\u3130-\u318F)])+/gi.test(text);

  const rAF = (fn) => isClient ? window.requestAnimationFrame(fn) : setTimeout(fn, 16);
  const cAF = (handle) => isClient ? window.cancelAnimationFrame(handle) : clearTimeout(handle);

  const generateId = () => Math.floor(Math.random() * 1e4);

  const mutable = (val) => val;

  const DEFAULT_EXCLUDE_KEYS = ["class", "style"];
  const LISTENER_PREFIX = /^on[A-Z]/;
  const useAttrs = (params = {}) => {
    const { excludeListeners = false, excludeKeys = [] } = params;
    const allExcludeKeys = excludeKeys.concat(DEFAULT_EXCLUDE_KEYS);
    const instance = vue.getCurrentInstance();
    if (!instance) {
      return vue.computed(() => ({}));
    }
    return vue.computed(() => {
      var _a;
      return fromPairs(Object.entries((_a = instance.proxy) == null ? void 0 : _a.$attrs).filter(([key]) => !allExcludeKeys.includes(key) && !(excludeListeners && LISTENER_PREFIX.test(key))));
    });
  };

  const breadcrumbKey = Symbol("breadcrumbKey");

  const buttonGroupContextKey = Symbol("buttonGroupContextKey");

  const collapseContextKey = Symbol("collapseContextKey");

  const configProviderContextKey = Symbol();

  const dialogInjectionKey = Symbol("dialogInjectionKey");

  const formContextKey = Symbol("formContextKey");
  const formItemContextKey = Symbol("formItemContextKey");

  const elPaginationKey = Symbol("elPaginationKey");

  const radioGroupKey = Symbol("radioGroupKey");

  const rowContextKey = Symbol("rowContextKey");

  const scrollbarContextKey = Symbol("scrollbarContextKey");

  const tabsRootContextKey = Symbol("tabsRootContextKey");

  const uploadContextKey = Symbol("uploadContextKey");

  const useProp = (name) => {
    const vm = vue.getCurrentInstance();
    return vue.computed(() => {
      var _a, _b;
      return (_b = (_a = vm.proxy) == null ? void 0 : _a.$props[name]) != null ? _b : void 0;
    });
  };

  const globalConfig = vue.ref();
  function useGlobalConfig(key, defaultValue = void 0) {
    const config = vue.getCurrentInstance() ? vue.inject(configProviderContextKey, globalConfig) : globalConfig;
    if (key) {
      return vue.computed(() => {
        var _a, _b;
        return (_b = (_a = config.value) == null ? void 0 : _a[key]) != null ? _b : defaultValue;
      });
    } else {
      return config;
    }
  }
  const provideGlobalConfig = (config, app, global = false) => {
    var _a;
    const inSetup = !!vue.getCurrentInstance();
    const oldConfig = inSetup ? useGlobalConfig() : void 0;
    const provideFn = (_a = app == null ? void 0 : app.provide) != null ? _a : inSetup ? vue.provide : void 0;
    if (!provideFn) {
      return;
    }
    const context = vue.computed(() => {
      const cfg = vue.unref(config);
      if (!(oldConfig == null ? void 0 : oldConfig.value))
        return cfg;
      return mergeConfig(oldConfig.value, cfg);
    });
    provideFn(configProviderContextKey, context);
    if (global || !globalConfig.value) {
      globalConfig.value = context.value;
    }
    return context;
  };
  const mergeConfig = (a, b) => {
    var _a;
    const keys = [.../* @__PURE__ */ new Set([...keysOf(a), ...keysOf(b)])];
    const obj = {};
    for (const key of keys) {
      obj[key] = (_a = b[key]) != null ? _a : a[key];
    }
    return obj;
  };

  const useSizeProp = buildProp({
    type: String,
    values: componentSizes,
    required: false
  });
  const useSize = (fallback, ignore = {}) => {
    const emptyRef = vue.ref(void 0);
    const size = ignore.prop ? emptyRef : useProp("size");
    const globalConfig = ignore.global ? emptyRef : useGlobalConfig("size");
    const form = ignore.form ? { size: void 0 } : vue.inject(formContextKey, void 0);
    const formItem = ignore.formItem ? { size: void 0 } : vue.inject(formItemContextKey, void 0);
    return vue.computed(() => size.value || vue.unref(fallback) || (formItem == null ? void 0 : formItem.size) || (form == null ? void 0 : form.size) || globalConfig.value || "default");
  };
  const useDisabled$1 = (fallback) => {
    const disabled = useProp("disabled");
    const form = vue.inject(formContextKey, void 0);
    return vue.computed(() => disabled.value || vue.unref(fallback) || (form == null ? void 0 : form.disabled) || false);
  };

  const useDeprecated = ({ from, replacement, scope, version, ref }, condition) => {
    vue.watch(() => vue.unref(condition), (val) => {
    }, {
      immediate: true
    });
  };

  const useDraggable = (targetRef, dragRef, draggable) => {
    let transform = {
      offsetX: 0,
      offsetY: 0
    };
    const onMousedown = (e) => {
      const downX = e.clientX;
      const downY = e.clientY;
      const { offsetX, offsetY } = transform;
      const targetRect = targetRef.value.getBoundingClientRect();
      const targetLeft = targetRect.left;
      const targetTop = targetRect.top;
      const targetWidth = targetRect.width;
      const targetHeight = targetRect.height;
      const clientWidth = document.documentElement.clientWidth;
      const clientHeight = document.documentElement.clientHeight;
      const minLeft = -targetLeft + offsetX;
      const minTop = -targetTop + offsetY;
      const maxLeft = clientWidth - targetLeft - targetWidth + offsetX;
      const maxTop = clientHeight - targetTop - targetHeight + offsetY;
      const onMousemove = (e2) => {
        const moveX = Math.min(Math.max(offsetX + e2.clientX - downX, minLeft), maxLeft);
        const moveY = Math.min(Math.max(offsetY + e2.clientY - downY, minTop), maxTop);
        transform = {
          offsetX: moveX,
          offsetY: moveY
        };
        targetRef.value.style.transform = `translate(${addUnit(moveX)}, ${addUnit(moveY)})`;
      };
      const onMouseup = () => {
        document.removeEventListener("mousemove", onMousemove);
        document.removeEventListener("mouseup", onMouseup);
      };
      document.addEventListener("mousemove", onMousemove);
      document.addEventListener("mouseup", onMouseup);
    };
    const onDraggable = () => {
      if (dragRef.value && targetRef.value) {
        dragRef.value.addEventListener("mousedown", onMousedown);
      }
    };
    const offDraggable = () => {
      if (dragRef.value && targetRef.value) {
        dragRef.value.removeEventListener("mousedown", onMousedown);
      }
    };
    vue.onMounted(() => {
      vue.watchEffect(() => {
        if (draggable.value) {
          onDraggable();
        } else {
          offDraggable();
        }
      });
    });
    vue.onBeforeUnmount(() => {
      offDraggable();
    });
  };

  const useFocus = (el) => {
    return {
      focus: () => {
        var _a, _b;
        (_b = (_a = el.value) == null ? void 0 : _a.focus) == null ? void 0 : _b.call(_a);
      }
    };
  };

  const useFormItem = () => {
    const form = vue.inject(formContextKey, void 0);
    const formItem = vue.inject(formItemContextKey, void 0);
    return {
      form,
      formItem
    };
  };

  var English = {
    name: "en",
    el: {
      colorpicker: {
        confirm: "OK",
        clear: "Clear"
      },
      datepicker: {
        now: "Now",
        today: "Today",
        cancel: "Cancel",
        clear: "Clear",
        confirm: "OK",
        selectDate: "Select date",
        selectTime: "Select time",
        startDate: "Start Date",
        startTime: "Start Time",
        endDate: "End Date",
        endTime: "End Time",
        prevYear: "Previous Year",
        nextYear: "Next Year",
        prevMonth: "Previous Month",
        nextMonth: "Next Month",
        year: "",
        month1: "January",
        month2: "February",
        month3: "March",
        month4: "April",
        month5: "May",
        month6: "June",
        month7: "July",
        month8: "August",
        month9: "September",
        month10: "October",
        month11: "November",
        month12: "December",
        week: "week",
        weeks: {
          sun: "Sun",
          mon: "Mon",
          tue: "Tue",
          wed: "Wed",
          thu: "Thu",
          fri: "Fri",
          sat: "Sat"
        },
        months: {
          jan: "Jan",
          feb: "Feb",
          mar: "Mar",
          apr: "Apr",
          may: "May",
          jun: "Jun",
          jul: "Jul",
          aug: "Aug",
          sep: "Sep",
          oct: "Oct",
          nov: "Nov",
          dec: "Dec"
        }
      },
      select: {
        loading: "Loading",
        noMatch: "No matching data",
        noData: "No data",
        placeholder: "Select"
      },
      cascader: {
        noMatch: "No matching data",
        loading: "Loading",
        placeholder: "Select",
        noData: "No data"
      },
      pagination: {
        goto: "Go to",
        pagesize: "/page",
        total: "Total {total}",
        pageClassifier: "",
        deprecationWarning: "Deprecated usages detected, please refer to the el-pagination documentation for more details"
      },
      messagebox: {
        title: "Message",
        confirm: "OK",
        cancel: "Cancel",
        error: "Illegal input"
      },
      upload: {
        deleteTip: "press delete to remove",
        delete: "Delete",
        preview: "Preview",
        continue: "Continue"
      },
      table: {
        emptyText: "No Data",
        confirmFilter: "Confirm",
        resetFilter: "Reset",
        clearFilter: "All",
        sumText: "Sum"
      },
      tree: {
        emptyText: "No Data"
      },
      transfer: {
        noMatch: "No matching data",
        noData: "No data",
        titles: ["List 1", "List 2"],
        filterPlaceholder: "Enter keyword",
        noCheckedFormat: "{total} items",
        hasCheckedFormat: "{checked}/{total} checked"
      },
      image: {
        error: "FAILED"
      },
      pageHeader: {
        title: "Back"
      },
      popconfirm: {
        confirmButtonText: "Yes",
        cancelButtonText: "No"
      }
    }
  };

  const buildTranslator = (locale) => (path, option) => translate(path, option, vue.unref(locale));
  const translate = (path, option, locale) => get(locale, path, path).replace(/\{(\w+)\}/g, (_, key) => {
    var _a;
    return `${(_a = option == null ? void 0 : option[key]) != null ? _a : `{${key}}`}`;
  });
  const buildLocaleContext = (locale) => {
    const lang = vue.computed(() => vue.unref(locale).name);
    const localeRef = vue.isRef(locale) ? locale : vue.ref(locale);
    return {
      lang,
      locale: localeRef,
      t: buildTranslator(locale)
    };
  };
  const useLocale = () => {
    const locale = useGlobalConfig("locale");
    return buildLocaleContext(vue.computed(() => locale.value || English));
  };

  const useLockscreen = (trigger) => {
    if (!vue.isRef(trigger)) {
      throwError("[useLockscreen]", "You need to pass a ref param to this function");
    }
    if (!isClient || hasClass(document.body, "el-popup-parent--hidden")) {
      return;
    }
    let scrollBarWidth = 0;
    let withoutHiddenClass = false;
    let bodyPaddingRight = "0";
    let computedBodyPaddingRight = 0;
    const cleanup = () => {
      removeClass(document.body, "el-popup-parent--hidden");
      if (withoutHiddenClass) {
        document.body.style.paddingRight = bodyPaddingRight;
      }
    };
    vue.watch(trigger, (val) => {
      if (!val) {
        cleanup();
        return;
      }
      withoutHiddenClass = !hasClass(document.body, "el-popup-parent--hidden");
      if (withoutHiddenClass) {
        bodyPaddingRight = document.body.style.paddingRight;
        computedBodyPaddingRight = Number.parseInt(getStyle(document.body, "paddingRight"), 10);
      }
      scrollBarWidth = getScrollBarWidth();
      const bodyHasOverflow = document.documentElement.clientHeight < document.body.scrollHeight;
      const bodyOverflowY = getStyle(document.body, "overflowY");
      if (scrollBarWidth > 0 && (bodyHasOverflow || bodyOverflowY === "scroll") && withoutHiddenClass) {
        document.body.style.paddingRight = `${computedBodyPaddingRight + scrollBarWidth}px`;
      }
      addClass(document.body, "el-popup-parent--hidden");
    });
    vue.onScopeDispose(() => cleanup());
  };

  const modalStack = [];
  const closeModal = (e) => {
    if (modalStack.length === 0)
      return;
    if (e.code === EVENT_CODE.esc) {
      e.stopPropagation();
      const topModal = modalStack[modalStack.length - 1];
      topModal.handleClose();
    }
  };
  const useModal = (instance, visibleRef) => {
    vue.watch(visibleRef, (val) => {
      if (val) {
        modalStack.push(instance);
      } else {
        modalStack.splice(modalStack.indexOf(instance), 1);
      }
    });
  };
  if (isClient)
    useEventListener(document, "keydown", closeModal);

  const _prop = buildProp({
    type: definePropType(Boolean),
    default: null
  });
  const _event = buildProp({
    type: definePropType(Function)
  });
  const createModelToggleComposable = (name) => {
    const useModelToggleProps2 = {
      [name]: _prop,
      [`onUpdate:${name}`]: _event
    };
    const useModelToggleEmits2 = [`update:${name}`];
    const useModelToggle2 = ({
      indicator,
      shouldHideWhenRouteChanges,
      shouldProceed,
      onShow,
      onHide
    }) => {
      const instance = vue.getCurrentInstance();
      const props = instance.props;
      const { emit } = instance;
      const updateEventKey = `update:${name}`;
      const hasUpdateHandler = vue.computed(() => isFunction(props[`onUpdate:${name}`]));
      const isModelBindingAbsent = vue.computed(() => props[name] === null);
      const doShow = () => {
        if (indicator.value === true) {
          return;
        }
        indicator.value = true;
        if (isFunction(onShow)) {
          onShow();
        }
      };
      const doHide = () => {
        if (indicator.value === false) {
          return;
        }
        indicator.value = false;
        if (isFunction(onHide)) {
          onHide();
        }
      };
      const show = () => {
        if (props.disabled === true || isFunction(shouldProceed) && !shouldProceed())
          return;
        const shouldEmit = hasUpdateHandler.value && isClient;
        if (shouldEmit) {
          emit(updateEventKey, true);
        }
        if (isModelBindingAbsent.value || !shouldEmit) {
          doShow();
        }
      };
      const hide = () => {
        if (props.disabled === true || !isClient)
          return;
        const shouldEmit = hasUpdateHandler.value && isClient;
        if (shouldEmit) {
          emit(updateEventKey, false);
        }
        if (isModelBindingAbsent.value || !shouldEmit) {
          doHide();
        }
      };
      const onChange = (val) => {
        if (!isBoolean(val))
          return;
        if (props.disabled && val) {
          if (hasUpdateHandler.value) {
            emit(updateEventKey, false);
          }
        } else if (indicator.value !== val) {
          if (val) {
            doShow();
          } else {
            doHide();
          }
        }
      };
      const toggle = () => {
        if (indicator.value) {
          hide();
        } else {
          show();
        }
      };
      vue.watch(() => props[name], onChange);
      if (shouldHideWhenRouteChanges && instance.appContext.config.globalProperties.$route !== void 0) {
        vue.watch(() => ({
          ...instance.proxy.$route
        }), () => {
          if (shouldHideWhenRouteChanges.value && indicator.value) {
            hide();
          }
        });
      }
      vue.onMounted(() => {
        onChange(props[name]);
      });
      return {
        hide,
        show,
        toggle
      };
    };
    return {
      useModelToggle: useModelToggle2,
      useModelToggleProps: useModelToggleProps2,
      useModelToggleEmits: useModelToggleEmits2
    };
  };
  const { useModelToggle: useModelToggle$1, useModelToggleProps: useModelToggleProps$1, useModelToggleEmits: useModelToggleEmits$1 } = createModelToggleComposable("modelValue");

  const usePreventGlobal = (indicator, evt, cb) => {
    const prevent = (e) => {
      if (cb(e))
        e.stopImmediatePropagation();
    };
    let stop = void 0;
    vue.watch(() => indicator.value, (val) => {
      if (val) {
        stop = useEventListener(document, evt, prevent, true);
      } else {
        stop == null ? void 0 : stop();
      }
    }, { immediate: true });
  };

  const useRestoreActive = (toggle, initialFocus) => {
    let previousActive;
    vue.watch(() => toggle.value, (val) => {
      var _a, _b;
      if (val) {
        previousActive = document.activeElement;
        if (vue.isRef(initialFocus)) {
          (_b = (_a = initialFocus.value).focus) == null ? void 0 : _b.call(_a);
        }
      } else {
        {
          previousActive.focus();
        }
      }
    });
  };

  const useSameTarget = (handleClick) => {
    if (!handleClick) {
      return { onClick: NOOP, onMousedown: NOOP, onMouseup: NOOP };
    }
    let mousedownTarget = false;
    let mouseupTarget = false;
    const onClick = (e) => {
      if (mousedownTarget && mouseupTarget) {
        handleClick(e);
      }
      mousedownTarget = mouseupTarget = false;
    };
    const onMousedown = (e) => {
      mousedownTarget = e.target === e.currentTarget;
    };
    const onMouseup = (e) => {
      mouseupTarget = e.target === e.currentTarget;
    };
    return { onClick, onMousedown, onMouseup };
  };

  const useTeleport = (contentRenderer, appendToBody) => {
    const isTeleportVisible = vue.ref(false);
    if (!isClient) {
      return {
        isTeleportVisible,
        showTeleport: NOOP,
        hideTeleport: NOOP,
        renderTeleport: NOOP
      };
    }
    let $el = null;
    const showTeleport = () => {
      isTeleportVisible.value = true;
      if ($el !== null)
        return;
      $el = createGlobalNode();
    };
    const hideTeleport = () => {
      isTeleportVisible.value = false;
      if ($el !== null) {
        removeGlobalNode($el);
        $el = null;
      }
    };
    const renderTeleport = () => {
      return appendToBody.value !== true ? contentRenderer() : isTeleportVisible.value ? [vue.h(vue.Teleport, { to: $el }, contentRenderer())] : void 0;
    };
    vue.onUnmounted(hideTeleport);
    return {
      isTeleportVisible,
      showTeleport,
      hideTeleport,
      renderTeleport
    };
  };

  const useThrottleRender = (loading, throttle = 0) => {
    if (throttle === 0)
      return loading;
    const throttled = vue.ref(false);
    let timeoutHandle = 0;
    const dispatchThrottling = () => {
      if (timeoutHandle) {
        clearTimeout(timeoutHandle);
      }
      timeoutHandle = window.setTimeout(() => {
        throttled.value = loading.value;
      }, throttle);
    };
    vue.onMounted(dispatchThrottling);
    vue.watch(() => loading.value, (val) => {
      if (val) {
        dispatchThrottling();
      } else {
        throttled.value = val;
      }
    });
    return throttled;
  };

  function useTimeout() {
    let timeoutHandle;
    const registerTimeout = (fn, delay) => {
      cancelTimeout();
      timeoutHandle = window.setTimeout(fn, delay);
    };
    const cancelTimeout = () => window.clearTimeout(timeoutHandle);
    tryOnScopeDispose(() => cancelTimeout());
    return {
      registerTimeout,
      cancelTimeout
    };
  }

  const AFTER_APPEAR = "after-appear";
  const AFTER_ENTER = "after-enter";
  const AFTER_LEAVE = "after-leave";
  const APPEAR = "appear";
  const APPEAR_CANCELLED = "appear-cancelled";
  const BEFORE_ENTER = "before-enter";
  const BEFORE_LEAVE = "before-leave";
  const ENTER = "enter";
  const ENTER_CANCELLED = "enter-cancelled";
  const LEAVE = "leave";
  const LEAVE_CANCELLED = "leave-cancelled";
  const useTransitionFallthroughEmits = [
    AFTER_APPEAR,
    AFTER_ENTER,
    AFTER_LEAVE,
    APPEAR,
    APPEAR_CANCELLED,
    BEFORE_ENTER,
    BEFORE_LEAVE,
    ENTER,
    ENTER_CANCELLED,
    LEAVE,
    LEAVE_CANCELLED
  ];
  const useTransitionFallthrough = () => {
    const { emit } = vue.getCurrentInstance();
    return {
      onAfterAppear: () => {
        emit(AFTER_APPEAR);
      },
      onAfterEnter: () => {
        emit(AFTER_ENTER);
      },
      onAfterLeave: () => {
        emit(AFTER_LEAVE);
      },
      onAppearCancelled: () => {
        emit(APPEAR_CANCELLED);
      },
      onBeforeEnter: () => {
        emit(BEFORE_ENTER);
      },
      onBeforeLeave: () => {
        emit(BEFORE_LEAVE);
      },
      onEnter: () => {
        emit(ENTER);
      },
      onEnterCancelled: () => {
        emit(ENTER_CANCELLED);
      },
      onLeave: () => {
        emit(LEAVE);
      },
      onLeaveCancelled: () => {
        emit(LEAVE_CANCELLED);
      }
    };
  };

  const defaultIdInjection = {
    prefix: Math.floor(Math.random() * 1e4),
    current: 0
  };
  const ID_INJECTION_KEY = Symbol("elIdInjection");
  const useId = (deterministicId) => {
    const idInjection = vue.inject(ID_INJECTION_KEY, defaultIdInjection);
    const idRef = vue.computed(() => vue.unref(deterministicId) || `el-id-${idInjection.prefix}-${idInjection.current++}`);
    return idRef;
  };

  const useEscapeKeydown = (handler) => {
    const cachedHandler = (e) => {
      const event = e;
      if (event.key === EVENT_CODE.esc) {
        handler == null ? void 0 : handler(event);
      }
    };
    vue.onMounted(() => {
      on(document, "keydown", cachedHandler);
    });
    vue.onBeforeUnmount(() => {
      off(document, "keydown", cachedHandler);
    });
  };

  let cachedContainer;
  const POPPER_CONTAINER_ID = `el-popper-container-${generateId()}`;
  const POPPER_CONTAINER_SELECTOR = `#${POPPER_CONTAINER_ID}`;
  const usePopperContainer = () => {
    vue.onBeforeMount(() => {
      if (!isClient)
        return;
      if (!cachedContainer) {
        const container = document.createElement("div");
        container.id = POPPER_CONTAINER_ID;
        document.body.appendChild(container);
        cachedContainer = container;
      }
    });
  };

  const useDelayedRender = ({
    indicator,
    intermediateIndicator,
    shouldSetIntermediate = () => true,
    beforeShow,
    afterShow,
    afterHide,
    beforeHide
  }) => {
    vue.watch(() => vue.unref(indicator), (val) => {
      if (val) {
        beforeShow == null ? void 0 : beforeShow();
        vue.nextTick(() => {
          if (!vue.unref(indicator))
            return;
          if (shouldSetIntermediate("show")) {
            intermediateIndicator.value = true;
          }
        });
      } else {
        beforeHide == null ? void 0 : beforeHide();
        vue.nextTick(() => {
          if (vue.unref(indicator))
            return;
          if (shouldSetIntermediate("hide")) {
            intermediateIndicator.value = false;
          }
        });
      }
    });
    vue.watch(() => intermediateIndicator.value, (val) => {
      if (val) {
        afterShow == null ? void 0 : afterShow();
      } else {
        afterHide == null ? void 0 : afterHide();
      }
    });
  };

  const useDelayedToggleProps = buildProps({
    showAfter: {
      type: Number,
      default: 0
    },
    hideAfter: {
      type: Number,
      default: 200
    }
  });
  const useDelayedToggle = ({
    showAfter,
    hideAfter,
    open,
    close
  }) => {
    const { registerTimeout } = useTimeout();
    const onOpen = () => {
      registerTimeout(() => {
        open();
      }, vue.unref(showAfter));
    };
    const onClose = () => {
      registerTimeout(() => {
        close();
      }, vue.unref(hideAfter));
    };
    return {
      onOpen,
      onClose
    };
  };

  const FORWARD_REF_INJECTION_KEY = Symbol("elForwardRef");
  const useForwardRef = (forwardRef) => {
    const setForwardRef = (el) => {
      forwardRef.value = el;
    };
    vue.provide(FORWARD_REF_INJECTION_KEY, {
      setForwardRef
    });
  };
  const useForwardRefDirective = (setForwardRef) => {
    return {
      mounted(el) {
        setForwardRef(el);
      },
      updated(el) {
        setForwardRef(el);
      },
      unmounted() {
        setForwardRef(null);
      }
    };
  };

  const defaultNamespace = "el";
  const statePrefix = "is-";
  const _bem = (namespace, block, blockSuffix, element, modifier) => {
    let cls = `${namespace}-${block}`;
    if (blockSuffix) {
      cls += `-${blockSuffix}`;
    }
    if (element) {
      cls += `__${element}`;
    }
    if (modifier) {
      cls += `--${modifier}`;
    }
    return cls;
  };
  const useNamespace = (block) => {
    const globalConfig = useGlobalConfig("namespace");
    const namespace = vue.computed(() => globalConfig.value || defaultNamespace);
    const b = (blockSuffix = "") => _bem(vue.unref(namespace), block, blockSuffix, "", "");
    const e = (element) => element ? _bem(vue.unref(namespace), block, "", element, "") : "";
    const m = (modifier) => modifier ? _bem(vue.unref(namespace), block, "", "", modifier) : "";
    const be = (blockSuffix, element) => blockSuffix && element ? _bem(vue.unref(namespace), block, blockSuffix, element, "") : "";
    const em = (element, modifier) => element && modifier ? _bem(vue.unref(namespace), block, "", element, modifier) : "";
    const bm = (blockSuffix, modifier) => blockSuffix && modifier ? _bem(vue.unref(namespace), block, blockSuffix, "", modifier) : "";
    const bem = (blockSuffix, element, modifier) => blockSuffix && element && modifier ? _bem(vue.unref(namespace), block, blockSuffix, element, modifier) : "";
    const is = (name, ...args) => {
      const state = args.length >= 1 ? args[0] : true;
      return name && state ? `${statePrefix}${name}` : "";
    };
    return {
      namespace,
      b,
      e,
      m,
      be,
      em,
      bm,
      bem,
      is
    };
  };

  const zIndex = vue.ref(0);
  const useZIndex = () => {
    const initialZIndex = useGlobalConfig("zIndex", 2e3);
    const currentZIndex = vue.computed(() => initialZIndex.value + zIndex.value);
    const nextZIndex = () => {
      zIndex.value++;
      return currentZIndex.value;
    };
    return {
      initialZIndex,
      currentZIndex,
      nextZIndex
    };
  };

  const version$1 = "2.1.0";

  const INSTALLED_KEY = Symbol("INSTALLED_KEY");
  const makeInstaller = (components = []) => {
    const install = (app, options = {}) => {
      if (app[INSTALLED_KEY])
        return;
      app[INSTALLED_KEY] = true;
      components.forEach((c) => app.use(c));
      provideGlobalConfig(options, app, true);
    };
    return {
      version: version$1,
      install
    };
  };

  const affixProps = buildProps({
    zIndex: {
      type: definePropType([Number, String]),
      default: 100
    },
    target: {
      type: String,
      default: ""
    },
    offset: {
      type: Number,
      default: 0
    },
    position: {
      type: String,
      values: ["top", "bottom"],
      default: "top"
    }
  });
  const affixEmits = {
    scroll: ({ scrollTop, fixed }) => typeof scrollTop === "number" && typeof fixed === "boolean",
    change: (fixed) => typeof fixed === "boolean"
  };

  const __default__$p = {
    name: "ElAffix"
  };
  const _sfc_main$2b = /* @__PURE__ */ vue.defineComponent({
    ...__default__$p,
    props: affixProps,
    emits: affixEmits,
    setup(__props, { expose, emit }) {
      const props = __props;
      const COMPONENT_NAME = "ElAffix";
      const ns = useNamespace("affix");
      const target = vue.shallowRef();
      const root = vue.shallowRef();
      const scrollContainer = vue.shallowRef();
      const { height: windowHeight } = useWindowSize();
      const {
        height: rootHeight,
        width: rootWidth,
        top: rootTop,
        bottom: rootBottom,
        update: updateRoot
      } = useElementBounding(root);
      const targetRect = useElementBounding(target);
      const fixed = vue.ref(false);
      const scrollTop = vue.ref(0);
      const transform = vue.ref(0);
      const rootStyle = vue.computed(() => {
        return {
          height: fixed.value ? `${rootHeight.value}px` : "",
          width: fixed.value ? `${rootWidth.value}px` : ""
        };
      });
      const affixStyle = vue.computed(() => {
        if (!fixed.value)
          return {};
        const offset = props.offset ? `${props.offset}px` : 0;
        return {
          height: `${rootHeight.value}px`,
          width: `${rootWidth.value}px`,
          top: props.position === "top" ? offset : "",
          bottom: props.position === "bottom" ? offset : "",
          transform: transform.value ? `translateY(${transform.value}px)` : "",
          zIndex: props.zIndex
        };
      });
      const update = () => {
        if (!scrollContainer.value)
          return;
        scrollTop.value = scrollContainer.value instanceof Window ? document.documentElement.scrollTop : scrollContainer.value.scrollTop || 0;
        if (props.position === "top") {
          if (props.target) {
            const difference = targetRect.bottom.value - props.offset - rootHeight.value;
            fixed.value = props.offset > rootTop.value && targetRect.bottom.value > 0;
            transform.value = difference < 0 ? difference : 0;
          } else {
            fixed.value = props.offset > rootTop.value;
          }
        } else if (props.target) {
          const difference = windowHeight.value - targetRect.top.value - props.offset - rootHeight.value;
          fixed.value = windowHeight.value - props.offset < rootBottom.value && windowHeight.value > targetRect.top.value;
          transform.value = difference < 0 ? -difference : 0;
        } else {
          fixed.value = windowHeight.value - props.offset < rootBottom.value;
        }
      };
      const handleScroll = () => {
        emit("scroll", {
          scrollTop: scrollTop.value,
          fixed: fixed.value
        });
      };
      vue.watch(fixed, (val) => emit("change", val));
      vue.onMounted(() => {
        var _a;
        if (props.target) {
          target.value = (_a = document.querySelector(props.target)) != null ? _a : void 0;
          if (!target.value)
            throwError(COMPONENT_NAME, `Target is not existed: ${props.target}`);
        } else {
          target.value = document.documentElement;
        }
        scrollContainer.value = getScrollContainer(root.value, true);
        updateRoot();
      });
      useEventListener(scrollContainer, "scroll", handleScroll);
      vue.watchEffect(update);
      expose({
        update
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          ref_key: "root",
          ref: root,
          class: vue.normalizeClass(vue.unref(ns).b()),
          style: vue.normalizeStyle(vue.unref(rootStyle))
        }, [
          vue.createElementVNode("div", {
            class: vue.normalizeClass({ [vue.unref(ns).m("fixed")]: fixed.value }),
            style: vue.normalizeStyle(vue.unref(affixStyle))
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 6)
        ], 6);
      };
    }
  });
  var Affix = _sfc_main$2b;

  const ElAffix = withInstall(Affix);

  const iconProps = buildProps({
    size: {
      type: definePropType([Number, String])
    },
    color: {
      type: String
    }
  });

  const __default__$o = {
    name: "ElIcon",
    inheritAttrs: false
  };
  const _sfc_main$2a = /* @__PURE__ */ vue.defineComponent({
    ...__default__$o,
    props: iconProps,
    setup(__props) {
      const props = __props;
      const ns = useNamespace("icon");
      const style = vue.computed(() => {
        if (!props.size && !props.color)
          return {};
        return {
          fontSize: isUndefined(props.size) ? void 0 : addUnit(props.size),
          "--color": props.color
        };
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("i", vue.mergeProps({
          class: vue.unref(ns).b(),
          style: vue.unref(style)
        }, _ctx.$attrs), [
          vue.renderSlot(_ctx.$slots, "default")
        ], 16);
      };
    }
  });
  var Icon = _sfc_main$2a;

  const ElIcon = withInstall(Icon);

  const alertEffects = ["light", "dark"];
  const alertProps = buildProps({
    title: {
      type: String,
      default: ""
    },
    description: {
      type: String,
      default: ""
    },
    type: {
      type: String,
      values: keysOf(TypeComponentsMap),
      default: "info"
    },
    closable: {
      type: Boolean,
      default: true
    },
    closeText: {
      type: String,
      default: ""
    },
    showIcon: Boolean,
    center: Boolean,
    effect: {
      type: String,
      values: alertEffects,
      default: "light"
    }
  });
  const alertEmits = {
    close: (evt) => evt instanceof MouseEvent
  };

  const __default__$n = {
    name: "ElAlert"
  };
  const _sfc_main$29 = /* @__PURE__ */ vue.defineComponent({
    ...__default__$n,
    props: alertProps,
    emits: alertEmits,
    setup(__props, { emit }) {
      const props = __props;
      const { Close } = TypeComponents;
      const slots = vue.useSlots();
      const ns = useNamespace("alert");
      const visible = vue.ref(true);
      const iconComponent = vue.computed(() => TypeComponentsMap[props.type] || TypeComponentsMap["info"]);
      const isBigIcon = vue.computed(() => props.description || { [ns.is("big")]: slots.default });
      const isBoldTitle = vue.computed(() => props.description || { [ns.is("bold")]: slots.default });
      const close = (evt) => {
        visible.value = false;
        emit("close", evt);
      };
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createBlock(vue.Transition, {
          name: vue.unref(ns).b("fade")
        }, {
          default: vue.withCtx(() => [
            vue.withDirectives(vue.createElementVNode("div", {
              class: vue.normalizeClass([vue.unref(ns).b(), vue.unref(ns).m(_ctx.type), vue.unref(ns).is("center", _ctx.center), vue.unref(ns).is(_ctx.effect)]),
              role: "alert"
            }, [
              _ctx.showIcon && vue.unref(iconComponent) ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), {
                key: 0,
                class: vue.normalizeClass([vue.unref(ns).e("icon"), vue.unref(isBigIcon)])
              }, {
                default: vue.withCtx(() => [
                  (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(vue.unref(iconComponent))))
                ]),
                _: 1
              }, 8, ["class"])) : vue.createCommentVNode("v-if", true),
              vue.createElementVNode("div", {
                class: vue.normalizeClass(vue.unref(ns).e("content"))
              }, [
                _ctx.title || _ctx.$slots.title ? (vue.openBlock(), vue.createElementBlock("span", {
                  key: 0,
                  class: vue.normalizeClass([vue.unref(ns).e("title"), vue.unref(isBoldTitle)])
                }, [
                  vue.renderSlot(_ctx.$slots, "title", {}, () => [
                    vue.createTextVNode(vue.toDisplayString(_ctx.title), 1)
                  ])
                ], 2)) : vue.createCommentVNode("v-if", true),
                _ctx.$slots.default || _ctx.description ? (vue.openBlock(), vue.createElementBlock("p", {
                  key: 1,
                  class: vue.normalizeClass(vue.unref(ns).e("description"))
                }, [
                  vue.renderSlot(_ctx.$slots, "default", {}, () => [
                    vue.createTextVNode(vue.toDisplayString(_ctx.description), 1)
                  ])
                ], 2)) : vue.createCommentVNode("v-if", true),
                _ctx.closable ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 2 }, [
                  _ctx.closeText ? (vue.openBlock(), vue.createElementBlock("div", {
                    key: 0,
                    class: vue.normalizeClass([vue.unref(ns).e("close-btn"), vue.unref(ns).is("customed")]),
                    onClick: close
                  }, vue.toDisplayString(_ctx.closeText), 3)) : (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), {
                    key: 1,
                    class: vue.normalizeClass(vue.unref(ns).e("close-btn")),
                    onClick: close
                  }, {
                    default: vue.withCtx(() => [
                      vue.createVNode(vue.unref(Close))
                    ]),
                    _: 1
                  }, 8, ["class"]))
                ], 2112)) : vue.createCommentVNode("v-if", true)
              ], 2)
            ], 2), [
              [vue.vShow, visible.value]
            ])
          ]),
          _: 3
        }, 8, ["name"]);
      };
    }
  });
  var Alert = _sfc_main$29;

  const ElAlert = withInstall(Alert);

  let hiddenTextarea = void 0;
  const HIDDEN_STYLE = `
  height:0 !important;
  visibility:hidden !important;
  overflow:hidden !important;
  position:absolute !important;
  z-index:-1000 !important;
  top:0 !important;
  right:0 !important;
`;
  const CONTEXT_STYLE = [
    "letter-spacing",
    "line-height",
    "padding-top",
    "padding-bottom",
    "font-family",
    "font-weight",
    "font-size",
    "text-rendering",
    "text-transform",
    "width",
    "text-indent",
    "padding-left",
    "padding-right",
    "border-width",
    "box-sizing"
  ];
  function calculateNodeStyling(targetElement) {
    const style = window.getComputedStyle(targetElement);
    const boxSizing = style.getPropertyValue("box-sizing");
    const paddingSize = Number.parseFloat(style.getPropertyValue("padding-bottom")) + Number.parseFloat(style.getPropertyValue("padding-top"));
    const borderSize = Number.parseFloat(style.getPropertyValue("border-bottom-width")) + Number.parseFloat(style.getPropertyValue("border-top-width"));
    const contextStyle = CONTEXT_STYLE.map((name) => `${name}:${style.getPropertyValue(name)}`).join(";");
    return { contextStyle, paddingSize, borderSize, boxSizing };
  }
  function calcTextareaHeight(targetElement, minRows = 1, maxRows) {
    var _a;
    if (!hiddenTextarea) {
      hiddenTextarea = document.createElement("textarea");
      document.body.appendChild(hiddenTextarea);
    }
    const { paddingSize, borderSize, boxSizing, contextStyle } = calculateNodeStyling(targetElement);
    hiddenTextarea.setAttribute("style", `${contextStyle};${HIDDEN_STYLE}`);
    hiddenTextarea.value = targetElement.value || targetElement.placeholder || "";
    let height = hiddenTextarea.scrollHeight;
    const result = {};
    if (boxSizing === "border-box") {
      height = height + borderSize;
    } else if (boxSizing === "content-box") {
      height = height - paddingSize;
    }
    hiddenTextarea.value = "";
    const singleRowHeight = hiddenTextarea.scrollHeight - paddingSize;
    if (isNumber(minRows)) {
      let minHeight = singleRowHeight * minRows;
      if (boxSizing === "border-box") {
        minHeight = minHeight + paddingSize + borderSize;
      }
      height = Math.max(minHeight, height);
      result.minHeight = `${minHeight}px`;
    }
    if (isNumber(maxRows)) {
      let maxHeight = singleRowHeight * maxRows;
      if (boxSizing === "border-box") {
        maxHeight = maxHeight + paddingSize + borderSize;
      }
      height = Math.min(maxHeight, height);
    }
    result.height = `${height}px`;
    (_a = hiddenTextarea.parentNode) == null ? void 0 : _a.removeChild(hiddenTextarea);
    hiddenTextarea = void 0;
    return result;
  }

  const inputProps = buildProps({
    size: useSizeProp,
    disabled: Boolean,
    modelValue: {
      type: definePropType(void 0),
      default: ""
    },
    type: {
      type: String,
      default: "text"
    },
    resize: {
      type: String,
      values: ["none", "both", "horizontal", "vertical"]
    },
    autosize: {
      type: definePropType([Boolean, Object]),
      default: false
    },
    autocomplete: {
      type: String,
      default: "off"
    },
    placeholder: {
      type: String
    },
    form: {
      type: String,
      default: ""
    },
    readonly: {
      type: Boolean,
      default: false
    },
    clearable: {
      type: Boolean,
      default: false
    },
    showPassword: {
      type: Boolean,
      default: false
    },
    showWordLimit: {
      type: Boolean,
      default: false
    },
    suffixIcon: {
      type: iconPropType,
      default: ""
    },
    prefixIcon: {
      type: iconPropType,
      default: ""
    },
    label: {
      type: String
    },
    tabindex: {
      type: [Number, String]
    },
    validateEvent: {
      type: Boolean,
      default: true
    },
    inputStyle: {
      type: definePropType([Object, Array, String]),
      default: () => mutable({})
    }
  });
  const inputEmits = {
    [UPDATE_MODEL_EVENT]: (value) => isString(value),
    input: (value) => isString(value),
    change: (value) => isString(value),
    focus: (evt) => evt instanceof FocusEvent,
    blur: (evt) => evt instanceof FocusEvent,
    clear: () => true,
    mouseleave: (evt) => evt instanceof MouseEvent,
    mouseenter: (evt) => evt instanceof MouseEvent,
    keydown: (evt) => evt instanceof KeyboardEvent,
    compositionstart: (evt) => evt instanceof CompositionEvent,
    compositionupdate: (evt) => evt instanceof CompositionEvent,
    compositionend: (evt) => evt instanceof CompositionEvent
  };

  var _export_sfc = (sfc, props) => {
    const target = sfc.__vccOpts || sfc;
    for (const [key, val] of props) {
      target[key] = val;
    }
    return target;
  };

  const PENDANT_MAP = {
    suffix: "append",
    prefix: "prepend"
  };
  const _sfc_main$28 = vue.defineComponent({
    name: "ElInput",
    components: { ElIcon, CircleClose: circleClose, IconView: view },
    inheritAttrs: false,
    props: inputProps,
    emits: inputEmits,
    setup(props, { slots, emit, attrs: rawAttrs }) {
      const instance = vue.getCurrentInstance();
      const attrs = useAttrs();
      const { form, formItem } = useFormItem();
      const inputSize = useSize();
      const inputDisabled = useDisabled$1();
      const nsInput = useNamespace("input");
      const nsTextarea = useNamespace("textarea");
      const input = vue.ref();
      const textarea = vue.ref();
      const focused = vue.ref(false);
      const hovering = vue.ref(false);
      const isComposing = vue.ref(false);
      const passwordVisible = vue.ref(false);
      const _textareaCalcStyle = vue.shallowRef(props.inputStyle);
      const inputOrTextarea = vue.computed(() => input.value || textarea.value);
      const needStatusIcon = vue.computed(() => {
        var _a;
        return (_a = form == null ? void 0 : form.statusIcon) != null ? _a : false;
      });
      const validateState = vue.computed(() => (formItem == null ? void 0 : formItem.validateState) || "");
      const validateIcon = vue.computed(() => ValidateComponentsMap[validateState.value]);
      const containerStyle = vue.computed(() => [
        rawAttrs.style,
        props.inputStyle
      ]);
      const computedTextareaStyle = vue.computed(() => [
        props.inputStyle,
        _textareaCalcStyle.value,
        { resize: props.resize }
      ]);
      const nativeInputValue = vue.computed(() => props.modelValue === null || props.modelValue === void 0 ? "" : String(props.modelValue));
      const showClear = vue.computed(() => props.clearable && !inputDisabled.value && !props.readonly && !!nativeInputValue.value && (focused.value || hovering.value));
      const showPwdVisible = vue.computed(() => props.showPassword && !inputDisabled.value && !props.readonly && (!!nativeInputValue.value || focused.value));
      const isWordLimitVisible = vue.computed(() => props.showWordLimit && !!attrs.value.maxlength && (props.type === "text" || props.type === "textarea") && !inputDisabled.value && !props.readonly && !props.showPassword);
      const textLength = vue.computed(() => Array.from(nativeInputValue.value).length);
      const inputExceed = vue.computed(() => !!isWordLimitVisible.value && textLength.value > Number(attrs.value.maxlength));
      const resizeTextarea = () => {
        const { type, autosize } = props;
        if (!isClient || type !== "textarea")
          return;
        if (autosize) {
          const minRows = isObject$1(autosize) ? autosize.minRows : void 0;
          const maxRows = isObject$1(autosize) ? autosize.maxRows : void 0;
          _textareaCalcStyle.value = {
            ...calcTextareaHeight(textarea.value, minRows, maxRows)
          };
        } else {
          _textareaCalcStyle.value = {
            minHeight: calcTextareaHeight(textarea.value).minHeight
          };
        }
      };
      const setNativeInputValue = () => {
        const input2 = inputOrTextarea.value;
        if (!input2 || input2.value === nativeInputValue.value)
          return;
        input2.value = nativeInputValue.value;
      };
      const calcIconOffset = (place) => {
        const { el } = instance.vnode;
        if (!el)
          return;
        const elList = Array.from(el.querySelectorAll(`.${nsInput.e(place)}`));
        const target = elList.find((item) => item.parentNode === el);
        if (!target)
          return;
        const pendant = PENDANT_MAP[place];
        if (slots[pendant]) {
          target.style.transform = `translateX(${place === "suffix" ? "-" : ""}${el.querySelector(`.${nsInput.be("group", pendant)}`).offsetWidth}px)`;
        } else {
          target.removeAttribute("style");
        }
      };
      const updateIconOffset = () => {
        calcIconOffset("prefix");
        calcIconOffset("suffix");
      };
      const handleInput = (event) => {
        const { value } = event.target;
        if (isComposing.value)
          return;
        if (value === nativeInputValue.value)
          return;
        emit(UPDATE_MODEL_EVENT, value);
        emit("input", value);
        vue.nextTick(setNativeInputValue);
      };
      const handleChange = (event) => {
        emit("change", event.target.value);
      };
      const focus = () => {
        vue.nextTick(() => {
          var _a;
          (_a = inputOrTextarea.value) == null ? void 0 : _a.focus();
        });
      };
      const blur = () => {
        var _a;
        (_a = inputOrTextarea.value) == null ? void 0 : _a.blur();
      };
      const handleFocus = (event) => {
        focused.value = true;
        emit("focus", event);
      };
      const handleBlur = (event) => {
        var _a;
        focused.value = false;
        emit("blur", event);
        if (props.validateEvent) {
          (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "blur").catch((err) => debugWarn());
        }
      };
      const select = () => {
        var _a;
        (_a = inputOrTextarea.value) == null ? void 0 : _a.select();
      };
      const handleCompositionStart = (event) => {
        emit("compositionstart", event);
        isComposing.value = true;
      };
      const handleCompositionUpdate = (event) => {
        var _a;
        emit("compositionupdate", event);
        const text = (_a = event.target) == null ? void 0 : _a.value;
        const lastCharacter = text[text.length - 1] || "";
        isComposing.value = !isKorean(lastCharacter);
      };
      const handleCompositionEnd = (event) => {
        emit("compositionend", event);
        if (isComposing.value) {
          isComposing.value = false;
          handleInput(event);
        }
      };
      const clear = () => {
        emit(UPDATE_MODEL_EVENT, "");
        emit("change", "");
        emit("clear");
        emit("input", "");
      };
      const handlePasswordVisible = () => {
        passwordVisible.value = !passwordVisible.value;
        focus();
      };
      const suffixVisible = vue.computed(() => !!slots.suffix || !!props.suffixIcon || showClear.value || props.showPassword || isWordLimitVisible.value || !!validateState.value && needStatusIcon.value);
      vue.watch(() => props.modelValue, () => {
        var _a;
        vue.nextTick(resizeTextarea);
        if (props.validateEvent) {
          (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "change").catch((err) => debugWarn());
        }
      });
      vue.watch(nativeInputValue, () => setNativeInputValue());
      vue.watch(() => props.type, () => {
        vue.nextTick(() => {
          setNativeInputValue();
          resizeTextarea();
          updateIconOffset();
        });
      });
      vue.onMounted(() => {
        setNativeInputValue();
        updateIconOffset();
        vue.nextTick(resizeTextarea);
      });
      vue.onUpdated(() => {
        vue.nextTick(updateIconOffset);
      });
      const onMouseLeave = (evt) => {
        hovering.value = false;
        emit("mouseleave", evt);
      };
      const onMouseEnter = (evt) => {
        hovering.value = true;
        emit("mouseenter", evt);
      };
      const handleKeydown = (evt) => {
        emit("keydown", evt);
      };
      return {
        input,
        textarea,
        attrs,
        inputSize,
        validateState,
        validateIcon,
        containerStyle,
        computedTextareaStyle,
        inputDisabled,
        showClear,
        showPwdVisible,
        isWordLimitVisible,
        textLength,
        hovering,
        inputExceed,
        passwordVisible,
        inputOrTextarea,
        suffixVisible,
        needStatusIcon,
        resizeTextarea,
        handleInput,
        handleChange,
        handleFocus,
        handleBlur,
        handleCompositionStart,
        handleCompositionUpdate,
        handleCompositionEnd,
        handlePasswordVisible,
        clear,
        select,
        focus,
        blur,
        onMouseLeave,
        onMouseEnter,
        handleKeydown,
        nsInput,
        nsTextarea
      };
    }
  });
  const _hoisted_1$10 = ["type", "disabled", "readonly", "autocomplete", "tabindex", "aria-label", "placeholder"];
  const _hoisted_2$I = ["tabindex", "disabled", "readonly", "autocomplete", "aria-label", "placeholder"];
  function _sfc_render$1J(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_circle_close = vue.resolveComponent("circle-close");
    const _component_icon_view = vue.resolveComponent("icon-view");
    return vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([
        _ctx.type === "textarea" ? _ctx.nsTextarea.b() : _ctx.nsInput.b(),
        _ctx.nsInput.m(_ctx.inputSize),
        _ctx.nsInput.is("disabled", _ctx.inputDisabled),
        _ctx.nsInput.is("exceed", _ctx.inputExceed),
        {
          [_ctx.nsInput.b("group")]: _ctx.$slots.prepend || _ctx.$slots.append,
          [_ctx.nsInput.bm("group", "append")]: _ctx.$slots.append,
          [_ctx.nsInput.bm("group", "prepend")]: _ctx.$slots.prepend,
          [_ctx.nsInput.m("prefix")]: _ctx.$slots.prefix || _ctx.prefixIcon,
          [_ctx.nsInput.m("suffix")]: _ctx.$slots.suffix || _ctx.suffixIcon || _ctx.clearable || _ctx.showPassword,
          [_ctx.nsInput.m("suffix--password-clear")]: _ctx.showClear && _ctx.showPwdVisible
        },
        _ctx.$attrs.class
      ]),
      style: vue.normalizeStyle(_ctx.containerStyle),
      onMouseenter: _cache[17] || (_cache[17] = (...args) => _ctx.onMouseEnter && _ctx.onMouseEnter(...args)),
      onMouseleave: _cache[18] || (_cache[18] = (...args) => _ctx.onMouseLeave && _ctx.onMouseLeave(...args))
    }, [
      vue.createCommentVNode(" input "),
      _ctx.type !== "textarea" ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
        vue.createCommentVNode(" prepend slot "),
        _ctx.$slots.prepend ? (vue.openBlock(), vue.createElementBlock("div", {
          key: 0,
          class: vue.normalizeClass(_ctx.nsInput.be("group", "prepend"))
        }, [
          vue.renderSlot(_ctx.$slots, "prepend")
        ], 2)) : vue.createCommentVNode("v-if", true),
        vue.createElementVNode("input", vue.mergeProps({
          ref: "input",
          class: _ctx.nsInput.e("inner")
        }, _ctx.attrs, {
          type: _ctx.showPassword ? _ctx.passwordVisible ? "text" : "password" : _ctx.type,
          disabled: _ctx.inputDisabled,
          readonly: _ctx.readonly,
          autocomplete: _ctx.autocomplete,
          tabindex: _ctx.tabindex,
          "aria-label": _ctx.label,
          placeholder: _ctx.placeholder,
          style: _ctx.inputStyle,
          onCompositionstart: _cache[0] || (_cache[0] = (...args) => _ctx.handleCompositionStart && _ctx.handleCompositionStart(...args)),
          onCompositionupdate: _cache[1] || (_cache[1] = (...args) => _ctx.handleCompositionUpdate && _ctx.handleCompositionUpdate(...args)),
          onCompositionend: _cache[2] || (_cache[2] = (...args) => _ctx.handleCompositionEnd && _ctx.handleCompositionEnd(...args)),
          onInput: _cache[3] || (_cache[3] = (...args) => _ctx.handleInput && _ctx.handleInput(...args)),
          onFocus: _cache[4] || (_cache[4] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
          onBlur: _cache[5] || (_cache[5] = (...args) => _ctx.handleBlur && _ctx.handleBlur(...args)),
          onChange: _cache[6] || (_cache[6] = (...args) => _ctx.handleChange && _ctx.handleChange(...args)),
          onKeydown: _cache[7] || (_cache[7] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args))
        }), null, 16, _hoisted_1$10),
        vue.createCommentVNode(" prefix slot "),
        _ctx.$slots.prefix || _ctx.prefixIcon ? (vue.openBlock(), vue.createElementBlock("span", {
          key: 1,
          class: vue.normalizeClass(_ctx.nsInput.e("prefix"))
        }, [
          vue.createElementVNode("span", {
            class: vue.normalizeClass(_ctx.nsInput.e("prefix-inner"))
          }, [
            vue.renderSlot(_ctx.$slots, "prefix"),
            _ctx.prefixIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: 0,
              class: vue.normalizeClass(_ctx.nsInput.e("icon"))
            }, {
              default: vue.withCtx(() => [
                (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.prefixIcon)))
              ]),
              _: 1
            }, 8, ["class"])) : vue.createCommentVNode("v-if", true)
          ], 2)
        ], 2)) : vue.createCommentVNode("v-if", true),
        vue.createCommentVNode(" suffix slot "),
        _ctx.suffixVisible ? (vue.openBlock(), vue.createElementBlock("span", {
          key: 2,
          class: vue.normalizeClass(_ctx.nsInput.e("suffix"))
        }, [
          vue.createElementVNode("span", {
            class: vue.normalizeClass(_ctx.nsInput.e("suffix-inner"))
          }, [
            !_ctx.showClear || !_ctx.showPwdVisible || !_ctx.isWordLimitVisible ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
              vue.renderSlot(_ctx.$slots, "suffix"),
              _ctx.suffixIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
                key: 0,
                class: vue.normalizeClass(_ctx.nsInput.e("icon"))
              }, {
                default: vue.withCtx(() => [
                  (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.suffixIcon)))
                ]),
                _: 1
              }, 8, ["class"])) : vue.createCommentVNode("v-if", true)
            ], 64)) : vue.createCommentVNode("v-if", true),
            _ctx.showClear ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: 1,
              class: vue.normalizeClass([_ctx.nsInput.e("icon"), _ctx.nsInput.e("clear")]),
              onMousedown: _cache[8] || (_cache[8] = vue.withModifiers(() => {
              }, ["prevent"])),
              onClick: _ctx.clear
            }, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_circle_close)
              ]),
              _: 1
            }, 8, ["class", "onClick"])) : vue.createCommentVNode("v-if", true),
            _ctx.showPwdVisible ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: 2,
              class: vue.normalizeClass([_ctx.nsInput.e("icon"), _ctx.nsInput.e("clear")]),
              onClick: _ctx.handlePasswordVisible
            }, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_icon_view)
              ]),
              _: 1
            }, 8, ["class", "onClick"])) : vue.createCommentVNode("v-if", true),
            _ctx.isWordLimitVisible ? (vue.openBlock(), vue.createElementBlock("span", {
              key: 3,
              class: vue.normalizeClass(_ctx.nsInput.e("count"))
            }, [
              vue.createElementVNode("span", {
                class: vue.normalizeClass(_ctx.nsInput.e("count-inner"))
              }, vue.toDisplayString(_ctx.textLength) + " / " + vue.toDisplayString(_ctx.attrs.maxlength), 3)
            ], 2)) : vue.createCommentVNode("v-if", true)
          ], 2),
          _ctx.validateState && _ctx.validateIcon && _ctx.needStatusIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
            key: 0,
            class: vue.normalizeClass([_ctx.nsInput.e("icon"), _ctx.nsInput.e("validateIcon")])
          }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.validateIcon)))
            ]),
            _: 1
          }, 8, ["class"])) : vue.createCommentVNode("v-if", true)
        ], 2)) : vue.createCommentVNode("v-if", true),
        vue.createCommentVNode(" append slot "),
        _ctx.$slots.append ? (vue.openBlock(), vue.createElementBlock("div", {
          key: 3,
          class: vue.normalizeClass(_ctx.nsInput.be("group", "append"))
        }, [
          vue.renderSlot(_ctx.$slots, "append")
        ], 2)) : vue.createCommentVNode("v-if", true)
      ], 64)) : (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 1 }, [
        vue.createCommentVNode(" textarea "),
        vue.createElementVNode("textarea", vue.mergeProps({
          ref: "textarea",
          class: _ctx.nsTextarea.e("inner")
        }, _ctx.attrs, {
          tabindex: _ctx.tabindex,
          disabled: _ctx.inputDisabled,
          readonly: _ctx.readonly,
          autocomplete: _ctx.autocomplete,
          style: _ctx.computedTextareaStyle,
          "aria-label": _ctx.label,
          placeholder: _ctx.placeholder,
          onCompositionstart: _cache[9] || (_cache[9] = (...args) => _ctx.handleCompositionStart && _ctx.handleCompositionStart(...args)),
          onCompositionupdate: _cache[10] || (_cache[10] = (...args) => _ctx.handleCompositionUpdate && _ctx.handleCompositionUpdate(...args)),
          onCompositionend: _cache[11] || (_cache[11] = (...args) => _ctx.handleCompositionEnd && _ctx.handleCompositionEnd(...args)),
          onInput: _cache[12] || (_cache[12] = (...args) => _ctx.handleInput && _ctx.handleInput(...args)),
          onFocus: _cache[13] || (_cache[13] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
          onBlur: _cache[14] || (_cache[14] = (...args) => _ctx.handleBlur && _ctx.handleBlur(...args)),
          onChange: _cache[15] || (_cache[15] = (...args) => _ctx.handleChange && _ctx.handleChange(...args)),
          onKeydown: _cache[16] || (_cache[16] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args))
        }), null, 16, _hoisted_2$I),
        _ctx.isWordLimitVisible ? (vue.openBlock(), vue.createElementBlock("span", {
          key: 0,
          class: vue.normalizeClass(_ctx.nsInput.e("count"))
        }, vue.toDisplayString(_ctx.textLength) + " / " + vue.toDisplayString(_ctx.attrs.maxlength), 3)) : vue.createCommentVNode("v-if", true)
      ], 64))
    ], 38)), [
      [vue.vShow, _ctx.type !== "hidden"]
    ]);
  }
  var Input = /* @__PURE__ */ _export_sfc(_sfc_main$28, [["render", _sfc_render$1J]]);

  const ElInput = withInstall(Input);

  const BAR_MAP = {
    vertical: {
      offset: "offsetHeight",
      scroll: "scrollTop",
      scrollSize: "scrollHeight",
      size: "height",
      key: "vertical",
      axis: "Y",
      client: "clientY",
      direction: "top"
    },
    horizontal: {
      offset: "offsetWidth",
      scroll: "scrollLeft",
      scrollSize: "scrollWidth",
      size: "width",
      key: "horizontal",
      axis: "X",
      client: "clientX",
      direction: "left"
    }
  };
  const renderThumbStyle$1 = ({ move, size, bar }) => ({
    [bar.size]: size,
    transform: `translate${bar.axis}(${move}%)`
  });

  const thumbProps = buildProps({
    vertical: Boolean,
    size: String,
    move: Number,
    ratio: {
      type: Number,
      required: true
    },
    always: Boolean
  });

  const COMPONENT_NAME$d = "Thumb";
  const _sfc_main$27 = vue.defineComponent({
    name: COMPONENT_NAME$d,
    props: thumbProps,
    setup(props) {
      const scrollbar = vue.inject(scrollbarContextKey);
      const ns = useNamespace("scrollbar");
      if (!scrollbar)
        throwError(COMPONENT_NAME$d, "can not inject scrollbar context");
      const instance = vue.ref();
      const thumb = vue.ref();
      const thumbState = vue.ref({});
      const visible = vue.ref(false);
      let cursorDown = false;
      let cursorLeave = false;
      let originalOnSelectStart = isClient ? document.onselectstart : null;
      const bar = vue.computed(() => BAR_MAP[props.vertical ? "vertical" : "horizontal"]);
      const thumbStyle = vue.computed(() => renderThumbStyle$1({
        size: props.size,
        move: props.move,
        bar: bar.value
      }));
      const offsetRatio = vue.computed(() => instance.value[bar.value.offset] ** 2 / scrollbar.wrapElement[bar.value.scrollSize] / props.ratio / thumb.value[bar.value.offset]);
      const clickThumbHandler = (e) => {
        var _a;
        e.stopPropagation();
        if (e.ctrlKey || [1, 2].includes(e.button))
          return;
        (_a = window.getSelection()) == null ? void 0 : _a.removeAllRanges();
        startDrag(e);
        const el = e.currentTarget;
        if (!el)
          return;
        thumbState.value[bar.value.axis] = el[bar.value.offset] - (e[bar.value.client] - el.getBoundingClientRect()[bar.value.direction]);
      };
      const clickTrackHandler = (e) => {
        if (!thumb.value || !instance.value || !scrollbar.wrapElement)
          return;
        const offset = Math.abs(e.target.getBoundingClientRect()[bar.value.direction] - e[bar.value.client]);
        const thumbHalf = thumb.value[bar.value.offset] / 2;
        const thumbPositionPercentage = (offset - thumbHalf) * 100 * offsetRatio.value / instance.value[bar.value.offset];
        scrollbar.wrapElement[bar.value.scroll] = thumbPositionPercentage * scrollbar.wrapElement[bar.value.scrollSize] / 100;
      };
      const startDrag = (e) => {
        e.stopImmediatePropagation();
        cursorDown = true;
        document.addEventListener("mousemove", mouseMoveDocumentHandler);
        document.addEventListener("mouseup", mouseUpDocumentHandler);
        originalOnSelectStart = document.onselectstart;
        document.onselectstart = () => false;
      };
      const mouseMoveDocumentHandler = (e) => {
        if (!instance.value || !thumb.value)
          return;
        if (cursorDown === false)
          return;
        const prevPage = thumbState.value[bar.value.axis];
        if (!prevPage)
          return;
        const offset = (instance.value.getBoundingClientRect()[bar.value.direction] - e[bar.value.client]) * -1;
        const thumbClickPosition = thumb.value[bar.value.offset] - prevPage;
        const thumbPositionPercentage = (offset - thumbClickPosition) * 100 * offsetRatio.value / instance.value[bar.value.offset];
        scrollbar.wrapElement[bar.value.scroll] = thumbPositionPercentage * scrollbar.wrapElement[bar.value.scrollSize] / 100;
      };
      const mouseUpDocumentHandler = () => {
        cursorDown = false;
        thumbState.value[bar.value.axis] = 0;
        document.removeEventListener("mousemove", mouseMoveDocumentHandler);
        document.removeEventListener("mouseup", mouseUpDocumentHandler);
        restoreOnselectstart();
        if (cursorLeave)
          visible.value = false;
      };
      const mouseMoveScrollbarHandler = () => {
        cursorLeave = false;
        visible.value = !!props.size;
      };
      const mouseLeaveScrollbarHandler = () => {
        cursorLeave = true;
        visible.value = cursorDown;
      };
      vue.onBeforeUnmount(() => {
        restoreOnselectstart();
        document.removeEventListener("mouseup", mouseUpDocumentHandler);
      });
      const restoreOnselectstart = () => {
        if (document.onselectstart !== originalOnSelectStart)
          document.onselectstart = originalOnSelectStart;
      };
      useEventListener(vue.toRef(scrollbar, "scrollbarElement"), "mousemove", mouseMoveScrollbarHandler);
      useEventListener(vue.toRef(scrollbar, "scrollbarElement"), "mouseleave", mouseLeaveScrollbarHandler);
      return {
        ns,
        instance,
        thumb,
        bar,
        thumbStyle,
        visible,
        clickTrackHandler,
        clickThumbHandler
      };
    }
  });
  function _sfc_render$1I(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createBlock(vue.Transition, {
      name: _ctx.ns.b("fade")
    }, {
      default: vue.withCtx(() => [
        vue.withDirectives(vue.createElementVNode("div", {
          ref: "instance",
          class: vue.normalizeClass([_ctx.ns.e("bar"), _ctx.ns.is(_ctx.bar.key)]),
          onMousedown: _cache[1] || (_cache[1] = (...args) => _ctx.clickTrackHandler && _ctx.clickTrackHandler(...args))
        }, [
          vue.createElementVNode("div", {
            ref: "thumb",
            class: vue.normalizeClass(_ctx.ns.e("thumb")),
            style: vue.normalizeStyle(_ctx.thumbStyle),
            onMousedown: _cache[0] || (_cache[0] = (...args) => _ctx.clickThumbHandler && _ctx.clickThumbHandler(...args))
          }, null, 38)
        ], 34), [
          [vue.vShow, _ctx.always || _ctx.visible]
        ])
      ]),
      _: 1
    }, 8, ["name"]);
  }
  var Thumb = /* @__PURE__ */ _export_sfc(_sfc_main$27, [["render", _sfc_render$1I]]);

  const barProps = buildProps({
    always: {
      type: Boolean,
      default: true
    },
    width: {
      type: String,
      default: ""
    },
    height: {
      type: String,
      default: ""
    },
    ratioX: {
      type: Number,
      default: 1
    },
    ratioY: {
      type: Number,
      default: 1
    }
  });

  const _sfc_main$26 = vue.defineComponent({
    components: {
      Thumb
    },
    props: barProps,
    setup(props) {
      const moveX = vue.ref(0);
      const moveY = vue.ref(0);
      const GAP = 4;
      const handleScroll = (wrap) => {
        if (wrap) {
          const offsetHeight = wrap.offsetHeight - GAP;
          const offsetWidth = wrap.offsetWidth - GAP;
          moveY.value = wrap.scrollTop * 100 / offsetHeight * props.ratioY;
          moveX.value = wrap.scrollLeft * 100 / offsetWidth * props.ratioX;
        }
      };
      return {
        handleScroll,
        moveX,
        moveY
      };
    }
  });
  function _sfc_render$1H(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_thumb = vue.resolveComponent("thumb");
    return vue.openBlock(), vue.createElementBlock(vue.Fragment, null, [
      vue.createVNode(_component_thumb, {
        move: _ctx.moveX,
        ratio: _ctx.ratioX,
        size: _ctx.width,
        always: _ctx.always
      }, null, 8, ["move", "ratio", "size", "always"]),
      vue.createVNode(_component_thumb, {
        move: _ctx.moveY,
        ratio: _ctx.ratioY,
        size: _ctx.height,
        vertical: "",
        always: _ctx.always
      }, null, 8, ["move", "ratio", "size", "always"])
    ], 64);
  }
  var Bar = /* @__PURE__ */ _export_sfc(_sfc_main$26, [["render", _sfc_render$1H]]);

  const scrollbarProps = buildProps({
    height: {
      type: [String, Number],
      default: ""
    },
    maxHeight: {
      type: [String, Number],
      default: ""
    },
    native: {
      type: Boolean,
      default: false
    },
    wrapStyle: {
      type: definePropType([String, Object, Array]),
      default: ""
    },
    wrapClass: {
      type: [String, Array],
      default: ""
    },
    viewClass: {
      type: [String, Array],
      default: ""
    },
    viewStyle: {
      type: [String, Array, Object],
      default: ""
    },
    noresize: Boolean,
    tag: {
      type: String,
      default: "div"
    },
    always: {
      type: Boolean,
      default: false
    },
    minSize: {
      type: Number,
      default: 20
    }
  });
  const scrollbarEmits = {
    scroll: ({
      scrollTop,
      scrollLeft
    }) => isNumber(scrollTop) && isNumber(scrollLeft)
  };

  const _sfc_main$25 = vue.defineComponent({
    name: "ElScrollbar",
    components: {
      Bar
    },
    props: scrollbarProps,
    emits: scrollbarEmits,
    setup(props, { emit }) {
      const ns = useNamespace("scrollbar");
      let stopResizeObserver = void 0;
      let stopResizeListener = void 0;
      const scrollbar$ = vue.ref();
      const wrap$ = vue.ref();
      const resize$ = vue.ref();
      const sizeWidth = vue.ref("0");
      const sizeHeight = vue.ref("0");
      const barRef = vue.ref();
      const moveX = vue.ref(0);
      const moveY = vue.ref(0);
      const ratioY = vue.ref(1);
      const ratioX = vue.ref(1);
      const GAP = 4;
      const style = vue.computed(() => {
        const style2 = {};
        if (props.height)
          style2.height = addUnit(props.height);
        if (props.maxHeight)
          style2.maxHeight = addUnit(props.maxHeight);
        return [props.wrapStyle, style2];
      });
      const handleScroll = () => {
        var _a;
        if (wrap$.value) {
          (_a = barRef.value) == null ? void 0 : _a.handleScroll(wrap$.value);
          emit("scroll", {
            scrollTop: wrap$.value.scrollTop,
            scrollLeft: wrap$.value.scrollLeft
          });
        }
      };
      const setScrollTop = (value) => {
        if (!isNumber(value)) {
          return;
        }
        wrap$.value.scrollTop = value;
      };
      const setScrollLeft = (value) => {
        if (!isNumber(value)) {
          return;
        }
        wrap$.value.scrollLeft = value;
      };
      const update = () => {
        if (!wrap$.value)
          return;
        const offsetHeight = wrap$.value.offsetHeight - GAP;
        const offsetWidth = wrap$.value.offsetWidth - GAP;
        const originalHeight = offsetHeight ** 2 / wrap$.value.scrollHeight;
        const originalWidth = offsetWidth ** 2 / wrap$.value.scrollWidth;
        const height = Math.max(originalHeight, props.minSize);
        const width = Math.max(originalWidth, props.minSize);
        ratioY.value = originalHeight / (offsetHeight - originalHeight) / (height / (offsetHeight - height));
        ratioX.value = originalWidth / (offsetWidth - originalWidth) / (width / (offsetWidth - width));
        sizeHeight.value = height + GAP < offsetHeight ? `${height}px` : "";
        sizeWidth.value = width + GAP < offsetWidth ? `${width}px` : "";
      };
      vue.watch(() => props.noresize, (noresize) => {
        if (noresize) {
          stopResizeObserver == null ? void 0 : stopResizeObserver();
          stopResizeListener == null ? void 0 : stopResizeListener();
        } else {
          ({ stop: stopResizeObserver } = useResizeObserver(resize$, update));
          stopResizeListener = useEventListener("resize", update);
        }
      }, { immediate: true });
      vue.watch(() => [props.maxHeight, props.height], () => {
        if (!props.native)
          vue.nextTick(() => {
            var _a;
            update();
            if (wrap$.value) {
              (_a = barRef.value) == null ? void 0 : _a.handleScroll(wrap$.value);
            }
          });
      });
      vue.provide(scrollbarContextKey, vue.reactive({
        scrollbarElement: scrollbar$,
        wrapElement: wrap$
      }));
      vue.onMounted(() => {
        if (!props.native)
          vue.nextTick(() => update());
      });
      return {
        ns,
        scrollbar$,
        wrap$,
        resize$,
        barRef,
        moveX,
        moveY,
        ratioX,
        ratioY,
        sizeWidth,
        sizeHeight,
        style,
        update,
        handleScroll,
        setScrollTop,
        setScrollLeft
      };
    }
  });
  function _sfc_render$1G(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_bar = vue.resolveComponent("bar");
    return vue.openBlock(), vue.createElementBlock("div", {
      ref: "scrollbar$",
      class: vue.normalizeClass(_ctx.ns.b())
    }, [
      vue.createElementVNode("div", {
        ref: "wrap$",
        class: vue.normalizeClass([
          _ctx.wrapClass,
          _ctx.ns.e("wrap"),
          { [_ctx.ns.em("wrap", "hidden-default")]: !_ctx.native }
        ]),
        style: vue.normalizeStyle(_ctx.style),
        onScroll: _cache[0] || (_cache[0] = (...args) => _ctx.handleScroll && _ctx.handleScroll(...args))
      }, [
        (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.tag), {
          ref: "resize$",
          class: vue.normalizeClass([_ctx.ns.e("view"), _ctx.viewClass]),
          style: vue.normalizeStyle(_ctx.viewStyle)
        }, {
          default: vue.withCtx(() => [
            vue.renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 8, ["class", "style"]))
      ], 38),
      !_ctx.native ? (vue.openBlock(), vue.createBlock(_component_bar, {
        key: 0,
        ref: "barRef",
        height: _ctx.sizeHeight,
        width: _ctx.sizeWidth,
        always: _ctx.always,
        "ratio-x": _ctx.ratioX,
        "ratio-y": _ctx.ratioY
      }, null, 8, ["height", "width", "always", "ratio-x", "ratio-y"])) : vue.createCommentVNode("v-if", true)
    ], 2);
  }
  var Scrollbar$1 = /* @__PURE__ */ _export_sfc(_sfc_main$25, [["render", _sfc_render$1G]]);

  const ElScrollbar = withInstall(Scrollbar$1);

  const POPPER_INJECTION_KEY = Symbol("elPopper");
  const POPPER_CONTENT_INJECTION_KEY = Symbol("elPopperContent");

  const _sfc_main$24 = vue.defineComponent({
    name: "ElPopperProvider",
    inheritAttrs: false,
    setup() {
      const popperProvides = {
        triggerRef: vue.ref(null),
        popperInstanceRef: vue.ref(null),
        contentRef: vue.ref(null)
      };
      vue.provide(POPPER_INJECTION_KEY, popperProvides);
      return popperProvides;
    }
  });
  function _sfc_render$1F(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.renderSlot(_ctx.$slots, "default");
  }
  var Popper = /* @__PURE__ */ _export_sfc(_sfc_main$24, [["render", _sfc_render$1F]]);

  var top = "top";
  var bottom = "bottom";
  var right = "right";
  var left = "left";
  var auto = "auto";
  var basePlacements = [top, bottom, right, left];
  var start = "start";
  var end = "end";
  var clippingParents = "clippingParents";
  var viewport = "viewport";
  var popper = "popper";
  var reference = "reference";
  var variationPlacements = /* @__PURE__ */ basePlacements.reduce(function(acc, placement) {
    return acc.concat([placement + "-" + start, placement + "-" + end]);
  }, []);
  var placements = /* @__PURE__ */ [].concat(basePlacements, [auto]).reduce(function(acc, placement) {
    return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
  }, []);
  var beforeRead = "beforeRead";
  var read = "read";
  var afterRead = "afterRead";
  var beforeMain = "beforeMain";
  var main = "main";
  var afterMain = "afterMain";
  var beforeWrite = "beforeWrite";
  var write = "write";
  var afterWrite = "afterWrite";
  var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

  function getNodeName(element) {
    return element ? (element.nodeName || "").toLowerCase() : null;
  }

  function getWindow(node) {
    if (node == null) {
      return window;
    }
    if (node.toString() !== "[object Window]") {
      var ownerDocument = node.ownerDocument;
      return ownerDocument ? ownerDocument.defaultView || window : window;
    }
    return node;
  }

  function isElement(node) {
    var OwnElement = getWindow(node).Element;
    return node instanceof OwnElement || node instanceof Element;
  }
  function isHTMLElement(node) {
    var OwnElement = getWindow(node).HTMLElement;
    return node instanceof OwnElement || node instanceof HTMLElement;
  }
  function isShadowRoot(node) {
    if (typeof ShadowRoot === "undefined") {
      return false;
    }
    var OwnElement = getWindow(node).ShadowRoot;
    return node instanceof OwnElement || node instanceof ShadowRoot;
  }

  function applyStyles(_ref) {
    var state = _ref.state;
    Object.keys(state.elements).forEach(function(name) {
      var style = state.styles[name] || {};
      var attributes = state.attributes[name] || {};
      var element = state.elements[name];
      if (!isHTMLElement(element) || !getNodeName(element)) {
        return;
      }
      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function(name2) {
        var value = attributes[name2];
        if (value === false) {
          element.removeAttribute(name2);
        } else {
          element.setAttribute(name2, value === true ? "" : value);
        }
      });
    });
  }
  function effect$2(_ref2) {
    var state = _ref2.state;
    var initialStyles = {
      popper: {
        position: state.options.strategy,
        left: "0",
        top: "0",
        margin: "0"
      },
      arrow: {
        position: "absolute"
      },
      reference: {}
    };
    Object.assign(state.elements.popper.style, initialStyles.popper);
    state.styles = initialStyles;
    if (state.elements.arrow) {
      Object.assign(state.elements.arrow.style, initialStyles.arrow);
    }
    return function() {
      Object.keys(state.elements).forEach(function(name) {
        var element = state.elements[name];
        var attributes = state.attributes[name] || {};
        var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]);
        var style = styleProperties.reduce(function(style2, property) {
          style2[property] = "";
          return style2;
        }, {});
        if (!isHTMLElement(element) || !getNodeName(element)) {
          return;
        }
        Object.assign(element.style, style);
        Object.keys(attributes).forEach(function(attribute) {
          element.removeAttribute(attribute);
        });
      });
    };
  }
  var applyStyles$1 = {
    name: "applyStyles",
    enabled: true,
    phase: "write",
    fn: applyStyles,
    effect: effect$2,
    requires: ["computeStyles"]
  };

  function getBasePlacement(placement) {
    return placement.split("-")[0];
  }

  var max$1 = Math.max;
  var min$1 = Math.min;
  var round = Math.round;

  function getBoundingClientRect(element, includeScale) {
    if (includeScale === void 0) {
      includeScale = false;
    }
    var rect = element.getBoundingClientRect();
    var scaleX = 1;
    var scaleY = 1;
    if (isHTMLElement(element) && includeScale) {
      var offsetHeight = element.offsetHeight;
      var offsetWidth = element.offsetWidth;
      if (offsetWidth > 0) {
        scaleX = round(rect.width) / offsetWidth || 1;
      }
      if (offsetHeight > 0) {
        scaleY = round(rect.height) / offsetHeight || 1;
      }
    }
    return {
      width: rect.width / scaleX,
      height: rect.height / scaleY,
      top: rect.top / scaleY,
      right: rect.right / scaleX,
      bottom: rect.bottom / scaleY,
      left: rect.left / scaleX,
      x: rect.left / scaleX,
      y: rect.top / scaleY
    };
  }

  function getLayoutRect(element) {
    var clientRect = getBoundingClientRect(element);
    var width = element.offsetWidth;
    var height = element.offsetHeight;
    if (Math.abs(clientRect.width - width) <= 1) {
      width = clientRect.width;
    }
    if (Math.abs(clientRect.height - height) <= 1) {
      height = clientRect.height;
    }
    return {
      x: element.offsetLeft,
      y: element.offsetTop,
      width,
      height
    };
  }

  function contains(parent, child) {
    var rootNode = child.getRootNode && child.getRootNode();
    if (parent.contains(child)) {
      return true;
    } else if (rootNode && isShadowRoot(rootNode)) {
      var next = child;
      do {
        if (next && parent.isSameNode(next)) {
          return true;
        }
        next = next.parentNode || next.host;
      } while (next);
    }
    return false;
  }

  function getComputedStyle$1(element) {
    return getWindow(element).getComputedStyle(element);
  }

  function isTableElement(element) {
    return ["table", "td", "th"].indexOf(getNodeName(element)) >= 0;
  }

  function getDocumentElement(element) {
    return ((isElement(element) ? element.ownerDocument : element.document) || window.document).documentElement;
  }

  function getParentNode(element) {
    if (getNodeName(element) === "html") {
      return element;
    }
    return element.assignedSlot || element.parentNode || (isShadowRoot(element) ? element.host : null) || getDocumentElement(element);
  }

  function getTrueOffsetParent(element) {
    if (!isHTMLElement(element) || getComputedStyle$1(element).position === "fixed") {
      return null;
    }
    return element.offsetParent;
  }
  function getContainingBlock(element) {
    var isFirefox = navigator.userAgent.toLowerCase().indexOf("firefox") !== -1;
    var isIE = navigator.userAgent.indexOf("Trident") !== -1;
    if (isIE && isHTMLElement(element)) {
      var elementCss = getComputedStyle$1(element);
      if (elementCss.position === "fixed") {
        return null;
      }
    }
    var currentNode = getParentNode(element);
    while (isHTMLElement(currentNode) && ["html", "body"].indexOf(getNodeName(currentNode)) < 0) {
      var css = getComputedStyle$1(currentNode);
      if (css.transform !== "none" || css.perspective !== "none" || css.contain === "paint" || ["transform", "perspective"].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === "filter" || isFirefox && css.filter && css.filter !== "none") {
        return currentNode;
      } else {
        currentNode = currentNode.parentNode;
      }
    }
    return null;
  }
  function getOffsetParent(element) {
    var window = getWindow(element);
    var offsetParent = getTrueOffsetParent(element);
    while (offsetParent && isTableElement(offsetParent) && getComputedStyle$1(offsetParent).position === "static") {
      offsetParent = getTrueOffsetParent(offsetParent);
    }
    if (offsetParent && (getNodeName(offsetParent) === "html" || getNodeName(offsetParent) === "body" && getComputedStyle$1(offsetParent).position === "static")) {
      return window;
    }
    return offsetParent || getContainingBlock(element) || window;
  }

  function getMainAxisFromPlacement(placement) {
    return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
  }

  function within(min, value, max) {
    return max$1(min, min$1(value, max));
  }
  function withinMaxClamp(min, value, max) {
    var v = within(min, value, max);
    return v > max ? max : v;
  }

  function getFreshSideObject() {
    return {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
  }

  function mergePaddingObject(paddingObject) {
    return Object.assign({}, getFreshSideObject(), paddingObject);
  }

  function expandToHashMap(value, keys) {
    return keys.reduce(function(hashMap, key) {
      hashMap[key] = value;
      return hashMap;
    }, {});
  }

  var toPaddingObject = function toPaddingObject2(padding, state) {
    padding = typeof padding === "function" ? padding(Object.assign({}, state.rects, {
      placement: state.placement
    })) : padding;
    return mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
  };
  function arrow(_ref) {
    var _state$modifiersData$;
    var state = _ref.state, name = _ref.name, options = _ref.options;
    var arrowElement = state.elements.arrow;
    var popperOffsets = state.modifiersData.popperOffsets;
    var basePlacement = getBasePlacement(state.placement);
    var axis = getMainAxisFromPlacement(basePlacement);
    var isVertical = [left, right].indexOf(basePlacement) >= 0;
    var len = isVertical ? "height" : "width";
    if (!arrowElement || !popperOffsets) {
      return;
    }
    var paddingObject = toPaddingObject(options.padding, state);
    var arrowRect = getLayoutRect(arrowElement);
    var minProp = axis === "y" ? top : left;
    var maxProp = axis === "y" ? bottom : right;
    var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
    var startDiff = popperOffsets[axis] - state.rects.reference[axis];
    var arrowOffsetParent = getOffsetParent(arrowElement);
    var clientSize = arrowOffsetParent ? axis === "y" ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
    var centerToReference = endDiff / 2 - startDiff / 2;
    var min = paddingObject[minProp];
    var max = clientSize - arrowRect[len] - paddingObject[maxProp];
    var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
    var offset = within(min, center, max);
    var axisProp = axis;
    state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
  }
  function effect$1(_ref2) {
    var state = _ref2.state, options = _ref2.options;
    var _options$element = options.element, arrowElement = _options$element === void 0 ? "[data-popper-arrow]" : _options$element;
    if (arrowElement == null) {
      return;
    }
    if (typeof arrowElement === "string") {
      arrowElement = state.elements.popper.querySelector(arrowElement);
      if (!arrowElement) {
        return;
      }
    }
    if (!contains(state.elements.popper, arrowElement)) {
      return;
    }
    state.elements.arrow = arrowElement;
  }
  var arrow$1 = {
    name: "arrow",
    enabled: true,
    phase: "main",
    fn: arrow,
    effect: effect$1,
    requires: ["popperOffsets"],
    requiresIfExists: ["preventOverflow"]
  };

  function getVariation(placement) {
    return placement.split("-")[1];
  }

  var unsetSides = {
    top: "auto",
    right: "auto",
    bottom: "auto",
    left: "auto"
  };
  function roundOffsetsByDPR(_ref) {
    var x = _ref.x, y = _ref.y;
    var win = window;
    var dpr = win.devicePixelRatio || 1;
    return {
      x: round(x * dpr) / dpr || 0,
      y: round(y * dpr) / dpr || 0
    };
  }
  function mapToStyles(_ref2) {
    var _Object$assign2;
    var popper = _ref2.popper, popperRect = _ref2.popperRect, placement = _ref2.placement, variation = _ref2.variation, offsets = _ref2.offsets, position = _ref2.position, gpuAcceleration = _ref2.gpuAcceleration, adaptive = _ref2.adaptive, roundOffsets = _ref2.roundOffsets, isFixed = _ref2.isFixed;
    var _offsets$x = offsets.x, x = _offsets$x === void 0 ? 0 : _offsets$x, _offsets$y = offsets.y, y = _offsets$y === void 0 ? 0 : _offsets$y;
    var _ref3 = typeof roundOffsets === "function" ? roundOffsets({
      x,
      y
    }) : {
      x,
      y
    };
    x = _ref3.x;
    y = _ref3.y;
    var hasX = offsets.hasOwnProperty("x");
    var hasY = offsets.hasOwnProperty("y");
    var sideX = left;
    var sideY = top;
    var win = window;
    if (adaptive) {
      var offsetParent = getOffsetParent(popper);
      var heightProp = "clientHeight";
      var widthProp = "clientWidth";
      if (offsetParent === getWindow(popper)) {
        offsetParent = getDocumentElement(popper);
        if (getComputedStyle$1(offsetParent).position !== "static" && position === "absolute") {
          heightProp = "scrollHeight";
          widthProp = "scrollWidth";
        }
      }
      offsetParent = offsetParent;
      if (placement === top || (placement === left || placement === right) && variation === end) {
        sideY = bottom;
        var offsetY = isFixed && win.visualViewport ? win.visualViewport.height : offsetParent[heightProp];
        y -= offsetY - popperRect.height;
        y *= gpuAcceleration ? 1 : -1;
      }
      if (placement === left || (placement === top || placement === bottom) && variation === end) {
        sideX = right;
        var offsetX = isFixed && win.visualViewport ? win.visualViewport.width : offsetParent[widthProp];
        x -= offsetX - popperRect.width;
        x *= gpuAcceleration ? 1 : -1;
      }
    }
    var commonStyles = Object.assign({
      position
    }, adaptive && unsetSides);
    var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
      x,
      y
    }) : {
      x,
      y
    };
    x = _ref4.x;
    y = _ref4.y;
    if (gpuAcceleration) {
      var _Object$assign;
      return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? "0" : "", _Object$assign[sideX] = hasX ? "0" : "", _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
    }
    return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : "", _Object$assign2[sideX] = hasX ? x + "px" : "", _Object$assign2.transform = "", _Object$assign2));
  }
  function computeStyles(_ref5) {
    var state = _ref5.state, options = _ref5.options;
    var _options$gpuAccelerat = options.gpuAcceleration, gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat, _options$adaptive = options.adaptive, adaptive = _options$adaptive === void 0 ? true : _options$adaptive, _options$roundOffsets = options.roundOffsets, roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
    var commonStyles = {
      placement: getBasePlacement(state.placement),
      variation: getVariation(state.placement),
      popper: state.elements.popper,
      popperRect: state.rects.popper,
      gpuAcceleration,
      isFixed: state.options.strategy === "fixed"
    };
    if (state.modifiersData.popperOffsets != null) {
      state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.popperOffsets,
        position: state.options.strategy,
        adaptive,
        roundOffsets
      })));
    }
    if (state.modifiersData.arrow != null) {
      state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
        offsets: state.modifiersData.arrow,
        position: "absolute",
        adaptive: false,
        roundOffsets
      })));
    }
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      "data-popper-placement": state.placement
    });
  }
  var computeStyles$1 = {
    name: "computeStyles",
    enabled: true,
    phase: "beforeWrite",
    fn: computeStyles,
    data: {}
  };

  var passive = {
    passive: true
  };
  function effect(_ref) {
    var state = _ref.state, instance = _ref.instance, options = _ref.options;
    var _options$scroll = options.scroll, scroll = _options$scroll === void 0 ? true : _options$scroll, _options$resize = options.resize, resize = _options$resize === void 0 ? true : _options$resize;
    var window = getWindow(state.elements.popper);
    var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);
    if (scroll) {
      scrollParents.forEach(function(scrollParent) {
        scrollParent.addEventListener("scroll", instance.update, passive);
      });
    }
    if (resize) {
      window.addEventListener("resize", instance.update, passive);
    }
    return function() {
      if (scroll) {
        scrollParents.forEach(function(scrollParent) {
          scrollParent.removeEventListener("scroll", instance.update, passive);
        });
      }
      if (resize) {
        window.removeEventListener("resize", instance.update, passive);
      }
    };
  }
  var eventListeners = {
    name: "eventListeners",
    enabled: true,
    phase: "write",
    fn: function fn() {
    },
    effect,
    data: {}
  };

  var hash$1 = {
    left: "right",
    right: "left",
    bottom: "top",
    top: "bottom"
  };
  function getOppositePlacement(placement) {
    return placement.replace(/left|right|bottom|top/g, function(matched) {
      return hash$1[matched];
    });
  }

  var hash = {
    start: "end",
    end: "start"
  };
  function getOppositeVariationPlacement(placement) {
    return placement.replace(/start|end/g, function(matched) {
      return hash[matched];
    });
  }

  function getWindowScroll(node) {
    var win = getWindow(node);
    var scrollLeft = win.pageXOffset;
    var scrollTop = win.pageYOffset;
    return {
      scrollLeft,
      scrollTop
    };
  }

  function getWindowScrollBarX(element) {
    return getBoundingClientRect(getDocumentElement(element)).left + getWindowScroll(element).scrollLeft;
  }

  function getViewportRect(element) {
    var win = getWindow(element);
    var html = getDocumentElement(element);
    var visualViewport = win.visualViewport;
    var width = html.clientWidth;
    var height = html.clientHeight;
    var x = 0;
    var y = 0;
    if (visualViewport) {
      width = visualViewport.width;
      height = visualViewport.height;
      if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
        x = visualViewport.offsetLeft;
        y = visualViewport.offsetTop;
      }
    }
    return {
      width,
      height,
      x: x + getWindowScrollBarX(element),
      y
    };
  }

  function getDocumentRect(element) {
    var _element$ownerDocumen;
    var html = getDocumentElement(element);
    var winScroll = getWindowScroll(element);
    var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
    var width = max$1(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
    var height = max$1(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
    var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
    var y = -winScroll.scrollTop;
    if (getComputedStyle$1(body || html).direction === "rtl") {
      x += max$1(html.clientWidth, body ? body.clientWidth : 0) - width;
    }
    return {
      width,
      height,
      x,
      y
    };
  }

  function isScrollParent(element) {
    var _getComputedStyle = getComputedStyle$1(element), overflow = _getComputedStyle.overflow, overflowX = _getComputedStyle.overflowX, overflowY = _getComputedStyle.overflowY;
    return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
  }

  function getScrollParent(node) {
    if (["html", "body", "#document"].indexOf(getNodeName(node)) >= 0) {
      return node.ownerDocument.body;
    }
    if (isHTMLElement(node) && isScrollParent(node)) {
      return node;
    }
    return getScrollParent(getParentNode(node));
  }

  function listScrollParents(element, list) {
    var _element$ownerDocumen;
    if (list === void 0) {
      list = [];
    }
    var scrollParent = getScrollParent(element);
    var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
    var win = getWindow(scrollParent);
    var target = isBody ? [win].concat(win.visualViewport || [], isScrollParent(scrollParent) ? scrollParent : []) : scrollParent;
    var updatedList = list.concat(target);
    return isBody ? updatedList : updatedList.concat(listScrollParents(getParentNode(target)));
  }

  function rectToClientRect(rect) {
    return Object.assign({}, rect, {
      left: rect.x,
      top: rect.y,
      right: rect.x + rect.width,
      bottom: rect.y + rect.height
    });
  }

  function getInnerBoundingClientRect(element) {
    var rect = getBoundingClientRect(element);
    rect.top = rect.top + element.clientTop;
    rect.left = rect.left + element.clientLeft;
    rect.bottom = rect.top + element.clientHeight;
    rect.right = rect.left + element.clientWidth;
    rect.width = element.clientWidth;
    rect.height = element.clientHeight;
    rect.x = rect.left;
    rect.y = rect.top;
    return rect;
  }
  function getClientRectFromMixedType(element, clippingParent) {
    return clippingParent === viewport ? rectToClientRect(getViewportRect(element)) : isElement(clippingParent) ? getInnerBoundingClientRect(clippingParent) : rectToClientRect(getDocumentRect(getDocumentElement(element)));
  }
  function getClippingParents(element) {
    var clippingParents = listScrollParents(getParentNode(element));
    var canEscapeClipping = ["absolute", "fixed"].indexOf(getComputedStyle$1(element).position) >= 0;
    var clipperElement = canEscapeClipping && isHTMLElement(element) ? getOffsetParent(element) : element;
    if (!isElement(clipperElement)) {
      return [];
    }
    return clippingParents.filter(function(clippingParent) {
      return isElement(clippingParent) && contains(clippingParent, clipperElement) && getNodeName(clippingParent) !== "body";
    });
  }
  function getClippingRect(element, boundary, rootBoundary) {
    var mainClippingParents = boundary === "clippingParents" ? getClippingParents(element) : [].concat(boundary);
    var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
    var firstClippingParent = clippingParents[0];
    var clippingRect = clippingParents.reduce(function(accRect, clippingParent) {
      var rect = getClientRectFromMixedType(element, clippingParent);
      accRect.top = max$1(rect.top, accRect.top);
      accRect.right = min$1(rect.right, accRect.right);
      accRect.bottom = min$1(rect.bottom, accRect.bottom);
      accRect.left = max$1(rect.left, accRect.left);
      return accRect;
    }, getClientRectFromMixedType(element, firstClippingParent));
    clippingRect.width = clippingRect.right - clippingRect.left;
    clippingRect.height = clippingRect.bottom - clippingRect.top;
    clippingRect.x = clippingRect.left;
    clippingRect.y = clippingRect.top;
    return clippingRect;
  }

  function computeOffsets(_ref) {
    var reference = _ref.reference, element = _ref.element, placement = _ref.placement;
    var basePlacement = placement ? getBasePlacement(placement) : null;
    var variation = placement ? getVariation(placement) : null;
    var commonX = reference.x + reference.width / 2 - element.width / 2;
    var commonY = reference.y + reference.height / 2 - element.height / 2;
    var offsets;
    switch (basePlacement) {
      case top:
        offsets = {
          x: commonX,
          y: reference.y - element.height
        };
        break;
      case bottom:
        offsets = {
          x: commonX,
          y: reference.y + reference.height
        };
        break;
      case right:
        offsets = {
          x: reference.x + reference.width,
          y: commonY
        };
        break;
      case left:
        offsets = {
          x: reference.x - element.width,
          y: commonY
        };
        break;
      default:
        offsets = {
          x: reference.x,
          y: reference.y
        };
    }
    var mainAxis = basePlacement ? getMainAxisFromPlacement(basePlacement) : null;
    if (mainAxis != null) {
      var len = mainAxis === "y" ? "height" : "width";
      switch (variation) {
        case start:
          offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
          break;
        case end:
          offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
          break;
      }
    }
    return offsets;
  }

  function detectOverflow(state, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options, _options$placement = _options.placement, placement = _options$placement === void 0 ? state.placement : _options$placement, _options$boundary = _options.boundary, boundary = _options$boundary === void 0 ? clippingParents : _options$boundary, _options$rootBoundary = _options.rootBoundary, rootBoundary = _options$rootBoundary === void 0 ? viewport : _options$rootBoundary, _options$elementConte = _options.elementContext, elementContext = _options$elementConte === void 0 ? popper : _options$elementConte, _options$altBoundary = _options.altBoundary, altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary, _options$padding = _options.padding, padding = _options$padding === void 0 ? 0 : _options$padding;
    var paddingObject = mergePaddingObject(typeof padding !== "number" ? padding : expandToHashMap(padding, basePlacements));
    var altContext = elementContext === popper ? reference : popper;
    var popperRect = state.rects.popper;
    var element = state.elements[altBoundary ? altContext : elementContext];
    var clippingClientRect = getClippingRect(isElement(element) ? element : element.contextElement || getDocumentElement(state.elements.popper), boundary, rootBoundary);
    var referenceClientRect = getBoundingClientRect(state.elements.reference);
    var popperOffsets = computeOffsets({
      reference: referenceClientRect,
      element: popperRect,
      strategy: "absolute",
      placement
    });
    var popperClientRect = rectToClientRect(Object.assign({}, popperRect, popperOffsets));
    var elementClientRect = elementContext === popper ? popperClientRect : referenceClientRect;
    var overflowOffsets = {
      top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
      bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
      left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
      right: elementClientRect.right - clippingClientRect.right + paddingObject.right
    };
    var offsetData = state.modifiersData.offset;
    if (elementContext === popper && offsetData) {
      var offset = offsetData[placement];
      Object.keys(overflowOffsets).forEach(function(key) {
        var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
        var axis = [top, bottom].indexOf(key) >= 0 ? "y" : "x";
        overflowOffsets[key] += offset[axis] * multiply;
      });
    }
    return overflowOffsets;
  }

  function computeAutoPlacement(state, options) {
    if (options === void 0) {
      options = {};
    }
    var _options = options, placement = _options.placement, boundary = _options.boundary, rootBoundary = _options.rootBoundary, padding = _options.padding, flipVariations = _options.flipVariations, _options$allowedAutoP = _options.allowedAutoPlacements, allowedAutoPlacements = _options$allowedAutoP === void 0 ? placements : _options$allowedAutoP;
    var variation = getVariation(placement);
    var placements$1 = variation ? flipVariations ? variationPlacements : variationPlacements.filter(function(placement2) {
      return getVariation(placement2) === variation;
    }) : basePlacements;
    var allowedPlacements = placements$1.filter(function(placement2) {
      return allowedAutoPlacements.indexOf(placement2) >= 0;
    });
    if (allowedPlacements.length === 0) {
      allowedPlacements = placements$1;
    }
    var overflows = allowedPlacements.reduce(function(acc, placement2) {
      acc[placement2] = detectOverflow(state, {
        placement: placement2,
        boundary,
        rootBoundary,
        padding
      })[getBasePlacement(placement2)];
      return acc;
    }, {});
    return Object.keys(overflows).sort(function(a, b) {
      return overflows[a] - overflows[b];
    });
  }

  function getExpandedFallbackPlacements(placement) {
    if (getBasePlacement(placement) === auto) {
      return [];
    }
    var oppositePlacement = getOppositePlacement(placement);
    return [getOppositeVariationPlacement(placement), oppositePlacement, getOppositeVariationPlacement(oppositePlacement)];
  }
  function flip(_ref) {
    var state = _ref.state, options = _ref.options, name = _ref.name;
    if (state.modifiersData[name]._skip) {
      return;
    }
    var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis, specifiedFallbackPlacements = options.fallbackPlacements, padding = options.padding, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, _options$flipVariatio = options.flipVariations, flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio, allowedAutoPlacements = options.allowedAutoPlacements;
    var preferredPlacement = state.options.placement;
    var basePlacement = getBasePlacement(preferredPlacement);
    var isBasePlacement = basePlacement === preferredPlacement;
    var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [getOppositePlacement(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
    var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function(acc, placement2) {
      return acc.concat(getBasePlacement(placement2) === auto ? computeAutoPlacement(state, {
        placement: placement2,
        boundary,
        rootBoundary,
        padding,
        flipVariations,
        allowedAutoPlacements
      }) : placement2);
    }, []);
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var checksMap = /* @__PURE__ */ new Map();
    var makeFallbackChecks = true;
    var firstFittingPlacement = placements[0];
    for (var i = 0; i < placements.length; i++) {
      var placement = placements[i];
      var _basePlacement = getBasePlacement(placement);
      var isStartVariation = getVariation(placement) === start;
      var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
      var len = isVertical ? "width" : "height";
      var overflow = detectOverflow(state, {
        placement,
        boundary,
        rootBoundary,
        altBoundary,
        padding
      });
      var mainVariationSide = isVertical ? isStartVariation ? right : left : isStartVariation ? bottom : top;
      if (referenceRect[len] > popperRect[len]) {
        mainVariationSide = getOppositePlacement(mainVariationSide);
      }
      var altVariationSide = getOppositePlacement(mainVariationSide);
      var checks = [];
      if (checkMainAxis) {
        checks.push(overflow[_basePlacement] <= 0);
      }
      if (checkAltAxis) {
        checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
      }
      if (checks.every(function(check) {
        return check;
      })) {
        firstFittingPlacement = placement;
        makeFallbackChecks = false;
        break;
      }
      checksMap.set(placement, checks);
    }
    if (makeFallbackChecks) {
      var numberOfChecks = flipVariations ? 3 : 1;
      var _loop = function _loop2(_i2) {
        var fittingPlacement = placements.find(function(placement2) {
          var checks2 = checksMap.get(placement2);
          if (checks2) {
            return checks2.slice(0, _i2).every(function(check) {
              return check;
            });
          }
        });
        if (fittingPlacement) {
          firstFittingPlacement = fittingPlacement;
          return "break";
        }
      };
      for (var _i = numberOfChecks; _i > 0; _i--) {
        var _ret = _loop(_i);
        if (_ret === "break")
          break;
      }
    }
    if (state.placement !== firstFittingPlacement) {
      state.modifiersData[name]._skip = true;
      state.placement = firstFittingPlacement;
      state.reset = true;
    }
  }
  var flip$1 = {
    name: "flip",
    enabled: true,
    phase: "main",
    fn: flip,
    requiresIfExists: ["offset"],
    data: {
      _skip: false
    }
  };

  function getSideOffsets(overflow, rect, preventedOffsets) {
    if (preventedOffsets === void 0) {
      preventedOffsets = {
        x: 0,
        y: 0
      };
    }
    return {
      top: overflow.top - rect.height - preventedOffsets.y,
      right: overflow.right - rect.width + preventedOffsets.x,
      bottom: overflow.bottom - rect.height + preventedOffsets.y,
      left: overflow.left - rect.width - preventedOffsets.x
    };
  }
  function isAnySideFullyClipped(overflow) {
    return [top, right, bottom, left].some(function(side) {
      return overflow[side] >= 0;
    });
  }
  function hide(_ref) {
    var state = _ref.state, name = _ref.name;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var preventedOffsets = state.modifiersData.preventOverflow;
    var referenceOverflow = detectOverflow(state, {
      elementContext: "reference"
    });
    var popperAltOverflow = detectOverflow(state, {
      altBoundary: true
    });
    var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
    var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
    var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
    var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
    state.modifiersData[name] = {
      referenceClippingOffsets,
      popperEscapeOffsets,
      isReferenceHidden,
      hasPopperEscaped
    };
    state.attributes.popper = Object.assign({}, state.attributes.popper, {
      "data-popper-reference-hidden": isReferenceHidden,
      "data-popper-escaped": hasPopperEscaped
    });
  }
  var hide$1 = {
    name: "hide",
    enabled: true,
    phase: "main",
    requiresIfExists: ["preventOverflow"],
    fn: hide
  };

  function distanceAndSkiddingToXY(placement, rects, offset2) {
    var basePlacement = getBasePlacement(placement);
    var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;
    var _ref = typeof offset2 === "function" ? offset2(Object.assign({}, rects, {
      placement
    })) : offset2, skidding = _ref[0], distance = _ref[1];
    skidding = skidding || 0;
    distance = (distance || 0) * invertDistance;
    return [left, right].indexOf(basePlacement) >= 0 ? {
      x: distance,
      y: skidding
    } : {
      x: skidding,
      y: distance
    };
  }
  function offset(_ref2) {
    var state = _ref2.state, options = _ref2.options, name = _ref2.name;
    var _options$offset = options.offset, offset2 = _options$offset === void 0 ? [0, 0] : _options$offset;
    var data = placements.reduce(function(acc, placement) {
      acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset2);
      return acc;
    }, {});
    var _data$state$placement = data[state.placement], x = _data$state$placement.x, y = _data$state$placement.y;
    if (state.modifiersData.popperOffsets != null) {
      state.modifiersData.popperOffsets.x += x;
      state.modifiersData.popperOffsets.y += y;
    }
    state.modifiersData[name] = data;
  }
  var offset$1 = {
    name: "offset",
    enabled: true,
    phase: "main",
    requires: ["popperOffsets"],
    fn: offset
  };

  function popperOffsets(_ref) {
    var state = _ref.state, name = _ref.name;
    state.modifiersData[name] = computeOffsets({
      reference: state.rects.reference,
      element: state.rects.popper,
      strategy: "absolute",
      placement: state.placement
    });
  }
  var popperOffsets$1 = {
    name: "popperOffsets",
    enabled: true,
    phase: "read",
    fn: popperOffsets,
    data: {}
  };

  function getAltAxis(axis) {
    return axis === "x" ? "y" : "x";
  }

  function preventOverflow(_ref) {
    var state = _ref.state, options = _ref.options, name = _ref.name;
    var _options$mainAxis = options.mainAxis, checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis, _options$altAxis = options.altAxis, checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis, boundary = options.boundary, rootBoundary = options.rootBoundary, altBoundary = options.altBoundary, padding = options.padding, _options$tether = options.tether, tether = _options$tether === void 0 ? true : _options$tether, _options$tetherOffset = options.tetherOffset, tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
    var overflow = detectOverflow(state, {
      boundary,
      rootBoundary,
      padding,
      altBoundary
    });
    var basePlacement = getBasePlacement(state.placement);
    var variation = getVariation(state.placement);
    var isBasePlacement = !variation;
    var mainAxis = getMainAxisFromPlacement(basePlacement);
    var altAxis = getAltAxis(mainAxis);
    var popperOffsets = state.modifiersData.popperOffsets;
    var referenceRect = state.rects.reference;
    var popperRect = state.rects.popper;
    var tetherOffsetValue = typeof tetherOffset === "function" ? tetherOffset(Object.assign({}, state.rects, {
      placement: state.placement
    })) : tetherOffset;
    var normalizedTetherOffsetValue = typeof tetherOffsetValue === "number" ? {
      mainAxis: tetherOffsetValue,
      altAxis: tetherOffsetValue
    } : Object.assign({
      mainAxis: 0,
      altAxis: 0
    }, tetherOffsetValue);
    var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
    var data = {
      x: 0,
      y: 0
    };
    if (!popperOffsets) {
      return;
    }
    if (checkMainAxis) {
      var _offsetModifierState$;
      var mainSide = mainAxis === "y" ? top : left;
      var altSide = mainAxis === "y" ? bottom : right;
      var len = mainAxis === "y" ? "height" : "width";
      var offset = popperOffsets[mainAxis];
      var min = offset + overflow[mainSide];
      var max = offset - overflow[altSide];
      var additive = tether ? -popperRect[len] / 2 : 0;
      var minLen = variation === start ? referenceRect[len] : popperRect[len];
      var maxLen = variation === start ? -popperRect[len] : -referenceRect[len];
      var arrowElement = state.elements.arrow;
      var arrowRect = tether && arrowElement ? getLayoutRect(arrowElement) : {
        width: 0,
        height: 0
      };
      var arrowPaddingObject = state.modifiersData["arrow#persistent"] ? state.modifiersData["arrow#persistent"].padding : getFreshSideObject();
      var arrowPaddingMin = arrowPaddingObject[mainSide];
      var arrowPaddingMax = arrowPaddingObject[altSide];
      var arrowLen = within(0, referenceRect[len], arrowRect[len]);
      var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
      var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
      var arrowOffsetParent = state.elements.arrow && getOffsetParent(state.elements.arrow);
      var clientOffset = arrowOffsetParent ? mainAxis === "y" ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
      var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
      var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
      var tetherMax = offset + maxOffset - offsetModifierValue;
      var preventedOffset = within(tether ? min$1(min, tetherMin) : min, offset, tether ? max$1(max, tetherMax) : max);
      popperOffsets[mainAxis] = preventedOffset;
      data[mainAxis] = preventedOffset - offset;
    }
    if (checkAltAxis) {
      var _offsetModifierState$2;
      var _mainSide = mainAxis === "x" ? top : left;
      var _altSide = mainAxis === "x" ? bottom : right;
      var _offset = popperOffsets[altAxis];
      var _len = altAxis === "y" ? "height" : "width";
      var _min = _offset + overflow[_mainSide];
      var _max = _offset - overflow[_altSide];
      var isOriginSide = [top, left].indexOf(basePlacement) !== -1;
      var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;
      var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;
      var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;
      var _preventedOffset = tether && isOriginSide ? withinMaxClamp(_tetherMin, _offset, _tetherMax) : within(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);
      popperOffsets[altAxis] = _preventedOffset;
      data[altAxis] = _preventedOffset - _offset;
    }
    state.modifiersData[name] = data;
  }
  var preventOverflow$1 = {
    name: "preventOverflow",
    enabled: true,
    phase: "main",
    fn: preventOverflow,
    requiresIfExists: ["offset"]
  };

  function getHTMLElementScroll(element) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }

  function getNodeScroll(node) {
    if (node === getWindow(node) || !isHTMLElement(node)) {
      return getWindowScroll(node);
    } else {
      return getHTMLElementScroll(node);
    }
  }

  function isElementScaled(element) {
    var rect = element.getBoundingClientRect();
    var scaleX = round(rect.width) / element.offsetWidth || 1;
    var scaleY = round(rect.height) / element.offsetHeight || 1;
    return scaleX !== 1 || scaleY !== 1;
  }
  function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
    if (isFixed === void 0) {
      isFixed = false;
    }
    var isOffsetParentAnElement = isHTMLElement(offsetParent);
    var offsetParentIsScaled = isHTMLElement(offsetParent) && isElementScaled(offsetParent);
    var documentElement = getDocumentElement(offsetParent);
    var rect = getBoundingClientRect(elementOrVirtualElement, offsetParentIsScaled);
    var scroll = {
      scrollLeft: 0,
      scrollTop: 0
    };
    var offsets = {
      x: 0,
      y: 0
    };
    if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
      if (getNodeName(offsetParent) !== "body" || isScrollParent(documentElement)) {
        scroll = getNodeScroll(offsetParent);
      }
      if (isHTMLElement(offsetParent)) {
        offsets = getBoundingClientRect(offsetParent, true);
        offsets.x += offsetParent.clientLeft;
        offsets.y += offsetParent.clientTop;
      } else if (documentElement) {
        offsets.x = getWindowScrollBarX(documentElement);
      }
    }
    return {
      x: rect.left + scroll.scrollLeft - offsets.x,
      y: rect.top + scroll.scrollTop - offsets.y,
      width: rect.width,
      height: rect.height
    };
  }

  function order(modifiers) {
    var map = /* @__PURE__ */ new Map();
    var visited = /* @__PURE__ */ new Set();
    var result = [];
    modifiers.forEach(function(modifier) {
      map.set(modifier.name, modifier);
    });
    function sort(modifier) {
      visited.add(modifier.name);
      var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
      requires.forEach(function(dep) {
        if (!visited.has(dep)) {
          var depModifier = map.get(dep);
          if (depModifier) {
            sort(depModifier);
          }
        }
      });
      result.push(modifier);
    }
    modifiers.forEach(function(modifier) {
      if (!visited.has(modifier.name)) {
        sort(modifier);
      }
    });
    return result;
  }
  function orderModifiers(modifiers) {
    var orderedModifiers = order(modifiers);
    return modifierPhases.reduce(function(acc, phase) {
      return acc.concat(orderedModifiers.filter(function(modifier) {
        return modifier.phase === phase;
      }));
    }, []);
  }

  function debounce(fn) {
    var pending;
    return function() {
      if (!pending) {
        pending = new Promise(function(resolve) {
          Promise.resolve().then(function() {
            pending = void 0;
            resolve(fn());
          });
        });
      }
      return pending;
    };
  }

  function mergeByName(modifiers) {
    var merged = modifiers.reduce(function(merged2, current) {
      var existing = merged2[current.name];
      merged2[current.name] = existing ? Object.assign({}, existing, current, {
        options: Object.assign({}, existing.options, current.options),
        data: Object.assign({}, existing.data, current.data)
      }) : current;
      return merged2;
    }, {});
    return Object.keys(merged).map(function(key) {
      return merged[key];
    });
  }

  var DEFAULT_OPTIONS = {
    placement: "bottom",
    modifiers: [],
    strategy: "absolute"
  };
  function areValidElements() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    return !args.some(function(element) {
      return !(element && typeof element.getBoundingClientRect === "function");
    });
  }
  function popperGenerator(generatorOptions) {
    if (generatorOptions === void 0) {
      generatorOptions = {};
    }
    var _generatorOptions = generatorOptions, _generatorOptions$def = _generatorOptions.defaultModifiers, defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def, _generatorOptions$def2 = _generatorOptions.defaultOptions, defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
    return function createPopper2(reference, popper, options) {
      if (options === void 0) {
        options = defaultOptions;
      }
      var state = {
        placement: "bottom",
        orderedModifiers: [],
        options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
        modifiersData: {},
        elements: {
          reference,
          popper
        },
        attributes: {},
        styles: {}
      };
      var effectCleanupFns = [];
      var isDestroyed = false;
      var instance = {
        state,
        setOptions: function setOptions(setOptionsAction) {
          var options2 = typeof setOptionsAction === "function" ? setOptionsAction(state.options) : setOptionsAction;
          cleanupModifierEffects();
          state.options = Object.assign({}, defaultOptions, state.options, options2);
          state.scrollParents = {
            reference: isElement(reference) ? listScrollParents(reference) : reference.contextElement ? listScrollParents(reference.contextElement) : [],
            popper: listScrollParents(popper)
          };
          var orderedModifiers = orderModifiers(mergeByName([].concat(defaultModifiers, state.options.modifiers)));
          state.orderedModifiers = orderedModifiers.filter(function(m) {
            return m.enabled;
          });
          runModifierEffects();
          return instance.update();
        },
        forceUpdate: function forceUpdate() {
          if (isDestroyed) {
            return;
          }
          var _state$elements = state.elements, reference2 = _state$elements.reference, popper2 = _state$elements.popper;
          if (!areValidElements(reference2, popper2)) {
            return;
          }
          state.rects = {
            reference: getCompositeRect(reference2, getOffsetParent(popper2), state.options.strategy === "fixed"),
            popper: getLayoutRect(popper2)
          };
          state.reset = false;
          state.placement = state.options.placement;
          state.orderedModifiers.forEach(function(modifier) {
            return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
          });
          for (var index = 0; index < state.orderedModifiers.length; index++) {
            if (state.reset === true) {
              state.reset = false;
              index = -1;
              continue;
            }
            var _state$orderedModifie = state.orderedModifiers[index], fn = _state$orderedModifie.fn, _state$orderedModifie2 = _state$orderedModifie.options, _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2, name = _state$orderedModifie.name;
            if (typeof fn === "function") {
              state = fn({
                state,
                options: _options,
                name,
                instance
              }) || state;
            }
          }
        },
        update: debounce(function() {
          return new Promise(function(resolve) {
            instance.forceUpdate();
            resolve(state);
          });
        }),
        destroy: function destroy() {
          cleanupModifierEffects();
          isDestroyed = true;
        }
      };
      if (!areValidElements(reference, popper)) {
        return instance;
      }
      instance.setOptions(options).then(function(state2) {
        if (!isDestroyed && options.onFirstUpdate) {
          options.onFirstUpdate(state2);
        }
      });
      function runModifierEffects() {
        state.orderedModifiers.forEach(function(_ref3) {
          var name = _ref3.name, _ref3$options = _ref3.options, options2 = _ref3$options === void 0 ? {} : _ref3$options, effect = _ref3.effect;
          if (typeof effect === "function") {
            var cleanupFn = effect({
              state,
              name,
              instance,
              options: options2
            });
            var noopFn = function noopFn2() {
            };
            effectCleanupFns.push(cleanupFn || noopFn);
          }
        });
      }
      function cleanupModifierEffects() {
        effectCleanupFns.forEach(function(fn) {
          return fn();
        });
        effectCleanupFns = [];
      }
      return instance;
    };
  }

  var defaultModifiers = [eventListeners, popperOffsets$1, computeStyles$1, applyStyles$1, offset$1, flip$1, preventOverflow$1, arrow$1, hide$1];
  var createPopper = /* @__PURE__ */ popperGenerator({
    defaultModifiers
  });

  const Effect = {
    LIGHT: "light",
    DARK: "dark"
  };
  const usePopperArrowProps = buildProps({
    arrowOffset: {
      type: Number,
      default: 5
    }
  });
  const usePopperCoreConfigProps = buildProps({
    boundariesPadding: {
      type: Number,
      default: 0
    },
    fallbackPlacements: {
      type: definePropType(Array),
      default: () => []
    },
    gpuAcceleration: {
      type: Boolean,
      default: true
    },
    offset: {
      type: Number,
      default: 12
    },
    placement: {
      type: String,
      values: placements,
      default: "bottom"
    },
    popperOptions: {
      type: definePropType(Object),
      default: () => ({})
    },
    strategy: {
      type: String,
      values: ["fixed", "absolute"],
      default: "absolute"
    }
  });
  const usePopperProps = buildProps({
    autoClose: {
      type: Number,
      default: 0
    },
    cutoff: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    }
  });
  const usePopperContentProps = buildProps({
    ...usePopperCoreConfigProps,
    style: { type: definePropType([String, Array, Object]) },
    className: { type: definePropType([String, Array, Object]) },
    effect: {
      type: String,
      default: "dark"
    },
    visible: {
      type: Boolean
    },
    enterable: {
      type: Boolean,
      default: true
    },
    pure: {
      type: Boolean
    },
    popperClass: {
      type: definePropType([String, Array, Object])
    },
    popperStyle: {
      type: definePropType([String, Array, Object])
    },
    referenceEl: {
      type: definePropType(Object)
    },
    stopPopperMouseEvent: {
      type: Boolean,
      default: true
    },
    zIndex: Number
  });
  const usePopperTriggerProps = buildProps({
    virtualRef: {
      type: definePropType(Object)
    },
    virtualTriggering: {
      type: Boolean
    }
  });

  const _sfc_main$23 = vue.defineComponent({
    name: "ElPopperArrow",
    props: usePopperArrowProps,
    setup(props) {
      const ns = useNamespace("popper");
      const arrowRef = vue.ref(null);
      const popperContentInjection = vue.inject(POPPER_CONTENT_INJECTION_KEY, void 0);
      vue.watch(() => props.arrowOffset, (val) => {
        popperContentInjection.arrowOffset.value = val;
      });
      vue.onMounted(() => {
        popperContentInjection.arrowRef.value = vue.unref(arrowRef);
      });
      vue.onBeforeUnmount(() => {
        popperContentInjection.arrowRef.value = null;
      });
      return {
        ns,
        arrowRef
      };
    }
  });
  function _sfc_render$1E(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("span", {
      ref: "arrowRef",
      class: vue.normalizeClass(_ctx.ns.e("arrow")),
      "data-popper-arrow": ""
    }, null, 2);
  }
  var ElPopperArrow = /* @__PURE__ */ _export_sfc(_sfc_main$23, [["render", _sfc_render$1E]]);

  const NAME = "ElOnlyChild";
  const OnlyChild = vue.defineComponent({
    name: NAME,
    setup(_, {
      slots,
      attrs
    }) {
      var _a;
      const forwardRefInjection = vue.inject(FORWARD_REF_INJECTION_KEY);
      const forwardRefDirective = useForwardRefDirective((_a = forwardRefInjection == null ? void 0 : forwardRefInjection.setForwardRef) != null ? _a : NOOP);
      return () => {
        var _a2;
        const defaultSlot = (_a2 = slots.default) == null ? void 0 : _a2.call(slots, attrs);
        if (!defaultSlot)
          return null;
        if (defaultSlot.length > 1) {
          return null;
        }
        const firstLegitNode = findFirstLegitChild(defaultSlot);
        if (!firstLegitNode) {
          return null;
        }
        return vue.withDirectives(vue.cloneVNode(firstLegitNode, attrs), [[forwardRefDirective]]);
      };
    }
  });
  function findFirstLegitChild(node) {
    if (!node)
      return null;
    const children = node;
    for (const child of children) {
      if (isObject$1(child)) {
        switch (child.type) {
          case vue.Comment:
            continue;
          case vue.Text:
            return wrapTextContent(child);
          case "svg":
            return wrapTextContent(child);
          case vue.Fragment:
            return findFirstLegitChild(child.children);
          default:
            return child;
        }
      }
      return wrapTextContent(child);
    }
    return null;
  }
  function wrapTextContent(s) {
    return vue.createVNode("span", {
      "class": "el-only-child__content"
    }, [s]);
  }

  const buildPopperOptions = (props, arrowProps) => {
    const { placement, strategy, popperOptions } = props;
    const options = {
      placement,
      strategy,
      ...popperOptions,
      modifiers: genModifiers(props)
    };
    attachArrow(options, arrowProps);
    deriveExtraModifiers(options, popperOptions == null ? void 0 : popperOptions.modifiers);
    return options;
  };
  const unwrapMeasurableEl = ($el) => {
    let el = null;
    if (!$el)
      return null;
    if ("getBoundingClientRect" in $el || isElement$1($el)) {
      el = $el;
    } else {
      el = $el.$el;
    }
    return el;
  };
  function genModifiers(options) {
    const { offset, gpuAcceleration, fallbackPlacements } = options;
    return [
      {
        name: "offset",
        options: {
          offset: [0, offset != null ? offset : 12]
        }
      },
      {
        name: "preventOverflow",
        options: {
          padding: {
            top: 2,
            bottom: 2,
            left: 5,
            right: 5
          }
        }
      },
      {
        name: "flip",
        options: {
          padding: 5,
          fallbackPlacements: fallbackPlacements != null ? fallbackPlacements : []
        }
      },
      {
        name: "computeStyles",
        options: {
          gpuAcceleration,
          adaptive: gpuAcceleration
        }
      }
    ];
  }
  function attachArrow(options, { arrowEl, arrowOffset }) {
    options.modifiers.push({
      name: "arrow",
      options: {
        element: arrowEl,
        padding: arrowOffset != null ? arrowOffset : 5
      }
    });
  }
  function deriveExtraModifiers(options, modifiers) {
    if (modifiers) {
      options.modifiers = [...options.modifiers, ...modifiers != null ? modifiers : []];
    }
  }

  const _sfc_main$22 = vue.defineComponent({
    name: "ElPopperTrigger",
    components: { ElOnlyChild: OnlyChild },
    inheritAttrs: false,
    props: {
      ...usePopperTriggerProps,
      onMouseenter: Function,
      onMouseleave: Function,
      onClick: Function,
      onKeydown: Function,
      onFocus: Function,
      onBlur: Function,
      onContextmenu: Function,
      id: String,
      open: Boolean
    },
    setup(props) {
      const { triggerRef } = vue.inject(POPPER_INJECTION_KEY, void 0);
      useForwardRef(triggerRef);
      vue.watch(() => props.virtualRef, (val) => {
        if (val) {
          triggerRef.value = unwrapMeasurableEl(val);
        }
      }, {
        immediate: true
      });
      vue.watch(() => triggerRef.value, (el, prevEl) => {
        if (isElement$1(el)) {
          [
            "onMouseenter",
            "onMouseleave",
            "onClick",
            "onKeydown",
            "onFocus",
            "onBlur",
            "onContextmenu"
          ].forEach((eventName) => {
            const handler = props[eventName];
            if (handler) {
              el.addEventListener(eventName.slice(2).toLowerCase(), handler);
              prevEl == null ? void 0 : prevEl.removeEventListener(eventName.slice(2).toLowerCase(), handler);
            }
          });
        }
      }, {
        immediate: true
      });
      return {
        triggerRef
      };
    }
  });
  function _sfc_render$1D(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_only_child = vue.resolveComponent("el-only-child");
    return !_ctx.virtualTriggering ? (vue.openBlock(), vue.createBlock(_component_el_only_child, vue.mergeProps({ key: 0 }, _ctx.$attrs, {
      "aria-describedby": _ctx.open ? _ctx.id : void 0
    }), {
      default: vue.withCtx(() => [
        vue.renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 16, ["aria-describedby"])) : vue.createCommentVNode("v-if", true);
  }
  var ElPopperTrigger = /* @__PURE__ */ _export_sfc(_sfc_main$22, [["render", _sfc_render$1D]]);

  const _sfc_main$21 = vue.defineComponent({
    name: "ElPopperContent",
    props: usePopperContentProps,
    emits: ["mouseenter", "mouseleave"],
    setup(props) {
      const { triggerRef, popperInstanceRef, contentRef } = vue.inject(POPPER_INJECTION_KEY, void 0);
      const { nextZIndex } = useZIndex();
      const ns = useNamespace("popper");
      const popperContentRef = vue.ref(null);
      const arrowRef = vue.ref(null);
      const arrowOffset = vue.ref();
      vue.provide(POPPER_CONTENT_INJECTION_KEY, {
        arrowRef,
        arrowOffset
      });
      const contentZIndex = vue.ref(props.zIndex || nextZIndex());
      const contentStyle = vue.computed(() => [{ zIndex: vue.unref(contentZIndex) }, props.popperStyle]);
      const contentClass = vue.computed(() => [
        ns.b(),
        ns.is("pure", props.pure),
        ns.is(props.effect),
        props.popperClass
      ]);
      const createPopperInstance = ({
        referenceEl,
        popperContentEl,
        arrowEl
      }) => {
        const options = buildPopperOptions(props, {
          arrowEl,
          arrowOffset: vue.unref(arrowOffset)
        });
        return createPopper(referenceEl, popperContentEl, options);
      };
      const updatePopper = () => {
        var _a;
        (_a = vue.unref(popperInstanceRef)) == null ? void 0 : _a.update();
        contentZIndex.value = props.zIndex || nextZIndex();
      };
      const togglePopoerAlive = () => {
        var _a;
        const monitorable = { name: "eventListeners", enabled: props.visible };
        (_a = vue.unref(popperInstanceRef)) == null ? void 0 : _a.setOptions((options) => ({
          ...options,
          modifiers: [...options.modifiers, monitorable]
        }));
      };
      vue.onMounted(() => {
        let updateHandle;
        vue.watch(() => unwrapMeasurableEl(props.referenceEl) || vue.unref(triggerRef), (val) => {
          var _a;
          updateHandle == null ? void 0 : updateHandle();
          if (val) {
            (_a = popperInstanceRef.value) == null ? void 0 : _a.destroy();
            const popperContentEl = vue.unref(popperContentRef);
            contentRef.value = popperContentEl;
            const arrowEl = vue.unref(arrowRef);
            const newInstance = createPopperInstance({
              referenceEl: val,
              popperContentEl: vue.unref(popperContentRef),
              arrowEl
            });
            popperInstanceRef.value = newInstance;
            updateHandle = vue.watch(() => val.getBoundingClientRect(), () => {
              updatePopper();
            }, {
              immediate: true
            });
          } else {
            popperInstanceRef.value = null;
          }
        }, {
          immediate: true
        });
        vue.watch(() => props.visible, togglePopoerAlive, { immediate: true });
        vue.watch(() => buildPopperOptions(props, {
          arrowEl: vue.unref(arrowRef),
          arrowOffset: vue.unref(arrowOffset)
        }), (option) => {
          var _a;
          return (_a = popperInstanceRef.value) == null ? void 0 : _a.setOptions(option);
        });
      });
      return {
        ns,
        popperContentRef,
        popperInstanceRef,
        contentStyle,
        contentClass,
        updatePopper
      };
    }
  });
  function _sfc_render$1C(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      ref: "popperContentRef",
      style: vue.normalizeStyle(_ctx.contentStyle),
      class: vue.normalizeClass(_ctx.contentClass),
      role: "tooltip",
      onMouseenter: _cache[0] || (_cache[0] = (e) => _ctx.$emit("mouseenter", e)),
      onMouseleave: _cache[1] || (_cache[1] = (e) => _ctx.$emit("mouseleave", e))
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 38);
  }
  var ElPopperContent = /* @__PURE__ */ _export_sfc(_sfc_main$21, [["render", _sfc_render$1C]]);

  function useDeprecateAppendToBody(scope, from) {
    const vm = vue.getCurrentInstance();
    const compatTeleported = vue.computed(() => {
      return isBoolean(vm.props[from]) ? vm.props[from] : vm.props.teleported;
    });
    useDeprecated({
      scope,
      from,
      replacement: "teleported",
      version: "2.1.0",
      ref: "https://element-plus.org/en-US/component/tooltip.html#attributes"
    }, vue.computed(() => isBoolean(vm.props[from])));
    return {
      compatTeleported
    };
  }

  const ElPopper = withInstall(Popper);

  const _sfc_main$20 = vue.defineComponent({
    name: "ElVisuallyHidden",
    props: {
      style: {
        type: [String, Object, Array]
      }
    },
    setup(props) {
      return {
        computedStyle: vue.computed(() => {
          return [
            props.style,
            {
              position: "absolute",
              border: 0,
              width: 1,
              height: 1,
              padding: 0,
              margin: -1,
              overflow: "hidden",
              clip: "rect(0, 0, 0, 0)",
              whiteSpace: "nowrap",
              wordWrap: "normal"
            }
          ];
        })
      };
    }
  });
  function _sfc_render$1B(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("span", vue.mergeProps(_ctx.$attrs, { style: _ctx.computedStyle }), null, 16);
  }
  var ElVisuallyHidden = /* @__PURE__ */ _export_sfc(_sfc_main$20, [["render", _sfc_render$1B]]);

  const useTooltipContentProps = buildProps({
    ...useDelayedToggleProps,
    ...usePopperContentProps,
    appendTo: {
      type: definePropType([String, Object]),
      default: POPPER_CONTAINER_SELECTOR
    },
    content: {
      type: String,
      default: ""
    },
    rawContent: {
      type: Boolean,
      default: false
    },
    persistent: Boolean,
    ariaLabel: String,
    visible: {
      type: definePropType(Boolean),
      default: null
    },
    transition: {
      type: String,
      default: "el-fade-in-linear"
    },
    teleported: {
      type: Boolean,
      default: true
    },
    disabled: {
      type: Boolean
    }
  });
  const useTooltipTriggerProps = buildProps({
    ...usePopperTriggerProps,
    disabled: Boolean,
    trigger: {
      type: definePropType([String, Array]),
      default: "hover"
    }
  });
  const useTooltipProps = buildProps({
    openDelay: {
      type: Number
    },
    visibleArrow: {
      type: Boolean,
      default: void 0
    },
    hideAfter: {
      type: Number,
      default: 200
    },
    showArrow: {
      type: Boolean,
      default: true
    }
  });

  const TOOLTIP_INJECTION_KEY = Symbol("elTooltip");

  const _sfc_main$1$ = vue.defineComponent({
    name: "ElTooltipContent",
    components: {
      ElPopperContent,
      ElVisuallyHidden
    },
    inheritAttrs: false,
    props: useTooltipContentProps,
    setup(props) {
      const contentRef = vue.ref(null);
      const intermediateOpen = vue.ref(false);
      const entering = vue.ref(false);
      const leaving = vue.ref(false);
      const destroyed = vue.ref(false);
      const {
        controlled,
        id,
        open,
        trigger,
        onClose,
        onOpen,
        onShow,
        onHide,
        onBeforeShow,
        onBeforeHide
      } = vue.inject(TOOLTIP_INJECTION_KEY, void 0);
      const persistentRef = vue.computed(() => {
        return props.persistent;
      });
      vue.onBeforeUnmount(() => {
        destroyed.value = true;
      });
      const shouldRender = vue.computed(() => {
        return vue.unref(persistentRef) ? true : vue.unref(open);
      });
      const shouldShow = vue.computed(() => {
        return props.disabled ? false : vue.unref(open);
      });
      const contentStyle = vue.computed(() => {
        var _a;
        return (_a = props.style) != null ? _a : {};
      });
      const ariaHidden = vue.computed(() => !vue.unref(open));
      useEscapeKeydown(onClose);
      const onTransitionLeave = () => {
        onHide();
      };
      const stopWhenControlled = () => {
        if (vue.unref(controlled))
          return true;
      };
      const onContentEnter = composeEventHandlers(stopWhenControlled, () => {
        if (props.enterable && vue.unref(trigger) === "hover") {
          onOpen();
        }
      });
      const onContentLeave = composeEventHandlers(stopWhenControlled, () => {
        if (vue.unref(trigger) === "hover") {
          onClose();
        }
      });
      const onBeforeEnter = () => {
        var _a, _b;
        (_b = (_a = contentRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
        onBeforeShow == null ? void 0 : onBeforeShow();
      };
      const onBeforeLeave = () => {
        onBeforeHide == null ? void 0 : onBeforeHide();
      };
      const onAfterShow = () => {
        onShow();
      };
      let stopHandle;
      vue.watch(() => vue.unref(open), (val) => {
        if (val) {
          stopHandle = onClickOutside(vue.computed(() => {
            var _a;
            return (_a = contentRef.value) == null ? void 0 : _a.popperContentRef;
          }), () => {
            if (vue.unref(controlled))
              return;
            const $trigger = vue.unref(trigger);
            if ($trigger !== "hover") {
              onClose();
            }
          });
        } else {
          stopHandle == null ? void 0 : stopHandle();
        }
      }, {
        flush: "post"
      });
      return {
        ariaHidden,
        entering,
        leaving,
        id,
        intermediateOpen,
        contentStyle,
        contentRef,
        destroyed,
        shouldRender,
        shouldShow,
        open,
        onAfterShow,
        onBeforeEnter,
        onBeforeLeave,
        onContentEnter,
        onContentLeave,
        onTransitionLeave
      };
    }
  });
  function _sfc_render$1A(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_visually_hidden = vue.resolveComponent("el-visually-hidden");
    const _component_el_popper_content = vue.resolveComponent("el-popper-content");
    return vue.openBlock(), vue.createBlock(vue.Teleport, {
      disabled: !_ctx.teleported,
      to: _ctx.appendTo
    }, [
      vue.createVNode(vue.Transition, {
        name: _ctx.transition,
        onAfterLeave: _ctx.onTransitionLeave,
        onBeforeEnter: _ctx.onBeforeEnter,
        onAfterEnter: _ctx.onAfterShow,
        onBeforeLeave: _ctx.onBeforeLeave
      }, {
        default: vue.withCtx(() => [
          _ctx.shouldRender ? vue.withDirectives((vue.openBlock(), vue.createBlock(_component_el_popper_content, vue.mergeProps({
            key: 0,
            ref: "contentRef"
          }, _ctx.$attrs, {
            "aria-hidden": _ctx.ariaHidden,
            "boundaries-padding": _ctx.boundariesPadding,
            "fallback-placements": _ctx.fallbackPlacements,
            "gpu-acceleration": _ctx.gpuAcceleration,
            offset: _ctx.offset,
            placement: _ctx.placement,
            "popper-options": _ctx.popperOptions,
            strategy: _ctx.strategy,
            effect: _ctx.effect,
            enterable: _ctx.enterable,
            pure: _ctx.pure,
            "popper-class": _ctx.popperClass,
            "popper-style": [_ctx.popperStyle, _ctx.contentStyle],
            "reference-el": _ctx.referenceEl,
            visible: _ctx.shouldShow,
            "z-index": _ctx.zIndex,
            onMouseenter: _ctx.onContentEnter,
            onMouseleave: _ctx.onContentLeave
          }), {
            default: vue.withCtx(() => [
              vue.createCommentVNode(" Workaround bug #6378 "),
              !_ctx.destroyed ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
                vue.renderSlot(_ctx.$slots, "default"),
                vue.createVNode(_component_el_visually_hidden, {
                  id: _ctx.id,
                  role: "tooltip"
                }, {
                  default: vue.withCtx(() => [
                    vue.createTextVNode(vue.toDisplayString(_ctx.ariaLabel), 1)
                  ]),
                  _: 1
                }, 8, ["id"])
              ], 64)) : vue.createCommentVNode("v-if", true)
            ]),
            _: 3
          }, 16, ["aria-hidden", "boundaries-padding", "fallback-placements", "gpu-acceleration", "offset", "placement", "popper-options", "strategy", "effect", "enterable", "pure", "popper-class", "popper-style", "reference-el", "visible", "z-index", "onMouseenter", "onMouseleave"])), [
            [vue.vShow, _ctx.shouldShow]
          ]) : vue.createCommentVNode("v-if", true)
        ]),
        _: 3
      }, 8, ["name", "onAfterLeave", "onBeforeEnter", "onAfterEnter", "onBeforeLeave"])
    ], 8, ["disabled", "to"]);
  }
  var ElTooltipContent = /* @__PURE__ */ _export_sfc(_sfc_main$1$, [["render", _sfc_render$1A]]);

  const isTriggerType = (trigger, type) => {
    if (isArray(trigger)) {
      return trigger.includes(type);
    }
    return trigger === type;
  };
  const whenTrigger = (trigger, type, handler) => {
    return (e) => {
      isTriggerType(vue.unref(trigger), type) && handler(e);
    };
  };

  const _sfc_main$1_ = vue.defineComponent({
    name: "ElTooltipTrigger",
    components: {
      ElPopperTrigger
    },
    props: useTooltipTriggerProps,
    setup(props) {
      const ns = useNamespace("tooltip");
      const { controlled, id, open, onOpen, onClose, onToggle } = vue.inject(TOOLTIP_INJECTION_KEY, void 0);
      const triggerRef = vue.ref(null);
      const stopWhenControlledOrDisabled = () => {
        if (vue.unref(controlled) || props.disabled) {
          return true;
        }
      };
      const trigger = vue.toRef(props, "trigger");
      const onMouseenter = composeEventHandlers(stopWhenControlledOrDisabled, whenTrigger(trigger, "hover", onOpen));
      const onMouseleave = composeEventHandlers(stopWhenControlledOrDisabled, whenTrigger(trigger, "hover", onClose));
      const onClick = composeEventHandlers(stopWhenControlledOrDisabled, whenTrigger(trigger, "click", (e) => {
        if (e.button === 0) {
          onToggle(e);
        }
      }));
      const onFocus = composeEventHandlers(stopWhenControlledOrDisabled, whenTrigger(trigger, "focus", onOpen));
      const onBlur = composeEventHandlers(stopWhenControlledOrDisabled, whenTrigger(trigger, "focus", onClose));
      const onContextMenu = composeEventHandlers(stopWhenControlledOrDisabled, whenTrigger(trigger, "contextmenu", (e) => {
        e.preventDefault();
        onToggle(e);
      }));
      const onKeydown = composeEventHandlers(stopWhenControlledOrDisabled, (e) => {
        const { code } = e;
        if (code === EVENT_CODE.enter || code === EVENT_CODE.space) {
          onToggle(e);
        }
      });
      return {
        onBlur,
        onContextMenu,
        onFocus,
        onMouseenter,
        onMouseleave,
        onClick,
        onKeydown,
        open,
        id,
        triggerRef,
        ns
      };
    }
  });
  function _sfc_render$1z(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_popper_trigger = vue.resolveComponent("el-popper-trigger");
    return vue.openBlock(), vue.createBlock(_component_el_popper_trigger, {
      id: _ctx.id,
      "virtual-ref": _ctx.virtualRef,
      open: _ctx.open,
      "virtual-triggering": _ctx.virtualTriggering,
      class: vue.normalizeClass(_ctx.ns.e("trigger")),
      onBlur: _ctx.onBlur,
      onClick: _ctx.onClick,
      onContextmenu: _ctx.onContextMenu,
      onFocus: _ctx.onFocus,
      onMouseenter: _ctx.onMouseenter,
      onMouseleave: _ctx.onMouseleave,
      onKeydown: _ctx.onKeydown
    }, {
      default: vue.withCtx(() => [
        vue.renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 8, ["id", "virtual-ref", "open", "virtual-triggering", "class", "onBlur", "onClick", "onContextmenu", "onFocus", "onMouseenter", "onMouseleave", "onKeydown"]);
  }
  var ElTooltipTrigger = /* @__PURE__ */ _export_sfc(_sfc_main$1_, [["render", _sfc_render$1z]]);

  const { useModelToggleProps, useModelToggle, useModelToggleEmits } = createModelToggleComposable("visible");
  const _sfc_main$1Z = vue.defineComponent({
    name: "ElTooltip",
    components: {
      ElPopper,
      ElPopperArrow,
      ElTooltipContent,
      ElTooltipTrigger
    },
    props: {
      ...useModelToggleProps,
      ...useTooltipContentProps,
      ...useTooltipTriggerProps,
      ...usePopperArrowProps,
      ...useTooltipProps
    },
    emits: [...useModelToggleEmits, "before-show", "before-hide", "show", "hide"],
    setup(props, { emit }) {
      usePopperContainer();
      const compatShowAfter = vue.computed(() => {
        if (!isUndefined(props.openDelay)) ;
        return props.openDelay || props.showAfter;
      });
      const compatShowArrow = vue.computed(() => {
        if (!isUndefined(props.visibleArrow)) ;
        return isBoolean(props.visibleArrow) ? props.visibleArrow : props.showArrow;
      });
      const id = useId();
      const popperRef = vue.ref(null);
      const updatePopper = () => {
        var _a;
        const popperComponent = vue.unref(popperRef);
        if (popperComponent) {
          (_a = popperComponent.popperInstanceRef) == null ? void 0 : _a.update();
        }
      };
      const open = vue.ref(false);
      const { show, hide } = useModelToggle({
        indicator: open
      });
      const { onOpen, onClose } = useDelayedToggle({
        showAfter: compatShowAfter,
        hideAfter: vue.toRef(props, "hideAfter"),
        open: show,
        close: hide
      });
      const controlled = vue.computed(() => isBoolean(props.visible));
      vue.provide(TOOLTIP_INJECTION_KEY, {
        controlled,
        id,
        open: vue.readonly(open),
        trigger: vue.toRef(props, "trigger"),
        onOpen,
        onClose,
        onToggle: () => {
          if (vue.unref(open)) {
            onClose();
          } else {
            onOpen();
          }
        },
        onShow: () => {
          emit("show");
        },
        onHide: () => {
          emit("hide");
        },
        onBeforeShow: () => {
          emit("before-show");
        },
        onBeforeHide: () => {
          emit("before-hide");
        },
        updatePopper
      });
      vue.watch(() => props.disabled, (disabled) => {
        if (disabled && open.value) {
          open.value = false;
        }
      });
      return {
        compatShowAfter,
        compatShowArrow,
        popperRef,
        open,
        hide,
        updatePopper,
        onOpen,
        onClose
      };
    }
  });
  const _hoisted_1$$ = ["innerHTML"];
  const _hoisted_2$H = { key: 1 };
  function _sfc_render$1y(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_tooltip_trigger = vue.resolveComponent("el-tooltip-trigger");
    const _component_el_popper_arrow = vue.resolveComponent("el-popper-arrow");
    const _component_el_tooltip_content = vue.resolveComponent("el-tooltip-content");
    const _component_el_popper = vue.resolveComponent("el-popper");
    return vue.openBlock(), vue.createBlock(_component_el_popper, { ref: "popperRef" }, {
      default: vue.withCtx(() => [
        vue.createVNode(_component_el_tooltip_trigger, {
          disabled: _ctx.disabled,
          trigger: _ctx.trigger,
          "virtual-ref": _ctx.virtualRef,
          "virtual-triggering": _ctx.virtualTriggering
        }, {
          default: vue.withCtx(() => [
            _ctx.$slots.default ? vue.renderSlot(_ctx.$slots, "default", { key: 0 }) : vue.createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 8, ["disabled", "trigger", "virtual-ref", "virtual-triggering"]),
        vue.createVNode(_component_el_tooltip_content, {
          "aria-label": _ctx.ariaLabel,
          "boundaries-padding": _ctx.boundariesPadding,
          content: _ctx.content,
          disabled: _ctx.disabled,
          effect: _ctx.effect,
          enterable: _ctx.enterable,
          "fallback-placements": _ctx.fallbackPlacements,
          "hide-after": _ctx.hideAfter,
          "gpu-acceleration": _ctx.gpuAcceleration,
          offset: _ctx.offset,
          persistent: _ctx.persistent,
          "popper-class": _ctx.popperClass,
          "popper-style": _ctx.popperStyle,
          placement: _ctx.placement,
          "popper-options": _ctx.popperOptions,
          pure: _ctx.pure,
          "raw-content": _ctx.rawContent,
          "reference-el": _ctx.referenceEl,
          "show-after": _ctx.compatShowAfter,
          strategy: _ctx.strategy,
          teleported: _ctx.teleported,
          transition: _ctx.transition,
          "z-index": _ctx.zIndex,
          "append-to": _ctx.appendTo
        }, {
          default: vue.withCtx(() => [
            vue.renderSlot(_ctx.$slots, "content", {}, () => [
              _ctx.rawContent ? (vue.openBlock(), vue.createElementBlock("span", {
                key: 0,
                innerHTML: _ctx.content
              }, null, 8, _hoisted_1$$)) : (vue.openBlock(), vue.createElementBlock("span", _hoisted_2$H, vue.toDisplayString(_ctx.content), 1))
            ]),
            _ctx.compatShowArrow ? (vue.openBlock(), vue.createBlock(_component_el_popper_arrow, {
              key: 0,
              "arrow-offset": _ctx.arrowOffset
            }, null, 8, ["arrow-offset"])) : vue.createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 8, ["aria-label", "boundaries-padding", "content", "disabled", "effect", "enterable", "fallback-placements", "hide-after", "gpu-acceleration", "offset", "persistent", "popper-class", "popper-style", "placement", "popper-options", "pure", "raw-content", "reference-el", "show-after", "strategy", "teleported", "transition", "z-index", "append-to"])
      ]),
      _: 3
    }, 512);
  }
  var Tooltip = /* @__PURE__ */ _export_sfc(_sfc_main$1Z, [["render", _sfc_render$1y]]);

  const ElTooltip = withInstall(Tooltip);

  const autocompleteProps = buildProps({
    valueKey: {
      type: String,
      default: "value"
    },
    modelValue: {
      type: [String, Number],
      default: ""
    },
    debounce: {
      type: Number,
      default: 300
    },
    placement: {
      type: definePropType(String),
      values: [
        "top",
        "top-start",
        "top-end",
        "bottom",
        "bottom-start",
        "bottom-end"
      ],
      default: "bottom-start"
    },
    fetchSuggestions: {
      type: definePropType(Function),
      default: NOOP
    },
    popperClass: {
      type: String,
      default: ""
    },
    triggerOnFocus: {
      type: Boolean,
      default: true
    },
    selectWhenUnmatched: {
      type: Boolean,
      default: false
    },
    hideLoading: {
      type: Boolean,
      default: false
    },
    popperAppendToBody: {
      type: Boolean,
      default: void 0
    },
    teleported: useTooltipContentProps.teleported,
    highlightFirstItem: {
      type: Boolean,
      default: false
    }
  });
  const autocompleteEmits = {
    [UPDATE_MODEL_EVENT]: (value) => isString(value),
    input: (value) => isString(value),
    change: (value) => isString(value),
    focus: (evt) => evt instanceof FocusEvent,
    blur: (evt) => evt instanceof FocusEvent,
    clear: () => true,
    select: (item) => isObject$1(item)
  };

  const _hoisted_1$_ = ["aria-expanded", "aria-owns"];
  const _hoisted_2$G = { key: 0 };
  const _hoisted_3$p = ["id", "aria-selected", "onClick"];
  const __default__$m = {
    name: "ElAutocomplete",
    inheritAttrs: false
  };
  const _sfc_main$1Y = /* @__PURE__ */ vue.defineComponent({
    ...__default__$m,
    props: autocompleteProps,
    emits: autocompleteEmits,
    setup(__props, { expose, emit }) {
      const props = __props;
      const COMPONENT_NAME = "ElAutocomplete";
      const ns = useNamespace("autocomplete");
      const { compatTeleported } = useDeprecateAppendToBody(COMPONENT_NAME, "popperAppendToBody");
      const attrs = useAttrs();
      const compAttrs = vue.useAttrs();
      const suggestions = vue.ref([]);
      const highlightedIndex = vue.ref(-1);
      const dropdownWidth = vue.ref("");
      const activated = vue.ref(false);
      const suggestionDisabled = vue.ref(false);
      const loading$1 = vue.ref(false);
      const inputRef = vue.ref();
      const regionRef = vue.ref();
      const popperRef = vue.ref();
      const listboxRef = vue.ref();
      const id = vue.computed(() => {
        return ns.b(String(generateId()));
      });
      const styles = vue.computed(() => compAttrs.style);
      const suggestionVisible = vue.computed(() => {
        const isValidData = isArray(suggestions.value) && suggestions.value.length > 0;
        return (isValidData || loading$1.value) && activated.value;
      });
      const suggestionLoading = vue.computed(() => {
        return !props.hideLoading && loading$1.value;
      });
      const onSuggestionShow = () => {
        vue.nextTick(() => {
          if (suggestionVisible.value) {
            dropdownWidth.value = `${inputRef.value.$el.offsetWidth}px`;
          }
        });
      };
      const getData = (queryString) => {
        if (suggestionDisabled.value) {
          return;
        }
        loading$1.value = true;
        props.fetchSuggestions(queryString, (suggestionsArg) => {
          loading$1.value = false;
          if (suggestionDisabled.value) {
            return;
          }
          if (isArray(suggestionsArg)) {
            suggestions.value = suggestionsArg;
            highlightedIndex.value = props.highlightFirstItem ? 0 : -1;
          } else {
            throwError(COMPONENT_NAME, "autocomplete suggestions must be an array");
          }
        });
      };
      const debouncedGetData = debounce$1(getData, props.debounce);
      const handleInput = (value) => {
        emit("input", value);
        emit(UPDATE_MODEL_EVENT, value);
        suggestionDisabled.value = false;
        if (!props.triggerOnFocus && !value) {
          suggestionDisabled.value = true;
          suggestions.value = [];
          return;
        }
        debouncedGetData(value);
      };
      const handleChange = (value) => {
        emit("change", value);
      };
      const handleFocus = (evt) => {
        activated.value = true;
        emit("focus", evt);
        if (props.triggerOnFocus) {
          debouncedGetData(String(props.modelValue));
        }
      };
      const handleBlur = (evt) => {
        emit("blur", evt);
      };
      const handleClear = () => {
        activated.value = false;
        emit(UPDATE_MODEL_EVENT, "");
        emit("clear");
      };
      const handleKeyEnter = () => {
        if (suggestionVisible.value && highlightedIndex.value >= 0 && highlightedIndex.value < suggestions.value.length) {
          handleSelect(suggestions.value[highlightedIndex.value]);
        } else if (props.selectWhenUnmatched) {
          emit("select", { value: props.modelValue });
          vue.nextTick(() => {
            suggestions.value = [];
            highlightedIndex.value = -1;
          });
        }
      };
      const close = () => {
        activated.value = false;
      };
      const focus = () => {
        var _a;
        (_a = inputRef.value) == null ? void 0 : _a.focus();
      };
      const handleSelect = (item) => {
        emit("input", item[props.valueKey]);
        emit(UPDATE_MODEL_EVENT, item[props.valueKey]);
        emit("select", item);
        vue.nextTick(() => {
          suggestions.value = [];
          highlightedIndex.value = -1;
        });
      };
      const highlight = (index) => {
        if (!suggestionVisible.value || loading$1.value) {
          return;
        }
        if (index < 0) {
          highlightedIndex.value = -1;
          return;
        }
        if (index >= suggestions.value.length) {
          index = suggestions.value.length - 1;
        }
        const suggestion = regionRef.value.querySelector(`.${ns.be("suggestion", "wrap")}`);
        const suggestionList = suggestion.querySelectorAll(`.${ns.be("suggestion", "list")} li`);
        const highlightItem = suggestionList[index];
        const scrollTop = suggestion.scrollTop;
        const { offsetTop, scrollHeight } = highlightItem;
        if (offsetTop + scrollHeight > scrollTop + suggestion.clientHeight) {
          suggestion.scrollTop += scrollHeight;
        }
        if (offsetTop < scrollTop) {
          suggestion.scrollTop -= scrollHeight;
        }
        highlightedIndex.value = index;
        inputRef.value.inputOrTextarea.setAttribute("aria-activedescendant", `${id.value}-item-${highlightedIndex.value}`);
      };
      onClickOutside(listboxRef, close);
      vue.onMounted(() => {
        inputRef.value.inputOrTextarea.setAttribute("role", "textbox");
        inputRef.value.inputOrTextarea.setAttribute("aria-autocomplete", "list");
        inputRef.value.inputOrTextarea.setAttribute("aria-controls", "id");
        inputRef.value.inputOrTextarea.setAttribute("aria-activedescendant", `${id.value}-item-${highlightedIndex.value}`);
      });
      expose({
        highlightedIndex,
        activated,
        loading: loading$1,
        inputRef,
        popperRef,
        suggestions,
        handleSelect,
        handleKeyEnter,
        focus,
        close,
        highlight
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createBlock(vue.unref(ElTooltip), {
          ref_key: "popperRef",
          ref: popperRef,
          visible: vue.unref(suggestionVisible),
          "onUpdate:visible": _cache[2] || (_cache[2] = ($event) => vue.isRef(suggestionVisible) ? suggestionVisible.value = $event : null),
          placement: _ctx.placement,
          "fallback-placements": ["bottom-start", "top-start"],
          "popper-class": [vue.unref(ns).e("popper"), _ctx.popperClass],
          teleported: vue.unref(compatTeleported),
          "gpu-acceleration": false,
          pure: "",
          "manual-mode": "",
          effect: "light",
          trigger: "click",
          transition: `${vue.unref(ns).namespace.value}-zoom-in-top`,
          persistent: "",
          onBeforeShow: onSuggestionShow
        }, {
          content: vue.withCtx(() => [
            vue.createElementVNode("div", {
              ref_key: "regionRef",
              ref: regionRef,
              class: vue.normalizeClass([vue.unref(ns).b("suggestion"), vue.unref(ns).is("loading", vue.unref(suggestionLoading))]),
              style: vue.normalizeStyle({ minWidth: dropdownWidth.value, outline: "none" }),
              role: "region"
            }, [
              vue.createVNode(vue.unref(ElScrollbar), {
                id: vue.unref(id),
                tag: "ul",
                "wrap-class": vue.unref(ns).be("suggestion", "wrap"),
                "view-class": vue.unref(ns).be("suggestion", "list"),
                role: "listbox"
              }, {
                default: vue.withCtx(() => [
                  vue.unref(suggestionLoading) ? (vue.openBlock(), vue.createElementBlock("li", _hoisted_2$G, [
                    vue.createVNode(vue.unref(ElIcon), {
                      class: vue.normalizeClass(vue.unref(ns).is("loading"))
                    }, {
                      default: vue.withCtx(() => [
                        vue.createVNode(vue.unref(loading))
                      ]),
                      _: 1
                    }, 8, ["class"])
                  ])) : (vue.openBlock(true), vue.createElementBlock(vue.Fragment, { key: 1 }, vue.renderList(suggestions.value, (item, index) => {
                    return vue.openBlock(), vue.createElementBlock("li", {
                      id: `${vue.unref(id)}-item-${index}`,
                      key: index,
                      class: vue.normalizeClass({ highlighted: highlightedIndex.value === index }),
                      role: "option",
                      "aria-selected": highlightedIndex.value === index,
                      onClick: ($event) => handleSelect(item)
                    }, [
                      vue.renderSlot(_ctx.$slots, "default", { item }, () => [
                        vue.createTextVNode(vue.toDisplayString(item[_ctx.valueKey]), 1)
                      ])
                    ], 10, _hoisted_3$p);
                  }), 128))
                ]),
                _: 3
              }, 8, ["id", "wrap-class", "view-class"])
            ], 6)
          ]),
          default: vue.withCtx(() => [
            vue.createElementVNode("div", {
              ref_key: "listboxRef",
              ref: listboxRef,
              class: vue.normalizeClass([vue.unref(ns).b(), _ctx.$attrs.class]),
              style: vue.normalizeStyle(vue.unref(styles)),
              role: "combobox",
              "aria-haspopup": "listbox",
              "aria-expanded": vue.unref(suggestionVisible),
              "aria-owns": vue.unref(id)
            }, [
              vue.createVNode(vue.unref(ElInput), vue.mergeProps({
                ref_key: "inputRef",
                ref: inputRef
              }, vue.unref(attrs), {
                "model-value": _ctx.modelValue,
                onInput: handleInput,
                onChange: handleChange,
                onFocus: handleFocus,
                onBlur: handleBlur,
                onClear: handleClear,
                onKeydown: [
                  _cache[0] || (_cache[0] = vue.withKeys(vue.withModifiers(($event) => highlight(highlightedIndex.value - 1), ["prevent"]), ["up"])),
                  _cache[1] || (_cache[1] = vue.withKeys(vue.withModifiers(($event) => highlight(highlightedIndex.value + 1), ["prevent"]), ["down"])),
                  vue.withKeys(handleKeyEnter, ["enter"]),
                  vue.withKeys(close, ["tab"])
                ]
              }), vue.createSlots({ _: 2 }, [
                _ctx.$slots.prepend ? {
                  name: "prepend",
                  fn: vue.withCtx(() => [
                    vue.renderSlot(_ctx.$slots, "prepend")
                  ])
                } : void 0,
                _ctx.$slots.append ? {
                  name: "append",
                  fn: vue.withCtx(() => [
                    vue.renderSlot(_ctx.$slots, "append")
                  ])
                } : void 0,
                _ctx.$slots.prefix ? {
                  name: "prefix",
                  fn: vue.withCtx(() => [
                    vue.renderSlot(_ctx.$slots, "prefix")
                  ])
                } : void 0,
                _ctx.$slots.suffix ? {
                  name: "suffix",
                  fn: vue.withCtx(() => [
                    vue.renderSlot(_ctx.$slots, "suffix")
                  ])
                } : void 0
              ]), 1040, ["model-value", "onKeydown"])
            ], 14, _hoisted_1$_)
          ]),
          _: 3
        }, 8, ["visible", "placement", "popper-class", "teleported", "transition"]);
      };
    }
  });
  var Autocomplete = _sfc_main$1Y;

  const ElAutocomplete = withInstall(Autocomplete);

  const avatarProps = buildProps({
    size: {
      type: [Number, String],
      values: ["large", "default", "small"],
      default: "default",
      validator: (val) => typeof val === "number"
    },
    shape: {
      type: String,
      values: ["circle", "square"],
      default: "circle"
    },
    icon: {
      type: iconPropType
    },
    src: {
      type: String,
      default: ""
    },
    alt: String,
    srcSet: String,
    fit: {
      type: definePropType(String),
      default: "cover"
    }
  });
  const avatarEmits = {
    error: (evt) => evt instanceof Event
  };

  const _hoisted_1$Z = ["src", "alt", "srcset"];
  const __default__$l = {
    name: "ElAvatar"
  };
  const _sfc_main$1X = /* @__PURE__ */ vue.defineComponent({
    ...__default__$l,
    props: avatarProps,
    emits: avatarEmits,
    setup(__props, { emit }) {
      const props = __props;
      const ns = useNamespace("avatar");
      const hasLoadError = vue.ref(false);
      const avatarClass = vue.computed(() => {
        const { size, icon, shape } = props;
        const classList = [ns.b()];
        if (isString(size))
          classList.push(ns.m(size));
        if (icon)
          classList.push(ns.m("icon"));
        if (shape)
          classList.push(ns.m(shape));
        return classList;
      });
      const sizeStyle = vue.computed(() => {
        const { size } = props;
        return isNumber(size) ? {
          "--el-avatar-size": addUnit(size)
        } : void 0;
      });
      const fitStyle = vue.computed(() => ({
        objectFit: props.fit
      }));
      vue.watch(() => props.src, () => hasLoadError.value = false);
      function handleError(e) {
        hasLoadError.value = true;
        emit("error", e);
      }
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("span", {
          class: vue.normalizeClass(vue.unref(avatarClass)),
          style: vue.normalizeStyle(vue.unref(sizeStyle))
        }, [
          (_ctx.src || _ctx.srcSet) && !hasLoadError.value ? (vue.openBlock(), vue.createElementBlock("img", {
            key: 0,
            src: _ctx.src,
            alt: _ctx.alt,
            srcset: _ctx.srcSet,
            style: vue.normalizeStyle(vue.unref(fitStyle)),
            onError: handleError
          }, null, 44, _hoisted_1$Z)) : _ctx.icon ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), { key: 1 }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.icon)))
            ]),
            _: 1
          })) : vue.renderSlot(_ctx.$slots, "default", { key: 2 })
        ], 6);
      };
    }
  });
  var Avatar = _sfc_main$1X;

  const ElAvatar = withInstall(Avatar);

  const backtopProps = {
    visibilityHeight: {
      type: Number,
      default: 200
    },
    target: {
      type: String,
      default: ""
    },
    right: {
      type: Number,
      default: 40
    },
    bottom: {
      type: Number,
      default: 40
    }
  };
  const backtopEmits = {
    click: (evt) => evt instanceof MouseEvent
  };

  const _hoisted_1$Y = ["onClick"];
  const __default__$k = {
    name: "ElBacktop"
  };
  const _sfc_main$1W = /* @__PURE__ */ vue.defineComponent({
    ...__default__$k,
    props: backtopProps,
    emits: backtopEmits,
    setup(__props, { emit }) {
      const props = __props;
      const COMPONENT_NAME = "ElBacktop";
      const ns = useNamespace("backtop");
      const el = vue.shallowRef(document.documentElement);
      const container = vue.shallowRef(document);
      const visible = vue.ref(false);
      const styleBottom = vue.computed(() => `${props.bottom}px`);
      const styleRight = vue.computed(() => `${props.right}px`);
      const scrollToTop = () => {
        if (!el.value)
          return;
        const beginTime = Date.now();
        const beginValue = el.value.scrollTop;
        const frameFunc = () => {
          if (!el.value)
            return;
          const progress = (Date.now() - beginTime) / 500;
          if (progress < 1) {
            el.value.scrollTop = beginValue * (1 - easeInOutCubic(progress));
            requestAnimationFrame(frameFunc);
          } else {
            el.value.scrollTop = 0;
          }
        };
        requestAnimationFrame(frameFunc);
      };
      const handleScroll = () => {
        if (el.value)
          visible.value = el.value.scrollTop >= props.visibilityHeight;
      };
      const handleClick = (event) => {
        scrollToTop();
        emit("click", event);
      };
      const handleScrollThrottled = useThrottleFn(handleScroll, 300);
      vue.onMounted(() => {
        var _a;
        if (props.target) {
          el.value = (_a = document.querySelector(props.target)) != null ? _a : void 0;
          if (!el.value) {
            throwError(COMPONENT_NAME, `target is not existed: ${props.target}`);
          }
          container.value = el.value;
        }
        useEventListener(container, "scroll", handleScrollThrottled);
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createBlock(vue.Transition, {
          name: `${vue.unref(ns).namespace.value}-fade-in`
        }, {
          default: vue.withCtx(() => [
            visible.value ? (vue.openBlock(), vue.createElementBlock("div", {
              key: 0,
              style: vue.normalizeStyle({
                right: vue.unref(styleRight),
                bottom: vue.unref(styleBottom)
              }),
              class: vue.normalizeClass(vue.unref(ns).b()),
              onClick: vue.withModifiers(handleClick, ["stop"])
            }, [
              vue.renderSlot(_ctx.$slots, "default", {}, () => [
                vue.createVNode(vue.unref(ElIcon), {
                  class: vue.normalizeClass(vue.unref(ns).e("icon"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(vue.unref(caretTop))
                  ]),
                  _: 1
                }, 8, ["class"])
              ])
            ], 14, _hoisted_1$Y)) : vue.createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 8, ["name"]);
      };
    }
  });
  var Backtop = _sfc_main$1W;

  const ElBacktop = withInstall(Backtop);

  const badgeProps = buildProps({
    value: {
      type: [String, Number],
      default: ""
    },
    max: {
      type: Number,
      default: 99
    },
    isDot: Boolean,
    hidden: Boolean,
    type: {
      type: String,
      values: ["primary", "success", "warning", "info", "danger"],
      default: "danger"
    }
  });

  const _hoisted_1$X = ["textContent"];
  const __default__$j = {
    name: "ElBadge"
  };
  const _sfc_main$1V = /* @__PURE__ */ vue.defineComponent({
    ...__default__$j,
    props: badgeProps,
    setup(__props, { expose }) {
      const props = __props;
      const ns = useNamespace("badge");
      const content = vue.computed(() => {
        if (props.isDot)
          return "";
        if (isNumber(props.value) && isNumber(props.max)) {
          return props.max < props.value ? `${props.max}+` : `${props.value}`;
        }
        return `${props.value}`;
      });
      expose({
        content
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass(vue.unref(ns).b())
        }, [
          vue.renderSlot(_ctx.$slots, "default"),
          vue.createVNode(vue.Transition, {
            name: `${vue.unref(ns).namespace.value}-zoom-in-center`
          }, {
            default: vue.withCtx(() => [
              vue.withDirectives(vue.createElementVNode("sup", {
                class: vue.normalizeClass([
                  vue.unref(ns).e("content"),
                  vue.unref(ns).em("content", _ctx.type),
                  vue.unref(ns).is("fixed", !!_ctx.$slots.default),
                  vue.unref(ns).is("dot", _ctx.isDot)
                ]),
                textContent: vue.toDisplayString(vue.unref(content))
              }, null, 10, _hoisted_1$X), [
                [vue.vShow, !_ctx.hidden && (vue.unref(content) || vue.unref(content) === "0" || _ctx.isDot)]
              ])
            ]),
            _: 1
          }, 8, ["name"])
        ], 2);
      };
    }
  });
  var Badge = _sfc_main$1V;

  const ElBadge = withInstall(Badge);

  const breadcrumbProps = buildProps({
    separator: {
      type: String,
      default: "/"
    },
    separatorIcon: {
      type: iconPropType,
      default: ""
    }
  });

  const __default__$i = {
    name: "ElBreadcrumb"
  };
  const _sfc_main$1U = /* @__PURE__ */ vue.defineComponent({
    ...__default__$i,
    props: breadcrumbProps,
    setup(__props) {
      const props = __props;
      const ns = useNamespace("breadcrumb");
      const breadcrumb = vue.ref();
      vue.provide(breadcrumbKey, props);
      vue.onMounted(() => {
        const items = breadcrumb.value.querySelectorAll(`.${ns.e("item")}`);
        if (items.length) {
          items[items.length - 1].setAttribute("aria-current", "page");
        }
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          ref_key: "breadcrumb",
          ref: breadcrumb,
          class: vue.normalizeClass(vue.unref(ns).b()),
          "aria-label": "Breadcrumb",
          role: "navigation"
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2);
      };
    }
  });
  var Breadcrumb = _sfc_main$1U;

  const breadcrumbItemProps = buildProps({
    to: {
      type: definePropType([String, Object]),
      default: ""
    },
    replace: {
      type: Boolean,
      default: false
    }
  });

  const __default__$h = {
    name: "ElBreadcrumbItem"
  };
  const _sfc_main$1T = /* @__PURE__ */ vue.defineComponent({
    ...__default__$h,
    props: breadcrumbItemProps,
    setup(__props) {
      const props = __props;
      const instance = vue.getCurrentInstance();
      const router = instance.appContext.config.globalProperties.$router;
      const parent = vue.inject(breadcrumbKey, void 0);
      const ns = useNamespace("breadcrumb");
      const { separator, separatorIcon } = parent != null ? parent : {};
      const link = vue.ref();
      vue.onMounted(() => {
        link.value.setAttribute("role", "link");
        link.value.addEventListener("click", () => {
          if (!props.to || !router)
            return;
          props.replace ? router.replace(props.to) : router.push(props.to);
        });
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("span", {
          class: vue.normalizeClass(vue.unref(ns).e("item"))
        }, [
          vue.createElementVNode("span", {
            ref_key: "link",
            ref: link,
            class: vue.normalizeClass([vue.unref(ns).e("inner"), vue.unref(ns).is("link", !!_ctx.to)]),
            role: "link"
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 2),
          vue.unref(separatorIcon) ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), {
            key: 0,
            class: vue.normalizeClass(vue.unref(ns).e("separator"))
          }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(vue.unref(separatorIcon))))
            ]),
            _: 1
          }, 8, ["class"])) : (vue.openBlock(), vue.createElementBlock("span", {
            key: 1,
            class: vue.normalizeClass(vue.unref(ns).e("separator")),
            role: "presentation"
          }, vue.toDisplayString(vue.unref(separator)), 3))
        ], 2);
      };
    }
  });
  var BreadcrumbItem = _sfc_main$1T;

  const ElBreadcrumb = withInstall(Breadcrumb, {
    BreadcrumbItem
  });
  const ElBreadcrumbItem = withNoopInstall(BreadcrumbItem);

  function bound01$1(n, max) {
    if (isOnePointZero$1(n)) {
      n = "100%";
    }
    var isPercent = isPercentage$1(n);
    n = max === 360 ? n : Math.min(max, Math.max(0, parseFloat(n)));
    if (isPercent) {
      n = parseInt(String(n * max), 10) / 100;
    }
    if (Math.abs(n - max) < 1e-6) {
      return 1;
    }
    if (max === 360) {
      n = (n < 0 ? n % max + max : n % max) / parseFloat(String(max));
    } else {
      n = n % max / parseFloat(String(max));
    }
    return n;
  }
  function clamp01(val) {
    return Math.min(1, Math.max(0, val));
  }
  function isOnePointZero$1(n) {
    return typeof n === "string" && n.indexOf(".") !== -1 && parseFloat(n) === 1;
  }
  function isPercentage$1(n) {
    return typeof n === "string" && n.indexOf("%") !== -1;
  }
  function boundAlpha(a) {
    a = parseFloat(a);
    if (isNaN(a) || a < 0 || a > 1) {
      a = 1;
    }
    return a;
  }
  function convertToPercentage(n) {
    if (n <= 1) {
      return Number(n) * 100 + "%";
    }
    return n;
  }
  function pad2(c) {
    return c.length === 1 ? "0" + c : String(c);
  }

  function rgbToRgb(r, g, b) {
    return {
      r: bound01$1(r, 255) * 255,
      g: bound01$1(g, 255) * 255,
      b: bound01$1(b, 255) * 255
    };
  }
  function rgbToHsl(r, g, b) {
    r = bound01$1(r, 255);
    g = bound01$1(g, 255);
    b = bound01$1(b, 255);
    var max = Math.max(r, g, b);
    var min = Math.min(r, g, b);
    var h = 0;
    var s = 0;
    var l = (max + min) / 2;
    if (max === min) {
      s = 0;
      h = 0;
    } else {
      var d = max - min;
      s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
      switch (max) {
        case r:
          h = (g - b) / d + (g < b ? 6 : 0);
          break;
        case g:
          h = (b - r) / d + 2;
          break;
        case b:
          h = (r - g) / d + 4;
          break;
      }
      h /= 6;
    }
    return { h, s, l };
  }
  function hue2rgb(p, q, t) {
    if (t < 0) {
      t += 1;
    }
    if (t > 1) {
      t -= 1;
    }
    if (t < 1 / 6) {
      return p + (q - p) * (6 * t);
    }
    if (t < 1 / 2) {
      return q;
    }
    if (t < 2 / 3) {
      return p + (q - p) * (2 / 3 - t) * 6;
    }
    return p;
  }
  function hslToRgb(h, s, l) {
    var r;
    var g;
    var b;
    h = bound01$1(h, 360);
    s = bound01$1(s, 100);
    l = bound01$1(l, 100);
    if (s === 0) {
      g = l;
      b = l;
      r = l;
    } else {
      var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      var p = 2 * l - q;
      r = hue2rgb(p, q, h + 1 / 3);
      g = hue2rgb(p, q, h);
      b = hue2rgb(p, q, h - 1 / 3);
    }
    return { r: r * 255, g: g * 255, b: b * 255 };
  }
  function rgbToHsv(r, g, b) {
    r = bound01$1(r, 255);
    g = bound01$1(g, 255);
    b = bound01$1(b, 255);
    var max = Math.max(r, g, b);
    var min = Math.min(r, g, b);
    var h = 0;
    var v = max;
    var d = max - min;
    var s = max === 0 ? 0 : d / max;
    if (max === min) {
      h = 0;
    } else {
      switch (max) {
        case r:
          h = (g - b) / d + (g < b ? 6 : 0);
          break;
        case g:
          h = (b - r) / d + 2;
          break;
        case b:
          h = (r - g) / d + 4;
          break;
      }
      h /= 6;
    }
    return { h, s, v };
  }
  function hsvToRgb(h, s, v) {
    h = bound01$1(h, 360) * 6;
    s = bound01$1(s, 100);
    v = bound01$1(v, 100);
    var i = Math.floor(h);
    var f = h - i;
    var p = v * (1 - s);
    var q = v * (1 - f * s);
    var t = v * (1 - (1 - f) * s);
    var mod = i % 6;
    var r = [v, q, p, p, t, v][mod];
    var g = [t, v, v, q, p, p][mod];
    var b = [p, p, t, v, v, q][mod];
    return { r: r * 255, g: g * 255, b: b * 255 };
  }
  function rgbToHex(r, g, b, allow3Char) {
    var hex = [
      pad2(Math.round(r).toString(16)),
      pad2(Math.round(g).toString(16)),
      pad2(Math.round(b).toString(16))
    ];
    if (allow3Char && hex[0].startsWith(hex[0].charAt(1)) && hex[1].startsWith(hex[1].charAt(1)) && hex[2].startsWith(hex[2].charAt(1))) {
      return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
    }
    return hex.join("");
  }
  function rgbaToHex(r, g, b, a, allow4Char) {
    var hex = [
      pad2(Math.round(r).toString(16)),
      pad2(Math.round(g).toString(16)),
      pad2(Math.round(b).toString(16)),
      pad2(convertDecimalToHex(a))
    ];
    if (allow4Char && hex[0].startsWith(hex[0].charAt(1)) && hex[1].startsWith(hex[1].charAt(1)) && hex[2].startsWith(hex[2].charAt(1)) && hex[3].startsWith(hex[3].charAt(1))) {
      return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
    }
    return hex.join("");
  }
  function convertDecimalToHex(d) {
    return Math.round(parseFloat(d) * 255).toString(16);
  }
  function convertHexToDecimal(h) {
    return parseIntFromHex(h) / 255;
  }
  function parseIntFromHex(val) {
    return parseInt(val, 16);
  }
  function numberInputToObject(color) {
    return {
      r: color >> 16,
      g: (color & 65280) >> 8,
      b: color & 255
    };
  }

  var names = {
    aliceblue: "#f0f8ff",
    antiquewhite: "#faebd7",
    aqua: "#00ffff",
    aquamarine: "#7fffd4",
    azure: "#f0ffff",
    beige: "#f5f5dc",
    bisque: "#ffe4c4",
    black: "#000000",
    blanchedalmond: "#ffebcd",
    blue: "#0000ff",
    blueviolet: "#8a2be2",
    brown: "#a52a2a",
    burlywood: "#deb887",
    cadetblue: "#5f9ea0",
    chartreuse: "#7fff00",
    chocolate: "#d2691e",
    coral: "#ff7f50",
    cornflowerblue: "#6495ed",
    cornsilk: "#fff8dc",
    crimson: "#dc143c",
    cyan: "#00ffff",
    darkblue: "#00008b",
    darkcyan: "#008b8b",
    darkgoldenrod: "#b8860b",
    darkgray: "#a9a9a9",
    darkgreen: "#006400",
    darkgrey: "#a9a9a9",
    darkkhaki: "#bdb76b",
    darkmagenta: "#8b008b",
    darkolivegreen: "#556b2f",
    darkorange: "#ff8c00",
    darkorchid: "#9932cc",
    darkred: "#8b0000",
    darksalmon: "#e9967a",
    darkseagreen: "#8fbc8f",
    darkslateblue: "#483d8b",
    darkslategray: "#2f4f4f",
    darkslategrey: "#2f4f4f",
    darkturquoise: "#00ced1",
    darkviolet: "#9400d3",
    deeppink: "#ff1493",
    deepskyblue: "#00bfff",
    dimgray: "#696969",
    dimgrey: "#696969",
    dodgerblue: "#1e90ff",
    firebrick: "#b22222",
    floralwhite: "#fffaf0",
    forestgreen: "#228b22",
    fuchsia: "#ff00ff",
    gainsboro: "#dcdcdc",
    ghostwhite: "#f8f8ff",
    goldenrod: "#daa520",
    gold: "#ffd700",
    gray: "#808080",
    green: "#008000",
    greenyellow: "#adff2f",
    grey: "#808080",
    honeydew: "#f0fff0",
    hotpink: "#ff69b4",
    indianred: "#cd5c5c",
    indigo: "#4b0082",
    ivory: "#fffff0",
    khaki: "#f0e68c",
    lavenderblush: "#fff0f5",
    lavender: "#e6e6fa",
    lawngreen: "#7cfc00",
    lemonchiffon: "#fffacd",
    lightblue: "#add8e6",
    lightcoral: "#f08080",
    lightcyan: "#e0ffff",
    lightgoldenrodyellow: "#fafad2",
    lightgray: "#d3d3d3",
    lightgreen: "#90ee90",
    lightgrey: "#d3d3d3",
    lightpink: "#ffb6c1",
    lightsalmon: "#ffa07a",
    lightseagreen: "#20b2aa",
    lightskyblue: "#87cefa",
    lightslategray: "#778899",
    lightslategrey: "#778899",
    lightsteelblue: "#b0c4de",
    lightyellow: "#ffffe0",
    lime: "#00ff00",
    limegreen: "#32cd32",
    linen: "#faf0e6",
    magenta: "#ff00ff",
    maroon: "#800000",
    mediumaquamarine: "#66cdaa",
    mediumblue: "#0000cd",
    mediumorchid: "#ba55d3",
    mediumpurple: "#9370db",
    mediumseagreen: "#3cb371",
    mediumslateblue: "#7b68ee",
    mediumspringgreen: "#00fa9a",
    mediumturquoise: "#48d1cc",
    mediumvioletred: "#c71585",
    midnightblue: "#191970",
    mintcream: "#f5fffa",
    mistyrose: "#ffe4e1",
    moccasin: "#ffe4b5",
    navajowhite: "#ffdead",
    navy: "#000080",
    oldlace: "#fdf5e6",
    olive: "#808000",
    olivedrab: "#6b8e23",
    orange: "#ffa500",
    orangered: "#ff4500",
    orchid: "#da70d6",
    palegoldenrod: "#eee8aa",
    palegreen: "#98fb98",
    paleturquoise: "#afeeee",
    palevioletred: "#db7093",
    papayawhip: "#ffefd5",
    peachpuff: "#ffdab9",
    peru: "#cd853f",
    pink: "#ffc0cb",
    plum: "#dda0dd",
    powderblue: "#b0e0e6",
    purple: "#800080",
    rebeccapurple: "#663399",
    red: "#ff0000",
    rosybrown: "#bc8f8f",
    royalblue: "#4169e1",
    saddlebrown: "#8b4513",
    salmon: "#fa8072",
    sandybrown: "#f4a460",
    seagreen: "#2e8b57",
    seashell: "#fff5ee",
    sienna: "#a0522d",
    silver: "#c0c0c0",
    skyblue: "#87ceeb",
    slateblue: "#6a5acd",
    slategray: "#708090",
    slategrey: "#708090",
    snow: "#fffafa",
    springgreen: "#00ff7f",
    steelblue: "#4682b4",
    tan: "#d2b48c",
    teal: "#008080",
    thistle: "#d8bfd8",
    tomato: "#ff6347",
    turquoise: "#40e0d0",
    violet: "#ee82ee",
    wheat: "#f5deb3",
    white: "#ffffff",
    whitesmoke: "#f5f5f5",
    yellow: "#ffff00",
    yellowgreen: "#9acd32"
  };

  function inputToRGB(color) {
    var rgb = { r: 0, g: 0, b: 0 };
    var a = 1;
    var s = null;
    var v = null;
    var l = null;
    var ok = false;
    var format = false;
    if (typeof color === "string") {
      color = stringInputToObject(color);
    }
    if (typeof color === "object") {
      if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
        rgb = rgbToRgb(color.r, color.g, color.b);
        ok = true;
        format = String(color.r).substr(-1) === "%" ? "prgb" : "rgb";
      } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
        s = convertToPercentage(color.s);
        v = convertToPercentage(color.v);
        rgb = hsvToRgb(color.h, s, v);
        ok = true;
        format = "hsv";
      } else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
        s = convertToPercentage(color.s);
        l = convertToPercentage(color.l);
        rgb = hslToRgb(color.h, s, l);
        ok = true;
        format = "hsl";
      }
      if (Object.prototype.hasOwnProperty.call(color, "a")) {
        a = color.a;
      }
    }
    a = boundAlpha(a);
    return {
      ok,
      format: color.format || format,
      r: Math.min(255, Math.max(rgb.r, 0)),
      g: Math.min(255, Math.max(rgb.g, 0)),
      b: Math.min(255, Math.max(rgb.b, 0)),
      a
    };
  }
  var CSS_INTEGER = "[-\\+]?\\d+%?";
  var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";
  var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";
  var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
  var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
  var matchers = {
    CSS_UNIT: new RegExp(CSS_UNIT),
    rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
    rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
    hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
    hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
    hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
    hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
    hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
    hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
    hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
    hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
  };
  function stringInputToObject(color) {
    color = color.trim().toLowerCase();
    if (color.length === 0) {
      return false;
    }
    var named = false;
    if (names[color]) {
      color = names[color];
      named = true;
    } else if (color === "transparent") {
      return { r: 0, g: 0, b: 0, a: 0, format: "name" };
    }
    var match = matchers.rgb.exec(color);
    if (match) {
      return { r: match[1], g: match[2], b: match[3] };
    }
    match = matchers.rgba.exec(color);
    if (match) {
      return { r: match[1], g: match[2], b: match[3], a: match[4] };
    }
    match = matchers.hsl.exec(color);
    if (match) {
      return { h: match[1], s: match[2], l: match[3] };
    }
    match = matchers.hsla.exec(color);
    if (match) {
      return { h: match[1], s: match[2], l: match[3], a: match[4] };
    }
    match = matchers.hsv.exec(color);
    if (match) {
      return { h: match[1], s: match[2], v: match[3] };
    }
    match = matchers.hsva.exec(color);
    if (match) {
      return { h: match[1], s: match[2], v: match[3], a: match[4] };
    }
    match = matchers.hex8.exec(color);
    if (match) {
      return {
        r: parseIntFromHex(match[1]),
        g: parseIntFromHex(match[2]),
        b: parseIntFromHex(match[3]),
        a: convertHexToDecimal(match[4]),
        format: named ? "name" : "hex8"
      };
    }
    match = matchers.hex6.exec(color);
    if (match) {
      return {
        r: parseIntFromHex(match[1]),
        g: parseIntFromHex(match[2]),
        b: parseIntFromHex(match[3]),
        format: named ? "name" : "hex"
      };
    }
    match = matchers.hex4.exec(color);
    if (match) {
      return {
        r: parseIntFromHex(match[1] + match[1]),
        g: parseIntFromHex(match[2] + match[2]),
        b: parseIntFromHex(match[3] + match[3]),
        a: convertHexToDecimal(match[4] + match[4]),
        format: named ? "name" : "hex8"
      };
    }
    match = matchers.hex3.exec(color);
    if (match) {
      return {
        r: parseIntFromHex(match[1] + match[1]),
        g: parseIntFromHex(match[2] + match[2]),
        b: parseIntFromHex(match[3] + match[3]),
        format: named ? "name" : "hex"
      };
    }
    return false;
  }
  function isValidCSSUnit(color) {
    return Boolean(matchers.CSS_UNIT.exec(String(color)));
  }

  var TinyColor = function() {
    function TinyColor2(color, opts) {
      if (color === void 0) {
        color = "";
      }
      if (opts === void 0) {
        opts = {};
      }
      var _a;
      if (color instanceof TinyColor2) {
        return color;
      }
      if (typeof color === "number") {
        color = numberInputToObject(color);
      }
      this.originalInput = color;
      var rgb = inputToRGB(color);
      this.originalInput = color;
      this.r = rgb.r;
      this.g = rgb.g;
      this.b = rgb.b;
      this.a = rgb.a;
      this.roundA = Math.round(100 * this.a) / 100;
      this.format = (_a = opts.format) !== null && _a !== void 0 ? _a : rgb.format;
      this.gradientType = opts.gradientType;
      if (this.r < 1) {
        this.r = Math.round(this.r);
      }
      if (this.g < 1) {
        this.g = Math.round(this.g);
      }
      if (this.b < 1) {
        this.b = Math.round(this.b);
      }
      this.isValid = rgb.ok;
    }
    TinyColor2.prototype.isDark = function() {
      return this.getBrightness() < 128;
    };
    TinyColor2.prototype.isLight = function() {
      return !this.isDark();
    };
    TinyColor2.prototype.getBrightness = function() {
      var rgb = this.toRgb();
      return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1e3;
    };
    TinyColor2.prototype.getLuminance = function() {
      var rgb = this.toRgb();
      var R;
      var G;
      var B;
      var RsRGB = rgb.r / 255;
      var GsRGB = rgb.g / 255;
      var BsRGB = rgb.b / 255;
      if (RsRGB <= 0.03928) {
        R = RsRGB / 12.92;
      } else {
        R = Math.pow((RsRGB + 0.055) / 1.055, 2.4);
      }
      if (GsRGB <= 0.03928) {
        G = GsRGB / 12.92;
      } else {
        G = Math.pow((GsRGB + 0.055) / 1.055, 2.4);
      }
      if (BsRGB <= 0.03928) {
        B = BsRGB / 12.92;
      } else {
        B = Math.pow((BsRGB + 0.055) / 1.055, 2.4);
      }
      return 0.2126 * R + 0.7152 * G + 0.0722 * B;
    };
    TinyColor2.prototype.getAlpha = function() {
      return this.a;
    };
    TinyColor2.prototype.setAlpha = function(alpha) {
      this.a = boundAlpha(alpha);
      this.roundA = Math.round(100 * this.a) / 100;
      return this;
    };
    TinyColor2.prototype.toHsv = function() {
      var hsv = rgbToHsv(this.r, this.g, this.b);
      return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this.a };
    };
    TinyColor2.prototype.toHsvString = function() {
      var hsv = rgbToHsv(this.r, this.g, this.b);
      var h = Math.round(hsv.h * 360);
      var s = Math.round(hsv.s * 100);
      var v = Math.round(hsv.v * 100);
      return this.a === 1 ? "hsv(" + h + ", " + s + "%, " + v + "%)" : "hsva(" + h + ", " + s + "%, " + v + "%, " + this.roundA + ")";
    };
    TinyColor2.prototype.toHsl = function() {
      var hsl = rgbToHsl(this.r, this.g, this.b);
      return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this.a };
    };
    TinyColor2.prototype.toHslString = function() {
      var hsl = rgbToHsl(this.r, this.g, this.b);
      var h = Math.round(hsl.h * 360);
      var s = Math.round(hsl.s * 100);
      var l = Math.round(hsl.l * 100);
      return this.a === 1 ? "hsl(" + h + ", " + s + "%, " + l + "%)" : "hsla(" + h + ", " + s + "%, " + l + "%, " + this.roundA + ")";
    };
    TinyColor2.prototype.toHex = function(allow3Char) {
      if (allow3Char === void 0) {
        allow3Char = false;
      }
      return rgbToHex(this.r, this.g, this.b, allow3Char);
    };
    TinyColor2.prototype.toHexString = function(allow3Char) {
      if (allow3Char === void 0) {
        allow3Char = false;
      }
      return "#" + this.toHex(allow3Char);
    };
    TinyColor2.prototype.toHex8 = function(allow4Char) {
      if (allow4Char === void 0) {
        allow4Char = false;
      }
      return rgbaToHex(this.r, this.g, this.b, this.a, allow4Char);
    };
    TinyColor2.prototype.toHex8String = function(allow4Char) {
      if (allow4Char === void 0) {
        allow4Char = false;
      }
      return "#" + this.toHex8(allow4Char);
    };
    TinyColor2.prototype.toRgb = function() {
      return {
        r: Math.round(this.r),
        g: Math.round(this.g),
        b: Math.round(this.b),
        a: this.a
      };
    };
    TinyColor2.prototype.toRgbString = function() {
      var r = Math.round(this.r);
      var g = Math.round(this.g);
      var b = Math.round(this.b);
      return this.a === 1 ? "rgb(" + r + ", " + g + ", " + b + ")" : "rgba(" + r + ", " + g + ", " + b + ", " + this.roundA + ")";
    };
    TinyColor2.prototype.toPercentageRgb = function() {
      var fmt = function(x) {
        return Math.round(bound01$1(x, 255) * 100) + "%";
      };
      return {
        r: fmt(this.r),
        g: fmt(this.g),
        b: fmt(this.b),
        a: this.a
      };
    };
    TinyColor2.prototype.toPercentageRgbString = function() {
      var rnd = function(x) {
        return Math.round(bound01$1(x, 255) * 100);
      };
      return this.a === 1 ? "rgb(" + rnd(this.r) + "%, " + rnd(this.g) + "%, " + rnd(this.b) + "%)" : "rgba(" + rnd(this.r) + "%, " + rnd(this.g) + "%, " + rnd(this.b) + "%, " + this.roundA + ")";
    };
    TinyColor2.prototype.toName = function() {
      if (this.a === 0) {
        return "transparent";
      }
      if (this.a < 1) {
        return false;
      }
      var hex = "#" + rgbToHex(this.r, this.g, this.b, false);
      for (var _i = 0, _a = Object.entries(names); _i < _a.length; _i++) {
        var _b = _a[_i], key = _b[0], value = _b[1];
        if (hex === value) {
          return key;
        }
      }
      return false;
    };
    TinyColor2.prototype.toString = function(format) {
      var formatSet = Boolean(format);
      format = format !== null && format !== void 0 ? format : this.format;
      var formattedString = false;
      var hasAlpha = this.a < 1 && this.a >= 0;
      var needsAlphaFormat = !formatSet && hasAlpha && (format.startsWith("hex") || format === "name");
      if (needsAlphaFormat) {
        if (format === "name" && this.a === 0) {
          return this.toName();
        }
        return this.toRgbString();
      }
      if (format === "rgb") {
        formattedString = this.toRgbString();
      }
      if (format === "prgb") {
        formattedString = this.toPercentageRgbString();
      }
      if (format === "hex" || format === "hex6") {
        formattedString = this.toHexString();
      }
      if (format === "hex3") {
        formattedString = this.toHexString(true);
      }
      if (format === "hex4") {
        formattedString = this.toHex8String(true);
      }
      if (format === "hex8") {
        formattedString = this.toHex8String();
      }
      if (format === "name") {
        formattedString = this.toName();
      }
      if (format === "hsl") {
        formattedString = this.toHslString();
      }
      if (format === "hsv") {
        formattedString = this.toHsvString();
      }
      return formattedString || this.toHexString();
    };
    TinyColor2.prototype.toNumber = function() {
      return (Math.round(this.r) << 16) + (Math.round(this.g) << 8) + Math.round(this.b);
    };
    TinyColor2.prototype.clone = function() {
      return new TinyColor2(this.toString());
    };
    TinyColor2.prototype.lighten = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      var hsl = this.toHsl();
      hsl.l += amount / 100;
      hsl.l = clamp01(hsl.l);
      return new TinyColor2(hsl);
    };
    TinyColor2.prototype.brighten = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      var rgb = this.toRgb();
      rgb.r = Math.max(0, Math.min(255, rgb.r - Math.round(255 * -(amount / 100))));
      rgb.g = Math.max(0, Math.min(255, rgb.g - Math.round(255 * -(amount / 100))));
      rgb.b = Math.max(0, Math.min(255, rgb.b - Math.round(255 * -(amount / 100))));
      return new TinyColor2(rgb);
    };
    TinyColor2.prototype.darken = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      var hsl = this.toHsl();
      hsl.l -= amount / 100;
      hsl.l = clamp01(hsl.l);
      return new TinyColor2(hsl);
    };
    TinyColor2.prototype.tint = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      return this.mix("white", amount);
    };
    TinyColor2.prototype.shade = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      return this.mix("black", amount);
    };
    TinyColor2.prototype.desaturate = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      var hsl = this.toHsl();
      hsl.s -= amount / 100;
      hsl.s = clamp01(hsl.s);
      return new TinyColor2(hsl);
    };
    TinyColor2.prototype.saturate = function(amount) {
      if (amount === void 0) {
        amount = 10;
      }
      var hsl = this.toHsl();
      hsl.s += amount / 100;
      hsl.s = clamp01(hsl.s);
      return new TinyColor2(hsl);
    };
    TinyColor2.prototype.greyscale = function() {
      return this.desaturate(100);
    };
    TinyColor2.prototype.spin = function(amount) {
      var hsl = this.toHsl();
      var hue = (hsl.h + amount) % 360;
      hsl.h = hue < 0 ? 360 + hue : hue;
      return new TinyColor2(hsl);
    };
    TinyColor2.prototype.mix = function(color, amount) {
      if (amount === void 0) {
        amount = 50;
      }
      var rgb1 = this.toRgb();
      var rgb2 = new TinyColor2(color).toRgb();
      var p = amount / 100;
      var rgba = {
        r: (rgb2.r - rgb1.r) * p + rgb1.r,
        g: (rgb2.g - rgb1.g) * p + rgb1.g,
        b: (rgb2.b - rgb1.b) * p + rgb1.b,
        a: (rgb2.a - rgb1.a) * p + rgb1.a
      };
      return new TinyColor2(rgba);
    };
    TinyColor2.prototype.analogous = function(results, slices) {
      if (results === void 0) {
        results = 6;
      }
      if (slices === void 0) {
        slices = 30;
      }
      var hsl = this.toHsl();
      var part = 360 / slices;
      var ret = [this];
      for (hsl.h = (hsl.h - (part * results >> 1) + 720) % 360; --results; ) {
        hsl.h = (hsl.h + part) % 360;
        ret.push(new TinyColor2(hsl));
      }
      return ret;
    };
    TinyColor2.prototype.complement = function() {
      var hsl = this.toHsl();
      hsl.h = (hsl.h + 180) % 360;
      return new TinyColor2(hsl);
    };
    TinyColor2.prototype.monochromatic = function(results) {
      if (results === void 0) {
        results = 6;
      }
      var hsv = this.toHsv();
      var h = hsv.h;
      var s = hsv.s;
      var v = hsv.v;
      var res = [];
      var modification = 1 / results;
      while (results--) {
        res.push(new TinyColor2({ h, s, v }));
        v = (v + modification) % 1;
      }
      return res;
    };
    TinyColor2.prototype.splitcomplement = function() {
      var hsl = this.toHsl();
      var h = hsl.h;
      return [
        this,
        new TinyColor2({ h: (h + 72) % 360, s: hsl.s, l: hsl.l }),
        new TinyColor2({ h: (h + 216) % 360, s: hsl.s, l: hsl.l })
      ];
    };
    TinyColor2.prototype.onBackground = function(background) {
      var fg = this.toRgb();
      var bg = new TinyColor2(background).toRgb();
      return new TinyColor2({
        r: bg.r + (fg.r - bg.r) * fg.a,
        g: bg.g + (fg.g - bg.g) * fg.a,
        b: bg.b + (fg.b - bg.b) * fg.a
      });
    };
    TinyColor2.prototype.triad = function() {
      return this.polyad(3);
    };
    TinyColor2.prototype.tetrad = function() {
      return this.polyad(4);
    };
    TinyColor2.prototype.polyad = function(n) {
      var hsl = this.toHsl();
      var h = hsl.h;
      var result = [this];
      var increment = 360 / n;
      for (var i = 1; i < n; i++) {
        result.push(new TinyColor2({ h: (h + i * increment) % 360, s: hsl.s, l: hsl.l }));
      }
      return result;
    };
    TinyColor2.prototype.equals = function(color) {
      return this.toRgbString() === new TinyColor2(color).toRgbString();
    };
    return TinyColor2;
  }();

  const buttonTypes = [
    "default",
    "primary",
    "success",
    "warning",
    "info",
    "danger",
    "text",
    ""
  ];
  const buttonNativeTypes = ["button", "submit", "reset"];
  const buttonProps = buildProps({
    size: useSizeProp,
    disabled: Boolean,
    type: {
      type: String,
      values: buttonTypes,
      default: ""
    },
    icon: {
      type: iconPropType,
      default: ""
    },
    nativeType: {
      type: String,
      values: buttonNativeTypes,
      default: "button"
    },
    loading: Boolean,
    loadingIcon: {
      type: iconPropType,
      default: () => loading
    },
    plain: Boolean,
    autofocus: Boolean,
    round: Boolean,
    circle: Boolean,
    color: String,
    autoInsertSpace: {
      type: Boolean,
      default: void 0
    }
  });
  const buttonEmits = {
    click: (evt) => evt instanceof MouseEvent
  };

  const _hoisted_1$W = ["disabled", "autofocus", "type"];
  const __default__$g = {
    name: "ElButton"
  };
  const _sfc_main$1S = /* @__PURE__ */ vue.defineComponent({
    ...__default__$g,
    props: buttonProps,
    emits: buttonEmits,
    setup(__props, { expose, emit }) {
      const props = __props;
      const slots = vue.useSlots();
      const buttonGroupContext = vue.inject(buttonGroupContextKey, void 0);
      const globalConfig = useGlobalConfig("button");
      const ns = useNamespace("button");
      const { form } = useFormItem();
      const _size = useSize(vue.computed(() => buttonGroupContext == null ? void 0 : buttonGroupContext.size));
      const _disabled = useDisabled$1();
      const _ref = vue.ref();
      const _type = vue.computed(() => props.type || (buttonGroupContext == null ? void 0 : buttonGroupContext.type) || "");
      const autoInsertSpace = vue.computed(() => {
        var _a, _b, _c;
        return (_c = (_b = props.autoInsertSpace) != null ? _b : (_a = globalConfig.value) == null ? void 0 : _a.autoInsertSpace) != null ? _c : false;
      });
      const shouldAddSpace = vue.computed(() => {
        var _a;
        const defaultSlot = (_a = slots.default) == null ? void 0 : _a.call(slots);
        if (autoInsertSpace.value && (defaultSlot == null ? void 0 : defaultSlot.length) === 1) {
          const slot = defaultSlot[0];
          if ((slot == null ? void 0 : slot.type) === vue.Text) {
            const text = slot.children;
            return /^\p{Unified_Ideograph}{2}$/u.test(text.trim());
          }
        }
        return false;
      });
      const buttonStyle = vue.computed(() => {
        let styles = {};
        const buttonColor = props.color;
        if (buttonColor) {
          const color = new TinyColor(buttonColor);
          const shadeBgColor = color.shade(20).toString();
          if (props.plain) {
            styles = {
              "--el-button-bg-color": color.tint(90).toString(),
              "--el-button-text-color": buttonColor,
              "--el-button-hover-text-color": "var(--el-color-white)",
              "--el-button-hover-bg-color": buttonColor,
              "--el-button-hover-border-color": buttonColor,
              "--el-button-active-bg-color": shadeBgColor,
              "--el-button-active-text-color": "var(--el-color-white)",
              "--el-button-active-border-color": shadeBgColor
            };
          } else {
            const tintBgColor = color.tint(30).toString();
            styles = {
              "--el-button-bg-color": buttonColor,
              "--el-button-border-color": buttonColor,
              "--el-button-hover-bg-color": tintBgColor,
              "--el-button-hover-border-color": tintBgColor,
              "--el-button-active-bg-color": shadeBgColor,
              "--el-button-active-border-color": shadeBgColor
            };
          }
          if (_disabled.value) {
            const disabledButtonColor = color.tint(50).toString();
            styles["--el-button-disabled-bg-color"] = disabledButtonColor;
            styles["--el-button-disabled-border-color"] = disabledButtonColor;
          }
        }
        return styles;
      });
      const handleClick = (evt) => {
        if (props.nativeType === "reset") {
          form == null ? void 0 : form.resetFields();
        }
        emit("click", evt);
      };
      expose({
        ref: _ref,
        size: _size,
        type: _type,
        disabled: _disabled,
        shouldAddSpace
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("button", {
          ref_key: "_ref",
          ref: _ref,
          class: vue.normalizeClass([
            vue.unref(ns).b(),
            vue.unref(ns).m(vue.unref(_type)),
            vue.unref(ns).m(vue.unref(_size)),
            vue.unref(ns).is("disabled", vue.unref(_disabled)),
            vue.unref(ns).is("loading", _ctx.loading),
            vue.unref(ns).is("plain", _ctx.plain),
            vue.unref(ns).is("round", _ctx.round),
            vue.unref(ns).is("circle", _ctx.circle)
          ]),
          disabled: vue.unref(_disabled) || _ctx.loading,
          autofocus: _ctx.autofocus,
          type: _ctx.nativeType,
          style: vue.normalizeStyle(vue.unref(buttonStyle)),
          onClick: handleClick
        }, [
          _ctx.loading ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
            _ctx.$slots.loading ? vue.renderSlot(_ctx.$slots, "loading", { key: 0 }) : (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), {
              key: 1,
              class: vue.normalizeClass(vue.unref(ns).is("loading"))
            }, {
              default: vue.withCtx(() => [
                (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.loadingIcon)))
              ]),
              _: 1
            }, 8, ["class"]))
          ], 2112)) : _ctx.icon || _ctx.$slots.icon ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), { key: 1 }, {
            default: vue.withCtx(() => [
              _ctx.icon ? (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.icon), { key: 0 })) : vue.renderSlot(_ctx.$slots, "icon", { key: 1 })
            ]),
            _: 3
          })) : vue.createCommentVNode("v-if", true),
          _ctx.$slots.default ? (vue.openBlock(), vue.createElementBlock("span", {
            key: 2,
            class: vue.normalizeClass({ [vue.unref(ns).em("text", "expand")]: vue.unref(shouldAddSpace) })
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 2)) : vue.createCommentVNode("v-if", true)
        ], 14, _hoisted_1$W);
      };
    }
  });
  var Button = _sfc_main$1S;

  const buttonGroupProps = {
    size: buttonProps.size,
    type: buttonProps.type
  };

  const __default__$f = {
    name: "ElButtonGroup"
  };
  const _sfc_main$1R = /* @__PURE__ */ vue.defineComponent({
    ...__default__$f,
    props: buttonGroupProps,
    setup(__props) {
      const props = __props;
      vue.provide(buttonGroupContextKey, vue.reactive({
        size: vue.toRef(props, "size"),
        type: vue.toRef(props, "type")
      }));
      const ns = useNamespace("button");
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass(`${vue.unref(ns).b("group")}`)
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2);
      };
    }
  });
  var ButtonGroup = _sfc_main$1R;

  const ElButton = withInstall(Button, {
    ButtonGroup
  });
  const ElButtonGroup$1 = withNoopInstall(ButtonGroup);

  var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

  var dayjs_min = {exports: {}};

  (function(module, exports) {
    !function(t, e) {
      module.exports = e() ;
    }(commonjsGlobal, function() {
      var t = 1e3, e = 6e4, n = 36e5, r = "millisecond", i = "second", s = "minute", u = "hour", a = "day", o = "week", f = "month", h = "quarter", c = "year", d = "date", $ = "Invalid Date", l = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/, y = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g, M = { name: "en", weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_") }, m = function(t2, e2, n2) {
        var r2 = String(t2);
        return !r2 || r2.length >= e2 ? t2 : "" + Array(e2 + 1 - r2.length).join(n2) + t2;
      }, g = { s: m, z: function(t2) {
        var e2 = -t2.utcOffset(), n2 = Math.abs(e2), r2 = Math.floor(n2 / 60), i2 = n2 % 60;
        return (e2 <= 0 ? "+" : "-") + m(r2, 2, "0") + ":" + m(i2, 2, "0");
      }, m: function t2(e2, n2) {
        if (e2.date() < n2.date())
          return -t2(n2, e2);
        var r2 = 12 * (n2.year() - e2.year()) + (n2.month() - e2.month()), i2 = e2.clone().add(r2, f), s2 = n2 - i2 < 0, u2 = e2.clone().add(r2 + (s2 ? -1 : 1), f);
        return +(-(r2 + (n2 - i2) / (s2 ? i2 - u2 : u2 - i2)) || 0);
      }, a: function(t2) {
        return t2 < 0 ? Math.ceil(t2) || 0 : Math.floor(t2);
      }, p: function(t2) {
        return { M: f, y: c, w: o, d: a, D: d, h: u, m: s, s: i, ms: r, Q: h }[t2] || String(t2 || "").toLowerCase().replace(/s$/, "");
      }, u: function(t2) {
        return t2 === void 0;
      } }, D = "en", v = {};
      v[D] = M;
      var p = function(t2) {
        return t2 instanceof _;
      }, S = function(t2, e2, n2) {
        var r2;
        if (!t2)
          return D;
        if (typeof t2 == "string")
          v[t2] && (r2 = t2), e2 && (v[t2] = e2, r2 = t2);
        else {
          var i2 = t2.name;
          v[i2] = t2, r2 = i2;
        }
        return !n2 && r2 && (D = r2), r2 || !n2 && D;
      }, w = function(t2, e2) {
        if (p(t2))
          return t2.clone();
        var n2 = typeof e2 == "object" ? e2 : {};
        return n2.date = t2, n2.args = arguments, new _(n2);
      }, O = g;
      O.l = S, O.i = p, O.w = function(t2, e2) {
        return w(t2, { locale: e2.$L, utc: e2.$u, x: e2.$x, $offset: e2.$offset });
      };
      var _ = function() {
        function M2(t2) {
          this.$L = S(t2.locale, null, true), this.parse(t2);
        }
        var m2 = M2.prototype;
        return m2.parse = function(t2) {
          this.$d = function(t3) {
            var e2 = t3.date, n2 = t3.utc;
            if (e2 === null)
              return new Date(NaN);
            if (O.u(e2))
              return new Date();
            if (e2 instanceof Date)
              return new Date(e2);
            if (typeof e2 == "string" && !/Z$/i.test(e2)) {
              var r2 = e2.match(l);
              if (r2) {
                var i2 = r2[2] - 1 || 0, s2 = (r2[7] || "0").substring(0, 3);
                return n2 ? new Date(Date.UTC(r2[1], i2, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2)) : new Date(r2[1], i2, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2);
              }
            }
            return new Date(e2);
          }(t2), this.$x = t2.x || {}, this.init();
        }, m2.init = function() {
          var t2 = this.$d;
          this.$y = t2.getFullYear(), this.$M = t2.getMonth(), this.$D = t2.getDate(), this.$W = t2.getDay(), this.$H = t2.getHours(), this.$m = t2.getMinutes(), this.$s = t2.getSeconds(), this.$ms = t2.getMilliseconds();
        }, m2.$utils = function() {
          return O;
        }, m2.isValid = function() {
          return !(this.$d.toString() === $);
        }, m2.isSame = function(t2, e2) {
          var n2 = w(t2);
          return this.startOf(e2) <= n2 && n2 <= this.endOf(e2);
        }, m2.isAfter = function(t2, e2) {
          return w(t2) < this.startOf(e2);
        }, m2.isBefore = function(t2, e2) {
          return this.endOf(e2) < w(t2);
        }, m2.$g = function(t2, e2, n2) {
          return O.u(t2) ? this[e2] : this.set(n2, t2);
        }, m2.unix = function() {
          return Math.floor(this.valueOf() / 1e3);
        }, m2.valueOf = function() {
          return this.$d.getTime();
        }, m2.startOf = function(t2, e2) {
          var n2 = this, r2 = !!O.u(e2) || e2, h2 = O.p(t2), $2 = function(t3, e3) {
            var i2 = O.w(n2.$u ? Date.UTC(n2.$y, e3, t3) : new Date(n2.$y, e3, t3), n2);
            return r2 ? i2 : i2.endOf(a);
          }, l2 = function(t3, e3) {
            return O.w(n2.toDate()[t3].apply(n2.toDate("s"), (r2 ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e3)), n2);
          }, y2 = this.$W, M3 = this.$M, m3 = this.$D, g2 = "set" + (this.$u ? "UTC" : "");
          switch (h2) {
            case c:
              return r2 ? $2(1, 0) : $2(31, 11);
            case f:
              return r2 ? $2(1, M3) : $2(0, M3 + 1);
            case o:
              var D2 = this.$locale().weekStart || 0, v2 = (y2 < D2 ? y2 + 7 : y2) - D2;
              return $2(r2 ? m3 - v2 : m3 + (6 - v2), M3);
            case a:
            case d:
              return l2(g2 + "Hours", 0);
            case u:
              return l2(g2 + "Minutes", 1);
            case s:
              return l2(g2 + "Seconds", 2);
            case i:
              return l2(g2 + "Milliseconds", 3);
            default:
              return this.clone();
          }
        }, m2.endOf = function(t2) {
          return this.startOf(t2, false);
        }, m2.$set = function(t2, e2) {
          var n2, o2 = O.p(t2), h2 = "set" + (this.$u ? "UTC" : ""), $2 = (n2 = {}, n2[a] = h2 + "Date", n2[d] = h2 + "Date", n2[f] = h2 + "Month", n2[c] = h2 + "FullYear", n2[u] = h2 + "Hours", n2[s] = h2 + "Minutes", n2[i] = h2 + "Seconds", n2[r] = h2 + "Milliseconds", n2)[o2], l2 = o2 === a ? this.$D + (e2 - this.$W) : e2;
          if (o2 === f || o2 === c) {
            var y2 = this.clone().set(d, 1);
            y2.$d[$2](l2), y2.init(), this.$d = y2.set(d, Math.min(this.$D, y2.daysInMonth())).$d;
          } else
            $2 && this.$d[$2](l2);
          return this.init(), this;
        }, m2.set = function(t2, e2) {
          return this.clone().$set(t2, e2);
        }, m2.get = function(t2) {
          return this[O.p(t2)]();
        }, m2.add = function(r2, h2) {
          var d2, $2 = this;
          r2 = Number(r2);
          var l2 = O.p(h2), y2 = function(t2) {
            var e2 = w($2);
            return O.w(e2.date(e2.date() + Math.round(t2 * r2)), $2);
          };
          if (l2 === f)
            return this.set(f, this.$M + r2);
          if (l2 === c)
            return this.set(c, this.$y + r2);
          if (l2 === a)
            return y2(1);
          if (l2 === o)
            return y2(7);
          var M3 = (d2 = {}, d2[s] = e, d2[u] = n, d2[i] = t, d2)[l2] || 1, m3 = this.$d.getTime() + r2 * M3;
          return O.w(m3, this);
        }, m2.subtract = function(t2, e2) {
          return this.add(-1 * t2, e2);
        }, m2.format = function(t2) {
          var e2 = this, n2 = this.$locale();
          if (!this.isValid())
            return n2.invalidDate || $;
          var r2 = t2 || "YYYY-MM-DDTHH:mm:ssZ", i2 = O.z(this), s2 = this.$H, u2 = this.$m, a2 = this.$M, o2 = n2.weekdays, f2 = n2.months, h2 = function(t3, n3, i3, s3) {
            return t3 && (t3[n3] || t3(e2, r2)) || i3[n3].substr(0, s3);
          }, c2 = function(t3) {
            return O.s(s2 % 12 || 12, t3, "0");
          }, d2 = n2.meridiem || function(t3, e3, n3) {
            var r3 = t3 < 12 ? "AM" : "PM";
            return n3 ? r3.toLowerCase() : r3;
          }, l2 = { YY: String(this.$y).slice(-2), YYYY: this.$y, M: a2 + 1, MM: O.s(a2 + 1, 2, "0"), MMM: h2(n2.monthsShort, a2, f2, 3), MMMM: h2(f2, a2), D: this.$D, DD: O.s(this.$D, 2, "0"), d: String(this.$W), dd: h2(n2.weekdaysMin, this.$W, o2, 2), ddd: h2(n2.weekdaysShort, this.$W, o2, 3), dddd: o2[this.$W], H: String(s2), HH: O.s(s2, 2, "0"), h: c2(1), hh: c2(2), a: d2(s2, u2, true), A: d2(s2, u2, false), m: String(u2), mm: O.s(u2, 2, "0"), s: String(this.$s), ss: O.s(this.$s, 2, "0"), SSS: O.s(this.$ms, 3, "0"), Z: i2 };
          return r2.replace(y, function(t3, e3) {
            return e3 || l2[t3] || i2.replace(":", "");
          });
        }, m2.utcOffset = function() {
          return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
        }, m2.diff = function(r2, d2, $2) {
          var l2, y2 = O.p(d2), M3 = w(r2), m3 = (M3.utcOffset() - this.utcOffset()) * e, g2 = this - M3, D2 = O.m(this, M3);
          return D2 = (l2 = {}, l2[c] = D2 / 12, l2[f] = D2, l2[h] = D2 / 3, l2[o] = (g2 - m3) / 6048e5, l2[a] = (g2 - m3) / 864e5, l2[u] = g2 / n, l2[s] = g2 / e, l2[i] = g2 / t, l2)[y2] || g2, $2 ? D2 : O.a(D2);
        }, m2.daysInMonth = function() {
          return this.endOf(f).$D;
        }, m2.$locale = function() {
          return v[this.$L];
        }, m2.locale = function(t2, e2) {
          if (!t2)
            return this.$L;
          var n2 = this.clone(), r2 = S(t2, e2, true);
          return r2 && (n2.$L = r2), n2;
        }, m2.clone = function() {
          return O.w(this.$d, this);
        }, m2.toDate = function() {
          return new Date(this.valueOf());
        }, m2.toJSON = function() {
          return this.isValid() ? this.toISOString() : null;
        }, m2.toISOString = function() {
          return this.$d.toISOString();
        }, m2.toString = function() {
          return this.$d.toUTCString();
        }, M2;
      }(), b = _.prototype;
      return w.prototype = b, [["$ms", r], ["$s", i], ["$m", s], ["$H", u], ["$W", a], ["$M", f], ["$y", c], ["$D", d]].forEach(function(t2) {
        b[t2[1]] = function(e2) {
          return this.$g(e2, t2[0], t2[1]);
        };
      }), w.extend = function(t2, e2) {
        return t2.$i || (t2(e2, _, w), t2.$i = true), w;
      }, w.locale = S, w.isDayjs = p, w.unix = function(t2) {
        return w(1e3 * t2);
      }, w.en = v[D], w.Ls = v, w.p = {}, w;
    });
  })(dayjs_min);
  var dayjs = dayjs_min.exports;

  var localeData$1 = {exports: {}};

  (function(module, exports) {
    !function(n, e) {
      module.exports = e() ;
    }(commonjsGlobal, function() {
      return function(n, e, t) {
        var r = e.prototype, o = function(n2) {
          return n2 && (n2.indexOf ? n2 : n2.s);
        }, u = function(n2, e2, t2, r2, u2) {
          var i2 = n2.name ? n2 : n2.$locale(), a2 = o(i2[e2]), s2 = o(i2[t2]), f = a2 || s2.map(function(n3) {
            return n3.substr(0, r2);
          });
          if (!u2)
            return f;
          var d = i2.weekStart;
          return f.map(function(n3, e3) {
            return f[(e3 + (d || 0)) % 7];
          });
        }, i = function() {
          return t.Ls[t.locale()];
        }, a = function(n2, e2) {
          return n2.formats[e2] || function(n3) {
            return n3.replace(/(\[[^\]]+])|(MMMM|MM|DD|dddd)/g, function(n4, e3, t2) {
              return e3 || t2.slice(1);
            });
          }(n2.formats[e2.toUpperCase()]);
        }, s = function() {
          var n2 = this;
          return { months: function(e2) {
            return e2 ? e2.format("MMMM") : u(n2, "months");
          }, monthsShort: function(e2) {
            return e2 ? e2.format("MMM") : u(n2, "monthsShort", "months", 3);
          }, firstDayOfWeek: function() {
            return n2.$locale().weekStart || 0;
          }, weekdays: function(e2) {
            return e2 ? e2.format("dddd") : u(n2, "weekdays");
          }, weekdaysMin: function(e2) {
            return e2 ? e2.format("dd") : u(n2, "weekdaysMin", "weekdays", 2);
          }, weekdaysShort: function(e2) {
            return e2 ? e2.format("ddd") : u(n2, "weekdaysShort", "weekdays", 3);
          }, longDateFormat: function(e2) {
            return a(n2.$locale(), e2);
          }, meridiem: this.$locale().meridiem, ordinal: this.$locale().ordinal };
        };
        r.localeData = function() {
          return s.bind(this)();
        }, t.localeData = function() {
          var n2 = i();
          return { firstDayOfWeek: function() {
            return n2.weekStart || 0;
          }, weekdays: function() {
            return t.weekdays();
          }, weekdaysShort: function() {
            return t.weekdaysShort();
          }, weekdaysMin: function() {
            return t.weekdaysMin();
          }, months: function() {
            return t.months();
          }, monthsShort: function() {
            return t.monthsShort();
          }, longDateFormat: function(e2) {
            return a(n2, e2);
          }, meridiem: n2.meridiem, ordinal: n2.ordinal };
        }, t.months = function() {
          return u(i(), "months");
        }, t.monthsShort = function() {
          return u(i(), "monthsShort", "months", 3);
        }, t.weekdays = function(n2) {
          return u(i(), "weekdays", null, null, n2);
        }, t.weekdaysShort = function(n2) {
          return u(i(), "weekdaysShort", "weekdays", 3, n2);
        }, t.weekdaysMin = function(n2) {
          return u(i(), "weekdaysMin", "weekdays", 2, n2);
        };
      };
    });
  })(localeData$1);
  var localeData = localeData$1.exports;

  var customParseFormat$1 = {exports: {}};

  (function(module, exports) {
    !function(t, e) {
      module.exports = e() ;
    }(commonjsGlobal, function() {
      var t = { LTS: "h:mm:ss A", LT: "h:mm A", L: "MM/DD/YYYY", LL: "MMMM D, YYYY", LLL: "MMMM D, YYYY h:mm A", LLLL: "dddd, MMMM D, YYYY h:mm A" }, e = /(\[[^[]*\])|([-:/.()\s]+)|(A|a|YYYY|YY?|MM?M?M?|Do|DD?|hh?|HH?|mm?|ss?|S{1,3}|z|ZZ?)/g, n = /\d\d/, r = /\d\d?/, i = /\d*[^\s\d-_:/()]+/, o = {}, s = function(t2) {
        return (t2 = +t2) + (t2 > 68 ? 1900 : 2e3);
      };
      var a = function(t2) {
        return function(e2) {
          this[t2] = +e2;
        };
      }, f = [/[+-]\d\d:?(\d\d)?|Z/, function(t2) {
        (this.zone || (this.zone = {})).offset = function(t3) {
          if (!t3)
            return 0;
          if (t3 === "Z")
            return 0;
          var e2 = t3.match(/([+-]|\d\d)/g), n2 = 60 * e2[1] + (+e2[2] || 0);
          return n2 === 0 ? 0 : e2[0] === "+" ? -n2 : n2;
        }(t2);
      }], u = function(t2) {
        var e2 = o[t2];
        return e2 && (e2.indexOf ? e2 : e2.s.concat(e2.f));
      }, h = function(t2, e2) {
        var n2, r2 = o.meridiem;
        if (r2) {
          for (var i2 = 1; i2 <= 24; i2 += 1)
            if (t2.indexOf(r2(i2, 0, e2)) > -1) {
              n2 = i2 > 12;
              break;
            }
        } else
          n2 = t2 === (e2 ? "pm" : "PM");
        return n2;
      }, d = { A: [i, function(t2) {
        this.afternoon = h(t2, false);
      }], a: [i, function(t2) {
        this.afternoon = h(t2, true);
      }], S: [/\d/, function(t2) {
        this.milliseconds = 100 * +t2;
      }], SS: [n, function(t2) {
        this.milliseconds = 10 * +t2;
      }], SSS: [/\d{3}/, function(t2) {
        this.milliseconds = +t2;
      }], s: [r, a("seconds")], ss: [r, a("seconds")], m: [r, a("minutes")], mm: [r, a("minutes")], H: [r, a("hours")], h: [r, a("hours")], HH: [r, a("hours")], hh: [r, a("hours")], D: [r, a("day")], DD: [n, a("day")], Do: [i, function(t2) {
        var e2 = o.ordinal, n2 = t2.match(/\d+/);
        if (this.day = n2[0], e2)
          for (var r2 = 1; r2 <= 31; r2 += 1)
            e2(r2).replace(/\[|\]/g, "") === t2 && (this.day = r2);
      }], M: [r, a("month")], MM: [n, a("month")], MMM: [i, function(t2) {
        var e2 = u("months"), n2 = (u("monthsShort") || e2.map(function(t3) {
          return t3.substr(0, 3);
        })).indexOf(t2) + 1;
        if (n2 < 1)
          throw new Error();
        this.month = n2 % 12 || n2;
      }], MMMM: [i, function(t2) {
        var e2 = u("months").indexOf(t2) + 1;
        if (e2 < 1)
          throw new Error();
        this.month = e2 % 12 || e2;
      }], Y: [/[+-]?\d+/, a("year")], YY: [n, function(t2) {
        this.year = s(t2);
      }], YYYY: [/\d{4}/, a("year")], Z: f, ZZ: f };
      function c(n2) {
        var r2, i2;
        r2 = n2, i2 = o && o.formats;
        for (var s2 = (n2 = r2.replace(/(\[[^\]]+])|(LTS?|l{1,4}|L{1,4})/g, function(e2, n3, r3) {
          var o2 = r3 && r3.toUpperCase();
          return n3 || i2[r3] || t[r3] || i2[o2].replace(/(\[[^\]]+])|(MMMM|MM|DD|dddd)/g, function(t2, e3, n4) {
            return e3 || n4.slice(1);
          });
        })).match(e), a2 = s2.length, f2 = 0; f2 < a2; f2 += 1) {
          var u2 = s2[f2], h2 = d[u2], c2 = h2 && h2[0], l = h2 && h2[1];
          s2[f2] = l ? { regex: c2, parser: l } : u2.replace(/^\[|\]$/g, "");
        }
        return function(t2) {
          for (var e2 = {}, n3 = 0, r3 = 0; n3 < a2; n3 += 1) {
            var i3 = s2[n3];
            if (typeof i3 == "string")
              r3 += i3.length;
            else {
              var o2 = i3.regex, f3 = i3.parser, u3 = t2.substr(r3), h3 = o2.exec(u3)[0];
              f3.call(e2, h3), t2 = t2.replace(h3, "");
            }
          }
          return function(t3) {
            var e3 = t3.afternoon;
            if (e3 !== void 0) {
              var n4 = t3.hours;
              e3 ? n4 < 12 && (t3.hours += 12) : n4 === 12 && (t3.hours = 0), delete t3.afternoon;
            }
          }(e2), e2;
        };
      }
      return function(t2, e2, n2) {
        n2.p.customParseFormat = true, t2 && t2.parseTwoDigitYear && (s = t2.parseTwoDigitYear);
        var r2 = e2.prototype, i2 = r2.parse;
        r2.parse = function(t3) {
          var e3 = t3.date, r3 = t3.utc, s2 = t3.args;
          this.$u = r3;
          var a2 = s2[1];
          if (typeof a2 == "string") {
            var f2 = s2[2] === true, u2 = s2[3] === true, h2 = f2 || u2, d2 = s2[2];
            u2 && (d2 = s2[2]), o = this.$locale(), !f2 && d2 && (o = n2.Ls[d2]), this.$d = function(t4, e4, n3) {
              try {
                if (["x", "X"].indexOf(e4) > -1)
                  return new Date((e4 === "X" ? 1e3 : 1) * t4);
                var r4 = c(e4)(t4), i3 = r4.year, o2 = r4.month, s3 = r4.day, a3 = r4.hours, f3 = r4.minutes, u3 = r4.seconds, h3 = r4.milliseconds, d3 = r4.zone, l2 = new Date(), m2 = s3 || (i3 || o2 ? 1 : l2.getDate()), M2 = i3 || l2.getFullYear(), Y = 0;
                i3 && !o2 || (Y = o2 > 0 ? o2 - 1 : l2.getMonth());
                var p = a3 || 0, v = f3 || 0, D = u3 || 0, g = h3 || 0;
                return d3 ? new Date(Date.UTC(M2, Y, m2, p, v, D, g + 60 * d3.offset * 1e3)) : n3 ? new Date(Date.UTC(M2, Y, m2, p, v, D, g)) : new Date(M2, Y, m2, p, v, D, g);
              } catch (t5) {
                return new Date("");
              }
            }(e3, a2, r3), this.init(), d2 && d2 !== true && (this.$L = this.locale(d2).$L), h2 && e3 != this.format(a2) && (this.$d = new Date("")), o = {};
          } else if (a2 instanceof Array)
            for (var l = a2.length, m = 1; m <= l; m += 1) {
              s2[1] = a2[m - 1];
              var M = n2.apply(this, s2);
              if (M.isValid()) {
                this.$d = M.$d, this.$L = M.$L, this.init();
                break;
              }
              m === l && (this.$d = new Date(""));
            }
          else
            i2.call(this, t3);
        };
      };
    });
  })(customParseFormat$1);
  var customParseFormat = customParseFormat$1.exports;

  const DEFAULT_FORMATS_TIME = "HH:mm:ss";
  const DEFAULT_FORMATS_DATE = "YYYY-MM-DD";
  const DEFAULT_FORMATS_DATEPICKER = {
    date: DEFAULT_FORMATS_DATE,
    week: "gggg[w]ww",
    year: "YYYY",
    month: "YYYY-MM",
    datetime: `${DEFAULT_FORMATS_DATE} ${DEFAULT_FORMATS_TIME}`,
    monthrange: "YYYY-MM",
    daterange: DEFAULT_FORMATS_DATE,
    datetimerange: `${DEFAULT_FORMATS_DATE} ${DEFAULT_FORMATS_TIME}`
  };

  const timePickerDefaultProps = {
    id: {
      type: [Array, String]
    },
    name: {
      type: [Array, String],
      default: ""
    },
    popperClass: {
      type: String,
      default: ""
    },
    format: {
      type: String
    },
    valueFormat: {
      type: String
    },
    type: {
      type: String,
      default: ""
    },
    clearable: {
      type: Boolean,
      default: true
    },
    clearIcon: {
      type: [String, Object],
      default: circleClose
    },
    editable: {
      type: Boolean,
      default: true
    },
    prefixIcon: {
      type: [String, Object],
      default: ""
    },
    size: {
      type: String,
      validator: isValidComponentSize
    },
    readonly: {
      type: Boolean,
      default: false
    },
    disabled: {
      type: Boolean,
      default: false
    },
    placeholder: {
      type: String,
      default: ""
    },
    popperOptions: {
      type: Object,
      default: () => ({})
    },
    modelValue: {
      type: [Date, Array, String, Number],
      default: ""
    },
    rangeSeparator: {
      type: String,
      default: "-"
    },
    startPlaceholder: String,
    endPlaceholder: String,
    defaultValue: {
      type: [Date, Array]
    },
    defaultTime: {
      type: [Date, Array]
    },
    isRange: {
      type: Boolean,
      default: false
    },
    disabledHours: {
      type: Function
    },
    disabledMinutes: {
      type: Function
    },
    disabledSeconds: {
      type: Function
    },
    disabledDate: {
      type: Function
    },
    cellClassName: {
      type: Function
    },
    shortcuts: {
      type: Array,
      default: () => []
    },
    arrowControl: {
      type: Boolean,
      default: false
    },
    validateEvent: {
      type: Boolean,
      default: true
    },
    unlinkPanels: Boolean
  };

  const dateEquals = function(a, b) {
    const aIsDate = a instanceof Date;
    const bIsDate = b instanceof Date;
    if (aIsDate && bIsDate) {
      return a.getTime() === b.getTime();
    }
    if (!aIsDate && !bIsDate) {
      return a === b;
    }
    return false;
  };
  const valueEquals = function(a, b) {
    const aIsArray = Array.isArray(a);
    const bIsArray = Array.isArray(b);
    if (aIsArray && bIsArray) {
      if (a.length !== b.length) {
        return false;
      }
      return a.every((item, index) => dateEquals(item, b[index]));
    }
    if (!aIsArray && !bIsArray) {
      return dateEquals(a, b);
    }
    return false;
  };
  const parser = function(date, format, lang) {
    const day = isEmpty(format) || format === "x" ? dayjs(date).locale(lang) : dayjs(date, format).locale(lang);
    return day.isValid() ? day : void 0;
  };
  const formatter = function(date, format, lang) {
    if (isEmpty(format))
      return date;
    if (format === "x")
      return +date;
    return dayjs(date).locale(lang).format(format);
  };
  const _sfc_main$1Q = vue.defineComponent({
    name: "Picker",
    components: {
      ElInput,
      ElTooltip,
      ElIcon
    },
    props: timePickerDefaultProps,
    emits: [
      "update:modelValue",
      "change",
      "focus",
      "blur",
      "calendar-change",
      "panel-change",
      "visible-change"
    ],
    setup(props, ctx) {
      const { lang } = useLocale();
      const elForm = vue.inject(formContextKey, {});
      const elFormItem = vue.inject(formItemContextKey, {});
      const elPopperOptions = vue.inject("ElPopperOptions", {});
      const refPopper = vue.ref();
      const inputRef = vue.ref();
      const pickerVisible = vue.ref(false);
      const pickerActualVisible = vue.ref(false);
      const valueOnOpen = vue.ref(null);
      vue.watch(pickerVisible, (val) => {
        var _a;
        if (!val) {
          userInput.value = null;
          vue.nextTick(() => {
            emitChange(props.modelValue);
          });
          ctx.emit("blur");
          blurInput();
          props.validateEvent && ((_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "blur").catch((err) => debugWarn()));
        } else {
          valueOnOpen.value = props.modelValue;
        }
      });
      const emitChange = (val, isClear) => {
        var _a;
        if (isClear || !valueEquals(val, valueOnOpen.value)) {
          ctx.emit("change", val);
          props.validateEvent && ((_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn()));
        }
      };
      const emitInput = (val) => {
        if (!valueEquals(props.modelValue, val)) {
          let formatValue;
          if (Array.isArray(val)) {
            formatValue = val.map((_) => formatter(_, props.valueFormat, lang.value));
          } else if (val) {
            formatValue = formatter(val, props.valueFormat, lang.value);
          }
          ctx.emit("update:modelValue", val ? formatValue : val, lang.value);
        }
      };
      const refInput = vue.computed(() => {
        if (inputRef.value) {
          const _r = isRangeInput.value ? inputRef.value : inputRef.value.$el;
          return Array.from(_r.querySelectorAll("input"));
        }
        return [];
      });
      const refStartInput = vue.computed(() => {
        return refInput == null ? void 0 : refInput.value[0];
      });
      const refEndInput = vue.computed(() => {
        return refInput == null ? void 0 : refInput.value[1];
      });
      const setSelectionRange = (start, end, pos) => {
        const _inputs = refInput.value;
        if (!_inputs.length)
          return;
        if (!pos || pos === "min") {
          _inputs[0].setSelectionRange(start, end);
          _inputs[0].focus();
        } else if (pos === "max") {
          _inputs[1].setSelectionRange(start, end);
          _inputs[1].focus();
        }
      };
      const onPick = (date = "", visible = false) => {
        pickerVisible.value = visible;
        let result;
        if (Array.isArray(date)) {
          result = date.map((_) => _.toDate());
        } else {
          result = date ? date.toDate() : date;
        }
        userInput.value = null;
        emitInput(result);
      };
      const onBeforeShow = () => {
        pickerActualVisible.value = true;
      };
      const onShow = () => {
        ctx.emit("visible-change", true);
      };
      const onHide = () => {
        pickerActualVisible.value = false;
        ctx.emit("visible-change", false);
      };
      const focus = (focusStartInput = true) => {
        let input = refStartInput.value;
        if (!focusStartInput && isRangeInput.value) {
          input = refEndInput.value;
        }
        if (input) {
          input.focus();
        }
      };
      const handleFocus = (e) => {
        if (props.readonly || pickerDisabled.value || pickerVisible.value)
          return;
        pickerVisible.value = true;
        ctx.emit("focus", e);
      };
      const handleBlur = () => {
        var _a;
        (_a = refPopper.value) == null ? void 0 : _a.onClose();
        blurInput();
      };
      const pickerDisabled = vue.computed(() => {
        return props.disabled || elForm.disabled;
      });
      const parsedValue = vue.computed(() => {
        let result;
        if (valueIsEmpty.value) {
          if (pickerOptions.value.getDefaultValue) {
            result = pickerOptions.value.getDefaultValue();
          }
        } else {
          if (Array.isArray(props.modelValue)) {
            result = props.modelValue.map((_) => parser(_, props.valueFormat, lang.value));
          } else {
            result = parser(props.modelValue, props.valueFormat, lang.value);
          }
        }
        if (pickerOptions.value.getRangeAvailableTime) {
          const availableResult = pickerOptions.value.getRangeAvailableTime(result);
          if (!isEqual$1(availableResult, result)) {
            result = availableResult;
            emitInput(Array.isArray(result) ? result.map((_) => _.toDate()) : result.toDate());
          }
        }
        if (Array.isArray(result) && result.some((_) => !_)) {
          result = [];
        }
        return result;
      });
      const displayValue = vue.computed(() => {
        if (!pickerOptions.value.panelReady)
          return;
        const formattedValue = formatDayjsToString(parsedValue.value);
        if (Array.isArray(userInput.value)) {
          return [
            userInput.value[0] || formattedValue && formattedValue[0] || "",
            userInput.value[1] || formattedValue && formattedValue[1] || ""
          ];
        } else if (userInput.value !== null) {
          return userInput.value;
        }
        if (!isTimePicker.value && valueIsEmpty.value)
          return;
        if (!pickerVisible.value && valueIsEmpty.value)
          return;
        if (formattedValue) {
          return isDatesPicker.value ? formattedValue.join(", ") : formattedValue;
        }
        return "";
      });
      const isTimeLikePicker = vue.computed(() => props.type.includes("time"));
      const isTimePicker = vue.computed(() => props.type.startsWith("time"));
      const isDatesPicker = vue.computed(() => props.type === "dates");
      const triggerIcon = vue.computed(() => props.prefixIcon || (isTimeLikePicker.value ? clock : calendar));
      const showClose = vue.ref(false);
      const onClearIconClick = (event) => {
        if (props.readonly || pickerDisabled.value)
          return;
        if (showClose.value) {
          event.stopPropagation();
          emitInput(null);
          emitChange(null, true);
          showClose.value = false;
          pickerVisible.value = false;
          pickerOptions.value.handleClear && pickerOptions.value.handleClear();
        }
      };
      const valueIsEmpty = vue.computed(() => {
        return !props.modelValue || Array.isArray(props.modelValue) && !props.modelValue.length;
      });
      const onMouseEnter = () => {
        if (props.readonly || pickerDisabled.value)
          return;
        if (!valueIsEmpty.value && props.clearable) {
          showClose.value = true;
        }
      };
      const onMouseLeave = () => {
        showClose.value = false;
      };
      const isRangeInput = vue.computed(() => {
        return props.type.includes("range");
      });
      const pickerSize = useSize();
      const popperPaneRef = vue.computed(() => {
        var _a, _b;
        return (_b = (_a = refPopper.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef;
      });
      const popperEl = vue.computed(() => {
        var _a, _b;
        return (_b = (_a = vue.unref(refPopper)) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef;
      });
      const actualInputRef = vue.computed(() => {
        var _a;
        if (vue.unref(isRangeInput)) {
          return vue.unref(inputRef);
        }
        return (_a = vue.unref(inputRef)) == null ? void 0 : _a.$el;
      });
      onClickOutside(actualInputRef, (e) => {
        const unrefedPopperEl = vue.unref(popperEl);
        const inputEl = vue.unref(actualInputRef);
        if (unrefedPopperEl && (e.target === unrefedPopperEl || e.composedPath().includes(unrefedPopperEl)) || e.target === inputEl || e.composedPath().includes(inputEl))
          return;
        pickerVisible.value = false;
      });
      const userInput = vue.ref(null);
      const handleChange = () => {
        if (userInput.value) {
          const value = parseUserInputToDayjs(displayValue.value);
          if (value) {
            if (isValidValue(value)) {
              emitInput(Array.isArray(value) ? value.map((_) => _.toDate()) : value.toDate());
              userInput.value = null;
            }
          }
        }
        if (userInput.value === "") {
          emitInput(null);
          emitChange(null);
          userInput.value = null;
        }
      };
      const blurInput = () => {
        refInput.value.forEach((input) => input.blur());
      };
      const parseUserInputToDayjs = (value) => {
        if (!value)
          return null;
        return pickerOptions.value.parseUserInput(value);
      };
      const formatDayjsToString = (value) => {
        if (!value)
          return null;
        return pickerOptions.value.formatToString(value);
      };
      const isValidValue = (value) => {
        return pickerOptions.value.isValidValue(value);
      };
      const handleKeydown = (event) => {
        const code = event.code;
        if (code === EVENT_CODE.esc) {
          pickerVisible.value = false;
          event.stopPropagation();
          return;
        }
        if (code === EVENT_CODE.tab) {
          if (!isRangeInput.value) {
            handleChange();
            pickerVisible.value = false;
            event.stopPropagation();
          } else {
            setTimeout(() => {
              if (!refInput.value.includes(document.activeElement)) {
                pickerVisible.value = false;
                blurInput();
              }
            }, 0);
          }
          return;
        }
        if (code === EVENT_CODE.enter || code === EVENT_CODE.numpadEnter) {
          if (userInput.value === null || userInput.value === "" || isValidValue(parseUserInputToDayjs(displayValue.value))) {
            handleChange();
            pickerVisible.value = false;
          }
          event.stopPropagation();
          return;
        }
        if (userInput.value) {
          event.stopPropagation();
          return;
        }
        if (pickerOptions.value.handleKeydown) {
          pickerOptions.value.handleKeydown(event);
        }
      };
      const onUserInput = (e) => {
        userInput.value = e;
      };
      const handleStartInput = (event) => {
        if (userInput.value) {
          userInput.value = [event.target.value, userInput.value[1]];
        } else {
          userInput.value = [event.target.value, null];
        }
      };
      const handleEndInput = (event) => {
        if (userInput.value) {
          userInput.value = [userInput.value[0], event.target.value];
        } else {
          userInput.value = [null, event.target.value];
        }
      };
      const handleStartChange = () => {
        const value = parseUserInputToDayjs(userInput.value && userInput.value[0]);
        if (value && value.isValid()) {
          userInput.value = [formatDayjsToString(value), displayValue.value[1]];
          const newValue = [value, parsedValue.value && parsedValue.value[1]];
          if (isValidValue(newValue)) {
            emitInput(newValue);
            userInput.value = null;
          }
        }
      };
      const handleEndChange = () => {
        const value = parseUserInputToDayjs(userInput.value && userInput.value[1]);
        if (value && value.isValid()) {
          userInput.value = [displayValue.value[0], formatDayjsToString(value)];
          const newValue = [parsedValue.value && parsedValue.value[0], value];
          if (isValidValue(newValue)) {
            emitInput(newValue);
            userInput.value = null;
          }
        }
      };
      const pickerOptions = vue.ref({});
      const onSetPickerOption = (e) => {
        pickerOptions.value[e[0]] = e[1];
        pickerOptions.value.panelReady = true;
      };
      const onCalendarChange = (e) => {
        ctx.emit("calendar-change", e);
      };
      const onPanelChange = (value, mode, view) => {
        ctx.emit("panel-change", value, mode, view);
      };
      vue.provide("EP_PICKER_BASE", {
        props
      });
      return {
        elPopperOptions,
        isDatesPicker,
        handleEndChange,
        handleStartChange,
        handleStartInput,
        handleEndInput,
        onUserInput,
        handleChange,
        handleKeydown,
        popperPaneRef,
        onClickOutside,
        pickerSize,
        isRangeInput,
        onMouseLeave,
        onMouseEnter,
        onClearIconClick,
        showClose,
        triggerIcon,
        onPick,
        handleFocus,
        handleBlur,
        pickerVisible,
        pickerActualVisible,
        displayValue,
        parsedValue,
        setSelectionRange,
        refPopper,
        inputRef,
        pickerDisabled,
        onSetPickerOption,
        onCalendarChange,
        onPanelChange,
        focus,
        onShow,
        onBeforeShow,
        onHide
      };
    }
  });
  const _hoisted_1$V = ["id", "name", "placeholder", "value", "disabled", "readonly"];
  const _hoisted_2$F = { class: "el-range-separator" };
  const _hoisted_3$o = ["id", "name", "placeholder", "value", "disabled", "readonly"];
  function _sfc_render$1x(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_el_input = vue.resolveComponent("el-input");
    const _component_el_tooltip = vue.resolveComponent("el-tooltip");
    return vue.openBlock(), vue.createBlock(_component_el_tooltip, vue.mergeProps({
      ref: "refPopper",
      visible: _ctx.pickerVisible,
      "onUpdate:visible": _cache[17] || (_cache[17] = ($event) => _ctx.pickerVisible = $event),
      effect: "light",
      pure: "",
      trigger: "click"
    }, _ctx.$attrs, {
      "append-to-body": "",
      transition: "el-zoom-in-top",
      "popper-class": `el-picker__popper ${_ctx.popperClass}`,
      "popper-options": _ctx.elPopperOptions,
      "fallback-placements": ["bottom", "top", "right", "left"],
      "gpu-acceleration": false,
      "stop-popper-mouse-event": false,
      "hide-after": 0,
      persistent: "",
      onBeforeShow: _ctx.onBeforeShow,
      onShow: _ctx.onShow,
      onHide: _ctx.onHide
    }), {
      default: vue.withCtx(() => [
        !_ctx.isRangeInput ? (vue.openBlock(), vue.createBlock(_component_el_input, {
          key: 0,
          id: _ctx.id,
          ref: "inputRef",
          "model-value": _ctx.displayValue,
          name: _ctx.name,
          size: _ctx.pickerSize,
          disabled: _ctx.pickerDisabled,
          placeholder: _ctx.placeholder,
          class: vue.normalizeClass(["el-date-editor", ["el-date-editor--" + _ctx.type, _ctx.$attrs.class || void 0]]),
          style: vue.normalizeStyle(_ctx.$attrs.style || void 0),
          readonly: !_ctx.editable || _ctx.readonly || _ctx.isDatesPicker || _ctx.type === "week",
          onInput: _ctx.onUserInput,
          onFocus: _ctx.handleFocus,
          onKeydown: _ctx.handleKeydown,
          onChange: _ctx.handleChange,
          onMouseenter: _ctx.onMouseEnter,
          onMouseleave: _ctx.onMouseLeave,
          onClick: _cache[0] || (_cache[0] = vue.withModifiers(() => {
          }, ["stop"]))
        }, {
          prefix: vue.withCtx(() => [
            _ctx.triggerIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: 0,
              class: "el-input__icon",
              onClick: _ctx.handleFocus
            }, {
              default: vue.withCtx(() => [
                (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.triggerIcon)))
              ]),
              _: 1
            }, 8, ["onClick"])) : vue.createCommentVNode("v-if", true)
          ]),
          suffix: vue.withCtx(() => [
            _ctx.showClose && _ctx.clearIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
              key: 0,
              class: "el-input__icon clear-icon",
              onClick: _ctx.onClearIconClick
            }, {
              default: vue.withCtx(() => [
                (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.clearIcon)))
              ]),
              _: 1
            }, 8, ["onClick"])) : vue.createCommentVNode("v-if", true)
          ]),
          _: 1
        }, 8, ["id", "model-value", "name", "size", "disabled", "placeholder", "class", "style", "readonly", "onInput", "onFocus", "onKeydown", "onChange", "onMouseenter", "onMouseleave"])) : (vue.openBlock(), vue.createElementBlock("div", {
          key: 1,
          ref: "inputRef",
          class: vue.normalizeClass(["el-date-editor el-range-editor el-input__inner", [
            "el-date-editor--" + _ctx.type,
            _ctx.pickerSize ? `el-range-editor--${_ctx.pickerSize}` : "",
            _ctx.pickerDisabled ? "is-disabled" : "",
            _ctx.pickerVisible ? "is-active" : "",
            _ctx.$attrs.class || void 0
          ]]),
          style: vue.normalizeStyle(_ctx.$attrs.style || void 0),
          onClick: _cache[7] || (_cache[7] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
          onMouseenter: _cache[8] || (_cache[8] = (...args) => _ctx.onMouseEnter && _ctx.onMouseEnter(...args)),
          onMouseleave: _cache[9] || (_cache[9] = (...args) => _ctx.onMouseLeave && _ctx.onMouseLeave(...args)),
          onKeydown: _cache[10] || (_cache[10] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args))
        }, [
          _ctx.triggerIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
            key: 0,
            class: "el-input__icon el-range__icon",
            onClick: _ctx.handleFocus
          }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.triggerIcon)))
            ]),
            _: 1
          }, 8, ["onClick"])) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("input", {
            id: _ctx.id && _ctx.id[0],
            autocomplete: "off",
            name: _ctx.name && _ctx.name[0],
            placeholder: _ctx.startPlaceholder,
            value: _ctx.displayValue && _ctx.displayValue[0],
            disabled: _ctx.pickerDisabled,
            readonly: !_ctx.editable || _ctx.readonly,
            class: "el-range-input",
            onInput: _cache[1] || (_cache[1] = (...args) => _ctx.handleStartInput && _ctx.handleStartInput(...args)),
            onChange: _cache[2] || (_cache[2] = (...args) => _ctx.handleStartChange && _ctx.handleStartChange(...args)),
            onFocus: _cache[3] || (_cache[3] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args))
          }, null, 40, _hoisted_1$V),
          vue.renderSlot(_ctx.$slots, "range-separator", {}, () => [
            vue.createElementVNode("span", _hoisted_2$F, vue.toDisplayString(_ctx.rangeSeparator), 1)
          ]),
          vue.createElementVNode("input", {
            id: _ctx.id && _ctx.id[1],
            autocomplete: "off",
            name: _ctx.name && _ctx.name[1],
            placeholder: _ctx.endPlaceholder,
            value: _ctx.displayValue && _ctx.displayValue[1],
            disabled: _ctx.pickerDisabled,
            readonly: !_ctx.editable || _ctx.readonly,
            class: "el-range-input",
            onFocus: _cache[4] || (_cache[4] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
            onInput: _cache[5] || (_cache[5] = (...args) => _ctx.handleEndInput && _ctx.handleEndInput(...args)),
            onChange: _cache[6] || (_cache[6] = (...args) => _ctx.handleEndChange && _ctx.handleEndChange(...args))
          }, null, 40, _hoisted_3$o),
          _ctx.clearIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
            key: 1,
            class: vue.normalizeClass(["el-input__icon el-range__close-icon", {
              "el-range__close-icon--hidden": !_ctx.showClose
            }]),
            onClick: _ctx.onClearIconClick
          }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.clearIcon)))
            ]),
            _: 1
          }, 8, ["class", "onClick"])) : vue.createCommentVNode("v-if", true)
        ], 38))
      ]),
      content: vue.withCtx(() => [
        vue.renderSlot(_ctx.$slots, "default", {
          visible: _ctx.pickerVisible,
          actualVisible: _ctx.pickerActualVisible,
          parsedValue: _ctx.parsedValue,
          format: _ctx.format,
          unlinkPanels: _ctx.unlinkPanels,
          type: _ctx.type,
          defaultValue: _ctx.defaultValue,
          onPick: _cache[11] || (_cache[11] = (...args) => _ctx.onPick && _ctx.onPick(...args)),
          onSelectRange: _cache[12] || (_cache[12] = (...args) => _ctx.setSelectionRange && _ctx.setSelectionRange(...args)),
          onSetPickerOption: _cache[13] || (_cache[13] = (...args) => _ctx.onSetPickerOption && _ctx.onSetPickerOption(...args)),
          onCalendarChange: _cache[14] || (_cache[14] = (...args) => _ctx.onCalendarChange && _ctx.onCalendarChange(...args)),
          onPanelChange: _cache[15] || (_cache[15] = (...args) => _ctx.onPanelChange && _ctx.onPanelChange(...args)),
          onMousedown: _cache[16] || (_cache[16] = vue.withModifiers(() => {
          }, ["stop"]))
        })
      ]),
      _: 3
    }, 16, ["visible", "popper-class", "popper-options", "onBeforeShow", "onShow", "onHide"]);
  }
  var CommonPicker = /* @__PURE__ */ _export_sfc(_sfc_main$1Q, [["render", _sfc_render$1x]]);

  const nodeList = /* @__PURE__ */ new Map();
  let startClick;
  if (isClient) {
    document.addEventListener("mousedown", (e) => startClick = e);
    document.addEventListener("mouseup", (e) => {
      for (const handlers of nodeList.values()) {
        for (const { documentHandler } of handlers) {
          documentHandler(e, startClick);
        }
      }
    });
  }
  function createDocumentHandler(el, binding) {
    let excludes = [];
    if (Array.isArray(binding.arg)) {
      excludes = binding.arg;
    } else if (isElement$1(binding.arg)) {
      excludes.push(binding.arg);
    }
    return function(mouseup, mousedown) {
      const popperRef = binding.instance.popperRef;
      const mouseUpTarget = mouseup.target;
      const mouseDownTarget = mousedown == null ? void 0 : mousedown.target;
      const isBound = !binding || !binding.instance;
      const isTargetExists = !mouseUpTarget || !mouseDownTarget;
      const isContainedByEl = el.contains(mouseUpTarget) || el.contains(mouseDownTarget);
      const isSelf = el === mouseUpTarget;
      const isTargetExcluded = excludes.length && excludes.some((item) => item == null ? void 0 : item.contains(mouseUpTarget)) || excludes.length && excludes.includes(mouseDownTarget);
      const isContainedByPopper = popperRef && (popperRef.contains(mouseUpTarget) || popperRef.contains(mouseDownTarget));
      if (isBound || isTargetExists || isContainedByEl || isSelf || isTargetExcluded || isContainedByPopper) {
        return;
      }
      binding.value(mouseup, mousedown);
    };
  }
  const ClickOutside = {
    beforeMount(el, binding) {
      if (!nodeList.has(el)) {
        nodeList.set(el, []);
      }
      nodeList.get(el).push({
        documentHandler: createDocumentHandler(el, binding),
        bindingFn: binding.value
      });
    },
    updated(el, binding) {
      if (!nodeList.has(el)) {
        nodeList.set(el, []);
      }
      const handlers = nodeList.get(el);
      const oldHandlerIndex = handlers.findIndex((item) => item.bindingFn === binding.oldValue);
      const newHandler = {
        documentHandler: createDocumentHandler(el, binding),
        bindingFn: binding.value
      };
      if (oldHandlerIndex >= 0) {
        handlers.splice(oldHandlerIndex, 1, newHandler);
      } else {
        handlers.push(newHandler);
      }
    },
    unmounted(el) {
      nodeList.delete(el);
    }
  };

  var RepeatClick = {
    beforeMount(el, binding) {
      let interval = null;
      let startTime;
      const handler = () => binding.value && binding.value();
      const clear = () => {
        if (Date.now() - startTime < 100) {
          handler();
        }
        clearInterval(interval);
        interval = null;
      };
      on(el, "mousedown", (e) => {
        if (e.button !== 0)
          return;
        startTime = Date.now();
        once(document, "mouseup", clear);
        clearInterval(interval);
        interval = setInterval(handler, 100);
      });
    }
  };

  const FOCUSABLE_CHILDREN = "_trap-focus-children";
  const FOCUS_STACK = [];
  const FOCUS_HANDLER = (e) => {
    if (FOCUS_STACK.length === 0)
      return;
    const focusableElement = FOCUS_STACK[FOCUS_STACK.length - 1][FOCUSABLE_CHILDREN];
    if (focusableElement.length > 0 && e.code === EVENT_CODE.tab) {
      if (focusableElement.length === 1) {
        e.preventDefault();
        if (document.activeElement !== focusableElement[0]) {
          focusableElement[0].focus();
        }
        return;
      }
      const goingBackward = e.shiftKey;
      const isFirst = e.target === focusableElement[0];
      const isLast = e.target === focusableElement[focusableElement.length - 1];
      if (isFirst && goingBackward) {
        e.preventDefault();
        focusableElement[focusableElement.length - 1].focus();
      }
      if (isLast && !goingBackward) {
        e.preventDefault();
        focusableElement[0].focus();
      }
    }
  };
  const TrapFocus = {
    beforeMount(el) {
      el[FOCUSABLE_CHILDREN] = obtainAllFocusableElements$1(el);
      FOCUS_STACK.push(el);
      if (FOCUS_STACK.length <= 1) {
        on(document, "keydown", FOCUS_HANDLER);
      }
    },
    updated(el) {
      vue.nextTick(() => {
        el[FOCUSABLE_CHILDREN] = obtainAllFocusableElements$1(el);
      });
    },
    unmounted() {
      FOCUS_STACK.shift();
      if (FOCUS_STACK.length === 0) {
        off(document, "keydown", FOCUS_HANDLER);
      }
    }
  };

  var h=!1,o,s,f,u,d,D,l,p,m,w,N,E,x,A,M;function a(){if(!h){h=!0;var e=navigator.userAgent,n=/(?:MSIE.(\d+\.\d+))|(?:(?:Firefox|GranParadiso|Iceweasel).(\d+\.\d+))|(?:Opera(?:.+Version.|.)(\d+\.\d+))|(?:AppleWebKit.(\d+(?:\.\d+)?))|(?:Trident\/\d+\.\d+.*rv:(\d+\.\d+))/.exec(e),i=/(Mac OS X)|(Windows)|(Linux)/.exec(e);if(E=/\b(iPhone|iP[ao]d)/.exec(e),x=/\b(iP[ao]d)/.exec(e),w=/Android/i.exec(e),A=/FBAN\/\w+;/i.exec(e),M=/Mobile/i.exec(e),N=!!/Win64/.exec(e),n){o=n[1]?parseFloat(n[1]):n[5]?parseFloat(n[5]):NaN,o&&document&&document.documentMode&&(o=document.documentMode);var r=/(?:Trident\/(\d+.\d+))/.exec(e);D=r?parseFloat(r[1])+4:o,s=n[2]?parseFloat(n[2]):NaN,f=n[3]?parseFloat(n[3]):NaN,u=n[4]?parseFloat(n[4]):NaN,u?(n=/(?:Chrome\/(\d+\.\d+))/.exec(e),d=n&&n[1]?parseFloat(n[1]):NaN):d=NaN;}else { o=s=f=d=u=NaN; }if(i){if(i[1]){var t=/(?:Mac OS X (\d+(?:[._]\d+)?))/.exec(e);l=t?parseFloat(t[1].replace("_",".")):!0;}else { l=!1; }p=!!i[2],m=!!i[3];}else { l=p=m=!1; }}}var _={ie:function(){return a()||o},ieCompatibilityMode:function(){return a()||D>o},ie64:function(){return _.ie()&&N},firefox:function(){return a()||s},opera:function(){return a()||f},webkit:function(){return a()||u},safari:function(){return _.webkit()},chrome:function(){return a()||d},windows:function(){return a()||p},osx:function(){return a()||l},linux:function(){return a()||m},iphone:function(){return a()||E},mobile:function(){return a()||E||x||w||M},nativeApp:function(){return a()||A},android:function(){return a()||w},ipad:function(){return a()||x}},F=_;var c=!!(typeof window!="undefined"&&window.document&&window.document.createElement),I={canUseDOM:c,canUseWorkers:typeof Worker!="undefined",canUseEventListeners:c&&!!(window.addEventListener||window.attachEvent),canUseViewport:c&&!!window.screen,isInWorker:!c},v=I;var X;v.canUseDOM&&(X=document.implementation&&document.implementation.hasFeature&&document.implementation.hasFeature("","")!==!0);function S(e,n){if(!v.canUseDOM||n&&!("addEventListener"in document)){ return !1; }var i="on"+e,r=i in document;if(!r){var t=document.createElement("div");t.setAttribute(i,"return;"),r=typeof t[i]=="function";}return !r&&X&&e==="wheel"&&(r=document.implementation.hasFeature("Events.wheel","3.0")),r}var b=S;var O=10,P=40,T=800;function U(e){var n=0,i=0,r=0,t=0;return "detail"in e&&(i=e.detail),"wheelDelta"in e&&(i=-e.wheelDelta/120),"wheelDeltaY"in e&&(i=-e.wheelDeltaY/120),"wheelDeltaX"in e&&(n=-e.wheelDeltaX/120),"axis"in e&&e.axis===e.HORIZONTAL_AXIS&&(n=i,i=0),r=n*O,t=i*O,"deltaY"in e&&(t=e.deltaY),"deltaX"in e&&(r=e.deltaX),(r||t)&&e.deltaMode&&(e.deltaMode==1?(r*=P,t*=P):(r*=T,t*=T)),r&&!n&&(n=r<1?-1:1),t&&!i&&(i=t<1?-1:1),{spinX:n,spinY:i,pixelX:r,pixelY:t}}U.getEventType=function(){return F.firefox()?"DOMMouseScroll":b("wheel")?"wheel":"mousewheel"};var W=U;/**
   * Checks if an event is supported in the current execution environment.
   *
   * NOTE: This will not work correctly for non-generic events such as `change`,
   * `reset`, `load`, `error`, and `select`.
   *
   * Borrows from Modernizr.
   *
   * @param {string} eventNameSuffix Event name, e.g. "click".
   * @param {?boolean} capture Check if the capture phase is supported.
   * @return {boolean} True if the event is supported.
   * @internal
   * @license Modernizr 3.0.0pre (Custom Build) | MIT
   */

  const mousewheel = function(element, callback) {
    if (element && element.addEventListener) {
      const fn = function(event) {
        const normalized = W(event);
        callback && Reflect.apply(callback, this, [event, normalized]);
      };
      if (isFirefox()) {
        element.addEventListener("DOMMouseScroll", fn);
      } else {
        element.onmousewheel = fn;
      }
    }
  };
  const Mousewheel = {
    beforeMount(el, binding) {
      mousewheel(el, binding.value);
    }
  };

  const Resize = {
    beforeMount(el, binding) {
      el._handleResize = () => {
        var _a;
        el && ((_a = binding.value) == null ? void 0 : _a.call(binding, el));
      };
      addResizeListener(el, el._handleResize);
    },
    beforeUnmount(el) {
      removeResizeListener(el, el._handleResize);
    }
  };

  const makeList = (total, method, methodFunc) => {
    const arr = [];
    const disabledArr = method && methodFunc();
    for (let i = 0; i < total; i++) {
      arr[i] = disabledArr ? disabledArr.includes(i) : false;
    }
    return arr;
  };
  const makeAvailableArr = (list) => {
    return list.map((_, index) => !_ ? index : _).filter((_) => _ !== true);
  };
  const getTimeLists = (disabledHours, disabledMinutes, disabledSeconds) => {
    const getHoursList = (role, compare) => {
      return makeList(24, disabledHours, () => disabledHours(role, compare));
    };
    const getMinutesList = (hour, role, compare) => {
      return makeList(60, disabledMinutes, () => disabledMinutes(hour, role, compare));
    };
    const getSecondsList = (hour, minute, role, compare) => {
      return makeList(60, disabledSeconds, () => disabledSeconds(hour, minute, role, compare));
    };
    return {
      getHoursList,
      getMinutesList,
      getSecondsList
    };
  };
  const getAvailableArrs = (disabledHours, disabledMinutes, disabledSeconds) => {
    const { getHoursList, getMinutesList, getSecondsList } = getTimeLists(disabledHours, disabledMinutes, disabledSeconds);
    const getAvailableHours = (role, compare) => {
      return makeAvailableArr(getHoursList(role, compare));
    };
    const getAvailableMinutes = (hour, role, compare) => {
      return makeAvailableArr(getMinutesList(hour, role, compare));
    };
    const getAvailableSeconds = (hour, minute, role, compare) => {
      return makeAvailableArr(getSecondsList(hour, minute, role, compare));
    };
    return {
      getAvailableHours,
      getAvailableMinutes,
      getAvailableSeconds
    };
  };
  const useOldValue = (props) => {
    const oldValue = vue.ref(props.parsedValue);
    vue.watch(() => props.visible, (val) => {
      if (!val) {
        oldValue.value = props.parsedValue;
      }
    });
    return oldValue;
  };

  const _sfc_main$1P = vue.defineComponent({
    directives: {
      repeatClick: RepeatClick
    },
    components: {
      ElScrollbar,
      ElIcon,
      ArrowUp: arrowUp,
      ArrowDown: arrowDown
    },
    props: {
      role: {
        type: String,
        required: true
      },
      spinnerDate: {
        type: Object,
        required: true
      },
      showSeconds: {
        type: Boolean,
        default: true
      },
      arrowControl: Boolean,
      amPmMode: {
        type: String,
        default: ""
      },
      disabledHours: {
        type: Function
      },
      disabledMinutes: {
        type: Function
      },
      disabledSeconds: {
        type: Function
      }
    },
    emits: ["change", "select-range", "set-option"],
    setup(props, ctx) {
      let isScrolling = false;
      const debouncedResetScroll = debounce$1((type) => {
        isScrolling = false;
        adjustCurrentSpinner(type);
      }, 200);
      const currentScrollbar = vue.ref(null);
      const listHoursRef = vue.ref(null);
      const listMinutesRef = vue.ref(null);
      const listSecondsRef = vue.ref(null);
      const listRefsMap = {
        hours: listHoursRef,
        minutes: listMinutesRef,
        seconds: listSecondsRef
      };
      const spinnerItems = vue.computed(() => {
        const arr = ["hours", "minutes", "seconds"];
        return props.showSeconds ? arr : arr.slice(0, 2);
      });
      const hours = vue.computed(() => {
        return props.spinnerDate.hour();
      });
      const minutes = vue.computed(() => {
        return props.spinnerDate.minute();
      });
      const seconds = vue.computed(() => {
        return props.spinnerDate.second();
      });
      const timePartsMap = vue.computed(() => ({
        hours,
        minutes,
        seconds
      }));
      const hoursList = vue.computed(() => {
        return getHoursList(props.role);
      });
      const minutesList = vue.computed(() => {
        return getMinutesList(hours.value, props.role);
      });
      const secondsList = vue.computed(() => {
        return getSecondsList(hours.value, minutes.value, props.role);
      });
      const listMap = vue.computed(() => ({
        hours: hoursList,
        minutes: minutesList,
        seconds: secondsList
      }));
      const arrowHourList = vue.computed(() => {
        const hour = hours.value;
        return [
          hour > 0 ? hour - 1 : void 0,
          hour,
          hour < 23 ? hour + 1 : void 0
        ];
      });
      const arrowMinuteList = vue.computed(() => {
        const minute = minutes.value;
        return [
          minute > 0 ? minute - 1 : void 0,
          minute,
          minute < 59 ? minute + 1 : void 0
        ];
      });
      const arrowSecondList = vue.computed(() => {
        const second = seconds.value;
        return [
          second > 0 ? second - 1 : void 0,
          second,
          second < 59 ? second + 1 : void 0
        ];
      });
      const arrowListMap = vue.computed(() => ({
        hours: arrowHourList,
        minutes: arrowMinuteList,
        seconds: arrowSecondList
      }));
      const getAmPmFlag = (hour) => {
        const shouldShowAmPm = !!props.amPmMode;
        if (!shouldShowAmPm)
          return "";
        const isCapital = props.amPmMode === "A";
        let content = hour < 12 ? " am" : " pm";
        if (isCapital)
          content = content.toUpperCase();
        return content;
      };
      const emitSelectRange = (type) => {
        if (type === "hours") {
          ctx.emit("select-range", 0, 2);
        } else if (type === "minutes") {
          ctx.emit("select-range", 3, 5);
        } else if (type === "seconds") {
          ctx.emit("select-range", 6, 8);
        }
        currentScrollbar.value = type;
      };
      const adjustCurrentSpinner = (type) => {
        adjustSpinner(type, timePartsMap.value[type].value);
      };
      const adjustSpinners = () => {
        adjustCurrentSpinner("hours");
        adjustCurrentSpinner("minutes");
        adjustCurrentSpinner("seconds");
      };
      const adjustSpinner = (type, value) => {
        if (props.arrowControl)
          return;
        const el = listRefsMap[type];
        if (el && el.$el) {
          el.$el.querySelector(".el-scrollbar__wrap").scrollTop = Math.max(0, value * typeItemHeight(type));
        }
      };
      const typeItemHeight = (type) => {
        const el = listRefsMap[type];
        return el.$el.querySelector("li").offsetHeight;
      };
      const onIncreaseClick = () => {
        scrollDown(1);
      };
      const onDecreaseClick = () => {
        scrollDown(-1);
      };
      const scrollDown = (step) => {
        if (!currentScrollbar.value) {
          emitSelectRange("hours");
        }
        const label = currentScrollbar.value;
        let now = timePartsMap.value[label].value;
        const total = currentScrollbar.value === "hours" ? 24 : 60;
        now = (now + step + total) % total;
        modifyDateField(label, now);
        adjustSpinner(label, now);
        vue.nextTick(() => emitSelectRange(currentScrollbar.value));
      };
      const modifyDateField = (type, value) => {
        const list = listMap.value[type].value;
        const isDisabled = list[value];
        if (isDisabled)
          return;
        switch (type) {
          case "hours":
            ctx.emit("change", props.spinnerDate.hour(value).minute(minutes.value).second(seconds.value));
            break;
          case "minutes":
            ctx.emit("change", props.spinnerDate.hour(hours.value).minute(value).second(seconds.value));
            break;
          case "seconds":
            ctx.emit("change", props.spinnerDate.hour(hours.value).minute(minutes.value).second(value));
            break;
        }
      };
      const handleClick = (type, { value, disabled }) => {
        if (!disabled) {
          modifyDateField(type, value);
          emitSelectRange(type);
          adjustSpinner(type, value);
        }
      };
      const handleScroll = (type) => {
        isScrolling = true;
        debouncedResetScroll(type);
        const value = Math.min(Math.round((listRefsMap[type].$el.querySelector(".el-scrollbar__wrap").scrollTop - (scrollBarHeight(type) * 0.5 - 10) / typeItemHeight(type) + 3) / typeItemHeight(type)), type === "hours" ? 23 : 59);
        modifyDateField(type, value);
      };
      const scrollBarHeight = (type) => {
        return listRefsMap[type].$el.offsetHeight;
      };
      const bindScrollEvent = () => {
        const bindFuntion = (type) => {
          if (listRefsMap[type] && listRefsMap[type].$el) {
            listRefsMap[type].$el.querySelector(".el-scrollbar__wrap").onscroll = () => {
              handleScroll(type);
            };
          }
        };
        bindFuntion("hours");
        bindFuntion("minutes");
        bindFuntion("seconds");
      };
      vue.onMounted(() => {
        vue.nextTick(() => {
          !props.arrowControl && bindScrollEvent();
          adjustSpinners();
          if (props.role === "start")
            emitSelectRange("hours");
        });
      });
      const setRef = (scrollbar, type) => {
        listRefsMap[type] = scrollbar;
      };
      ctx.emit("set-option", [`${props.role}_scrollDown`, scrollDown]);
      ctx.emit("set-option", [`${props.role}_emitSelectRange`, emitSelectRange]);
      const { getHoursList, getMinutesList, getSecondsList } = getTimeLists(props.disabledHours, props.disabledMinutes, props.disabledSeconds);
      vue.watch(() => props.spinnerDate, () => {
        if (isScrolling)
          return;
        adjustSpinners();
      });
      return {
        setRef,
        spinnerItems,
        currentScrollbar,
        hours,
        minutes,
        seconds,
        hoursList,
        minutesList,
        arrowHourList,
        arrowMinuteList,
        arrowSecondList,
        getAmPmFlag,
        emitSelectRange,
        adjustCurrentSpinner,
        typeItemHeight,
        listHoursRef,
        listMinutesRef,
        listSecondsRef,
        onIncreaseClick,
        onDecreaseClick,
        handleClick,
        secondsList,
        timePartsMap,
        arrowListMap,
        listMap
      };
    }
  });
  const _hoisted_1$U = ["onClick"];
  const _hoisted_2$E = ["onMouseenter"];
  const _hoisted_3$n = { class: "el-time-spinner__list" };
  function _sfc_render$1w(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_scrollbar = vue.resolveComponent("el-scrollbar");
    const _component_arrow_up = vue.resolveComponent("arrow-up");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_arrow_down = vue.resolveComponent("arrow-down");
    const _directive_repeat_click = vue.resolveDirective("repeat-click");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(["el-time-spinner", { "has-seconds": _ctx.showSeconds }])
    }, [
      !_ctx.arrowControl ? (vue.openBlock(true), vue.createElementBlock(vue.Fragment, { key: 0 }, vue.renderList(_ctx.spinnerItems, (item) => {
        return vue.openBlock(), vue.createBlock(_component_el_scrollbar, {
          key: item,
          ref_for: true,
          ref: (scollbar) => _ctx.setRef(scollbar, item),
          class: "el-time-spinner__wrapper",
          "wrap-style": "max-height: inherit;",
          "view-class": "el-time-spinner__list",
          noresize: "",
          tag: "ul",
          onMouseenter: ($event) => _ctx.emitSelectRange(item),
          onMousemove: ($event) => _ctx.adjustCurrentSpinner(item)
        }, {
          default: vue.withCtx(() => [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.listMap[item].value, (disabled, key) => {
              return vue.openBlock(), vue.createElementBlock("li", {
                key,
                class: vue.normalizeClass(["el-time-spinner__item", { active: key === _ctx.timePartsMap[item].value, disabled }]),
                onClick: ($event) => _ctx.handleClick(item, { value: key, disabled })
              }, [
                item === "hours" ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
                  vue.createTextVNode(vue.toDisplayString(("0" + (_ctx.amPmMode ? key % 12 || 12 : key)).slice(-2)) + vue.toDisplayString(_ctx.getAmPmFlag(key)), 1)
                ], 2112)) : (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 1 }, [
                  vue.createTextVNode(vue.toDisplayString(("0" + key).slice(-2)), 1)
                ], 2112))
              ], 10, _hoisted_1$U);
            }), 128))
          ]),
          _: 2
        }, 1032, ["onMouseenter", "onMousemove"]);
      }), 128)) : vue.createCommentVNode("v-if", true),
      _ctx.arrowControl ? (vue.openBlock(true), vue.createElementBlock(vue.Fragment, { key: 1 }, vue.renderList(_ctx.spinnerItems, (item) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          key: item,
          class: "el-time-spinner__wrapper is-arrow",
          onMouseenter: ($event) => _ctx.emitSelectRange(item)
        }, [
          vue.withDirectives((vue.openBlock(), vue.createBlock(_component_el_icon, { class: "el-time-spinner__arrow arrow-up" }, {
            default: vue.withCtx(() => [
              vue.createVNode(_component_arrow_up)
            ]),
            _: 1
          })), [
            [_directive_repeat_click, _ctx.onDecreaseClick]
          ]),
          vue.withDirectives((vue.openBlock(), vue.createBlock(_component_el_icon, { class: "el-time-spinner__arrow arrow-down" }, {
            default: vue.withCtx(() => [
              vue.createVNode(_component_arrow_down)
            ]),
            _: 1
          })), [
            [_directive_repeat_click, _ctx.onIncreaseClick]
          ]),
          vue.createElementVNode("ul", _hoisted_3$n, [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.arrowListMap[item].value, (time, key) => {
              return vue.openBlock(), vue.createElementBlock("li", {
                key,
                class: vue.normalizeClass(["el-time-spinner__item", {
                  active: time === _ctx.timePartsMap[item].value,
                  disabled: _ctx.listMap[item].value[time]
                }])
              }, [
                typeof time === "number" ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
                  item === "hours" ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
                    vue.createTextVNode(vue.toDisplayString(("0" + (_ctx.amPmMode ? time % 12 || 12 : time)).slice(-2)) + vue.toDisplayString(_ctx.getAmPmFlag(time)), 1)
                  ], 2112)) : (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 1 }, [
                    vue.createTextVNode(vue.toDisplayString(("0" + time).slice(-2)), 1)
                  ], 2112))
                ], 2112)) : vue.createCommentVNode("v-if", true)
              ], 2);
            }), 128))
          ])
        ], 40, _hoisted_2$E);
      }), 128)) : vue.createCommentVNode("v-if", true)
    ], 2);
  }
  var TimeSpinner = /* @__PURE__ */ _export_sfc(_sfc_main$1P, [["render", _sfc_render$1w]]);

  const _sfc_main$1O = vue.defineComponent({
    components: {
      TimeSpinner
    },
    props: {
      visible: Boolean,
      actualVisible: {
        type: Boolean,
        default: void 0
      },
      datetimeRole: {
        type: String
      },
      parsedValue: {
        type: [Object, String]
      },
      format: {
        type: String,
        default: ""
      }
    },
    emits: ["pick", "select-range", "set-picker-option"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const selectionRange = vue.ref([0, 2]);
      const oldValue = useOldValue(props);
      const transitionName = vue.computed(() => {
        return props.actualVisible === void 0 ? "el-zoom-in-top" : "";
      });
      const showSeconds = vue.computed(() => {
        return props.format.includes("ss");
      });
      const amPmMode = vue.computed(() => {
        if (props.format.includes("A"))
          return "A";
        if (props.format.includes("a"))
          return "a";
        return "";
      });
      const isValidValue = (_date) => {
        const parsedDate = dayjs(_date).locale(lang.value);
        const result = getRangeAvailableTime(parsedDate);
        return parsedDate.isSame(result);
      };
      const handleCancel = () => {
        ctx.emit("pick", oldValue.value, false);
      };
      const handleConfirm = (visible = false, first = false) => {
        if (first)
          return;
        ctx.emit("pick", props.parsedValue, visible);
      };
      const handleChange = (_date) => {
        if (!props.visible) {
          return;
        }
        const result = getRangeAvailableTime(_date).millisecond(0);
        ctx.emit("pick", result, true);
      };
      const setSelectionRange = (start, end) => {
        ctx.emit("select-range", start, end);
        selectionRange.value = [start, end];
      };
      const changeSelectionRange = (step) => {
        const list = [0, 3].concat(showSeconds.value ? [6] : []);
        const mapping = ["hours", "minutes"].concat(showSeconds.value ? ["seconds"] : []);
        const index = list.indexOf(selectionRange.value[0]);
        const next = (index + step + list.length) % list.length;
        timePickerOptions["start_emitSelectRange"](mapping[next]);
      };
      const handleKeydown = (event) => {
        const code = event.code;
        if (code === EVENT_CODE.left || code === EVENT_CODE.right) {
          const step = code === EVENT_CODE.left ? -1 : 1;
          changeSelectionRange(step);
          event.preventDefault();
          return;
        }
        if (code === EVENT_CODE.up || code === EVENT_CODE.down) {
          const step = code === EVENT_CODE.up ? -1 : 1;
          timePickerOptions["start_scrollDown"](step);
          event.preventDefault();
          return;
        }
      };
      const getRangeAvailableTime = (date) => {
        const availableMap = {
          hour: getAvailableHours,
          minute: getAvailableMinutes,
          second: getAvailableSeconds
        };
        let result = date;
        ["hour", "minute", "second"].forEach((_) => {
          if (availableMap[_]) {
            let availableArr;
            const method = availableMap[_];
            if (_ === "minute") {
              availableArr = method(result.hour(), props.datetimeRole);
            } else if (_ === "second") {
              availableArr = method(result.hour(), result.minute(), props.datetimeRole);
            } else {
              availableArr = method(props.datetimeRole);
            }
            if (availableArr && availableArr.length && !availableArr.includes(result[_]())) {
              result = result[_](availableArr[0]);
            }
          }
        });
        return result;
      };
      const parseUserInput = (value) => {
        if (!value)
          return null;
        return dayjs(value, props.format).locale(lang.value);
      };
      const formatToString = (value) => {
        if (!value)
          return null;
        return value.format(props.format);
      };
      const getDefaultValue = () => {
        return dayjs(defaultValue).locale(lang.value);
      };
      ctx.emit("set-picker-option", ["isValidValue", isValidValue]);
      ctx.emit("set-picker-option", ["formatToString", formatToString]);
      ctx.emit("set-picker-option", ["parseUserInput", parseUserInput]);
      ctx.emit("set-picker-option", ["handleKeydown", handleKeydown]);
      ctx.emit("set-picker-option", [
        "getRangeAvailableTime",
        getRangeAvailableTime
      ]);
      ctx.emit("set-picker-option", ["getDefaultValue", getDefaultValue]);
      const timePickerOptions = {};
      const onSetOption = (e) => {
        timePickerOptions[e[0]] = e[1];
      };
      const pickerBase = vue.inject("EP_PICKER_BASE");
      const {
        arrowControl,
        disabledHours,
        disabledMinutes,
        disabledSeconds,
        defaultValue
      } = pickerBase.props;
      const { getAvailableHours, getAvailableMinutes, getAvailableSeconds } = getAvailableArrs(disabledHours, disabledMinutes, disabledSeconds);
      return {
        transitionName,
        arrowControl,
        onSetOption,
        t,
        handleConfirm,
        handleChange,
        setSelectionRange,
        amPmMode,
        showSeconds,
        handleCancel,
        disabledHours,
        disabledMinutes,
        disabledSeconds
      };
    }
  });
  const _hoisted_1$T = {
    key: 0,
    class: "el-time-panel"
  };
  const _hoisted_2$D = { class: "el-time-panel__footer" };
  function _sfc_render$1v(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_time_spinner = vue.resolveComponent("time-spinner");
    return vue.openBlock(), vue.createBlock(vue.Transition, { name: _ctx.transitionName }, {
      default: vue.withCtx(() => [
        _ctx.actualVisible || _ctx.visible ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_1$T, [
          vue.createElementVNode("div", {
            class: vue.normalizeClass(["el-time-panel__content", { "has-seconds": _ctx.showSeconds }])
          }, [
            vue.createVNode(_component_time_spinner, {
              ref: "spinner",
              role: _ctx.datetimeRole || "start",
              "arrow-control": _ctx.arrowControl,
              "show-seconds": _ctx.showSeconds,
              "am-pm-mode": _ctx.amPmMode,
              "spinner-date": _ctx.parsedValue,
              "disabled-hours": _ctx.disabledHours,
              "disabled-minutes": _ctx.disabledMinutes,
              "disabled-seconds": _ctx.disabledSeconds,
              onChange: _ctx.handleChange,
              onSetOption: _ctx.onSetOption,
              onSelectRange: _ctx.setSelectionRange
            }, null, 8, ["role", "arrow-control", "show-seconds", "am-pm-mode", "spinner-date", "disabled-hours", "disabled-minutes", "disabled-seconds", "onChange", "onSetOption", "onSelectRange"])
          ], 2),
          vue.createElementVNode("div", _hoisted_2$D, [
            vue.createElementVNode("button", {
              type: "button",
              class: "el-time-panel__btn cancel",
              onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleCancel && _ctx.handleCancel(...args))
            }, vue.toDisplayString(_ctx.t("el.datepicker.cancel")), 1),
            vue.createElementVNode("button", {
              type: "button",
              class: "el-time-panel__btn confirm",
              onClick: _cache[1] || (_cache[1] = ($event) => _ctx.handleConfirm())
            }, vue.toDisplayString(_ctx.t("el.datepicker.confirm")), 1)
          ])
        ])) : vue.createCommentVNode("v-if", true)
      ]),
      _: 1
    }, 8, ["name"]);
  }
  var TimePickPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1O, [["render", _sfc_render$1v]]);

  const makeSelectRange = (start, end) => {
    const result = [];
    for (let i = start; i <= end; i++) {
      result.push(i);
    }
    return result;
  };
  const _sfc_main$1N = vue.defineComponent({
    components: { TimeSpinner },
    props: {
      visible: Boolean,
      actualVisible: Boolean,
      parsedValue: {
        type: [Array]
      },
      format: {
        type: String,
        default: ""
      }
    },
    emits: ["pick", "select-range", "set-picker-option"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const minDate = vue.computed(() => props.parsedValue[0]);
      const maxDate = vue.computed(() => props.parsedValue[1]);
      const oldValue = useOldValue(props);
      const handleCancel = () => {
        ctx.emit("pick", oldValue.value, null);
      };
      const showSeconds = vue.computed(() => {
        return props.format.includes("ss");
      });
      const amPmMode = vue.computed(() => {
        if (props.format.includes("A"))
          return "A";
        if (props.format.includes("a"))
          return "a";
        return "";
      });
      const minSelectableRange = vue.ref([]);
      const maxSelectableRange = vue.ref([]);
      const handleConfirm = (visible = false) => {
        ctx.emit("pick", [minDate.value, maxDate.value], visible);
      };
      const handleMinChange = (date) => {
        handleChange(date.millisecond(0), maxDate.value);
      };
      const handleMaxChange = (date) => {
        handleChange(minDate.value, date.millisecond(0));
      };
      const isValidValue = (_date) => {
        const parsedDate = _date.map((_) => dayjs(_).locale(lang.value));
        const result = getRangeAvailableTime(parsedDate);
        return parsedDate[0].isSame(result[0]) && parsedDate[1].isSame(result[1]);
      };
      const handleChange = (_minDate, _maxDate) => {
        ctx.emit("pick", [_minDate, _maxDate], true);
      };
      const btnConfirmDisabled = vue.computed(() => {
        return minDate.value > maxDate.value;
      });
      const selectionRange = vue.ref([0, 2]);
      const setMinSelectionRange = (start, end) => {
        ctx.emit("select-range", start, end, "min");
        selectionRange.value = [start, end];
      };
      const offset = vue.computed(() => showSeconds.value ? 11 : 8);
      const setMaxSelectionRange = (start, end) => {
        ctx.emit("select-range", start, end, "max");
        selectionRange.value = [start + offset.value, end + offset.value];
      };
      const changeSelectionRange = (step) => {
        const list = showSeconds.value ? [0, 3, 6, 11, 14, 17] : [0, 3, 8, 11];
        const mapping = ["hours", "minutes"].concat(showSeconds.value ? ["seconds"] : []);
        const index = list.indexOf(selectionRange.value[0]);
        const next = (index + step + list.length) % list.length;
        const half = list.length / 2;
        if (next < half) {
          timePickerOptions["start_emitSelectRange"](mapping[next]);
        } else {
          timePickerOptions["end_emitSelectRange"](mapping[next - half]);
        }
      };
      const handleKeydown = (event) => {
        const code = event.code;
        if (code === EVENT_CODE.left || code === EVENT_CODE.right) {
          const step = code === EVENT_CODE.left ? -1 : 1;
          changeSelectionRange(step);
          event.preventDefault();
          return;
        }
        if (code === EVENT_CODE.up || code === EVENT_CODE.down) {
          const step = code === EVENT_CODE.up ? -1 : 1;
          const role = selectionRange.value[0] < offset.value ? "start" : "end";
          timePickerOptions[`${role}_scrollDown`](step);
          event.preventDefault();
          return;
        }
      };
      const disabledHours_ = (role, compare) => {
        const defaultDisable = disabledHours ? disabledHours(role) : [];
        const isStart = role === "start";
        const compareDate = compare || (isStart ? maxDate.value : minDate.value);
        const compareHour = compareDate.hour();
        const nextDisable = isStart ? makeSelectRange(compareHour + 1, 23) : makeSelectRange(0, compareHour - 1);
        return union$1(defaultDisable, nextDisable);
      };
      const disabledMinutes_ = (hour, role, compare) => {
        const defaultDisable = disabledMinutes ? disabledMinutes(hour, role) : [];
        const isStart = role === "start";
        const compareDate = compare || (isStart ? maxDate.value : minDate.value);
        const compareHour = compareDate.hour();
        if (hour !== compareHour) {
          return defaultDisable;
        }
        const compareMinute = compareDate.minute();
        const nextDisable = isStart ? makeSelectRange(compareMinute + 1, 59) : makeSelectRange(0, compareMinute - 1);
        return union$1(defaultDisable, nextDisable);
      };
      const disabledSeconds_ = (hour, minute, role, compare) => {
        const defaultDisable = disabledSeconds ? disabledSeconds(hour, minute, role) : [];
        const isStart = role === "start";
        const compareDate = compare || (isStart ? maxDate.value : minDate.value);
        const compareHour = compareDate.hour();
        const compareMinute = compareDate.minute();
        if (hour !== compareHour || minute !== compareMinute) {
          return defaultDisable;
        }
        const compareSecond = compareDate.second();
        const nextDisable = isStart ? makeSelectRange(compareSecond + 1, 59) : makeSelectRange(0, compareSecond - 1);
        return union$1(defaultDisable, nextDisable);
      };
      const getRangeAvailableTime = (dates) => {
        return dates.map((_, index) => getRangeAvailableTimeEach(dates[0], dates[1], index === 0 ? "start" : "end"));
      };
      const { getAvailableHours, getAvailableMinutes, getAvailableSeconds } = getAvailableArrs(disabledHours_, disabledMinutes_, disabledSeconds_);
      const getRangeAvailableTimeEach = (startDate, endDate, role) => {
        const availableMap = {
          hour: getAvailableHours,
          minute: getAvailableMinutes,
          second: getAvailableSeconds
        };
        const isStart = role === "start";
        let result = isStart ? startDate : endDate;
        const compareDate = isStart ? endDate : startDate;
        ["hour", "minute", "second"].forEach((_) => {
          if (availableMap[_]) {
            let availableArr;
            const method = availableMap[_];
            if (_ === "minute") {
              availableArr = method(result.hour(), role, compareDate);
            } else if (_ === "second") {
              availableArr = method(result.hour(), result.minute(), role, compareDate);
            } else {
              availableArr = method(role, compareDate);
            }
            if (availableArr && availableArr.length && !availableArr.includes(result[_]())) {
              const pos = isStart ? 0 : availableArr.length - 1;
              result = result[_](availableArr[pos]);
            }
          }
        });
        return result;
      };
      const parseUserInput = (value) => {
        if (!value)
          return null;
        if (Array.isArray(value)) {
          return value.map((_) => dayjs(_, props.format).locale(lang.value));
        }
        return dayjs(value, props.format).locale(lang.value);
      };
      const formatToString = (value) => {
        if (!value)
          return null;
        if (Array.isArray(value)) {
          return value.map((_) => _.format(props.format));
        }
        return value.format(props.format);
      };
      const getDefaultValue = () => {
        if (Array.isArray(defaultValue)) {
          return defaultValue.map((_) => dayjs(_).locale(lang.value));
        }
        const defaultDay = dayjs(defaultValue).locale(lang.value);
        return [defaultDay, defaultDay.add(60, "m")];
      };
      ctx.emit("set-picker-option", ["formatToString", formatToString]);
      ctx.emit("set-picker-option", ["parseUserInput", parseUserInput]);
      ctx.emit("set-picker-option", ["isValidValue", isValidValue]);
      ctx.emit("set-picker-option", ["handleKeydown", handleKeydown]);
      ctx.emit("set-picker-option", ["getDefaultValue", getDefaultValue]);
      ctx.emit("set-picker-option", [
        "getRangeAvailableTime",
        getRangeAvailableTime
      ]);
      const timePickerOptions = {};
      const onSetOption = (e) => {
        timePickerOptions[e[0]] = e[1];
      };
      const pickerBase = vue.inject("EP_PICKER_BASE");
      const {
        arrowControl,
        disabledHours,
        disabledMinutes,
        disabledSeconds,
        defaultValue
      } = pickerBase.props;
      return {
        arrowControl,
        onSetOption,
        setMaxSelectionRange,
        setMinSelectionRange,
        btnConfirmDisabled,
        handleCancel,
        handleConfirm,
        t,
        showSeconds,
        minDate,
        maxDate,
        amPmMode,
        handleMinChange,
        handleMaxChange,
        minSelectableRange,
        maxSelectableRange,
        disabledHours_,
        disabledMinutes_,
        disabledSeconds_
      };
    }
  });
  const _hoisted_1$S = {
    key: 0,
    class: "el-time-range-picker el-picker-panel"
  };
  const _hoisted_2$C = { class: "el-time-range-picker__content" };
  const _hoisted_3$m = { class: "el-time-range-picker__cell" };
  const _hoisted_4$f = { class: "el-time-range-picker__header" };
  const _hoisted_5$a = { class: "el-time-range-picker__cell" };
  const _hoisted_6$7 = { class: "el-time-range-picker__header" };
  const _hoisted_7$6 = { class: "el-time-panel__footer" };
  const _hoisted_8$6 = ["disabled"];
  function _sfc_render$1u(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_time_spinner = vue.resolveComponent("time-spinner");
    return _ctx.actualVisible ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_1$S, [
      vue.createElementVNode("div", _hoisted_2$C, [
        vue.createElementVNode("div", _hoisted_3$m, [
          vue.createElementVNode("div", _hoisted_4$f, vue.toDisplayString(_ctx.t("el.datepicker.startTime")), 1),
          vue.createElementVNode("div", {
            class: vue.normalizeClass([{ "has-seconds": _ctx.showSeconds, "is-arrow": _ctx.arrowControl }, "el-time-range-picker__body el-time-panel__content"])
          }, [
            vue.createVNode(_component_time_spinner, {
              ref: "minSpinner",
              role: "start",
              "show-seconds": _ctx.showSeconds,
              "am-pm-mode": _ctx.amPmMode,
              "arrow-control": _ctx.arrowControl,
              "spinner-date": _ctx.minDate,
              "disabled-hours": _ctx.disabledHours_,
              "disabled-minutes": _ctx.disabledMinutes_,
              "disabled-seconds": _ctx.disabledSeconds_,
              onChange: _ctx.handleMinChange,
              onSetOption: _ctx.onSetOption,
              onSelectRange: _ctx.setMinSelectionRange
            }, null, 8, ["show-seconds", "am-pm-mode", "arrow-control", "spinner-date", "disabled-hours", "disabled-minutes", "disabled-seconds", "onChange", "onSetOption", "onSelectRange"])
          ], 2)
        ]),
        vue.createElementVNode("div", _hoisted_5$a, [
          vue.createElementVNode("div", _hoisted_6$7, vue.toDisplayString(_ctx.t("el.datepicker.endTime")), 1),
          vue.createElementVNode("div", {
            class: vue.normalizeClass([{ "has-seconds": _ctx.showSeconds, "is-arrow": _ctx.arrowControl }, "el-time-range-picker__body el-time-panel__content"])
          }, [
            vue.createVNode(_component_time_spinner, {
              ref: "maxSpinner",
              role: "end",
              "show-seconds": _ctx.showSeconds,
              "am-pm-mode": _ctx.amPmMode,
              "arrow-control": _ctx.arrowControl,
              "spinner-date": _ctx.maxDate,
              "disabled-hours": _ctx.disabledHours_,
              "disabled-minutes": _ctx.disabledMinutes_,
              "disabled-seconds": _ctx.disabledSeconds_,
              onChange: _ctx.handleMaxChange,
              onSetOption: _ctx.onSetOption,
              onSelectRange: _ctx.setMaxSelectionRange
            }, null, 8, ["show-seconds", "am-pm-mode", "arrow-control", "spinner-date", "disabled-hours", "disabled-minutes", "disabled-seconds", "onChange", "onSetOption", "onSelectRange"])
          ], 2)
        ])
      ]),
      vue.createElementVNode("div", _hoisted_7$6, [
        vue.createElementVNode("button", {
          type: "button",
          class: "el-time-panel__btn cancel",
          onClick: _cache[0] || (_cache[0] = ($event) => _ctx.handleCancel())
        }, vue.toDisplayString(_ctx.t("el.datepicker.cancel")), 1),
        vue.createElementVNode("button", {
          type: "button",
          class: "el-time-panel__btn confirm",
          disabled: _ctx.btnConfirmDisabled,
          onClick: _cache[1] || (_cache[1] = ($event) => _ctx.handleConfirm())
        }, vue.toDisplayString(_ctx.t("el.datepicker.confirm")), 9, _hoisted_8$6)
      ])
    ])) : vue.createCommentVNode("v-if", true);
  }
  var TimeRangePanel = /* @__PURE__ */ _export_sfc(_sfc_main$1N, [["render", _sfc_render$1u]]);

  dayjs.extend(customParseFormat);
  var TimePicker = vue.defineComponent({
    name: "ElTimePicker",
    install: null,
    props: {
      ...timePickerDefaultProps,
      isRange: {
        type: Boolean,
        default: false
      }
    },
    emits: ["update:modelValue"],
    setup(props, ctx) {
      const commonPicker = vue.ref(null);
      const type = props.isRange ? "timerange" : "time";
      const panel = props.isRange ? TimeRangePanel : TimePickPanel;
      const refProps = {
        ...props,
        focus: () => {
          var _a;
          (_a = commonPicker.value) == null ? void 0 : _a.handleFocus();
        },
        blur: () => {
          var _a;
          (_a = commonPicker.value) == null ? void 0 : _a.handleBlur();
        }
      };
      vue.provide("ElPopperOptions", props.popperOptions);
      ctx.expose(refProps);
      return () => {
        var _a;
        const format = (_a = props.format) != null ? _a : DEFAULT_FORMATS_TIME;
        return vue.h(CommonPicker, {
          ...props,
          format,
          type,
          ref: commonPicker,
          "onUpdate:modelValue": (value) => ctx.emit("update:modelValue", value)
        }, {
          default: (scopedProps) => vue.h(panel, scopedProps)
        });
      };
    }
  });

  const rangeArr = (n) => Array.from(Array.from({ length: n }).keys());
  const extractDateFormat = (format) => {
    return format.replace(/\W?m{1,2}|\W?ZZ/g, "").replace(/\W?h{1,2}|\W?s{1,3}|\W?a/gi, "").trim();
  };
  const extractTimeFormat = (format) => {
    return format.replace(/\W?D{1,2}|\W?Do|\W?d{1,4}|\W?M{1,4}|\W?Y{2,4}/g, "").trim();
  };

  const _TimePicker = TimePicker;
  _TimePicker.install = (app) => {
    app.component(_TimePicker.name, _TimePicker);
  };
  const ElTimePicker = _TimePicker;

  const dateTableProps = buildProps({
    selectedDay: {
      type: definePropType(Object)
    },
    range: {
      type: definePropType(Array)
    },
    date: {
      type: definePropType(Object),
      required: true
    },
    hideHeader: {
      type: Boolean
    }
  });
  const dateTableEmits = {
    pick: (value) => isObject$1(value)
  };

  dayjs.extend(localeData);
  const WEEK_DAYS = ["sun", "mon", "tue", "wed", "thu", "fri", "sat"];
  const getPrevMonthLastDays = (date, count) => {
    const lastDay = date.subtract(1, "month").endOf("month").date();
    return rangeArr(count).map((_, index) => lastDay - (count - index - 1));
  };
  const getMonthDays = (date) => {
    const days = date.daysInMonth();
    return rangeArr(days).map((_, index) => index + 1);
  };
  const toNestedArr = (days) => rangeArr(days.length / 7).map((index) => {
    const start = index * 7;
    return days.slice(start, start + 7);
  });
  const _sfc_main$1M = vue.defineComponent({
    props: dateTableProps,
    emits: dateTableEmits,
    setup(props, { emit }) {
      const { t, lang } = useLocale();
      const nsTable = useNamespace("calendar-table");
      const nsDay = useNamespace("calendar-day");
      const now = dayjs().locale(lang.value);
      const firstDayOfWeek = now.$locale().weekStart || 0;
      const isInRange = vue.computed(() => !!props.range && !!props.range.length);
      const rows = vue.computed(() => {
        let days = [];
        if (isInRange.value) {
          const [start, end] = props.range;
          const currentMonthRange = rangeArr(end.date() - start.date() + 1).map((index) => ({
            text: start.date() + index,
            type: "current"
          }));
          let remaining = currentMonthRange.length % 7;
          remaining = remaining === 0 ? 0 : 7 - remaining;
          const nextMonthRange = rangeArr(remaining).map((_, index) => ({
            text: index + 1,
            type: "next"
          }));
          days = currentMonthRange.concat(nextMonthRange);
        } else {
          const firstDay = props.date.startOf("month").day() || 7;
          const prevMonthDays = getPrevMonthLastDays(props.date, firstDay - firstDayOfWeek).map((day) => ({
            text: day,
            type: "prev"
          }));
          const currentMonthDays = getMonthDays(props.date).map((day) => ({
            text: day,
            type: "current"
          }));
          days = [...prevMonthDays, ...currentMonthDays];
          const nextMonthDays = rangeArr(42 - days.length).map((_, index) => ({
            text: index + 1,
            type: "next"
          }));
          days = days.concat(nextMonthDays);
        }
        return toNestedArr(days);
      });
      const weekDays = vue.computed(() => {
        const start = firstDayOfWeek;
        if (start === 0) {
          return WEEK_DAYS.map((_) => t(`el.datepicker.weeks.${_}`));
        } else {
          return WEEK_DAYS.slice(start).concat(WEEK_DAYS.slice(0, start)).map((_) => t(`el.datepicker.weeks.${_}`));
        }
      });
      const getFormattedDate = (day, type) => {
        switch (type) {
          case "prev":
            return props.date.startOf("month").subtract(1, "month").date(day);
          case "next":
            return props.date.startOf("month").add(1, "month").date(day);
          case "current":
            return props.date.date(day);
        }
      };
      const getCellClass = ({ text, type }) => {
        const classes = [type];
        if (type === "current") {
          const date = getFormattedDate(text, type);
          if (date.isSame(props.selectedDay, "day")) {
            classes.push(nsDay.is("selected"));
          }
          if (date.isSame(now, "day")) {
            classes.push(nsDay.is("today"));
          }
        }
        return classes;
      };
      const handlePickDay = ({ text, type }) => {
        const date = getFormattedDate(text, type);
        emit("pick", date);
      };
      const getSlotData = ({ text, type }) => {
        const day = getFormattedDate(text, type);
        return {
          isSelected: day.isSame(props.selectedDay),
          type: `${type}-month`,
          day: day.format("YYYY-MM-DD"),
          date: day.toDate()
        };
      };
      return {
        isInRange,
        weekDays,
        rows,
        getCellClass,
        handlePickDay,
        getSlotData,
        nsTable,
        nsDay
      };
    }
  });
  const _hoisted_1$R = { key: 0 };
  const _hoisted_2$B = ["onClick"];
  function _sfc_render$1t(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("table", {
      class: vue.normalizeClass([_ctx.nsTable.b(), _ctx.nsTable.is("range", _ctx.isInRange)]),
      cellspacing: "0",
      cellpadding: "0"
    }, [
      !_ctx.hideHeader ? (vue.openBlock(), vue.createElementBlock("thead", _hoisted_1$R, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.weekDays, (day) => {
          return vue.openBlock(), vue.createElementBlock("th", { key: day }, vue.toDisplayString(day), 1);
        }), 128))
      ])) : vue.createCommentVNode("v-if", true),
      vue.createElementVNode("tbody", null, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.rows, (row, index) => {
          return vue.openBlock(), vue.createElementBlock("tr", {
            key: index,
            class: vue.normalizeClass({
              [_ctx.nsTable.e("row")]: true,
              [_ctx.nsTable.em("row", "hide-border")]: index === 0 && _ctx.hideHeader
            })
          }, [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(row, (cell, key) => {
              return vue.openBlock(), vue.createElementBlock("td", {
                key,
                class: vue.normalizeClass(_ctx.getCellClass(cell)),
                onClick: ($event) => _ctx.handlePickDay(cell)
              }, [
                vue.createElementVNode("div", {
                  class: vue.normalizeClass(_ctx.nsDay.b())
                }, [
                  vue.renderSlot(_ctx.$slots, "dateCell", {
                    data: _ctx.getSlotData(cell)
                  }, () => [
                    vue.createElementVNode("span", null, vue.toDisplayString(cell.text), 1)
                  ])
                ], 2)
              ], 10, _hoisted_2$B);
            }), 128))
          ], 2);
        }), 128))
      ])
    ], 2);
  }
  var DateTable$1 = /* @__PURE__ */ _export_sfc(_sfc_main$1M, [["render", _sfc_render$1t]]);

  const calendarProps = buildProps({
    modelValue: {
      type: Date
    },
    range: {
      type: definePropType(Array),
      validator: (range) => Array.isArray(range) && range.length === 2 && range.every((item) => item instanceof Date)
    }
  });
  const calendarEmits = {
    [UPDATE_MODEL_EVENT]: (value) => value instanceof Date,
    input: (value) => value instanceof Date
  };

  const _sfc_main$1L = vue.defineComponent({
    name: "ElCalendar",
    components: {
      DateTable: DateTable$1,
      ElButton,
      ElButtonGroup: ElButtonGroup$1
    },
    props: calendarProps,
    emits: calendarEmits,
    setup(props, { emit }) {
      const ns = useNamespace("calendar");
      const { t, lang } = useLocale();
      const selectedDay = vue.ref();
      const now = dayjs().locale(lang.value);
      const prevMonthDayjs = vue.computed(() => {
        return date.value.subtract(1, "month").date(1);
      });
      const curMonthDatePrefix = vue.computed(() => {
        return dayjs(date.value).locale(lang.value).format("YYYY-MM");
      });
      const nextMonthDayjs = vue.computed(() => {
        return date.value.add(1, "month").date(1);
      });
      const prevYearDayjs = vue.computed(() => {
        return date.value.subtract(1, "year").date(1);
      });
      const nextYearDayjs = vue.computed(() => {
        return date.value.add(1, "year").date(1);
      });
      const i18nDate = vue.computed(() => {
        const pickedMonth = `el.datepicker.month${date.value.format("M")}`;
        return `${date.value.year()} ${t("el.datepicker.year")} ${t(pickedMonth)}`;
      });
      const realSelectedDay = vue.computed({
        get() {
          if (!props.modelValue)
            return selectedDay.value;
          return date.value;
        },
        set(val) {
          if (!val)
            return;
          selectedDay.value = val;
          const result = val.toDate();
          emit("input", result);
          emit("update:modelValue", result);
        }
      });
      const date = vue.computed(() => {
        if (!props.modelValue) {
          if (realSelectedDay.value) {
            return realSelectedDay.value;
          } else if (validatedRange.value.length) {
            return validatedRange.value[0][0];
          }
          return now;
        } else {
          return dayjs(props.modelValue).locale(lang.value);
        }
      });
      const calculateValidatedDateRange = (startDayjs, endDayjs) => {
        const firstDay = startDayjs.startOf("week");
        const lastDay = endDayjs.endOf("week");
        const firstMonth = firstDay.get("month");
        const lastMonth = lastDay.get("month");
        if (firstMonth === lastMonth) {
          return [[firstDay, lastDay]];
        } else if (firstMonth + 1 === lastMonth) {
          const firstMonthLastDay = firstDay.endOf("month");
          const lastMonthFirstDay = lastDay.startOf("month");
          const isSameWeek = firstMonthLastDay.isSame(lastMonthFirstDay, "week");
          const lastMonthStartDay = isSameWeek ? lastMonthFirstDay.add(1, "week") : lastMonthFirstDay;
          return [
            [firstDay, firstMonthLastDay],
            [lastMonthStartDay.startOf("week"), lastDay]
          ];
        } else if (firstMonth + 2 === lastMonth) {
          const firstMonthLastDay = firstDay.endOf("month");
          const secondMonthFirstDay = firstDay.add(1, "month").startOf("month");
          const secondMonthStartDay = firstMonthLastDay.isSame(secondMonthFirstDay, "week") ? secondMonthFirstDay.add(1, "week") : secondMonthFirstDay;
          const secondMonthLastDay = secondMonthStartDay.endOf("month");
          const lastMonthFirstDay = lastDay.startOf("month");
          const lastMonthStartDay = secondMonthLastDay.isSame(lastMonthFirstDay, "week") ? lastMonthFirstDay.add(1, "week") : lastMonthFirstDay;
          return [
            [firstDay, firstMonthLastDay],
            [secondMonthStartDay.startOf("week"), secondMonthLastDay],
            [lastMonthStartDay.startOf("week"), lastDay]
          ];
        } else {
          return [];
        }
      };
      const validatedRange = vue.computed(() => {
        if (!props.range)
          return [];
        const rangeArrDayjs = props.range.map((_) => dayjs(_).locale(lang.value));
        const [startDayjs, endDayjs] = rangeArrDayjs;
        if (startDayjs.isAfter(endDayjs)) {
          return [];
        }
        if (startDayjs.isSame(endDayjs, "month")) {
          return calculateValidatedDateRange(startDayjs, endDayjs);
        } else {
          if (startDayjs.add(1, "month").month() !== endDayjs.month()) {
            return [];
          }
          return calculateValidatedDateRange(startDayjs, endDayjs);
        }
      });
      const pickDay = (day) => {
        realSelectedDay.value = day;
      };
      const selectDate = (type) => {
        let day;
        if (type === "prev-month") {
          day = prevMonthDayjs.value;
        } else if (type === "next-month") {
          day = nextMonthDayjs.value;
        } else if (type === "prev-year") {
          day = prevYearDayjs.value;
        } else if (type === "next-year") {
          day = nextYearDayjs.value;
        } else {
          day = now;
        }
        if (day.isSame(date.value, "day"))
          return;
        pickDay(day);
      };
      return {
        selectedDay,
        curMonthDatePrefix,
        i18nDate,
        realSelectedDay,
        date,
        validatedRange,
        pickDay,
        selectDate,
        t,
        ns
      };
    }
  });
  function _sfc_render$1s(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_button = vue.resolveComponent("el-button");
    const _component_el_button_group = vue.resolveComponent("el-button-group");
    const _component_date_table = vue.resolveComponent("date-table");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(_ctx.ns.b())
    }, [
      vue.createElementVNode("div", {
        class: vue.normalizeClass(_ctx.ns.e("header"))
      }, [
        vue.renderSlot(_ctx.$slots, "header", { date: _ctx.i18nDate }, () => [
          vue.createElementVNode("div", {
            class: vue.normalizeClass(_ctx.ns.e("title"))
          }, vue.toDisplayString(_ctx.i18nDate), 3),
          _ctx.validatedRange.length === 0 ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 0,
            class: vue.normalizeClass(_ctx.ns.e("button-group"))
          }, [
            vue.createVNode(_component_el_button_group, null, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_el_button, {
                  size: "small",
                  onClick: _cache[0] || (_cache[0] = ($event) => _ctx.selectDate("prev-month"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.prevMonth")), 1)
                  ]),
                  _: 1
                }),
                vue.createVNode(_component_el_button, {
                  size: "small",
                  onClick: _cache[1] || (_cache[1] = ($event) => _ctx.selectDate("today"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.today")), 1)
                  ]),
                  _: 1
                }),
                vue.createVNode(_component_el_button, {
                  size: "small",
                  onClick: _cache[2] || (_cache[2] = ($event) => _ctx.selectDate("next-month"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.nextMonth")), 1)
                  ]),
                  _: 1
                })
              ]),
              _: 1
            })
          ], 2)) : vue.createCommentVNode("v-if", true)
        ])
      ], 2),
      _ctx.validatedRange.length === 0 ? (vue.openBlock(), vue.createElementBlock("div", {
        key: 0,
        class: vue.normalizeClass(_ctx.ns.e("body"))
      }, [
        vue.createVNode(_component_date_table, {
          date: _ctx.date,
          "selected-day": _ctx.realSelectedDay,
          onPick: _ctx.pickDay
        }, vue.createSlots({ _: 2 }, [
          _ctx.$slots.dateCell ? {
            name: "dateCell",
            fn: vue.withCtx((data) => [
              vue.renderSlot(_ctx.$slots, "dateCell", vue.normalizeProps(vue.guardReactiveProps(data)))
            ])
          } : void 0
        ]), 1032, ["date", "selected-day", "onPick"])
      ], 2)) : (vue.openBlock(), vue.createElementBlock("div", {
        key: 1,
        class: vue.normalizeClass(_ctx.ns.e("body"))
      }, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.validatedRange, (range_, index) => {
          return vue.openBlock(), vue.createBlock(_component_date_table, {
            key: index,
            date: range_[0],
            "selected-day": _ctx.realSelectedDay,
            range: range_,
            "hide-header": index !== 0,
            onPick: _ctx.pickDay
          }, vue.createSlots({ _: 2 }, [
            _ctx.$slots.dateCell ? {
              name: "dateCell",
              fn: vue.withCtx((data) => [
                vue.renderSlot(_ctx.$slots, "dateCell", vue.normalizeProps(vue.guardReactiveProps(data)))
              ])
            } : void 0
          ]), 1032, ["date", "selected-day", "range", "hide-header", "onPick"]);
        }), 128))
      ], 2))
    ], 2);
  }
  var Calendar = /* @__PURE__ */ _export_sfc(_sfc_main$1L, [["render", _sfc_render$1s]]);

  const ElCalendar = withInstall(Calendar);

  const cardProps = buildProps({
    header: {
      type: String,
      default: ""
    },
    bodyStyle: {
      type: definePropType([String, Object, Array]),
      default: ""
    },
    shadow: {
      type: String,
      default: "always"
    }
  });

  const __default__$e = {
    name: "ElCard"
  };
  const _sfc_main$1K = /* @__PURE__ */ vue.defineComponent({
    ...__default__$e,
    props: cardProps,
    setup(__props) {
      const ns = useNamespace("card");
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass([vue.unref(ns).b(), vue.unref(ns).is(`${_ctx.shadow}-shadow`)])
        }, [
          _ctx.$slots.header || _ctx.header ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 0,
            class: vue.normalizeClass(vue.unref(ns).e("header"))
          }, [
            vue.renderSlot(_ctx.$slots, "header", {}, () => [
              vue.createTextVNode(vue.toDisplayString(_ctx.header), 1)
            ])
          ], 2)) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("div", {
            class: vue.normalizeClass(vue.unref(ns).e("body")),
            style: vue.normalizeStyle(_ctx.bodyStyle)
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 6)
        ], 2);
      };
    }
  });
  var Card = _sfc_main$1K;

  const ElCard = withInstall(Card);

  const _sfc_main$1J = vue.defineComponent({
    name: "ElCarousel",
    components: {
      ElIcon,
      ArrowLeft: arrowLeft,
      ArrowRight: arrowRight
    },
    props: {
      initialIndex: {
        type: Number,
        default: 0
      },
      height: { type: String, default: "" },
      trigger: {
        type: String,
        default: "hover"
      },
      autoplay: {
        type: Boolean,
        default: true
      },
      interval: {
        type: Number,
        default: 3e3
      },
      indicatorPosition: { type: String, default: "" },
      indicator: {
        type: Boolean,
        default: true
      },
      arrow: {
        type: String,
        default: "hover"
      },
      type: { type: String, default: "" },
      loop: {
        type: Boolean,
        default: true
      },
      direction: {
        type: String,
        default: "horizontal",
        validator(val) {
          return ["horizontal", "vertical"].includes(val);
        }
      },
      pauseOnHover: {
        type: Boolean,
        default: true
      }
    },
    emits: ["change"],
    setup(props, { emit }) {
      const ns = useNamespace("carousel");
      const data = vue.reactive({
        activeIndex: -1,
        containerWidth: 0,
        timer: null,
        hover: false
      });
      const root = vue.ref(null);
      const items = vue.ref([]);
      const arrowDisplay = vue.computed(() => props.arrow !== "never" && props.direction !== "vertical");
      const hasLabel = vue.computed(() => {
        return items.value.some((item) => item.label.toString().length > 0);
      });
      const carouselClasses = vue.computed(() => {
        const classes = [ns.b(), ns.m(props.direction)];
        if (props.type === "card") {
          classes.push(ns.m("card"));
        }
        return classes;
      });
      const indicatorsClasses = vue.computed(() => {
        const classes = [ns.e("indicators"), ns.em("indicators", props.direction)];
        if (hasLabel.value) {
          classes.push(ns.em("indicators", "labels"));
        }
        if (props.indicatorPosition === "outside" || props.type === "card") {
          classes.push(ns.em("indicators", "outside"));
        }
        return classes;
      });
      const throttledArrowClick = throttle((index) => {
        setActiveItem(index);
      }, 300, { trailing: true });
      const throttledIndicatorHover = throttle((index) => {
        handleIndicatorHover(index);
      }, 300);
      function pauseTimer() {
        if (data.timer) {
          clearInterval(data.timer);
          data.timer = null;
        }
      }
      function startTimer() {
        if (props.interval <= 0 || !props.autoplay || data.timer)
          return;
        data.timer = setInterval(() => playSlides(), props.interval);
      }
      const playSlides = () => {
        if (data.activeIndex < items.value.length - 1) {
          data.activeIndex = data.activeIndex + 1;
        } else if (props.loop) {
          data.activeIndex = 0;
        }
      };
      function setActiveItem(index) {
        if (typeof index === "string") {
          const filteredItems = items.value.filter((item) => item.name === index);
          if (filteredItems.length > 0) {
            index = items.value.indexOf(filteredItems[0]);
          }
        }
        index = Number(index);
        if (Number.isNaN(index) || index !== Math.floor(index)) {
          return;
        }
        const length = items.value.length;
        const oldIndex = data.activeIndex;
        if (index < 0) {
          data.activeIndex = props.loop ? length - 1 : 0;
        } else if (index >= length) {
          data.activeIndex = props.loop ? 0 : length - 1;
        } else {
          data.activeIndex = index;
        }
        if (oldIndex === data.activeIndex) {
          resetItemPosition(oldIndex);
        }
      }
      function resetItemPosition(oldIndex) {
        items.value.forEach((item, index) => {
          item.translateItem(index, data.activeIndex, oldIndex);
        });
      }
      function addItem(item) {
        items.value.push(item);
      }
      function removeItem(uid) {
        const index = items.value.findIndex((item) => item.uid === uid);
        if (index !== -1) {
          items.value.splice(index, 1);
          if (data.activeIndex === index)
            next();
        }
      }
      function itemInStage(item, index) {
        const length = items.value.length;
        if (index === length - 1 && item.inStage && items.value[0].active || item.inStage && items.value[index + 1] && items.value[index + 1].active) {
          return "left";
        } else if (index === 0 && item.inStage && items.value[length - 1].active || item.inStage && items.value[index - 1] && items.value[index - 1].active) {
          return "right";
        }
        return false;
      }
      function handleMouseEnter() {
        data.hover = true;
        if (props.pauseOnHover) {
          pauseTimer();
        }
      }
      function handleMouseLeave() {
        data.hover = false;
        startTimer();
      }
      function handleButtonEnter(arrow) {
        if (props.direction === "vertical")
          return;
        items.value.forEach((item, index) => {
          if (arrow === itemInStage(item, index)) {
            item.hover = true;
          }
        });
      }
      function handleButtonLeave() {
        if (props.direction === "vertical")
          return;
        items.value.forEach((item) => {
          item.hover = false;
        });
      }
      function handleIndicatorClick(index) {
        data.activeIndex = index;
      }
      function handleIndicatorHover(index) {
        if (props.trigger === "hover" && index !== data.activeIndex) {
          data.activeIndex = index;
        }
      }
      function prev() {
        setActiveItem(data.activeIndex - 1);
      }
      function next() {
        setActiveItem(data.activeIndex + 1);
      }
      vue.watch(() => data.activeIndex, (current, prev2) => {
        resetItemPosition(prev2);
        if (prev2 > -1) {
          emit("change", current, prev2);
        }
      });
      vue.watch(() => props.autoplay, (current) => {
        current ? startTimer() : pauseTimer();
      });
      vue.watch(() => props.loop, () => {
        setActiveItem(data.activeIndex);
      });
      vue.onMounted(() => {
        vue.nextTick(() => {
          addResizeListener(root.value, resetItemPosition);
          if (props.initialIndex < items.value.length && props.initialIndex >= 0) {
            data.activeIndex = props.initialIndex;
          }
          startTimer();
        });
      });
      vue.onBeforeUnmount(() => {
        if (root.value)
          removeResizeListener(root.value, resetItemPosition);
        pauseTimer();
      });
      vue.provide("injectCarouselScope", {
        root,
        direction: props.direction,
        type: props.type,
        items,
        loop: props.loop,
        addItem,
        removeItem,
        setActiveItem
      });
      return {
        data,
        props,
        items,
        arrowDisplay,
        carouselClasses,
        indicatorsClasses,
        hasLabel,
        handleMouseEnter,
        handleMouseLeave,
        handleIndicatorClick,
        throttledArrowClick,
        throttledIndicatorHover,
        handleButtonEnter,
        handleButtonLeave,
        prev,
        next,
        setActiveItem,
        root,
        ns
      };
    }
  });
  const _hoisted_1$Q = ["onMouseenter", "onClick"];
  const _hoisted_2$A = { key: 0 };
  function _sfc_render$1r(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_arrow_left = vue.resolveComponent("arrow-left");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_arrow_right = vue.resolveComponent("arrow-right");
    return vue.openBlock(), vue.createElementBlock("div", {
      ref: "root",
      class: vue.normalizeClass(_ctx.carouselClasses),
      onMouseenter: _cache[6] || (_cache[6] = vue.withModifiers((...args) => _ctx.handleMouseEnter && _ctx.handleMouseEnter(...args), ["stop"])),
      onMouseleave: _cache[7] || (_cache[7] = vue.withModifiers((...args) => _ctx.handleMouseLeave && _ctx.handleMouseLeave(...args), ["stop"]))
    }, [
      vue.createElementVNode("div", {
        class: vue.normalizeClass(_ctx.ns.e("container")),
        style: vue.normalizeStyle({ height: _ctx.height })
      }, [
        _ctx.arrowDisplay ? (vue.openBlock(), vue.createBlock(vue.Transition, {
          key: 0,
          name: "carousel-arrow-left"
        }, {
          default: vue.withCtx(() => [
            vue.withDirectives(vue.createElementVNode("button", {
              type: "button",
              class: vue.normalizeClass([_ctx.ns.e("arrow"), _ctx.ns.em("arrow", "left")]),
              onMouseenter: _cache[0] || (_cache[0] = ($event) => _ctx.handleButtonEnter("left")),
              onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.handleButtonLeave && _ctx.handleButtonLeave(...args)),
              onClick: _cache[2] || (_cache[2] = vue.withModifiers(($event) => _ctx.throttledArrowClick(_ctx.data.activeIndex - 1), ["stop"]))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_left)
                ]),
                _: 1
              })
            ], 34), [
              [
                vue.vShow,
                (_ctx.arrow === "always" || _ctx.data.hover) && (_ctx.props.loop || _ctx.data.activeIndex > 0)
              ]
            ])
          ]),
          _: 1
        })) : vue.createCommentVNode("v-if", true),
        _ctx.arrowDisplay ? (vue.openBlock(), vue.createBlock(vue.Transition, {
          key: 1,
          name: "carousel-arrow-right"
        }, {
          default: vue.withCtx(() => [
            vue.withDirectives(vue.createElementVNode("button", {
              type: "button",
              class: vue.normalizeClass([_ctx.ns.e("arrow"), _ctx.ns.em("arrow", "right")]),
              onMouseenter: _cache[3] || (_cache[3] = ($event) => _ctx.handleButtonEnter("right")),
              onMouseleave: _cache[4] || (_cache[4] = (...args) => _ctx.handleButtonLeave && _ctx.handleButtonLeave(...args)),
              onClick: _cache[5] || (_cache[5] = vue.withModifiers(($event) => _ctx.throttledArrowClick(_ctx.data.activeIndex + 1), ["stop"]))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_right)
                ]),
                _: 1
              })
            ], 34), [
              [
                vue.vShow,
                (_ctx.arrow === "always" || _ctx.data.hover) && (_ctx.props.loop || _ctx.data.activeIndex < _ctx.items.length - 1)
              ]
            ])
          ]),
          _: 1
        })) : vue.createCommentVNode("v-if", true),
        vue.renderSlot(_ctx.$slots, "default")
      ], 6),
      _ctx.indicatorPosition !== "none" ? (vue.openBlock(), vue.createElementBlock("ul", {
        key: 0,
        class: vue.normalizeClass(_ctx.indicatorsClasses)
      }, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.items, (item, index) => {
          return vue.openBlock(), vue.createElementBlock("li", {
            key: index,
            class: vue.normalizeClass([
              _ctx.ns.e("indicator"),
              _ctx.ns.em("indicator", _ctx.direction),
              _ctx.ns.is("active", index === _ctx.data.activeIndex)
            ]),
            onMouseenter: ($event) => _ctx.throttledIndicatorHover(index),
            onClick: vue.withModifiers(($event) => _ctx.handleIndicatorClick(index), ["stop"])
          }, [
            vue.createElementVNode("button", {
              class: vue.normalizeClass(_ctx.ns.e("button"))
            }, [
              _ctx.hasLabel ? (vue.openBlock(), vue.createElementBlock("span", _hoisted_2$A, vue.toDisplayString(item.label), 1)) : vue.createCommentVNode("v-if", true)
            ], 2)
          ], 42, _hoisted_1$Q);
        }), 128))
      ], 2)) : vue.createCommentVNode("v-if", true)
    ], 34);
  }
  var Carousel = /* @__PURE__ */ _export_sfc(_sfc_main$1J, [["render", _sfc_render$1r]]);

  const CARD_SCALE = 0.83;
  const _sfc_main$1I = vue.defineComponent({
    name: "ElCarouselItem",
    props: {
      name: { type: String, default: "" },
      label: {
        type: [String, Number],
        default: ""
      }
    },
    setup(props) {
      const ns = useNamespace("carousel");
      const instance = vue.getCurrentInstance();
      const data = vue.reactive({
        hover: false,
        translate: 0,
        scale: 1,
        active: false,
        ready: false,
        inStage: false,
        animating: false
      });
      const injectCarouselScope = vue.inject("injectCarouselScope");
      const parentDirection = vue.computed(() => {
        return injectCarouselScope.direction;
      });
      const itemStyle = vue.computed(() => {
        const translateType = parentDirection.value === "vertical" ? "translateY" : "translateX";
        const value = `${translateType}(${data.translate}px) scale(${data.scale})`;
        const style = {
          transform: value
        };
        return style;
      });
      function processIndex(index, activeIndex, length) {
        if (activeIndex === 0 && index === length - 1) {
          return -1;
        } else if (activeIndex === length - 1 && index === 0) {
          return length;
        } else if (index < activeIndex - 1 && activeIndex - index >= length / 2) {
          return length + 1;
        } else if (index > activeIndex + 1 && index - activeIndex >= length / 2) {
          return -2;
        }
        return index;
      }
      function calcCardTranslate(index, activeIndex) {
        var _a;
        const parentWidth = ((_a = injectCarouselScope.root.value) == null ? void 0 : _a.offsetWidth) || 0;
        if (data.inStage) {
          return parentWidth * ((2 - CARD_SCALE) * (index - activeIndex) + 1) / 4;
        } else if (index < activeIndex) {
          return -(1 + CARD_SCALE) * parentWidth / 4;
        } else {
          return (3 + CARD_SCALE) * parentWidth / 4;
        }
      }
      function calcTranslate(index, activeIndex, isVertical) {
        var _a, _b;
        const distance = (isVertical ? (_a = injectCarouselScope.root.value) == null ? void 0 : _a.offsetHeight : (_b = injectCarouselScope.root.value) == null ? void 0 : _b.offsetWidth) || 0;
        return distance * (index - activeIndex);
      }
      const translateItem = (index, activeIndex, oldIndex) => {
        const parentType = injectCarouselScope.type;
        const length = injectCarouselScope.items.value.length;
        if (parentType !== "card" && oldIndex !== void 0) {
          data.animating = index === activeIndex || index === oldIndex;
        }
        if (index !== activeIndex && length > 2 && injectCarouselScope.loop) {
          index = processIndex(index, activeIndex, length);
        }
        if (parentType === "card") {
          if (parentDirection.value === "vertical") ;
          data.inStage = Math.round(Math.abs(index - activeIndex)) <= 1;
          data.active = index === activeIndex;
          data.translate = calcCardTranslate(index, activeIndex);
          data.scale = data.active ? 1 : CARD_SCALE;
        } else {
          data.active = index === activeIndex;
          const isVertical = parentDirection.value === "vertical";
          data.translate = calcTranslate(index, activeIndex, isVertical);
        }
        data.ready = true;
      };
      function handleItemClick() {
        if (injectCarouselScope && injectCarouselScope.type === "card") {
          const index = injectCarouselScope.items.value.map((d) => d.uid).indexOf(instance.uid);
          injectCarouselScope.setActiveItem(index);
        }
      }
      vue.onMounted(() => {
        if (injectCarouselScope.addItem) {
          injectCarouselScope.addItem({
            uid: instance.uid,
            ...props,
            ...vue.toRefs(data),
            translateItem
          });
        }
      });
      vue.onUnmounted(() => {
        if (injectCarouselScope.removeItem) {
          injectCarouselScope.removeItem(instance.uid);
        }
      });
      return {
        data,
        itemStyle,
        translateItem,
        type: injectCarouselScope.type,
        handleItemClick,
        ns
      };
    }
  });
  function _sfc_render$1q(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([
        _ctx.ns.e("item"),
        _ctx.ns.is("active", _ctx.data.active),
        _ctx.ns.is("in-stage", _ctx.data.inStage),
        _ctx.ns.is("hover", _ctx.data.hover),
        _ctx.ns.is("animating", _ctx.data.animating),
        { [_ctx.ns.em("item", "card")]: _ctx.type === "card" }
      ]),
      style: vue.normalizeStyle(_ctx.itemStyle),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleItemClick && _ctx.handleItemClick(...args))
    }, [
      _ctx.type === "card" ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
        key: 0,
        class: vue.normalizeClass(_ctx.ns.e("mask"))
      }, null, 2)), [
        [vue.vShow, !_ctx.data.active]
      ]) : vue.createCommentVNode("v-if", true),
      vue.renderSlot(_ctx.$slots, "default")
    ], 6)), [
      [vue.vShow, _ctx.data.ready]
    ]);
  }
  var CarouselItem = /* @__PURE__ */ _export_sfc(_sfc_main$1I, [["render", _sfc_render$1q]]);

  const ElCarousel = withInstall(Carousel, {
    CarouselItem
  });
  const ElCarouselItem = withNoopInstall(CarouselItem);

  const useCheckboxProps = {
    modelValue: {
      type: [Boolean, Number, String],
      default: () => void 0
    },
    label: {
      type: [String, Boolean, Number, Object]
    },
    indeterminate: Boolean,
    disabled: Boolean,
    checked: Boolean,
    name: {
      type: String,
      default: void 0
    },
    trueLabel: {
      type: [String, Number],
      default: void 0
    },
    falseLabel: {
      type: [String, Number],
      default: void 0
    },
    tabindex: [String, Number],
    size: String
  };
  const useCheckboxGroup = () => {
    const elForm = vue.inject(formContextKey, {});
    const elFormItem = vue.inject(formItemContextKey, {});
    const checkboxGroup = vue.inject("CheckboxGroup", {});
    const isGroup = vue.computed(() => checkboxGroup && (checkboxGroup == null ? void 0 : checkboxGroup.name) === "ElCheckboxGroup");
    const elFormItemSize = vue.computed(() => {
      return elFormItem.size;
    });
    return {
      isGroup,
      checkboxGroup,
      elForm,
      elFormItemSize,
      elFormItem
    };
  };
  const useModel = (props) => {
    const selfModel = vue.ref(false);
    const { emit } = vue.getCurrentInstance();
    const { isGroup, checkboxGroup } = useCheckboxGroup();
    const isLimitExceeded = vue.ref(false);
    const model = vue.computed({
      get() {
        var _a, _b;
        return isGroup.value ? (_a = checkboxGroup.modelValue) == null ? void 0 : _a.value : (_b = props.modelValue) != null ? _b : selfModel.value;
      },
      set(val) {
        var _a;
        if (isGroup.value && Array.isArray(val)) {
          isLimitExceeded.value = checkboxGroup.max !== void 0 && val.length > checkboxGroup.max.value;
          isLimitExceeded.value === false && ((_a = checkboxGroup == null ? void 0 : checkboxGroup.changeEvent) == null ? void 0 : _a.call(checkboxGroup, val));
        } else {
          emit(UPDATE_MODEL_EVENT, val);
          selfModel.value = val;
        }
      }
    });
    return {
      model,
      isLimitExceeded
    };
  };
  const useCheckboxStatus = (props, { model }) => {
    const { isGroup, checkboxGroup } = useCheckboxGroup();
    const focus = vue.ref(false);
    const size = useSize(checkboxGroup == null ? void 0 : checkboxGroup.checkboxGroupSize, { prop: true });
    const isChecked = vue.computed(() => {
      const value = model.value;
      if (toTypeString(value) === "[object Boolean]") {
        return value;
      } else if (Array.isArray(value)) {
        return value.includes(props.label);
      } else if (value !== null && value !== void 0) {
        return value === props.trueLabel;
      } else {
        return !!value;
      }
    });
    const checkboxSize = useSize(vue.computed(() => {
      var _a;
      return isGroup.value ? (_a = checkboxGroup == null ? void 0 : checkboxGroup.checkboxGroupSize) == null ? void 0 : _a.value : void 0;
    }));
    return {
      isChecked,
      focus,
      size,
      checkboxSize
    };
  };
  const useDisabled = (props, {
    model,
    isChecked
  }) => {
    const { elForm, isGroup, checkboxGroup } = useCheckboxGroup();
    const isLimitDisabled = vue.computed(() => {
      var _a, _b;
      const max = (_a = checkboxGroup.max) == null ? void 0 : _a.value;
      const min = (_b = checkboxGroup.min) == null ? void 0 : _b.value;
      return !!(max || min) && model.value.length >= max && !isChecked.value || model.value.length <= min && isChecked.value;
    });
    const isDisabled = vue.computed(() => {
      var _a, _b;
      const disabled = props.disabled || elForm.disabled;
      return (_b = isGroup.value ? ((_a = checkboxGroup.disabled) == null ? void 0 : _a.value) || disabled || isLimitDisabled.value : props.disabled || elForm.disabled) != null ? _b : false;
    });
    return {
      isDisabled,
      isLimitDisabled
    };
  };
  const setStoreValue = (props, { model }) => {
    function addToStore() {
      if (Array.isArray(model.value) && !model.value.includes(props.label)) {
        model.value.push(props.label);
      } else {
        model.value = props.trueLabel || true;
      }
    }
    props.checked && addToStore();
  };
  const useEvent$1 = (props, { isLimitExceeded }) => {
    const { elFormItem } = useCheckboxGroup();
    const { emit } = vue.getCurrentInstance();
    function handleChange(e) {
      var _a, _b;
      if (isLimitExceeded.value)
        return;
      const target = e.target;
      const value = target.checked ? (_a = props.trueLabel) != null ? _a : true : (_b = props.falseLabel) != null ? _b : false;
      emit("change", value, e);
    }
    vue.watch(() => props.modelValue, () => {
      var _a;
      (_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
    });
    return {
      handleChange
    };
  };
  const useCheckbox = (props) => {
    const { model, isLimitExceeded } = useModel(props);
    const { focus, size, isChecked, checkboxSize } = useCheckboxStatus(props, {
      model
    });
    const { isDisabled } = useDisabled(props, { model, isChecked });
    const { handleChange } = useEvent$1(props, { isLimitExceeded });
    setStoreValue(props, { model });
    return {
      isChecked,
      isDisabled,
      checkboxSize,
      model,
      handleChange,
      focus,
      size
    };
  };

  const _sfc_main$1H = vue.defineComponent({
    name: "ElCheckbox",
    props: {
      modelValue: {
        type: [Number, String, Boolean],
        default: () => void 0
      },
      label: {
        type: [String, Boolean, Number, Object]
      },
      indeterminate: Boolean,
      disabled: Boolean,
      checked: Boolean,
      name: {
        type: String,
        default: void 0
      },
      trueLabel: {
        type: [String, Number],
        default: void 0
      },
      falseLabel: {
        type: [String, Number],
        default: void 0
      },
      id: {
        type: String,
        default: void 0
      },
      controls: {
        type: String,
        default: void 0
      },
      border: Boolean,
      size: {
        type: String,
        validator: isValidComponentSize
      },
      tabindex: [String, Number]
    },
    emits: [UPDATE_MODEL_EVENT, "change"],
    setup(props) {
      const ns = useNamespace("checkbox");
      return {
        ns,
        ...useCheckbox(props)
      };
    }
  });
  const _hoisted_1$P = ["id", "aria-controls"];
  const _hoisted_2$z = ["tabindex", "role", "aria-checked"];
  const _hoisted_3$l = ["aria-hidden", "name", "tabindex", "disabled", "true-value", "false-value"];
  const _hoisted_4$e = ["aria-hidden", "disabled", "value", "name", "tabindex"];
  function _sfc_render$1p(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("label", {
      id: _ctx.id,
      class: vue.normalizeClass([
        _ctx.ns.b(),
        _ctx.ns.m(_ctx.checkboxSize),
        _ctx.ns.is("disabled", _ctx.isDisabled),
        _ctx.ns.is("bordered", _ctx.border),
        _ctx.ns.is("checked", _ctx.isChecked)
      ]),
      "aria-controls": _ctx.indeterminate ? _ctx.controls : null
    }, [
      vue.createElementVNode("span", {
        class: vue.normalizeClass([
          _ctx.ns.e("input"),
          _ctx.ns.is("disabled", _ctx.isDisabled),
          _ctx.ns.is("checked", _ctx.isChecked),
          _ctx.ns.is("indeterminate", _ctx.indeterminate),
          _ctx.ns.is("focus", _ctx.focus)
        ]),
        tabindex: _ctx.indeterminate ? 0 : void 0,
        role: _ctx.indeterminate ? "checkbox" : void 0,
        "aria-checked": _ctx.indeterminate ? "mixed" : false
      }, [
        vue.createElementVNode("span", {
          class: vue.normalizeClass(_ctx.ns.e("inner"))
        }, null, 2),
        _ctx.trueLabel || _ctx.falseLabel ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
          key: 0,
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.model = $event),
          class: vue.normalizeClass(_ctx.ns.e("original")),
          type: "checkbox",
          "aria-hidden": _ctx.indeterminate ? "true" : "false",
          name: _ctx.name,
          tabindex: _ctx.tabindex,
          disabled: _ctx.isDisabled,
          "true-value": _ctx.trueLabel,
          "false-value": _ctx.falseLabel,
          onChange: _cache[1] || (_cache[1] = (...args) => _ctx.handleChange && _ctx.handleChange(...args)),
          onFocus: _cache[2] || (_cache[2] = ($event) => _ctx.focus = true),
          onBlur: _cache[3] || (_cache[3] = ($event) => _ctx.focus = false)
        }, null, 42, _hoisted_3$l)), [
          [vue.vModelCheckbox, _ctx.model]
        ]) : vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
          key: 1,
          "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.model = $event),
          class: vue.normalizeClass(_ctx.ns.e("original")),
          type: "checkbox",
          "aria-hidden": _ctx.indeterminate ? "true" : "false",
          disabled: _ctx.isDisabled,
          value: _ctx.label,
          name: _ctx.name,
          tabindex: _ctx.tabindex,
          onChange: _cache[5] || (_cache[5] = (...args) => _ctx.handleChange && _ctx.handleChange(...args)),
          onFocus: _cache[6] || (_cache[6] = ($event) => _ctx.focus = true),
          onBlur: _cache[7] || (_cache[7] = ($event) => _ctx.focus = false)
        }, null, 42, _hoisted_4$e)), [
          [vue.vModelCheckbox, _ctx.model]
        ])
      ], 10, _hoisted_2$z),
      _ctx.$slots.default || _ctx.label ? (vue.openBlock(), vue.createElementBlock("span", {
        key: 0,
        class: vue.normalizeClass(_ctx.ns.e("label"))
      }, [
        vue.renderSlot(_ctx.$slots, "default"),
        !_ctx.$slots.default ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
          vue.createTextVNode(vue.toDisplayString(_ctx.label), 1)
        ], 2112)) : vue.createCommentVNode("v-if", true)
      ], 2)) : vue.createCommentVNode("v-if", true)
    ], 10, _hoisted_1$P);
  }
  var Checkbox = /* @__PURE__ */ _export_sfc(_sfc_main$1H, [["render", _sfc_render$1p]]);

  const _sfc_main$1G = vue.defineComponent({
    name: "ElCheckboxButton",
    props: useCheckboxProps,
    emits: [UPDATE_MODEL_EVENT, "change"],
    setup(props) {
      const { focus, isChecked, isDisabled, size, model, handleChange } = useCheckbox(props);
      const { checkboxGroup } = useCheckboxGroup();
      const ns = useNamespace("checkbox");
      const activeStyle = vue.computed(() => {
        var _a, _b, _c, _d;
        const fillValue = (_b = (_a = checkboxGroup == null ? void 0 : checkboxGroup.fill) == null ? void 0 : _a.value) != null ? _b : "";
        return {
          backgroundColor: fillValue,
          borderColor: fillValue,
          color: (_d = (_c = checkboxGroup == null ? void 0 : checkboxGroup.textColor) == null ? void 0 : _c.value) != null ? _d : "",
          boxShadow: fillValue ? `-1px 0 0 0 ${fillValue}` : null
        };
      });
      return {
        focus,
        isChecked,
        isDisabled,
        model,
        handleChange,
        activeStyle,
        size,
        ns
      };
    }
  });
  const _hoisted_1$O = ["aria-checked", "aria-disabled"];
  const _hoisted_2$y = ["name", "tabindex", "disabled", "true-value", "false-value"];
  const _hoisted_3$k = ["name", "tabindex", "disabled", "value"];
  function _sfc_render$1o(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("label", {
      class: vue.normalizeClass([
        _ctx.ns.b("button"),
        _ctx.ns.bm("button", _ctx.size),
        _ctx.ns.is("disabled", _ctx.isDisabled),
        _ctx.ns.is("checked", _ctx.isChecked),
        _ctx.ns.is("focus", _ctx.focus)
      ]),
      role: "checkbox",
      "aria-checked": _ctx.isChecked,
      "aria-disabled": _ctx.isDisabled
    }, [
      _ctx.trueLabel || _ctx.falseLabel ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
        key: 0,
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.model = $event),
        class: vue.normalizeClass(_ctx.ns.be("button", "original")),
        type: "checkbox",
        name: _ctx.name,
        tabindex: _ctx.tabindex,
        disabled: _ctx.isDisabled,
        "true-value": _ctx.trueLabel,
        "false-value": _ctx.falseLabel,
        onChange: _cache[1] || (_cache[1] = (...args) => _ctx.handleChange && _ctx.handleChange(...args)),
        onFocus: _cache[2] || (_cache[2] = ($event) => _ctx.focus = true),
        onBlur: _cache[3] || (_cache[3] = ($event) => _ctx.focus = false)
      }, null, 42, _hoisted_2$y)), [
        [vue.vModelCheckbox, _ctx.model]
      ]) : vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
        key: 1,
        "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.model = $event),
        class: vue.normalizeClass(_ctx.ns.be("button", "original")),
        type: "checkbox",
        name: _ctx.name,
        tabindex: _ctx.tabindex,
        disabled: _ctx.isDisabled,
        value: _ctx.label,
        onChange: _cache[5] || (_cache[5] = (...args) => _ctx.handleChange && _ctx.handleChange(...args)),
        onFocus: _cache[6] || (_cache[6] = ($event) => _ctx.focus = true),
        onBlur: _cache[7] || (_cache[7] = ($event) => _ctx.focus = false)
      }, null, 42, _hoisted_3$k)), [
        [vue.vModelCheckbox, _ctx.model]
      ]),
      _ctx.$slots.default || _ctx.label ? (vue.openBlock(), vue.createElementBlock("span", {
        key: 2,
        class: vue.normalizeClass(_ctx.ns.be("button", "inner")),
        style: vue.normalizeStyle(_ctx.isChecked ? _ctx.activeStyle : null)
      }, [
        vue.renderSlot(_ctx.$slots, "default", {}, () => [
          vue.createTextVNode(vue.toDisplayString(_ctx.label), 1)
        ])
      ], 6)) : vue.createCommentVNode("v-if", true)
    ], 10, _hoisted_1$O);
  }
  var CheckboxButton = /* @__PURE__ */ _export_sfc(_sfc_main$1G, [["render", _sfc_render$1o]]);

  const _sfc_main$1F = vue.defineComponent({
    name: "ElCheckboxGroup",
    props: {
      modelValue: {
        type: Array,
        default: () => []
      },
      disabled: Boolean,
      min: {
        type: Number,
        default: void 0
      },
      max: {
        type: Number,
        default: void 0
      },
      size: {
        type: String,
        validator: isValidComponentSize
      },
      fill: {
        type: String,
        default: void 0
      },
      textColor: {
        type: String,
        default: void 0
      },
      tag: {
        type: String,
        default: "div"
      }
    },
    emits: [UPDATE_MODEL_EVENT, "change"],
    setup(props, { emit, slots }) {
      const { elFormItem } = useCheckboxGroup();
      const checkboxGroupSize = useSize();
      const ns = useNamespace("checkbox");
      const changeEvent = (value) => {
        emit(UPDATE_MODEL_EVENT, value);
        vue.nextTick(() => {
          emit("change", value);
        });
      };
      const modelValue = vue.computed({
        get() {
          return props.modelValue;
        },
        set(val) {
          changeEvent(val);
        }
      });
      vue.provide("CheckboxGroup", {
        name: "ElCheckboxGroup",
        modelValue,
        ...vue.toRefs(props),
        checkboxGroupSize,
        changeEvent
      });
      vue.watch(() => props.modelValue, () => {
        var _a;
        (_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
      });
      return () => {
        return vue.h(props.tag, {
          class: ns.b("group"),
          role: "group",
          "aria-label": "checkbox-group"
        }, [vue.renderSlot(slots, "default")]);
      };
    }
  });
  var CheckboxGroup = _sfc_main$1F;

  const ElCheckbox = withInstall(Checkbox, {
    CheckboxButton,
    CheckboxGroup
  });
  const ElCheckboxButton = withNoopInstall(CheckboxButton);
  const ElCheckboxGroup$1 = withNoopInstall(CheckboxGroup);

  const radioPropsBase = buildProps({
    size: useSizeProp,
    disabled: Boolean,
    label: {
      type: [String, Number, Boolean],
      default: ""
    }
  });
  const radioProps = buildProps({
    ...radioPropsBase,
    modelValue: {
      type: [String, Number, Boolean],
      default: ""
    },
    name: {
      type: String,
      default: ""
    },
    border: Boolean
  });
  const radioEmits = {
    [UPDATE_MODEL_EVENT]: (val) => isString(val) || isNumber(val) || isBoolean(val),
    change: (val) => isString(val) || isNumber(val) || isBoolean(val)
  };
  const useRadio = (props, emit) => {
    const radioRef = vue.ref();
    const radioGroup = vue.inject(radioGroupKey, void 0);
    const isGroup = vue.computed(() => !!radioGroup);
    const modelValue = vue.computed({
      get() {
        return isGroup.value ? radioGroup.modelValue : props.modelValue;
      },
      set(val) {
        if (isGroup.value) {
          radioGroup.changeEvent(val);
        } else {
          emit(UPDATE_MODEL_EVENT, val);
        }
        radioRef.value.checked = props.modelValue === props.label;
      }
    });
    const size = useSize(vue.computed(() => radioGroup == null ? void 0 : radioGroup.size));
    const disabled = useDisabled$1(vue.computed(() => radioGroup == null ? void 0 : radioGroup.disabled));
    const focus = vue.ref(false);
    const tabIndex = vue.computed(() => {
      return disabled.value || isGroup.value && modelValue.value !== props.label ? -1 : 0;
    });
    return {
      radioRef,
      isGroup,
      radioGroup,
      focus,
      size,
      disabled,
      tabIndex,
      modelValue
    };
  };

  const _sfc_main$1E = vue.defineComponent({
    name: "ElRadio",
    props: radioProps,
    emits: radioEmits,
    setup(props, { emit }) {
      const ns = useNamespace("radio");
      const { radioRef, isGroup, focus, size, disabled, tabIndex, modelValue } = useRadio(props, emit);
      function handleChange() {
        vue.nextTick(() => emit("change", modelValue.value));
      }
      return {
        ns,
        focus,
        isGroup,
        modelValue,
        tabIndex,
        size,
        disabled,
        radioRef,
        handleChange
      };
    }
  });
  const _hoisted_1$N = ["aria-checked", "aria-disabled", "tabindex"];
  const _hoisted_2$x = ["value", "name", "disabled"];
  function _sfc_render$1n(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("label", {
      class: vue.normalizeClass([
        _ctx.ns.b(),
        _ctx.ns.is("disabled", _ctx.disabled),
        _ctx.ns.is("focus", _ctx.focus),
        _ctx.ns.is("bordered", _ctx.border),
        _ctx.ns.is("checked", _ctx.modelValue === _ctx.label),
        _ctx.ns.m(_ctx.size)
      ]),
      role: "radio",
      "aria-checked": _ctx.modelValue === _ctx.label,
      "aria-disabled": _ctx.disabled,
      tabindex: _ctx.tabIndex,
      onKeydown: _cache[5] || (_cache[5] = vue.withKeys(vue.withModifiers(($event) => _ctx.modelValue = _ctx.disabled ? _ctx.modelValue : _ctx.label, ["stop", "prevent"]), ["space"]))
    }, [
      vue.createElementVNode("span", {
        class: vue.normalizeClass([
          _ctx.ns.e("input"),
          _ctx.ns.is("disabled", _ctx.disabled),
          _ctx.ns.is("checked", _ctx.modelValue === _ctx.label)
        ])
      }, [
        vue.createElementVNode("span", {
          class: vue.normalizeClass(_ctx.ns.e("inner"))
        }, null, 2),
        vue.withDirectives(vue.createElementVNode("input", {
          ref: "radioRef",
          "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.modelValue = $event),
          class: vue.normalizeClass(_ctx.ns.e("original")),
          value: _ctx.label,
          type: "radio",
          "aria-hidden": "true",
          name: _ctx.name,
          disabled: _ctx.disabled,
          tabindex: "-1",
          onFocus: _cache[1] || (_cache[1] = ($event) => _ctx.focus = true),
          onBlur: _cache[2] || (_cache[2] = ($event) => _ctx.focus = false),
          onChange: _cache[3] || (_cache[3] = (...args) => _ctx.handleChange && _ctx.handleChange(...args))
        }, null, 42, _hoisted_2$x), [
          [vue.vModelRadio, _ctx.modelValue]
        ])
      ], 2),
      vue.createElementVNode("span", {
        class: vue.normalizeClass(_ctx.ns.e("label")),
        onKeydown: _cache[4] || (_cache[4] = vue.withModifiers(() => {
        }, ["stop"]))
      }, [
        vue.renderSlot(_ctx.$slots, "default", {}, () => [
          vue.createTextVNode(vue.toDisplayString(_ctx.label), 1)
        ])
      ], 34)
    ], 42, _hoisted_1$N);
  }
  var Radio = /* @__PURE__ */ _export_sfc(_sfc_main$1E, [["render", _sfc_render$1n]]);

  const radioButtonProps = buildProps({
    ...radioPropsBase,
    name: {
      type: String,
      default: ""
    }
  });

  const _sfc_main$1D = vue.defineComponent({
    name: "ElRadioButton",
    props: radioButtonProps,
    setup(props, { emit }) {
      const ns = useNamespace("radio");
      const {
        radioRef,
        isGroup,
        focus,
        size,
        disabled,
        tabIndex,
        modelValue,
        radioGroup
      } = useRadio(props, emit);
      const activeStyle = vue.computed(() => {
        return {
          backgroundColor: (radioGroup == null ? void 0 : radioGroup.fill) || "",
          borderColor: (radioGroup == null ? void 0 : radioGroup.fill) || "",
          boxShadow: (radioGroup == null ? void 0 : radioGroup.fill) ? `-1px 0 0 0 ${radioGroup.fill}` : "",
          color: (radioGroup == null ? void 0 : radioGroup.textColor) || ""
        };
      });
      return {
        ns,
        isGroup,
        size,
        disabled,
        tabIndex,
        modelValue,
        focus,
        activeStyle,
        radioRef
      };
    }
  });
  const _hoisted_1$M = ["aria-checked", "aria-disabled", "tabindex"];
  const _hoisted_2$w = ["value", "name", "disabled"];
  function _sfc_render$1m(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("label", {
      class: vue.normalizeClass([
        _ctx.ns.b("button"),
        _ctx.ns.is("active", _ctx.modelValue === _ctx.label),
        _ctx.ns.is("disabled", _ctx.disabled),
        _ctx.ns.is("focus", _ctx.focus),
        _ctx.ns.bm("button", _ctx.size)
      ]),
      role: "radio",
      "aria-checked": _ctx.modelValue === _ctx.label,
      "aria-disabled": _ctx.disabled,
      tabindex: _ctx.tabIndex,
      onKeydown: _cache[4] || (_cache[4] = vue.withKeys(vue.withModifiers(($event) => _ctx.modelValue = _ctx.disabled ? _ctx.modelValue : _ctx.label, ["stop", "prevent"]), ["space"]))
    }, [
      vue.withDirectives(vue.createElementVNode("input", {
        ref: "radioRef",
        "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.modelValue = $event),
        class: vue.normalizeClass(_ctx.ns.be("button", "original-radio")),
        value: _ctx.label,
        type: "radio",
        name: _ctx.name,
        disabled: _ctx.disabled,
        tabindex: "-1",
        onFocus: _cache[1] || (_cache[1] = ($event) => _ctx.focus = true),
        onBlur: _cache[2] || (_cache[2] = ($event) => _ctx.focus = false)
      }, null, 42, _hoisted_2$w), [
        [vue.vModelRadio, _ctx.modelValue]
      ]),
      vue.createElementVNode("span", {
        class: vue.normalizeClass(_ctx.ns.be("button", "inner")),
        style: vue.normalizeStyle(_ctx.modelValue === _ctx.label ? _ctx.activeStyle : {}),
        onKeydown: _cache[3] || (_cache[3] = vue.withModifiers(() => {
        }, ["stop"]))
      }, [
        vue.renderSlot(_ctx.$slots, "default", {}, () => [
          vue.createTextVNode(vue.toDisplayString(_ctx.label), 1)
        ])
      ], 38)
    ], 42, _hoisted_1$M);
  }
  var RadioButton = /* @__PURE__ */ _export_sfc(_sfc_main$1D, [["render", _sfc_render$1m]]);

  const radioGroupProps = buildProps({
    size: useSizeProp,
    disabled: Boolean,
    modelValue: {
      type: [String, Number, Boolean],
      default: ""
    },
    fill: {
      type: String,
      default: ""
    },
    textColor: {
      type: String,
      default: ""
    }
  });
  const radioGroupEmits = radioEmits;

  const _sfc_main$1C = vue.defineComponent({
    name: "ElRadioGroup",
    props: radioGroupProps,
    emits: radioGroupEmits,
    setup(props, ctx) {
      const ns = useNamespace("radio");
      const radioGroupRef = vue.ref();
      const { formItem } = useFormItem();
      const changeEvent = (value) => {
        ctx.emit(UPDATE_MODEL_EVENT, value);
        vue.nextTick(() => ctx.emit("change", value));
      };
      const handleKeydown = (e) => {
        if (!radioGroupRef.value)
          return;
        const target = e.target;
        const className = target.nodeName === "INPUT" ? "[type=radio]" : "[role=radio]";
        const radios = radioGroupRef.value.querySelectorAll(className);
        const length = radios.length;
        const index = Array.from(radios).indexOf(target);
        const roleRadios = radioGroupRef.value.querySelectorAll("[role=radio]");
        let nextIndex = null;
        switch (e.code) {
          case EVENT_CODE.left:
          case EVENT_CODE.up:
            e.stopPropagation();
            e.preventDefault();
            nextIndex = index === 0 ? length - 1 : index - 1;
            break;
          case EVENT_CODE.right:
          case EVENT_CODE.down:
            e.stopPropagation();
            e.preventDefault();
            nextIndex = index === length - 1 ? 0 : index + 1;
            break;
        }
        if (nextIndex === null)
          return;
        roleRadios[nextIndex].click();
        roleRadios[nextIndex].focus();
      };
      vue.onMounted(() => {
        const radios = radioGroupRef.value.querySelectorAll("[type=radio]");
        const firstLabel = radios[0];
        if (!Array.from(radios).some((radio) => radio.checked) && firstLabel) {
          firstLabel.tabIndex = 0;
        }
      });
      vue.provide(radioGroupKey, vue.reactive({
        ...vue.toRefs(props),
        changeEvent
      }));
      vue.watch(() => props.modelValue, () => formItem == null ? void 0 : formItem.validate("change").catch((err) => debugWarn()));
      return {
        ns,
        radioGroupRef,
        handleKeydown
      };
    }
  });
  function _sfc_render$1l(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      ref: "radioGroupRef",
      class: vue.normalizeClass(_ctx.ns.b("group")),
      role: "radiogroup",
      onKeydown: _cache[0] || (_cache[0] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args))
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 34);
  }
  var RadioGroup = /* @__PURE__ */ _export_sfc(_sfc_main$1C, [["render", _sfc_render$1l]]);

  const ElRadio = withInstall(Radio, {
    RadioButton,
    RadioGroup
  });
  const ElRadioGroup = withNoopInstall(RadioGroup);
  const ElRadioButton = withNoopInstall(RadioButton);

  var NodeContent$1 = vue.defineComponent({
    name: "NodeContent",
    setup() {
      const ns = useNamespace("cascader-node");
      return {
        ns
      };
    },
    render() {
      const { ns } = this;
      const { node, panel } = this.$parent;
      const { data, label } = node;
      const { renderLabelFn } = panel;
      return vue.h("span", { class: ns.e("label") }, renderLabelFn ? renderLabelFn({ node, data }) : label);
    }
  });

  var ExpandTrigger$1 = /* @__PURE__ */ ((ExpandTrigger2) => {
    ExpandTrigger2["CLICK"] = "click";
    ExpandTrigger2["HOVER"] = "hover";
    return ExpandTrigger2;
  })(ExpandTrigger$1 || {});
  const CASCADER_PANEL_INJECTION_KEY = Symbol();

  const _sfc_main$1B = vue.defineComponent({
    name: "ElCascaderNode",
    components: {
      ElCheckbox,
      ElRadio,
      NodeContent: NodeContent$1,
      ElIcon,
      Check: check,
      Loading: loading,
      ArrowRight: arrowRight
    },
    props: {
      node: {
        type: Object,
        required: true
      },
      menuId: String
    },
    emits: ["expand"],
    setup(props, { emit }) {
      const panel = vue.inject(CASCADER_PANEL_INJECTION_KEY);
      const ns = useNamespace("cascader-node");
      const isHoverMenu = vue.computed(() => panel.isHoverMenu);
      const multiple = vue.computed(() => panel.config.multiple);
      const checkStrictly = vue.computed(() => panel.config.checkStrictly);
      const checkedNodeId = vue.computed(() => {
        var _a;
        return (_a = panel.checkedNodes[0]) == null ? void 0 : _a.uid;
      });
      const isDisabled = vue.computed(() => props.node.isDisabled);
      const isLeaf = vue.computed(() => props.node.isLeaf);
      const expandable = vue.computed(() => checkStrictly.value && !isLeaf.value || !isDisabled.value);
      const inExpandingPath = vue.computed(() => isInPath(panel.expandingNode));
      const inCheckedPath = vue.computed(() => checkStrictly.value && panel.checkedNodes.some(isInPath));
      const isInPath = (node) => {
        var _a;
        const { level, uid } = props.node;
        return ((_a = node == null ? void 0 : node.pathNodes[level - 1]) == null ? void 0 : _a.uid) === uid;
      };
      const doExpand = () => {
        if (inExpandingPath.value)
          return;
        panel.expandNode(props.node);
      };
      const doCheck = (checked) => {
        const { node } = props;
        if (checked === node.checked)
          return;
        panel.handleCheckChange(node, checked);
      };
      const doLoad = () => {
        panel.lazyLoad(props.node, () => {
          if (!isLeaf.value)
            doExpand();
        });
      };
      const handleHoverExpand = (e) => {
        if (!isHoverMenu.value)
          return;
        handleExpand();
        !isLeaf.value && emit("expand", e);
      };
      const handleExpand = () => {
        const { node } = props;
        if (!expandable.value || node.loading)
          return;
        node.loaded ? doExpand() : doLoad();
      };
      const handleClick = () => {
        if (isHoverMenu.value && !isLeaf.value)
          return;
        if (isLeaf.value && !isDisabled.value && !checkStrictly.value && !multiple.value) {
          handleCheck(true);
        } else {
          handleExpand();
        }
      };
      const handleSelectCheck = (checked) => {
        if (checkStrictly.value) {
          doCheck(checked);
          if (props.node.loaded) {
            doExpand();
          }
        } else {
          handleCheck(checked);
        }
      };
      const handleCheck = (checked) => {
        if (!props.node.loaded) {
          doLoad();
        } else {
          doCheck(checked);
          !checkStrictly.value && doExpand();
        }
      };
      return {
        panel,
        isHoverMenu,
        multiple,
        checkStrictly,
        checkedNodeId,
        isDisabled,
        isLeaf,
        expandable,
        inExpandingPath,
        inCheckedPath,
        ns,
        handleHoverExpand,
        handleExpand,
        handleClick,
        handleCheck,
        handleSelectCheck
      };
    }
  });
  const _hoisted_1$L = ["id", "aria-haspopup", "aria-owns", "aria-expanded", "tabindex"];
  const _hoisted_2$v = /* @__PURE__ */ vue.createElementVNode("span", null, null, -1);
  function _sfc_render$1k(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_checkbox = vue.resolveComponent("el-checkbox");
    const _component_el_radio = vue.resolveComponent("el-radio");
    const _component_check = vue.resolveComponent("check");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_node_content = vue.resolveComponent("node-content");
    const _component_loading = vue.resolveComponent("loading");
    const _component_arrow_right = vue.resolveComponent("arrow-right");
    return vue.openBlock(), vue.createElementBlock("li", {
      id: `${_ctx.menuId}-${_ctx.node.uid}`,
      role: "menuitem",
      "aria-haspopup": !_ctx.isLeaf,
      "aria-owns": _ctx.isLeaf ? null : _ctx.menuId,
      "aria-expanded": _ctx.inExpandingPath,
      tabindex: _ctx.expandable ? -1 : void 0,
      class: vue.normalizeClass([
        _ctx.ns.b(),
        _ctx.ns.is("selectable", _ctx.checkStrictly),
        _ctx.ns.is("active", _ctx.node.checked),
        _ctx.ns.is("disabled", !_ctx.expandable),
        _ctx.inExpandingPath && "in-active-path",
        _ctx.inCheckedPath && "in-checked-path"
      ]),
      onMouseenter: _cache[2] || (_cache[2] = (...args) => _ctx.handleHoverExpand && _ctx.handleHoverExpand(...args)),
      onFocus: _cache[3] || (_cache[3] = (...args) => _ctx.handleHoverExpand && _ctx.handleHoverExpand(...args)),
      onClick: _cache[4] || (_cache[4] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
    }, [
      vue.createCommentVNode(" prefix "),
      _ctx.multiple ? (vue.openBlock(), vue.createBlock(_component_el_checkbox, {
        key: 0,
        "model-value": _ctx.node.checked,
        indeterminate: _ctx.node.indeterminate,
        disabled: _ctx.isDisabled,
        onClick: _cache[0] || (_cache[0] = vue.withModifiers(() => {
        }, ["stop"])),
        "onUpdate:modelValue": _ctx.handleSelectCheck
      }, null, 8, ["model-value", "indeterminate", "disabled", "onUpdate:modelValue"])) : _ctx.checkStrictly ? (vue.openBlock(), vue.createBlock(_component_el_radio, {
        key: 1,
        "model-value": _ctx.checkedNodeId,
        label: _ctx.node.uid,
        disabled: _ctx.isDisabled,
        "onUpdate:modelValue": _ctx.handleSelectCheck,
        onClick: _cache[1] || (_cache[1] = vue.withModifiers(() => {
        }, ["stop"]))
      }, {
        default: vue.withCtx(() => [
          vue.createCommentVNode("\n        Add an empty element to avoid render label,\n        do not use empty fragment here for https://github.com/vuejs/vue-next/pull/2485\n      "),
          _hoisted_2$v
        ]),
        _: 1
      }, 8, ["model-value", "label", "disabled", "onUpdate:modelValue"])) : _ctx.isLeaf && _ctx.node.checked ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
        key: 2,
        class: vue.normalizeClass(_ctx.ns.e("prefix"))
      }, {
        default: vue.withCtx(() => [
          vue.createVNode(_component_check)
        ]),
        _: 1
      }, 8, ["class"])) : vue.createCommentVNode("v-if", true),
      vue.createCommentVNode(" content "),
      vue.createVNode(_component_node_content),
      vue.createCommentVNode(" postfix "),
      !_ctx.isLeaf ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 3 }, [
        _ctx.node.loading ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
          key: 0,
          class: vue.normalizeClass([_ctx.ns.is("loading"), _ctx.ns.e("postfix")])
        }, {
          default: vue.withCtx(() => [
            vue.createVNode(_component_loading)
          ]),
          _: 1
        }, 8, ["class"])) : (vue.openBlock(), vue.createBlock(_component_el_icon, {
          key: 1,
          class: vue.normalizeClass(["arrow-right", _ctx.ns.e("postfix")])
        }, {
          default: vue.withCtx(() => [
            vue.createVNode(_component_arrow_right)
          ]),
          _: 1
        }, 8, ["class"]))
      ], 2112)) : vue.createCommentVNode("v-if", true)
    ], 42, _hoisted_1$L);
  }
  var ElCascaderNode = /* @__PURE__ */ _export_sfc(_sfc_main$1B, [["render", _sfc_render$1k]]);

  const _sfc_main$1A = vue.defineComponent({
    name: "ElCascaderMenu",
    components: {
      Loading: loading,
      ElIcon,
      ElScrollbar,
      ElCascaderNode
    },
    props: {
      nodes: {
        type: Array,
        required: true
      },
      index: {
        type: Number,
        required: true
      }
    },
    setup(props) {
      const instance = vue.getCurrentInstance();
      const ns = useNamespace("cascader-menu");
      const { t } = useLocale();
      const id = generateId();
      let activeNode = null;
      let hoverTimer = null;
      const panel = vue.inject(CASCADER_PANEL_INJECTION_KEY);
      const hoverZone = vue.ref(null);
      const isEmpty = vue.computed(() => !props.nodes.length);
      const isLoading = vue.computed(() => !panel.initialLoaded);
      const menuId = vue.computed(() => `cascader-menu-${id}-${props.index}`);
      const handleExpand = (e) => {
        activeNode = e.target;
      };
      const handleMouseMove = (e) => {
        if (!panel.isHoverMenu || !activeNode || !hoverZone.value)
          return;
        if (activeNode.contains(e.target)) {
          clearHoverTimer();
          const el = instance.vnode.el;
          const { left } = el.getBoundingClientRect();
          const { offsetWidth, offsetHeight } = el;
          const startX = e.clientX - left;
          const top = activeNode.offsetTop;
          const bottom = top + activeNode.offsetHeight;
          hoverZone.value.innerHTML = `
          <path style="pointer-events: auto;" fill="transparent" d="M${startX} ${top} L${offsetWidth} 0 V${top} Z" />
          <path style="pointer-events: auto;" fill="transparent" d="M${startX} ${bottom} L${offsetWidth} ${offsetHeight} V${bottom} Z" />
        `;
        } else if (!hoverTimer) {
          hoverTimer = window.setTimeout(clearHoverZone, panel.config.hoverThreshold);
        }
      };
      const clearHoverTimer = () => {
        if (!hoverTimer)
          return;
        clearTimeout(hoverTimer);
        hoverTimer = null;
      };
      const clearHoverZone = () => {
        if (!hoverZone.value)
          return;
        hoverZone.value.innerHTML = "";
        clearHoverTimer();
      };
      return {
        ns,
        panel,
        hoverZone,
        isEmpty,
        isLoading,
        menuId,
        t,
        handleExpand,
        handleMouseMove,
        clearHoverZone
      };
    }
  });
  function _sfc_render$1j(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_cascader_node = vue.resolveComponent("el-cascader-node");
    const _component_loading = vue.resolveComponent("loading");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_el_scrollbar = vue.resolveComponent("el-scrollbar");
    return vue.openBlock(), vue.createBlock(_component_el_scrollbar, {
      key: _ctx.menuId,
      tag: "ul",
      role: "menu",
      class: vue.normalizeClass(_ctx.ns.b()),
      "wrap-class": _ctx.ns.e("wrap"),
      "view-class": [_ctx.ns.e("list"), _ctx.ns.is("empty", _ctx.isEmpty)],
      onMousemove: _ctx.handleMouseMove,
      onMouseleave: _ctx.clearHoverZone
    }, {
      default: vue.withCtx(() => {
        var _a;
        return [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.nodes, (node) => {
            return vue.openBlock(), vue.createBlock(_component_el_cascader_node, {
              key: node.uid,
              node,
              "menu-id": _ctx.menuId,
              onExpand: _ctx.handleExpand
            }, null, 8, ["node", "menu-id", "onExpand"]);
          }), 128)),
          _ctx.isLoading ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 0,
            class: vue.normalizeClass(_ctx.ns.e("empty-text"))
          }, [
            vue.createVNode(_component_el_icon, {
              size: "14",
              class: vue.normalizeClass(_ctx.ns.is("loading"))
            }, {
              default: vue.withCtx(() => [
                vue.createVNode(_component_loading)
              ]),
              _: 1
            }, 8, ["class"]),
            vue.createTextVNode(" " + vue.toDisplayString(_ctx.t("el.cascader.loading")), 1)
          ], 2)) : _ctx.isEmpty ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 1,
            class: vue.normalizeClass(_ctx.ns.e("empty-text"))
          }, vue.toDisplayString(_ctx.t("el.cascader.noData")), 3)) : ((_a = _ctx.panel) == null ? void 0 : _a.isHoverMenu) ? (vue.openBlock(), vue.createElementBlock("svg", {
            key: 2,
            ref: "hoverZone",
            class: vue.normalizeClass(_ctx.ns.e("hover-zone"))
          }, null, 2)) : vue.createCommentVNode("v-if", true)
        ];
      }),
      _: 1
    }, 8, ["class", "wrap-class", "view-class", "onMousemove", "onMouseleave"]);
  }
  var ElCascaderMenu = /* @__PURE__ */ _export_sfc(_sfc_main$1A, [["render", _sfc_render$1j]]);

  var ExpandTrigger = /* @__PURE__ */ ((ExpandTrigger2) => {
    ExpandTrigger2["CLICK"] = "click";
    ExpandTrigger2["HOVER"] = "hover";
    return ExpandTrigger2;
  })(ExpandTrigger || {});
  let uid = 0;
  const calculatePathNodes = (node) => {
    const nodes = [node];
    let { parent } = node;
    while (parent) {
      nodes.unshift(parent);
      parent = parent.parent;
    }
    return nodes;
  };
  class Node$2 {
    constructor(data, config, parent, root = false) {
      this.data = data;
      this.config = config;
      this.parent = parent;
      this.root = root;
      this.uid = uid++;
      this.checked = false;
      this.indeterminate = false;
      this.loading = false;
      const { value: valueKey, label: labelKey, children: childrenKey } = config;
      const childrenData = data[childrenKey];
      const pathNodes = calculatePathNodes(this);
      this.level = root ? 0 : parent ? parent.level + 1 : 1;
      this.value = data[valueKey];
      this.label = data[labelKey];
      this.pathNodes = pathNodes;
      this.pathValues = pathNodes.map((node) => node.value);
      this.pathLabels = pathNodes.map((node) => node.label);
      this.childrenData = childrenData;
      this.children = (childrenData || []).map((child) => new Node$2(child, config, this));
      this.loaded = !config.lazy || this.isLeaf || !isEmpty(childrenData);
    }
    get isDisabled() {
      const { data, parent, config } = this;
      const { disabled, checkStrictly } = config;
      const isDisabled = isFunction(disabled) ? disabled(data, this) : !!data[disabled];
      return isDisabled || !checkStrictly && (parent == null ? void 0 : parent.isDisabled);
    }
    get isLeaf() {
      const { data, config, childrenData, loaded } = this;
      const { lazy, leaf } = config;
      const isLeaf = isFunction(leaf) ? leaf(data, this) : data[leaf];
      return isUndefined(isLeaf) ? lazy && !loaded ? false : !(Array.isArray(childrenData) && childrenData.length) : !!isLeaf;
    }
    get valueByOption() {
      return this.config.emitPath ? this.pathValues : this.value;
    }
    appendChild(childData) {
      const { childrenData, children } = this;
      const node = new Node$2(childData, this.config, this);
      if (Array.isArray(childrenData)) {
        childrenData.push(childData);
      } else {
        this.childrenData = [childData];
      }
      children.push(node);
      return node;
    }
    calcText(allLevels, separator) {
      const text = allLevels ? this.pathLabels.join(separator) : this.label;
      this.text = text;
      return text;
    }
    broadcast(event, ...args) {
      const handlerName = `onParent${capitalize(event)}`;
      this.children.forEach((child) => {
        if (child) {
          child.broadcast(event, ...args);
          child[handlerName] && child[handlerName](...args);
        }
      });
    }
    emit(event, ...args) {
      const { parent } = this;
      const handlerName = `onChild${capitalize(event)}`;
      if (parent) {
        parent[handlerName] && parent[handlerName](...args);
        parent.emit(event, ...args);
      }
    }
    onParentCheck(checked) {
      if (!this.isDisabled) {
        this.setCheckState(checked);
      }
    }
    onChildCheck() {
      const { children } = this;
      const validChildren = children.filter((child) => !child.isDisabled);
      const checked = validChildren.length ? validChildren.every((child) => child.checked) : false;
      this.setCheckState(checked);
    }
    setCheckState(checked) {
      const totalNum = this.children.length;
      const checkedNum = this.children.reduce((c, p) => {
        const num = p.checked ? 1 : p.indeterminate ? 0.5 : 0;
        return c + num;
      }, 0);
      this.checked = this.loaded && this.children.every((child) => child.loaded && child.checked) && checked;
      this.indeterminate = this.loaded && checkedNum !== totalNum && checkedNum > 0;
    }
    doCheck(checked) {
      if (this.checked === checked)
        return;
      const { checkStrictly, multiple } = this.config;
      if (checkStrictly || !multiple) {
        this.checked = checked;
      } else {
        this.broadcast("check", checked);
        this.setCheckState(checked);
        this.emit("check");
      }
    }
  }

  const flatNodes = (nodes, leafOnly) => {
    return nodes.reduce((res, node) => {
      if (node.isLeaf) {
        res.push(node);
      } else {
        !leafOnly && res.push(node);
        res = res.concat(flatNodes(node.children, leafOnly));
      }
      return res;
    }, []);
  };
  class Store {
    constructor(data, config) {
      this.config = config;
      const nodes = (data || []).map((nodeData) => new Node$2(nodeData, this.config));
      this.nodes = nodes;
      this.allNodes = flatNodes(nodes, false);
      this.leafNodes = flatNodes(nodes, true);
    }
    getNodes() {
      return this.nodes;
    }
    getFlattedNodes(leafOnly) {
      return leafOnly ? this.leafNodes : this.allNodes;
    }
    appendNode(nodeData, parentNode) {
      const node = parentNode ? parentNode.appendChild(nodeData) : new Node$2(nodeData, this.config);
      if (!parentNode)
        this.nodes.push(node);
      this.allNodes.push(node);
      node.isLeaf && this.leafNodes.push(node);
    }
    appendNodes(nodeDataList, parentNode) {
      nodeDataList.forEach((nodeData) => this.appendNode(nodeData, parentNode));
    }
    getNodeByValue(value, leafOnly = false) {
      if (!value && value !== 0)
        return null;
      const node = this.getFlattedNodes(leafOnly).find((node2) => isEqual$1(node2.value, value) || isEqual$1(node2.pathValues, value));
      return node || null;
    }
    getSameNode(node) {
      if (!node)
        return null;
      const node_ = this.getFlattedNodes(false).find(({ value, level }) => isEqual$1(node.value, value) && node.level === level);
      return node_ || null;
    }
  }

  const CommonProps = {
    modelValue: [Number, String, Array],
    options: {
      type: Array,
      default: () => []
    },
    props: {
      type: Object,
      default: () => ({})
    }
  };
  const DefaultProps = {
    expandTrigger: ExpandTrigger.CLICK,
    multiple: false,
    checkStrictly: false,
    emitPath: true,
    lazy: false,
    lazyLoad: NOOP,
    value: "value",
    label: "label",
    children: "children",
    leaf: "leaf",
    disabled: "disabled",
    hoverThreshold: 500
  };
  const useCascaderConfig = (props) => {
    return vue.computed(() => ({
      ...DefaultProps,
      ...props.props
    }));
  };

  const getMenuIndex = (el) => {
    if (!el)
      return 0;
    const pieces = el.id.split("-");
    return Number(pieces[pieces.length - 2]);
  };
  const checkNode = (el) => {
    if (!el)
      return;
    const input = el.querySelector("input");
    if (input) {
      input.click();
    } else if (isLeaf(el)) {
      el.click();
    }
  };
  const sortByOriginalOrder = (oldNodes, newNodes) => {
    const newNodesCopy = newNodes.slice(0);
    const newIds = newNodesCopy.map((node) => node.uid);
    const res = oldNodes.reduce((acc, item) => {
      const index = newIds.indexOf(item.uid);
      if (index > -1) {
        acc.push(item);
        newNodesCopy.splice(index, 1);
        newIds.splice(index, 1);
      }
      return acc;
    }, []);
    res.push(...newNodesCopy);
    return res;
  };

  const _sfc_main$1z = vue.defineComponent({
    name: "ElCascaderPanel",
    components: {
      ElCascaderMenu
    },
    props: {
      ...CommonProps,
      border: {
        type: Boolean,
        default: true
      },
      renderLabel: Function
    },
    emits: [UPDATE_MODEL_EVENT, CHANGE_EVENT, "close", "expand-change"],
    setup(props, { emit, slots }) {
      let manualChecked = false;
      const ns = useNamespace("cascader");
      const config = useCascaderConfig(props);
      let store = null;
      const initialLoaded = vue.ref(true);
      const menuList = vue.ref([]);
      const checkedValue = vue.ref(null);
      const menus = vue.ref([]);
      const expandingNode = vue.ref(null);
      const checkedNodes = vue.ref([]);
      const isHoverMenu = vue.computed(() => config.value.expandTrigger === ExpandTrigger.HOVER);
      const renderLabelFn = vue.computed(() => props.renderLabel || slots.default);
      const initStore = () => {
        const { options } = props;
        const cfg = config.value;
        manualChecked = false;
        store = new Store(options, cfg);
        menus.value = [store.getNodes()];
        if (cfg.lazy && isEmpty(props.options)) {
          initialLoaded.value = false;
          lazyLoad(void 0, (list) => {
            if (list) {
              store = new Store(list, cfg);
              menus.value = [store.getNodes()];
            }
            initialLoaded.value = true;
            syncCheckedValue(false, true);
          });
        } else {
          syncCheckedValue(false, true);
        }
      };
      const lazyLoad = (node, cb) => {
        const cfg = config.value;
        node = node || new Node$2({}, cfg, void 0, true);
        node.loading = true;
        const resolve = (dataList) => {
          const _node = node;
          const parent = _node.root ? null : _node;
          dataList && (store == null ? void 0 : store.appendNodes(dataList, parent));
          _node.loading = false;
          _node.loaded = true;
          _node.childrenData = _node.childrenData || [];
          cb && cb(dataList);
        };
        cfg.lazyLoad(node, resolve);
      };
      const expandNode = (node, silent) => {
        var _a;
        const { level } = node;
        const newMenus = menus.value.slice(0, level);
        let newExpandingNode;
        if (node.isLeaf) {
          newExpandingNode = node.pathNodes[level - 2];
        } else {
          newExpandingNode = node;
          newMenus.push(node.children);
        }
        if (((_a = expandingNode.value) == null ? void 0 : _a.uid) !== (newExpandingNode == null ? void 0 : newExpandingNode.uid)) {
          expandingNode.value = node;
          menus.value = newMenus;
          !silent && emit("expand-change", (node == null ? void 0 : node.pathValues) || []);
        }
      };
      const handleCheckChange = (node, checked, emitClose = true) => {
        const { checkStrictly, multiple } = config.value;
        const oldNode = checkedNodes.value[0];
        manualChecked = true;
        !multiple && (oldNode == null ? void 0 : oldNode.doCheck(false));
        node.doCheck(checked);
        calculateCheckedValue();
        emitClose && !multiple && !checkStrictly && emit("close");
        !emitClose && !multiple && !checkStrictly && expandParentNode(node);
      };
      const expandParentNode = (node) => {
        if (!node)
          return;
        node = node.parent;
        expandParentNode(node);
        node && expandNode(node);
      };
      const getFlattedNodes = (leafOnly) => {
        return store == null ? void 0 : store.getFlattedNodes(leafOnly);
      };
      const getCheckedNodes = (leafOnly) => {
        var _a;
        return (_a = getFlattedNodes(leafOnly)) == null ? void 0 : _a.filter((node) => node.checked !== false);
      };
      const clearCheckedNodes = () => {
        checkedNodes.value.forEach((node) => node.doCheck(false));
        calculateCheckedValue();
      };
      const calculateCheckedValue = () => {
        var _a;
        const { checkStrictly, multiple } = config.value;
        const oldNodes = checkedNodes.value;
        const newNodes = getCheckedNodes(!checkStrictly);
        const nodes = sortByOriginalOrder(oldNodes, newNodes);
        const values = nodes.map((node) => node.valueByOption);
        checkedNodes.value = nodes;
        checkedValue.value = multiple ? values : (_a = values[0]) != null ? _a : null;
      };
      const syncCheckedValue = (loaded = false, forced = false) => {
        const { modelValue } = props;
        const { lazy, multiple, checkStrictly } = config.value;
        const leafOnly = !checkStrictly;
        if (!initialLoaded.value || manualChecked || !forced && isEqual$1(modelValue, checkedValue.value))
          return;
        if (lazy && !loaded) {
          const values = unique(flattenDeep(castArray(modelValue)));
          const nodes = values.map((val) => store == null ? void 0 : store.getNodeByValue(val)).filter((node) => !!node && !node.loaded && !node.loading);
          if (nodes.length) {
            nodes.forEach((node) => {
              lazyLoad(node, () => syncCheckedValue(false, forced));
            });
          } else {
            syncCheckedValue(true, forced);
          }
        } else {
          const values = multiple ? castArray(modelValue) : [modelValue];
          const nodes = unique(values.map((val) => store == null ? void 0 : store.getNodeByValue(val, leafOnly)));
          syncMenuState(nodes, false);
          checkedValue.value = modelValue;
        }
      };
      const syncMenuState = (newCheckedNodes, reserveExpandingState = true) => {
        const { checkStrictly } = config.value;
        const oldNodes = checkedNodes.value;
        const newNodes = newCheckedNodes.filter((node) => !!node && (checkStrictly || node.isLeaf));
        const oldExpandingNode = store == null ? void 0 : store.getSameNode(expandingNode.value);
        const newExpandingNode = reserveExpandingState && oldExpandingNode || newNodes[0];
        if (newExpandingNode) {
          newExpandingNode.pathNodes.forEach((node) => expandNode(node, true));
        } else {
          expandingNode.value = null;
        }
        oldNodes.forEach((node) => node.doCheck(false));
        newNodes.forEach((node) => node.doCheck(true));
        checkedNodes.value = newNodes;
        vue.nextTick(scrollToExpandingNode);
      };
      const scrollToExpandingNode = () => {
        if (!isClient)
          return;
        menuList.value.forEach((menu) => {
          const menuElement = menu == null ? void 0 : menu.$el;
          if (menuElement) {
            const container = menuElement.querySelector(`.${ns.namespace.value}-scrollbar__wrap`);
            const activeNode = menuElement.querySelector(`.${ns.b("node")}.${ns.is("active")}`) || menuElement.querySelector(`.${ns.b("node")}.in-active-path`);
            scrollIntoView(container, activeNode);
          }
        });
      };
      const handleKeyDown = (e) => {
        const target = e.target;
        const { code } = e;
        switch (code) {
          case EVENT_CODE.up:
          case EVENT_CODE.down: {
            e.preventDefault();
            const distance = code === EVENT_CODE.up ? -1 : 1;
            focusNode(getSibling(target, distance, `.${ns.b("node")}[tabindex="-1"]`));
            break;
          }
          case EVENT_CODE.left: {
            e.preventDefault();
            const preMenu = menuList.value[getMenuIndex(target) - 1];
            const expandedNode = preMenu == null ? void 0 : preMenu.$el.querySelector(`.${ns.b("node")}[aria-expanded="true"]`);
            focusNode(expandedNode);
            break;
          }
          case EVENT_CODE.right: {
            e.preventDefault();
            const nextMenu = menuList.value[getMenuIndex(target) + 1];
            const firstNode = nextMenu == null ? void 0 : nextMenu.$el.querySelector(`.${ns.b("node")}[tabindex="-1"]`);
            focusNode(firstNode);
            break;
          }
          case EVENT_CODE.enter:
            checkNode(target);
            break;
          case EVENT_CODE.esc:
          case EVENT_CODE.tab:
            emit("close");
            break;
        }
      };
      vue.provide(CASCADER_PANEL_INJECTION_KEY, vue.reactive({
        config,
        expandingNode,
        checkedNodes,
        isHoverMenu,
        initialLoaded,
        renderLabelFn,
        lazyLoad,
        expandNode,
        handleCheckChange
      }));
      vue.watch([config, () => props.options], initStore, {
        deep: true,
        immediate: true
      });
      vue.watch(() => props.modelValue, () => {
        manualChecked = false;
        syncCheckedValue();
      });
      vue.watch(checkedValue, (val) => {
        if (!isEqual$1(val, props.modelValue)) {
          emit(UPDATE_MODEL_EVENT, val);
          emit(CHANGE_EVENT, val);
        }
      });
      vue.onBeforeUpdate(() => menuList.value = []);
      vue.onMounted(() => !isEmpty(props.modelValue) && syncCheckedValue());
      return {
        ns,
        menuList,
        menus,
        checkedNodes,
        handleKeyDown,
        handleCheckChange,
        getFlattedNodes,
        getCheckedNodes,
        clearCheckedNodes,
        calculateCheckedValue,
        scrollToExpandingNode
      };
    }
  });
  function _sfc_render$1i(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_cascader_menu = vue.resolveComponent("el-cascader-menu");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([_ctx.ns.b("panel"), _ctx.ns.is("bordered", _ctx.border)]),
      onKeydown: _cache[0] || (_cache[0] = (...args) => _ctx.handleKeyDown && _ctx.handleKeyDown(...args))
    }, [
      (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.menus, (menu, index) => {
        return vue.openBlock(), vue.createBlock(_component_el_cascader_menu, {
          key: index,
          ref_for: true,
          ref: (item) => _ctx.menuList[index] = item,
          index,
          nodes: menu
        }, null, 8, ["index", "nodes"]);
      }), 128))
    ], 34);
  }
  var CascaderPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1z, [["render", _sfc_render$1i]]);

  CascaderPanel.install = (app) => {
    app.component(CascaderPanel.name, CascaderPanel);
  };
  const _CascaderPanel = CascaderPanel;
  const ElCascaderPanel = _CascaderPanel;

  const tagProps = buildProps({
    closable: Boolean,
    type: {
      type: String,
      values: ["success", "info", "warning", "danger", ""],
      default: ""
    },
    hit: Boolean,
    disableTransitions: Boolean,
    color: {
      type: String,
      default: ""
    },
    size: {
      type: String,
      values: ["large", "default", "small"]
    },
    effect: {
      type: String,
      values: ["dark", "light", "plain"],
      default: "light"
    }
  });
  const tagEmits = {
    close: (evt) => evt instanceof MouseEvent,
    click: (evt) => evt instanceof MouseEvent
  };

  const __default__$d = {
    name: "ElTag"
  };
  const _sfc_main$1y = /* @__PURE__ */ vue.defineComponent({
    ...__default__$d,
    props: tagProps,
    emits: tagEmits,
    setup(__props, { emit }) {
      const props = __props;
      const tagSize = useSize();
      const ns = useNamespace("tag");
      const classes = vue.computed(() => {
        const { type, hit, effect, closable } = props;
        return [
          ns.b(),
          ns.is("closable", closable),
          ns.m(type),
          ns.m(tagSize.value),
          ns.m(effect),
          ns.is("hit", hit)
        ];
      });
      const handleClose = (event) => {
        event.stopPropagation();
        emit("close", event);
      };
      const handleClick = (event) => {
        emit("click", event);
      };
      return (_ctx, _cache) => {
        return !_ctx.disableTransitions ? (vue.openBlock(), vue.createElementBlock("span", {
          key: 0,
          class: vue.normalizeClass(vue.unref(classes)),
          style: vue.normalizeStyle({ backgroundColor: _ctx.color }),
          onClick: handleClick
        }, [
          vue.createElementVNode("span", {
            class: vue.normalizeClass(vue.unref(ns).e("content"))
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 2),
          _ctx.closable ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), {
            key: 0,
            class: vue.normalizeClass(vue.unref(ns).e("close")),
            onClick: handleClose
          }, {
            default: vue.withCtx(() => [
              vue.createVNode(vue.unref(close$2))
            ]),
            _: 1
          }, 8, ["class"])) : vue.createCommentVNode("v-if", true)
        ], 6)) : (vue.openBlock(), vue.createBlock(vue.Transition, {
          key: 1,
          name: `${vue.unref(ns).namespace.value}-zoom-in-center`
        }, {
          default: vue.withCtx(() => [
            vue.createElementVNode("span", {
              class: vue.normalizeClass(vue.unref(classes)),
              style: vue.normalizeStyle({ backgroundColor: _ctx.color }),
              onClick: handleClick
            }, [
              vue.createElementVNode("span", {
                class: vue.normalizeClass(vue.unref(ns).e("content"))
              }, [
                vue.renderSlot(_ctx.$slots, "default")
              ], 2),
              _ctx.closable ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), {
                key: 0,
                class: vue.normalizeClass(vue.unref(ns).e("close")),
                onClick: handleClose
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(vue.unref(close$2))
                ]),
                _: 1
              }, 8, ["class"])) : vue.createCommentVNode("v-if", true)
            ], 6)
          ]),
          _: 3
        }, 8, ["name"]));
      };
    }
  });
  var Tag = _sfc_main$1y;

  const ElTag = withInstall(Tag);

  const DEFAULT_INPUT_HEIGHT = 40;
  const INPUT_HEIGHT_MAP = {
    large: 36,
    default: 32,
    small: 28
  };
  const popperOptions = {
    modifiers: [
      {
        name: "arrowPosition",
        enabled: true,
        phase: "main",
        fn: ({ state }) => {
          const { modifiersData, placement } = state;
          if (["right", "left", "bottom", "top"].includes(placement))
            return;
          modifiersData.arrow.x = 35;
        },
        requires: ["arrow"]
      }
    ]
  };
  const COMPONENT_NAME$c = "ElCascader";
  const _sfc_main$1x = vue.defineComponent({
    name: COMPONENT_NAME$c,
    components: {
      ElCascaderPanel: _CascaderPanel,
      ElInput,
      ElTooltip,
      ElScrollbar,
      ElTag,
      ElIcon,
      CircleClose: circleClose,
      Check: check,
      ArrowDown: arrowDown
    },
    directives: {
      Clickoutside: ClickOutside
    },
    props: {
      ...CommonProps,
      size: {
        type: String,
        validator: isValidComponentSize
      },
      placeholder: {
        type: String
      },
      disabled: Boolean,
      clearable: Boolean,
      filterable: Boolean,
      filterMethod: {
        type: Function,
        default: (node, keyword) => node.text.includes(keyword)
      },
      separator: {
        type: String,
        default: " / "
      },
      showAllLevels: {
        type: Boolean,
        default: true
      },
      collapseTags: Boolean,
      collapseTagsTooltip: {
        type: Boolean,
        default: false
      },
      debounce: {
        type: Number,
        default: 300
      },
      beforeFilter: {
        type: Function,
        default: () => true
      },
      popperClass: {
        type: String,
        default: ""
      },
      popperAppendToBody: {
        type: Boolean,
        default: void 0
      },
      teleported: useTooltipContentProps.teleported
    },
    emits: [
      UPDATE_MODEL_EVENT,
      CHANGE_EVENT,
      "focus",
      "blur",
      "visible-change",
      "expand-change",
      "remove-tag"
    ],
    setup(props, { emit }) {
      let inputInitialHeight = 0;
      let pressDeleteCount = 0;
      const { compatTeleported } = useDeprecateAppendToBody(COMPONENT_NAME$c, "popperAppendToBody");
      const nsCascader = useNamespace("cascader");
      const nsInput = useNamespace("input");
      const { t } = useLocale();
      const elForm = vue.inject(formContextKey, {});
      const elFormItem = vue.inject(formItemContextKey, {});
      const tooltipRef = vue.ref(null);
      const input = vue.ref(null);
      const tagWrapper = vue.ref(null);
      const panel = vue.ref(null);
      const suggestionPanel = vue.ref(null);
      const popperVisible = vue.ref(false);
      const inputHover = vue.ref(false);
      const filtering = vue.ref(false);
      const inputValue = vue.ref("");
      const searchInputValue = vue.ref("");
      const presentTags = vue.ref([]);
      const allPresentTags = vue.ref([]);
      const suggestions = vue.ref([]);
      const isOnComposition = vue.ref(false);
      const isDisabled = vue.computed(() => props.disabled || elForm.disabled);
      const inputPlaceholder = vue.computed(() => props.placeholder || t("el.cascader.placeholder"));
      const realSize = useSize();
      const tagSize = vue.computed(() => ["small"].includes(realSize.value) ? "small" : "default");
      const multiple = vue.computed(() => !!props.props.multiple);
      const readonly = vue.computed(() => !props.filterable || multiple.value);
      const searchKeyword = vue.computed(() => multiple.value ? searchInputValue.value : inputValue.value);
      const checkedNodes = vue.computed(() => {
        var _a;
        return ((_a = panel.value) == null ? void 0 : _a.checkedNodes) || [];
      });
      const clearBtnVisible = vue.computed(() => {
        if (!props.clearable || isDisabled.value || filtering.value || !inputHover.value)
          return false;
        return !!checkedNodes.value.length;
      });
      const presentText = vue.computed(() => {
        const { showAllLevels, separator } = props;
        const nodes = checkedNodes.value;
        return nodes.length ? multiple.value ? " " : nodes[0].calcText(showAllLevels, separator) : "";
      });
      const checkedValue = vue.computed({
        get() {
          return props.modelValue;
        },
        set(val) {
          var _a;
          emit(UPDATE_MODEL_EVENT, val);
          emit(CHANGE_EVENT, val);
          (_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
        }
      });
      const popperPaneRef = vue.computed(() => {
        var _a, _b;
        return (_b = (_a = tooltipRef.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef;
      });
      const togglePopperVisible = (visible) => {
        var _a, _b, _c;
        if (isDisabled.value)
          return;
        visible = visible != null ? visible : !popperVisible.value;
        if (visible !== popperVisible.value) {
          popperVisible.value = visible;
          (_b = (_a = input.value) == null ? void 0 : _a.input) == null ? void 0 : _b.setAttribute("aria-expanded", `${visible}`);
          if (visible) {
            updatePopperPosition();
            vue.nextTick((_c = panel.value) == null ? void 0 : _c.scrollToExpandingNode);
          } else if (props.filterable) {
            const { value } = presentText;
            inputValue.value = value;
            searchInputValue.value = value;
          }
          emit("visible-change", visible);
        }
      };
      const updatePopperPosition = () => {
        vue.nextTick(() => {
          var _a;
          (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper();
        });
      };
      const hideSuggestionPanel = () => {
        filtering.value = false;
      };
      const genTag = (node) => {
        const { showAllLevels, separator } = props;
        return {
          node,
          key: node.uid,
          text: node.calcText(showAllLevels, separator),
          hitState: false,
          closable: !isDisabled.value && !node.isDisabled,
          isCollapseTag: false
        };
      };
      const deleteTag = (tag) => {
        var _a;
        const node = tag.node;
        node.doCheck(false);
        (_a = panel.value) == null ? void 0 : _a.calculateCheckedValue();
        emit("remove-tag", node.valueByOption);
      };
      const calculatePresentTags = () => {
        if (!multiple.value)
          return;
        const nodes = checkedNodes.value;
        const tags = [];
        const allTags = [];
        nodes.forEach((node) => allTags.push(genTag(node)));
        allPresentTags.value = allTags;
        if (nodes.length) {
          const [first, ...rest] = nodes;
          const restCount = rest.length;
          tags.push(genTag(first));
          if (restCount) {
            if (props.collapseTags) {
              tags.push({
                key: -1,
                text: `+ ${restCount}`,
                closable: false,
                isCollapseTag: true
              });
            } else {
              rest.forEach((node) => tags.push(genTag(node)));
            }
          }
        }
        presentTags.value = tags;
      };
      const calculateSuggestions = () => {
        var _a, _b;
        const { filterMethod, showAllLevels, separator } = props;
        const res = (_b = (_a = panel.value) == null ? void 0 : _a.getFlattedNodes(!props.props.checkStrictly)) == null ? void 0 : _b.filter((node) => {
          if (node.isDisabled)
            return false;
          node.calcText(showAllLevels, separator);
          return filterMethod(node, searchKeyword.value);
        });
        if (multiple.value) {
          presentTags.value.forEach((tag) => {
            tag.hitState = false;
          });
          allPresentTags.value.forEach((tag) => {
            tag.hitState = false;
          });
        }
        filtering.value = true;
        suggestions.value = res;
        updatePopperPosition();
      };
      const focusFirstNode = () => {
        var _a;
        let firstNode;
        if (filtering.value && suggestionPanel.value) {
          firstNode = suggestionPanel.value.$el.querySelector(`.${nsCascader.e("suggestion-item")}`);
        } else {
          firstNode = (_a = panel.value) == null ? void 0 : _a.$el.querySelector(`.${nsCascader.b("node")}[tabindex="-1"]`);
        }
        if (firstNode) {
          firstNode.focus();
          !filtering.value && firstNode.click();
        }
      };
      const updateStyle = () => {
        var _a, _b;
        const inputInner = (_a = input.value) == null ? void 0 : _a.input;
        const tagWrapperEl = tagWrapper.value;
        const suggestionPanelEl = (_b = suggestionPanel.value) == null ? void 0 : _b.$el;
        if (!isClient || !inputInner)
          return;
        if (suggestionPanelEl) {
          const suggestionList = suggestionPanelEl.querySelector(`.${nsCascader.e("suggestion-list")}`);
          suggestionList.style.minWidth = `${inputInner.offsetWidth}px`;
        }
        if (tagWrapperEl) {
          const { offsetHeight } = tagWrapperEl;
          const height = presentTags.value.length > 0 ? `${Math.max(offsetHeight + 6, inputInitialHeight)}px` : `${inputInitialHeight}px`;
          inputInner.style.height = height;
          updatePopperPosition();
        }
      };
      const getCheckedNodes = (leafOnly) => {
        var _a;
        return (_a = panel.value) == null ? void 0 : _a.getCheckedNodes(leafOnly);
      };
      const handleExpandChange = (value) => {
        updatePopperPosition();
        emit("expand-change", value);
      };
      const handleComposition = (event) => {
        var _a;
        const text = (_a = event.target) == null ? void 0 : _a.value;
        if (event.type === "compositionend") {
          isOnComposition.value = false;
          vue.nextTick(() => handleInput(text));
        } else {
          const lastCharacter = text[text.length - 1] || "";
          isOnComposition.value = !isKorean(lastCharacter);
        }
      };
      const handleKeyDown = (e) => {
        if (isOnComposition.value)
          return;
        switch (e.code) {
          case EVENT_CODE.enter:
            togglePopperVisible();
            break;
          case EVENT_CODE.down:
            togglePopperVisible(true);
            vue.nextTick(focusFirstNode);
            e.preventDefault();
            break;
          case EVENT_CODE.esc:
          case EVENT_CODE.tab:
            togglePopperVisible(false);
            break;
        }
      };
      const handleClear = () => {
        var _a;
        (_a = panel.value) == null ? void 0 : _a.clearCheckedNodes();
        togglePopperVisible(false);
      };
      const handleSuggestionClick = (node) => {
        var _a, _b;
        const { checked } = node;
        if (multiple.value) {
          (_a = panel.value) == null ? void 0 : _a.handleCheckChange(node, !checked, false);
        } else {
          !checked && ((_b = panel.value) == null ? void 0 : _b.handleCheckChange(node, true, false));
          togglePopperVisible(false);
        }
      };
      const handleSuggestionKeyDown = (e) => {
        const target = e.target;
        const { code } = e;
        switch (code) {
          case EVENT_CODE.up:
          case EVENT_CODE.down: {
            const distance = code === EVENT_CODE.up ? -1 : 1;
            focusNode(getSibling(target, distance, `.${nsCascader.e("suggestion-item")}[tabindex="-1"]`));
            break;
          }
          case EVENT_CODE.enter:
            target.click();
            break;
          case EVENT_CODE.esc:
          case EVENT_CODE.tab:
            togglePopperVisible(false);
            break;
        }
      };
      const handleDelete = () => {
        const tags = presentTags.value;
        const lastTag = tags[tags.length - 1];
        pressDeleteCount = searchInputValue.value ? 0 : pressDeleteCount + 1;
        if (!lastTag || !pressDeleteCount)
          return;
        if (lastTag.hitState) {
          deleteTag(lastTag);
        } else {
          lastTag.hitState = true;
        }
      };
      const handleFilter = debounce$1(() => {
        const { value } = searchKeyword;
        if (!value)
          return;
        const passed = props.beforeFilter(value);
        if (isPromise(passed)) {
          passed.then(calculateSuggestions).catch(() => {
          });
        } else if (passed !== false) {
          calculateSuggestions();
        } else {
          hideSuggestionPanel();
        }
      }, props.debounce);
      const handleInput = (val, e) => {
        !popperVisible.value && togglePopperVisible(true);
        if (e == null ? void 0 : e.isComposing)
          return;
        val ? handleFilter() : hideSuggestionPanel();
      };
      vue.watch(filtering, updatePopperPosition);
      vue.watch([checkedNodes, isDisabled], calculatePresentTags);
      vue.watch(presentTags, () => {
        vue.nextTick(() => updateStyle());
      });
      vue.watch(presentText, (val) => inputValue.value = val, { immediate: true });
      vue.onMounted(() => {
        var _a;
        const inputEl = (_a = input.value) == null ? void 0 : _a.$el;
        inputInitialHeight = (inputEl == null ? void 0 : inputEl.offsetHeight) || INPUT_HEIGHT_MAP[realSize.value] || DEFAULT_INPUT_HEIGHT;
        addResizeListener(inputEl, updateStyle);
      });
      vue.onBeforeUnmount(() => {
        var _a;
        removeResizeListener((_a = input.value) == null ? void 0 : _a.$el, updateStyle);
      });
      return {
        popperOptions,
        tooltipRef,
        popperPaneRef,
        input,
        tagWrapper,
        panel,
        suggestionPanel,
        popperVisible,
        inputHover,
        inputPlaceholder,
        filtering,
        presentText,
        checkedValue,
        inputValue,
        searchInputValue,
        presentTags,
        allPresentTags,
        suggestions,
        isDisabled,
        isOnComposition,
        realSize,
        tagSize,
        multiple,
        readonly,
        clearBtnVisible,
        compatTeleported,
        nsCascader,
        nsInput,
        t,
        togglePopperVisible,
        hideSuggestionPanel,
        deleteTag,
        focusFirstNode,
        getCheckedNodes,
        handleExpandChange,
        handleKeyDown,
        handleComposition,
        handleClear,
        handleSuggestionClick,
        handleSuggestionKeyDown,
        handleDelete,
        handleInput
      };
    }
  });
  const _hoisted_1$K = { key: 0 };
  const _hoisted_2$u = { class: "el-cascader__collapse-tags" };
  const _hoisted_3$j = ["placeholder"];
  const _hoisted_4$d = ["onClick"];
  function _sfc_render$1h(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_circle_close = vue.resolveComponent("circle-close");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_arrow_down = vue.resolveComponent("arrow-down");
    const _component_el_input = vue.resolveComponent("el-input");
    const _component_el_tag = vue.resolveComponent("el-tag");
    const _component_el_tooltip = vue.resolveComponent("el-tooltip");
    const _component_el_cascader_panel = vue.resolveComponent("el-cascader-panel");
    const _component_check = vue.resolveComponent("check");
    const _component_el_scrollbar = vue.resolveComponent("el-scrollbar");
    const _directive_clickoutside = vue.resolveDirective("clickoutside");
    return vue.openBlock(), vue.createBlock(_component_el_tooltip, {
      ref: "tooltipRef",
      visible: _ctx.popperVisible,
      "onUpdate:visible": _cache[17] || (_cache[17] = ($event) => _ctx.popperVisible = $event),
      teleported: _ctx.compatTeleported,
      "popper-class": [_ctx.nsCascader.e("dropdown"), _ctx.popperClass],
      "popper-options": _ctx.popperOptions,
      "fallback-placements": [
        "bottom-start",
        "bottom",
        "top-start",
        "top",
        "right",
        "left"
      ],
      "stop-popper-mouse-event": false,
      "gpu-acceleration": false,
      placement: "bottom-start",
      transition: `${_ctx.nsCascader.namespace.value}-zoom-in-top`,
      effect: "light",
      pure: "",
      persistent: "",
      onHide: _ctx.hideSuggestionPanel
    }, {
      default: vue.withCtx(() => [
        vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass([
            _ctx.nsCascader.b(),
            _ctx.nsCascader.m(_ctx.realSize),
            _ctx.nsCascader.is("disabled", _ctx.isDisabled),
            _ctx.$attrs.class
          ]),
          style: vue.normalizeStyle(_ctx.$attrs.style),
          onClick: _cache[11] || (_cache[11] = () => _ctx.togglePopperVisible(_ctx.readonly ? void 0 : true)),
          onKeydown: _cache[12] || (_cache[12] = (...args) => _ctx.handleKeyDown && _ctx.handleKeyDown(...args)),
          onMouseenter: _cache[13] || (_cache[13] = ($event) => _ctx.inputHover = true),
          onMouseleave: _cache[14] || (_cache[14] = ($event) => _ctx.inputHover = false)
        }, [
          vue.createVNode(_component_el_input, {
            ref: "input",
            modelValue: _ctx.inputValue,
            "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => _ctx.inputValue = $event),
            placeholder: _ctx.inputPlaceholder,
            readonly: _ctx.readonly,
            disabled: _ctx.isDisabled,
            "validate-event": false,
            size: _ctx.realSize,
            class: vue.normalizeClass(_ctx.nsCascader.is("focus", _ctx.popperVisible)),
            onCompositionstart: _ctx.handleComposition,
            onCompositionupdate: _ctx.handleComposition,
            onCompositionend: _ctx.handleComposition,
            onFocus: _cache[2] || (_cache[2] = (e) => _ctx.$emit("focus", e)),
            onBlur: _cache[3] || (_cache[3] = (e) => _ctx.$emit("blur", e)),
            onInput: _ctx.handleInput
          }, {
            suffix: vue.withCtx(() => [
              _ctx.clearBtnVisible ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
                key: "clear",
                class: vue.normalizeClass([_ctx.nsInput.e("icon"), "icon-circle-close"]),
                onClick: vue.withModifiers(_ctx.handleClear, ["stop"])
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_circle_close)
                ]),
                _: 1
              }, 8, ["class", "onClick"])) : (vue.openBlock(), vue.createBlock(_component_el_icon, {
                key: "arrow-down",
                class: vue.normalizeClass([
                  _ctx.nsInput.e("icon"),
                  "icon-arrow-down",
                  _ctx.nsCascader.is("reverse", _ctx.popperVisible)
                ]),
                onClick: _cache[0] || (_cache[0] = vue.withModifiers(($event) => _ctx.togglePopperVisible(), ["stop"]))
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_down)
                ]),
                _: 1
              }, 8, ["class"]))
            ]),
            _: 1
          }, 8, ["modelValue", "placeholder", "readonly", "disabled", "size", "class", "onCompositionstart", "onCompositionupdate", "onCompositionend", "onInput"]),
          _ctx.multiple ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 0,
            ref: "tagWrapper",
            class: vue.normalizeClass(_ctx.nsCascader.e("tags"))
          }, [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.presentTags, (tag) => {
              return vue.openBlock(), vue.createBlock(_component_el_tag, {
                key: tag.key,
                type: "info",
                size: _ctx.tagSize,
                hit: tag.hitState,
                closable: tag.closable,
                "disable-transitions": "",
                onClose: ($event) => _ctx.deleteTag(tag)
              }, {
                default: vue.withCtx(() => [
                  tag.isCollapseTag === false ? (vue.openBlock(), vue.createElementBlock("span", _hoisted_1$K, vue.toDisplayString(tag.text), 1)) : (vue.openBlock(), vue.createBlock(_component_el_tooltip, {
                    key: 1,
                    teleported: false,
                    disabled: _ctx.popperVisible || !_ctx.collapseTagsTooltip,
                    "fallback-placements": ["bottom", "top", "right", "left"],
                    placement: "bottom",
                    effect: "light"
                  }, {
                    default: vue.withCtx(() => [
                      vue.createElementVNode("span", null, vue.toDisplayString(tag.text), 1)
                    ]),
                    content: vue.withCtx(() => [
                      vue.createElementVNode("div", _hoisted_2$u, [
                        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.allPresentTags, (tag2, idx) => {
                          return vue.openBlock(), vue.createElementBlock("div", {
                            key: idx,
                            class: "el-cascader__collapse-tag"
                          }, [
                            (vue.openBlock(), vue.createBlock(_component_el_tag, {
                              key: tag2.key,
                              class: "in-tooltip",
                              type: "info",
                              size: _ctx.tagSize,
                              hit: tag2.hitState,
                              closable: tag2.closable,
                              "disable-transitions": "",
                              onClose: ($event) => _ctx.deleteTag(tag2)
                            }, {
                              default: vue.withCtx(() => [
                                vue.createElementVNode("span", null, vue.toDisplayString(tag2.text), 1)
                              ]),
                              _: 2
                            }, 1032, ["size", "hit", "closable", "onClose"]))
                          ]);
                        }), 128))
                      ])
                    ]),
                    _: 2
                  }, 1032, ["disabled"]))
                ]),
                _: 2
              }, 1032, ["size", "hit", "closable", "onClose"]);
            }), 128)),
            _ctx.filterable && !_ctx.isDisabled ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
              key: 0,
              "onUpdate:modelValue": _cache[4] || (_cache[4] = ($event) => _ctx.searchInputValue = $event),
              type: "text",
              class: vue.normalizeClass(_ctx.nsCascader.e("search-input")),
              placeholder: _ctx.presentText ? "" : _ctx.inputPlaceholder,
              onInput: _cache[5] || (_cache[5] = (e) => _ctx.handleInput(_ctx.searchInputValue, e)),
              onClick: _cache[6] || (_cache[6] = vue.withModifiers(($event) => _ctx.togglePopperVisible(true), ["stop"])),
              onKeydown: _cache[7] || (_cache[7] = vue.withKeys((...args) => _ctx.handleDelete && _ctx.handleDelete(...args), ["delete"])),
              onCompositionstart: _cache[8] || (_cache[8] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
              onCompositionupdate: _cache[9] || (_cache[9] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
              onCompositionend: _cache[10] || (_cache[10] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args))
            }, null, 42, _hoisted_3$j)), [
              [vue.vModelText, _ctx.searchInputValue]
            ]) : vue.createCommentVNode("v-if", true)
          ], 2)) : vue.createCommentVNode("v-if", true)
        ], 38)), [
          [_directive_clickoutside, () => _ctx.togglePopperVisible(false), _ctx.popperPaneRef]
        ])
      ]),
      content: vue.withCtx(() => [
        vue.withDirectives(vue.createVNode(_component_el_cascader_panel, {
          ref: "panel",
          modelValue: _ctx.checkedValue,
          "onUpdate:modelValue": _cache[15] || (_cache[15] = ($event) => _ctx.checkedValue = $event),
          options: _ctx.options,
          props: _ctx.props,
          border: false,
          "render-label": _ctx.$slots.default,
          onExpandChange: _ctx.handleExpandChange,
          onClose: _cache[16] || (_cache[16] = ($event) => _ctx.$nextTick(() => _ctx.togglePopperVisible(false)))
        }, null, 8, ["modelValue", "options", "props", "render-label", "onExpandChange"]), [
          [vue.vShow, !_ctx.filtering]
        ]),
        _ctx.filterable ? vue.withDirectives((vue.openBlock(), vue.createBlock(_component_el_scrollbar, {
          key: 0,
          ref: "suggestionPanel",
          tag: "ul",
          class: vue.normalizeClass(_ctx.nsCascader.e("suggestion-panel")),
          "view-class": _ctx.nsCascader.e("suggestion-list"),
          onKeydown: _ctx.handleSuggestionKeyDown
        }, {
          default: vue.withCtx(() => [
            _ctx.suggestions.length ? (vue.openBlock(true), vue.createElementBlock(vue.Fragment, { key: 0 }, vue.renderList(_ctx.suggestions, (item) => {
              return vue.openBlock(), vue.createElementBlock("li", {
                key: item.uid,
                class: vue.normalizeClass([
                  _ctx.nsCascader.e("suggestion-item"),
                  _ctx.nsCascader.is("checked", item.checked)
                ]),
                tabindex: -1,
                onClick: ($event) => _ctx.handleSuggestionClick(item)
              }, [
                vue.createElementVNode("span", null, vue.toDisplayString(item.text), 1),
                item.checked ? (vue.openBlock(), vue.createBlock(_component_el_icon, { key: 0 }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_check)
                  ]),
                  _: 1
                })) : vue.createCommentVNode("v-if", true)
              ], 10, _hoisted_4$d);
            }), 128)) : vue.renderSlot(_ctx.$slots, "empty", { key: 1 }, () => [
              vue.createElementVNode("li", {
                class: vue.normalizeClass(_ctx.nsCascader.e("empty-text"))
              }, vue.toDisplayString(_ctx.t("el.cascader.noMatch")), 3)
            ])
          ]),
          _: 3
        }, 8, ["class", "view-class", "onKeydown"])), [
          [vue.vShow, _ctx.filtering]
        ]) : vue.createCommentVNode("v-if", true)
      ]),
      _: 3
    }, 8, ["visible", "teleported", "popper-class", "popper-options", "transition", "onHide"]);
  }
  var Cascader = /* @__PURE__ */ _export_sfc(_sfc_main$1x, [["render", _sfc_render$1h]]);

  Cascader.install = (app) => {
    app.component(Cascader.name, Cascader);
  };
  const _Cascader = Cascader;
  const ElCascader = _Cascader;

  const checkTagProps = buildProps({
    checked: {
      type: Boolean,
      default: false
    }
  });
  const checkTagEmits = {
    "update:checked": (value) => isBoolean(value),
    change: (value) => isBoolean(value)
  };

  const __default__$c = {
    name: "ElCheckTag"
  };
  const _sfc_main$1w = /* @__PURE__ */ vue.defineComponent({
    ...__default__$c,
    props: checkTagProps,
    emits: checkTagEmits,
    setup(__props, { emit }) {
      const props = __props;
      const ns = useNamespace("check-tag");
      const handleChange = () => {
        const checked = !props.checked;
        emit("change", checked);
        emit("update:checked", checked);
      };
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("span", {
          class: vue.normalizeClass([vue.unref(ns).b(), vue.unref(ns).is("checked", _ctx.checked)]),
          onClick: handleChange
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2);
      };
    }
  });
  var CheckTag = _sfc_main$1w;

  const ElCheckTag = withInstall(CheckTag);

  const colProps = buildProps({
    tag: {
      type: String,
      default: "div"
    },
    span: {
      type: Number,
      default: 24
    },
    offset: {
      type: Number,
      default: 0
    },
    pull: {
      type: Number,
      default: 0
    },
    push: {
      type: Number,
      default: 0
    },
    xs: {
      type: definePropType([Number, Object]),
      default: () => mutable({})
    },
    sm: {
      type: definePropType([Number, Object]),
      default: () => mutable({})
    },
    md: {
      type: definePropType([Number, Object]),
      default: () => mutable({})
    },
    lg: {
      type: definePropType([Number, Object]),
      default: () => mutable({})
    },
    xl: {
      type: definePropType([Number, Object]),
      default: () => mutable({})
    }
  });
  var Col = vue.defineComponent({
    name: "ElCol",
    props: colProps,
    setup(props, {
      slots
    }) {
      const {
        gutter
      } = vue.inject(rowContextKey, {
        gutter: vue.computed(() => 0)
      });
      const ns = useNamespace("col");
      const style = vue.computed(() => {
        if (gutter.value) {
          return {
            paddingLeft: `${gutter.value / 2}px`,
            paddingRight: `${gutter.value / 2}px`
          };
        }
        return {};
      });
      const classes = vue.computed(() => {
        const classes2 = [];
        const pos = ["span", "offset", "pull", "push"];
        pos.forEach((prop) => {
          const size = props[prop];
          if (typeof size === "number") {
            if (prop === "span")
              classes2.push(ns.b(`${props[prop]}`));
            else if (size > 0)
              classes2.push(ns.b(`${prop}-${props[prop]}`));
          }
        });
        const sizes = ["xs", "sm", "md", "lg", "xl"];
        sizes.forEach((size) => {
          if (typeof props[size] === "number") {
            classes2.push(ns.b(`${size}-${props[size]}`));
          } else if (typeof props[size] === "object") {
            const sizeProps = props[size];
            Object.keys(sizeProps).forEach((prop) => {
              classes2.push(prop !== "span" ? ns.b(`${size}-${prop}-${sizeProps[prop]}`) : ns.b(`${size}-${sizeProps[prop]}`));
            });
          }
        });
        if (gutter.value) {
          classes2.push(ns.is("guttered"));
        }
        return classes2;
      });
      return () => vue.createVNode(props.tag, {
        "class": [ns.b(), classes.value],
        "style": style.value
      }, slots);
    }
  });

  const ElCol = withInstall(Col);

  const emitChangeFn = (value) => typeof isNumber(value);
  const collapseProps = buildProps({
    accordion: Boolean,
    modelValue: {
      type: definePropType([Array, String, Number]),
      default: () => mutable([])
    }
  });
  const collapseEmits = {
    [UPDATE_MODEL_EVENT]: emitChangeFn,
    [CHANGE_EVENT]: emitChangeFn
  };

  const __default__$b = {
    name: "ElCollapse"
  };
  const _sfc_main$1v = /* @__PURE__ */ vue.defineComponent({
    ...__default__$b,
    props: collapseProps,
    emits: collapseEmits,
    setup(__props, { expose, emit }) {
      const props = __props;
      const ns = useNamespace("collapse");
      const activeNames = vue.ref(castArray$1(props.modelValue));
      const setActiveNames = (_activeNames) => {
        activeNames.value = _activeNames;
        const value = props.accordion ? activeNames.value[0] : activeNames.value;
        emit(UPDATE_MODEL_EVENT, value);
        emit(CHANGE_EVENT, value);
      };
      const handleItemClick = (name) => {
        if (props.accordion) {
          setActiveNames([
            (activeNames.value[0] || activeNames.value[0] === 0) && activeNames.value[0] === name ? "" : name
          ]);
        } else {
          const _activeNames = [...activeNames.value];
          const index = _activeNames.indexOf(name);
          if (index > -1) {
            _activeNames.splice(index, 1);
          } else {
            _activeNames.push(name);
          }
          setActiveNames(_activeNames);
        }
      };
      vue.watch(() => props.modelValue, () => activeNames.value = castArray$1(props.modelValue), { deep: true });
      vue.provide(collapseContextKey, {
        activeNames,
        handleItemClick
      });
      expose({
        activeNames,
        setActiveNames
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass(vue.unref(ns).b()),
          role: "tablist",
          "aria-multiselectable": "true"
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2);
      };
    }
  });
  var Collapse = _sfc_main$1v;

  const _sfc_main$1u = vue.defineComponent({
    name: "ElCollapseTransition",
    setup() {
      const ns = useNamespace("collapse-transition");
      return {
        ns,
        on: {
          beforeEnter(el) {
            if (!el.dataset)
              el.dataset = {};
            el.dataset.oldPaddingTop = el.style.paddingTop;
            el.dataset.oldPaddingBottom = el.style.paddingBottom;
            el.style.maxHeight = 0;
            el.style.paddingTop = 0;
            el.style.paddingBottom = 0;
          },
          enter(el) {
            el.dataset.oldOverflow = el.style.overflow;
            if (el.scrollHeight !== 0) {
              el.style.maxHeight = `${el.scrollHeight}px`;
              el.style.paddingTop = el.dataset.oldPaddingTop;
              el.style.paddingBottom = el.dataset.oldPaddingBottom;
            } else {
              el.style.maxHeight = 0;
              el.style.paddingTop = el.dataset.oldPaddingTop;
              el.style.paddingBottom = el.dataset.oldPaddingBottom;
            }
            el.style.overflow = "hidden";
          },
          afterEnter(el) {
            el.style.maxHeight = "";
            el.style.overflow = el.dataset.oldOverflow;
          },
          beforeLeave(el) {
            if (!el.dataset)
              el.dataset = {};
            el.dataset.oldPaddingTop = el.style.paddingTop;
            el.dataset.oldPaddingBottom = el.style.paddingBottom;
            el.dataset.oldOverflow = el.style.overflow;
            el.style.maxHeight = `${el.scrollHeight}px`;
            el.style.overflow = "hidden";
          },
          leave(el) {
            if (el.scrollHeight !== 0) {
              el.style.maxHeight = 0;
              el.style.paddingTop = 0;
              el.style.paddingBottom = 0;
            }
          },
          afterLeave(el) {
            el.style.maxHeight = "";
            el.style.overflow = el.dataset.oldOverflow;
            el.style.paddingTop = el.dataset.oldPaddingTop;
            el.style.paddingBottom = el.dataset.oldPaddingBottom;
          }
        }
      };
    }
  });
  function _sfc_render$1g(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createBlock(vue.Transition, vue.mergeProps({
      name: _ctx.ns.b()
    }, vue.toHandlers(_ctx.on)), {
      default: vue.withCtx(() => [
        vue.renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 16, ["name"]);
  }
  var CollapseTransition = /* @__PURE__ */ _export_sfc(_sfc_main$1u, [["render", _sfc_render$1g]]);

  CollapseTransition.install = (app) => {
    app.component(CollapseTransition.name, CollapseTransition);
  };
  const _CollapseTransition = CollapseTransition;
  const ElCollapseTransition = _CollapseTransition;

  const collapseItemProps = buildProps({
    title: {
      type: String,
      default: ""
    },
    name: {
      type: definePropType([String, Number]),
      default: () => generateId()
    },
    disabled: Boolean
  });

  const _hoisted_1$J = ["aria-expanded", "aria-controls", "aria-describedby"];
  const _hoisted_2$t = ["id", "tabindex", "onKeypress"];
  const _hoisted_3$i = ["id", "aria-hidden", "aria-labelledby"];
  const __default__$a = {
    name: "ElCollapseItem"
  };
  const _sfc_main$1t = /* @__PURE__ */ vue.defineComponent({
    ...__default__$a,
    props: collapseItemProps,
    setup(__props, { expose }) {
      const props = __props;
      const collapse = vue.inject(collapseContextKey);
      const ns = useNamespace("collapse");
      const focusing = vue.ref(false);
      const isClick = vue.ref(false);
      const id = vue.ref(generateId());
      const isActive = vue.computed(() => collapse == null ? void 0 : collapse.activeNames.value.includes(props.name));
      const handleFocus = () => {
        setTimeout(() => {
          if (!isClick.value) {
            focusing.value = true;
          } else {
            isClick.value = false;
          }
        }, 50);
      };
      const handleHeaderClick = () => {
        if (props.disabled)
          return;
        collapse == null ? void 0 : collapse.handleItemClick(props.name);
        focusing.value = false;
        isClick.value = true;
      };
      const handleEnterClick = () => {
        collapse == null ? void 0 : collapse.handleItemClick(props.name);
      };
      expose({
        isActive
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass([
            vue.unref(ns).b("item"),
            vue.unref(ns).is("active", vue.unref(isActive)),
            vue.unref(ns).is("disabled", _ctx.disabled)
          ])
        }, [
          vue.createElementVNode("div", {
            role: "tab",
            "aria-expanded": vue.unref(isActive),
            "aria-controls": vue.unref(ns).b(`content-${id.value}`),
            "aria-describedby": vue.unref(ns).b(`content-${id.value}`)
          }, [
            vue.createElementVNode("div", {
              id: vue.unref(ns).b(`head-${id.value}`),
              class: vue.normalizeClass([
                vue.unref(ns).be("item", "header"),
                vue.unref(ns).is("active", vue.unref(isActive)),
                { focusing: focusing.value }
              ]),
              role: "button",
              tabindex: _ctx.disabled ? -1 : 0,
              onClick: handleHeaderClick,
              onKeypress: vue.withKeys(vue.withModifiers(handleEnterClick, ["stop", "prevent"]), ["space", "enter"]),
              onFocus: handleFocus,
              onBlur: _cache[0] || (_cache[0] = ($event) => focusing.value = false)
            }, [
              vue.renderSlot(_ctx.$slots, "title", {}, () => [
                vue.createTextVNode(vue.toDisplayString(_ctx.title), 1)
              ]),
              vue.createVNode(vue.unref(ElIcon), {
                class: vue.normalizeClass([vue.unref(ns).be("item", "arrow"), vue.unref(ns).is("active", vue.unref(isActive))])
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(vue.unref(arrowRight))
                ]),
                _: 1
              }, 8, ["class"])
            ], 42, _hoisted_2$t)
          ], 8, _hoisted_1$J),
          vue.createVNode(vue.unref(_CollapseTransition), null, {
            default: vue.withCtx(() => [
              vue.withDirectives(vue.createElementVNode("div", {
                id: vue.unref(ns).b(`content-${id.value}`),
                class: vue.normalizeClass(vue.unref(ns).be("item", "wrap")),
                role: "tabpanel",
                "aria-hidden": !vue.unref(isActive),
                "aria-labelledby": vue.unref(ns).b(`head-${id.value}`)
              }, [
                vue.createElementVNode("div", {
                  class: vue.normalizeClass(vue.unref(ns).be("item", "content"))
                }, [
                  vue.renderSlot(_ctx.$slots, "default")
                ], 2)
              ], 10, _hoisted_3$i), [
                [vue.vShow, vue.unref(isActive)]
              ])
            ]),
            _: 3
          })
        ], 2);
      };
    }
  });
  var CollapseItem = _sfc_main$1t;

  const ElCollapse = withInstall(Collapse, {
    CollapseItem
  });
  const ElCollapseItem = withNoopInstall(CollapseItem);

  let isDragging = false;
  function draggable(element, options) {
    if (!isClient)
      return;
    const moveFn = function(event) {
      var _a;
      (_a = options.drag) == null ? void 0 : _a.call(options, event);
    };
    const upFn = function(event) {
      var _a;
      off(document, "mousemove", moveFn);
      off(document, "mouseup", upFn);
      off(document, "touchmove", moveFn);
      off(document, "touchend", upFn);
      document.onselectstart = null;
      document.ondragstart = null;
      isDragging = false;
      (_a = options.end) == null ? void 0 : _a.call(options, event);
    };
    const downFn = function(event) {
      var _a;
      if (isDragging)
        return;
      event.preventDefault();
      document.onselectstart = () => false;
      document.ondragstart = () => false;
      on(document, "mousemove", moveFn);
      on(document, "mouseup", upFn);
      on(document, "touchmove", moveFn);
      on(document, "touchend", upFn);
      isDragging = true;
      (_a = options.start) == null ? void 0 : _a.call(options, event);
    };
    on(element, "mousedown", downFn);
    on(element, "touchstart", downFn);
  }

  const _sfc_main$1s = vue.defineComponent({
    name: "ElColorAlphaSlider",
    props: {
      color: {
        type: Object,
        required: true
      },
      vertical: {
        type: Boolean,
        default: false
      }
    },
    setup(props) {
      const instance = vue.getCurrentInstance();
      const thumb = vue.shallowRef(null);
      const bar = vue.shallowRef(null);
      const thumbLeft = vue.ref(0);
      const thumbTop = vue.ref(0);
      const background = vue.ref(null);
      vue.watch(() => props.color.get("alpha"), () => {
        update();
      });
      vue.watch(() => props.color.value, () => {
        update();
      });
      function getThumbLeft() {
        if (props.vertical)
          return 0;
        const el = instance.vnode.el;
        const alpha = props.color.get("alpha");
        if (!el)
          return 0;
        return Math.round(alpha * (el.offsetWidth - thumb.value.offsetWidth / 2) / 100);
      }
      function getThumbTop() {
        const el = instance.vnode.el;
        if (!props.vertical)
          return 0;
        const alpha = props.color.get("alpha");
        if (!el)
          return 0;
        return Math.round(alpha * (el.offsetHeight - thumb.value.offsetHeight / 2) / 100);
      }
      function getBackground() {
        if (props.color && props.color.value) {
          const { r, g, b } = props.color.toRgb();
          return `linear-gradient(to right, rgba(${r}, ${g}, ${b}, 0) 0%, rgba(${r}, ${g}, ${b}, 1) 100%)`;
        }
        return null;
      }
      function handleClick(event) {
        const target = event.target;
        if (target !== thumb.value) {
          handleDrag(event);
        }
      }
      function handleDrag(event) {
        const el = instance.vnode.el;
        const rect = el.getBoundingClientRect();
        const { clientX, clientY } = getClientXY(event);
        if (!props.vertical) {
          let left = clientX - rect.left;
          left = Math.max(thumb.value.offsetWidth / 2, left);
          left = Math.min(left, rect.width - thumb.value.offsetWidth / 2);
          props.color.set("alpha", Math.round((left - thumb.value.offsetWidth / 2) / (rect.width - thumb.value.offsetWidth) * 100));
        } else {
          let top = clientY - rect.top;
          top = Math.max(thumb.value.offsetHeight / 2, top);
          top = Math.min(top, rect.height - thumb.value.offsetHeight / 2);
          props.color.set("alpha", Math.round((top - thumb.value.offsetHeight / 2) / (rect.height - thumb.value.offsetHeight) * 100));
        }
      }
      function update() {
        thumbLeft.value = getThumbLeft();
        thumbTop.value = getThumbTop();
        background.value = getBackground();
      }
      vue.onMounted(() => {
        const dragConfig = {
          drag: (event) => {
            handleDrag(event);
          },
          end: (event) => {
            handleDrag(event);
          }
        };
        draggable(bar.value, dragConfig);
        draggable(thumb.value, dragConfig);
        update();
      });
      return {
        thumb,
        bar,
        thumbLeft,
        thumbTop,
        background,
        handleClick,
        update
      };
    }
  });
  function _sfc_render$1f(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(["el-color-alpha-slider", { "is-vertical": _ctx.vertical }])
    }, [
      vue.createElementVNode("div", {
        ref: "bar",
        class: "el-color-alpha-slider__bar",
        style: vue.normalizeStyle({
          background: _ctx.background
        }),
        onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
      }, null, 4),
      vue.createElementVNode("div", {
        ref: "thumb",
        class: "el-color-alpha-slider__thumb",
        style: vue.normalizeStyle({
          left: _ctx.thumbLeft + "px",
          top: _ctx.thumbTop + "px"
        })
      }, null, 4)
    ], 2);
  }
  var AlphaSlider = /* @__PURE__ */ _export_sfc(_sfc_main$1s, [["render", _sfc_render$1f]]);

  const _sfc_main$1r = vue.defineComponent({
    name: "ElColorHueSlider",
    props: {
      color: {
        type: Object,
        required: true
      },
      vertical: Boolean
    },
    setup(props) {
      const instance = vue.getCurrentInstance();
      const thumb = vue.ref(null);
      const bar = vue.ref(null);
      const thumbLeft = vue.ref(0);
      const thumbTop = vue.ref(0);
      const hueValue = vue.computed(() => {
        return props.color.get("hue");
      });
      vue.watch(() => hueValue.value, () => {
        update();
      });
      function handleClick(event) {
        const target = event.target;
        if (target !== thumb.value) {
          handleDrag(event);
        }
      }
      function handleDrag(event) {
        const el = instance.vnode.el;
        const rect = el.getBoundingClientRect();
        const { clientX, clientY } = getClientXY(event);
        let hue;
        if (!props.vertical) {
          let left = clientX - rect.left;
          left = Math.min(left, rect.width - thumb.value.offsetWidth / 2);
          left = Math.max(thumb.value.offsetWidth / 2, left);
          hue = Math.round((left - thumb.value.offsetWidth / 2) / (rect.width - thumb.value.offsetWidth) * 360);
        } else {
          let top = clientY - rect.top;
          top = Math.min(top, rect.height - thumb.value.offsetHeight / 2);
          top = Math.max(thumb.value.offsetHeight / 2, top);
          hue = Math.round((top - thumb.value.offsetHeight / 2) / (rect.height - thumb.value.offsetHeight) * 360);
        }
        props.color.set("hue", hue);
      }
      function getThumbLeft() {
        const el = instance.vnode.el;
        if (props.vertical)
          return 0;
        const hue = props.color.get("hue");
        if (!el)
          return 0;
        return Math.round(hue * (el.offsetWidth - thumb.value.offsetWidth / 2) / 360);
      }
      function getThumbTop() {
        const el = instance.vnode.el;
        if (!props.vertical)
          return 0;
        const hue = props.color.get("hue");
        if (!el)
          return 0;
        return Math.round(hue * (el.offsetHeight - thumb.value.offsetHeight / 2) / 360);
      }
      function update() {
        thumbLeft.value = getThumbLeft();
        thumbTop.value = getThumbTop();
      }
      vue.onMounted(() => {
        const dragConfig = {
          drag: (event) => {
            handleDrag(event);
          },
          end: (event) => {
            handleDrag(event);
          }
        };
        draggable(bar.value, dragConfig);
        draggable(thumb.value, dragConfig);
        update();
      });
      return {
        bar,
        thumb,
        thumbLeft,
        thumbTop,
        hueValue,
        handleClick,
        update
      };
    }
  });
  function _sfc_render$1e(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(["el-color-hue-slider", { "is-vertical": _ctx.vertical }])
    }, [
      vue.createElementVNode("div", {
        ref: "bar",
        class: "el-color-hue-slider__bar",
        onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
      }, null, 512),
      vue.createElementVNode("div", {
        ref: "thumb",
        class: "el-color-hue-slider__thumb",
        style: vue.normalizeStyle({
          left: _ctx.thumbLeft + "px",
          top: _ctx.thumbTop + "px"
        })
      }, null, 4)
    ], 2);
  }
  var HueSlider = /* @__PURE__ */ _export_sfc(_sfc_main$1r, [["render", _sfc_render$1e]]);

  const OPTIONS_KEY = Symbol();
  const useOptions = () => {
    return vue.inject(OPTIONS_KEY);
  };

  const hsv2hsl = function(hue, sat, val) {
    return [
      hue,
      sat * val / ((hue = (2 - sat) * val) < 1 ? hue : 2 - hue) || 0,
      hue / 2
    ];
  };
  const isOnePointZero = function(n) {
    return typeof n === "string" && n.includes(".") && Number.parseFloat(n) === 1;
  };
  const isPercentage = function(n) {
    return typeof n === "string" && n.includes("%");
  };
  const bound01 = function(value, max) {
    if (isOnePointZero(value))
      value = "100%";
    const processPercent = isPercentage(value);
    value = Math.min(max, Math.max(0, Number.parseFloat(`${value}`)));
    if (processPercent) {
      value = Number.parseInt(`${value * max}`, 10) / 100;
    }
    if (Math.abs(value - max) < 1e-6) {
      return 1;
    }
    return value % max / Number.parseFloat(max);
  };
  const INT_HEX_MAP = { 10: "A", 11: "B", 12: "C", 13: "D", 14: "E", 15: "F" };
  const hexOne = function(value) {
    value = Math.min(Math.round(value), 255);
    const high = Math.floor(value / 16);
    const low = value % 16;
    return `${INT_HEX_MAP[high] || high}${INT_HEX_MAP[low] || low}`;
  };
  const toHex = function({ r, g, b }) {
    if (Number.isNaN(+r) || Number.isNaN(+g) || Number.isNaN(+b))
      return "";
    return `#${hexOne(r)}${hexOne(g)}${hexOne(b)}`;
  };
  const HEX_INT_MAP = { A: 10, B: 11, C: 12, D: 13, E: 14, F: 15 };
  const parseHexChannel = function(hex) {
    if (hex.length === 2) {
      return (HEX_INT_MAP[hex[0].toUpperCase()] || +hex[0]) * 16 + (HEX_INT_MAP[hex[1].toUpperCase()] || +hex[1]);
    }
    return HEX_INT_MAP[hex[1].toUpperCase()] || +hex[1];
  };
  const hsl2hsv = function(hue, sat, light) {
    sat = sat / 100;
    light = light / 100;
    let smin = sat;
    const lmin = Math.max(light, 0.01);
    light *= 2;
    sat *= light <= 1 ? light : 2 - light;
    smin *= lmin <= 1 ? lmin : 2 - lmin;
    const v = (light + sat) / 2;
    const sv = light === 0 ? 2 * smin / (lmin + smin) : 2 * sat / (light + sat);
    return {
      h: hue,
      s: sv * 100,
      v: v * 100
    };
  };
  const rgb2hsv = function(r, g, b) {
    r = bound01(r, 255);
    g = bound01(g, 255);
    b = bound01(b, 255);
    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);
    let h;
    const v = max;
    const d = max - min;
    const s = max === 0 ? 0 : d / max;
    if (max === min) {
      h = 0;
    } else {
      switch (max) {
        case r: {
          h = (g - b) / d + (g < b ? 6 : 0);
          break;
        }
        case g: {
          h = (b - r) / d + 2;
          break;
        }
        case b: {
          h = (r - g) / d + 4;
          break;
        }
      }
      h /= 6;
    }
    return { h: h * 360, s: s * 100, v: v * 100 };
  };
  const hsv2rgb = function(h, s, v) {
    h = bound01(h, 360) * 6;
    s = bound01(s, 100);
    v = bound01(v, 100);
    const i = Math.floor(h);
    const f = h - i;
    const p = v * (1 - s);
    const q = v * (1 - f * s);
    const t = v * (1 - (1 - f) * s);
    const mod = i % 6;
    const r = [v, q, p, p, t, v][mod];
    const g = [t, v, v, q, p, p][mod];
    const b = [p, p, t, v, v, q][mod];
    return {
      r: Math.round(r * 255),
      g: Math.round(g * 255),
      b: Math.round(b * 255)
    };
  };
  class Color {
    constructor(options) {
      this._hue = 0;
      this._saturation = 100;
      this._value = 100;
      this._alpha = 100;
      this.enableAlpha = false;
      this.format = "hex";
      this.value = "";
      options = options || {};
      for (const option in options) {
        if (hasOwn(options, option)) {
          this[option] = options[option];
        }
      }
      if (options.value) {
        this.fromString(options.value);
      } else {
        this.doOnChange();
      }
    }
    set(prop, value) {
      if (arguments.length === 1 && typeof prop === "object") {
        for (const p in prop) {
          if (hasOwn(prop, p)) {
            this.set(p, prop[p]);
          }
        }
        return;
      }
      this[`_${prop}`] = value;
      this.doOnChange();
    }
    get(prop) {
      if (prop === "alpha") {
        return Math.floor(this[`_${prop}`]);
      }
      return this[`_${prop}`];
    }
    toRgb() {
      return hsv2rgb(this._hue, this._saturation, this._value);
    }
    fromString(value) {
      if (!value) {
        this._hue = 0;
        this._saturation = 100;
        this._value = 100;
        this.doOnChange();
        return;
      }
      const fromHSV = (h, s, v) => {
        this._hue = Math.max(0, Math.min(360, h));
        this._saturation = Math.max(0, Math.min(100, s));
        this._value = Math.max(0, Math.min(100, v));
        this.doOnChange();
      };
      if (value.includes("hsl")) {
        const parts = value.replace(/hsla|hsl|\(|\)/gm, "").split(/\s|,/g).filter((val) => val !== "").map((val, index) => index > 2 ? Number.parseFloat(val) : Number.parseInt(val, 10));
        if (parts.length === 4) {
          this._alpha = Number.parseFloat(parts[3]) * 100;
        } else if (parts.length === 3) {
          this._alpha = 100;
        }
        if (parts.length >= 3) {
          const { h, s, v } = hsl2hsv(parts[0], parts[1], parts[2]);
          fromHSV(h, s, v);
        }
      } else if (value.includes("hsv")) {
        const parts = value.replace(/hsva|hsv|\(|\)/gm, "").split(/\s|,/g).filter((val) => val !== "").map((val, index) => index > 2 ? Number.parseFloat(val) : Number.parseInt(val, 10));
        if (parts.length === 4) {
          this._alpha = Number.parseFloat(parts[3]) * 100;
        } else if (parts.length === 3) {
          this._alpha = 100;
        }
        if (parts.length >= 3) {
          fromHSV(parts[0], parts[1], parts[2]);
        }
      } else if (value.includes("rgb")) {
        const parts = value.replace(/rgba|rgb|\(|\)/gm, "").split(/\s|,/g).filter((val) => val !== "").map((val, index) => index > 2 ? Number.parseFloat(val) : Number.parseInt(val, 10));
        if (parts.length === 4) {
          this._alpha = Number.parseFloat(parts[3]) * 100;
        } else if (parts.length === 3) {
          this._alpha = 100;
        }
        if (parts.length >= 3) {
          const { h, s, v } = rgb2hsv(parts[0], parts[1], parts[2]);
          fromHSV(h, s, v);
        }
      } else if (value.includes("#")) {
        const hex = value.replace("#", "").trim();
        if (!/^[0-9a-fA-F]{3}$|^[0-9a-fA-F]{6}$|^[0-9a-fA-F]{8}$/.test(hex))
          return;
        let r, g, b;
        if (hex.length === 3) {
          r = parseHexChannel(hex[0] + hex[0]);
          g = parseHexChannel(hex[1] + hex[1]);
          b = parseHexChannel(hex[2] + hex[2]);
        } else if (hex.length === 6 || hex.length === 8) {
          r = parseHexChannel(hex.slice(0, 2));
          g = parseHexChannel(hex.slice(2, 4));
          b = parseHexChannel(hex.slice(4, 6));
        }
        if (hex.length === 8) {
          this._alpha = parseHexChannel(hex.slice(6)) / 255 * 100;
        } else if (hex.length === 3 || hex.length === 6) {
          this._alpha = 100;
        }
        const { h, s, v } = rgb2hsv(r, g, b);
        fromHSV(h, s, v);
      }
    }
    compare(color) {
      return Math.abs(color._hue - this._hue) < 2 && Math.abs(color._saturation - this._saturation) < 1 && Math.abs(color._value - this._value) < 1 && Math.abs(color._alpha - this._alpha) < 1;
    }
    doOnChange() {
      const { _hue, _saturation, _value, _alpha, format } = this;
      if (this.enableAlpha) {
        switch (format) {
          case "hsl": {
            const hsl = hsv2hsl(_hue, _saturation / 100, _value / 100);
            this.value = `hsla(${_hue}, ${Math.round(hsl[1] * 100)}%, ${Math.round(hsl[2] * 100)}%, ${this.get("alpha") / 100})`;
            break;
          }
          case "hsv": {
            this.value = `hsva(${_hue}, ${Math.round(_saturation)}%, ${Math.round(_value)}%, ${this.get("alpha") / 100})`;
            break;
          }
          case "hex": {
            this.value = `${toHex(hsv2rgb(_hue, _saturation, _value))}${hexOne(_alpha * 255 / 100)}`;
            break;
          }
          default: {
            const { r, g, b } = hsv2rgb(_hue, _saturation, _value);
            this.value = `rgba(${r}, ${g}, ${b}, ${this.get("alpha") / 100})`;
          }
        }
      } else {
        switch (format) {
          case "hsl": {
            const hsl = hsv2hsl(_hue, _saturation / 100, _value / 100);
            this.value = `hsl(${_hue}, ${Math.round(hsl[1] * 100)}%, ${Math.round(hsl[2] * 100)}%)`;
            break;
          }
          case "hsv": {
            this.value = `hsv(${_hue}, ${Math.round(_saturation)}%, ${Math.round(_value)}%)`;
            break;
          }
          case "rgb": {
            const { r, g, b } = hsv2rgb(_hue, _saturation, _value);
            this.value = `rgb(${r}, ${g}, ${b})`;
            break;
          }
          default: {
            this.value = toHex(hsv2rgb(_hue, _saturation, _value));
          }
        }
      }
    }
  }

  const _sfc_main$1q = vue.defineComponent({
    props: {
      colors: { type: Array, required: true },
      color: {
        type: Object,
        required: true
      }
    },
    setup(props) {
      const { currentColor } = useOptions();
      const rgbaColors = vue.ref(parseColors(props.colors, props.color));
      vue.watch(() => currentColor.value, (val) => {
        const color = new Color();
        color.fromString(val);
        rgbaColors.value.forEach((item) => {
          item.selected = color.compare(item);
        });
      });
      vue.watchEffect(() => {
        rgbaColors.value = parseColors(props.colors, props.color);
      });
      function handleSelect(index) {
        props.color.fromString(props.colors[index]);
      }
      function parseColors(colors, color) {
        return colors.map((value) => {
          const c = new Color();
          c.enableAlpha = true;
          c.format = "rgba";
          c.fromString(value);
          c.selected = c.value === color.value;
          return c;
        });
      }
      return {
        rgbaColors,
        handleSelect
      };
    }
  });
  const _hoisted_1$I = { class: "el-color-predefine" };
  const _hoisted_2$s = { class: "el-color-predefine__colors" };
  const _hoisted_3$h = ["onClick"];
  function _sfc_render$1d(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", _hoisted_1$I, [
      vue.createElementVNode("div", _hoisted_2$s, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.rgbaColors, (item, index) => {
          return vue.openBlock(), vue.createElementBlock("div", {
            key: _ctx.colors[index],
            class: vue.normalizeClass(["el-color-predefine__color-selector", { selected: item.selected, "is-alpha": item._alpha < 100 }]),
            onClick: ($event) => _ctx.handleSelect(index)
          }, [
            vue.createElementVNode("div", {
              style: vue.normalizeStyle({ backgroundColor: item.value })
            }, null, 4)
          ], 10, _hoisted_3$h);
        }), 128))
      ])
    ]);
  }
  var Predefine = /* @__PURE__ */ _export_sfc(_sfc_main$1q, [["render", _sfc_render$1d]]);

  const _sfc_main$1p = vue.defineComponent({
    name: "ElSlPanel",
    props: {
      color: {
        type: Object,
        required: true
      }
    },
    setup(props) {
      const instance = vue.getCurrentInstance();
      const cursorTop = vue.ref(0);
      const cursorLeft = vue.ref(0);
      const background = vue.ref("hsl(0, 100%, 50%)");
      const colorValue = vue.computed(() => {
        const hue = props.color.get("hue");
        const value = props.color.get("value");
        return { hue, value };
      });
      function update() {
        const saturation = props.color.get("saturation");
        const value = props.color.get("value");
        const el = instance.vnode.el;
        const { clientWidth: width, clientHeight: height } = el;
        cursorLeft.value = saturation * width / 100;
        cursorTop.value = (100 - value) * height / 100;
        background.value = `hsl(${props.color.get("hue")}, 100%, 50%)`;
      }
      function handleDrag(event) {
        const el = instance.vnode.el;
        const rect = el.getBoundingClientRect();
        const { clientX, clientY } = getClientXY(event);
        let left = clientX - rect.left;
        let top = clientY - rect.top;
        left = Math.max(0, left);
        left = Math.min(left, rect.width);
        top = Math.max(0, top);
        top = Math.min(top, rect.height);
        cursorLeft.value = left;
        cursorTop.value = top;
        props.color.set({
          saturation: left / rect.width * 100,
          value: 100 - top / rect.height * 100
        });
      }
      vue.watch(() => colorValue.value, () => {
        update();
      });
      vue.onMounted(() => {
        draggable(instance.vnode.el, {
          drag: (event) => {
            handleDrag(event);
          },
          end: (event) => {
            handleDrag(event);
          }
        });
        update();
      });
      return {
        cursorTop,
        cursorLeft,
        background,
        colorValue,
        handleDrag,
        update
      };
    }
  });
  const _hoisted_1$H = /* @__PURE__ */ vue.createElementVNode("div", { class: "el-color-svpanel__white" }, null, -1);
  const _hoisted_2$r = /* @__PURE__ */ vue.createElementVNode("div", { class: "el-color-svpanel__black" }, null, -1);
  const _hoisted_3$g = /* @__PURE__ */ vue.createElementVNode("div", null, null, -1);
  const _hoisted_4$c = [
    _hoisted_3$g
  ];
  function _sfc_render$1c(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      class: "el-color-svpanel",
      style: vue.normalizeStyle({
        backgroundColor: _ctx.background
      })
    }, [
      _hoisted_1$H,
      _hoisted_2$r,
      vue.createElementVNode("div", {
        class: "el-color-svpanel__cursor",
        style: vue.normalizeStyle({
          top: _ctx.cursorTop + "px",
          left: _ctx.cursorLeft + "px"
        })
      }, _hoisted_4$c, 4)
    ], 4);
  }
  var SvPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1p, [["render", _sfc_render$1c]]);

  const _sfc_main$1o = vue.defineComponent({
    name: "ElColorPicker",
    components: {
      ElButton,
      ElTooltip,
      ElInput,
      ElIcon,
      Close: close$2,
      ArrowDown: arrowDown,
      SvPanel,
      HueSlider,
      AlphaSlider,
      Predefine
    },
    directives: {
      ClickOutside
    },
    props: {
      modelValue: String,
      showAlpha: Boolean,
      colorFormat: String,
      disabled: Boolean,
      size: {
        type: String,
        validator: isValidComponentSize
      },
      popperClass: String,
      predefine: Array
    },
    emits: ["change", "active-change", UPDATE_MODEL_EVENT],
    setup(props, { emit }) {
      const { t } = useLocale();
      const ns = useNamespace("color");
      const elForm = vue.inject(formContextKey, {});
      const elFormItem = vue.inject(formItemContextKey, {});
      const hue = vue.ref(null);
      const svPanel = vue.ref(null);
      const alpha = vue.ref(null);
      const popper = vue.ref(null);
      const color = vue.reactive(new Color({
        enableAlpha: props.showAlpha,
        format: props.colorFormat,
        value: props.modelValue
      }));
      const showPicker = vue.ref(false);
      const showPanelColor = vue.ref(false);
      const customInput = vue.ref("");
      const displayedColor = vue.computed(() => {
        if (!props.modelValue && !showPanelColor.value) {
          return "transparent";
        }
        return displayedRgb(color, props.showAlpha);
      });
      const colorSize = useSize();
      const colorDisabled = vue.computed(() => {
        return !!(props.disabled || elForm.disabled);
      });
      const currentColor = vue.computed(() => {
        return !props.modelValue && !showPanelColor.value ? "" : color.value;
      });
      vue.watch(() => props.modelValue, (newVal) => {
        if (!newVal) {
          showPanelColor.value = false;
        } else if (newVal && newVal !== color.value) {
          color.fromString(newVal);
        }
      });
      vue.watch(() => currentColor.value, (val) => {
        customInput.value = val;
        emit("active-change", val);
      });
      vue.watch(() => color.value, () => {
        if (!props.modelValue && !showPanelColor.value) {
          showPanelColor.value = true;
        }
      });
      function displayedRgb(color2, showAlpha) {
        if (!(color2 instanceof Color)) {
          throw new TypeError("color should be instance of _color Class");
        }
        const { r, g, b } = color2.toRgb();
        return showAlpha ? `rgba(${r}, ${g}, ${b}, ${color2.get("alpha") / 100})` : `rgb(${r}, ${g}, ${b})`;
      }
      function setShowPicker(value) {
        showPicker.value = value;
      }
      const debounceSetShowPicker = debounce$1(setShowPicker, 100);
      function hide() {
        debounceSetShowPicker(false);
        resetColor();
      }
      function resetColor() {
        vue.nextTick(() => {
          if (props.modelValue) {
            color.fromString(props.modelValue);
          } else {
            showPanelColor.value = false;
          }
        });
      }
      function handleTrigger() {
        if (colorDisabled.value)
          return;
        debounceSetShowPicker(!showPicker.value);
      }
      function handleConfirm() {
        color.fromString(customInput.value);
      }
      function confirmValue() {
        var _a;
        const value = color.value;
        emit(UPDATE_MODEL_EVENT, value);
        emit("change", value);
        (_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
        debounceSetShowPicker(false);
        vue.nextTick(() => {
          const newColor = new Color({
            enableAlpha: props.showAlpha,
            format: props.colorFormat,
            value: props.modelValue
          });
          if (!color.compare(newColor)) {
            resetColor();
          }
        });
      }
      function clear() {
        var _a;
        debounceSetShowPicker(false);
        emit(UPDATE_MODEL_EVENT, null);
        emit("change", null);
        if (props.modelValue !== null) {
          (_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
        }
        resetColor();
      }
      vue.onMounted(() => {
        if (props.modelValue) {
          customInput.value = currentColor.value;
        }
      });
      vue.watch(() => showPicker.value, () => {
        vue.nextTick(() => {
          var _a, _b, _c;
          (_a = hue.value) == null ? void 0 : _a.update();
          (_b = svPanel.value) == null ? void 0 : _b.update();
          (_c = alpha.value) == null ? void 0 : _c.update();
        });
      });
      vue.provide(OPTIONS_KEY, {
        currentColor
      });
      return {
        color,
        colorDisabled,
        colorSize,
        displayedColor,
        showPanelColor,
        showPicker,
        customInput,
        handleConfirm,
        hide,
        handleTrigger,
        clear,
        confirmValue,
        t,
        ns,
        hue,
        svPanel,
        alpha,
        popper
      };
    }
  });
  function _sfc_render$1b(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_hue_slider = vue.resolveComponent("hue-slider");
    const _component_sv_panel = vue.resolveComponent("sv-panel");
    const _component_alpha_slider = vue.resolveComponent("alpha-slider");
    const _component_predefine = vue.resolveComponent("predefine");
    const _component_el_input = vue.resolveComponent("el-input");
    const _component_el_button = vue.resolveComponent("el-button");
    const _component_arrow_down = vue.resolveComponent("arrow-down");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_close = vue.resolveComponent("close");
    const _component_el_tooltip = vue.resolveComponent("el-tooltip");
    const _directive_click_outside = vue.resolveDirective("click-outside");
    return vue.openBlock(), vue.createBlock(_component_el_tooltip, {
      ref: "popper",
      visible: _ctx.showPicker,
      "onUpdate:visible": _cache[2] || (_cache[2] = ($event) => _ctx.showPicker = $event),
      "show-arrow": false,
      "fallback-placements": ["bottom", "top", "right", "left"],
      offset: 0,
      "gpu-acceleration": false,
      "popper-class": [_ctx.ns.be("picker", "panel"), _ctx.ns.b("dropdown"), _ctx.popperClass],
      "stop-popper-mouse-event": false,
      effect: "light",
      trigger: "click",
      transition: "el-zoom-in-top",
      persistent: ""
    }, {
      content: vue.withCtx(() => [
        vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", null, [
          vue.createElementVNode("div", {
            class: vue.normalizeClass(_ctx.ns.be("dropdown", "main-wrapper"))
          }, [
            vue.createVNode(_component_hue_slider, {
              ref: "hue",
              class: "hue-slider",
              color: _ctx.color,
              vertical: ""
            }, null, 8, ["color"]),
            vue.createVNode(_component_sv_panel, {
              ref: "svPanel",
              color: _ctx.color
            }, null, 8, ["color"])
          ], 2),
          _ctx.showAlpha ? (vue.openBlock(), vue.createBlock(_component_alpha_slider, {
            key: 0,
            ref: "alpha",
            color: _ctx.color
          }, null, 8, ["color"])) : vue.createCommentVNode("v-if", true),
          _ctx.predefine ? (vue.openBlock(), vue.createBlock(_component_predefine, {
            key: 1,
            ref: "predefine",
            color: _ctx.color,
            colors: _ctx.predefine
          }, null, 8, ["color", "colors"])) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("div", {
            class: vue.normalizeClass(_ctx.ns.be("dropdown", "btns"))
          }, [
            vue.createElementVNode("span", {
              class: vue.normalizeClass(_ctx.ns.be("dropdown", "value"))
            }, [
              vue.createVNode(_component_el_input, {
                modelValue: _ctx.customInput,
                "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => _ctx.customInput = $event),
                "validate-event": false,
                size: "small",
                onKeyup: vue.withKeys(_ctx.handleConfirm, ["enter"]),
                onBlur: _ctx.handleConfirm
              }, null, 8, ["modelValue", "onKeyup", "onBlur"])
            ], 2),
            vue.createVNode(_component_el_button, {
              size: "small",
              type: "text",
              class: vue.normalizeClass(_ctx.ns.be("dropdown", "link-btn")),
              onClick: _ctx.clear
            }, {
              default: vue.withCtx(() => [
                vue.createTextVNode(vue.toDisplayString(_ctx.t("el.colorpicker.clear")), 1)
              ]),
              _: 1
            }, 8, ["class", "onClick"]),
            vue.createVNode(_component_el_button, {
              plain: "",
              size: "small",
              class: vue.normalizeClass(_ctx.ns.be("dropdown", "btn")),
              onClick: _ctx.confirmValue
            }, {
              default: vue.withCtx(() => [
                vue.createTextVNode(vue.toDisplayString(_ctx.t("el.colorpicker.confirm")), 1)
              ]),
              _: 1
            }, 8, ["class", "onClick"])
          ], 2)
        ])), [
          [_directive_click_outside, _ctx.hide]
        ])
      ]),
      default: vue.withCtx(() => [
        vue.createElementVNode("div", {
          class: vue.normalizeClass([
            _ctx.ns.b("picker"),
            _ctx.ns.is("disabled", _ctx.colorDisabled),
            _ctx.ns.bm("picker", _ctx.colorSize)
          ])
        }, [
          _ctx.colorDisabled ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 0,
            class: vue.normalizeClass(_ctx.ns.be("picker", "mask"))
          }, null, 2)) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("div", {
            class: vue.normalizeClass(_ctx.ns.be("picker", "trigger")),
            onClick: _cache[1] || (_cache[1] = (...args) => _ctx.handleTrigger && _ctx.handleTrigger(...args))
          }, [
            vue.createElementVNode("span", {
              class: vue.normalizeClass([_ctx.ns.be("picker", "color"), _ctx.ns.is("alpha", _ctx.showAlpha)])
            }, [
              vue.createElementVNode("span", {
                class: vue.normalizeClass(_ctx.ns.be("picker", "color-inner")),
                style: vue.normalizeStyle({
                  backgroundColor: _ctx.displayedColor
                })
              }, [
                vue.withDirectives(vue.createVNode(_component_el_icon, {
                  class: vue.normalizeClass([_ctx.ns.be("picker", "icon"), _ctx.ns.is("icon-arrow-down")])
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_down)
                  ]),
                  _: 1
                }, 8, ["class"]), [
                  [vue.vShow, _ctx.modelValue || _ctx.showPanelColor]
                ]),
                !_ctx.modelValue && !_ctx.showPanelColor ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
                  key: 0,
                  class: vue.normalizeClass([_ctx.ns.be("picker", "empty"), _ctx.ns.is("icon-close")])
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_close)
                  ]),
                  _: 1
                }, 8, ["class"])) : vue.createCommentVNode("v-if", true)
              ], 6)
            ], 2)
          ], 2)
        ], 2)
      ]),
      _: 1
    }, 8, ["visible", "popper-class"]);
  }
  var ColorPicker = /* @__PURE__ */ _export_sfc(_sfc_main$1o, [["render", _sfc_render$1b]]);

  ColorPicker.install = (app) => {
    app.component(ColorPicker.name, ColorPicker);
  };
  const _ColorPicker = ColorPicker;
  const ElColorPicker = _ColorPicker;

  const messageConfig = {};
  const configProviderProps = buildProps({
    locale: {
      type: definePropType(Object)
    },
    size: {
      type: String,
      values: ["large", "default", "small"]
    },
    button: {
      type: definePropType(Object)
    },
    message: {
      type: definePropType(Object)
    },
    zIndex: {
      type: Number
    },
    namespace: {
      type: String,
      default: "el"
    }
  });
  var ConfigProvider = vue.defineComponent({
    name: "ElConfigProvider",
    props: configProviderProps,
    setup(props, { slots }) {
      vue.watch(() => props.message, (val) => {
        Object.assign(messageConfig, val != null ? val : {});
      }, { immediate: true, deep: true });
      const config = provideGlobalConfig(props);
      return () => vue.renderSlot(slots, "default", { config: config == null ? void 0 : config.value });
    }
  });

  const ElConfigProvider = withInstall(ConfigProvider);

  const _sfc_main$1n = vue.defineComponent({
    name: "ElContainer",
    props: {
      direction: {
        type: String,
        default: ""
      }
    },
    setup(props, { slots }) {
      const ns = useNamespace("container");
      const isVertical = vue.computed(() => {
        if (props.direction === "vertical") {
          return true;
        } else if (props.direction === "horizontal") {
          return false;
        }
        if (slots && slots.default) {
          const vNodes = slots.default();
          return vNodes.some((vNode) => {
            const tag = vNode.type.name;
            return tag === "ElHeader" || tag === "ElFooter";
          });
        } else {
          return false;
        }
      });
      return {
        isVertical,
        ns
      };
    }
  });
  function _sfc_render$1a(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("section", {
      class: vue.normalizeClass([_ctx.ns.b(), _ctx.ns.is("vertical", _ctx.isVertical)])
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 2);
  }
  var Container = /* @__PURE__ */ _export_sfc(_sfc_main$1n, [["render", _sfc_render$1a]]);

  const _sfc_main$1m = vue.defineComponent({
    name: "ElAside",
    props: {
      width: {
        type: String,
        default: null
      }
    },
    setup(props) {
      const ns = useNamespace("aside");
      return {
        style: vue.computed(() => {
          return props.width ? { "--el-aside-width": props.width } : {};
        }),
        ns
      };
    }
  });
  function _sfc_render$19(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("aside", {
      class: vue.normalizeClass(_ctx.ns.b()),
      style: vue.normalizeStyle(_ctx.style)
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 6);
  }
  var Aside = /* @__PURE__ */ _export_sfc(_sfc_main$1m, [["render", _sfc_render$19]]);

  const _sfc_main$1l = vue.defineComponent({
    name: "ElFooter",
    props: {
      height: {
        type: String,
        default: null
      }
    },
    setup(props) {
      const ns = useNamespace("footer");
      return {
        style: vue.computed(() => props.height ? {
          "--el-footer-height": props.height
        } : {}),
        ns
      };
    }
  });
  function _sfc_render$18(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("footer", {
      class: vue.normalizeClass(_ctx.ns.b()),
      style: vue.normalizeStyle(_ctx.style)
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 6);
  }
  var Footer = /* @__PURE__ */ _export_sfc(_sfc_main$1l, [["render", _sfc_render$18]]);

  const _sfc_main$1k = vue.defineComponent({
    name: "ElHeader",
    props: {
      height: {
        type: String,
        default: null
      }
    },
    setup(props) {
      const ns = useNamespace("header");
      return {
        style: vue.computed(() => props.height ? {
          "--el-header-height": props.height
        } : {}),
        ns
      };
    }
  });
  function _sfc_render$17(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("header", {
      class: vue.normalizeClass(_ctx.ns.b()),
      style: vue.normalizeStyle(_ctx.style)
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 6);
  }
  var Header = /* @__PURE__ */ _export_sfc(_sfc_main$1k, [["render", _sfc_render$17]]);

  const _sfc_main$1j = vue.defineComponent({
    name: "ElMain",
    setup() {
      const ns = useNamespace("main");
      return {
        ns
      };
    }
  });
  function _sfc_render$16(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("main", {
      class: vue.normalizeClass(_ctx.ns.b())
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 2);
  }
  var Main = /* @__PURE__ */ _export_sfc(_sfc_main$1j, [["render", _sfc_render$16]]);

  const ElContainer = withInstall(Container, {
    Aside,
    Footer,
    Header,
    Main
  });
  const ElAside = withNoopInstall(Aside);
  const ElFooter = withNoopInstall(Footer);
  const ElHeader = withNoopInstall(Header);
  const ElMain = withNoopInstall(Main);

  var advancedFormat$1 = {exports: {}};

  (function(module, exports) {
    !function(e, t) {
      module.exports = t() ;
    }(commonjsGlobal, function() {
      return function(e, t, r) {
        var n = t.prototype, s = n.format;
        r.en.ordinal = function(e2) {
          var t2 = ["th", "st", "nd", "rd"], r2 = e2 % 100;
          return "[" + e2 + (t2[(r2 - 20) % 10] || t2[r2] || t2[0]) + "]";
        }, n.format = function(e2) {
          var t2 = this, r2 = this.$locale();
          if (!this.isValid())
            return s.bind(this)(e2);
          var n2 = this.$utils(), a = (e2 || "YYYY-MM-DDTHH:mm:ssZ").replace(/\[([^\]]+)]|Q|wo|ww|w|WW|W|zzz|z|gggg|GGGG|Do|X|x|k{1,2}|S/g, function(e3) {
            switch (e3) {
              case "Q":
                return Math.ceil((t2.$M + 1) / 3);
              case "Do":
                return r2.ordinal(t2.$D);
              case "gggg":
                return t2.weekYear();
              case "GGGG":
                return t2.isoWeekYear();
              case "wo":
                return r2.ordinal(t2.week(), "W");
              case "w":
              case "ww":
                return n2.s(t2.week(), e3 === "w" ? 1 : 2, "0");
              case "W":
              case "WW":
                return n2.s(t2.isoWeek(), e3 === "W" ? 1 : 2, "0");
              case "k":
              case "kk":
                return n2.s(String(t2.$H === 0 ? 24 : t2.$H), e3 === "k" ? 1 : 2, "0");
              case "X":
                return Math.floor(t2.$d.getTime() / 1e3);
              case "x":
                return t2.$d.getTime();
              case "z":
                return "[" + t2.offsetName() + "]";
              case "zzz":
                return "[" + t2.offsetName("long") + "]";
              default:
                return e3;
            }
          });
          return s.bind(this)(a);
        };
      };
    });
  })(advancedFormat$1);
  var advancedFormat = advancedFormat$1.exports;

  var weekOfYear$1 = {exports: {}};

  (function(module, exports) {
    !function(e, t) {
      module.exports = t() ;
    }(commonjsGlobal, function() {
      var e = "week", t = "year";
      return function(i, n, r) {
        var f = n.prototype;
        f.week = function(i2) {
          if (i2 === void 0 && (i2 = null), i2 !== null)
            return this.add(7 * (i2 - this.week()), "day");
          var n2 = this.$locale().yearStart || 1;
          if (this.month() === 11 && this.date() > 25) {
            var f2 = r(this).startOf(t).add(1, t).date(n2), s = r(this).endOf(e);
            if (f2.isBefore(s))
              return 1;
          }
          var a = r(this).startOf(t).date(n2).startOf(e).subtract(1, "millisecond"), o = this.diff(a, e, true);
          return o < 0 ? r(this).startOf("week").week() : Math.ceil(o);
        }, f.weeks = function(e2) {
          return e2 === void 0 && (e2 = null), this.week(e2);
        };
      };
    });
  })(weekOfYear$1);
  var weekOfYear = weekOfYear$1.exports;

  var weekYear$1 = {exports: {}};

  (function(module, exports) {
    !function(e, t) {
      module.exports = t() ;
    }(commonjsGlobal, function() {
      return function(e, t) {
        t.prototype.weekYear = function() {
          var e2 = this.month(), t2 = this.week(), n = this.year();
          return t2 === 1 && e2 === 11 ? n + 1 : e2 === 0 && t2 >= 52 ? n - 1 : n;
        };
      };
    });
  })(weekYear$1);
  var weekYear = weekYear$1.exports;

  var dayOfYear$1 = {exports: {}};

  (function(module, exports) {
    !function(e, t) {
      module.exports = t() ;
    }(commonjsGlobal, function() {
      return function(e, t, n) {
        t.prototype.dayOfYear = function(e2) {
          var t2 = Math.round((n(this).startOf("day") - n(this).startOf("year")) / 864e5) + 1;
          return e2 == null ? t2 : this.add(e2 - t2, "day");
        };
      };
    });
  })(dayOfYear$1);
  var dayOfYear = dayOfYear$1.exports;

  var isSameOrAfter$1 = {exports: {}};

  (function(module, exports) {
    !function(e, t) {
      module.exports = t() ;
    }(commonjsGlobal, function() {
      return function(e, t) {
        t.prototype.isSameOrAfter = function(e2, t2) {
          return this.isSame(e2, t2) || this.isAfter(e2, t2);
        };
      };
    });
  })(isSameOrAfter$1);
  var isSameOrAfter = isSameOrAfter$1.exports;

  var isSameOrBefore$1 = {exports: {}};

  (function(module, exports) {
    !function(e, i) {
      module.exports = i() ;
    }(commonjsGlobal, function() {
      return function(e, i) {
        i.prototype.isSameOrBefore = function(e2, i2) {
          return this.isSame(e2, i2) || this.isBefore(e2, i2);
        };
      };
    });
  })(isSameOrBefore$1);
  var isSameOrBefore = isSameOrBefore$1.exports;

  const ROOT_PICKER_INJECTION_KEY = Symbol();

  var ElDatePickerCell = vue.defineComponent({
    name: "ElDatePickerCell",
    props: buildProps({
      cell: {
        type: definePropType(Object)
      }
    }),
    setup(props) {
      const picker = vue.inject(ROOT_PICKER_INJECTION_KEY);
      return () => {
        const cell = props.cell;
        if (picker == null ? void 0 : picker.ctx.slots.default) {
          const list = picker.ctx.slots.default(cell).filter((item) => {
            return item.patchFlag !== -2 && item.type.toString() !== "Symbol(Comment)";
          });
          if (list.length) {
            return list;
          }
        }
        return vue.h("div", {
          class: "el-date-table-cell"
        }, [
          vue.h("span", {
            class: "el-date-table-cell__text"
          }, [cell == null ? void 0 : cell.text])
        ]);
      };
    }
  });

  const _sfc_main$1i = vue.defineComponent({
    components: {
      ElDatePickerCell
    },
    props: {
      date: {
        type: Object
      },
      minDate: {
        type: Object
      },
      maxDate: {
        type: Object
      },
      parsedValue: {
        type: [Object, Array]
      },
      selectionMode: {
        type: String,
        default: "day"
      },
      showWeekNumber: {
        type: Boolean,
        default: false
      },
      disabledDate: {
        type: Function
      },
      cellClassName: {
        type: Function
      },
      rangeState: {
        type: Object,
        default: () => ({
          endDate: null,
          selecting: false
        })
      }
    },
    emits: ["changerange", "pick", "select"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const lastRow = vue.ref(null);
      const lastColumn = vue.ref(null);
      const tableRows = vue.ref([[], [], [], [], [], []]);
      const firstDayOfWeek = props.date.$locale().weekStart || 7;
      const WEEKS_CONSTANT = props.date.locale("en").localeData().weekdaysShort().map((_) => _.toLowerCase());
      const offsetDay = vue.computed(() => {
        return firstDayOfWeek > 3 ? 7 - firstDayOfWeek : -firstDayOfWeek;
      });
      const startDate = vue.computed(() => {
        const startDayOfMonth = props.date.startOf("month");
        return startDayOfMonth.subtract(startDayOfMonth.day() || 7, "day");
      });
      const WEEKS = vue.computed(() => {
        return WEEKS_CONSTANT.concat(WEEKS_CONSTANT).slice(firstDayOfWeek, firstDayOfWeek + 7);
      });
      const rows = vue.computed(() => {
        var _a;
        const startOfMonth = props.date.startOf("month");
        const startOfMonthDay = startOfMonth.day() || 7;
        const dateCountOfMonth = startOfMonth.daysInMonth();
        const dateCountOfLastMonth = startOfMonth.subtract(1, "month").daysInMonth();
        const offset = offsetDay.value;
        const rows_ = tableRows.value;
        let count = 1;
        const selectedDate = props.selectionMode === "dates" ? castArray(props.parsedValue) : [];
        const calNow = dayjs().locale(lang.value).startOf("day");
        for (let i = 0; i < 6; i++) {
          const row = rows_[i];
          if (props.showWeekNumber) {
            if (!row[0]) {
              row[0] = {
                type: "week",
                text: startDate.value.add(i * 7 + 1, "day").week()
              };
            }
          }
          for (let j = 0; j < 7; j++) {
            let cell = row[props.showWeekNumber ? j + 1 : j];
            if (!cell) {
              cell = {
                row: i,
                column: j,
                type: "normal",
                inRange: false,
                start: false,
                end: false
              };
            }
            const index = i * 7 + j;
            const calTime = startDate.value.add(index - offset, "day");
            cell.dayjs = calTime;
            cell.date = calTime.toDate();
            cell.timestamp = calTime.valueOf();
            cell.type = "normal";
            const calEndDate = props.rangeState.endDate || props.maxDate || props.rangeState.selecting && props.minDate;
            cell.inRange = props.minDate && calTime.isSameOrAfter(props.minDate, "day") && calEndDate && calTime.isSameOrBefore(calEndDate, "day") || props.minDate && calTime.isSameOrBefore(props.minDate, "day") && calEndDate && calTime.isSameOrAfter(calEndDate, "day");
            if ((_a = props.minDate) == null ? void 0 : _a.isSameOrAfter(calEndDate)) {
              cell.start = calEndDate && calTime.isSame(calEndDate, "day");
              cell.end = props.minDate && calTime.isSame(props.minDate, "day");
            } else {
              cell.start = props.minDate && calTime.isSame(props.minDate, "day");
              cell.end = calEndDate && calTime.isSame(calEndDate, "day");
            }
            const isToday = calTime.isSame(calNow, "day");
            if (isToday) {
              cell.type = "today";
            }
            if (i >= 0 && i <= 1) {
              const numberOfDaysFromPreviousMonth = startOfMonthDay + offset < 0 ? 7 + startOfMonthDay + offset : startOfMonthDay + offset;
              if (j + i * 7 >= numberOfDaysFromPreviousMonth) {
                cell.text = count++;
              } else {
                cell.text = dateCountOfLastMonth - (numberOfDaysFromPreviousMonth - j % 7) + 1 + i * 7;
                cell.type = "prev-month";
              }
            } else {
              if (count <= dateCountOfMonth) {
                cell.text = count++;
              } else {
                cell.text = count++ - dateCountOfMonth;
                cell.type = "next-month";
              }
            }
            const cellDate = calTime.toDate();
            cell.selected = selectedDate.find((_) => _.valueOf() === calTime.valueOf());
            cell.isSelected = !!cell.selected;
            cell.isCurrent = isCurrent(cell);
            cell.disabled = props.disabledDate && props.disabledDate(cellDate);
            cell.customClass = props.cellClassName && props.cellClassName(cellDate);
            row[props.showWeekNumber ? j + 1 : j] = cell;
          }
          if (props.selectionMode === "week") {
            const start = props.showWeekNumber ? 1 : 0;
            const end = props.showWeekNumber ? 7 : 6;
            const isActive = isWeekActive(row[start + 1]);
            row[start].inRange = isActive;
            row[start].start = isActive;
            row[end].inRange = isActive;
            row[end].end = isActive;
          }
        }
        return rows_;
      });
      const isCurrent = (cell) => {
        return props.selectionMode === "day" && (cell.type === "normal" || cell.type === "today") && cellMatchesDate(cell, props.parsedValue);
      };
      const cellMatchesDate = (cell, date) => {
        if (!date)
          return false;
        return dayjs(date).locale(lang.value).isSame(props.date.date(Number(cell.text)), "day");
      };
      const getCellClasses = (cell) => {
        const classes = [];
        if ((cell.type === "normal" || cell.type === "today") && !cell.disabled) {
          classes.push("available");
          if (cell.type === "today") {
            classes.push("today");
          }
        } else {
          classes.push(cell.type);
        }
        if (isCurrent(cell)) {
          classes.push("current");
        }
        if (cell.inRange && (cell.type === "normal" || cell.type === "today" || props.selectionMode === "week")) {
          classes.push("in-range");
          if (cell.start) {
            classes.push("start-date");
          }
          if (cell.end) {
            classes.push("end-date");
          }
        }
        if (cell.disabled) {
          classes.push("disabled");
        }
        if (cell.selected) {
          classes.push("selected");
        }
        if (cell.customClass) {
          classes.push(cell.customClass);
        }
        return classes.join(" ");
      };
      const getDateOfCell = (row, column) => {
        const offsetFromStart = row * 7 + (column - (props.showWeekNumber ? 1 : 0)) - offsetDay.value;
        return startDate.value.add(offsetFromStart, "day");
      };
      const handleMouseMove = (event) => {
        if (!props.rangeState.selecting)
          return;
        let target = event.target;
        if (target.tagName === "SPAN") {
          target = target.parentNode.parentNode;
        }
        if (target.tagName === "DIV") {
          target = target.parentNode;
        }
        if (target.tagName !== "TD")
          return;
        const row = target.parentNode.rowIndex - 1;
        const column = target.cellIndex;
        if (rows.value[row][column].disabled)
          return;
        if (row !== lastRow.value || column !== lastColumn.value) {
          lastRow.value = row;
          lastColumn.value = column;
          ctx.emit("changerange", {
            selecting: true,
            endDate: getDateOfCell(row, column)
          });
        }
      };
      const handleClick = (event) => {
        let target = event.target;
        while (target) {
          if (target.tagName === "TD") {
            break;
          }
          target = target.parentNode;
        }
        if (!target || target.tagName !== "TD")
          return;
        const row = target.parentNode.rowIndex - 1;
        const column = target.cellIndex;
        const cell = rows.value[row][column];
        if (cell.disabled || cell.type === "week")
          return;
        const newDate = getDateOfCell(row, column);
        if (props.selectionMode === "range") {
          if (!props.rangeState.selecting) {
            ctx.emit("pick", { minDate: newDate, maxDate: null });
            ctx.emit("select", true);
          } else {
            if (newDate >= props.minDate) {
              ctx.emit("pick", { minDate: props.minDate, maxDate: newDate });
            } else {
              ctx.emit("pick", { minDate: newDate, maxDate: props.minDate });
            }
            ctx.emit("select", false);
          }
        } else if (props.selectionMode === "day") {
          ctx.emit("pick", newDate);
        } else if (props.selectionMode === "week") {
          const weekNumber = newDate.week();
          const value = `${newDate.year()}w${weekNumber}`;
          ctx.emit("pick", {
            year: newDate.year(),
            week: weekNumber,
            value,
            date: newDate.startOf("week")
          });
        } else if (props.selectionMode === "dates") {
          const newValue = cell.selected ? castArray(props.parsedValue).filter((_) => _.valueOf() !== newDate.valueOf()) : castArray(props.parsedValue).concat([newDate]);
          ctx.emit("pick", newValue);
        }
      };
      const isWeekActive = (cell) => {
        if (props.selectionMode !== "week")
          return false;
        let newDate = props.date.startOf("day");
        if (cell.type === "prev-month") {
          newDate = newDate.subtract(1, "month");
        }
        if (cell.type === "next-month") {
          newDate = newDate.add(1, "month");
        }
        newDate = newDate.date(Number.parseInt(cell.text, 10));
        if (props.parsedValue && !Array.isArray(props.parsedValue)) {
          const dayOffset = (props.parsedValue.day() - firstDayOfWeek + 7) % 7 - 1;
          const weekDate = props.parsedValue.subtract(dayOffset, "day");
          return weekDate.isSame(newDate, "day");
        }
        return false;
      };
      return {
        handleMouseMove,
        t,
        rows,
        isWeekActive,
        getCellClasses,
        WEEKS,
        handleClick
      };
    }
  });
  const _hoisted_1$G = { key: 0 };
  function _sfc_render$15(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_date_picker_cell = vue.resolveComponent("el-date-picker-cell");
    return vue.openBlock(), vue.createElementBlock("table", {
      cellspacing: "0",
      cellpadding: "0",
      class: vue.normalizeClass(["el-date-table", { "is-week-mode": _ctx.selectionMode === "week" }]),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args)),
      onMousemove: _cache[1] || (_cache[1] = (...args) => _ctx.handleMouseMove && _ctx.handleMouseMove(...args))
    }, [
      vue.createElementVNode("tbody", null, [
        vue.createElementVNode("tr", null, [
          _ctx.showWeekNumber ? (vue.openBlock(), vue.createElementBlock("th", _hoisted_1$G, vue.toDisplayString(_ctx.t("el.datepicker.week")), 1)) : vue.createCommentVNode("v-if", true),
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.WEEKS, (week, key) => {
            return vue.openBlock(), vue.createElementBlock("th", { key }, vue.toDisplayString(_ctx.t("el.datepicker.weeks." + week)), 1);
          }), 128))
        ]),
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.rows, (row, key) => {
          return vue.openBlock(), vue.createElementBlock("tr", {
            key,
            class: vue.normalizeClass(["el-date-table__row", { current: _ctx.isWeekActive(row[1]) }])
          }, [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(row, (cell, key_) => {
              return vue.openBlock(), vue.createElementBlock("td", {
                key: key_,
                class: vue.normalizeClass(_ctx.getCellClasses(cell))
              }, [
                vue.createVNode(_component_el_date_picker_cell, { cell }, null, 8, ["cell"])
              ], 2);
            }), 128))
          ], 2);
        }), 128))
      ])
    ], 34);
  }
  var DateTable = /* @__PURE__ */ _export_sfc(_sfc_main$1i, [["render", _sfc_render$15]]);

  const datesInMonth = (year, month, lang) => {
    const firstDay = dayjs().locale(lang).startOf("month").month(month).year(year);
    const numOfDays = firstDay.daysInMonth();
    return rangeArr(numOfDays).map((n) => firstDay.add(n, "day").toDate());
  };
  const _sfc_main$1h = vue.defineComponent({
    props: {
      disabledDate: {
        type: Function
      },
      selectionMode: {
        type: String,
        default: "month"
      },
      minDate: {
        type: Object
      },
      maxDate: {
        type: Object
      },
      date: {
        type: Object
      },
      parsedValue: {
        type: Object
      },
      rangeState: {
        type: Object,
        default: () => ({
          endDate: null,
          selecting: false
        })
      }
    },
    emits: ["changerange", "pick", "select"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const months = vue.ref(props.date.locale("en").localeData().monthsShort().map((_) => _.toLowerCase()));
      const tableRows = vue.ref([[], [], []]);
      const lastRow = vue.ref(null);
      const lastColumn = vue.ref(null);
      const rows = vue.computed(() => {
        var _a;
        const rows2 = tableRows.value;
        const now = dayjs().locale(lang.value).startOf("month");
        for (let i = 0; i < 3; i++) {
          const row = rows2[i];
          for (let j = 0; j < 4; j++) {
            let cell = row[j];
            if (!cell) {
              cell = {
                row: i,
                column: j,
                type: "normal",
                inRange: false,
                start: false,
                end: false
              };
            }
            cell.type = "normal";
            const index = i * 4 + j;
            const calTime = props.date.startOf("year").month(index);
            const calEndDate = props.rangeState.endDate || props.maxDate || props.rangeState.selecting && props.minDate;
            cell.inRange = props.minDate && calTime.isSameOrAfter(props.minDate, "month") && calEndDate && calTime.isSameOrBefore(calEndDate, "month") || props.minDate && calTime.isSameOrBefore(props.minDate, "month") && calEndDate && calTime.isSameOrAfter(calEndDate, "month");
            if ((_a = props.minDate) == null ? void 0 : _a.isSameOrAfter(calEndDate)) {
              cell.start = calEndDate && calTime.isSame(calEndDate, "month");
              cell.end = props.minDate && calTime.isSame(props.minDate, "month");
            } else {
              cell.start = props.minDate && calTime.isSame(props.minDate, "month");
              cell.end = calEndDate && calTime.isSame(calEndDate, "month");
            }
            const isToday = now.isSame(calTime);
            if (isToday) {
              cell.type = "today";
            }
            cell.text = index;
            const cellDate = calTime.toDate();
            cell.disabled = props.disabledDate && props.disabledDate(cellDate);
            row[j] = cell;
          }
        }
        return rows2;
      });
      const getCellStyle = (cell) => {
        const style = {};
        const year = props.date.year();
        const today = new Date();
        const month = cell.text;
        style.disabled = props.disabledDate ? datesInMonth(year, month, lang.value).every(props.disabledDate) : false;
        style.current = castArray(props.parsedValue).findIndex((date) => date.year() === year && date.month() === month) >= 0;
        style.today = today.getFullYear() === year && today.getMonth() === month;
        if (cell.inRange) {
          style["in-range"] = true;
          if (cell.start) {
            style["start-date"] = true;
          }
          if (cell.end) {
            style["end-date"] = true;
          }
        }
        return style;
      };
      const handleMouseMove = (event) => {
        if (!props.rangeState.selecting)
          return;
        let target = event.target;
        if (target.tagName === "A") {
          target = target.parentNode.parentNode;
        }
        if (target.tagName === "DIV") {
          target = target.parentNode;
        }
        if (target.tagName !== "TD")
          return;
        const row = target.parentNode.rowIndex;
        const column = target.cellIndex;
        if (rows.value[row][column].disabled)
          return;
        if (row !== lastRow.value || column !== lastColumn.value) {
          lastRow.value = row;
          lastColumn.value = column;
          ctx.emit("changerange", {
            selecting: true,
            endDate: props.date.startOf("year").month(row * 4 + column)
          });
        }
      };
      const handleMonthTableClick = (event) => {
        let target = event.target;
        if (target.tagName === "A") {
          target = target.parentNode.parentNode;
        }
        if (target.tagName === "DIV") {
          target = target.parentNode;
        }
        if (target.tagName !== "TD")
          return;
        if (hasClass(target, "disabled"))
          return;
        const column = target.cellIndex;
        const row = target.parentNode.rowIndex;
        const month = row * 4 + column;
        const newDate = props.date.startOf("year").month(month);
        if (props.selectionMode === "range") {
          if (!props.rangeState.selecting) {
            ctx.emit("pick", { minDate: newDate, maxDate: null });
            ctx.emit("select", true);
          } else {
            if (newDate >= props.minDate) {
              ctx.emit("pick", { minDate: props.minDate, maxDate: newDate });
            } else {
              ctx.emit("pick", { minDate: newDate, maxDate: props.minDate });
            }
            ctx.emit("select", false);
          }
        } else {
          ctx.emit("pick", month);
        }
      };
      return {
        handleMouseMove,
        handleMonthTableClick,
        rows,
        getCellStyle,
        t,
        months
      };
    }
  });
  const _hoisted_1$F = { class: "cell" };
  function _sfc_render$14(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("table", {
      class: "el-month-table",
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleMonthTableClick && _ctx.handleMonthTableClick(...args)),
      onMousemove: _cache[1] || (_cache[1] = (...args) => _ctx.handleMouseMove && _ctx.handleMouseMove(...args))
    }, [
      vue.createElementVNode("tbody", null, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.rows, (row, key) => {
          return vue.openBlock(), vue.createElementBlock("tr", { key }, [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(row, (cell, key_) => {
              return vue.openBlock(), vue.createElementBlock("td", {
                key: key_,
                class: vue.normalizeClass(_ctx.getCellStyle(cell))
              }, [
                vue.createElementVNode("div", null, [
                  vue.createElementVNode("a", _hoisted_1$F, vue.toDisplayString(_ctx.t("el.datepicker.months." + _ctx.months[cell.text])), 1)
                ])
              ], 2);
            }), 128))
          ]);
        }), 128))
      ])
    ], 32);
  }
  var MonthTable = /* @__PURE__ */ _export_sfc(_sfc_main$1h, [["render", _sfc_render$14]]);

  const datesInYear = (year, lang) => {
    const firstDay = dayjs(String(year)).locale(lang).startOf("year");
    const lastDay = firstDay.endOf("year");
    const numOfDays = lastDay.dayOfYear();
    return rangeArr(numOfDays).map((n) => firstDay.add(n, "day").toDate());
  };
  const _sfc_main$1g = vue.defineComponent({
    props: {
      disabledDate: {
        type: Function
      },
      parsedValue: {
        type: Object
      },
      date: {
        type: Object
      }
    },
    emits: ["pick"],
    setup(props, ctx) {
      const { lang } = useLocale();
      const startYear = vue.computed(() => {
        return Math.floor(props.date.year() / 10) * 10;
      });
      const getCellStyle = (year) => {
        const style = {};
        const today = dayjs().locale(lang.value);
        style.disabled = props.disabledDate ? datesInYear(year, lang.value).every(props.disabledDate) : false;
        style.current = castArray(props.parsedValue).findIndex((_) => _.year() === year) >= 0;
        style.today = today.year() === year;
        return style;
      };
      const handleYearTableClick = (event) => {
        const target = event.target;
        if (target.tagName === "A") {
          if (hasClass(target.parentNode, "disabled"))
            return;
          const year = target.textContent || target.innerText;
          ctx.emit("pick", Number(year));
        }
      };
      return {
        startYear,
        getCellStyle,
        handleYearTableClick
      };
    }
  });
  const _hoisted_1$E = { class: "cell" };
  const _hoisted_2$q = { class: "cell" };
  const _hoisted_3$f = { class: "cell" };
  const _hoisted_4$b = { class: "cell" };
  const _hoisted_5$9 = { class: "cell" };
  const _hoisted_6$6 = { class: "cell" };
  const _hoisted_7$5 = { class: "cell" };
  const _hoisted_8$5 = { class: "cell" };
  const _hoisted_9$5 = { class: "cell" };
  const _hoisted_10$5 = { class: "cell" };
  const _hoisted_11$3 = /* @__PURE__ */ vue.createElementVNode("td", null, null, -1);
  const _hoisted_12$3 = /* @__PURE__ */ vue.createElementVNode("td", null, null, -1);
  function _sfc_render$13(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("table", {
      class: "el-year-table",
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleYearTableClick && _ctx.handleYearTableClick(...args))
    }, [
      vue.createElementVNode("tbody", null, [
        vue.createElementVNode("tr", null, [
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 0)])
          }, [
            vue.createElementVNode("a", _hoisted_1$E, vue.toDisplayString(_ctx.startYear), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 1)])
          }, [
            vue.createElementVNode("a", _hoisted_2$q, vue.toDisplayString(_ctx.startYear + 1), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 2)])
          }, [
            vue.createElementVNode("a", _hoisted_3$f, vue.toDisplayString(_ctx.startYear + 2), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 3)])
          }, [
            vue.createElementVNode("a", _hoisted_4$b, vue.toDisplayString(_ctx.startYear + 3), 1)
          ], 2)
        ]),
        vue.createElementVNode("tr", null, [
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 4)])
          }, [
            vue.createElementVNode("a", _hoisted_5$9, vue.toDisplayString(_ctx.startYear + 4), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 5)])
          }, [
            vue.createElementVNode("a", _hoisted_6$6, vue.toDisplayString(_ctx.startYear + 5), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 6)])
          }, [
            vue.createElementVNode("a", _hoisted_7$5, vue.toDisplayString(_ctx.startYear + 6), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 7)])
          }, [
            vue.createElementVNode("a", _hoisted_8$5, vue.toDisplayString(_ctx.startYear + 7), 1)
          ], 2)
        ]),
        vue.createElementVNode("tr", null, [
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 8)])
          }, [
            vue.createElementVNode("a", _hoisted_9$5, vue.toDisplayString(_ctx.startYear + 8), 1)
          ], 2),
          vue.createElementVNode("td", {
            class: vue.normalizeClass(["available", _ctx.getCellStyle(_ctx.startYear + 9)])
          }, [
            vue.createElementVNode("a", _hoisted_10$5, vue.toDisplayString(_ctx.startYear + 9), 1)
          ], 2),
          _hoisted_11$3,
          _hoisted_12$3
        ])
      ])
    ]);
  }
  var YearTable = /* @__PURE__ */ _export_sfc(_sfc_main$1g, [["render", _sfc_render$13]]);

  const timeWithinRange = (_, __, ___) => true;
  const _sfc_main$1f = vue.defineComponent({
    components: {
      DateTable,
      ElInput,
      ElButton,
      ElIcon,
      TimePickPanel,
      MonthTable,
      YearTable,
      DArrowLeft: dArrowLeft,
      ArrowLeft: arrowLeft,
      DArrowRight: dArrowRight,
      ArrowRight: arrowRight
    },
    directives: { clickoutside: ClickOutside },
    props: {
      visible: {
        type: Boolean,
        default: false
      },
      parsedValue: {
        type: [Object, Array]
      },
      format: {
        type: String,
        default: ""
      },
      type: {
        type: String,
        required: true,
        validator: isValidDatePickType
      }
    },
    emits: ["pick", "set-picker-option", "panel-change"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const pickerBase = vue.inject("EP_PICKER_BASE");
      const popper = vue.inject(TOOLTIP_INJECTION_KEY);
      const {
        shortcuts,
        disabledDate,
        cellClassName,
        defaultTime,
        arrowControl
      } = pickerBase.props;
      const defaultValue = vue.toRef(pickerBase.props, "defaultValue");
      const innerDate = vue.ref(dayjs().locale(lang.value));
      const defaultTimeD = vue.computed(() => {
        return dayjs(defaultTime).locale(lang.value);
      });
      const month = vue.computed(() => {
        return innerDate.value.month();
      });
      const year = vue.computed(() => {
        return innerDate.value.year();
      });
      const selectableRange = vue.ref([]);
      const userInputDate = vue.ref(null);
      const userInputTime = vue.ref(null);
      const checkDateWithinRange = (date) => {
        return selectableRange.value.length > 0 ? timeWithinRange(date, selectableRange.value, props.format || "HH:mm:ss") : true;
      };
      const formatEmit = (emitDayjs) => {
        if (defaultTime && !visibleTime.value) {
          return defaultTimeD.value.year(emitDayjs.year()).month(emitDayjs.month()).date(emitDayjs.date());
        }
        if (showTime.value)
          return emitDayjs.millisecond(0);
        return emitDayjs.startOf("day");
      };
      const emit = (value, ...args) => {
        if (!value) {
          ctx.emit("pick", value, ...args);
        } else if (Array.isArray(value)) {
          const dates = value.map(formatEmit);
          ctx.emit("pick", dates, ...args);
        } else {
          ctx.emit("pick", formatEmit(value), ...args);
        }
        userInputDate.value = null;
        userInputTime.value = null;
      };
      const handleDatePick = (value) => {
        if (selectionMode.value === "day") {
          let newDate = props.parsedValue ? props.parsedValue.year(value.year()).month(value.month()).date(value.date()) : value;
          if (!checkDateWithinRange(newDate)) {
            newDate = selectableRange.value[0][0].year(value.year()).month(value.month()).date(value.date());
          }
          innerDate.value = newDate;
          emit(newDate, showTime.value);
        } else if (selectionMode.value === "week") {
          emit(value.date);
        } else if (selectionMode.value === "dates") {
          emit(value, true);
        }
      };
      const prevMonth_ = () => {
        innerDate.value = innerDate.value.subtract(1, "month");
        handlePanelChange("month");
      };
      const nextMonth_ = () => {
        innerDate.value = innerDate.value.add(1, "month");
        handlePanelChange("month");
      };
      const prevYear_ = () => {
        if (currentView.value === "year") {
          innerDate.value = innerDate.value.subtract(10, "year");
        } else {
          innerDate.value = innerDate.value.subtract(1, "year");
        }
        handlePanelChange("year");
      };
      const nextYear_ = () => {
        if (currentView.value === "year") {
          innerDate.value = innerDate.value.add(10, "year");
        } else {
          innerDate.value = innerDate.value.add(1, "year");
        }
        handlePanelChange("year");
      };
      const currentView = vue.ref("date");
      const yearLabel = vue.computed(() => {
        const yearTranslation = t("el.datepicker.year");
        if (currentView.value === "year") {
          const startYear = Math.floor(year.value / 10) * 10;
          if (yearTranslation) {
            return `${startYear} ${yearTranslation} - ${startYear + 9} ${yearTranslation}`;
          }
          return `${startYear} - ${startYear + 9}`;
        }
        return `${year.value} ${yearTranslation}`;
      });
      const handleShortcutClick = (shortcut) => {
        const shortcutValue = typeof shortcut.value === "function" ? shortcut.value() : shortcut.value;
        if (shortcutValue) {
          emit(dayjs(shortcutValue).locale(lang.value));
          return;
        }
        if (shortcut.onClick) {
          shortcut.onClick(ctx);
        }
      };
      const selectionMode = vue.computed(() => {
        if (["week", "month", "year", "dates"].includes(props.type)) {
          return props.type;
        }
        return "day";
      });
      vue.watch(() => selectionMode.value, (val) => {
        if (["month", "year"].includes(val)) {
          currentView.value = val;
          return;
        }
        currentView.value = "date";
      }, { immediate: true });
      vue.watch(() => currentView.value, () => {
        popper == null ? void 0 : popper.updatePopper();
      });
      const hasShortcuts = vue.computed(() => !!shortcuts.length);
      const handleMonthPick = (month2) => {
        innerDate.value = innerDate.value.startOf("month").month(month2);
        if (selectionMode.value === "month") {
          emit(innerDate.value);
        } else {
          currentView.value = "date";
        }
        handlePanelChange("month");
      };
      const handleYearPick = (year2) => {
        if (selectionMode.value === "year") {
          innerDate.value = innerDate.value.startOf("year").year(year2);
          emit(innerDate.value);
        } else {
          innerDate.value = innerDate.value.year(year2);
          currentView.value = "month";
        }
        handlePanelChange("year");
      };
      const showMonthPicker = () => {
        currentView.value = "month";
      };
      const showYearPicker = () => {
        currentView.value = "year";
      };
      const showTime = vue.computed(() => props.type === "datetime" || props.type === "datetimerange");
      const footerVisible = vue.computed(() => {
        return showTime.value || selectionMode.value === "dates";
      });
      const onConfirm = () => {
        if (selectionMode.value === "dates") {
          emit(props.parsedValue);
        } else {
          let result = props.parsedValue;
          if (!result) {
            const defaultTimeD2 = dayjs(defaultTime).locale(lang.value);
            const defaultValueD = getDefaultValue();
            result = defaultTimeD2.year(defaultValueD.year()).month(defaultValueD.month()).date(defaultValueD.date());
          }
          innerDate.value = result;
          emit(result);
        }
      };
      const changeToNow = () => {
        const now = dayjs().locale(lang.value);
        const nowDate = now.toDate();
        if ((!disabledDate || !disabledDate(nowDate)) && checkDateWithinRange(nowDate)) {
          innerDate.value = dayjs().locale(lang.value);
          emit(innerDate.value);
        }
      };
      const timeFormat = vue.computed(() => {
        return extractTimeFormat(props.format);
      });
      const dateFormat = vue.computed(() => {
        return extractDateFormat(props.format);
      });
      const visibleTime = vue.computed(() => {
        if (userInputTime.value)
          return userInputTime.value;
        if (!props.parsedValue && !defaultValue.value)
          return;
        return (props.parsedValue || innerDate.value).format(timeFormat.value);
      });
      const visibleDate = vue.computed(() => {
        if (userInputDate.value)
          return userInputDate.value;
        if (!props.parsedValue && !defaultValue.value)
          return;
        return (props.parsedValue || innerDate.value).format(dateFormat.value);
      });
      const timePickerVisible = vue.ref(false);
      const onTimePickerInputFocus = () => {
        timePickerVisible.value = true;
      };
      const handleTimePickClose = () => {
        timePickerVisible.value = false;
      };
      const handleTimePick = (value, visible, first) => {
        const newDate = props.parsedValue ? props.parsedValue.hour(value.hour()).minute(value.minute()).second(value.second()) : value;
        innerDate.value = newDate;
        emit(innerDate.value, true);
        if (!first) {
          timePickerVisible.value = visible;
        }
      };
      const handleVisibleTimeChange = (value) => {
        const newDate = dayjs(value, timeFormat.value).locale(lang.value);
        if (newDate.isValid() && checkDateWithinRange(newDate)) {
          innerDate.value = newDate.year(innerDate.value.year()).month(innerDate.value.month()).date(innerDate.value.date());
          userInputTime.value = null;
          timePickerVisible.value = false;
          emit(innerDate.value, true);
        }
      };
      const handleVisibleDateChange = (value) => {
        const newDate = dayjs(value, dateFormat.value).locale(lang.value);
        if (newDate.isValid()) {
          if (disabledDate && disabledDate(newDate.toDate())) {
            return;
          }
          innerDate.value = newDate.hour(innerDate.value.hour()).minute(innerDate.value.minute()).second(innerDate.value.second());
          userInputDate.value = null;
          emit(innerDate.value, true);
        }
      };
      const isValidValue = (date) => {
        return dayjs.isDayjs(date) && date.isValid() && (disabledDate ? !disabledDate(date.toDate()) : true);
      };
      const formatToString = (value) => {
        if (selectionMode.value === "dates") {
          return value.map((_) => _.format(props.format));
        }
        return value.format(props.format);
      };
      const parseUserInput = (value) => {
        return dayjs(value, props.format).locale(lang.value);
      };
      const getDefaultValue = () => {
        const parseDate = dayjs(defaultValue.value).locale(lang.value);
        if (!defaultValue.value) {
          const defaultTimeDValue = defaultTimeD.value;
          return dayjs().hour(defaultTimeDValue.hour()).minute(defaultTimeDValue.minute()).second(defaultTimeDValue.second()).locale(lang.value);
        }
        return parseDate;
      };
      const handleKeydown = (event) => {
        const { code, keyCode } = event;
        const list = [
          EVENT_CODE.up,
          EVENT_CODE.down,
          EVENT_CODE.left,
          EVENT_CODE.right
        ];
        if (props.visible && !timePickerVisible.value) {
          if (list.includes(code)) {
            handleKeyControl(keyCode);
            event.stopPropagation();
            event.preventDefault();
          }
          if (code === EVENT_CODE.enter && userInputDate.value === null && userInputTime.value === null) {
            emit(innerDate, false);
          }
        }
      };
      const handleKeyControl = (keyCode) => {
        const mapping = {
          year: {
            38: -4,
            40: 4,
            37: -1,
            39: 1,
            offset: (date, step) => date.setFullYear(date.getFullYear() + step)
          },
          month: {
            38: -4,
            40: 4,
            37: -1,
            39: 1,
            offset: (date, step) => date.setMonth(date.getMonth() + step)
          },
          week: {
            38: -1,
            40: 1,
            37: -1,
            39: 1,
            offset: (date, step) => date.setDate(date.getDate() + step * 7)
          },
          day: {
            38: -7,
            40: 7,
            37: -1,
            39: 1,
            offset: (date, step) => date.setDate(date.getDate() + step)
          }
        };
        const newDate = innerDate.value.toDate();
        while (Math.abs(innerDate.value.diff(newDate, "year", true)) < 1) {
          const map = mapping[selectionMode.value];
          map.offset(newDate, map[keyCode]);
          if (disabledDate && disabledDate(newDate)) {
            continue;
          }
          const result = dayjs(newDate).locale(lang.value);
          innerDate.value = result;
          ctx.emit("pick", result, true);
          break;
        }
      };
      const handlePanelChange = (mode) => {
        ctx.emit("panel-change", innerDate.value.toDate(), mode, currentView.value);
      };
      ctx.emit("set-picker-option", ["isValidValue", isValidValue]);
      ctx.emit("set-picker-option", ["formatToString", formatToString]);
      ctx.emit("set-picker-option", ["parseUserInput", parseUserInput]);
      ctx.emit("set-picker-option", ["handleKeydown", handleKeydown]);
      vue.watch(() => defaultValue.value, (val) => {
        if (val) {
          innerDate.value = getDefaultValue();
        }
      }, { immediate: true });
      vue.watch(() => props.parsedValue, (val) => {
        if (val) {
          if (selectionMode.value === "dates")
            return;
          if (Array.isArray(val))
            return;
          innerDate.value = val;
        } else {
          innerDate.value = getDefaultValue();
        }
      }, { immediate: true });
      return {
        handleTimePick,
        handleTimePickClose,
        onTimePickerInputFocus,
        timePickerVisible,
        visibleTime,
        visibleDate,
        showTime,
        changeToNow,
        onConfirm,
        footerVisible,
        handleYearPick,
        showMonthPicker,
        showYearPicker,
        handleMonthPick,
        hasShortcuts,
        shortcuts,
        arrowControl,
        disabledDate,
        cellClassName,
        selectionMode,
        handleShortcutClick,
        prevYear_,
        nextYear_,
        prevMonth_,
        nextMonth_,
        innerDate,
        t,
        yearLabel,
        currentView,
        month,
        handleDatePick,
        handleVisibleTimeChange,
        handleVisibleDateChange,
        timeFormat,
        userInputTime,
        userInputDate
      };
    }
  });
  const _hoisted_1$D = { class: "el-picker-panel__body-wrapper" };
  const _hoisted_2$p = {
    key: 0,
    class: "el-picker-panel__sidebar"
  };
  const _hoisted_3$e = ["onClick"];
  const _hoisted_4$a = { class: "el-picker-panel__body" };
  const _hoisted_5$8 = {
    key: 0,
    class: "el-date-picker__time-header"
  };
  const _hoisted_6$5 = { class: "el-date-picker__editor-wrap" };
  const _hoisted_7$4 = { class: "el-date-picker__editor-wrap" };
  const _hoisted_8$4 = ["aria-label"];
  const _hoisted_9$4 = ["aria-label"];
  const _hoisted_10$4 = ["aria-label"];
  const _hoisted_11$2 = ["aria-label"];
  const _hoisted_12$2 = { class: "el-picker-panel__content" };
  const _hoisted_13$2 = { class: "el-picker-panel__footer" };
  function _sfc_render$12(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_input = vue.resolveComponent("el-input");
    const _component_time_pick_panel = vue.resolveComponent("time-pick-panel");
    const _component_d_arrow_left = vue.resolveComponent("d-arrow-left");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_arrow_left = vue.resolveComponent("arrow-left");
    const _component_d_arrow_right = vue.resolveComponent("d-arrow-right");
    const _component_arrow_right = vue.resolveComponent("arrow-right");
    const _component_date_table = vue.resolveComponent("date-table");
    const _component_year_table = vue.resolveComponent("year-table");
    const _component_month_table = vue.resolveComponent("month-table");
    const _component_el_button = vue.resolveComponent("el-button");
    const _directive_clickoutside = vue.resolveDirective("clickoutside");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(["el-picker-panel el-date-picker", [
        {
          "has-sidebar": _ctx.$slots.sidebar || _ctx.hasShortcuts,
          "has-time": _ctx.showTime
        }
      ]])
    }, [
      vue.createElementVNode("div", _hoisted_1$D, [
        vue.renderSlot(_ctx.$slots, "sidebar", { class: "el-picker-panel__sidebar" }),
        _ctx.hasShortcuts ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_2$p, [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.shortcuts, (shortcut, key) => {
            return vue.openBlock(), vue.createElementBlock("button", {
              key,
              type: "button",
              class: "el-picker-panel__shortcut",
              onClick: ($event) => _ctx.handleShortcutClick(shortcut)
            }, vue.toDisplayString(shortcut.text), 9, _hoisted_3$e);
          }), 128))
        ])) : vue.createCommentVNode("v-if", true),
        vue.createElementVNode("div", _hoisted_4$a, [
          _ctx.showTime ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_5$8, [
            vue.createElementVNode("span", _hoisted_6$5, [
              vue.createVNode(_component_el_input, {
                placeholder: _ctx.t("el.datepicker.selectDate"),
                "model-value": _ctx.visibleDate,
                size: "small",
                onInput: _cache[0] || (_cache[0] = (val) => _ctx.userInputDate = val),
                onChange: _ctx.handleVisibleDateChange
              }, null, 8, ["placeholder", "model-value", "onChange"])
            ]),
            vue.withDirectives((vue.openBlock(), vue.createElementBlock("span", _hoisted_7$4, [
              vue.createVNode(_component_el_input, {
                placeholder: _ctx.t("el.datepicker.selectTime"),
                "model-value": _ctx.visibleTime,
                size: "small",
                onFocus: _ctx.onTimePickerInputFocus,
                onInput: _cache[1] || (_cache[1] = (val) => _ctx.userInputTime = val),
                onChange: _ctx.handleVisibleTimeChange
              }, null, 8, ["placeholder", "model-value", "onFocus", "onChange"]),
              vue.createVNode(_component_time_pick_panel, {
                visible: _ctx.timePickerVisible,
                format: _ctx.timeFormat,
                "time-arrow-control": _ctx.arrowControl,
                "parsed-value": _ctx.innerDate,
                onPick: _ctx.handleTimePick
              }, null, 8, ["visible", "format", "time-arrow-control", "parsed-value", "onPick"])
            ])), [
              [_directive_clickoutside, _ctx.handleTimePickClose]
            ])
          ])) : vue.createCommentVNode("v-if", true),
          vue.withDirectives(vue.createElementVNode("div", {
            class: vue.normalizeClass(["el-date-picker__header", {
              "el-date-picker__header--bordered": _ctx.currentView === "year" || _ctx.currentView === "month"
            }])
          }, [
            vue.createElementVNode("button", {
              type: "button",
              "aria-label": _ctx.t(`el.datepicker.prevYear`),
              class: "el-picker-panel__icon-btn el-date-picker__prev-btn d-arrow-left",
              onClick: _cache[2] || (_cache[2] = (...args) => _ctx.prevYear_ && _ctx.prevYear_(...args))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_d_arrow_left)
                ]),
                _: 1
              })
            ], 8, _hoisted_8$4),
            vue.withDirectives(vue.createElementVNode("button", {
              type: "button",
              "aria-label": _ctx.t(`el.datepicker.prevMonth`),
              class: "el-picker-panel__icon-btn el-date-picker__prev-btn arrow-left",
              onClick: _cache[3] || (_cache[3] = (...args) => _ctx.prevMonth_ && _ctx.prevMonth_(...args))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_left)
                ]),
                _: 1
              })
            ], 8, _hoisted_9$4), [
              [vue.vShow, _ctx.currentView === "date"]
            ]),
            vue.createElementVNode("span", {
              role: "button",
              class: "el-date-picker__header-label",
              onClick: _cache[4] || (_cache[4] = (...args) => _ctx.showYearPicker && _ctx.showYearPicker(...args))
            }, vue.toDisplayString(_ctx.yearLabel), 1),
            vue.withDirectives(vue.createElementVNode("span", {
              role: "button",
              class: vue.normalizeClass(["el-date-picker__header-label", { active: _ctx.currentView === "month" }]),
              onClick: _cache[5] || (_cache[5] = (...args) => _ctx.showMonthPicker && _ctx.showMonthPicker(...args))
            }, vue.toDisplayString(_ctx.t(`el.datepicker.month${_ctx.month + 1}`)), 3), [
              [vue.vShow, _ctx.currentView === "date"]
            ]),
            vue.createElementVNode("button", {
              type: "button",
              "aria-label": _ctx.t(`el.datepicker.nextYear`),
              class: "el-picker-panel__icon-btn el-date-picker__next-btn d-arrow-right",
              onClick: _cache[6] || (_cache[6] = (...args) => _ctx.nextYear_ && _ctx.nextYear_(...args))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_d_arrow_right)
                ]),
                _: 1
              })
            ], 8, _hoisted_10$4),
            vue.withDirectives(vue.createElementVNode("button", {
              type: "button",
              "aria-label": _ctx.t(`el.datepicker.nextMonth`),
              class: "el-picker-panel__icon-btn el-date-picker__next-btn arrow-right",
              onClick: _cache[7] || (_cache[7] = (...args) => _ctx.nextMonth_ && _ctx.nextMonth_(...args))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_right)
                ]),
                _: 1
              })
            ], 8, _hoisted_11$2), [
              [vue.vShow, _ctx.currentView === "date"]
            ])
          ], 2), [
            [vue.vShow, _ctx.currentView !== "time"]
          ]),
          vue.createElementVNode("div", _hoisted_12$2, [
            _ctx.currentView === "date" ? (vue.openBlock(), vue.createBlock(_component_date_table, {
              key: 0,
              "selection-mode": _ctx.selectionMode,
              date: _ctx.innerDate,
              "parsed-value": _ctx.parsedValue,
              "disabled-date": _ctx.disabledDate,
              onPick: _ctx.handleDatePick
            }, null, 8, ["selection-mode", "date", "parsed-value", "disabled-date", "onPick"])) : vue.createCommentVNode("v-if", true),
            _ctx.currentView === "year" ? (vue.openBlock(), vue.createBlock(_component_year_table, {
              key: 1,
              date: _ctx.innerDate,
              "disabled-date": _ctx.disabledDate,
              "parsed-value": _ctx.parsedValue,
              onPick: _ctx.handleYearPick
            }, null, 8, ["date", "disabled-date", "parsed-value", "onPick"])) : vue.createCommentVNode("v-if", true),
            _ctx.currentView === "month" ? (vue.openBlock(), vue.createBlock(_component_month_table, {
              key: 2,
              date: _ctx.innerDate,
              "parsed-value": _ctx.parsedValue,
              "disabled-date": _ctx.disabledDate,
              onPick: _ctx.handleMonthPick
            }, null, 8, ["date", "parsed-value", "disabled-date", "onPick"])) : vue.createCommentVNode("v-if", true)
          ])
        ])
      ]),
      vue.withDirectives(vue.createElementVNode("div", _hoisted_13$2, [
        vue.withDirectives(vue.createVNode(_component_el_button, {
          size: "small",
          type: "text",
          class: "el-picker-panel__link-btn",
          onClick: _ctx.changeToNow
        }, {
          default: vue.withCtx(() => [
            vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.now")), 1)
          ]),
          _: 1
        }, 8, ["onClick"]), [
          [vue.vShow, _ctx.selectionMode !== "dates"]
        ]),
        vue.createVNode(_component_el_button, {
          plain: "",
          size: "small",
          class: "el-picker-panel__link-btn",
          onClick: _ctx.onConfirm
        }, {
          default: vue.withCtx(() => [
            vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.confirm")), 1)
          ]),
          _: 1
        }, 8, ["onClick"])
      ], 512), [
        [vue.vShow, _ctx.footerVisible && _ctx.currentView === "date"]
      ])
    ], 2);
  }
  var DatePickPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1f, [["render", _sfc_render$12]]);

  const _sfc_main$1e = vue.defineComponent({
    directives: { clickoutside: ClickOutside },
    components: {
      TimePickPanel,
      DateTable,
      ElInput,
      ElButton,
      ElIcon,
      DArrowLeft: dArrowLeft,
      ArrowLeft: arrowLeft,
      DArrowRight: dArrowRight,
      ArrowRight: arrowRight
    },
    props: {
      unlinkPanels: Boolean,
      parsedValue: {
        type: Array
      },
      type: {
        type: String,
        required: true,
        validator: isValidDatePickType
      }
    },
    emits: ["pick", "set-picker-option", "calendar-change", "panel-change"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const leftDate = vue.ref(dayjs().locale(lang.value));
      const rightDate = vue.ref(dayjs().locale(lang.value).add(1, "month"));
      const minDate = vue.ref(null);
      const maxDate = vue.ref(null);
      const dateUserInput = vue.ref({
        min: null,
        max: null
      });
      const timeUserInput = vue.ref({
        min: null,
        max: null
      });
      const leftLabel = vue.computed(() => {
        return `${leftDate.value.year()} ${t("el.datepicker.year")} ${t(`el.datepicker.month${leftDate.value.month() + 1}`)}`;
      });
      const rightLabel = vue.computed(() => {
        return `${rightDate.value.year()} ${t("el.datepicker.year")} ${t(`el.datepicker.month${rightDate.value.month() + 1}`)}`;
      });
      const leftYear = vue.computed(() => {
        return leftDate.value.year();
      });
      const leftMonth = vue.computed(() => {
        return leftDate.value.month();
      });
      const rightYear = vue.computed(() => {
        return rightDate.value.year();
      });
      const rightMonth = vue.computed(() => {
        return rightDate.value.month();
      });
      const hasShortcuts = vue.computed(() => !!shortcuts.length);
      const minVisibleDate = vue.computed(() => {
        if (dateUserInput.value.min !== null)
          return dateUserInput.value.min;
        if (minDate.value)
          return minDate.value.format(dateFormat.value);
        return "";
      });
      const maxVisibleDate = vue.computed(() => {
        if (dateUserInput.value.max !== null)
          return dateUserInput.value.max;
        if (maxDate.value || minDate.value)
          return (maxDate.value || minDate.value).format(dateFormat.value);
        return "";
      });
      const minVisibleTime = vue.computed(() => {
        if (timeUserInput.value.min !== null)
          return timeUserInput.value.min;
        if (minDate.value)
          return minDate.value.format(timeFormat.value);
        return "";
      });
      const maxVisibleTime = vue.computed(() => {
        if (timeUserInput.value.max !== null)
          return timeUserInput.value.max;
        if (maxDate.value || minDate.value)
          return (maxDate.value || minDate.value).format(timeFormat.value);
        return "";
      });
      const timeFormat = vue.computed(() => {
        return extractTimeFormat(format);
      });
      const dateFormat = vue.computed(() => {
        return extractDateFormat(format);
      });
      const leftPrevYear = () => {
        leftDate.value = leftDate.value.subtract(1, "year");
        if (!props.unlinkPanels) {
          rightDate.value = leftDate.value.add(1, "month");
        }
        handlePanelChange("year");
      };
      const leftPrevMonth = () => {
        leftDate.value = leftDate.value.subtract(1, "month");
        if (!props.unlinkPanels) {
          rightDate.value = leftDate.value.add(1, "month");
        }
        handlePanelChange("month");
      };
      const rightNextYear = () => {
        if (!props.unlinkPanels) {
          leftDate.value = leftDate.value.add(1, "year");
          rightDate.value = leftDate.value.add(1, "month");
        } else {
          rightDate.value = rightDate.value.add(1, "year");
        }
        handlePanelChange("year");
      };
      const rightNextMonth = () => {
        if (!props.unlinkPanels) {
          leftDate.value = leftDate.value.add(1, "month");
          rightDate.value = leftDate.value.add(1, "month");
        } else {
          rightDate.value = rightDate.value.add(1, "month");
        }
        handlePanelChange("month");
      };
      const leftNextYear = () => {
        leftDate.value = leftDate.value.add(1, "year");
        handlePanelChange("year");
      };
      const leftNextMonth = () => {
        leftDate.value = leftDate.value.add(1, "month");
        handlePanelChange("month");
      };
      const rightPrevYear = () => {
        rightDate.value = rightDate.value.subtract(1, "year");
        handlePanelChange("year");
      };
      const rightPrevMonth = () => {
        rightDate.value = rightDate.value.subtract(1, "month");
        handlePanelChange("month");
      };
      const handlePanelChange = (mode) => {
        ctx.emit("panel-change", [leftDate.value.toDate(), rightDate.value.toDate()], mode);
      };
      const enableMonthArrow = vue.computed(() => {
        const nextMonth = (leftMonth.value + 1) % 12;
        const yearOffset = leftMonth.value + 1 >= 12 ? 1 : 0;
        return props.unlinkPanels && new Date(leftYear.value + yearOffset, nextMonth) < new Date(rightYear.value, rightMonth.value);
      });
      const enableYearArrow = vue.computed(() => {
        return props.unlinkPanels && rightYear.value * 12 + rightMonth.value - (leftYear.value * 12 + leftMonth.value + 1) >= 12;
      });
      const isValidValue = (value) => {
        return Array.isArray(value) && value[0] && value[1] && value[0].valueOf() <= value[1].valueOf();
      };
      const rangeState = vue.ref({
        endDate: null,
        selecting: false
      });
      const btnDisabled = vue.computed(() => {
        return !(minDate.value && maxDate.value && !rangeState.value.selecting && isValidValue([minDate.value, maxDate.value]));
      });
      const handleChangeRange = (val) => {
        rangeState.value = val;
      };
      const onSelect = (selecting) => {
        rangeState.value.selecting = selecting;
        if (!selecting) {
          rangeState.value.endDate = null;
        }
      };
      const showTime = vue.computed(() => props.type === "datetime" || props.type === "datetimerange");
      const handleConfirm = (visible = false) => {
        if (isValidValue([minDate.value, maxDate.value])) {
          ctx.emit("pick", [minDate.value, maxDate.value], visible);
        }
      };
      const formatEmit = (emitDayjs, index) => {
        if (!emitDayjs)
          return;
        if (defaultTime) {
          const defaultTimeD = dayjs(defaultTime[index] || defaultTime).locale(lang.value);
          return defaultTimeD.year(emitDayjs.year()).month(emitDayjs.month()).date(emitDayjs.date());
        }
        return emitDayjs;
      };
      const handleRangePick = (val, close = true) => {
        const min_ = val.minDate;
        const max_ = val.maxDate;
        const minDate_ = formatEmit(min_, 0);
        const maxDate_ = formatEmit(max_, 1);
        if (maxDate.value === maxDate_ && minDate.value === minDate_) {
          return;
        }
        ctx.emit("calendar-change", [min_.toDate(), max_ && max_.toDate()]);
        maxDate.value = maxDate_;
        minDate.value = minDate_;
        if (!close || showTime.value)
          return;
        handleConfirm();
      };
      const handleShortcutClick = (shortcut) => {
        const shortcutValues = typeof shortcut.value === "function" ? shortcut.value() : shortcut.value;
        if (shortcutValues) {
          ctx.emit("pick", [
            dayjs(shortcutValues[0]).locale(lang.value),
            dayjs(shortcutValues[1]).locale(lang.value)
          ]);
          return;
        }
        if (shortcut.onClick) {
          shortcut.onClick(ctx);
        }
      };
      const minTimePickerVisible = vue.ref(false);
      const maxTimePickerVisible = vue.ref(false);
      const handleMinTimeClose = () => {
        minTimePickerVisible.value = false;
      };
      const handleMaxTimeClose = () => {
        maxTimePickerVisible.value = false;
      };
      const handleDateInput = (value, type) => {
        dateUserInput.value[type] = value;
        const parsedValueD = dayjs(value, dateFormat.value).locale(lang.value);
        if (parsedValueD.isValid()) {
          if (disabledDate && disabledDate(parsedValueD.toDate())) {
            return;
          }
          if (type === "min") {
            leftDate.value = parsedValueD;
            minDate.value = (minDate.value || leftDate.value).year(parsedValueD.year()).month(parsedValueD.month()).date(parsedValueD.date());
            if (!props.unlinkPanels) {
              rightDate.value = parsedValueD.add(1, "month");
              maxDate.value = minDate.value.add(1, "month");
            }
          } else {
            rightDate.value = parsedValueD;
            maxDate.value = (maxDate.value || rightDate.value).year(parsedValueD.year()).month(parsedValueD.month()).date(parsedValueD.date());
            if (!props.unlinkPanels) {
              leftDate.value = parsedValueD.subtract(1, "month");
              minDate.value = maxDate.value.subtract(1, "month");
            }
          }
        }
      };
      const handleDateChange = (_, type) => {
        dateUserInput.value[type] = null;
      };
      const handleTimeInput = (value, type) => {
        timeUserInput.value[type] = value;
        const parsedValueD = dayjs(value, timeFormat.value).locale(lang.value);
        if (parsedValueD.isValid()) {
          if (type === "min") {
            minTimePickerVisible.value = true;
            minDate.value = (minDate.value || leftDate.value).hour(parsedValueD.hour()).minute(parsedValueD.minute()).second(parsedValueD.second());
            if (!maxDate.value || maxDate.value.isBefore(minDate.value)) {
              maxDate.value = minDate.value;
            }
          } else {
            maxTimePickerVisible.value = true;
            maxDate.value = (maxDate.value || rightDate.value).hour(parsedValueD.hour()).minute(parsedValueD.minute()).second(parsedValueD.second());
            rightDate.value = maxDate.value;
            if (maxDate.value && maxDate.value.isBefore(minDate.value)) {
              minDate.value = maxDate.value;
            }
          }
        }
      };
      const handleTimeChange = (value, type) => {
        timeUserInput.value[type] = null;
        if (type === "min") {
          leftDate.value = minDate.value;
          minTimePickerVisible.value = false;
        } else {
          rightDate.value = maxDate.value;
          maxTimePickerVisible.value = false;
        }
      };
      const handleMinTimePick = (value, visible, first) => {
        if (timeUserInput.value.min)
          return;
        if (value) {
          leftDate.value = value;
          minDate.value = (minDate.value || leftDate.value).hour(value.hour()).minute(value.minute()).second(value.second());
        }
        if (!first) {
          minTimePickerVisible.value = visible;
        }
        if (!maxDate.value || maxDate.value.isBefore(minDate.value)) {
          maxDate.value = minDate.value;
          rightDate.value = value;
        }
      };
      const handleMaxTimePick = (value, visible, first) => {
        if (timeUserInput.value.max)
          return;
        if (value) {
          rightDate.value = value;
          maxDate.value = (maxDate.value || rightDate.value).hour(value.hour()).minute(value.minute()).second(value.second());
        }
        if (!first) {
          maxTimePickerVisible.value = visible;
        }
        if (maxDate.value && maxDate.value.isBefore(minDate.value)) {
          minDate.value = maxDate.value;
        }
      };
      const handleClear = () => {
        leftDate.value = getDefaultValue()[0];
        rightDate.value = leftDate.value.add(1, "month");
        ctx.emit("pick", null);
      };
      const formatToString = (value) => {
        return Array.isArray(value) ? value.map((_) => _.format(format)) : value.format(format);
      };
      const parseUserInput = (value) => {
        return Array.isArray(value) ? value.map((_) => dayjs(_, format).locale(lang.value)) : dayjs(value, format).locale(lang.value);
      };
      const getDefaultValue = () => {
        let start;
        if (Array.isArray(defaultValue.value)) {
          const left = dayjs(defaultValue.value[0]);
          let right = dayjs(defaultValue.value[1]);
          if (!props.unlinkPanels) {
            right = left.add(1, "month");
          }
          return [left, right];
        } else if (defaultValue.value) {
          start = dayjs(defaultValue.value);
        } else {
          start = dayjs();
        }
        start = start.locale(lang.value);
        return [start, start.add(1, "month")];
      };
      ctx.emit("set-picker-option", ["isValidValue", isValidValue]);
      ctx.emit("set-picker-option", ["parseUserInput", parseUserInput]);
      ctx.emit("set-picker-option", ["formatToString", formatToString]);
      ctx.emit("set-picker-option", ["handleClear", handleClear]);
      const pickerBase = vue.inject("EP_PICKER_BASE");
      const {
        shortcuts,
        disabledDate,
        cellClassName,
        format,
        defaultTime,
        arrowControl,
        clearable
      } = pickerBase.props;
      const defaultValue = vue.toRef(pickerBase.props, "defaultValue");
      vue.watch(() => defaultValue.value, (val) => {
        if (val) {
          const defaultArr = getDefaultValue();
          minDate.value = null;
          maxDate.value = null;
          leftDate.value = defaultArr[0];
          rightDate.value = defaultArr[1];
        }
      }, { immediate: true });
      vue.watch(() => props.parsedValue, (newVal) => {
        if (newVal && newVal.length === 2) {
          minDate.value = newVal[0];
          maxDate.value = newVal[1];
          leftDate.value = minDate.value;
          if (props.unlinkPanels && maxDate.value) {
            const minDateYear = minDate.value.year();
            const minDateMonth = minDate.value.month();
            const maxDateYear = maxDate.value.year();
            const maxDateMonth = maxDate.value.month();
            rightDate.value = minDateYear === maxDateYear && minDateMonth === maxDateMonth ? maxDate.value.add(1, "month") : maxDate.value;
          } else {
            rightDate.value = leftDate.value.add(1, "month");
            if (maxDate.value) {
              rightDate.value = rightDate.value.hour(maxDate.value.hour()).minute(maxDate.value.minute()).second(maxDate.value.second());
            }
          }
        } else {
          const defaultArr = getDefaultValue();
          minDate.value = null;
          maxDate.value = null;
          leftDate.value = defaultArr[0];
          rightDate.value = defaultArr[1];
        }
      }, { immediate: true });
      return {
        shortcuts,
        disabledDate,
        cellClassName,
        minTimePickerVisible,
        maxTimePickerVisible,
        handleMinTimeClose,
        handleMaxTimeClose,
        handleShortcutClick,
        rangeState,
        minDate,
        maxDate,
        handleRangePick,
        onSelect,
        handleChangeRange,
        btnDisabled,
        enableYearArrow,
        enableMonthArrow,
        rightPrevMonth,
        rightPrevYear,
        rightNextMonth,
        rightNextYear,
        leftPrevMonth,
        leftPrevYear,
        leftNextMonth,
        leftNextYear,
        hasShortcuts,
        leftLabel,
        rightLabel,
        leftDate,
        rightDate,
        showTime,
        t,
        minVisibleDate,
        maxVisibleDate,
        minVisibleTime,
        maxVisibleTime,
        arrowControl,
        handleDateInput,
        handleDateChange,
        handleTimeInput,
        handleTimeChange,
        handleMinTimePick,
        handleMaxTimePick,
        handleClear,
        handleConfirm,
        timeFormat,
        clearable
      };
    }
  });
  const _hoisted_1$C = { class: "el-picker-panel__body-wrapper" };
  const _hoisted_2$o = {
    key: 0,
    class: "el-picker-panel__sidebar"
  };
  const _hoisted_3$d = ["onClick"];
  const _hoisted_4$9 = { class: "el-picker-panel__body" };
  const _hoisted_5$7 = {
    key: 0,
    class: "el-date-range-picker__time-header"
  };
  const _hoisted_6$4 = { class: "el-date-range-picker__editors-wrap" };
  const _hoisted_7$3 = { class: "el-date-range-picker__time-picker-wrap" };
  const _hoisted_8$3 = { class: "el-date-range-picker__time-picker-wrap" };
  const _hoisted_9$3 = { class: "el-date-range-picker__editors-wrap is-right" };
  const _hoisted_10$3 = { class: "el-date-range-picker__time-picker-wrap" };
  const _hoisted_11$1 = { class: "el-date-range-picker__time-picker-wrap" };
  const _hoisted_12$1 = { class: "el-picker-panel__content el-date-range-picker__content is-left" };
  const _hoisted_13$1 = { class: "el-date-range-picker__header" };
  const _hoisted_14$1 = ["disabled"];
  const _hoisted_15$1 = ["disabled"];
  const _hoisted_16$1 = { class: "el-picker-panel__content el-date-range-picker__content is-right" };
  const _hoisted_17$1 = { class: "el-date-range-picker__header" };
  const _hoisted_18$1 = ["disabled"];
  const _hoisted_19$1 = ["disabled"];
  const _hoisted_20$1 = {
    key: 0,
    class: "el-picker-panel__footer"
  };
  function _sfc_render$11(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_input = vue.resolveComponent("el-input");
    const _component_time_pick_panel = vue.resolveComponent("time-pick-panel");
    const _component_arrow_right = vue.resolveComponent("arrow-right");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_d_arrow_left = vue.resolveComponent("d-arrow-left");
    const _component_arrow_left = vue.resolveComponent("arrow-left");
    const _component_d_arrow_right = vue.resolveComponent("d-arrow-right");
    const _component_date_table = vue.resolveComponent("date-table");
    const _component_el_button = vue.resolveComponent("el-button");
    const _directive_clickoutside = vue.resolveDirective("clickoutside");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(["el-picker-panel el-date-range-picker", [
        {
          "has-sidebar": _ctx.$slots.sidebar || _ctx.hasShortcuts,
          "has-time": _ctx.showTime
        }
      ]])
    }, [
      vue.createElementVNode("div", _hoisted_1$C, [
        vue.renderSlot(_ctx.$slots, "sidebar", { class: "el-picker-panel__sidebar" }),
        _ctx.hasShortcuts ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_2$o, [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.shortcuts, (shortcut, key) => {
            return vue.openBlock(), vue.createElementBlock("button", {
              key,
              type: "button",
              class: "el-picker-panel__shortcut",
              onClick: ($event) => _ctx.handleShortcutClick(shortcut)
            }, vue.toDisplayString(shortcut.text), 9, _hoisted_3$d);
          }), 128))
        ])) : vue.createCommentVNode("v-if", true),
        vue.createElementVNode("div", _hoisted_4$9, [
          _ctx.showTime ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_5$7, [
            vue.createElementVNode("span", _hoisted_6$4, [
              vue.createElementVNode("span", _hoisted_7$3, [
                vue.createVNode(_component_el_input, {
                  size: "small",
                  disabled: _ctx.rangeState.selecting,
                  placeholder: _ctx.t("el.datepicker.startDate"),
                  class: "el-date-range-picker__editor",
                  "model-value": _ctx.minVisibleDate,
                  onInput: _cache[0] || (_cache[0] = (val) => _ctx.handleDateInput(val, "min")),
                  onChange: _cache[1] || (_cache[1] = (val) => _ctx.handleDateChange(val, "min"))
                }, null, 8, ["disabled", "placeholder", "model-value"])
              ]),
              vue.withDirectives((vue.openBlock(), vue.createElementBlock("span", _hoisted_8$3, [
                vue.createVNode(_component_el_input, {
                  size: "small",
                  class: "el-date-range-picker__editor",
                  disabled: _ctx.rangeState.selecting,
                  placeholder: _ctx.t("el.datepicker.startTime"),
                  "model-value": _ctx.minVisibleTime,
                  onFocus: _cache[2] || (_cache[2] = ($event) => _ctx.minTimePickerVisible = true),
                  onInput: _cache[3] || (_cache[3] = (val) => _ctx.handleTimeInput(val, "min")),
                  onChange: _cache[4] || (_cache[4] = (val) => _ctx.handleTimeChange(val, "min"))
                }, null, 8, ["disabled", "placeholder", "model-value"]),
                vue.createVNode(_component_time_pick_panel, {
                  visible: _ctx.minTimePickerVisible,
                  format: _ctx.timeFormat,
                  "datetime-role": "start",
                  "time-arrow-control": _ctx.arrowControl,
                  "parsed-value": _ctx.leftDate,
                  onPick: _ctx.handleMinTimePick
                }, null, 8, ["visible", "format", "time-arrow-control", "parsed-value", "onPick"])
              ])), [
                [_directive_clickoutside, _ctx.handleMinTimeClose]
              ])
            ]),
            vue.createElementVNode("span", null, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_right)
                ]),
                _: 1
              })
            ]),
            vue.createElementVNode("span", _hoisted_9$3, [
              vue.createElementVNode("span", _hoisted_10$3, [
                vue.createVNode(_component_el_input, {
                  size: "small",
                  class: "el-date-range-picker__editor",
                  disabled: _ctx.rangeState.selecting,
                  placeholder: _ctx.t("el.datepicker.endDate"),
                  "model-value": _ctx.maxVisibleDate,
                  readonly: !_ctx.minDate,
                  onInput: _cache[5] || (_cache[5] = (val) => _ctx.handleDateInput(val, "max")),
                  onChange: _cache[6] || (_cache[6] = (val) => _ctx.handleDateChange(val, "max"))
                }, null, 8, ["disabled", "placeholder", "model-value", "readonly"])
              ]),
              vue.withDirectives((vue.openBlock(), vue.createElementBlock("span", _hoisted_11$1, [
                vue.createVNode(_component_el_input, {
                  size: "small",
                  class: "el-date-range-picker__editor",
                  disabled: _ctx.rangeState.selecting,
                  placeholder: _ctx.t("el.datepicker.endTime"),
                  "model-value": _ctx.maxVisibleTime,
                  readonly: !_ctx.minDate,
                  onFocus: _cache[7] || (_cache[7] = ($event) => _ctx.minDate && (_ctx.maxTimePickerVisible = true)),
                  onInput: _cache[8] || (_cache[8] = (val) => _ctx.handleTimeInput(val, "max")),
                  onChange: _cache[9] || (_cache[9] = (val) => _ctx.handleTimeChange(val, "max"))
                }, null, 8, ["disabled", "placeholder", "model-value", "readonly"]),
                vue.createVNode(_component_time_pick_panel, {
                  "datetime-role": "end",
                  visible: _ctx.maxTimePickerVisible,
                  format: _ctx.timeFormat,
                  "time-arrow-control": _ctx.arrowControl,
                  "parsed-value": _ctx.rightDate,
                  onPick: _ctx.handleMaxTimePick
                }, null, 8, ["visible", "format", "time-arrow-control", "parsed-value", "onPick"])
              ])), [
                [_directive_clickoutside, _ctx.handleMaxTimeClose]
              ])
            ])
          ])) : vue.createCommentVNode("v-if", true),
          vue.createElementVNode("div", _hoisted_12$1, [
            vue.createElementVNode("div", _hoisted_13$1, [
              vue.createElementVNode("button", {
                type: "button",
                class: "el-picker-panel__icon-btn d-arrow-left",
                onClick: _cache[10] || (_cache[10] = (...args) => _ctx.leftPrevYear && _ctx.leftPrevYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_left)
                  ]),
                  _: 1
                })
              ]),
              vue.createElementVNode("button", {
                type: "button",
                class: "el-picker-panel__icon-btn arrow-left",
                onClick: _cache[11] || (_cache[11] = (...args) => _ctx.leftPrevMonth && _ctx.leftPrevMonth(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_left)
                  ]),
                  _: 1
                })
              ]),
              _ctx.unlinkPanels ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 0,
                type: "button",
                disabled: !_ctx.enableYearArrow,
                class: vue.normalizeClass([{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn d-arrow-right"]),
                onClick: _cache[12] || (_cache[12] = (...args) => _ctx.leftNextYear && _ctx.leftNextYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_right)
                  ]),
                  _: 1
                })
              ], 10, _hoisted_14$1)) : vue.createCommentVNode("v-if", true),
              _ctx.unlinkPanels ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 1,
                type: "button",
                disabled: !_ctx.enableMonthArrow,
                class: vue.normalizeClass([{ "is-disabled": !_ctx.enableMonthArrow }, "el-picker-panel__icon-btn arrow-right"]),
                onClick: _cache[13] || (_cache[13] = (...args) => _ctx.leftNextMonth && _ctx.leftNextMonth(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_right)
                  ]),
                  _: 1
                })
              ], 10, _hoisted_15$1)) : vue.createCommentVNode("v-if", true),
              vue.createElementVNode("div", null, vue.toDisplayString(_ctx.leftLabel), 1)
            ]),
            vue.createVNode(_component_date_table, {
              "selection-mode": "range",
              date: _ctx.leftDate,
              "min-date": _ctx.minDate,
              "max-date": _ctx.maxDate,
              "range-state": _ctx.rangeState,
              "disabled-date": _ctx.disabledDate,
              "cell-class-name": _ctx.cellClassName,
              onChangerange: _ctx.handleChangeRange,
              onPick: _ctx.handleRangePick,
              onSelect: _ctx.onSelect
            }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "cell-class-name", "onChangerange", "onPick", "onSelect"])
          ]),
          vue.createElementVNode("div", _hoisted_16$1, [
            vue.createElementVNode("div", _hoisted_17$1, [
              _ctx.unlinkPanels ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 0,
                type: "button",
                disabled: !_ctx.enableYearArrow,
                class: vue.normalizeClass([{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn d-arrow-left"]),
                onClick: _cache[14] || (_cache[14] = (...args) => _ctx.rightPrevYear && _ctx.rightPrevYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_left)
                  ]),
                  _: 1
                })
              ], 10, _hoisted_18$1)) : vue.createCommentVNode("v-if", true),
              _ctx.unlinkPanels ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 1,
                type: "button",
                disabled: !_ctx.enableMonthArrow,
                class: vue.normalizeClass([{ "is-disabled": !_ctx.enableMonthArrow }, "el-picker-panel__icon-btn arrow-left"]),
                onClick: _cache[15] || (_cache[15] = (...args) => _ctx.rightPrevMonth && _ctx.rightPrevMonth(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_left)
                  ]),
                  _: 1
                })
              ], 10, _hoisted_19$1)) : vue.createCommentVNode("v-if", true),
              vue.createElementVNode("button", {
                type: "button",
                class: "el-picker-panel__icon-btn d-arrow-right",
                onClick: _cache[16] || (_cache[16] = (...args) => _ctx.rightNextYear && _ctx.rightNextYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_right)
                  ]),
                  _: 1
                })
              ]),
              vue.createElementVNode("button", {
                type: "button",
                class: "el-picker-panel__icon-btn arrow-right",
                onClick: _cache[17] || (_cache[17] = (...args) => _ctx.rightNextMonth && _ctx.rightNextMonth(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_right)
                  ]),
                  _: 1
                })
              ]),
              vue.createElementVNode("div", null, vue.toDisplayString(_ctx.rightLabel), 1)
            ]),
            vue.createVNode(_component_date_table, {
              "selection-mode": "range",
              date: _ctx.rightDate,
              "min-date": _ctx.minDate,
              "max-date": _ctx.maxDate,
              "range-state": _ctx.rangeState,
              "disabled-date": _ctx.disabledDate,
              "cell-class-name": _ctx.cellClassName,
              onChangerange: _ctx.handleChangeRange,
              onPick: _ctx.handleRangePick,
              onSelect: _ctx.onSelect
            }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "cell-class-name", "onChangerange", "onPick", "onSelect"])
          ])
        ])
      ]),
      _ctx.showTime ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_20$1, [
        _ctx.clearable ? (vue.openBlock(), vue.createBlock(_component_el_button, {
          key: 0,
          size: "small",
          type: "text",
          class: "el-picker-panel__link-btn",
          onClick: _ctx.handleClear
        }, {
          default: vue.withCtx(() => [
            vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.clear")), 1)
          ]),
          _: 1
        }, 8, ["onClick"])) : vue.createCommentVNode("v-if", true),
        vue.createVNode(_component_el_button, {
          plain: "",
          size: "small",
          class: "el-picker-panel__link-btn",
          disabled: _ctx.btnDisabled,
          onClick: _cache[18] || (_cache[18] = ($event) => _ctx.handleConfirm(false))
        }, {
          default: vue.withCtx(() => [
            vue.createTextVNode(vue.toDisplayString(_ctx.t("el.datepicker.confirm")), 1)
          ]),
          _: 1
        }, 8, ["disabled"])
      ])) : vue.createCommentVNode("v-if", true)
    ], 2);
  }
  var DateRangePickPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1e, [["render", _sfc_render$11]]);

  const _sfc_main$1d = vue.defineComponent({
    components: { MonthTable, ElIcon, DArrowLeft: dArrowLeft, DArrowRight: dArrowRight },
    props: {
      unlinkPanels: Boolean,
      parsedValue: {
        type: Array
      }
    },
    emits: ["pick", "set-picker-option"],
    setup(props, ctx) {
      const { t, lang } = useLocale();
      const leftDate = vue.ref(dayjs().locale(lang.value));
      const rightDate = vue.ref(dayjs().locale(lang.value).add(1, "year"));
      const hasShortcuts = vue.computed(() => !!shortcuts.length);
      const handleShortcutClick = (shortcut) => {
        const shortcutValues = typeof shortcut.value === "function" ? shortcut.value() : shortcut.value;
        if (shortcutValues) {
          ctx.emit("pick", [
            dayjs(shortcutValues[0]).locale(lang.value),
            dayjs(shortcutValues[1]).locale(lang.value)
          ]);
          return;
        }
        if (shortcut.onClick) {
          shortcut.onClick(ctx);
        }
      };
      const leftPrevYear = () => {
        leftDate.value = leftDate.value.subtract(1, "year");
        if (!props.unlinkPanels) {
          rightDate.value = rightDate.value.subtract(1, "year");
        }
      };
      const rightNextYear = () => {
        if (!props.unlinkPanels) {
          leftDate.value = leftDate.value.add(1, "year");
        }
        rightDate.value = rightDate.value.add(1, "year");
      };
      const leftNextYear = () => {
        leftDate.value = leftDate.value.add(1, "year");
      };
      const rightPrevYear = () => {
        rightDate.value = rightDate.value.subtract(1, "year");
      };
      const leftLabel = vue.computed(() => {
        return `${leftDate.value.year()} ${t("el.datepicker.year")}`;
      });
      const rightLabel = vue.computed(() => {
        return `${rightDate.value.year()} ${t("el.datepicker.year")}`;
      });
      const leftYear = vue.computed(() => {
        return leftDate.value.year();
      });
      const rightYear = vue.computed(() => {
        return rightDate.value.year() === leftDate.value.year() ? leftDate.value.year() + 1 : rightDate.value.year();
      });
      const enableYearArrow = vue.computed(() => {
        return props.unlinkPanels && rightYear.value > leftYear.value + 1;
      });
      const minDate = vue.ref(null);
      const maxDate = vue.ref(null);
      const rangeState = vue.ref({
        endDate: null,
        selecting: false
      });
      const handleChangeRange = (val) => {
        rangeState.value = val;
      };
      const handleRangePick = (val, close = true) => {
        const minDate_ = val.minDate;
        const maxDate_ = val.maxDate;
        if (maxDate.value === maxDate_ && minDate.value === minDate_) {
          return;
        }
        maxDate.value = maxDate_;
        minDate.value = minDate_;
        if (!close)
          return;
        handleConfirm();
      };
      const isValidValue = (value) => {
        return Array.isArray(value) && value && value[0] && value[1] && value[0].valueOf() <= value[1].valueOf();
      };
      const handleConfirm = (visible = false) => {
        if (isValidValue([minDate.value, maxDate.value])) {
          ctx.emit("pick", [minDate.value, maxDate.value], visible);
        }
      };
      const onSelect = (selecting) => {
        rangeState.value.selecting = selecting;
        if (!selecting) {
          rangeState.value.endDate = null;
        }
      };
      const formatToString = (value) => {
        return value.map((_) => _.format(format));
      };
      const getDefaultValue = () => {
        let start;
        if (Array.isArray(defaultValue.value)) {
          const left = dayjs(defaultValue.value[0]);
          let right = dayjs(defaultValue.value[1]);
          if (!props.unlinkPanels) {
            right = left.add(1, "year");
          }
          return [left, right];
        } else if (defaultValue.value) {
          start = dayjs(defaultValue.value);
        } else {
          start = dayjs();
        }
        start = start.locale(lang.value);
        return [start, start.add(1, "year")];
      };
      ctx.emit("set-picker-option", ["formatToString", formatToString]);
      const pickerBase = vue.inject("EP_PICKER_BASE");
      const { shortcuts, disabledDate, format } = pickerBase.props;
      const defaultValue = vue.toRef(pickerBase.props, "defaultValue");
      vue.watch(() => defaultValue.value, (val) => {
        if (val) {
          const defaultArr = getDefaultValue();
          leftDate.value = defaultArr[0];
          rightDate.value = defaultArr[1];
        }
      }, { immediate: true });
      vue.watch(() => props.parsedValue, (newVal) => {
        if (newVal && newVal.length === 2) {
          minDate.value = newVal[0];
          maxDate.value = newVal[1];
          leftDate.value = minDate.value;
          if (props.unlinkPanels && maxDate.value) {
            const minDateYear = minDate.value.year();
            const maxDateYear = maxDate.value.year();
            rightDate.value = minDateYear === maxDateYear ? maxDate.value.add(1, "year") : maxDate.value;
          } else {
            rightDate.value = leftDate.value.add(1, "year");
          }
        } else {
          const defaultArr = getDefaultValue();
          minDate.value = null;
          maxDate.value = null;
          leftDate.value = defaultArr[0];
          rightDate.value = defaultArr[1];
        }
      }, { immediate: true });
      return {
        shortcuts,
        disabledDate,
        onSelect,
        handleRangePick,
        rangeState,
        handleChangeRange,
        minDate,
        maxDate,
        enableYearArrow,
        leftLabel,
        rightLabel,
        leftNextYear,
        leftPrevYear,
        rightNextYear,
        rightPrevYear,
        t,
        leftDate,
        rightDate,
        hasShortcuts,
        handleShortcutClick
      };
    }
  });
  const _hoisted_1$B = { class: "el-picker-panel__body-wrapper" };
  const _hoisted_2$n = {
    key: 0,
    class: "el-picker-panel__sidebar"
  };
  const _hoisted_3$c = ["onClick"];
  const _hoisted_4$8 = { class: "el-picker-panel__body" };
  const _hoisted_5$6 = { class: "el-picker-panel__content el-date-range-picker__content is-left" };
  const _hoisted_6$3 = { class: "el-date-range-picker__header" };
  const _hoisted_7$2 = ["disabled"];
  const _hoisted_8$2 = { class: "el-picker-panel__content el-date-range-picker__content is-right" };
  const _hoisted_9$2 = { class: "el-date-range-picker__header" };
  const _hoisted_10$2 = ["disabled"];
  function _sfc_render$10(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_d_arrow_left = vue.resolveComponent("d-arrow-left");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_d_arrow_right = vue.resolveComponent("d-arrow-right");
    const _component_month_table = vue.resolveComponent("month-table");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(["el-picker-panel el-date-range-picker", [
        {
          "has-sidebar": _ctx.$slots.sidebar || _ctx.hasShortcuts
        }
      ]])
    }, [
      vue.createElementVNode("div", _hoisted_1$B, [
        vue.renderSlot(_ctx.$slots, "sidebar", { class: "el-picker-panel__sidebar" }),
        _ctx.hasShortcuts ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_2$n, [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.shortcuts, (shortcut, key) => {
            return vue.openBlock(), vue.createElementBlock("button", {
              key,
              type: "button",
              class: "el-picker-panel__shortcut",
              onClick: ($event) => _ctx.handleShortcutClick(shortcut)
            }, vue.toDisplayString(shortcut.text), 9, _hoisted_3$c);
          }), 128))
        ])) : vue.createCommentVNode("v-if", true),
        vue.createElementVNode("div", _hoisted_4$8, [
          vue.createElementVNode("div", _hoisted_5$6, [
            vue.createElementVNode("div", _hoisted_6$3, [
              vue.createElementVNode("button", {
                type: "button",
                class: "el-picker-panel__icon-btn d-arrow-left",
                onClick: _cache[0] || (_cache[0] = (...args) => _ctx.leftPrevYear && _ctx.leftPrevYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_left)
                  ]),
                  _: 1
                })
              ]),
              _ctx.unlinkPanels ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 0,
                type: "button",
                disabled: !_ctx.enableYearArrow,
                class: vue.normalizeClass([{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn d-arrow-right"]),
                onClick: _cache[1] || (_cache[1] = (...args) => _ctx.leftNextYear && _ctx.leftNextYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_right)
                  ]),
                  _: 1
                })
              ], 10, _hoisted_7$2)) : vue.createCommentVNode("v-if", true),
              vue.createElementVNode("div", null, vue.toDisplayString(_ctx.leftLabel), 1)
            ]),
            vue.createVNode(_component_month_table, {
              "selection-mode": "range",
              date: _ctx.leftDate,
              "min-date": _ctx.minDate,
              "max-date": _ctx.maxDate,
              "range-state": _ctx.rangeState,
              "disabled-date": _ctx.disabledDate,
              onChangerange: _ctx.handleChangeRange,
              onPick: _ctx.handleRangePick,
              onSelect: _ctx.onSelect
            }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "onChangerange", "onPick", "onSelect"])
          ]),
          vue.createElementVNode("div", _hoisted_8$2, [
            vue.createElementVNode("div", _hoisted_9$2, [
              _ctx.unlinkPanels ? (vue.openBlock(), vue.createElementBlock("button", {
                key: 0,
                type: "button",
                disabled: !_ctx.enableYearArrow,
                class: vue.normalizeClass([{ "is-disabled": !_ctx.enableYearArrow }, "el-picker-panel__icon-btn d-arrow-left"]),
                onClick: _cache[2] || (_cache[2] = (...args) => _ctx.rightPrevYear && _ctx.rightPrevYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_left)
                  ]),
                  _: 1
                })
              ], 10, _hoisted_10$2)) : vue.createCommentVNode("v-if", true),
              vue.createElementVNode("button", {
                type: "button",
                class: "el-picker-panel__icon-btn d-arrow-right",
                onClick: _cache[3] || (_cache[3] = (...args) => _ctx.rightNextYear && _ctx.rightNextYear(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_d_arrow_right)
                  ]),
                  _: 1
                })
              ]),
              vue.createElementVNode("div", null, vue.toDisplayString(_ctx.rightLabel), 1)
            ]),
            vue.createVNode(_component_month_table, {
              "selection-mode": "range",
              date: _ctx.rightDate,
              "min-date": _ctx.minDate,
              "max-date": _ctx.maxDate,
              "range-state": _ctx.rangeState,
              "disabled-date": _ctx.disabledDate,
              onChangerange: _ctx.handleChangeRange,
              onPick: _ctx.handleRangePick,
              onSelect: _ctx.onSelect
            }, null, 8, ["date", "min-date", "max-date", "range-state", "disabled-date", "onChangerange", "onPick", "onSelect"])
          ])
        ])
      ])
    ], 2);
  }
  var MonthRangePickPanel = /* @__PURE__ */ _export_sfc(_sfc_main$1d, [["render", _sfc_render$10]]);

  dayjs.extend(localeData);
  dayjs.extend(advancedFormat);
  dayjs.extend(customParseFormat);
  dayjs.extend(weekOfYear);
  dayjs.extend(weekYear);
  dayjs.extend(dayOfYear);
  dayjs.extend(isSameOrAfter);
  dayjs.extend(isSameOrBefore);
  const getPanel = function(type) {
    if (type === "daterange" || type === "datetimerange") {
      return DateRangePickPanel;
    } else if (type === "monthrange") {
      return MonthRangePickPanel;
    }
    return DatePickPanel;
  };
  var DatePicker = vue.defineComponent({
    name: "ElDatePicker",
    install: null,
    props: {
      ...timePickerDefaultProps,
      type: {
        type: String,
        default: "date"
      }
    },
    emits: ["update:modelValue"],
    setup(props, ctx) {
      vue.provide("ElPopperOptions", props.popperOptions);
      vue.provide(ROOT_PICKER_INJECTION_KEY, {
        ctx
      });
      const commonPicker = vue.ref(null);
      const refProps = {
        ...props,
        focus: (focusStartInput = true) => {
          var _a;
          (_a = commonPicker.value) == null ? void 0 : _a.focus(focusStartInput);
        }
      };
      ctx.expose(refProps);
      return () => {
        var _a;
        const format = (_a = props.format) != null ? _a : DEFAULT_FORMATS_DATEPICKER[props.type] || DEFAULT_FORMATS_DATE;
        return vue.h(CommonPicker, {
          ...props,
          format,
          type: props.type,
          ref: commonPicker,
          "onUpdate:modelValue": (value) => ctx.emit("update:modelValue", value)
        }, {
          default: (scopedProps) => vue.h(getPanel(props.type), scopedProps),
          "range-separator": () => vue.renderSlot(ctx.slots, "range-separator")
        });
      };
    }
  });

  const _DatePicker = DatePicker;
  _DatePicker.install = (app) => {
    app.component(_DatePicker.name, _DatePicker);
  };
  const ElDatePicker = _DatePicker;

  const elDescriptionsKey = "elDescriptions";

  var DescriptionsCell = vue.defineComponent({
    name: "ElDescriptionsCell",
    props: {
      cell: {
        type: Object
      },
      tag: {
        type: String
      },
      type: {
        type: String
      }
    },
    setup() {
      const descriptions = vue.inject(elDescriptionsKey, {});
      return {
        descriptions
      };
    },
    render() {
      var _a, _b, _c, _d, _e, _f;
      const item = getNormalizedProps(this.cell);
      const { border, direction } = this.descriptions;
      const isVertical = direction === "vertical";
      const label = ((_c = (_b = (_a = this.cell) == null ? void 0 : _a.children) == null ? void 0 : _b.label) == null ? void 0 : _c.call(_b)) || item.label;
      const content = (_f = (_e = (_d = this.cell) == null ? void 0 : _d.children) == null ? void 0 : _e.default) == null ? void 0 : _f.call(_e);
      const span = item.span;
      const align = item.align ? `is-${item.align}` : "";
      const labelAlign = item.labelAlign ? `is-${item.labelAlign}` : align;
      const className = item.className;
      const labelClassName = item.labelClassName;
      const style = {
        width: addUnit(item.width),
        minWidth: addUnit(item.minWidth)
      };
      const ns = useNamespace("descriptions");
      switch (this.type) {
        case "label":
          return vue.h(this.tag, {
            style,
            class: [
              ns.e("cell"),
              ns.e("label"),
              ns.is("bordered-label", border),
              ns.is("vertical-label", isVertical),
              labelAlign,
              labelClassName
            ],
            colSpan: isVertical ? span : 1
          }, label);
        case "content":
          return vue.h(this.tag, {
            style,
            class: [
              ns.e("cell"),
              ns.e("content"),
              ns.is("bordered-content", border),
              ns.is("vertical-content", isVertical),
              align,
              className
            ],
            colSpan: isVertical ? span : span * 2 - 1
          }, content);
        default:
          return vue.h("td", {
            style,
            class: [ns.e("cell"), align],
            colSpan: span
          }, [
            vue.h("span", {
              class: [ns.e("label"), labelClassName]
            }, label),
            vue.h("span", {
              class: [ns.e("content"), className]
            }, content)
          ]);
      }
    }
  });

  const _sfc_main$1c = vue.defineComponent({
    name: "ElDescriptionsRow",
    components: {
      [DescriptionsCell.name]: DescriptionsCell
    },
    props: {
      row: {
        type: Array
      }
    },
    setup() {
      const descriptions = vue.inject(elDescriptionsKey, {});
      return {
        descriptions
      };
    }
  });
  const _hoisted_1$A = { key: 1 };
  function _sfc_render$$(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_descriptions_cell = vue.resolveComponent("el-descriptions-cell");
    return _ctx.descriptions.direction === "vertical" ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
      vue.createElementVNode("tr", null, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.row, (cell, index) => {
          return vue.openBlock(), vue.createBlock(_component_el_descriptions_cell, {
            key: `tr1-${index}`,
            cell,
            tag: "th",
            type: "label"
          }, null, 8, ["cell"]);
        }), 128))
      ]),
      vue.createElementVNode("tr", null, [
        (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.row, (cell, index) => {
          return vue.openBlock(), vue.createBlock(_component_el_descriptions_cell, {
            key: `tr2-${index}`,
            cell,
            tag: "td",
            type: "content"
          }, null, 8, ["cell"]);
        }), 128))
      ])
    ], 64)) : (vue.openBlock(), vue.createElementBlock("tr", _hoisted_1$A, [
      (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.row, (cell, index) => {
        return vue.openBlock(), vue.createElementBlock(vue.Fragment, {
          key: `tr3-${index}`
        }, [
          _ctx.descriptions.border ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
            vue.createVNode(_component_el_descriptions_cell, {
              cell,
              tag: "td",
              type: "label"
            }, null, 8, ["cell"]),
            vue.createVNode(_component_el_descriptions_cell, {
              cell,
              tag: "td",
              type: "content"
            }, null, 8, ["cell"])
          ], 64)) : (vue.openBlock(), vue.createBlock(_component_el_descriptions_cell, {
            key: 1,
            cell,
            tag: "td",
            type: "both"
          }, null, 8, ["cell"]))
        ], 64);
      }), 128))
    ]));
  }
  var DescriptionsRow = /* @__PURE__ */ _export_sfc(_sfc_main$1c, [["render", _sfc_render$$]]);

  const _sfc_main$1b = vue.defineComponent({
    name: "ElDescriptions",
    components: {
      [DescriptionsRow.name]: DescriptionsRow
    },
    props: {
      border: {
        type: Boolean,
        default: false
      },
      column: {
        type: Number,
        default: 3
      },
      direction: {
        type: String,
        default: "horizontal"
      },
      size: {
        type: String,
        validator: isValidComponentSize
      },
      title: {
        type: String,
        default: ""
      },
      extra: {
        type: String,
        default: ""
      }
    },
    setup(props, { slots }) {
      vue.provide(elDescriptionsKey, props);
      const descriptionsSize = useSize();
      const ns = useNamespace("descriptions");
      const descriptionKls = vue.computed(() => [
        ns.b(),
        ns.is(ns.m(descriptionsSize.value), !!descriptionsSize.value)
      ]);
      const flattedChildren = (children) => {
        const temp = Array.isArray(children) ? children : [children];
        const res = [];
        temp.forEach((child) => {
          if (Array.isArray(child.children)) {
            res.push(...flattedChildren(child.children));
          } else {
            res.push(child);
          }
        });
        return res;
      };
      const filledNode = (node, span, count, isLast = false) => {
        if (!node.props) {
          node.props = {};
        }
        if (span > count) {
          node.props.span = count;
        }
        if (isLast) {
          node.props.span = span;
        }
        return node;
      };
      const getRows = () => {
        var _a;
        const children = flattedChildren((_a = slots.default) == null ? void 0 : _a.call(slots)).filter((node) => {
          var _a2;
          return ((_a2 = node == null ? void 0 : node.type) == null ? void 0 : _a2.name) === "ElDescriptionsItem";
        });
        const rows = [];
        let temp = [];
        let count = props.column;
        let totalSpan = 0;
        children.forEach((node, index) => {
          var _a2;
          const span = ((_a2 = node.props) == null ? void 0 : _a2.span) || 1;
          if (index < children.length - 1) {
            totalSpan += span > count ? count : span;
          }
          if (index === children.length - 1) {
            const lastSpan = props.column - totalSpan % props.column;
            temp.push(filledNode(node, lastSpan, count, true));
            rows.push(temp);
            return;
          }
          if (span < count) {
            count -= span;
            temp.push(node);
          } else {
            temp.push(filledNode(node, span, count));
            rows.push(temp);
            count = props.column;
            temp = [];
          }
        });
        return rows;
      };
      return {
        descriptionKls,
        getRows,
        ns
      };
    }
  });
  function _sfc_render$_(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_descriptions_row = vue.resolveComponent("el-descriptions-row");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(_ctx.descriptionKls)
    }, [
      _ctx.title || _ctx.extra || _ctx.$slots.title || _ctx.$slots.extra ? (vue.openBlock(), vue.createElementBlock("div", {
        key: 0,
        class: vue.normalizeClass(_ctx.ns.e("header"))
      }, [
        vue.createElementVNode("div", {
          class: vue.normalizeClass(_ctx.ns.e("title"))
        }, [
          vue.renderSlot(_ctx.$slots, "title", {}, () => [
            vue.createTextVNode(vue.toDisplayString(_ctx.title), 1)
          ])
        ], 2),
        vue.createElementVNode("div", {
          class: vue.normalizeClass(_ctx.ns.e("extra"))
        }, [
          vue.renderSlot(_ctx.$slots, "extra", {}, () => [
            vue.createTextVNode(vue.toDisplayString(_ctx.extra), 1)
          ])
        ], 2)
      ], 2)) : vue.createCommentVNode("v-if", true),
      vue.createElementVNode("div", {
        class: vue.normalizeClass(_ctx.ns.e("body"))
      }, [
        vue.createElementVNode("table", {
          class: vue.normalizeClass([_ctx.ns.e("table"), _ctx.ns.is("bordered", _ctx.border)])
        }, [
          vue.createElementVNode("tbody", null, [
            (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.getRows(), (row, index) => {
              return vue.openBlock(), vue.createBlock(_component_el_descriptions_row, {
                key: index,
                row
              }, null, 8, ["row"]);
            }), 128))
          ])
        ], 2)
      ], 2)
    ], 2);
  }
  var Descriptions = /* @__PURE__ */ _export_sfc(_sfc_main$1b, [["render", _sfc_render$_]]);

  var DescriptionsItem = vue.defineComponent({
    name: "ElDescriptionsItem",
    props: {
      label: {
        type: String,
        default: ""
      },
      span: {
        type: Number,
        default: 1
      },
      width: {
        type: [String, Number],
        default: ""
      },
      minWidth: {
        type: [String, Number],
        default: ""
      },
      align: {
        type: String,
        default: "left"
      },
      labelAlign: {
        type: String,
        default: ""
      },
      className: {
        type: String,
        default: ""
      },
      labelClassName: {
        type: String,
        default: ""
      }
    }
  });

  const ElDescriptions = withInstall(Descriptions, {
    DescriptionsItem
  });
  const ElDescriptionsItem = withNoopInstall(DescriptionsItem);

  const overlayProps = buildProps({
    mask: {
      type: Boolean,
      default: true
    },
    customMaskEvent: {
      type: Boolean,
      default: false
    },
    overlayClass: {
      type: definePropType([
        String,
        Array,
        Object
      ])
    },
    zIndex: {
      type: definePropType([String, Number])
    }
  });
  const overlayEmits = {
    click: (evt) => evt instanceof MouseEvent
  };
  var Overlay = vue.defineComponent({
    name: "ElOverlay",
    props: overlayProps,
    emits: overlayEmits,
    setup(props, { slots, emit }) {
      const ns = useNamespace("overlay");
      const onMaskClick = (e) => {
        emit("click", e);
      };
      const { onClick, onMousedown, onMouseup } = useSameTarget(props.customMaskEvent ? void 0 : onMaskClick);
      return () => {
        return props.mask ? vue.createVNode("div", {
          class: [ns.b(), props.overlayClass],
          style: {
            zIndex: props.zIndex
          },
          onClick,
          onMousedown,
          onMouseup
        }, [vue.renderSlot(slots, "default")], PatchFlags.STYLE | PatchFlags.CLASS | PatchFlags.PROPS, ["onClick", "onMouseup", "onMousedown"]) : vue.h("div", {
          class: props.overlayClass,
          style: {
            zIndex: props.zIndex,
            position: "fixed",
            top: "0px",
            right: "0px",
            bottom: "0px",
            left: "0px"
          }
        }, [vue.renderSlot(slots, "default")]);
      };
    }
  });

  const ElOverlay = Overlay;

  const dialogContentProps = buildProps({
    center: {
      type: Boolean,
      default: false
    },
    closeIcon: {
      type: iconPropType,
      default: ""
    },
    customClass: {
      type: String,
      default: ""
    },
    draggable: {
      type: Boolean,
      default: false
    },
    fullscreen: {
      type: Boolean,
      default: false
    },
    showClose: {
      type: Boolean,
      default: true
    },
    title: {
      type: String,
      default: ""
    }
  });
  const dialogContentEmits = {
    close: () => true
  };

  const _hoisted_1$z = ["aria-label"];
  const __default__$9 = { name: "ElDialogContent" };
  const _sfc_main$1a = /* @__PURE__ */ vue.defineComponent({
    ...__default__$9,
    props: dialogContentProps,
    emits: dialogContentEmits,
    setup(__props) {
      const { Close } = CloseComponents;
      const { dialogRef, headerRef, ns, style } = vue.inject(dialogInjectionKey);
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          ref_key: "dialogRef",
          ref: dialogRef,
          class: vue.normalizeClass([
            vue.unref(ns).b(),
            vue.unref(ns).is("fullscreen", _ctx.fullscreen),
            vue.unref(ns).is("draggable", _ctx.draggable),
            { [vue.unref(ns).m("center")]: _ctx.center },
            _ctx.customClass
          ]),
          "aria-modal": "true",
          role: "dialog",
          "aria-label": _ctx.title || "dialog",
          style: vue.normalizeStyle(vue.unref(style)),
          onClick: _cache[1] || (_cache[1] = vue.withModifiers(() => {
          }, ["stop"]))
        }, [
          vue.createElementVNode("div", {
            ref_key: "headerRef",
            ref: headerRef,
            class: vue.normalizeClass(vue.unref(ns).e("header"))
          }, [
            vue.renderSlot(_ctx.$slots, "title", {}, () => [
              vue.createElementVNode("span", {
                class: vue.normalizeClass(vue.unref(ns).e("title"))
              }, vue.toDisplayString(_ctx.title), 3)
            ])
          ], 2),
          vue.createElementVNode("div", {
            class: vue.normalizeClass(vue.unref(ns).e("body"))
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 2),
          _ctx.$slots.footer ? (vue.openBlock(), vue.createElementBlock("div", {
            key: 0,
            class: vue.normalizeClass(vue.unref(ns).e("footer"))
          }, [
            vue.renderSlot(_ctx.$slots, "footer")
          ], 2)) : vue.createCommentVNode("v-if", true),
          _ctx.showClose ? (vue.openBlock(), vue.createElementBlock("button", {
            key: 1,
            "aria-label": "close",
            class: vue.normalizeClass(vue.unref(ns).e("headerbtn")),
            type: "button",
            onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("close"))
          }, [
            vue.createVNode(vue.unref(ElIcon), {
              class: vue.normalizeClass(vue.unref(ns).e("close"))
            }, {
              default: vue.withCtx(() => [
                (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.closeIcon || vue.unref(Close))))
              ]),
              _: 1
            }, 8, ["class"])
          ], 2)) : vue.createCommentVNode("v-if", true)
        ], 14, _hoisted_1$z);
      };
    }
  });
  var ElDialogContent = _sfc_main$1a;

  const dialogProps = buildProps({
    ...dialogContentProps,
    appendToBody: {
      type: Boolean,
      default: false
    },
    beforeClose: {
      type: definePropType(Function)
    },
    destroyOnClose: {
      type: Boolean,
      default: false
    },
    closeOnClickModal: {
      type: Boolean,
      default: true
    },
    closeOnPressEscape: {
      type: Boolean,
      default: true
    },
    lockScroll: {
      type: Boolean,
      default: true
    },
    modal: {
      type: Boolean,
      default: true
    },
    openDelay: {
      type: Number,
      default: 0
    },
    closeDelay: {
      type: Number,
      default: 0
    },
    top: {
      type: String
    },
    modelValue: {
      type: Boolean,
      required: true
    },
    modalClass: String,
    width: {
      type: [String, Number]
    },
    zIndex: {
      type: Number
    },
    trapFocus: {
      type: Boolean,
      default: false
    }
  });
  const dialogEmits = {
    open: () => true,
    opened: () => true,
    close: () => true,
    closed: () => true,
    [UPDATE_MODEL_EVENT]: (value) => isBoolean(value),
    openAutoFocus: () => true,
    closeAutoFocus: () => true
  };

  const useDialog = (props, targetRef) => {
    const instance = vue.getCurrentInstance();
    const emit = instance.emit;
    const { nextZIndex } = useZIndex();
    let lastPosition = "";
    const visible = vue.ref(false);
    const closed = vue.ref(false);
    const rendered = vue.ref(false);
    const zIndex = vue.ref(props.zIndex || nextZIndex());
    let openTimer = void 0;
    let closeTimer = void 0;
    const normalizeWidth = vue.computed(() => isNumber(props.width) ? `${props.width}px` : props.width);
    const style = vue.computed(() => {
      const style2 = {};
      const varPrefix = `--el-dialog`;
      if (!props.fullscreen) {
        if (props.top) {
          style2[`${varPrefix}-margin-top`] = props.top;
        }
        if (props.width) {
          style2[`${varPrefix}-width`] = normalizeWidth.value;
        }
      }
      return style2;
    });
    function afterEnter() {
      emit("opened");
    }
    function afterLeave() {
      emit("closed");
      emit(UPDATE_MODEL_EVENT, false);
      if (props.destroyOnClose) {
        rendered.value = false;
      }
    }
    function beforeLeave() {
      emit("close");
    }
    function open() {
      closeTimer == null ? void 0 : closeTimer();
      openTimer == null ? void 0 : openTimer();
      if (props.openDelay && props.openDelay > 0) {
        ({ stop: openTimer } = useTimeoutFn(() => doOpen(), props.openDelay));
      } else {
        doOpen();
      }
    }
    function close() {
      openTimer == null ? void 0 : openTimer();
      closeTimer == null ? void 0 : closeTimer();
      if (props.closeDelay && props.closeDelay > 0) {
        ({ stop: closeTimer } = useTimeoutFn(() => doClose(), props.closeDelay));
      } else {
        doClose();
      }
    }
    function handleClose() {
      function hide(shouldCancel) {
        if (shouldCancel)
          return;
        closed.value = true;
        visible.value = false;
      }
      if (props.beforeClose) {
        props.beforeClose(hide);
      } else {
        close();
      }
    }
    function onModalClick() {
      if (props.closeOnClickModal) {
        handleClose();
      }
    }
    function doOpen() {
      if (!isClient)
        return;
      visible.value = true;
    }
    function doClose() {
      visible.value = false;
    }
    if (props.lockScroll) {
      useLockscreen(visible);
    }
    if (props.closeOnPressEscape) {
      useModal({
        handleClose
      }, visible);
    }
    useRestoreActive(visible);
    vue.watch(() => props.modelValue, (val) => {
      if (val) {
        closed.value = false;
        open();
        rendered.value = true;
        emit("open");
        zIndex.value = props.zIndex ? zIndex.value++ : nextZIndex();
        vue.nextTick(() => {
          if (targetRef.value) {
            targetRef.value.scrollTop = 0;
          }
        });
      } else {
        if (visible.value) {
          close();
        }
      }
    });
    vue.watch(() => props.fullscreen, (val) => {
      if (!targetRef.value)
        return;
      if (val) {
        lastPosition = targetRef.value.style.transform;
        targetRef.value.style.transform = "";
      } else {
        targetRef.value.style.transform = lastPosition;
      }
    });
    vue.onMounted(() => {
      if (props.modelValue) {
        visible.value = true;
        rendered.value = true;
        open();
      }
    });
    return {
      afterEnter,
      afterLeave,
      beforeLeave,
      handleClose,
      onModalClick,
      close,
      doClose,
      closed,
      style,
      rendered,
      visible,
      zIndex
    };
  };

  const __default__$8 = {
    name: "ElDialog"
  };
  const _sfc_main$19 = /* @__PURE__ */ vue.defineComponent({
    ...__default__$8,
    props: dialogProps,
    emits: dialogEmits,
    setup(__props, { expose }) {
      const props = __props;
      const ns = useNamespace("dialog");
      const dialogRef = vue.ref();
      const headerRef = vue.ref();
      const {
        visible,
        style,
        rendered,
        zIndex,
        afterEnter,
        afterLeave,
        beforeLeave,
        handleClose,
        onModalClick
      } = useDialog(props, dialogRef);
      vue.provide(dialogInjectionKey, {
        dialogRef,
        headerRef,
        ns,
        rendered,
        style
      });
      const overlayEvent = useSameTarget(onModalClick);
      const draggable = vue.computed(() => props.draggable && !props.fullscreen);
      useDraggable(dialogRef, headerRef, draggable);
      expose({
        visible
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createBlock(vue.Teleport, {
          to: "body",
          disabled: !_ctx.appendToBody
        }, [
          vue.createVNode(vue.Transition, {
            name: "dialog-fade",
            onAfterEnter: vue.unref(afterEnter),
            onAfterLeave: vue.unref(afterLeave),
            onBeforeLeave: vue.unref(beforeLeave)
          }, {
            default: vue.withCtx(() => [
              vue.withDirectives(vue.createVNode(vue.unref(ElOverlay), {
                "custom-mask-event": "",
                mask: _ctx.modal,
                "overlay-class": _ctx.modalClass,
                "z-index": vue.unref(zIndex)
              }, {
                default: vue.withCtx(() => [
                  vue.createElementVNode("div", {
                    class: vue.normalizeClass(`${vue.unref(ns).namespace.value}-overlay-dialog`),
                    onClick: _cache[0] || (_cache[0] = (...args) => vue.unref(overlayEvent).onClick && vue.unref(overlayEvent).onClick(...args)),
                    onMousedown: _cache[1] || (_cache[1] = (...args) => vue.unref(overlayEvent).onMousedown && vue.unref(overlayEvent).onMousedown(...args)),
                    onMouseup: _cache[2] || (_cache[2] = (...args) => vue.unref(overlayEvent).onMouseup && vue.unref(overlayEvent).onMouseup(...args))
                  }, [
                    vue.unref(rendered) ? (vue.openBlock(), vue.createBlock(ElDialogContent, {
                      key: 0,
                      "custom-class": _ctx.customClass,
                      center: _ctx.center,
                      "close-icon": _ctx.closeIcon,
                      draggable: vue.unref(draggable),
                      fullscreen: _ctx.fullscreen,
                      "show-close": _ctx.showClose,
                      style: vue.normalizeStyle(vue.unref(style)),
                      title: _ctx.title,
                      onClose: vue.unref(handleClose)
                    }, {
                      title: vue.withCtx(() => [
                        vue.renderSlot(_ctx.$slots, "title")
                      ]),
                      footer: vue.withCtx(() => [
                        vue.renderSlot(_ctx.$slots, "footer")
                      ]),
                      default: vue.withCtx(() => [
                        vue.renderSlot(_ctx.$slots, "default")
                      ]),
                      _: 3
                    }, 8, ["custom-class", "center", "close-icon", "draggable", "fullscreen", "show-close", "style", "title", "onClose"])) : vue.createCommentVNode("v-if", true)
                  ], 34)
                ]),
                _: 3
              }, 8, ["mask", "overlay-class", "z-index"]), [
                [vue.vShow, vue.unref(visible)]
              ])
            ]),
            _: 3
          }, 8, ["onAfterEnter", "onAfterLeave", "onBeforeLeave"])
        ], 8, ["disabled"]);
      };
    }
  });
  var Dialog = _sfc_main$19;

  const ElDialog = withInstall(Dialog);

  const dividerProps = buildProps({
    direction: {
      type: String,
      values: ["horizontal", "vertical"],
      default: "horizontal"
    },
    contentPosition: {
      type: String,
      values: ["left", "center", "right"],
      default: "center"
    },
    borderStyle: {
      type: definePropType(String),
      default: "solid"
    }
  });

  const _sfc_main$18 = vue.defineComponent({
    name: "ElDivider",
    props: dividerProps,
    setup(props) {
      const ns = useNamespace("divider");
      const dividerStyle = vue.computed(() => {
        return {
          "--el-border-style": props.borderStyle
        };
      });
      return {
        ns,
        dividerStyle
      };
    }
  });
  function _sfc_render$Z(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([_ctx.ns.b(), _ctx.ns.m(_ctx.direction)]),
      style: vue.normalizeStyle(_ctx.dividerStyle)
    }, [
      _ctx.$slots.default && _ctx.direction !== "vertical" ? (vue.openBlock(), vue.createElementBlock("div", {
        key: 0,
        class: vue.normalizeClass([_ctx.ns.e("text"), _ctx.ns.is(_ctx.contentPosition)])
      }, [
        vue.renderSlot(_ctx.$slots, "default")
      ], 2)) : vue.createCommentVNode("v-if", true)
    ], 6);
  }
  var Divider = /* @__PURE__ */ _export_sfc(_sfc_main$18, [["render", _sfc_render$Z]]);

  const ElDivider = withInstall(Divider);

  const drawerProps = buildProps({
    ...dialogProps,
    direction: {
      type: String,
      default: "rtl",
      values: ["ltr", "rtl", "ttb", "btt"]
    },
    size: {
      type: [String, Number],
      default: "30%"
    },
    withHeader: {
      type: Boolean,
      default: true
    },
    modalFade: {
      type: Boolean,
      default: true
    }
  });
  const drawerEmits = dialogEmits;

  const _sfc_main$17 = vue.defineComponent({
    name: "ElDrawer",
    components: {
      ElOverlay,
      ElIcon,
      Close: close$2
    },
    directives: {
      TrapFocus
    },
    props: drawerProps,
    emits: drawerEmits,
    setup(props, ctx) {
      const drawerRef = vue.ref();
      const ns = useNamespace("drawer");
      const isHorizontal = vue.computed(() => props.direction === "rtl" || props.direction === "ltr");
      const drawerSize = vue.computed(() => typeof props.size === "number" ? `${props.size}px` : props.size);
      return {
        ...useDialog(props, ctx),
        drawerRef,
        isHorizontal,
        drawerSize,
        ns
      };
    }
  });
  const _hoisted_1$y = ["aria-labelledby", "aria-label"];
  const _hoisted_2$m = ["id"];
  const _hoisted_3$b = ["title"];
  const _hoisted_4$7 = ["aria-label"];
  function _sfc_render$Y(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_close = vue.resolveComponent("close");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_el_overlay = vue.resolveComponent("el-overlay");
    const _directive_trap_focus = vue.resolveDirective("trap-focus");
    return vue.openBlock(), vue.createBlock(vue.Teleport, {
      to: "body",
      disabled: !_ctx.appendToBody
    }, [
      vue.createVNode(vue.Transition, {
        name: _ctx.ns.b("fade"),
        onAfterEnter: _ctx.afterEnter,
        onAfterLeave: _ctx.afterLeave,
        onBeforeLeave: _ctx.beforeLeave
      }, {
        default: vue.withCtx(() => [
          vue.withDirectives(vue.createVNode(_component_el_overlay, {
            mask: _ctx.modal,
            "overlay-class": _ctx.modalClass,
            "z-index": _ctx.zIndex,
            onClick: _ctx.onModalClick
          }, {
            default: vue.withCtx(() => [
              vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
                ref: "drawerRef",
                "aria-modal": "true",
                "aria-labelledby": _ctx.ns.e("title"),
                "aria-label": _ctx.title,
                class: vue.normalizeClass([_ctx.ns.b(), _ctx.direction, _ctx.visible && "open", _ctx.customClass]),
                style: vue.normalizeStyle(_ctx.isHorizontal ? "width: " + _ctx.drawerSize : "height: " + _ctx.drawerSize),
                role: "dialog",
                onClick: _cache[1] || (_cache[1] = vue.withModifiers(() => {
                }, ["stop"]))
              }, [
                _ctx.withHeader ? (vue.openBlock(), vue.createElementBlock("header", {
                  key: 0,
                  id: _ctx.ns.e("title"),
                  class: vue.normalizeClass(_ctx.ns.e("header"))
                }, [
                  vue.renderSlot(_ctx.$slots, "title", {}, () => [
                    vue.createElementVNode("span", {
                      role: "heading",
                      title: _ctx.title
                    }, vue.toDisplayString(_ctx.title), 9, _hoisted_3$b)
                  ]),
                  _ctx.showClose ? (vue.openBlock(), vue.createElementBlock("button", {
                    key: 0,
                    "aria-label": "close " + (_ctx.title || "drawer"),
                    class: vue.normalizeClass(_ctx.ns.e("close-btn")),
                    type: "button",
                    onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClose && _ctx.handleClose(...args))
                  }, [
                    vue.createVNode(_component_el_icon, {
                      class: vue.normalizeClass(_ctx.ns.e("close"))
                    }, {
                      default: vue.withCtx(() => [
                        vue.createVNode(_component_close)
                      ]),
                      _: 1
                    }, 8, ["class"])
                  ], 10, _hoisted_4$7)) : vue.createCommentVNode("v-if", true)
                ], 10, _hoisted_2$m)) : vue.createCommentVNode("v-if", true),
                _ctx.rendered ? (vue.openBlock(), vue.createElementBlock("section", {
                  key: 1,
                  class: vue.normalizeClass(_ctx.ns.e("body"))
                }, [
                  vue.renderSlot(_ctx.$slots, "default")
                ], 2)) : vue.createCommentVNode("v-if", true),
                _ctx.$slots.footer ? (vue.openBlock(), vue.createElementBlock("div", {
                  key: 2,
                  class: vue.normalizeClass(_ctx.ns.e("footer"))
                }, [
                  vue.renderSlot(_ctx.$slots, "footer")
                ], 2)) : vue.createCommentVNode("v-if", true)
              ], 14, _hoisted_1$y)), [
                [_directive_trap_focus]
              ])
            ]),
            _: 3
          }, 8, ["mask", "overlay-class", "z-index", "onClick"]), [
            [vue.vShow, _ctx.visible]
          ])
        ]),
        _: 3
      }, 8, ["name", "onAfterEnter", "onAfterLeave", "onBeforeLeave"])
    ], 8, ["disabled"]);
  }
  var Drawer = /* @__PURE__ */ _export_sfc(_sfc_main$17, [["render", _sfc_render$Y]]);

  const ElDrawer = withInstall(Drawer);

  const obtainAllFocusableElements = (element) => {
    const nodes = [];
    const walker = document.createTreeWalker(element, NodeFilter.SHOW_ELEMENT, {
      acceptNode: (node) => {
        const isHiddenInput = node.tagName === "INPUT" && node.type === "hidden";
        if (node.disabled || node.hidden || isHiddenInput)
          return NodeFilter.FILTER_SKIP;
        return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
      }
    });
    while (walker.nextNode())
      nodes.push(walker.currentNode);
    return nodes;
  };
  const getVisibleElement = (elements, container) => {
    for (const element of elements) {
      if (!isHidden(element, container))
        return element;
    }
  };
  const isHidden = (element, container) => {
    if (getComputedStyle(element).visibility === "hidden")
      return true;
    while (element) {
      if (container && element === container)
        return false;
      if (getComputedStyle(element).display === "none")
        return true;
      element = element.parentElement;
    }
    return false;
  };
  const getEdges = (container) => {
    const focusable = obtainAllFocusableElements(container);
    const first = getVisibleElement(focusable, container);
    const last = getVisibleElement(focusable.reverse(), container);
    return [first, last];
  };
  const isSelectable = (element) => {
    return element instanceof HTMLInputElement && "select" in element;
  };
  const tryFocus = (element, shouldSelect) => {
    if (element && element.focus) {
      const prevFocusedElement = document.activeElement;
      element.focus({ preventScroll: true });
      if (element !== prevFocusedElement && isSelectable(element) && shouldSelect) {
        element.select();
      }
    }
  };
  function removeFromStack(list, item) {
    const copy = [...list];
    const idx = list.indexOf(item);
    if (idx !== -1) {
      copy.splice(idx, 1);
    }
    return copy;
  }
  const createFocusableStack = () => {
    let stack = [];
    const push = (layer) => {
      const currentLayer = stack[0];
      if (currentLayer && layer !== currentLayer) {
        currentLayer.pause();
      }
      stack = removeFromStack(stack, layer);
      stack.unshift(layer);
    };
    const remove = (layer) => {
      var _a, _b;
      stack = removeFromStack(stack, layer);
      (_b = (_a = stack[0]) == null ? void 0 : _a.resume) == null ? void 0 : _b.call(_a);
    };
    return {
      push,
      remove
    };
  };
  const focusFirstDescendant = (elements, shouldSelect = false) => {
    const prevFocusedElement = document.activeElement;
    for (const element of elements) {
      tryFocus(element, shouldSelect);
      if (document.activeElement !== prevFocusedElement)
        return;
    }
  };
  const focusableStack = createFocusableStack();

  const FOCUS_ON_MOUNT = "focus-trap.focus-on-mount";
  const FOCUS_ON_UNMOUNT = "focus-trap.focus-on-unmount";
  const FOCUS_ON_MOUNT_OPTS = {
    cancelable: true,
    bubbles: false
  };
  const ON_MOUNT_FOCUS_EVT = "mountOnFocus";
  const ON_UNMOUNT_FOCUS_EVT = "unmountOnFocus";
  const FOCUS_TRAP_INJECTION_KEY = Symbol("elFocusTrap");

  const _sfc_main$16 = vue.defineComponent({
    name: "ElFocusTrap",
    inheritAttrs: false,
    props: {
      loop: Boolean,
      trapped: Boolean
    },
    emits: [ON_MOUNT_FOCUS_EVT, ON_UNMOUNT_FOCUS_EVT],
    setup(props, { emit }) {
      const focusTrapRef = vue.ref();
      const forwardRef = vue.ref(null);
      let lastFocusBeforeMounted;
      let lastFocusAfterMounted;
      const focusLayer = {
        paused: false,
        pause() {
          this.paused = true;
        },
        resume() {
          this.paused = false;
        }
      };
      const onKeydown = (e) => {
        if (!props.loop && !props.trapped)
          return;
        if (focusLayer.paused)
          return;
        const { key, altKey, ctrlKey, metaKey, currentTarget, shiftKey } = e;
        const { loop } = props;
        const isTabbing = key === EVENT_CODE.tab && !altKey && !ctrlKey && !metaKey;
        const currentFocusingEl = document.activeElement;
        if (isTabbing && currentFocusingEl) {
          const container = currentTarget;
          const [first, last] = getEdges(container);
          const isTabbable = first && last;
          if (!isTabbable) {
            if (currentFocusingEl === container)
              e.preventDefault();
          } else {
            if (!shiftKey && currentFocusingEl === last) {
              e.preventDefault();
              if (loop)
                tryFocus(first, true);
            } else if (shiftKey && currentFocusingEl === first) {
              e.preventDefault();
              if (loop)
                tryFocus(last, true);
            }
          }
        }
      };
      vue.provide(FOCUS_TRAP_INJECTION_KEY, {
        focusTrapRef: forwardRef,
        onKeydown
      });
      const focusOnMount = (e) => {
        emit(ON_MOUNT_FOCUS_EVT, e);
      };
      const focusOnUnmount = (e) => emit(ON_UNMOUNT_FOCUS_EVT, e);
      const onFocusIn = (e) => {
        const trapContainer = vue.unref(forwardRef);
        if (focusLayer.paused || !trapContainer)
          return;
        const target = e.target;
        if (target && trapContainer.contains(target)) {
          lastFocusAfterMounted = target;
        } else {
          tryFocus(lastFocusAfterMounted, true);
        }
      };
      const onFocusOut = (e) => {
        const trapContainer = vue.unref(forwardRef);
        if (focusLayer.paused || !trapContainer)
          return;
        if (!trapContainer.contains(e.relatedTarget)) {
          tryFocus(lastFocusAfterMounted, true);
        }
      };
      const cleanupDocumentListeners = () => {
        document.removeEventListener("focusin", onFocusIn);
        document.removeEventListener("focusout", onFocusOut);
      };
      vue.onMounted(() => {
        const trapContainer = vue.unref(forwardRef);
        if (trapContainer) {
          focusableStack.push(focusLayer);
          const prevFocusedElement = document.activeElement;
          lastFocusBeforeMounted = prevFocusedElement;
          const isPrevFocusContained = trapContainer.contains(prevFocusedElement);
          if (!isPrevFocusContained) {
            const mountEvent = new Event(FOCUS_ON_MOUNT, FOCUS_ON_MOUNT_OPTS);
            trapContainer.addEventListener(FOCUS_ON_MOUNT, focusOnMount);
            trapContainer.dispatchEvent(mountEvent);
            if (!mountEvent.defaultPrevented) {
              vue.nextTick(() => {
                focusFirstDescendant(obtainAllFocusableElements(trapContainer), true);
                if (document.activeElement === prevFocusedElement) {
                  tryFocus(trapContainer);
                }
              });
            }
          }
        }
        vue.watch(() => props.trapped, (trapped) => {
          if (trapped) {
            document.addEventListener("focusin", onFocusIn);
            document.addEventListener("focusout", onFocusOut);
          } else {
            cleanupDocumentListeners();
          }
        }, { immediate: true });
      });
      vue.onBeforeUnmount(() => {
        cleanupDocumentListeners();
        const trapContainer = vue.unref(forwardRef);
        if (trapContainer) {
          trapContainer.removeEventListener(FOCUS_ON_MOUNT, focusOnMount);
          const unmountEvent = new Event(FOCUS_ON_UNMOUNT, FOCUS_ON_MOUNT_OPTS);
          trapContainer.addEventListener(FOCUS_ON_UNMOUNT, focusOnUnmount);
          trapContainer.dispatchEvent(unmountEvent);
          if (!unmountEvent.defaultPrevented) {
            tryFocus(lastFocusBeforeMounted != null ? lastFocusBeforeMounted : document.body, true);
          }
          trapContainer.removeEventListener(FOCUS_ON_UNMOUNT, focusOnMount);
          focusableStack.remove(focusLayer);
        }
      });
      return {
        focusTrapRef,
        forwardRef,
        onKeydown
      };
    }
  });
  function _sfc_render$X(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.renderSlot(_ctx.$slots, "default");
  }
  var ElFocusTrap = /* @__PURE__ */ _export_sfc(_sfc_main$16, [["render", _sfc_render$X]]);

  const _sfc_main$15 = vue.defineComponent({
    inheritAttrs: false
  });
  function _sfc_render$W(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.renderSlot(_ctx.$slots, "default");
  }
  var Collection = /* @__PURE__ */ _export_sfc(_sfc_main$15, [["render", _sfc_render$W]]);

  const _sfc_main$14 = vue.defineComponent({
    name: "ElCollectionItem",
    inheritAttrs: false
  });
  function _sfc_render$V(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.renderSlot(_ctx.$slots, "default");
  }
  var CollectionItem = /* @__PURE__ */ _export_sfc(_sfc_main$14, [["render", _sfc_render$V]]);

  const COLLECTION_ITEM_SIGN = `data-el-collection-item`;
  const createCollectionWithScope = (name) => {
    const COLLECTION_NAME = `El${name}Collection`;
    const COLLECTION_ITEM_NAME = `${COLLECTION_NAME}Item`;
    const COLLECTION_INJECTION_KEY = Symbol(COLLECTION_NAME);
    const COLLECTION_ITEM_INJECTION_KEY = Symbol(COLLECTION_ITEM_NAME);
    const ElCollection = {
      ...Collection,
      name: COLLECTION_NAME,
      setup() {
        const collectionRef = vue.ref(null);
        const itemMap = /* @__PURE__ */ new Map();
        const getItems = () => {
          const collectionEl = vue.unref(collectionRef);
          if (!collectionEl)
            return [];
          const orderedNodes = Array.from(collectionEl.querySelectorAll(`[${COLLECTION_ITEM_SIGN}]`));
          const items = [...itemMap.values()];
          const orderedItems = items.sort((a, b) => orderedNodes.indexOf(a.ref) - orderedNodes.indexOf(b.ref));
          return orderedItems;
        };
        vue.provide(COLLECTION_INJECTION_KEY, {
          itemMap,
          getItems,
          collectionRef
        });
      }
    };
    const ElCollectionItem = {
      ...CollectionItem,
      name: COLLECTION_ITEM_NAME,
      setup(_, { attrs }) {
        const collectionItemRef = vue.ref(null);
        const collectionInjection = vue.inject(COLLECTION_INJECTION_KEY, void 0);
        vue.provide(COLLECTION_ITEM_INJECTION_KEY, {
          collectionItemRef
        });
        vue.onMounted(() => {
          const collectionItemEl = vue.unref(collectionItemRef);
          if (collectionItemEl) {
            collectionInjection.itemMap.set(collectionItemEl, {
              ref: collectionItemEl,
              ...attrs
            });
          }
        });
        vue.onBeforeUnmount(() => {
          const collectionItemEl = vue.unref(collectionItemRef);
          collectionInjection.itemMap.delete(collectionItemEl);
        });
      }
    };
    return {
      COLLECTION_INJECTION_KEY,
      COLLECTION_ITEM_INJECTION_KEY,
      ElCollection,
      ElCollectionItem
    };
  };

  const rovingFocusGroupProps = buildProps({
    style: { type: definePropType([String, Array, Object]) },
    currentTabId: {
      type: definePropType(String)
    },
    defaultCurrentTabId: String,
    loop: Boolean,
    dir: {
      type: String,
      values: ["ltr", "rtl"],
      default: "ltr"
    },
    orientation: {
      type: definePropType(String)
    },
    onBlur: Function,
    onFocus: Function,
    onMousedown: Function
  });
  const {
    ElCollection: ElCollection$1,
    ElCollectionItem: ElCollectionItem$1,
    COLLECTION_INJECTION_KEY: COLLECTION_INJECTION_KEY$1,
    COLLECTION_ITEM_INJECTION_KEY: COLLECTION_ITEM_INJECTION_KEY$1
  } = createCollectionWithScope("RovingFocusGroup");

  const ROVING_FOCUS_GROUP_INJECTION_KEY = Symbol("elRovingFocusGroup");
  const ROVING_FOCUS_GROUP_ITEM_INJECTION_KEY = Symbol("elRovingFocusGroupItem");

  const MAP_KEY_TO_FOCUS_INTENT = {
    ArrowLeft: "prev",
    ArrowUp: "prev",
    ArrowRight: "next",
    ArrowDown: "next",
    PageUp: "first",
    Home: "first",
    PageDown: "last",
    End: "last"
  };
  const getDirectionAwareKey = (key, dir) => {
    if (dir !== "rtl")
      return key;
    switch (key) {
      case EVENT_CODE.right:
        return EVENT_CODE.left;
      case EVENT_CODE.left:
        return EVENT_CODE.right;
      default:
        return key;
    }
  };
  const getFocusIntent = (event, orientation, dir) => {
    const key = getDirectionAwareKey(event.key, dir);
    if (orientation === "vertical" && [EVENT_CODE.left, EVENT_CODE.right].includes(key))
      return void 0;
    if (orientation === "horizontal" && [EVENT_CODE.up, EVENT_CODE.down].includes(key))
      return void 0;
    return MAP_KEY_TO_FOCUS_INTENT[key];
  };
  const reorderArray = (array, atIdx) => {
    return array.map((_, idx) => array[(idx + atIdx) % array.length]);
  };
  const focusFirst = (elements) => {
    const { activeElement: prevActive } = document;
    for (const element of elements) {
      if (element === prevActive)
        return;
      element.focus();
      if (prevActive !== document.activeElement)
        return;
    }
  };

  const CURRENT_TAB_ID_CHANGE_EVT = "currentTabIdChange";
  const ENTRY_FOCUS_EVT = "rovingFocusGroup.entryFocus";
  const EVT_OPTS = { bubbles: false, cancelable: true };
  const _sfc_main$13 = vue.defineComponent({
    name: "ElRovingFocusGroupImpl",
    inheritAttrs: false,
    props: rovingFocusGroupProps,
    emits: [CURRENT_TAB_ID_CHANGE_EVT, "entryFocus"],
    setup(props, { emit }) {
      var _a;
      const currentTabbedId = vue.ref((_a = props.currentTabId || props.defaultCurrentTabId) != null ? _a : null);
      const isBackingOut = vue.ref(false);
      const isClickFocus = vue.ref(false);
      const rovingFocusGroupRef = vue.ref(null);
      const { getItems } = vue.inject(COLLECTION_INJECTION_KEY$1, void 0);
      const rovingFocusGroupRootStyle = vue.computed(() => {
        return [
          {
            outline: "none"
          },
          props.style
        ];
      });
      const onItemFocus = (tabbedId) => {
        emit(CURRENT_TAB_ID_CHANGE_EVT, tabbedId);
      };
      const onItemShiftTab = () => {
        isBackingOut.value = true;
      };
      const onMousedown = composeEventHandlers((e) => {
        var _a2;
        (_a2 = props.onMousedown) == null ? void 0 : _a2.call(props, e);
      }, () => {
        isClickFocus.value = true;
      });
      const onFocus = composeEventHandlers((e) => {
        var _a2;
        (_a2 = props.onFocus) == null ? void 0 : _a2.call(props, e);
      }, (e) => {
        const isKeyboardFocus = !vue.unref(isClickFocus);
        const { target, currentTarget } = e;
        if (target === currentTarget && isKeyboardFocus && !vue.unref(isBackingOut)) {
          const entryFocusEvt = new Event(ENTRY_FOCUS_EVT, EVT_OPTS);
          currentTarget == null ? void 0 : currentTarget.dispatchEvent(entryFocusEvt);
          if (!entryFocusEvt.defaultPrevented) {
            const items = getItems().filter((item) => item.focusable);
            const activeItem = items.find((item) => item.active);
            const currentItem = items.find((item) => item.id === vue.unref(currentTabbedId));
            const candidates = [activeItem, currentItem, ...items].filter(Boolean);
            const candidateNodes = candidates.map((item) => item.ref);
            focusFirst(candidateNodes);
          }
        }
        isClickFocus.value = false;
      });
      const onBlur = composeEventHandlers((e) => {
        var _a2;
        (_a2 = props.onBlur) == null ? void 0 : _a2.call(props, e);
      }, () => {
        isBackingOut.value = false;
      });
      const handleEntryFocus = (...args) => {
        emit("entryFocus", ...args);
      };
      vue.provide(ROVING_FOCUS_GROUP_INJECTION_KEY, {
        currentTabbedId: vue.readonly(currentTabbedId),
        loop: vue.toRef(props, "loop"),
        tabIndex: vue.computed(() => {
          return vue.unref(isBackingOut) ? -1 : 0;
        }),
        rovingFocusGroupRef,
        rovingFocusGroupRootStyle,
        orientation: vue.toRef(props, "orientation"),
        dir: vue.toRef(props, "dir"),
        onItemFocus,
        onItemShiftTab,
        onBlur,
        onFocus,
        onMousedown
      });
      vue.watch(() => props.currentTabId, (val) => {
        currentTabbedId.value = val != null ? val : null;
      });
      vue.onMounted(() => {
        const rovingFocusGroupEl = vue.unref(rovingFocusGroupRef);
        on(rovingFocusGroupEl, ENTRY_FOCUS_EVT, handleEntryFocus);
      });
      vue.onBeforeUnmount(() => {
        const rovingFocusGroupEl = vue.unref(rovingFocusGroupRef);
        off(rovingFocusGroupEl, ENTRY_FOCUS_EVT, handleEntryFocus);
      });
    }
  });
  function _sfc_render$U(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.renderSlot(_ctx.$slots, "default");
  }
  var ElRovingFocusGroupImpl = /* @__PURE__ */ _export_sfc(_sfc_main$13, [["render", _sfc_render$U]]);

  const _sfc_main$12 = vue.defineComponent({
    name: "ElRovingFocusGroup",
    components: {
      ElFocusGroupCollection: ElCollection$1,
      ElRovingFocusGroupImpl
    }
  });
  function _sfc_render$T(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_roving_focus_group_impl = vue.resolveComponent("el-roving-focus-group-impl");
    const _component_el_focus_group_collection = vue.resolveComponent("el-focus-group-collection");
    return vue.openBlock(), vue.createBlock(_component_el_focus_group_collection, null, {
      default: vue.withCtx(() => [
        vue.createVNode(_component_el_roving_focus_group_impl, vue.normalizeProps(vue.guardReactiveProps(_ctx.$attrs)), {
          default: vue.withCtx(() => [
            vue.renderSlot(_ctx.$slots, "default")
          ]),
          _: 3
        }, 16)
      ]),
      _: 3
    });
  }
  var ElRovingFocusGroup = /* @__PURE__ */ _export_sfc(_sfc_main$12, [["render", _sfc_render$T]]);

  const _sfc_main$11 = vue.defineComponent({
    components: {
      ElRovingFocusCollectionItem: ElCollectionItem$1
    },
    props: {
      focusable: {
        type: Boolean,
        default: true
      },
      active: {
        type: Boolean,
        default: false
      }
    },
    emits: ["mousedown", "focus", "keydown"],
    setup(props, { emit }) {
      const { currentTabbedId, loop, onItemFocus, onItemShiftTab } = vue.inject(ROVING_FOCUS_GROUP_INJECTION_KEY, void 0);
      const { getItems } = vue.inject(COLLECTION_INJECTION_KEY$1, void 0);
      const id = useId();
      const rovingFocusGroupItemRef = vue.ref(null);
      const handleMousedown = composeEventHandlers((e) => {
        emit("mousedown", e);
      }, (e) => {
        if (!props.focusable) {
          e.preventDefault();
        } else {
          onItemFocus(vue.unref(id));
        }
      });
      const handleFocus = composeEventHandlers((e) => {
        emit("focus", e);
      }, () => {
        onItemFocus(vue.unref(id));
      });
      const handleKeydown = composeEventHandlers((e) => {
        emit("keydown", e);
      }, (e) => {
        const { key, shiftKey, target, currentTarget } = e;
        if (key === EVENT_CODE.tab && shiftKey) {
          onItemShiftTab();
          return;
        }
        if (target !== currentTarget)
          return;
        const focusIntent = getFocusIntent(e);
        if (focusIntent) {
          e.preventDefault();
          const items = getItems().filter((item) => item.focusable);
          let elements = items.map((item) => item.ref);
          switch (focusIntent) {
            case "last": {
              elements.reverse();
              break;
            }
            case "prev":
            case "next": {
              if (focusIntent === "prev") {
                elements.reverse();
              }
              const currentIdx = elements.indexOf(currentTarget);
              elements = loop.value ? reorderArray(elements, currentIdx + 1) : elements.slice(currentIdx + 1);
              break;
            }
          }
          vue.nextTick(() => {
            focusFirst(elements);
          });
        }
      });
      const isCurrentTab = vue.computed(() => currentTabbedId.value === vue.unref(id));
      vue.provide(ROVING_FOCUS_GROUP_ITEM_INJECTION_KEY, {
        rovingFocusGroupItemRef,
        tabIndex: vue.computed(() => vue.unref(isCurrentTab) ? 0 : -1),
        handleMousedown,
        handleFocus,
        handleKeydown
      });
      return {
        id,
        handleKeydown,
        handleFocus,
        handleMousedown
      };
    }
  });
  function _sfc_render$S(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_roving_focus_collection_item = vue.resolveComponent("el-roving-focus-collection-item");
    return vue.openBlock(), vue.createBlock(_component_el_roving_focus_collection_item, {
      id: _ctx.id,
      focusable: _ctx.focusable,
      active: _ctx.active
    }, {
      default: vue.withCtx(() => [
        vue.renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 8, ["id", "focusable", "active"]);
  }
  var ElRovingFocusItem = /* @__PURE__ */ _export_sfc(_sfc_main$11, [["render", _sfc_render$S]]);

  const dropdownProps = buildProps({
    trigger: useTooltipTriggerProps.trigger,
    effect: {
      ...useTooltipContentProps.effect,
      default: "light"
    },
    type: {
      type: definePropType(String)
    },
    placement: {
      type: definePropType(String),
      default: "bottom"
    },
    popperOptions: {
      type: definePropType(Object),
      default: () => ({})
    },
    size: {
      type: String,
      default: ""
    },
    splitButton: Boolean,
    hideOnClick: {
      type: Boolean,
      default: true
    },
    loop: {
      type: Boolean
    },
    showTimeout: {
      type: Number,
      default: 150
    },
    hideTimeout: {
      type: Number,
      default: 150
    },
    tabindex: {
      type: definePropType([Number, String]),
      default: 0
    },
    maxHeight: {
      type: definePropType([Number, String]),
      default: ""
    },
    popperClass: {
      type: String,
      default: ""
    },
    disabled: {
      type: Boolean,
      default: false
    }
  });
  const dropdownItemProps = buildProps({
    command: {
      type: [Object, String, Number],
      default: () => ({})
    },
    disabled: Boolean,
    divided: Boolean,
    textValue: String,
    icon: {
      type: iconPropType
    }
  });
  const dropdownMenuProps = buildProps({
    onKeydown: { type: definePropType(Function) }
  });
  const FIRST_KEYS = [
    EVENT_CODE.down,
    EVENT_CODE.pageDown,
    EVENT_CODE.home
  ];
  const LAST_KEYS = [EVENT_CODE.up, EVENT_CODE.pageUp, EVENT_CODE.end];
  const FIRST_LAST_KEYS = [...FIRST_KEYS, ...LAST_KEYS];
  const {
    ElCollection,
    ElCollectionItem,
    COLLECTION_INJECTION_KEY,
    COLLECTION_ITEM_INJECTION_KEY
  } = createCollectionWithScope("Dropdown");

  const DROPDOWN_INJECTION_KEY = Symbol("elDropdown");

  const { ButtonGroup: ElButtonGroup } = ElButton;
  const _sfc_main$10 = vue.defineComponent({
    name: "ElDropdown",
    components: {
      ElButton,
      ElFocusTrap,
      ElButtonGroup,
      ElScrollbar,
      ElDropdownCollection: ElCollection,
      ElTooltip,
      ElRovingFocusGroup,
      ElIcon,
      ArrowDown: arrowDown
    },
    props: dropdownProps,
    emits: ["visible-change", "click", "command"],
    setup(props, { emit }) {
      const _instance = vue.getCurrentInstance();
      const ns = useNamespace("dropdown");
      const triggeringElementRef = vue.ref();
      const referenceElementRef = vue.ref();
      const popperRef = vue.ref(null);
      const contentRef = vue.ref(null);
      const scrollbar = vue.ref(null);
      const currentTabId = vue.ref(null);
      const isUsingKeyboard = vue.ref(false);
      const wrapStyle = vue.computed(() => ({
        maxHeight: addUnit(props.maxHeight)
      }));
      const dropdownTriggerKls = vue.computed(() => [ns.m(dropdownSize.value)]);
      function handleClick() {
        handleClose();
      }
      function handleClose() {
        var _a;
        (_a = popperRef.value) == null ? void 0 : _a.onClose();
      }
      function handleOpen() {
        var _a;
        (_a = popperRef.value) == null ? void 0 : _a.onOpen();
      }
      const dropdownSize = useSize();
      function commandHandler(...args) {
        emit("command", ...args);
      }
      function onItemEnter() {
      }
      function onItemLeave() {
        const contentEl = vue.unref(contentRef);
        contentEl == null ? void 0 : contentEl.focus();
        currentTabId.value = null;
      }
      function handleCurrentTabIdChange(id) {
        currentTabId.value = id;
      }
      function handleEntryFocus(e) {
        if (!isUsingKeyboard.value) {
          e.preventDefault();
          e.stopImmediatePropagation();
        }
      }
      vue.provide(DROPDOWN_INJECTION_KEY, {
        contentRef,
        isUsingKeyboard,
        onItemEnter,
        onItemLeave
      });
      vue.provide("elDropdown", {
        instance: _instance,
        dropdownSize,
        handleClick,
        commandHandler,
        trigger: vue.toRef(props, "trigger"),
        hideOnClick: vue.toRef(props, "hideOnClick")
      });
      const onMountOnFocus = (e) => {
        var _a, _b;
        e.preventDefault();
        (_b = (_a = contentRef.value) == null ? void 0 : _a.focus) == null ? void 0 : _b.call(_a, {
          preventScroll: true
        });
      };
      const handlerMainButtonClick = (event) => {
        emit("click", event);
      };
      return {
        ns,
        scrollbar,
        wrapStyle,
        dropdownTriggerKls,
        dropdownSize,
        currentTabId,
        handleCurrentTabIdChange,
        handlerMainButtonClick,
        handleEntryFocus,
        handleClose,
        handleOpen,
        onMountOnFocus,
        popperRef,
        triggeringElementRef,
        referenceElementRef
      };
    }
  });
  function _sfc_render$R(_ctx, _cache, $props, $setup, $data, $options) {
    var _a;
    const _component_el_dropdown_collection = vue.resolveComponent("el-dropdown-collection");
    const _component_el_roving_focus_group = vue.resolveComponent("el-roving-focus-group");
    const _component_el_focus_trap = vue.resolveComponent("el-focus-trap");
    const _component_el_scrollbar = vue.resolveComponent("el-scrollbar");
    const _component_el_tooltip = vue.resolveComponent("el-tooltip");
    const _component_el_button = vue.resolveComponent("el-button");
    const _component_arrow_down = vue.resolveComponent("arrow-down");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_el_button_group = vue.resolveComponent("el-button-group");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([_ctx.ns.b(), _ctx.ns.is("disabled", _ctx.disabled)])
    }, [
      vue.createVNode(_component_el_tooltip, {
        ref: "popperRef",
        effect: _ctx.effect,
        "fallback-placements": ["bottom", "top"],
        "popper-options": _ctx.popperOptions,
        "gpu-acceleration": false,
        "hide-after": _ctx.hideTimeout,
        "manual-mode": true,
        placement: _ctx.placement,
        "popper-class": [_ctx.ns.e("popper"), _ctx.popperClass],
        "reference-element": (_a = _ctx.referenceElementRef) == null ? void 0 : _a.$el,
        trigger: _ctx.trigger,
        "show-after": _ctx.showTimeout,
        "stop-popper-mouse-event": false,
        "virtual-ref": _ctx.triggeringElementRef,
        "virtual-triggering": _ctx.splitButton,
        disabled: _ctx.disabled,
        "append-to-body": "",
        pure: "",
        transition: `${_ctx.ns.namespace.value}-zoom-in-top`,
        persistent: "",
        onShow: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("visible-change", true)),
        onHide: _cache[1] || (_cache[1] = ($event) => _ctx.$emit("visible-change", false))
      }, vue.createSlots({
        content: vue.withCtx(() => [
          vue.createVNode(_component_el_scrollbar, {
            ref: "scrollbar",
            "wrap-style": _ctx.wrapStyle,
            tag: "div",
            "view-class": _ctx.ns.e("list")
          }, {
            default: vue.withCtx(() => [
              vue.createVNode(_component_el_focus_trap, {
                trapped: "",
                onMountOnFocus: _ctx.onMountOnFocus
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_el_roving_focus_group, {
                    loop: _ctx.loop,
                    "current-tab-id": _ctx.currentTabId,
                    orientation: "horizontal",
                    onCurrentTabIdChange: _ctx.handleCurrentTabIdChange,
                    onEntryFocus: _ctx.handleEntryFocus
                  }, {
                    default: vue.withCtx(() => [
                      vue.createVNode(_component_el_dropdown_collection, null, {
                        default: vue.withCtx(() => [
                          vue.renderSlot(_ctx.$slots, "dropdown")
                        ]),
                        _: 3
                      })
                    ]),
                    _: 3
                  }, 8, ["loop", "current-tab-id", "onCurrentTabIdChange", "onEntryFocus"])
                ]),
                _: 3
              }, 8, ["onMountOnFocus"])
            ]),
            _: 3
          }, 8, ["wrap-style", "view-class"])
        ]),
        _: 2
      }, [
        !_ctx.splitButton ? {
          name: "default",
          fn: vue.withCtx(() => [
            vue.createElementVNode("div", {
              class: vue.normalizeClass(_ctx.dropdownTriggerKls)
            }, [
              vue.renderSlot(_ctx.$slots, "default")
            ], 2)
          ])
        } : void 0
      ]), 1032, ["effect", "popper-options", "hide-after", "placement", "popper-class", "reference-element", "trigger", "show-after", "virtual-ref", "virtual-triggering", "disabled", "transition"]),
      _ctx.splitButton ? (vue.openBlock(), vue.createBlock(_component_el_button_group, { key: 0 }, {
        default: vue.withCtx(() => [
          vue.createVNode(_component_el_button, {
            ref: "referenceElementRef",
            size: _ctx.dropdownSize,
            type: _ctx.type,
            disabled: _ctx.disabled,
            onClick: _ctx.handlerMainButtonClick
          }, {
            default: vue.withCtx(() => [
              vue.renderSlot(_ctx.$slots, "default")
            ]),
            _: 3
          }, 8, ["size", "type", "disabled", "onClick"]),
          vue.createVNode(_component_el_button, {
            ref: "triggeringElementRef",
            size: _ctx.dropdownSize,
            type: _ctx.type,
            class: vue.normalizeClass(_ctx.ns.e("caret-button")),
            disabled: _ctx.disabled
          }, {
            default: vue.withCtx(() => [
              vue.createVNode(_component_el_icon, {
                class: vue.normalizeClass(_ctx.ns.e("icon"))
              }, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_arrow_down)
                ]),
                _: 1
              }, 8, ["class"])
            ]),
            _: 1
          }, 8, ["size", "type", "class", "disabled"])
        ]),
        _: 3
      })) : vue.createCommentVNode("v-if", true)
    ], 2);
  }
  var Dropdown = /* @__PURE__ */ _export_sfc(_sfc_main$10, [["render", _sfc_render$R]]);

  const _sfc_main$$ = vue.defineComponent({
    name: "DropdownItemImpl",
    components: {
      ElIcon
    },
    props: dropdownItemProps,
    emits: ["pointermove", "pointerleave", "click", "clickimpl"],
    setup(_, { emit }) {
      const ns = useNamespace("dropdown");
      const { collectionItemRef: dropdownCollectionItemRef } = vue.inject(COLLECTION_ITEM_INJECTION_KEY, void 0);
      const { collectionItemRef: rovingFocusCollectionItemRef } = vue.inject(COLLECTION_ITEM_INJECTION_KEY$1, void 0);
      const {
        rovingFocusGroupItemRef,
        tabIndex,
        handleFocus,
        handleKeydown: handleItemKeydown,
        handleMousedown
      } = vue.inject(ROVING_FOCUS_GROUP_ITEM_INJECTION_KEY, void 0);
      const itemRef = composeRefs(dropdownCollectionItemRef, rovingFocusCollectionItemRef, rovingFocusGroupItemRef);
      const handleKeydown = composeEventHandlers((e) => {
        const { code } = e;
        if (code === EVENT_CODE.enter || code === EVENT_CODE.space) {
          e.preventDefault();
          e.stopImmediatePropagation();
          emit("clickimpl", e);
          return true;
        }
      }, handleItemKeydown);
      return {
        ns,
        itemRef,
        dataset: {
          [COLLECTION_ITEM_SIGN]: ""
        },
        tabIndex,
        handleFocus,
        handleKeydown,
        handleMousedown
      };
    }
  });
  const _hoisted_1$x = ["aria-disabled", "tabindex"];
  function _sfc_render$Q(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_icon = vue.resolveComponent("el-icon");
    return vue.openBlock(), vue.createElementBlock(vue.Fragment, null, [
      _ctx.divided ? (vue.openBlock(), vue.createElementBlock("li", vue.mergeProps({
        key: 0,
        class: _ctx.ns.bem("menu", "item", "divided")
      }, _ctx.$attrs), null, 16)) : vue.createCommentVNode("v-if", true),
      vue.createElementVNode("li", vue.mergeProps({ ref: _ctx.itemRef }, { ..._ctx.dataset, ..._ctx.$attrs }, {
        "aria-disabled": _ctx.disabled,
        class: [_ctx.ns.be("menu", "item"), _ctx.ns.is("disabled", _ctx.disabled)],
        tabindex: _ctx.tabIndex,
        role: "menuitem",
        onClick: _cache[0] || (_cache[0] = (e) => _ctx.$emit("clickimpl", e)),
        onFocus: _cache[1] || (_cache[1] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
        onKeydown: _cache[2] || (_cache[2] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args)),
        onMousedown: _cache[3] || (_cache[3] = (...args) => _ctx.handleMousedown && _ctx.handleMousedown(...args)),
        onPointermove: _cache[4] || (_cache[4] = (e) => _ctx.$emit("pointermove", e)),
        onPointerleave: _cache[5] || (_cache[5] = (e) => _ctx.$emit("pointerleave", e))
      }), [
        _ctx.icon ? (vue.openBlock(), vue.createBlock(_component_el_icon, { key: 0 }, {
          default: vue.withCtx(() => [
            (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.icon)))
          ]),
          _: 1
        })) : vue.createCommentVNode("v-if", true),
        vue.renderSlot(_ctx.$slots, "default")
      ], 16, _hoisted_1$x)
    ], 64);
  }
  var ElDropdownItemImpl = /* @__PURE__ */ _export_sfc(_sfc_main$$, [["render", _sfc_render$Q]]);

  const useDropdown = () => {
    const elDropdown = vue.inject("elDropdown", {});
    const _elDropdownSize = vue.computed(() => elDropdown == null ? void 0 : elDropdown.dropdownSize);
    return {
      elDropdown,
      _elDropdownSize
    };
  };

  const _sfc_main$_ = vue.defineComponent({
    name: "ElDropdownItem",
    components: {
      ElDropdownCollectionItem: ElCollectionItem,
      ElRovingFocusItem,
      ElDropdownItemImpl
    },
    inheritAttrs: false,
    props: dropdownItemProps,
    emits: ["pointermove", "pointerleave", "click"],
    setup(props, { emit, attrs }) {
      const { elDropdown } = useDropdown();
      const _instance = vue.getCurrentInstance();
      const itemRef = vue.ref(null);
      const textContent = vue.computed(() => {
        var _a, _b;
        return (_b = (_a = vue.unref(itemRef)) == null ? void 0 : _a.textContent) != null ? _b : "";
      });
      const { onItemEnter, onItemLeave } = vue.inject(DROPDOWN_INJECTION_KEY, void 0);
      const handlePointerMove = composeEventHandlers((e) => {
        emit("pointermove", e);
        return e.defaultPrevented;
      }, whenMouse((e) => {
        var _a;
        if (props.disabled) {
          onItemLeave(e);
        } else {
          onItemEnter(e);
          if (!e.defaultPrevented) {
            (_a = e.currentTarget) == null ? void 0 : _a.focus();
          }
        }
      }));
      const handlePointerLeave = composeEventHandlers((e) => {
        emit("pointerleave", e);
        return e.defaultPrevented;
      }, whenMouse((e) => {
        onItemLeave(e);
      }));
      const handleClick = composeEventHandlers((e) => {
        emit("click", e);
        return e.defaultPrevented;
      }, (e) => {
        var _a, _b, _c;
        if (props.disabled) {
          e.stopImmediatePropagation();
          return;
        }
        if ((_a = elDropdown == null ? void 0 : elDropdown.hideOnClick) == null ? void 0 : _a.value) {
          (_b = elDropdown.handleClick) == null ? void 0 : _b.call(elDropdown);
        }
        (_c = elDropdown.commandHandler) == null ? void 0 : _c.call(elDropdown, props.command, _instance, e);
      });
      const propsAndAttrs = vue.computed(() => {
        return { ...props, ...attrs };
      });
      return {
        handleClick,
        handlePointerMove,
        handlePointerLeave,
        textContent,
        propsAndAttrs
      };
    }
  });
  function _sfc_render$P(_ctx, _cache, $props, $setup, $data, $options) {
    var _a;
    const _component_el_dropdown_item_impl = vue.resolveComponent("el-dropdown-item-impl");
    const _component_el_roving_focus_item = vue.resolveComponent("el-roving-focus-item");
    const _component_el_dropdown_collection_item = vue.resolveComponent("el-dropdown-collection-item");
    return vue.openBlock(), vue.createBlock(_component_el_dropdown_collection_item, {
      disabled: _ctx.disabled,
      "text-value": (_a = _ctx.textValue) != null ? _a : _ctx.textContent
    }, {
      default: vue.withCtx(() => [
        vue.createVNode(_component_el_roving_focus_item, {
          focusable: !_ctx.disabled
        }, {
          default: vue.withCtx(() => [
            vue.createVNode(_component_el_dropdown_item_impl, vue.mergeProps(_ctx.propsAndAttrs, {
              onPointerleave: _ctx.handlePointerLeave,
              onPointermove: _ctx.handlePointerMove,
              onClickimpl: _ctx.handleClick
            }), {
              default: vue.withCtx(() => [
                vue.renderSlot(_ctx.$slots, "default")
              ]),
              _: 3
            }, 16, ["onPointerleave", "onPointermove", "onClickimpl"])
          ]),
          _: 3
        }, 8, ["focusable"])
      ]),
      _: 3
    }, 8, ["disabled", "text-value"]);
  }
  var DropdownItem = /* @__PURE__ */ _export_sfc(_sfc_main$_, [["render", _sfc_render$P]]);

  const _sfc_main$Z = vue.defineComponent({
    name: "ElDropdownMenu",
    props: dropdownMenuProps,
    setup(props) {
      const ns = useNamespace("dropdown");
      const { _elDropdownSize } = useDropdown();
      const size = _elDropdownSize.value;
      const { focusTrapRef, onKeydown } = vue.inject(FOCUS_TRAP_INJECTION_KEY, void 0);
      const { contentRef } = vue.inject(DROPDOWN_INJECTION_KEY, void 0);
      const { collectionRef: dropdownCollectionRef, getItems } = vue.inject(COLLECTION_INJECTION_KEY, void 0);
      const {
        rovingFocusGroupRef,
        rovingFocusGroupRootStyle,
        tabIndex,
        onBlur,
        onFocus,
        onMousedown
      } = vue.inject(ROVING_FOCUS_GROUP_INJECTION_KEY, void 0);
      const { collectionRef: rovingFocusGroupCollectionRef } = vue.inject(COLLECTION_INJECTION_KEY$1, void 0);
      const dropdownKls = vue.computed(() => {
        return [ns.b("menu"), ns.bm("menu", size == null ? void 0 : size.value)];
      });
      const dropdownListWrapperRef = composeRefs(contentRef, dropdownCollectionRef, focusTrapRef, rovingFocusGroupRef, rovingFocusGroupCollectionRef);
      const composedKeydown = composeEventHandlers((e) => {
        var _a;
        (_a = props.onKeydown) == null ? void 0 : _a.call(props, e);
      }, (e) => {
        const { currentTarget, code, target } = e;
        currentTarget.contains(target);
        if (EVENT_CODE.tab === code) {
          e.stopImmediatePropagation();
        }
        e.preventDefault();
        if (target !== vue.unref(contentRef))
          return;
        if (!FIRST_LAST_KEYS.includes(code))
          return;
        const items = getItems().filter((item) => !item.disabled);
        const targets = items.map((item) => item.ref);
        if (LAST_KEYS.includes(code)) {
          targets.reverse();
        }
        focusFirst(targets);
      });
      const handleKeydown = (e) => {
        composedKeydown(e);
        onKeydown(e);
      };
      return {
        size,
        rovingFocusGroupRootStyle,
        tabIndex,
        dropdownKls,
        dropdownListWrapperRef,
        handleKeydown,
        onBlur,
        onFocus,
        onMousedown
      };
    }
  });
  function _sfc_render$O(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("ul", {
      ref: _ctx.dropdownListWrapperRef,
      class: vue.normalizeClass(_ctx.dropdownKls),
      style: vue.normalizeStyle(_ctx.rovingFocusGroupRootStyle),
      tabindex: -1,
      role: "menu",
      onBlur: _cache[0] || (_cache[0] = (...args) => _ctx.onBlur && _ctx.onBlur(...args)),
      onFocus: _cache[1] || (_cache[1] = (...args) => _ctx.onFocus && _ctx.onFocus(...args)),
      onKeydown: _cache[2] || (_cache[2] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args)),
      onMousedown: _cache[3] || (_cache[3] = (...args) => _ctx.onMousedown && _ctx.onMousedown(...args))
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 38);
  }
  var DropdownMenu = /* @__PURE__ */ _export_sfc(_sfc_main$Z, [["render", _sfc_render$O]]);

  const ElDropdown = withInstall(Dropdown, {
    DropdownItem,
    DropdownMenu
  });
  const ElDropdownItem = withNoopInstall(DropdownItem);
  const ElDropdownMenu = withNoopInstall(DropdownMenu);

  let id = 0;
  const _sfc_main$Y = vue.defineComponent({
    name: "ImgEmpty",
    setup() {
      return {
        id: ++id
      };
    }
  });
  const _hoisted_1$w = {
    viewBox: "0 0 79 86",
    version: "1.1",
    xmlns: "http://www.w3.org/2000/svg",
    "xmlns:xlink": "http://www.w3.org/1999/xlink"
  };
  const _hoisted_2$l = ["id"];
  const _hoisted_3$a = /* @__PURE__ */ vue.createElementVNode("stop", {
    "stop-color": "var(--el-empty-fill-color-1)",
    offset: "0%"
  }, null, -1);
  const _hoisted_4$6 = /* @__PURE__ */ vue.createElementVNode("stop", {
    "stop-color": "var(--el-empty-fill-color-4)",
    offset: "100%"
  }, null, -1);
  const _hoisted_5$5 = [
    _hoisted_3$a,
    _hoisted_4$6
  ];
  const _hoisted_6$2 = ["id"];
  const _hoisted_7$1 = /* @__PURE__ */ vue.createElementVNode("stop", {
    "stop-color": "var(--el-empty-fill-color-1)",
    offset: "0%"
  }, null, -1);
  const _hoisted_8$1 = /* @__PURE__ */ vue.createElementVNode("stop", {
    "stop-color": "var(--el-empty-fill-color-6)",
    offset: "100%"
  }, null, -1);
  const _hoisted_9$1 = [
    _hoisted_7$1,
    _hoisted_8$1
  ];
  const _hoisted_10$1 = ["id"];
  const _hoisted_11 = {
    id: "Illustrations",
    stroke: "none",
    "stroke-width": "1",
    fill: "none",
    "fill-rule": "evenodd"
  };
  const _hoisted_12 = {
    id: "B-type",
    transform: "translate(-1268.000000, -535.000000)"
  };
  const _hoisted_13 = {
    id: "Group-2",
    transform: "translate(1268.000000, 535.000000)"
  };
  const _hoisted_14 = /* @__PURE__ */ vue.createElementVNode("path", {
    id: "Oval-Copy-2",
    d: "M39.5,86 C61.3152476,86 79,83.9106622 79,81.3333333 C79,78.7560045 57.3152476,78 35.5,78 C13.6847524,78 0,78.7560045 0,81.3333333 C0,83.9106622 17.6847524,86 39.5,86 Z",
    fill: "var(--el-empty-fill-color-3)"
  }, null, -1);
  const _hoisted_15 = /* @__PURE__ */ vue.createElementVNode("polygon", {
    id: "Rectangle-Copy-14",
    fill: "var(--el-empty-fill-color-7)",
    transform: "translate(27.500000, 51.500000) scale(1, -1) translate(-27.500000, -51.500000) ",
    points: "13 58 53 58 42 45 2 45"
  }, null, -1);
  const _hoisted_16 = {
    id: "Group-Copy",
    transform: "translate(34.500000, 31.500000) scale(-1, 1) rotate(-25.000000) translate(-34.500000, -31.500000) translate(7.000000, 10.000000)"
  };
  const _hoisted_17 = /* @__PURE__ */ vue.createElementVNode("polygon", {
    id: "Rectangle-Copy-10",
    fill: "var(--el-empty-fill-color-7)",
    transform: "translate(11.500000, 5.000000) scale(1, -1) translate(-11.500000, -5.000000) ",
    points: "2.84078316e-14 3 18 3 23 7 5 7"
  }, null, -1);
  const _hoisted_18 = /* @__PURE__ */ vue.createElementVNode("polygon", {
    id: "Rectangle-Copy-11",
    fill: "var(--el-empty-fill-color-5)",
    points: "-3.69149156e-15 7 38 7 38 43 -3.69149156e-15 43"
  }, null, -1);
  const _hoisted_19 = ["fill"];
  const _hoisted_20 = /* @__PURE__ */ vue.createElementVNode("polygon", {
    id: "Rectangle-Copy-13",
    fill: "var(--el-empty-fill-color-2)",
    transform: "translate(39.500000, 3.500000) scale(-1, 1) translate(-39.500000, -3.500000) ",
    points: "24 7 41 7 55 -3.63806207e-12 38 -3.63806207e-12"
  }, null, -1);
  const _hoisted_21 = ["fill"];
  const _hoisted_22 = {
    id: "Rectangle-Copy-17",
    transform: "translate(53.000000, 45.000000)"
  };
  const _hoisted_23 = ["id"];
  const _hoisted_24 = ["xlink:href"];
  const _hoisted_25 = ["xlink:href"];
  const _hoisted_26 = ["mask"];
  const _hoisted_27 = /* @__PURE__ */ vue.createElementVNode("polygon", {
    id: "Rectangle-Copy-18",
    fill: "var(--el-empty-fill-color-2)",
    transform: "translate(66.000000, 51.500000) scale(-1, 1) translate(-66.000000, -51.500000) ",
    points: "62 45 79 45 70 58 53 58"
  }, null, -1);
  function _sfc_render$N(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("svg", _hoisted_1$w, [
      vue.createElementVNode("defs", null, [
        vue.createElementVNode("linearGradient", {
          id: `linearGradient-1-${_ctx.id}`,
          x1: "38.8503086%",
          y1: "0%",
          x2: "61.1496914%",
          y2: "100%"
        }, _hoisted_5$5, 8, _hoisted_2$l),
        vue.createElementVNode("linearGradient", {
          id: `linearGradient-2-${_ctx.id}`,
          x1: "0%",
          y1: "9.5%",
          x2: "100%",
          y2: "90.5%"
        }, _hoisted_9$1, 8, _hoisted_6$2),
        vue.createElementVNode("rect", {
          id: `path-3-${_ctx.id}`,
          x: "0",
          y: "0",
          width: "17",
          height: "36"
        }, null, 8, _hoisted_10$1)
      ]),
      vue.createElementVNode("g", _hoisted_11, [
        vue.createElementVNode("g", _hoisted_12, [
          vue.createElementVNode("g", _hoisted_13, [
            _hoisted_14,
            _hoisted_15,
            vue.createElementVNode("g", _hoisted_16, [
              _hoisted_17,
              _hoisted_18,
              vue.createElementVNode("rect", {
                id: "Rectangle-Copy-12",
                fill: `url(#linearGradient-1-${_ctx.id})`,
                transform: "translate(46.500000, 25.000000) scale(-1, 1) translate(-46.500000, -25.000000) ",
                x: "38",
                y: "7",
                width: "17",
                height: "36"
              }, null, 8, _hoisted_19),
              _hoisted_20
            ]),
            vue.createElementVNode("rect", {
              id: "Rectangle-Copy-15",
              fill: `url(#linearGradient-2-${_ctx.id})`,
              x: "13",
              y: "45",
              width: "40",
              height: "36"
            }, null, 8, _hoisted_21),
            vue.createElementVNode("g", _hoisted_22, [
              vue.createElementVNode("mask", {
                id: `mask-4-${_ctx.id}`,
                fill: "var(--el-empty-fill-color-0)"
              }, [
                vue.createElementVNode("use", {
                  "xlink:href": `#path-3-${_ctx.id}`
                }, null, 8, _hoisted_24)
              ], 8, _hoisted_23),
              vue.createElementVNode("use", {
                id: "Mask",
                fill: "var(--el-empty-fill-color-8)",
                transform: "translate(8.500000, 18.000000) scale(-1, 1) translate(-8.500000, -18.000000) ",
                "xlink:href": `#path-3-${_ctx.id}`
              }, null, 8, _hoisted_25),
              vue.createElementVNode("polygon", {
                id: "Rectangle-Copy",
                fill: "var(--el-empty-fill-color-9)",
                mask: `url(#mask-4-${_ctx.id})`,
                transform: "translate(12.000000, 9.000000) scale(-1, 1) translate(-12.000000, -9.000000) ",
                points: "7 0 24 0 20 18 -1.70530257e-13 16"
              }, null, 8, _hoisted_26)
            ]),
            _hoisted_27
          ])
        ])
      ])
    ]);
  }
  var ImgEmpty = /* @__PURE__ */ _export_sfc(_sfc_main$Y, [["render", _sfc_render$N]]);

  const emptyProps = {
    image: {
      type: String,
      default: ""
    },
    imageSize: Number,
    description: {
      type: String,
      default: ""
    }
  };

  const _sfc_main$X = vue.defineComponent({
    name: "ElEmpty",
    components: {
      ImgEmpty
    },
    props: emptyProps,
    setup(props) {
      const { t } = useLocale();
      const ns = useNamespace("empty");
      const emptyDescription = vue.computed(() => props.description || t("el.table.emptyText"));
      const imageStyle = vue.computed(() => ({
        width: props.imageSize ? `${props.imageSize}px` : ""
      }));
      return {
        ns,
        emptyDescription,
        imageStyle
      };
    }
  });
  const _hoisted_1$v = ["src"];
  const _hoisted_2$k = { key: 1 };
  function _sfc_render$M(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_img_empty = vue.resolveComponent("img-empty");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass(_ctx.ns.b())
    }, [
      vue.createElementVNode("div", {
        class: vue.normalizeClass(_ctx.ns.e("image")),
        style: vue.normalizeStyle(_ctx.imageStyle)
      }, [
        _ctx.image ? (vue.openBlock(), vue.createElementBlock("img", {
          key: 0,
          src: _ctx.image,
          ondragstart: "return false"
        }, null, 8, _hoisted_1$v)) : vue.renderSlot(_ctx.$slots, "image", { key: 1 }, () => [
          vue.createVNode(_component_img_empty)
        ])
      ], 6),
      vue.createElementVNode("div", {
        class: vue.normalizeClass(_ctx.ns.e("description"))
      }, [
        _ctx.$slots.description ? vue.renderSlot(_ctx.$slots, "description", { key: 0 }) : (vue.openBlock(), vue.createElementBlock("p", _hoisted_2$k, vue.toDisplayString(_ctx.emptyDescription), 1))
      ], 2),
      _ctx.$slots.default ? (vue.openBlock(), vue.createElementBlock("div", {
        key: 0,
        class: vue.normalizeClass(_ctx.ns.e("bottom"))
      }, [
        vue.renderSlot(_ctx.$slots, "default")
      ], 2)) : vue.createCommentVNode("v-if", true)
    ], 2);
  }
  var Empty = /* @__PURE__ */ _export_sfc(_sfc_main$X, [["render", _sfc_render$M]]);

  const ElEmpty = withInstall(Empty);

  const formProps = buildProps({
    model: Object,
    rules: {
      type: definePropType(Object)
    },
    labelPosition: String,
    labelWidth: {
      type: [String, Number],
      default: ""
    },
    labelSuffix: {
      type: String,
      default: ""
    },
    inline: Boolean,
    inlineMessage: Boolean,
    statusIcon: Boolean,
    showMessage: {
      type: Boolean,
      default: true
    },
    size: {
      type: String,
      values: componentSizes
    },
    disabled: Boolean,
    validateOnRuleChange: {
      type: Boolean,
      default: true
    },
    hideRequiredAsterisk: {
      type: Boolean,
      default: false
    },
    scrollToError: Boolean
  });
  const formEmits = {
    validate: (prop, isValid, message) => (isArray(prop) || isString(prop)) && isBoolean(isValid) && isString(message)
  };

  function useFormLabelWidth() {
    const potentialLabelWidthArr = vue.ref([]);
    const autoLabelWidth = vue.computed(() => {
      if (!potentialLabelWidthArr.value.length)
        return "0";
      const max = Math.max(...potentialLabelWidthArr.value);
      return max ? `${max}px` : "";
    });
    function getLabelWidthIndex(width) {
      const index = potentialLabelWidthArr.value.indexOf(width);
      return index;
    }
    function registerLabelWidth(val, oldVal) {
      if (val && oldVal) {
        const index = getLabelWidthIndex(oldVal);
        potentialLabelWidthArr.value.splice(index, 1, val);
      } else if (val) {
        potentialLabelWidthArr.value.push(val);
      }
    }
    function deregisterLabelWidth(val) {
      const index = getLabelWidthIndex(val);
      if (index > -1) {
        potentialLabelWidthArr.value.splice(index, 1);
      }
    }
    return {
      autoLabelWidth,
      registerLabelWidth,
      deregisterLabelWidth
    };
  }
  const filterFields = (fields, props) => {
    const normalized = castArray$1(props);
    return normalized.length > 0 ? fields.filter((field) => field.prop && normalized.includes(field.prop)) : fields;
  };

  const __default__$7 = {
    name: "ElForm"
  };
  const _sfc_main$W = /* @__PURE__ */ vue.defineComponent({
    ...__default__$7,
    props: formProps,
    emits: formEmits,
    setup(__props, { expose, emit }) {
      const props = __props;
      const fields = [];
      const formSize = useSize();
      const ns = useNamespace("form");
      const formClasses = vue.computed(() => {
        const { labelPosition, inline } = props;
        return [
          ns.b(),
          ns.m(formSize.value),
          {
            [ns.m(`label-${labelPosition}`)]: labelPosition,
            [ns.m("inline")]: inline
          }
        ];
      });
      const addField = (field) => {
        fields.push(field);
      };
      const removeField = (field) => {
        if (!field.prop) {
          fields.splice(fields.indexOf(field), 1);
        }
      };
      const resetFields = (properties = []) => {
        if (!props.model) {
          return;
        }
        filterFields(fields, properties).forEach((field) => field.resetField());
      };
      const clearValidate = (props2 = []) => {
        filterFields(fields, props2).forEach((field) => field.clearValidate());
      };
      const validate = async (callback) => validateField(void 0, callback);
      const validateField = async (properties = [], callback) => {
        if (callback) {
          validate().then(() => callback(true)).catch((fields2) => callback(false, fields2));
          return;
        }
        const { model, scrollToError } = props;
        if (!model) {
          return;
        }
        if (fields.length === 0) {
          return;
        }
        const filteredFields = filterFields(fields, properties);
        if (!filteredFields.length) {
          return;
        }
        let valid = true;
        let invalidFields = {};
        let firstInvalidFields;
        for (const field of filteredFields) {
          const fieldsError = await field.validate("").catch((fields2) => fields2);
          if (fieldsError) {
            valid = false;
            if (!firstInvalidFields)
              firstInvalidFields = fieldsError;
          }
          invalidFields = { ...invalidFields, ...fieldsError };
        }
        if (!valid) {
          if (scrollToError)
            scrollToField(Object.keys(firstInvalidFields)[0]);
          return Promise.reject(invalidFields);
        }
      };
      const scrollToField = (prop) => {
        var _a;
        const field = filterFields(fields, prop)[0];
        if (field) {
          (_a = field.$el) == null ? void 0 : _a.scrollIntoView();
        }
      };
      vue.watch(() => props.rules, () => {
        if (props.validateOnRuleChange)
          validate();
      }, { deep: true });
      vue.provide(formContextKey, vue.reactive({
        ...vue.toRefs(props),
        emit,
        resetFields,
        clearValidate,
        validateField,
        addField,
        removeField,
        ...useFormLabelWidth()
      }));
      expose({
        validate,
        validateField,
        resetFields,
        clearValidate,
        scrollToField
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("form", {
          class: vue.normalizeClass(vue.unref(formClasses))
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2);
      };
    }
  });
  var Form = _sfc_main$W;

  function _extends() {
    _extends = Object.assign || function(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
    return _extends.apply(this, arguments);
  }
  function _inheritsLoose(subClass, superClass) {
    subClass.prototype = Object.create(superClass.prototype);
    subClass.prototype.constructor = subClass;
    _setPrototypeOf(subClass, superClass);
  }
  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf2(o2) {
      return o2.__proto__ || Object.getPrototypeOf(o2);
    };
    return _getPrototypeOf(o);
  }
  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf2(o2, p2) {
      o2.__proto__ = p2;
      return o2;
    };
    return _setPrototypeOf(o, p);
  }
  function _isNativeReflectConstruct() {
    if (typeof Reflect === "undefined" || !Reflect.construct)
      return false;
    if (Reflect.construct.sham)
      return false;
    if (typeof Proxy === "function")
      return true;
    try {
      Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function() {
      }));
      return true;
    } catch (e) {
      return false;
    }
  }
  function _construct(Parent, args, Class) {
    if (_isNativeReflectConstruct()) {
      _construct = Reflect.construct;
    } else {
      _construct = function _construct2(Parent2, args2, Class2) {
        var a = [null];
        a.push.apply(a, args2);
        var Constructor = Function.bind.apply(Parent2, a);
        var instance = new Constructor();
        if (Class2)
          _setPrototypeOf(instance, Class2.prototype);
        return instance;
      };
    }
    return _construct.apply(null, arguments);
  }
  function _isNativeFunction(fn) {
    return Function.toString.call(fn).indexOf("[native code]") !== -1;
  }
  function _wrapNativeSuper(Class) {
    var _cache = typeof Map === "function" ? /* @__PURE__ */ new Map() : void 0;
    _wrapNativeSuper = function _wrapNativeSuper2(Class2) {
      if (Class2 === null || !_isNativeFunction(Class2))
        return Class2;
      if (typeof Class2 !== "function") {
        throw new TypeError("Super expression must either be null or a function");
      }
      if (typeof _cache !== "undefined") {
        if (_cache.has(Class2))
          return _cache.get(Class2);
        _cache.set(Class2, Wrapper);
      }
      function Wrapper() {
        return _construct(Class2, arguments, _getPrototypeOf(this).constructor);
      }
      Wrapper.prototype = Object.create(Class2.prototype, {
        constructor: {
          value: Wrapper,
          enumerable: false,
          writable: true,
          configurable: true
        }
      });
      return _setPrototypeOf(Wrapper, Class2);
    };
    return _wrapNativeSuper(Class);
  }
  var formatRegExp = /%[sdj%]/g;
  var warning = function warning2() {
  };
  if (typeof process !== "undefined" && process.env && false) {
    warning = function warning3(type4, errors) {
      if (typeof console !== "undefined" && console.warn && typeof ASYNC_VALIDATOR_NO_WARNING === "undefined") {
        if (errors.every(function(e) {
          return typeof e === "string";
        })) {
          console.warn(type4, errors);
        }
      }
    };
  }
  function convertFieldsError(errors) {
    if (!errors || !errors.length)
      return null;
    var fields = {};
    errors.forEach(function(error) {
      var field = error.field;
      fields[field] = fields[field] || [];
      fields[field].push(error);
    });
    return fields;
  }
  function format(template) {
    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }
    var i = 0;
    var len = args.length;
    if (typeof template === "function") {
      return template.apply(null, args);
    }
    if (typeof template === "string") {
      var str = template.replace(formatRegExp, function(x) {
        if (x === "%%") {
          return "%";
        }
        if (i >= len) {
          return x;
        }
        switch (x) {
          case "%s":
            return String(args[i++]);
          case "%d":
            return Number(args[i++]);
          case "%j":
            try {
              return JSON.stringify(args[i++]);
            } catch (_) {
              return "[Circular]";
            }
            break;
          default:
            return x;
        }
      });
      return str;
    }
    return template;
  }
  function isNativeStringType(type4) {
    return type4 === "string" || type4 === "url" || type4 === "hex" || type4 === "email" || type4 === "date" || type4 === "pattern";
  }
  function isEmptyValue(value, type4) {
    if (value === void 0 || value === null) {
      return true;
    }
    if (type4 === "array" && Array.isArray(value) && !value.length) {
      return true;
    }
    if (isNativeStringType(type4) && typeof value === "string" && !value) {
      return true;
    }
    return false;
  }
  function asyncParallelArray(arr, func, callback) {
    var results = [];
    var total = 0;
    var arrLength = arr.length;
    function count(errors) {
      results.push.apply(results, errors || []);
      total++;
      if (total === arrLength) {
        callback(results);
      }
    }
    arr.forEach(function(a) {
      func(a, count);
    });
  }
  function asyncSerialArray(arr, func, callback) {
    var index = 0;
    var arrLength = arr.length;
    function next(errors) {
      if (errors && errors.length) {
        callback(errors);
        return;
      }
      var original = index;
      index = index + 1;
      if (original < arrLength) {
        func(arr[original], next);
      } else {
        callback([]);
      }
    }
    next([]);
  }
  function flattenObjArr(objArr) {
    var ret = [];
    Object.keys(objArr).forEach(function(k) {
      ret.push.apply(ret, objArr[k] || []);
    });
    return ret;
  }
  var AsyncValidationError = /* @__PURE__ */ function(_Error) {
    _inheritsLoose(AsyncValidationError2, _Error);
    function AsyncValidationError2(errors, fields) {
      var _this;
      _this = _Error.call(this, "Async Validation Error") || this;
      _this.errors = errors;
      _this.fields = fields;
      return _this;
    }
    return AsyncValidationError2;
  }(/* @__PURE__ */ _wrapNativeSuper(Error));
  function asyncMap(objArr, option, func, callback, source) {
    if (option.first) {
      var _pending = new Promise(function(resolve, reject) {
        var next = function next2(errors) {
          callback(errors);
          return errors.length ? reject(new AsyncValidationError(errors, convertFieldsError(errors))) : resolve(source);
        };
        var flattenArr = flattenObjArr(objArr);
        asyncSerialArray(flattenArr, func, next);
      });
      _pending["catch"](function(e) {
        return e;
      });
      return _pending;
    }
    var firstFields = option.firstFields === true ? Object.keys(objArr) : option.firstFields || [];
    var objArrKeys = Object.keys(objArr);
    var objArrLength = objArrKeys.length;
    var total = 0;
    var results = [];
    var pending = new Promise(function(resolve, reject) {
      var next = function next2(errors) {
        results.push.apply(results, errors);
        total++;
        if (total === objArrLength) {
          callback(results);
          return results.length ? reject(new AsyncValidationError(results, convertFieldsError(results))) : resolve(source);
        }
      };
      if (!objArrKeys.length) {
        callback(results);
        resolve(source);
      }
      objArrKeys.forEach(function(key) {
        var arr = objArr[key];
        if (firstFields.indexOf(key) !== -1) {
          asyncSerialArray(arr, func, next);
        } else {
          asyncParallelArray(arr, func, next);
        }
      });
    });
    pending["catch"](function(e) {
      return e;
    });
    return pending;
  }
  function isErrorObj(obj) {
    return !!(obj && obj.message !== void 0);
  }
  function getValue(value, path) {
    var v = value;
    for (var i = 0; i < path.length; i++) {
      if (v == void 0) {
        return v;
      }
      v = v[path[i]];
    }
    return v;
  }
  function complementError(rule, source) {
    return function(oe) {
      var fieldValue;
      if (rule.fullFields) {
        fieldValue = getValue(source, rule.fullFields);
      } else {
        fieldValue = source[oe.field || rule.fullField];
      }
      if (isErrorObj(oe)) {
        oe.field = oe.field || rule.fullField;
        oe.fieldValue = fieldValue;
        return oe;
      }
      return {
        message: typeof oe === "function" ? oe() : oe,
        fieldValue,
        field: oe.field || rule.fullField
      };
    };
  }
  function deepMerge(target, source) {
    if (source) {
      for (var s in source) {
        if (source.hasOwnProperty(s)) {
          var value = source[s];
          if (typeof value === "object" && typeof target[s] === "object") {
            target[s] = _extends({}, target[s], value);
          } else {
            target[s] = value;
          }
        }
      }
    }
    return target;
  }
  var required$1 = function required(rule, value, source, errors, options, type4) {
    if (rule.required && (!source.hasOwnProperty(rule.field) || isEmptyValue(value, type4 || rule.type))) {
      errors.push(format(options.messages.required, rule.fullField));
    }
  };
  var whitespace = function whitespace2(rule, value, source, errors, options) {
    if (/^\s+$/.test(value) || value === "") {
      errors.push(format(options.messages.whitespace, rule.fullField));
    }
  };
  var pattern$2 = {
    email: /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]+\.)+[a-zA-Z\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]{2,}))$/,
    url: new RegExp("^(?!mailto:)(?:(?:http|https|ftp)://|//)(?:\\S+(?::\\S*)?@)?(?:(?:(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[0-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]+-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]+-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))|localhost)(?::\\d{2,5})?(?:(/|\\?|#)[^\\s]*)?$", "i"),
    hex: /^#?([a-f0-9]{6}|[a-f0-9]{3})$/i
  };
  var types = {
    integer: function integer(value) {
      return types.number(value) && parseInt(value, 10) === value;
    },
    "float": function float(value) {
      return types.number(value) && !types.integer(value);
    },
    array: function array(value) {
      return Array.isArray(value);
    },
    regexp: function regexp(value) {
      if (value instanceof RegExp) {
        return true;
      }
      try {
        return !!new RegExp(value);
      } catch (e) {
        return false;
      }
    },
    date: function date(value) {
      return typeof value.getTime === "function" && typeof value.getMonth === "function" && typeof value.getYear === "function" && !isNaN(value.getTime());
    },
    number: function number(value) {
      if (isNaN(value)) {
        return false;
      }
      return typeof value === "number";
    },
    object: function object(value) {
      return typeof value === "object" && !types.array(value);
    },
    method: function method(value) {
      return typeof value === "function";
    },
    email: function email(value) {
      return typeof value === "string" && value.length <= 320 && !!value.match(pattern$2.email);
    },
    url: function url(value) {
      return typeof value === "string" && value.length <= 2048 && !!value.match(pattern$2.url);
    },
    hex: function hex(value) {
      return typeof value === "string" && !!value.match(pattern$2.hex);
    }
  };
  var type$1 = function type(rule, value, source, errors, options) {
    if (rule.required && value === void 0) {
      required$1(rule, value, source, errors, options);
      return;
    }
    var custom = ["integer", "float", "array", "regexp", "object", "method", "email", "number", "date", "url", "hex"];
    var ruleType = rule.type;
    if (custom.indexOf(ruleType) > -1) {
      if (!types[ruleType](value)) {
        errors.push(format(options.messages.types[ruleType], rule.fullField, rule.type));
      }
    } else if (ruleType && typeof value !== rule.type) {
      errors.push(format(options.messages.types[ruleType], rule.fullField, rule.type));
    }
  };
  var range = function range2(rule, value, source, errors, options) {
    var len = typeof rule.len === "number";
    var min = typeof rule.min === "number";
    var max = typeof rule.max === "number";
    var spRegexp = /[\uD800-\uDBFF][\uDC00-\uDFFF]/g;
    var val = value;
    var key = null;
    var num = typeof value === "number";
    var str = typeof value === "string";
    var arr = Array.isArray(value);
    if (num) {
      key = "number";
    } else if (str) {
      key = "string";
    } else if (arr) {
      key = "array";
    }
    if (!key) {
      return false;
    }
    if (arr) {
      val = value.length;
    }
    if (str) {
      val = value.replace(spRegexp, "_").length;
    }
    if (len) {
      if (val !== rule.len) {
        errors.push(format(options.messages[key].len, rule.fullField, rule.len));
      }
    } else if (min && !max && val < rule.min) {
      errors.push(format(options.messages[key].min, rule.fullField, rule.min));
    } else if (max && !min && val > rule.max) {
      errors.push(format(options.messages[key].max, rule.fullField, rule.max));
    } else if (min && max && (val < rule.min || val > rule.max)) {
      errors.push(format(options.messages[key].range, rule.fullField, rule.min, rule.max));
    }
  };
  var ENUM$1 = "enum";
  var enumerable$1 = function enumerable(rule, value, source, errors, options) {
    rule[ENUM$1] = Array.isArray(rule[ENUM$1]) ? rule[ENUM$1] : [];
    if (rule[ENUM$1].indexOf(value) === -1) {
      errors.push(format(options.messages[ENUM$1], rule.fullField, rule[ENUM$1].join(", ")));
    }
  };
  var pattern$1 = function pattern(rule, value, source, errors, options) {
    if (rule.pattern) {
      if (rule.pattern instanceof RegExp) {
        rule.pattern.lastIndex = 0;
        if (!rule.pattern.test(value)) {
          errors.push(format(options.messages.pattern.mismatch, rule.fullField, value, rule.pattern));
        }
      } else if (typeof rule.pattern === "string") {
        var _pattern = new RegExp(rule.pattern);
        if (!_pattern.test(value)) {
          errors.push(format(options.messages.pattern.mismatch, rule.fullField, value, rule.pattern));
        }
      }
    }
  };
  var rules = {
    required: required$1,
    whitespace,
    type: type$1,
    range,
    "enum": enumerable$1,
    pattern: pattern$1
  };
  var string = function string2(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value, "string") && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options, "string");
      if (!isEmptyValue(value, "string")) {
        rules.type(rule, value, source, errors, options);
        rules.range(rule, value, source, errors, options);
        rules.pattern(rule, value, source, errors, options);
        if (rule.whitespace === true) {
          rules.whitespace(rule, value, source, errors, options);
        }
      }
    }
    callback(errors);
  };
  var method2 = function method3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules.type(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var number2 = function number3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (value === "") {
        value = void 0;
      }
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules.type(rule, value, source, errors, options);
        rules.range(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var _boolean = function _boolean2(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules.type(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var regexp2 = function regexp3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (!isEmptyValue(value)) {
        rules.type(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var integer2 = function integer3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules.type(rule, value, source, errors, options);
        rules.range(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var floatFn = function floatFn2(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules.type(rule, value, source, errors, options);
        rules.range(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var array2 = function array3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if ((value === void 0 || value === null) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options, "array");
      if (value !== void 0 && value !== null) {
        rules.type(rule, value, source, errors, options);
        rules.range(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var object2 = function object3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules.type(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var ENUM = "enum";
  var enumerable2 = function enumerable3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (value !== void 0) {
        rules[ENUM](rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var pattern2 = function pattern3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value, "string") && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (!isEmptyValue(value, "string")) {
        rules.pattern(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var date2 = function date3(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value, "date") && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
      if (!isEmptyValue(value, "date")) {
        var dateObject;
        if (value instanceof Date) {
          dateObject = value;
        } else {
          dateObject = new Date(value);
        }
        rules.type(rule, dateObject, source, errors, options);
        if (dateObject) {
          rules.range(rule, dateObject.getTime(), source, errors, options);
        }
      }
    }
    callback(errors);
  };
  var required2 = function required3(rule, value, callback, source, options) {
    var errors = [];
    var type4 = Array.isArray(value) ? "array" : typeof value;
    rules.required(rule, value, source, errors, options, type4);
    callback(errors);
  };
  var type2 = function type3(rule, value, callback, source, options) {
    var ruleType = rule.type;
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value, ruleType) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options, ruleType);
      if (!isEmptyValue(value, ruleType)) {
        rules.type(rule, value, source, errors, options);
      }
    }
    callback(errors);
  };
  var any = function any2(rule, value, callback, source, options) {
    var errors = [];
    var validate = rule.required || !rule.required && source.hasOwnProperty(rule.field);
    if (validate) {
      if (isEmptyValue(value) && !rule.required) {
        return callback();
      }
      rules.required(rule, value, source, errors, options);
    }
    callback(errors);
  };
  var validators = {
    string,
    method: method2,
    number: number2,
    "boolean": _boolean,
    regexp: regexp2,
    integer: integer2,
    "float": floatFn,
    array: array2,
    object: object2,
    "enum": enumerable2,
    pattern: pattern2,
    date: date2,
    url: type2,
    hex: type2,
    email: type2,
    required: required2,
    any
  };
  function newMessages() {
    return {
      "default": "Validation error on field %s",
      required: "%s is required",
      "enum": "%s must be one of %s",
      whitespace: "%s cannot be empty",
      date: {
        format: "%s date %s is invalid for format %s",
        parse: "%s date could not be parsed, %s is invalid ",
        invalid: "%s date %s is invalid"
      },
      types: {
        string: "%s is not a %s",
        method: "%s is not a %s (function)",
        array: "%s is not an %s",
        object: "%s is not an %s",
        number: "%s is not a %s",
        date: "%s is not a %s",
        "boolean": "%s is not a %s",
        integer: "%s is not an %s",
        "float": "%s is not a %s",
        regexp: "%s is not a valid %s",
        email: "%s is not a valid %s",
        url: "%s is not a valid %s",
        hex: "%s is not a valid %s"
      },
      string: {
        len: "%s must be exactly %s characters",
        min: "%s must be at least %s characters",
        max: "%s cannot be longer than %s characters",
        range: "%s must be between %s and %s characters"
      },
      number: {
        len: "%s must equal %s",
        min: "%s cannot be less than %s",
        max: "%s cannot be greater than %s",
        range: "%s must be between %s and %s"
      },
      array: {
        len: "%s must be exactly %s in length",
        min: "%s cannot be less than %s in length",
        max: "%s cannot be greater than %s in length",
        range: "%s must be between %s and %s in length"
      },
      pattern: {
        mismatch: "%s value %s does not match pattern %s"
      },
      clone: function clone() {
        var cloned = JSON.parse(JSON.stringify(this));
        cloned.clone = this.clone;
        return cloned;
      }
    };
  }
  var messages = newMessages();
  var Schema = /* @__PURE__ */ function() {
    function Schema2(descriptor) {
      this.rules = null;
      this._messages = messages;
      this.define(descriptor);
    }
    var _proto = Schema2.prototype;
    _proto.define = function define(rules2) {
      var _this = this;
      if (!rules2) {
        throw new Error("Cannot configure a schema with no rules");
      }
      if (typeof rules2 !== "object" || Array.isArray(rules2)) {
        throw new Error("Rules must be an object");
      }
      this.rules = {};
      Object.keys(rules2).forEach(function(name) {
        var item = rules2[name];
        _this.rules[name] = Array.isArray(item) ? item : [item];
      });
    };
    _proto.messages = function messages2(_messages) {
      if (_messages) {
        this._messages = deepMerge(newMessages(), _messages);
      }
      return this._messages;
    };
    _proto.validate = function validate(source_, o, oc) {
      var _this2 = this;
      if (o === void 0) {
        o = {};
      }
      if (oc === void 0) {
        oc = function oc2() {
        };
      }
      var source = source_;
      var options = o;
      var callback = oc;
      if (typeof options === "function") {
        callback = options;
        options = {};
      }
      if (!this.rules || Object.keys(this.rules).length === 0) {
        if (callback) {
          callback(null, source);
        }
        return Promise.resolve(source);
      }
      function complete(results) {
        var errors = [];
        var fields = {};
        function add(e) {
          if (Array.isArray(e)) {
            var _errors;
            errors = (_errors = errors).concat.apply(_errors, e);
          } else {
            errors.push(e);
          }
        }
        for (var i = 0; i < results.length; i++) {
          add(results[i]);
        }
        if (!errors.length) {
          callback(null, source);
        } else {
          fields = convertFieldsError(errors);
          callback(errors, fields);
        }
      }
      if (options.messages) {
        var messages$1 = this.messages();
        if (messages$1 === messages) {
          messages$1 = newMessages();
        }
        deepMerge(messages$1, options.messages);
        options.messages = messages$1;
      } else {
        options.messages = this.messages();
      }
      var series = {};
      var keys = options.keys || Object.keys(this.rules);
      keys.forEach(function(z) {
        var arr = _this2.rules[z];
        var value = source[z];
        arr.forEach(function(r) {
          var rule = r;
          if (typeof rule.transform === "function") {
            if (source === source_) {
              source = _extends({}, source);
            }
            value = source[z] = rule.transform(value);
          }
          if (typeof rule === "function") {
            rule = {
              validator: rule
            };
          } else {
            rule = _extends({}, rule);
          }
          rule.validator = _this2.getValidationMethod(rule);
          if (!rule.validator) {
            return;
          }
          rule.field = z;
          rule.fullField = rule.fullField || z;
          rule.type = _this2.getType(rule);
          series[z] = series[z] || [];
          series[z].push({
            rule,
            value,
            source,
            field: z
          });
        });
      });
      var errorFields = {};
      return asyncMap(series, options, function(data, doIt) {
        var rule = data.rule;
        var deep = (rule.type === "object" || rule.type === "array") && (typeof rule.fields === "object" || typeof rule.defaultField === "object");
        deep = deep && (rule.required || !rule.required && data.value);
        rule.field = data.field;
        function addFullField(key, schema) {
          return _extends({}, schema, {
            fullField: rule.fullField + "." + key,
            fullFields: rule.fullFields ? [].concat(rule.fullFields, [key]) : [key]
          });
        }
        function cb(e) {
          if (e === void 0) {
            e = [];
          }
          var errorList = Array.isArray(e) ? e : [e];
          if (!options.suppressWarning && errorList.length) {
            Schema2.warning("async-validator:", errorList);
          }
          if (errorList.length && rule.message !== void 0) {
            errorList = [].concat(rule.message);
          }
          var filledErrors = errorList.map(complementError(rule, source));
          if (options.first && filledErrors.length) {
            errorFields[rule.field] = 1;
            return doIt(filledErrors);
          }
          if (!deep) {
            doIt(filledErrors);
          } else {
            if (rule.required && !data.value) {
              if (rule.message !== void 0) {
                filledErrors = [].concat(rule.message).map(complementError(rule, source));
              } else if (options.error) {
                filledErrors = [options.error(rule, format(options.messages.required, rule.field))];
              }
              return doIt(filledErrors);
            }
            var fieldsSchema = {};
            if (rule.defaultField) {
              Object.keys(data.value).map(function(key) {
                fieldsSchema[key] = rule.defaultField;
              });
            }
            fieldsSchema = _extends({}, fieldsSchema, data.rule.fields);
            var paredFieldsSchema = {};
            Object.keys(fieldsSchema).forEach(function(field) {
              var fieldSchema = fieldsSchema[field];
              var fieldSchemaList = Array.isArray(fieldSchema) ? fieldSchema : [fieldSchema];
              paredFieldsSchema[field] = fieldSchemaList.map(addFullField.bind(null, field));
            });
            var schema = new Schema2(paredFieldsSchema);
            schema.messages(options.messages);
            if (data.rule.options) {
              data.rule.options.messages = options.messages;
              data.rule.options.error = options.error;
            }
            schema.validate(data.value, data.rule.options || options, function(errs) {
              var finalErrors = [];
              if (filledErrors && filledErrors.length) {
                finalErrors.push.apply(finalErrors, filledErrors);
              }
              if (errs && errs.length) {
                finalErrors.push.apply(finalErrors, errs);
              }
              doIt(finalErrors.length ? finalErrors : null);
            });
          }
        }
        var res;
        if (rule.asyncValidator) {
          res = rule.asyncValidator(rule, data.value, cb, data.source, options);
        } else if (rule.validator) {
          res = rule.validator(rule, data.value, cb, data.source, options);
          if (res === true) {
            cb();
          } else if (res === false) {
            cb(typeof rule.message === "function" ? rule.message(rule.fullField || rule.field) : rule.message || (rule.fullField || rule.field) + " fails");
          } else if (res instanceof Array) {
            cb(res);
          } else if (res instanceof Error) {
            cb(res.message);
          }
        }
        if (res && res.then) {
          res.then(function() {
            return cb();
          }, function(e) {
            return cb(e);
          });
        }
      }, function(results) {
        complete(results);
      }, source);
    };
    _proto.getType = function getType(rule) {
      if (rule.type === void 0 && rule.pattern instanceof RegExp) {
        rule.type = "pattern";
      }
      if (typeof rule.validator !== "function" && rule.type && !validators.hasOwnProperty(rule.type)) {
        throw new Error(format("Unknown rule type %s", rule.type));
      }
      return rule.type || "string";
    };
    _proto.getValidationMethod = function getValidationMethod(rule) {
      if (typeof rule.validator === "function") {
        return rule.validator;
      }
      var keys = Object.keys(rule);
      var messageIndex = keys.indexOf("message");
      if (messageIndex !== -1) {
        keys.splice(messageIndex, 1);
      }
      if (keys.length === 1 && keys[0] === "required") {
        return validators.required;
      }
      return validators[this.getType(rule)] || void 0;
    };
    return Schema2;
  }();
  Schema.register = function register(type4, validator) {
    if (typeof validator !== "function") {
      throw new Error("Cannot register a validator by type, validator is not a function");
    }
    validators[type4] = validator;
  };
  Schema.warning = warning;
  Schema.messages = messages;
  Schema.validators = validators;

  const formItemValidateStates = [
    "",
    "error",
    "validating",
    "success"
  ];
  const formItemProps = buildProps({
    label: String,
    labelWidth: {
      type: [String, Number],
      default: ""
    },
    prop: {
      type: definePropType([String, Array])
    },
    required: {
      type: Boolean,
      default: void 0
    },
    rules: {
      type: definePropType([Object, Array])
    },
    error: String,
    validateStatus: {
      type: String,
      values: formItemValidateStates
    },
    for: String,
    inlineMessage: {
      type: [String, Boolean],
      default: ""
    },
    showMessage: {
      type: Boolean,
      default: true
    },
    size: {
      type: String,
      values: componentSizes
    }
  });

  const COMPONENT_NAME$b = "ElLabelWrap";
  var FormLabelWrap = vue.defineComponent({
    name: COMPONENT_NAME$b,
    props: {
      isAutoWidth: Boolean,
      updateAll: Boolean
    },
    setup(props, {
      slots
    }) {
      const formContext = vue.inject(formContextKey);
      const formItemContext = vue.inject(formItemContextKey);
      if (!formContext || !formItemContext)
        throwError(COMPONENT_NAME$b, "usage: <el-form><el-form-item><label-wrap /></el-form-item></el-form>");
      const ns = useNamespace("form");
      const el = vue.ref();
      const computedWidth = vue.ref(0);
      const getLabelWidth = () => {
        var _a;
        if ((_a = el.value) == null ? void 0 : _a.firstElementChild) {
          const width = window.getComputedStyle(el.value.firstElementChild).width;
          return Math.ceil(Number.parseFloat(width));
        } else {
          return 0;
        }
      };
      const updateLabelWidth = (action = "update") => {
        vue.nextTick(() => {
          if (slots.default && props.isAutoWidth) {
            if (action === "update") {
              computedWidth.value = getLabelWidth();
            } else if (action === "remove") {
              formContext.deregisterLabelWidth(computedWidth.value);
            }
          }
        });
      };
      const updateLabelWidthFn = () => updateLabelWidth("update");
      vue.onMounted(() => {
        updateLabelWidthFn();
      });
      vue.onBeforeUnmount(() => {
        updateLabelWidth("remove");
      });
      vue.onUpdated(() => updateLabelWidthFn());
      vue.watch(computedWidth, (val, oldVal) => {
        if (props.updateAll) {
          formContext.registerLabelWidth(val, oldVal);
        }
      });
      useResizeObserver(vue.computed(() => {
        var _a, _b;
        return (_b = (_a = el.value) == null ? void 0 : _a.firstElementChild) != null ? _b : null;
      }), updateLabelWidthFn);
      return () => {
        var _a, _b;
        if (!slots)
          return null;
        const {
          isAutoWidth
        } = props;
        if (isAutoWidth) {
          const autoLabelWidth = formContext.autoLabelWidth;
          const style = {};
          if (autoLabelWidth && autoLabelWidth !== "auto") {
            const marginWidth = Math.max(0, Number.parseInt(autoLabelWidth, 10) - computedWidth.value);
            const marginPosition = formContext.labelPosition === "left" ? "marginRight" : "marginLeft";
            if (marginWidth) {
              style[marginPosition] = `${marginWidth}px`;
            }
          }
          return vue.createVNode("div", {
            "ref": el,
            "class": [ns.be("item", "label-wrap")],
            "style": style
          }, [(_a = slots.default) == null ? void 0 : _a.call(slots)]);
        } else {
          return vue.createVNode(vue.Fragment, {
            "ref": el
          }, [(_b = slots.default) == null ? void 0 : _b.call(slots)]);
        }
      };
    }
  });

  const _hoisted_1$u = ["for"];
  const __default__$6 = {
    name: "ElFormItem"
  };
  const _sfc_main$V = /* @__PURE__ */ vue.defineComponent({
    ...__default__$6,
    props: formItemProps,
    setup(__props, { expose }) {
      const props = __props;
      const COMPONENT_NAME = "ElFormItem";
      const slots = vue.useSlots();
      const formContext = vue.inject(formContextKey);
      if (!formContext)
        throwError(COMPONENT_NAME, "usage: <el-form><el-form-item /></el-form>");
      const parentFormItemContext = vue.inject(formItemContextKey, void 0);
      const _size = useSize(void 0, { formItem: false });
      const ns = useNamespace("form-item");
      const validateState = vue.ref("");
      const validateMessage = vue.ref("");
      const formItemRef = vue.ref();
      let initialValue = void 0;
      const labelStyle = vue.computed(() => {
        if (formContext.labelPosition === "top") {
          return {};
        }
        const labelWidth = addUnit(props.labelWidth || formContext.labelWidth || "");
        if (labelWidth)
          return { width: labelWidth };
        return {};
      });
      const contentStyle = vue.computed(() => {
        if (formContext.labelPosition === "top" || formContext.inline) {
          return {};
        }
        if (!props.label && !props.labelWidth && isNested) {
          return {};
        }
        const labelWidth = addUnit(props.labelWidth || formContext.labelWidth || "");
        if (!props.label && !slots.label) {
          return { marginLeft: labelWidth };
        }
        return {};
      });
      const formItemClasses = vue.computed(() => [
        ns.b(),
        ns.m(_size.value),
        ns.is("error", validateState.value === "error"),
        ns.is("validating", validateState.value === "validating"),
        ns.is("success", validateState.value === "success"),
        ns.is("required", isRequired.value || props.required),
        ns.is("no-asterisk", formContext.hideRequiredAsterisk),
        { [ns.m("feedback")]: formContext.statusIcon }
      ]);
      const _inlineMessage = vue.computed(() => isBoolean(props.inlineMessage) ? props.inlineMessage : formContext.inlineMessage || false);
      const validateClasses = vue.computed(() => [
        ns.e("error"),
        { [ns.em("error", "inline")]: _inlineMessage.value }
      ]);
      const propString = vue.computed(() => {
        if (!props.prop)
          return "";
        return isString(props.prop) ? props.prop : props.prop.join(".");
      });
      const labelFor = vue.computed(() => props.for || propString.value);
      const isNested = !!parentFormItemContext;
      const fieldValue = vue.computed(() => {
        const model = formContext.model;
        if (!model || !props.prop) {
          return;
        }
        return getProp(model, props.prop).value;
      });
      const _rules = vue.computed(() => {
        const rules = props.rules ? castArray$1(props.rules) : [];
        const formRules = formContext.rules;
        if (formRules && props.prop) {
          const _rules2 = getProp(formRules, props.prop).value;
          if (_rules2) {
            rules.push(...castArray$1(_rules2));
          }
        }
        if (props.required !== void 0) {
          rules.push({ required: !!props.required });
        }
        return rules;
      });
      const validateEnabled = vue.computed(() => _rules.value.length > 0);
      const getFilteredRule = (trigger) => {
        const rules = _rules.value;
        return rules.filter((rule) => {
          if (!rule.trigger || !trigger)
            return true;
          if (Array.isArray(rule.trigger)) {
            return rule.trigger.includes(trigger);
          } else {
            return rule.trigger === trigger;
          }
        }).map(({ trigger: trigger2, ...rule }) => rule);
      };
      const isRequired = vue.computed(() => _rules.value.some((rule) => rule.required === true));
      const shouldShowError = vue.computed(() => validateState.value === "error" && props.showMessage && formContext.showMessage);
      const currentLabel = vue.computed(() => `${props.label || ""}${formContext.labelSuffix || ""}`);
      const validate = async (trigger, callback) => {
        if (callback) {
          try {
            validate(trigger);
            callback(true);
          } catch (err) {
            callback(false, err);
          }
          validate(trigger).then(() => callback(true)).catch((fields) => callback(false, fields));
          return;
        }
        if (!validateEnabled.value) {
          return;
        }
        const rules = getFilteredRule(trigger);
        if (rules.length === 0) {
          return;
        }
        validateState.value = "validating";
        const descriptor = {
          [propString.value]: rules
        };
        const validator = new Schema(descriptor);
        const model = {
          [propString.value]: fieldValue.value
        };
        return validator.validate(model, { firstFields: true }).then(() => void 0).catch((err) => {
          const { errors, fields } = err;
          if (!errors || !fields)
            console.error(err);
          validateState.value = "error";
          validateMessage.value = errors ? errors[0].message || `${props.prop} is required` : "";
          formContext.emit("validate", props.prop, !errors, validateMessage.value);
          return Promise.reject(fields);
        });
      };
      const clearValidate = () => {
        validateState.value = "";
        validateMessage.value = "";
      };
      const resetField = () => {
        const model = formContext.model;
        if (!model || !props.prop)
          return;
        getProp(model, props.prop).value = initialValue;
        vue.nextTick(() => clearValidate());
      };
      vue.watch(() => props.error, (val) => {
        validateMessage.value = val || "";
        validateState.value = val ? "error" : "";
      }, { immediate: true });
      vue.watch(() => props.validateStatus, (val) => validateState.value = val || "");
      const context = vue.reactive({
        ...vue.toRefs(props),
        $el: formItemRef,
        size: _size,
        validateState,
        resetField,
        clearValidate,
        validate
      });
      vue.provide(formItemContextKey, context);
      vue.onMounted(() => {
        if (props.prop) {
          formContext.addField(context);
          initialValue = clone(fieldValue.value);
        }
      });
      vue.onBeforeUnmount(() => {
        formContext.removeField(context);
      });
      expose({
        size: _size,
        validateMessage,
        validate,
        clearValidate,
        resetField
      });
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          ref_key: "formItemRef",
          ref: formItemRef,
          class: vue.normalizeClass(vue.unref(formItemClasses))
        }, [
          vue.createVNode(vue.unref(FormLabelWrap), {
            "is-auto-width": vue.unref(labelStyle).width === "auto",
            "update-all": vue.unref(formContext).labelWidth === "auto"
          }, {
            default: vue.withCtx(() => [
              _ctx.label || _ctx.$slots.label ? (vue.openBlock(), vue.createElementBlock("label", {
                key: 0,
                for: vue.unref(labelFor),
                class: vue.normalizeClass(vue.unref(ns).e("label")),
                style: vue.normalizeStyle(vue.unref(labelStyle))
              }, [
                vue.renderSlot(_ctx.$slots, "label", { label: vue.unref(currentLabel) }, () => [
                  vue.createTextVNode(vue.toDisplayString(vue.unref(currentLabel)), 1)
                ])
              ], 14, _hoisted_1$u)) : vue.createCommentVNode("v-if", true)
            ]),
            _: 3
          }, 8, ["is-auto-width", "update-all"]),
          vue.createElementVNode("div", {
            class: vue.normalizeClass(vue.unref(ns).e("content")),
            style: vue.normalizeStyle(vue.unref(contentStyle))
          }, [
            vue.renderSlot(_ctx.$slots, "default"),
            vue.createVNode(vue.Transition, {
              name: `${vue.unref(ns).namespace.value}-zoom-in-top`
            }, {
              default: vue.withCtx(() => [
                vue.unref(shouldShowError) ? vue.renderSlot(_ctx.$slots, "error", {
                  key: 0,
                  error: validateMessage.value
                }, () => [
                  vue.createElementVNode("div", {
                    class: vue.normalizeClass(vue.unref(validateClasses))
                  }, vue.toDisplayString(validateMessage.value), 3)
                ]) : vue.createCommentVNode("v-if", true)
              ]),
              _: 3
            }, 8, ["name"])
          ], 6)
        ], 2);
      };
    }
  });
  var FormItem = _sfc_main$V;

  const ElForm = withInstall(Form, {
    FormItem
  });
  const ElFormItem = withNoopInstall(FormItem);

  const imageViewerProps = buildProps({
    urlList: {
      type: definePropType(Array),
      default: () => mutable([])
    },
    zIndex: {
      type: Number
    },
    initialIndex: {
      type: Number,
      default: 0
    },
    infinite: {
      type: Boolean,
      default: true
    },
    hideOnClickModal: {
      type: Boolean,
      default: false
    },
    teleported: {
      type: Boolean,
      default: false
    }
  });
  const imageViewerEmits = {
    close: () => true,
    switch: (index) => typeof index === "number"
  };

  const Mode = {
    CONTAIN: {
      name: "contain",
      icon: vue.markRaw(fullScreen)
    },
    ORIGINAL: {
      name: "original",
      icon: vue.markRaw(scaleToOriginal)
    }
  };
  const mousewheelEventName = isFirefox() ? "DOMMouseScroll" : "mousewheel";
  const _sfc_main$U = vue.defineComponent({
    name: "ElImageViewer",
    components: {
      ElIcon,
      Close: close$2,
      ArrowLeft: arrowLeft,
      ArrowRight: arrowRight,
      ZoomOut: zoomOut,
      ZoomIn: zoomIn,
      RefreshLeft: refreshLeft,
      RefreshRight: refreshRight
    },
    props: imageViewerProps,
    emits: imageViewerEmits,
    setup(props, { emit }) {
      const { t } = useLocale();
      const ns = useNamespace("image-viewer");
      const { nextZIndex } = useZIndex();
      const wrapper = vue.ref();
      const imgRefs = vue.ref([]);
      const scopeEventListener = vue.effectScope();
      const loading = vue.ref(true);
      const index = vue.ref(props.initialIndex);
      const mode = vue.ref(Mode.CONTAIN);
      const transform = vue.ref({
        scale: 1,
        deg: 0,
        offsetX: 0,
        offsetY: 0,
        enableTransition: false
      });
      const isSingle = vue.computed(() => {
        const { urlList } = props;
        return urlList.length <= 1;
      });
      const isFirst = vue.computed(() => {
        return index.value === 0;
      });
      const isLast = vue.computed(() => {
        return index.value === props.urlList.length - 1;
      });
      const currentImg = vue.computed(() => {
        return props.urlList[index.value];
      });
      const imgStyle = vue.computed(() => {
        const { scale, deg, offsetX, offsetY, enableTransition } = transform.value;
        let translateX = offsetX / scale;
        let translateY = offsetY / scale;
        switch (deg % 360) {
          case 90:
          case -270:
            [translateX, translateY] = [translateY, -translateX];
            break;
          case 180:
          case -180:
            [translateX, translateY] = [-translateX, -translateY];
            break;
          case 270:
          case -90:
            [translateX, translateY] = [-translateY, translateX];
            break;
        }
        const style = {
          transform: `scale(${scale}) rotate(${deg}deg) translate(${translateX}px, ${translateY}px)`,
          transition: enableTransition ? "transform .3s" : ""
        };
        if (mode.value.name === Mode.CONTAIN.name) {
          style.maxWidth = style.maxHeight = "100%";
        }
        return style;
      });
      const computedZIndex = vue.computed(() => {
        return isNumber(props.zIndex) ? props.zIndex : nextZIndex();
      });
      function hide() {
        unregisterEventListener();
        emit("close");
      }
      function registerEventListener() {
        const keydownHandler = throttle((e) => {
          switch (e.code) {
            case EVENT_CODE.esc:
              hide();
              break;
            case EVENT_CODE.space:
              toggleMode();
              break;
            case EVENT_CODE.left:
              prev();
              break;
            case EVENT_CODE.up:
              handleActions("zoomIn");
              break;
            case EVENT_CODE.right:
              next();
              break;
            case EVENT_CODE.down:
              handleActions("zoomOut");
              break;
          }
        });
        const mousewheelHandler = throttle((e) => {
          const delta = e.wheelDelta ? e.wheelDelta : -e.detail;
          if (delta > 0) {
            handleActions("zoomIn", {
              zoomRate: 1.2,
              enableTransition: false
            });
          } else {
            handleActions("zoomOut", {
              zoomRate: 1.2,
              enableTransition: false
            });
          }
        });
        scopeEventListener.run(() => {
          useEventListener(document, "keydown", keydownHandler);
          useEventListener(document, mousewheelEventName, mousewheelHandler);
        });
      }
      function unregisterEventListener() {
        scopeEventListener.stop();
      }
      function handleImgLoad() {
        loading.value = false;
      }
      function handleImgError(e) {
        loading.value = false;
        e.target.alt = t("el.image.error");
      }
      function handleMouseDown(e) {
        if (loading.value || e.button !== 0 || !wrapper.value)
          return;
        transform.value.enableTransition = false;
        const { offsetX, offsetY } = transform.value;
        const startX = e.pageX;
        const startY = e.pageY;
        const dragHandler = throttle((ev) => {
          transform.value = {
            ...transform.value,
            offsetX: offsetX + ev.pageX - startX,
            offsetY: offsetY + ev.pageY - startY
          };
        });
        const removeMousemove = useEventListener(document, "mousemove", dragHandler);
        useEventListener(document, "mouseup", () => {
          removeMousemove();
        });
        e.preventDefault();
      }
      function reset() {
        transform.value = {
          scale: 1,
          deg: 0,
          offsetX: 0,
          offsetY: 0,
          enableTransition: false
        };
      }
      function toggleMode() {
        if (loading.value)
          return;
        const modeNames = Object.keys(Mode);
        const modeValues = Object.values(Mode);
        const currentMode = mode.value.name;
        const index2 = modeValues.findIndex((i) => i.name === currentMode);
        const nextIndex = (index2 + 1) % modeNames.length;
        mode.value = Mode[modeNames[nextIndex]];
        reset();
      }
      function prev() {
        if (isFirst.value && !props.infinite)
          return;
        const len = props.urlList.length;
        index.value = (index.value - 1 + len) % len;
      }
      function next() {
        if (isLast.value && !props.infinite)
          return;
        const len = props.urlList.length;
        index.value = (index.value + 1) % len;
      }
      function handleActions(action, options = {}) {
        if (loading.value)
          return;
        const { zoomRate, rotateDeg, enableTransition } = {
          zoomRate: 1.4,
          rotateDeg: 90,
          enableTransition: true,
          ...options
        };
        switch (action) {
          case "zoomOut":
            if (transform.value.scale > 0.2) {
              transform.value.scale = Number.parseFloat((transform.value.scale / zoomRate).toFixed(3));
            }
            break;
          case "zoomIn":
            if (transform.value.scale < 7) {
              transform.value.scale = Number.parseFloat((transform.value.scale * zoomRate).toFixed(3));
            }
            break;
          case "clockwise":
            transform.value.deg += rotateDeg;
            break;
          case "anticlockwise":
            transform.value.deg -= rotateDeg;
            break;
        }
        transform.value.enableTransition = enableTransition;
      }
      vue.watch(currentImg, () => {
        vue.nextTick(() => {
          const $img = imgRefs.value[0];
          if (!($img == null ? void 0 : $img.complete)) {
            loading.value = true;
          }
        });
      });
      vue.watch(index, (val) => {
        reset();
        emit("switch", val);
      });
      vue.onMounted(() => {
        var _a, _b;
        registerEventListener();
        (_b = (_a = wrapper.value) == null ? void 0 : _a.focus) == null ? void 0 : _b.call(_a);
      });
      return {
        index,
        wrapper,
        imgRefs,
        isSingle,
        isFirst,
        isLast,
        currentImg,
        imgStyle,
        mode,
        computedZIndex,
        handleActions,
        prev,
        next,
        hide,
        toggleMode,
        handleImgLoad,
        handleImgError,
        handleMouseDown,
        ns
      };
    }
  });
  const _hoisted_1$t = ["src"];
  function _sfc_render$L(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_close = vue.resolveComponent("close");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_arrow_left = vue.resolveComponent("arrow-left");
    const _component_arrow_right = vue.resolveComponent("arrow-right");
    const _component_zoom_out = vue.resolveComponent("zoom-out");
    const _component_zoom_in = vue.resolveComponent("zoom-in");
    const _component_refresh_left = vue.resolveComponent("refresh-left");
    const _component_refresh_right = vue.resolveComponent("refresh-right");
    return vue.openBlock(), vue.createBlock(vue.Teleport, {
      to: "body",
      disabled: !_ctx.teleported
    }, [
      vue.createVNode(vue.Transition, {
        name: "viewer-fade",
        appear: ""
      }, {
        default: vue.withCtx(() => [
          vue.createElementVNode("div", {
            ref: "wrapper",
            tabindex: -1,
            class: vue.normalizeClass(_ctx.ns.e("wrapper")),
            style: vue.normalizeStyle({ zIndex: _ctx.computedZIndex })
          }, [
            vue.createElementVNode("div", {
              class: vue.normalizeClass(_ctx.ns.e("mask")),
              onClick: _cache[0] || (_cache[0] = vue.withModifiers(($event) => _ctx.hideOnClickModal && _ctx.hide(), ["self"]))
            }, null, 2),
            vue.createCommentVNode(" CLOSE "),
            vue.createElementVNode("span", {
              class: vue.normalizeClass([_ctx.ns.e("btn"), _ctx.ns.e("close")]),
              onClick: _cache[1] || (_cache[1] = (...args) => _ctx.hide && _ctx.hide(...args))
            }, [
              vue.createVNode(_component_el_icon, null, {
                default: vue.withCtx(() => [
                  vue.createVNode(_component_close)
                ]),
                _: 1
              })
            ], 2),
            vue.createCommentVNode(" ARROW "),
            !_ctx.isSingle ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
              vue.createElementVNode("span", {
                class: vue.normalizeClass([
                  _ctx.ns.e("btn"),
                  _ctx.ns.e("prev"),
                  _ctx.ns.is("disabled", !_ctx.infinite && _ctx.isFirst)
                ]),
                onClick: _cache[2] || (_cache[2] = (...args) => _ctx.prev && _ctx.prev(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_left)
                  ]),
                  _: 1
                })
              ], 2),
              vue.createElementVNode("span", {
                class: vue.normalizeClass([
                  _ctx.ns.e("btn"),
                  _ctx.ns.e("next"),
                  _ctx.ns.is("disabled", !_ctx.infinite && _ctx.isLast)
                ]),
                onClick: _cache[3] || (_cache[3] = (...args) => _ctx.next && _ctx.next(...args))
              }, [
                vue.createVNode(_component_el_icon, null, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_arrow_right)
                  ]),
                  _: 1
                })
              ], 2)
            ], 64)) : vue.createCommentVNode("v-if", true),
            vue.createCommentVNode(" ACTIONS "),
            vue.createElementVNode("div", {
              class: vue.normalizeClass([_ctx.ns.e("btn"), _ctx.ns.e("actions")])
            }, [
              vue.createElementVNode("div", {
                class: vue.normalizeClass(_ctx.ns.e("actions__inner"))
              }, [
                vue.createVNode(_component_el_icon, {
                  onClick: _cache[4] || (_cache[4] = ($event) => _ctx.handleActions("zoomOut"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_zoom_out)
                  ]),
                  _: 1
                }),
                vue.createVNode(_component_el_icon, {
                  onClick: _cache[5] || (_cache[5] = ($event) => _ctx.handleActions("zoomIn"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_zoom_in)
                  ]),
                  _: 1
                }),
                vue.createElementVNode("i", {
                  class: vue.normalizeClass(_ctx.ns.e("actions__divider"))
                }, null, 2),
                vue.createVNode(_component_el_icon, { onClick: _ctx.toggleMode }, {
                  default: vue.withCtx(() => [
                    (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.mode.icon)))
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                vue.createElementVNode("i", {
                  class: vue.normalizeClass(_ctx.ns.e("actions__divider"))
                }, null, 2),
                vue.createVNode(_component_el_icon, {
                  onClick: _cache[6] || (_cache[6] = ($event) => _ctx.handleActions("anticlockwise"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_refresh_left)
                  ]),
                  _: 1
                }),
                vue.createVNode(_component_el_icon, {
                  onClick: _cache[7] || (_cache[7] = ($event) => _ctx.handleActions("clockwise"))
                }, {
                  default: vue.withCtx(() => [
                    vue.createVNode(_component_refresh_right)
                  ]),
                  _: 1
                })
              ], 2)
            ], 2),
            vue.createCommentVNode(" CANVAS "),
            vue.createElementVNode("div", {
              class: vue.normalizeClass(_ctx.ns.e("canvas"))
            }, [
              (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.urlList, (url, i) => {
                return vue.withDirectives((vue.openBlock(), vue.createElementBlock("img", {
                  ref_for: true,
                  ref: (el) => _ctx.imgRefs[i] = el,
                  key: url,
                  src: url,
                  style: vue.normalizeStyle(_ctx.imgStyle),
                  class: vue.normalizeClass(_ctx.ns.e("img")),
                  onLoad: _cache[8] || (_cache[8] = (...args) => _ctx.handleImgLoad && _ctx.handleImgLoad(...args)),
                  onError: _cache[9] || (_cache[9] = (...args) => _ctx.handleImgError && _ctx.handleImgError(...args)),
                  onMousedown: _cache[10] || (_cache[10] = (...args) => _ctx.handleMouseDown && _ctx.handleMouseDown(...args))
                }, null, 46, _hoisted_1$t)), [
                  [vue.vShow, i === _ctx.index]
                ]);
              }), 128))
            ], 2),
            vue.renderSlot(_ctx.$slots, "default")
          ], 6)
        ]),
        _: 3
      })
    ], 8, ["disabled"]);
  }
  var ImageViewer = /* @__PURE__ */ _export_sfc(_sfc_main$U, [["render", _sfc_render$L]]);

  const ElImageViewer = withInstall(ImageViewer);

  const imageProps = buildProps({
    appendToBody: {
      type: Boolean,
      default: void 0
    },
    hideOnClickModal: {
      type: Boolean,
      default: false
    },
    src: {
      type: String,
      default: ""
    },
    fit: {
      type: String,
      values: ["", "contain", "cover", "fill", "none", "scale-down"],
      default: ""
    },
    lazy: {
      type: Boolean,
      default: false
    },
    scrollContainer: {
      type: definePropType([String, Object])
    },
    previewSrcList: {
      type: definePropType(Array),
      default: () => mutable([])
    },
    previewTeleported: {
      type: Boolean,
      default: false
    },
    zIndex: {
      type: Number
    },
    initialIndex: {
      type: Number,
      default: 0
    }
  });
  const imageEmits = {
    error: (evt) => evt instanceof Event,
    switch: (val) => isNumber(val),
    close: () => true
  };

  let prevOverflow = "";
  const _sfc_main$T = vue.defineComponent({
    name: "ElImage",
    components: {
      ImageViewer: ElImageViewer
    },
    inheritAttrs: false,
    props: imageProps,
    emits: imageEmits,
    setup(props, { emit, attrs: rawAttrs }) {
      useDeprecated({
        scope: "el-image",
        from: "append-to-body",
        replacement: "preview-teleported",
        version: "2.2.0",
        ref: "https://element-plus.org/en-US/component/image.html#image-attributess"
      }, vue.computed(() => isBoolean(props.appendToBody)));
      const { t } = useLocale();
      const ns = useNamespace("image");
      const attrs = useAttrs();
      const hasLoadError = vue.ref(false);
      const loading = vue.ref(true);
      const imgWidth = vue.ref(0);
      const imgHeight = vue.ref(0);
      const showViewer = vue.ref(false);
      const container = vue.ref();
      const _scrollContainer = vue.ref();
      let stopScrollListener;
      let stopWheelListener;
      const containerStyle = vue.computed(() => rawAttrs.style);
      const imageStyle = vue.computed(() => {
        const { fit } = props;
        if (isClient && fit) {
          return { objectFit: fit };
        }
        return {};
      });
      const preview = vue.computed(() => {
        const { previewSrcList } = props;
        return Array.isArray(previewSrcList) && previewSrcList.length > 0;
      });
      const teleported = vue.computed(() => {
        return props.appendToBody || props.previewTeleported;
      });
      const imageIndex = vue.computed(() => {
        const { previewSrcList, initialIndex } = props;
        let previewIndex = initialIndex;
        if (initialIndex > previewSrcList.length - 1) {
          previewIndex = 0;
        }
        return previewIndex;
      });
      const loadImage = () => {
        if (!isClient)
          return;
        loading.value = true;
        hasLoadError.value = false;
        const img = new Image();
        const currentImageSrc = props.src;
        img.addEventListener("load", (e) => {
          if (currentImageSrc !== props.src) {
            return;
          }
          handleLoad(e, img);
        });
        img.addEventListener("error", (e) => {
          if (currentImageSrc !== props.src) {
            return;
          }
          handleError(e);
        });
        Object.entries(attrs.value).forEach(([key, value]) => {
          if (key.toLowerCase() === "onload")
            return;
          img.setAttribute(key, value);
        });
        img.src = currentImageSrc;
      };
      function handleLoad(e, img) {
        imgWidth.value = img.width;
        imgHeight.value = img.height;
        loading.value = false;
        hasLoadError.value = false;
      }
      function handleError(event) {
        loading.value = false;
        hasLoadError.value = true;
        emit("error", event);
      }
      function handleLazyLoad() {
        if (isInContainer(container.value, _scrollContainer.value)) {
          loadImage();
          removeLazyLoadListener();
        }
      }
      const lazyLoadHandler = useThrottleFn(handleLazyLoad, 200);
      async function addLazyLoadListener() {
        var _a;
        if (!isClient)
          return;
        await vue.nextTick();
        const { scrollContainer } = props;
        if (isElement$1(scrollContainer)) {
          _scrollContainer.value = scrollContainer;
        } else if (isString(scrollContainer) && scrollContainer !== "") {
          _scrollContainer.value = (_a = document.querySelector(scrollContainer)) != null ? _a : void 0;
        } else if (container.value) {
          _scrollContainer.value = getScrollContainer(container.value);
        }
        if (_scrollContainer.value) {
          stopScrollListener = useEventListener(_scrollContainer, "scroll", lazyLoadHandler);
          setTimeout(() => handleLazyLoad(), 100);
        }
      }
      function removeLazyLoadListener() {
        if (!isClient || !_scrollContainer.value || !lazyLoadHandler)
          return;
        stopScrollListener();
        _scrollContainer.value = void 0;
      }
      function wheelHandler(e) {
        if (!e.ctrlKey)
          return;
        if (e.deltaY < 0) {
          e.preventDefault();
          return false;
        } else if (e.deltaY > 0) {
          e.preventDefault();
          return false;
        }
      }
      function clickHandler() {
        if (!preview.value)
          return;
        stopWheelListener = useEventListener("wheel", wheelHandler, {
          passive: false
        });
        prevOverflow = document.body.style.overflow;
        document.body.style.overflow = "hidden";
        showViewer.value = true;
      }
      function closeViewer() {
        stopWheelListener == null ? void 0 : stopWheelListener();
        document.body.style.overflow = prevOverflow;
        showViewer.value = false;
        emit("close");
      }
      function switchViewer(val) {
        emit("switch", val);
      }
      vue.watch(() => props.src, () => {
        if (props.lazy) {
          loading.value = true;
          hasLoadError.value = false;
          removeLazyLoadListener();
          addLazyLoadListener();
        } else {
          loadImage();
        }
      });
      vue.onMounted(() => {
        if (props.lazy) {
          addLazyLoadListener();
        } else {
          loadImage();
        }
      });
      return {
        attrs,
        loading,
        hasLoadError,
        showViewer,
        containerStyle,
        imageStyle,
        preview,
        imageIndex,
        container,
        ns,
        teleported,
        clickHandler,
        closeViewer,
        switchViewer,
        t
      };
    }
  });
  const _hoisted_1$s = ["src"];
  const _hoisted_2$j = { key: 0 };
  function _sfc_render$K(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_image_viewer = vue.resolveComponent("image-viewer");
    return vue.openBlock(), vue.createElementBlock("div", {
      ref: "container",
      class: vue.normalizeClass([_ctx.ns.b(), _ctx.$attrs.class]),
      style: vue.normalizeStyle(_ctx.containerStyle)
    }, [
      _ctx.loading ? vue.renderSlot(_ctx.$slots, "placeholder", { key: 0 }, () => [
        vue.createElementVNode("div", {
          class: vue.normalizeClass(_ctx.ns.e("placeholder"))
        }, null, 2)
      ]) : _ctx.hasLoadError ? vue.renderSlot(_ctx.$slots, "error", { key: 1 }, () => [
        vue.createElementVNode("div", {
          class: vue.normalizeClass(_ctx.ns.e("error"))
        }, vue.toDisplayString(_ctx.t("el.image.error")), 3)
      ]) : (vue.openBlock(), vue.createElementBlock("img", vue.mergeProps({ key: 2 }, _ctx.attrs, {
        src: _ctx.src,
        style: _ctx.imageStyle,
        class: [_ctx.ns.e("inner"), _ctx.preview ? _ctx.ns.e("preview") : ""],
        onClick: _cache[0] || (_cache[0] = (...args) => _ctx.clickHandler && _ctx.clickHandler(...args))
      }), null, 16, _hoisted_1$s)),
      _ctx.preview ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 3 }, [
        _ctx.showViewer ? (vue.openBlock(), vue.createBlock(_component_image_viewer, {
          key: 0,
          "z-index": _ctx.zIndex,
          "initial-index": _ctx.imageIndex,
          "url-list": _ctx.previewSrcList,
          "hide-on-click-modal": _ctx.hideOnClickModal,
          teleported: _ctx.teleported,
          onClose: _ctx.closeViewer,
          onSwitch: _ctx.switchViewer
        }, {
          default: vue.withCtx(() => [
            _ctx.$slots.viewer ? (vue.openBlock(), vue.createElementBlock("div", _hoisted_2$j, [
              vue.renderSlot(_ctx.$slots, "viewer")
            ])) : vue.createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 8, ["z-index", "initial-index", "url-list", "hide-on-click-modal", "teleported", "onClose", "onSwitch"])) : vue.createCommentVNode("v-if", true)
      ], 2112)) : vue.createCommentVNode("v-if", true)
    ], 6);
  }
  var Image$1 = /* @__PURE__ */ _export_sfc(_sfc_main$T, [["render", _sfc_render$K]]);

  const ElImage = withInstall(Image$1);

  const inputNumberProps = buildProps({
    step: {
      type: Number,
      default: 1
    },
    stepStrictly: {
      type: Boolean,
      default: false
    },
    max: {
      type: Number,
      default: Number.POSITIVE_INFINITY
    },
    min: {
      type: Number,
      default: Number.NEGATIVE_INFINITY
    },
    modelValue: {
      type: Number
    },
    disabled: {
      type: Boolean,
      default: false
    },
    size: {
      type: String,
      values: componentSizes
    },
    controls: {
      type: Boolean,
      default: true
    },
    controlsPosition: {
      type: String,
      default: "",
      values: ["", "right"]
    },
    name: String,
    label: String,
    placeholder: String,
    precision: {
      type: Number,
      validator: (val) => val >= 0 && val === Number.parseInt(`${val}`, 10)
    }
  });
  const inputNumberEmits = {
    change: (prev, cur) => prev !== cur,
    blur: (e) => e instanceof FocusEvent,
    focus: (e) => e instanceof FocusEvent,
    input: (val) => isNumber(val),
    "update:modelValue": (val) => isNumber(val) || val === void 0
  };

  const _sfc_main$S = vue.defineComponent({
    name: "ElInputNumber",
    components: {
      ElInput,
      ElIcon,
      ArrowUp: arrowUp,
      ArrowDown: arrowDown,
      Plus: plus,
      Minus: minus
    },
    directives: {
      RepeatClick
    },
    props: inputNumberProps,
    emits: inputNumberEmits,
    setup(props, { emit }) {
      const input = vue.ref();
      const data = vue.reactive({
        currentValue: props.modelValue,
        userInput: null
      });
      const { formItem } = useFormItem();
      const ns = useNamespace("input-number");
      const minDisabled = vue.computed(() => _decrease(props.modelValue) < props.min);
      const maxDisabled = vue.computed(() => _increase(props.modelValue) > props.max);
      const numPrecision = vue.computed(() => {
        const stepPrecision = getPrecision(props.step);
        if (props.precision !== void 0) {
          if (stepPrecision > props.precision) ;
          return props.precision;
        } else {
          return Math.max(getPrecision(props.modelValue), stepPrecision);
        }
      });
      const controlsAtRight = vue.computed(() => {
        return props.controls && props.controlsPosition === "right";
      });
      const inputNumberSize = useSize();
      const inputNumberDisabled = useDisabled$1();
      const displayValue = vue.computed(() => {
        if (data.userInput !== null) {
          return data.userInput;
        }
        let currentValue = data.currentValue;
        if (isNumber(currentValue)) {
          if (Number.isNaN(currentValue))
            return "";
          if (props.precision !== void 0) {
            currentValue = currentValue.toFixed(props.precision);
          }
        }
        return currentValue;
      });
      const toPrecision = (num, pre) => {
        if (pre === void 0)
          pre = numPrecision.value;
        return Number.parseFloat(`${Math.round(num * 10 ** pre) / 10 ** pre}`);
      };
      const getPrecision = (value) => {
        if (value === void 0)
          return 0;
        const valueString = value.toString();
        const dotPosition = valueString.indexOf(".");
        let precision = 0;
        if (dotPosition !== -1) {
          precision = valueString.length - dotPosition - 1;
        }
        return precision;
      };
      const _increase = (val) => {
        if (!isNumber(val))
          return data.currentValue;
        const precisionFactor = 10 ** numPrecision.value;
        val = isNumber(val) ? val : Number.NaN;
        return toPrecision((precisionFactor * val + precisionFactor * props.step) / precisionFactor);
      };
      const _decrease = (val) => {
        if (!isNumber(val))
          return data.currentValue;
        const precisionFactor = 10 ** numPrecision.value;
        val = isNumber(val) ? val : Number.NaN;
        return toPrecision((precisionFactor * val - precisionFactor * props.step) / precisionFactor);
      };
      const increase = () => {
        if (inputNumberDisabled.value || maxDisabled.value)
          return;
        const value = props.modelValue || 0;
        const newVal = _increase(value);
        setCurrentValue(newVal);
      };
      const decrease = () => {
        if (inputNumberDisabled.value || minDisabled.value)
          return;
        const value = props.modelValue || 0;
        const newVal = _decrease(value);
        setCurrentValue(newVal);
      };
      const setCurrentValue = (newVal) => {
        var _a;
        const oldVal = data.currentValue;
        if (typeof newVal === "number" && props.precision !== void 0) {
          newVal = toPrecision(newVal, props.precision);
        }
        if (newVal !== void 0 && newVal >= props.max)
          newVal = props.max;
        if (newVal !== void 0 && newVal <= props.min)
          newVal = props.min;
        if (oldVal === newVal)
          return;
        if (!isNumber(newVal)) {
          newVal = void 0;
        }
        data.userInput = null;
        emit("update:modelValue", newVal);
        emit("input", newVal);
        emit("change", newVal, oldVal);
        (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "change").catch((err) => debugWarn());
        data.currentValue = newVal;
      };
      const handleInput = (value) => {
        return data.userInput = value;
      };
      const handleInputChange = (value) => {
        const newVal = value !== "" ? Number(value) : "";
        if (isNumber(newVal) && !Number.isNaN(newVal) || value === "") {
          setCurrentValue(newVal);
        }
        data.userInput = null;
      };
      const focus = () => {
        var _a, _b;
        (_b = (_a = input.value) == null ? void 0 : _a.focus) == null ? void 0 : _b.call(_a);
      };
      const blur = () => {
        var _a, _b;
        (_b = (_a = input.value) == null ? void 0 : _a.blur) == null ? void 0 : _b.call(_a);
      };
      const handleFocus = (event) => {
        emit("focus", event);
      };
      const handleBlur = (event) => {
        var _a;
        emit("blur", event);
        (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "blur").catch((err) => debugWarn());
      };
      vue.watch(() => props.modelValue, (value) => {
        let newVal = Number(value);
        if (value === null) {
          newVal = Number.NaN;
        }
        if (!Number.isNaN(newVal)) {
          if (props.stepStrictly) {
            const stepPrecision = getPrecision(props.step);
            const precisionFactor = 10 ** stepPrecision;
            newVal = Math.round(newVal / props.step) * precisionFactor * props.step / precisionFactor;
          }
          if (props.precision !== void 0) {
            newVal = toPrecision(newVal, props.precision);
          }
          if (newVal > props.max) {
            newVal = props.max;
            emit("update:modelValue", newVal);
          }
          if (newVal < props.min) {
            newVal = props.min;
            emit("update:modelValue", newVal);
          }
        }
        data.currentValue = newVal;
        data.userInput = null;
      }, { immediate: true });
      vue.onMounted(() => {
        var _a;
        const innerInput = (_a = input.value) == null ? void 0 : _a.input;
        innerInput.setAttribute("role", "spinbutton");
        innerInput.setAttribute("aria-valuemax", String(props.max));
        innerInput.setAttribute("aria-valuemin", String(props.min));
        innerInput.setAttribute("aria-valuenow", String(data.currentValue));
        innerInput.setAttribute("aria-disabled", String(inputNumberDisabled.value));
        if (!isNumber(props.modelValue)) {
          let val = Number(props.modelValue);
          if (Number.isNaN(val)) {
            val = void 0;
          }
          emit("update:modelValue", val);
        }
      });
      vue.onUpdated(() => {
        var _a;
        const innerInput = (_a = input.value) == null ? void 0 : _a.input;
        innerInput == null ? void 0 : innerInput.setAttribute("aria-valuenow", data.currentValue);
      });
      return {
        input,
        displayValue,
        handleInput,
        handleInputChange,
        controlsAtRight,
        decrease,
        increase,
        inputNumberSize,
        inputNumberDisabled,
        maxDisabled,
        minDisabled,
        focus,
        blur,
        handleFocus,
        handleBlur,
        ns
      };
    }
  });
  function _sfc_render$J(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_arrow_down = vue.resolveComponent("arrow-down");
    const _component_minus = vue.resolveComponent("minus");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_arrow_up = vue.resolveComponent("arrow-up");
    const _component_plus = vue.resolveComponent("plus");
    const _component_el_input = vue.resolveComponent("el-input");
    const _directive_repeat_click = vue.resolveDirective("repeat-click");
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([
        _ctx.ns.b(),
        _ctx.ns.m(_ctx.inputNumberSize),
        _ctx.ns.is("disabled", _ctx.inputNumberDisabled),
        _ctx.ns.is("without-controls", !_ctx.controls),
        _ctx.ns.is("controls-right", _ctx.controlsAtRight)
      ]),
      onDragstart: _cache[2] || (_cache[2] = vue.withModifiers(() => {
      }, ["prevent"]))
    }, [
      _ctx.controls ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("span", {
        key: 0,
        role: "button",
        class: vue.normalizeClass([_ctx.ns.e("decrease"), _ctx.ns.is("disabled", _ctx.minDisabled)]),
        onKeydown: _cache[0] || (_cache[0] = vue.withKeys((...args) => _ctx.decrease && _ctx.decrease(...args), ["enter"]))
      }, [
        vue.createVNode(_component_el_icon, null, {
          default: vue.withCtx(() => [
            _ctx.controlsAtRight ? (vue.openBlock(), vue.createBlock(_component_arrow_down, { key: 0 })) : (vue.openBlock(), vue.createBlock(_component_minus, { key: 1 }))
          ]),
          _: 1
        })
      ], 34)), [
        [_directive_repeat_click, _ctx.decrease]
      ]) : vue.createCommentVNode("v-if", true),
      _ctx.controls ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("span", {
        key: 1,
        role: "button",
        class: vue.normalizeClass([_ctx.ns.e("increase"), _ctx.ns.is("disabled", _ctx.maxDisabled)]),
        onKeydown: _cache[1] || (_cache[1] = vue.withKeys((...args) => _ctx.increase && _ctx.increase(...args), ["enter"]))
      }, [
        vue.createVNode(_component_el_icon, null, {
          default: vue.withCtx(() => [
            _ctx.controlsAtRight ? (vue.openBlock(), vue.createBlock(_component_arrow_up, { key: 0 })) : (vue.openBlock(), vue.createBlock(_component_plus, { key: 1 }))
          ]),
          _: 1
        })
      ], 34)), [
        [_directive_repeat_click, _ctx.increase]
      ]) : vue.createCommentVNode("v-if", true),
      vue.createVNode(_component_el_input, {
        ref: "input",
        type: "number",
        step: _ctx.step,
        "model-value": _ctx.displayValue,
        placeholder: _ctx.placeholder,
        disabled: _ctx.inputNumberDisabled,
        size: _ctx.inputNumberSize,
        max: _ctx.max,
        min: _ctx.min,
        name: _ctx.name,
        label: _ctx.label,
        "validate-event": false,
        onKeydown: [
          vue.withKeys(vue.withModifiers(_ctx.increase, ["prevent"]), ["up"]),
          vue.withKeys(vue.withModifiers(_ctx.decrease, ["prevent"]), ["down"])
        ],
        onBlur: _ctx.handleBlur,
        onFocus: _ctx.handleFocus,
        onInput: _ctx.handleInput,
        onChange: _ctx.handleInputChange
      }, null, 8, ["step", "model-value", "placeholder", "disabled", "size", "max", "min", "name", "label", "onKeydown", "onBlur", "onFocus", "onInput", "onChange"])
    ], 34);
  }
  var InputNumber = /* @__PURE__ */ _export_sfc(_sfc_main$S, [["render", _sfc_render$J]]);

  const ElInputNumber = withInstall(InputNumber);

  const linkProps = buildProps({
    type: {
      type: String,
      values: ["primary", "success", "warning", "info", "danger", "default"],
      default: "default"
    },
    underline: {
      type: Boolean,
      default: true
    },
    disabled: { type: Boolean, default: false },
    href: { type: String, default: "" },
    icon: {
      type: iconPropType,
      default: ""
    }
  });
  const linkEmits = {
    click: (evt) => evt instanceof MouseEvent
  };

  const _hoisted_1$r = ["href"];
  const __default__$5 = {
    name: "ElLink"
  };
  const _sfc_main$R = /* @__PURE__ */ vue.defineComponent({
    ...__default__$5,
    props: linkProps,
    emits: linkEmits,
    setup(__props, { emit }) {
      const props = __props;
      const ns = useNamespace("link");
      function handleClick(event) {
        if (!props.disabled)
          emit("click", event);
      }
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("a", {
          class: vue.normalizeClass([
            vue.unref(ns).b(),
            vue.unref(ns).m(_ctx.type),
            vue.unref(ns).is("disabled", _ctx.disabled),
            vue.unref(ns).is("underline", _ctx.underline && !_ctx.disabled)
          ]),
          href: _ctx.disabled || !_ctx.href ? void 0 : _ctx.href,
          onClick: handleClick
        }, [
          _ctx.icon ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), { key: 0 }, {
            default: vue.withCtx(() => [
              (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.icon)))
            ]),
            _: 1
          })) : vue.createCommentVNode("v-if", true),
          _ctx.$slots.default ? (vue.openBlock(), vue.createElementBlock("span", {
            key: 1,
            class: vue.normalizeClass(vue.unref(ns).e("inner"))
          }, [
            vue.renderSlot(_ctx.$slots, "default")
          ], 2)) : vue.createCommentVNode("v-if", true),
          _ctx.$slots.icon ? vue.renderSlot(_ctx.$slots, "icon", { key: 2 }) : vue.createCommentVNode("v-if", true)
        ], 10, _hoisted_1$r);
      };
    }
  });
  var Link = _sfc_main$R;

  const ElLink = withInstall(Link);

  class SubMenu$1 {
    constructor(parent, domNode) {
      this.parent = parent;
      this.domNode = domNode;
      this.subIndex = 0;
      this.subIndex = 0;
      this.init();
    }
    init() {
      this.subMenuItems = this.domNode.querySelectorAll("li");
      this.addListeners();
    }
    gotoSubIndex(idx) {
      if (idx === this.subMenuItems.length) {
        idx = 0;
      } else if (idx < 0) {
        idx = this.subMenuItems.length - 1;
      }
      this.subMenuItems[idx].focus();
      this.subIndex = idx;
    }
    addListeners() {
      const parentNode = this.parent.domNode;
      Array.prototype.forEach.call(this.subMenuItems, (el) => {
        el.addEventListener("keydown", (event) => {
          let prevDef = false;
          switch (event.code) {
            case EVENT_CODE.down: {
              this.gotoSubIndex(this.subIndex + 1);
              prevDef = true;
              break;
            }
            case EVENT_CODE.up: {
              this.gotoSubIndex(this.subIndex - 1);
              prevDef = true;
              break;
            }
            case EVENT_CODE.tab: {
              triggerEvent(parentNode, "mouseleave");
              break;
            }
            case EVENT_CODE.enter:
            case EVENT_CODE.space: {
              prevDef = true;
              event.currentTarget.click();
              break;
            }
          }
          if (prevDef) {
            event.preventDefault();
            event.stopPropagation();
          }
          return false;
        });
      });
    }
  }
  var SubMenu$2 = SubMenu$1;

  class MenuItem$1 {
    constructor(domNode) {
      this.domNode = domNode;
      this.submenu = null;
      this.submenu = null;
      this.init();
    }
    init() {
      this.domNode.setAttribute("tabindex", "0");
      const menuChild = this.domNode.querySelector(".el-menu");
      if (menuChild) {
        this.submenu = new SubMenu$2(this, menuChild);
      }
      this.addListeners();
    }
    addListeners() {
      this.domNode.addEventListener("keydown", (event) => {
        let prevDef = false;
        switch (event.code) {
          case EVENT_CODE.down: {
            triggerEvent(event.currentTarget, "mouseenter");
            this.submenu && this.submenu.gotoSubIndex(0);
            prevDef = true;
            break;
          }
          case EVENT_CODE.up: {
            triggerEvent(event.currentTarget, "mouseenter");
            this.submenu && this.submenu.gotoSubIndex(this.submenu.subMenuItems.length - 1);
            prevDef = true;
            break;
          }
          case EVENT_CODE.tab: {
            triggerEvent(event.currentTarget, "mouseleave");
            break;
          }
          case EVENT_CODE.enter:
          case EVENT_CODE.space: {
            prevDef = true;
            event.currentTarget.click();
            break;
          }
        }
        if (prevDef) {
          event.preventDefault();
        }
      });
    }
  }
  var MenuItem$2 = MenuItem$1;

  class Menu$1 {
    constructor(domNode) {
      this.domNode = domNode;
      this.init();
    }
    init() {
      const menuChildren = this.domNode.childNodes;
      Array.from(menuChildren).forEach((child) => {
        if (child.nodeType === 1) {
          new MenuItem$2(child);
        }
      });
    }
  }
  var Menubar = Menu$1;

  const _sfc_main$Q = vue.defineComponent({
    name: "ElMenuCollapseTransition",
    setup() {
      const listeners = {
        onBeforeEnter: (el) => el.style.opacity = "0.2",
        onEnter(el, done) {
          addClass(el, "el-opacity-transition");
          el.style.opacity = "1";
          done();
        },
        onAfterEnter(el) {
          removeClass(el, "el-opacity-transition");
          el.style.opacity = "";
        },
        onBeforeLeave(el) {
          if (!el.dataset) {
            el.dataset = {};
          }
          if (hasClass(el, "el-menu--collapse")) {
            removeClass(el, "el-menu--collapse");
            el.dataset.oldOverflow = el.style.overflow;
            el.dataset.scrollWidth = el.clientWidth.toString();
            addClass(el, "el-menu--collapse");
          } else {
            addClass(el, "el-menu--collapse");
            el.dataset.oldOverflow = el.style.overflow;
            el.dataset.scrollWidth = el.clientWidth.toString();
            removeClass(el, "el-menu--collapse");
          }
          el.style.width = `${el.scrollWidth}px`;
          el.style.overflow = "hidden";
        },
        onLeave(el) {
          addClass(el, "horizontal-collapse-transition");
          el.style.width = `${el.dataset.scrollWidth}px`;
        }
      };
      return {
        listeners
      };
    }
  });
  function _sfc_render$I(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createBlock(vue.Transition, vue.mergeProps({ mode: "out-in" }, _ctx.listeners), {
      default: vue.withCtx(() => [
        vue.renderSlot(_ctx.$slots, "default")
      ]),
      _: 3
    }, 16);
  }
  var ElMenuCollapseTransition = /* @__PURE__ */ _export_sfc(_sfc_main$Q, [["render", _sfc_render$I]]);

  function useMenu(instance, currentIndex) {
    const rootMenu = vue.inject("rootMenu");
    if (!rootMenu)
      throwError("useMenu", "can not inject root menu");
    const indexPath = vue.computed(() => {
      let parent = instance.parent;
      const path = [currentIndex.value];
      while (parent.type.name !== "ElMenu") {
        if (parent.props.index) {
          path.unshift(parent.props.index);
        }
        parent = parent.parent;
      }
      return path;
    });
    const parentMenu = vue.computed(() => {
      let parent = instance.parent;
      while (parent && !["ElMenu", "ElSubMenu"].includes(parent.type.name)) {
        parent = parent.parent;
      }
      return parent;
    });
    const paddingStyle = vue.computed(() => {
      let parent = instance.parent;
      if (rootMenu.props.mode !== "vertical")
        return {};
      let padding = 20;
      if (rootMenu.props.collapse) {
        padding = 20;
      } else {
        while (parent && parent.type.name !== "ElMenu") {
          if (parent.type.name === "ElSubMenu") {
            padding += 20;
          }
          parent = parent.parent;
        }
      }
      return { paddingLeft: `${padding}px` };
    });
    return {
      parentMenu,
      paddingStyle,
      indexPath
    };
  }

  function useMenuColor(props) {
    const menuBarColor = vue.computed(() => {
      const color = props.backgroundColor;
      if (!color) {
        return "";
      } else {
        return new TinyColor(color).shade(20).toString();
      }
    });
    return menuBarColor;
  }

  const useMenuCssVar = (props) => {
    return vue.computed(() => {
      return {
        "--el-menu-text-color": props.textColor || "",
        "--el-menu-hover-text-color": props.textColor || "",
        "--el-menu-bg-color": props.backgroundColor || "",
        "--el-menu-hover-bg-color": useMenuColor(props).value || "",
        "--el-menu-active-color": props.activeTextColor || ""
      };
    });
  };

  const subMenuProps = buildProps({
    index: {
      type: String,
      required: true
    },
    showTimeout: {
      type: Number,
      default: 300
    },
    hideTimeout: {
      type: Number,
      default: 300
    },
    popperClass: String,
    disabled: Boolean,
    popperAppendToBody: {
      type: Boolean,
      default: void 0
    },
    popperOffset: {
      type: Number,
      default: 6
    }
  });
  const COMPONENT_NAME$a = "ElSubMenu";
  var SubMenu = vue.defineComponent({
    name: COMPONENT_NAME$a,
    props: subMenuProps,
    setup(props, { slots, expose }) {
      const instance = vue.getCurrentInstance();
      const { paddingStyle, indexPath, parentMenu } = useMenu(instance, vue.computed(() => props.index));
      const rootMenu = vue.inject("rootMenu");
      if (!rootMenu)
        throwError(COMPONENT_NAME$a, "can not inject root menu");
      const subMenu = vue.inject(`subMenu:${parentMenu.value.uid}`);
      if (!subMenu)
        throwError(COMPONENT_NAME$a, "can not inject sub menu");
      const items = vue.ref({});
      const subMenus = vue.ref({});
      let timeout;
      const mouseInChild = vue.ref(false);
      const verticalTitleRef = vue.ref();
      const vPopper = vue.ref(null);
      const currentPlacement = vue.computed(() => mode.value === "horizontal" && isFirstLevel.value ? "bottom-start" : "right-start");
      const subMenuTitleIcon = vue.computed(() => {
        return mode.value === "horizontal" && isFirstLevel.value || mode.value === "vertical" && !rootMenu.props.collapse ? arrowDown : arrowRight;
      });
      const isFirstLevel = vue.computed(() => {
        let isFirstLevel2 = true;
        let parent = instance.parent;
        while (parent && parent.type.name !== "ElMenu") {
          if (["ElSubMenu", "ElMenuItemGroup"].includes(parent.type.name)) {
            isFirstLevel2 = false;
            break;
          } else {
            parent = parent.parent;
          }
        }
        return isFirstLevel2;
      });
      const appendToBody = vue.computed(() => {
        return props.popperAppendToBody === void 0 ? isFirstLevel.value : Boolean(props.popperAppendToBody);
      });
      const menuTransitionName = vue.computed(() => rootMenu.props.collapse ? "el-zoom-in-left" : "el-zoom-in-top");
      const fallbackPlacements = vue.computed(() => mode.value === "horizontal" && isFirstLevel.value ? [
        "bottom-start",
        "bottom-end",
        "top-start",
        "top-end",
        "right-start",
        "left-start"
      ] : [
        "right-start",
        "left-start",
        "bottom-start",
        "bottom-end",
        "top-start",
        "top-end"
      ]);
      const opened = vue.computed(() => rootMenu.openedMenus.includes(props.index));
      const active = vue.computed(() => {
        let isActive = false;
        Object.values(items.value).forEach((item2) => {
          if (item2.active) {
            isActive = true;
          }
        });
        Object.values(subMenus.value).forEach((subItem) => {
          if (subItem.active) {
            isActive = true;
          }
        });
        return isActive;
      });
      const backgroundColor = vue.computed(() => rootMenu.props.backgroundColor || "");
      const activeTextColor = vue.computed(() => rootMenu.props.activeTextColor || "");
      const textColor = vue.computed(() => rootMenu.props.textColor || "");
      const mode = vue.computed(() => rootMenu.props.mode);
      const item = vue.reactive({
        index: props.index,
        indexPath,
        active
      });
      const titleStyle = vue.computed(() => {
        if (mode.value !== "horizontal") {
          return {
            color: textColor.value
          };
        }
        return {
          borderBottomColor: active.value ? rootMenu.props.activeTextColor ? activeTextColor.value : "" : "transparent",
          color: active.value ? activeTextColor.value : textColor.value
        };
      });
      const doDestroy = () => {
        var _a, _b, _c;
        return (_c = (_b = (_a = vPopper.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.popperInstanceRef) == null ? void 0 : _c.destroy();
      };
      const handleCollapseToggle = (value) => {
        if (!value) {
          doDestroy();
        }
      };
      const handleClick = () => {
        if (rootMenu.props.menuTrigger === "hover" && rootMenu.props.mode === "horizontal" || rootMenu.props.collapse && rootMenu.props.mode === "vertical" || props.disabled)
          return;
        rootMenu.handleSubMenuClick({
          index: props.index,
          indexPath: indexPath.value,
          active: active.value
        });
      };
      const handleMouseenter = (event, showTimeout = props.showTimeout) => {
        var _a;
        if (event.type === "focus" && !event.relatedTarget) {
          return;
        }
        if (rootMenu.props.menuTrigger === "click" && rootMenu.props.mode === "horizontal" || !rootMenu.props.collapse && rootMenu.props.mode === "vertical" || props.disabled) {
          return;
        }
        subMenu.mouseInChild.value = true;
        timeout == null ? void 0 : timeout();
        ({ stop: timeout } = useTimeoutFn(() => {
          rootMenu.openMenu(props.index, indexPath.value);
        }, showTimeout));
        if (appendToBody.value) {
          (_a = parentMenu.value.vnode.el) == null ? void 0 : _a.dispatchEvent(new MouseEvent("mouseenter"));
        }
      };
      const handleMouseleave = (deepDispatch = false) => {
        var _a, _b;
        if (rootMenu.props.menuTrigger === "click" && rootMenu.props.mode === "horizontal" || !rootMenu.props.collapse && rootMenu.props.mode === "vertical") {
          return;
        }
        timeout == null ? void 0 : timeout();
        subMenu.mouseInChild.value = false;
        ({ stop: timeout } = useTimeoutFn(() => !mouseInChild.value && rootMenu.closeMenu(props.index, indexPath.value), props.hideTimeout));
        if (appendToBody.value && deepDispatch) {
          if (((_a = instance.parent) == null ? void 0 : _a.type.name) === "ElSubMenu") {
            (_b = subMenu.handleMouseleave) == null ? void 0 : _b.call(subMenu, true);
          }
        }
      };
      vue.watch(() => rootMenu.props.collapse, (value) => handleCollapseToggle(Boolean(value)));
      {
        const addSubMenu = (item2) => {
          subMenus.value[item2.index] = item2;
        };
        const removeSubMenu = (item2) => {
          delete subMenus.value[item2.index];
        };
        vue.provide(`subMenu:${instance.uid}`, {
          addSubMenu,
          removeSubMenu,
          handleMouseleave,
          mouseInChild
        });
      }
      expose({
        opened
      });
      vue.onMounted(() => {
        rootMenu.addSubMenu(item);
        subMenu.addSubMenu(item);
      });
      vue.onBeforeUnmount(() => {
        subMenu.removeSubMenu(item);
        rootMenu.removeSubMenu(item);
      });
      return () => {
        var _a;
        const titleTag = [
          (_a = slots.title) == null ? void 0 : _a.call(slots),
          vue.h(ElIcon, {
            class: ["el-sub-menu__icon-arrow"]
          }, { default: () => vue.h(subMenuTitleIcon.value) })
        ];
        const ulStyle = useMenuCssVar(rootMenu.props);
        const child = rootMenu.isMenuPopup ? vue.h(ElTooltip, {
          ref: vPopper,
          visible: opened.value,
          effect: "light",
          pure: true,
          offset: props.popperOffset,
          showArrow: false,
          persistent: true,
          popperClass: props.popperClass,
          placement: currentPlacement.value,
          teleported: appendToBody.value,
          fallbackPlacements: fallbackPlacements.value,
          transition: menuTransitionName.value,
          gpuAcceleration: false
        }, {
          content: () => {
            var _a2;
            return vue.h("div", {
              class: [`el-menu--${mode.value}`, props.popperClass],
              onMouseenter: (evt) => handleMouseenter(evt, 100),
              onMouseleave: () => handleMouseleave(true),
              onFocus: (evt) => handleMouseenter(evt, 100)
            }, [
              vue.h("ul", {
                class: [
                  "el-menu el-menu--popup",
                  `el-menu--popup-${currentPlacement.value}`
                ],
                style: ulStyle.value
              }, [(_a2 = slots.default) == null ? void 0 : _a2.call(slots)])
            ]);
          },
          default: () => vue.h("div", {
            class: "el-sub-menu__title",
            style: [
              paddingStyle.value,
              titleStyle.value,
              { backgroundColor: backgroundColor.value }
            ],
            onClick: handleClick
          }, titleTag)
        }) : vue.h(vue.Fragment, {}, [
          vue.h("div", {
            class: "el-sub-menu__title",
            style: [
              paddingStyle.value,
              titleStyle.value,
              { backgroundColor: backgroundColor.value }
            ],
            ref: verticalTitleRef,
            onClick: handleClick
          }, titleTag),
          vue.h(_CollapseTransition, {}, {
            default: () => {
              var _a2;
              return vue.withDirectives(vue.h("ul", {
                role: "menu",
                class: "el-menu el-menu--inline",
                style: ulStyle.value
              }, [(_a2 = slots.default) == null ? void 0 : _a2.call(slots)]), [[vue.vShow, opened.value]]);
            }
          })
        ]);
        return vue.h("li", {
          class: [
            "el-sub-menu",
            {
              "is-active": active.value,
              "is-opened": opened.value,
              "is-disabled": props.disabled
            }
          ],
          role: "menuitem",
          ariaHaspopup: true,
          ariaExpanded: opened.value,
          onMouseenter: handleMouseenter,
          onMouseleave: () => handleMouseleave(true),
          onFocus: handleMouseenter
        }, [child]);
      };
    }
  });

  const menuProps = buildProps({
    mode: {
      type: String,
      values: ["horizontal", "vertical"],
      default: "vertical"
    },
    defaultActive: {
      type: String,
      default: ""
    },
    defaultOpeneds: {
      type: definePropType(Array),
      default: () => mutable([])
    },
    uniqueOpened: Boolean,
    router: Boolean,
    menuTrigger: {
      type: String,
      values: ["hover", "click"],
      default: "hover"
    },
    collapse: Boolean,
    backgroundColor: String,
    textColor: String,
    activeTextColor: String,
    collapseTransition: {
      type: Boolean,
      default: true
    },
    ellipsis: {
      type: Boolean,
      default: true
    }
  });
  const checkIndexPath = (indexPath) => Array.isArray(indexPath) && indexPath.every((path) => isString(path));
  const menuEmits = {
    close: (index, indexPath) => isString(index) && checkIndexPath(indexPath),
    open: (index, indexPath) => isString(index) && checkIndexPath(indexPath),
    select: (index, indexPath, item, routerResult) => isString(index) && checkIndexPath(indexPath) && isObject$1(item) && (routerResult === void 0 || routerResult instanceof Promise)
  };
  var Menu = vue.defineComponent({
    name: "ElMenu",
    props: menuProps,
    emits: menuEmits,
    setup(props, { emit, slots, expose }) {
      const instance = vue.getCurrentInstance();
      const router = instance.appContext.config.globalProperties.$router;
      const menu = vue.ref();
      const openedMenus = vue.ref(props.defaultOpeneds && !props.collapse ? props.defaultOpeneds.slice(0) : []);
      const activeIndex = vue.ref(props.defaultActive);
      const items = vue.ref({});
      const subMenus = vue.ref({});
      const isMenuPopup = vue.computed(() => {
        return props.mode === "horizontal" || props.mode === "vertical" && props.collapse;
      });
      const initMenu = () => {
        const activeItem = activeIndex.value && items.value[activeIndex.value];
        if (!activeItem || props.mode === "horizontal" || props.collapse)
          return;
        const indexPath = activeItem.indexPath;
        indexPath.forEach((index) => {
          const subMenu = subMenus.value[index];
          subMenu && openMenu(index, subMenu.indexPath);
        });
      };
      const openMenu = (index, indexPath) => {
        if (openedMenus.value.includes(index))
          return;
        if (props.uniqueOpened) {
          openedMenus.value = openedMenus.value.filter((index2) => indexPath.includes(index2));
        }
        openedMenus.value.push(index);
        emit("open", index, indexPath);
      };
      const closeMenu = (index, indexPath) => {
        const i = openedMenus.value.indexOf(index);
        if (i !== -1) {
          openedMenus.value.splice(i, 1);
        }
        emit("close", index, indexPath);
      };
      const handleSubMenuClick = ({
        index,
        indexPath
      }) => {
        const isOpened = openedMenus.value.includes(index);
        if (isOpened) {
          closeMenu(index, indexPath);
        } else {
          openMenu(index, indexPath);
        }
      };
      const handleMenuItemClick = (menuItem) => {
        if (props.mode === "horizontal" || props.collapse) {
          openedMenus.value = [];
        }
        const { index, indexPath } = menuItem;
        if (index === void 0 || indexPath === void 0)
          return;
        if (props.router && router) {
          const route = menuItem.route || index;
          const routerResult = router.push(route).then((res) => {
            if (!res)
              activeIndex.value = index;
            return res;
          });
          emit("select", index, indexPath, { index, indexPath, route }, routerResult);
        } else {
          activeIndex.value = index;
          emit("select", index, indexPath, { index, indexPath });
        }
      };
      const updateActiveIndex = (val) => {
        const itemsInData = items.value;
        const item = itemsInData[val] || activeIndex.value && itemsInData[activeIndex.value] || itemsInData[props.defaultActive];
        if (item) {
          activeIndex.value = item.index;
          initMenu();
        } else {
          activeIndex.value = val;
        }
      };
      const handleResize = () => {
        vue.nextTick(() => instance.proxy.$forceUpdate());
      };
      vue.watch(() => props.defaultActive, (currentActive) => {
        if (!items.value[currentActive]) {
          activeIndex.value = "";
        }
        updateActiveIndex(currentActive);
      });
      vue.watch(items.value, () => initMenu());
      vue.watch(() => props.collapse, (value) => {
        if (value)
          openedMenus.value = [];
      });
      {
        const addSubMenu = (item) => {
          subMenus.value[item.index] = item;
        };
        const removeSubMenu = (item) => {
          delete subMenus.value[item.index];
        };
        const addMenuItem = (item) => {
          items.value[item.index] = item;
        };
        const removeMenuItem = (item) => {
          delete items.value[item.index];
        };
        vue.provide("rootMenu", vue.reactive({
          props,
          openedMenus,
          items,
          subMenus,
          activeIndex,
          isMenuPopup,
          addMenuItem,
          removeMenuItem,
          addSubMenu,
          removeSubMenu,
          openMenu,
          closeMenu,
          handleMenuItemClick,
          handleSubMenuClick
        }));
        vue.provide(`subMenu:${instance.uid}`, {
          addSubMenu,
          removeSubMenu,
          mouseInChild: vue.ref(false)
        });
      }
      vue.onMounted(() => {
        initMenu();
        if (props.mode === "horizontal") {
          new Menubar(instance.vnode.el);
        }
      });
      {
        const open = (index) => {
          const { indexPath } = subMenus.value[index];
          indexPath.forEach((i) => openMenu(i, indexPath));
        };
        expose({
          open,
          close: closeMenu,
          handleResize
        });
      }
      const flattedChildren = (children) => {
        const vnodes = Array.isArray(children) ? children : [children];
        const result = [];
        vnodes.forEach((child) => {
          if (Array.isArray(child.children)) {
            result.push(...flattedChildren(child.children));
          } else {
            result.push(child);
          }
        });
        return result;
      };
      const useVNodeResize = (vnode) => props.mode === "horizontal" ? vue.withDirectives(vnode, [[Resize, handleResize]]) : vnode;
      return () => {
        var _a, _b, _c, _d;
        let slot = (_b = (_a = slots.default) == null ? void 0 : _a.call(slots)) != null ? _b : [];
        const vShowMore = [];
        if (props.mode === "horizontal" && menu.value) {
          const items2 = Array.from((_d = (_c = menu.value) == null ? void 0 : _c.childNodes) != null ? _d : []).filter((item) => item.nodeName !== "#text" || item.nodeValue);
          const originalSlot = flattedChildren(slot);
          const moreItemWidth = 64;
          const paddingLeft = Number.parseInt(getComputedStyle(menu.value).paddingLeft, 10);
          const paddingRight = Number.parseInt(getComputedStyle(menu.value).paddingRight, 10);
          const menuWidth = menu.value.clientWidth - paddingLeft - paddingRight;
          let calcWidth = 0;
          let sliceIndex = 0;
          items2.forEach((item, index) => {
            calcWidth += item.offsetWidth || 0;
            if (calcWidth <= menuWidth - moreItemWidth) {
              sliceIndex = index + 1;
            }
          });
          const slotDefault = originalSlot.slice(0, sliceIndex);
          const slotMore = originalSlot.slice(sliceIndex);
          if ((slotMore == null ? void 0 : slotMore.length) && props.ellipsis) {
            slot = slotDefault;
            vShowMore.push(vue.h(SubMenu, {
              index: "sub-menu-more",
              class: "el-sub-menu__hide-arrow"
            }, {
              title: () => vue.h(ElIcon, {
                class: ["el-sub-menu__icon-more"]
              }, { default: () => vue.h(more) }),
              default: () => slotMore
            }));
          }
        }
        const ulStyle = useMenuCssVar(props);
        const resizeMenu = (vNode) => props.ellipsis ? useVNodeResize(vNode) : vNode;
        const vMenu = resizeMenu(vue.h("ul", {
          key: String(props.collapse),
          role: "menubar",
          ref: menu,
          style: ulStyle.value,
          class: {
            "el-menu": true,
            "el-menu--horizontal": props.mode === "horizontal",
            "el-menu--collapse": props.collapse
          }
        }, [...slot.map((vnode) => resizeMenu(vnode)), ...vShowMore]));
        if (props.collapseTransition && props.mode === "vertical") {
          return vue.h(ElMenuCollapseTransition, () => vMenu);
        }
        return vMenu;
      };
    }
  });

  const menuItemProps = buildProps({
    index: {
      type: definePropType([String, null]),
      default: null
    },
    route: {
      type: definePropType([String, Object])
    },
    disabled: Boolean
  });
  const menuItemEmits = {
    click: (item) => isString(item.index) && Array.isArray(item.indexPath)
  };

  const COMPONENT_NAME$9 = "ElMenuItem";
  const _sfc_main$P = vue.defineComponent({
    name: COMPONENT_NAME$9,
    components: {
      ElTooltip
    },
    props: menuItemProps,
    emits: menuItemEmits,
    setup(props, { emit }) {
      const instance = vue.getCurrentInstance();
      const rootMenu = vue.inject("rootMenu");
      if (!rootMenu)
        throwError(COMPONENT_NAME$9, "can not inject root menu");
      const { parentMenu, paddingStyle, indexPath } = useMenu(instance, vue.toRef(props, "index"));
      const subMenu = vue.inject(`subMenu:${parentMenu.value.uid}`);
      if (!subMenu)
        throwError(COMPONENT_NAME$9, "can not inject sub menu");
      const active = vue.computed(() => props.index === rootMenu.activeIndex);
      const item = vue.reactive({
        index: props.index,
        indexPath,
        active
      });
      const handleClick = () => {
        if (!props.disabled) {
          rootMenu.handleMenuItemClick({
            index: props.index,
            indexPath: indexPath.value,
            route: props.route
          });
          emit("click", item);
        }
      };
      vue.onMounted(() => {
        subMenu.addSubMenu(item);
        rootMenu.addMenuItem(item);
      });
      vue.onBeforeUnmount(() => {
        subMenu.removeSubMenu(item);
        rootMenu.removeMenuItem(item);
      });
      return {
        Effect,
        parentMenu,
        rootMenu,
        paddingStyle,
        active,
        handleClick
      };
    }
  });
  const _hoisted_1$q = { class: "el-menu-tooltip__trigger" };
  function _sfc_render$H(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_tooltip = vue.resolveComponent("el-tooltip");
    return vue.openBlock(), vue.createElementBlock("li", {
      class: vue.normalizeClass(["el-menu-item", {
        "is-active": _ctx.active,
        "is-disabled": _ctx.disabled
      }]),
      role: "menuitem",
      tabindex: "-1",
      style: vue.normalizeStyle(_ctx.paddingStyle),
      onClick: _cache[0] || (_cache[0] = (...args) => _ctx.handleClick && _ctx.handleClick(...args))
    }, [
      _ctx.parentMenu.type.name === "ElMenu" && _ctx.rootMenu.props.collapse && _ctx.$slots.title ? (vue.openBlock(), vue.createBlock(_component_el_tooltip, {
        key: 0,
        effect: _ctx.Effect.DARK,
        placement: "right",
        persistent: ""
      }, {
        content: vue.withCtx(() => [
          vue.renderSlot(_ctx.$slots, "title")
        ]),
        default: vue.withCtx(() => [
          vue.createElementVNode("div", _hoisted_1$q, [
            vue.renderSlot(_ctx.$slots, "default")
          ])
        ]),
        _: 3
      }, 8, ["effect"])) : (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 1 }, [
        vue.renderSlot(_ctx.$slots, "default"),
        vue.renderSlot(_ctx.$slots, "title")
      ], 64))
    ], 6);
  }
  var MenuItem = /* @__PURE__ */ _export_sfc(_sfc_main$P, [["render", _sfc_render$H]]);

  const menuItemGroupProps = {
    title: String
  };

  const COMPONENT_NAME$8 = "ElMenuItemGroup";
  const _sfc_main$O = vue.defineComponent({
    name: COMPONENT_NAME$8,
    props: menuItemGroupProps,
    setup() {
      const instance = vue.getCurrentInstance();
      const menu = vue.inject("rootMenu");
      if (!menu)
        throwError(COMPONENT_NAME$8, "can not inject root menu");
      const levelPadding = vue.computed(() => {
        if (menu.props.collapse)
          return 20;
        let padding = 20;
        let parent = instance.parent;
        while (parent && parent.type.name !== "ElMenu") {
          if (parent.type.name === "ElSubMenu") {
            padding += 20;
          }
          parent = parent.parent;
        }
        return padding;
      });
      return {
        levelPadding
      };
    }
  });
  const _hoisted_1$p = { class: "el-menu-item-group" };
  function _sfc_render$G(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("li", _hoisted_1$p, [
      vue.createElementVNode("div", {
        class: "el-menu-item-group__title",
        style: vue.normalizeStyle({ paddingLeft: `${_ctx.levelPadding}px` })
      }, [
        !_ctx.$slots.title ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
          vue.createTextVNode(vue.toDisplayString(_ctx.title), 1)
        ], 2112)) : vue.renderSlot(_ctx.$slots, "title", { key: 1 })
      ], 4),
      vue.createElementVNode("ul", null, [
        vue.renderSlot(_ctx.$slots, "default")
      ])
    ]);
  }
  var MenuItemGroup = /* @__PURE__ */ _export_sfc(_sfc_main$O, [["render", _sfc_render$G]]);

  const ElMenu = withInstall(Menu, {
    MenuItem,
    MenuItemGroup,
    SubMenu
  });
  const ElMenuItem = withNoopInstall(MenuItem);
  const ElMenuItemGroup = withNoopInstall(MenuItemGroup);
  const ElSubMenu = withNoopInstall(SubMenu);

  const pageHeaderProps = buildProps({
    icon: {
      type: iconPropType,
      default: () => back
    },
    title: String,
    content: {
      type: String,
      default: ""
    }
  });
  const pageHeaderEmits = {
    back: () => true
  };

  const __default__$4 = {
    name: "ElPageHeader"
  };
  const _sfc_main$N = /* @__PURE__ */ vue.defineComponent({
    ...__default__$4,
    props: pageHeaderProps,
    emits: pageHeaderEmits,
    setup(__props, { emit }) {
      const { t } = useLocale();
      const ns = useNamespace("page-header");
      function handleClick() {
        emit("back");
      }
      return (_ctx, _cache) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          class: vue.normalizeClass(vue.unref(ns).b())
        }, [
          vue.createElementVNode("div", {
            class: vue.normalizeClass(vue.unref(ns).e("left")),
            onClick: handleClick
          }, [
            _ctx.icon || _ctx.$slots.icon ? (vue.openBlock(), vue.createElementBlock("div", {
              key: 0,
              class: vue.normalizeClass(vue.unref(ns).e("icon"))
            }, [
              vue.renderSlot(_ctx.$slots, "icon", {}, () => [
                _ctx.icon ? (vue.openBlock(), vue.createBlock(vue.unref(ElIcon), { key: 0 }, {
                  default: vue.withCtx(() => [
                    (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.icon)))
                  ]),
                  _: 1
                })) : vue.createCommentVNode("v-if", true)
              ])
            ], 2)) : vue.createCommentVNode("v-if", true),
            vue.createElementVNode("div", {
              class: vue.normalizeClass(vue.unref(ns).e("title"))
            }, [
              vue.renderSlot(_ctx.$slots, "title", {}, () => [
                vue.createTextVNode(vue.toDisplayString(_ctx.title || vue.unref(t)("el.pageHeader.title")), 1)
              ])
            ], 2)
          ], 2),
          vue.createElementVNode("div", {
            class: vue.normalizeClass(vue.unref(ns).e("content"))
          }, [
            vue.renderSlot(_ctx.$slots, "content", {}, () => [
              vue.createTextVNode(vue.toDisplayString(_ctx.content), 1)
            ])
          ], 2)
        ], 2);
      };
    }
  });
  var PageHeader = _sfc_main$N;

  const ElPageHeader = withInstall(PageHeader);

  const paginationPrevProps = {
    disabled: Boolean,
    currentPage: {
      type: Number,
      default: 1
    },
    prevText: {
      type: String,
      default: ""
    }
  };
  const _sfc_main$M = vue.defineComponent({
    name: "ElPaginationPrev",
    components: {
      ElIcon,
      ArrowLeft: arrowLeft
    },
    props: paginationPrevProps,
    emits: ["click"],
    setup(props) {
      const internalDisabled = vue.computed(() => props.disabled || props.currentPage <= 1);
      return {
        internalDisabled
      };
    }
  });
  const _hoisted_1$o = ["disabled", "aria-disabled"];
  const _hoisted_2$i = { key: 0 };
  function _sfc_render$F(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_arrow_left = vue.resolveComponent("arrow-left");
    const _component_el_icon = vue.resolveComponent("el-icon");
    return vue.openBlock(), vue.createElementBlock("button", {
      type: "button",
      class: "btn-prev",
      disabled: _ctx.internalDisabled,
      "aria-disabled": _ctx.internalDisabled,
      onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("click", $event))
    }, [
      _ctx.prevText ? (vue.openBlock(), vue.createElementBlock("span", _hoisted_2$i, vue.toDisplayString(_ctx.prevText), 1)) : (vue.openBlock(), vue.createBlock(_component_el_icon, { key: 1 }, {
        default: vue.withCtx(() => [
          vue.createVNode(_component_arrow_left)
        ]),
        _: 1
      }))
    ], 8, _hoisted_1$o);
  }
  var Prev = /* @__PURE__ */ _export_sfc(_sfc_main$M, [["render", _sfc_render$F]]);

  const paginationNextProps = {
    disabled: Boolean,
    currentPage: {
      type: Number,
      default: 1
    },
    pageCount: {
      type: Number,
      default: 50
    },
    nextText: {
      type: String,
      default: ""
    }
  };
  const _sfc_main$L = vue.defineComponent({
    name: "ElPaginationNext",
    components: {
      ElIcon,
      ArrowRight: arrowRight
    },
    props: paginationNextProps,
    emits: ["click"],
    setup(props) {
      const internalDisabled = vue.computed(() => props.disabled || props.currentPage === props.pageCount || props.pageCount === 0);
      return {
        internalDisabled
      };
    }
  });
  const _hoisted_1$n = ["disabled", "aria-disabled"];
  const _hoisted_2$h = { key: 0 };
  function _sfc_render$E(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_arrow_right = vue.resolveComponent("arrow-right");
    const _component_el_icon = vue.resolveComponent("el-icon");
    return vue.openBlock(), vue.createElementBlock("button", {
      type: "button",
      class: "btn-next",
      disabled: _ctx.internalDisabled,
      "aria-disabled": _ctx.internalDisabled,
      onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("click", $event))
    }, [
      _ctx.nextText ? (vue.openBlock(), vue.createElementBlock("span", _hoisted_2$h, vue.toDisplayString(_ctx.nextText), 1)) : (vue.openBlock(), vue.createBlock(_component_el_icon, { key: 1 }, {
        default: vue.withCtx(() => [
          vue.createVNode(_component_arrow_right)
        ]),
        _: 1
      }))
    ], 8, _hoisted_1$n);
  }
  var Next = /* @__PURE__ */ _export_sfc(_sfc_main$L, [["render", _sfc_render$E]]);

  const selectGroupKey = "ElSelectGroup";
  const selectKey = "ElSelect";

  function useOption$1(props, states) {
    const select = vue.inject(selectKey);
    const selectGroup = vue.inject(selectGroupKey, { disabled: false });
    const isObject = vue.computed(() => {
      return Object.prototype.toString.call(props.value).toLowerCase() === "[object object]";
    });
    const itemSelected = vue.computed(() => {
      if (!select.props.multiple) {
        return isEqual(props.value, select.props.modelValue);
      } else {
        return contains(select.props.modelValue, props.value);
      }
    });
    const limitReached = vue.computed(() => {
      if (select.props.multiple) {
        const modelValue = select.props.modelValue || [];
        return !itemSelected.value && modelValue.length >= select.props.multipleLimit && select.props.multipleLimit > 0;
      } else {
        return false;
      }
    });
    const currentLabel = vue.computed(() => {
      return props.label || (isObject.value ? "" : props.value);
    });
    const currentValue = vue.computed(() => {
      return props.value || props.label || "";
    });
    const isDisabled = vue.computed(() => {
      return props.disabled || states.groupDisabled || limitReached.value;
    });
    const instance = vue.getCurrentInstance();
    const contains = (arr = [], target) => {
      if (!isObject.value) {
        return arr && arr.includes(target);
      } else {
        const valueKey = select.props.valueKey;
        return arr && arr.some((item) => {
          return get(item, valueKey) === get(target, valueKey);
        });
      }
    };
    const isEqual = (a, b) => {
      if (!isObject.value) {
        return a === b;
      } else {
        const { valueKey } = select.props;
        return get(a, valueKey) === get(b, valueKey);
      }
    };
    const hoverItem = () => {
      if (!props.disabled && !selectGroup.disabled) {
        select.hoverIndex = select.optionsArray.indexOf(instance.proxy);
      }
    };
    vue.watch(() => currentLabel.value, () => {
      if (!props.created && !select.props.remote)
        select.setSelected();
    });
    vue.watch(() => props.value, (val, oldVal) => {
      const { remote, valueKey } = select.props;
      if (!props.created && !remote) {
        if (valueKey && typeof val === "object" && typeof oldVal === "object" && val[valueKey] === oldVal[valueKey]) {
          return;
        }
        select.setSelected();
      }
    });
    vue.watch(() => selectGroup.disabled, () => {
      states.groupDisabled = selectGroup.disabled;
    }, { immediate: true });
    const { queryChange } = vue.toRaw(select);
    vue.watch(queryChange, (changes) => {
      const { query } = vue.unref(changes);
      const regexp = new RegExp(escapeStringRegexp(query), "i");
      states.visible = regexp.test(currentLabel.value) || props.created;
      if (!states.visible) {
        select.filteredOptionsCount--;
      }
    });
    return {
      select,
      currentLabel,
      currentValue,
      itemSelected,
      isDisabled,
      hoverItem
    };
  }

  const _sfc_main$K = vue.defineComponent({
    name: "ElOption",
    componentName: "ElOption",
    props: {
      value: {
        required: true,
        type: [String, Number, Boolean, Object]
      },
      label: [String, Number],
      created: Boolean,
      disabled: {
        type: Boolean,
        default: false
      }
    },
    setup(props) {
      const ns = useNamespace("select");
      const states = vue.reactive({
        index: -1,
        groupDisabled: false,
        visible: true,
        hitState: false,
        hover: false
      });
      const { currentLabel, itemSelected, isDisabled, select, hoverItem } = useOption$1(props, states);
      const { visible, hover } = vue.toRefs(states);
      const vm = vue.getCurrentInstance().proxy;
      const key = vm.value;
      select.onOptionCreate(vm);
      vue.onBeforeUnmount(() => {
        const { selected } = select;
        const selectedOptions = select.props.multiple ? selected : [selected];
        const doesSelected = selectedOptions.some((item) => {
          return item.value === vm.value;
        });
        if (select.cachedOptions.get(key) === vm && !doesSelected) {
          vue.nextTick(() => {
            select.cachedOptions.delete(key);
          });
        }
        select.onOptionDestroy(key, vm);
      });
      function selectOptionClick() {
        if (props.disabled !== true && states.groupDisabled !== true) {
          select.handleOptionSelect(vm, true);
        }
      }
      return {
        ns,
        currentLabel,
        itemSelected,
        isDisabled,
        select,
        hoverItem,
        visible,
        hover,
        selectOptionClick,
        states
      };
    }
  });
  function _sfc_render$D(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.withDirectives((vue.openBlock(), vue.createElementBlock("li", {
      class: vue.normalizeClass([
        _ctx.ns.be("dropdown", "item"),
        _ctx.ns.is("disabled", _ctx.isDisabled),
        {
          selected: _ctx.itemSelected,
          hover: _ctx.hover
        }
      ]),
      onMouseenter: _cache[0] || (_cache[0] = (...args) => _ctx.hoverItem && _ctx.hoverItem(...args)),
      onClick: _cache[1] || (_cache[1] = vue.withModifiers((...args) => _ctx.selectOptionClick && _ctx.selectOptionClick(...args), ["stop"]))
    }, [
      vue.renderSlot(_ctx.$slots, "default", {}, () => [
        vue.createElementVNode("span", null, vue.toDisplayString(_ctx.currentLabel), 1)
      ])
    ], 34)), [
      [vue.vShow, _ctx.visible]
    ]);
  }
  var Option = /* @__PURE__ */ _export_sfc(_sfc_main$K, [["render", _sfc_render$D]]);

  const _sfc_main$J = vue.defineComponent({
    name: "ElSelectDropdown",
    componentName: "ElSelectDropdown",
    setup() {
      const select = vue.inject(selectKey);
      const ns = useNamespace("select");
      const popperClass = vue.computed(() => select.props.popperClass);
      const isMultiple = vue.computed(() => select.props.multiple);
      const isFitInputWidth = vue.computed(() => select.props.fitInputWidth);
      const minWidth = vue.ref("");
      function updateMinWidth() {
        var _a;
        minWidth.value = `${(_a = select.selectWrapper) == null ? void 0 : _a.getBoundingClientRect().width}px`;
      }
      vue.onMounted(() => {
        updateMinWidth();
        addResizeListener(select.selectWrapper, updateMinWidth);
      });
      vue.onBeforeUnmount(() => {
        removeResizeListener(select.selectWrapper, updateMinWidth);
      });
      return {
        ns,
        minWidth,
        popperClass,
        isMultiple,
        isFitInputWidth
      };
    }
  });
  function _sfc_render$C(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("div", {
      class: vue.normalizeClass([_ctx.ns.b("dropdown"), _ctx.ns.is("multiple", _ctx.isMultiple), _ctx.popperClass]),
      style: vue.normalizeStyle({ [_ctx.isFitInputWidth ? "width" : "minWidth"]: _ctx.minWidth })
    }, [
      vue.renderSlot(_ctx.$slots, "default")
    ], 6);
  }
  var ElSelectMenu$1 = /* @__PURE__ */ _export_sfc(_sfc_main$J, [["render", _sfc_render$C]]);

  function useSelectStates(props) {
    const { t } = useLocale();
    return vue.reactive({
      options: /* @__PURE__ */ new Map(),
      cachedOptions: /* @__PURE__ */ new Map(),
      createdLabel: null,
      createdSelected: false,
      selected: props.multiple ? [] : {},
      inputLength: 20,
      inputWidth: 0,
      initialInputHeight: 0,
      optionsCount: 0,
      filteredOptionsCount: 0,
      visible: false,
      softFocus: false,
      selectedLabel: "",
      hoverIndex: -1,
      query: "",
      previousQuery: null,
      inputHovering: false,
      cachedPlaceHolder: "",
      currentPlaceholder: t("el.select.placeholder"),
      menuVisibleOnFocus: false,
      isOnComposition: false,
      isSilentBlur: false,
      prefixWidth: 11,
      tagInMultiLine: false
    });
  }
  const useSelect$2 = (props, states, ctx) => {
    const { t } = useLocale();
    const ns = useNamespace("select");
    const reference = vue.ref(null);
    const input = vue.ref(null);
    const tooltipRef = vue.ref(null);
    const tags = vue.ref(null);
    const selectWrapper = vue.ref(null);
    const scrollbar = vue.ref(null);
    const hoverOption = vue.ref(-1);
    const queryChange = vue.shallowRef({ query: "" });
    const groupQueryChange = vue.shallowRef("");
    const elForm = vue.inject(formContextKey, {});
    const elFormItem = vue.inject(formItemContextKey, {});
    const readonly = vue.computed(() => !props.filterable || props.multiple || !states.visible);
    const selectDisabled = vue.computed(() => props.disabled || elForm.disabled);
    const showClose = vue.computed(() => {
      const hasValue = props.multiple ? Array.isArray(props.modelValue) && props.modelValue.length > 0 : props.modelValue !== void 0 && props.modelValue !== null && props.modelValue !== "";
      const criteria = props.clearable && !selectDisabled.value && states.inputHovering && hasValue;
      return criteria;
    });
    const iconComponent = vue.computed(() => props.remote && props.filterable ? "" : props.suffixIcon);
    const iconReverse = vue.computed(() => ns.is("reverse", iconComponent.value && states.visible));
    const debounce = vue.computed(() => props.remote ? 300 : 0);
    const emptyText = vue.computed(() => {
      if (props.loading) {
        return props.loadingText || t("el.select.loading");
      } else {
        if (props.remote && states.query === "" && states.options.size === 0)
          return false;
        if (props.filterable && states.query && states.options.size > 0 && states.filteredOptionsCount === 0) {
          return props.noMatchText || t("el.select.noMatch");
        }
        if (states.options.size === 0) {
          return props.noDataText || t("el.select.noData");
        }
      }
      return null;
    });
    const optionsArray = vue.computed(() => Array.from(states.options.values()));
    const cachedOptionsArray = vue.computed(() => Array.from(states.cachedOptions.values()));
    const showNewOption = vue.computed(() => {
      const hasExistingOption = optionsArray.value.filter((option) => {
        return !option.created;
      }).some((option) => {
        return option.currentLabel === states.query;
      });
      return props.filterable && props.allowCreate && states.query !== "" && !hasExistingOption;
    });
    const selectSize = useSize();
    const collapseTagSize = vue.computed(() => ["small"].includes(selectSize.value) ? "small" : "default");
    const dropMenuVisible = vue.computed({
      get() {
        return states.visible && emptyText.value !== false;
      },
      set(val) {
        states.visible = val;
      }
    });
    vue.watch(() => selectDisabled.value, () => {
      vue.nextTick(() => {
        resetInputHeight();
      });
    });
    vue.watch(() => props.placeholder, (val) => {
      states.cachedPlaceHolder = states.currentPlaceholder = val;
    });
    vue.watch(() => props.modelValue, (val, oldVal) => {
      var _a;
      if (props.multiple) {
        resetInputHeight();
        if (val && val.length > 0 || input.value && states.query !== "") {
          states.currentPlaceholder = "";
        } else {
          states.currentPlaceholder = states.cachedPlaceHolder;
        }
        if (props.filterable && !props.reserveKeyword) {
          states.query = "";
          handleQueryChange(states.query);
        }
      }
      setSelected();
      if (props.filterable && !props.multiple) {
        states.inputLength = 20;
      }
      if (!isEqual$1(val, oldVal)) {
        (_a = elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
      }
    }, {
      flush: "post",
      deep: true
    });
    vue.watch(() => states.visible, (val) => {
      var _a, _b, _c;
      if (!val) {
        input.value && input.value.blur();
        states.query = "";
        states.previousQuery = null;
        states.selectedLabel = "";
        states.inputLength = 20;
        states.menuVisibleOnFocus = false;
        resetHoverIndex();
        vue.nextTick(() => {
          if (input.value && input.value.value === "" && states.selected.length === 0) {
            states.currentPlaceholder = states.cachedPlaceHolder;
          }
        });
        if (!props.multiple) {
          if (states.selected) {
            if (props.filterable && props.allowCreate && states.createdSelected && states.createdLabel) {
              states.selectedLabel = states.createdLabel;
            } else {
              states.selectedLabel = states.selected.currentLabel;
            }
            if (props.filterable)
              states.query = states.selectedLabel;
          }
          if (props.filterable) {
            states.currentPlaceholder = states.cachedPlaceHolder;
          }
        }
      } else {
        (_b = (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
        if (props.filterable) {
          states.filteredOptionsCount = states.optionsCount;
          states.query = props.remote ? "" : states.selectedLabel;
          if (props.multiple) {
            (_c = input.value) == null ? void 0 : _c.focus();
          } else {
            if (states.selectedLabel) {
              states.currentPlaceholder = `${states.selectedLabel}`;
              states.selectedLabel = "";
            }
          }
          handleQueryChange(states.query);
          if (!props.multiple && !props.remote) {
            queryChange.value.query = "";
            vue.triggerRef(queryChange);
            vue.triggerRef(groupQueryChange);
          }
        }
      }
      ctx.emit("visible-change", val);
    });
    vue.watch(() => states.options.entries(), () => {
      var _a, _b, _c;
      if (!isClient)
        return;
      (_b = (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
      if (props.multiple) {
        resetInputHeight();
      }
      const inputs = ((_c = selectWrapper.value) == null ? void 0 : _c.querySelectorAll("input")) || [];
      if (!Array.from(inputs).includes(document.activeElement)) {
        setSelected();
      }
      if (props.defaultFirstOption && (props.filterable || props.remote) && states.filteredOptionsCount) {
        checkDefaultFirstOption();
      }
    }, {
      flush: "post"
    });
    vue.watch(() => states.hoverIndex, (val) => {
      if (typeof val === "number" && val > -1) {
        hoverOption.value = optionsArray.value[val] || {};
      }
      optionsArray.value.forEach((option) => {
        option.hover = hoverOption.value === option;
      });
    });
    const resetInputHeight = () => {
      if (props.collapseTags && !props.filterable)
        return;
      vue.nextTick(() => {
        var _a, _b;
        if (!reference.value)
          return;
        const inputChildNodes = reference.value.$el.childNodes;
        const input2 = Array.from(inputChildNodes).find((item) => item.tagName === "INPUT");
        const _tags = tags.value;
        const sizeInMap = states.initialInputHeight || 40;
        input2.style.height = states.selected.length === 0 ? `${sizeInMap}px` : `${Math.max(_tags ? _tags.clientHeight + (_tags.clientHeight > sizeInMap ? 6 : 0) : 0, sizeInMap)}px`;
        states.tagInMultiLine = Number.parseFloat(input2.style.height) >= sizeInMap;
        if (states.visible && emptyText.value !== false) {
          (_b = (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
        }
      });
    };
    const handleQueryChange = (val) => {
      if (states.previousQuery === val || states.isOnComposition)
        return;
      if (states.previousQuery === null && (typeof props.filterMethod === "function" || typeof props.remoteMethod === "function")) {
        states.previousQuery = val;
        return;
      }
      states.previousQuery = val;
      vue.nextTick(() => {
        var _a, _b;
        if (states.visible)
          (_b = (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
      });
      states.hoverIndex = -1;
      if (props.multiple && props.filterable) {
        vue.nextTick(() => {
          const length = input.value.value.length * 15 + 20;
          states.inputLength = props.collapseTags ? Math.min(50, length) : length;
          managePlaceholder();
          resetInputHeight();
        });
      }
      if (props.remote && typeof props.remoteMethod === "function") {
        states.hoverIndex = -1;
        props.remoteMethod(val);
      } else if (typeof props.filterMethod === "function") {
        props.filterMethod(val);
        vue.triggerRef(groupQueryChange);
      } else {
        states.filteredOptionsCount = states.optionsCount;
        queryChange.value.query = val;
        vue.triggerRef(queryChange);
        vue.triggerRef(groupQueryChange);
      }
      if (props.defaultFirstOption && (props.filterable || props.remote) && states.filteredOptionsCount) {
        checkDefaultFirstOption();
      }
    };
    const managePlaceholder = () => {
      if (states.currentPlaceholder !== "") {
        states.currentPlaceholder = input.value.value ? "" : states.cachedPlaceHolder;
      }
    };
    const checkDefaultFirstOption = () => {
      const optionsInDropdown = optionsArray.value.filter((n) => n.visible && !n.disabled && !n.states.groupDisabled);
      const userCreatedOption = optionsInDropdown.find((n) => n.created);
      const firstOriginOption = optionsInDropdown[0];
      states.hoverIndex = getValueIndex(optionsArray.value, userCreatedOption || firstOriginOption);
    };
    const setSelected = () => {
      var _a;
      if (!props.multiple) {
        const option = getOption(props.modelValue);
        if ((_a = option.props) == null ? void 0 : _a.created) {
          states.createdLabel = option.props.value;
          states.createdSelected = true;
        } else {
          states.createdSelected = false;
        }
        states.selectedLabel = option.currentLabel;
        states.selected = option;
        if (props.filterable)
          states.query = states.selectedLabel;
        return;
      }
      const result = [];
      if (Array.isArray(props.modelValue)) {
        props.modelValue.forEach((value) => {
          result.push(getOption(value));
        });
      }
      states.selected = result;
      vue.nextTick(() => {
        resetInputHeight();
      });
    };
    const getOption = (value) => {
      let option;
      const isObjectValue = toRawType(value).toLowerCase() === "object";
      const isNull = toRawType(value).toLowerCase() === "null";
      const isUndefined = toRawType(value).toLowerCase() === "undefined";
      for (let i = states.cachedOptions.size - 1; i >= 0; i--) {
        const cachedOption = cachedOptionsArray.value[i];
        const isEqualValue = isObjectValue ? get(cachedOption.value, props.valueKey) === get(value, props.valueKey) : cachedOption.value === value;
        if (isEqualValue) {
          option = {
            value,
            currentLabel: cachedOption.currentLabel,
            isDisabled: cachedOption.isDisabled
          };
          break;
        }
      }
      if (option)
        return option;
      const label = isObjectValue ? value.label : !isNull && !isUndefined ? value : "";
      const newOption = {
        value,
        currentLabel: label
      };
      if (props.multiple) {
        newOption.hitState = false;
      }
      return newOption;
    };
    const resetHoverIndex = () => {
      setTimeout(() => {
        const valueKey = props.valueKey;
        if (!props.multiple) {
          states.hoverIndex = optionsArray.value.findIndex((item) => {
            return getValueKey(item) === getValueKey(states.selected);
          });
        } else {
          if (states.selected.length > 0) {
            states.hoverIndex = Math.min.apply(null, states.selected.map((selected) => {
              return optionsArray.value.findIndex((item) => {
                return get(item, valueKey) === get(selected, valueKey);
              });
            }));
          } else {
            states.hoverIndex = -1;
          }
        }
      }, 300);
    };
    const handleResize = () => {
      var _a, _b;
      resetInputWidth();
      (_b = (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
      if (props.multiple && !props.filterable)
        resetInputHeight();
    };
    const resetInputWidth = () => {
      var _a;
      states.inputWidth = (_a = reference.value) == null ? void 0 : _a.$el.getBoundingClientRect().width;
    };
    const onInputChange = () => {
      if (props.filterable && states.query !== states.selectedLabel) {
        states.query = states.selectedLabel;
        handleQueryChange(states.query);
      }
    };
    const debouncedOnInputChange = debounce$1(() => {
      onInputChange();
    }, debounce.value);
    const debouncedQueryChange = debounce$1((e) => {
      handleQueryChange(e.target.value);
    }, debounce.value);
    const emitChange = (val) => {
      if (!isEqual$1(props.modelValue, val)) {
        ctx.emit(CHANGE_EVENT, val);
      }
    };
    const deletePrevTag = (e) => {
      if (e.target.value.length <= 0 && !toggleLastOptionHitState()) {
        const value = props.modelValue.slice();
        value.pop();
        ctx.emit(UPDATE_MODEL_EVENT, value);
        emitChange(value);
      }
      if (e.target.value.length === 1 && props.modelValue.length === 0) {
        states.currentPlaceholder = states.cachedPlaceHolder;
      }
    };
    const deleteTag = (event, tag) => {
      const index = states.selected.indexOf(tag);
      if (index > -1 && !selectDisabled.value) {
        const value = props.modelValue.slice();
        value.splice(index, 1);
        ctx.emit(UPDATE_MODEL_EVENT, value);
        emitChange(value);
        ctx.emit("remove-tag", tag.value);
      }
      event.stopPropagation();
    };
    const deleteSelected = (event) => {
      event.stopPropagation();
      const value = props.multiple ? [] : "";
      if (typeof value !== "string") {
        for (const item of states.selected) {
          if (item.isDisabled)
            value.push(item.value);
        }
      }
      ctx.emit(UPDATE_MODEL_EVENT, value);
      emitChange(value);
      states.visible = false;
      ctx.emit("clear");
    };
    const handleOptionSelect = (option, byClick) => {
      var _a;
      if (props.multiple) {
        const value = (props.modelValue || []).slice();
        const optionIndex = getValueIndex(value, option.value);
        if (optionIndex > -1) {
          value.splice(optionIndex, 1);
        } else if (props.multipleLimit <= 0 || value.length < props.multipleLimit) {
          value.push(option.value);
        }
        ctx.emit(UPDATE_MODEL_EVENT, value);
        emitChange(value);
        if (option.created) {
          states.query = "";
          handleQueryChange("");
          states.inputLength = 20;
        }
        if (props.filterable)
          (_a = input.value) == null ? void 0 : _a.focus();
      } else {
        ctx.emit(UPDATE_MODEL_EVENT, option.value);
        emitChange(option.value);
        states.visible = false;
      }
      states.isSilentBlur = byClick;
      setSoftFocus();
      if (states.visible)
        return;
      vue.nextTick(() => {
        scrollToOption(option);
      });
    };
    const getValueIndex = (arr = [], value) => {
      if (!isObject$1(value))
        return arr.indexOf(value);
      const valueKey = props.valueKey;
      let index = -1;
      arr.some((item, i) => {
        if (get(item, valueKey) === get(value, valueKey)) {
          index = i;
          return true;
        }
        return false;
      });
      return index;
    };
    const setSoftFocus = () => {
      states.softFocus = true;
      const _input = input.value || reference.value;
      if (_input) {
        _input == null ? void 0 : _input.focus();
      }
    };
    const scrollToOption = (option) => {
      var _a, _b, _c, _d, _e;
      const targetOption = Array.isArray(option) ? option[0] : option;
      let target = null;
      if (targetOption == null ? void 0 : targetOption.value) {
        const options = optionsArray.value.filter((item) => item.value === targetOption.value);
        if (options.length > 0) {
          target = options[0].$el;
        }
      }
      if (tooltipRef.value && target) {
        const menu = (_d = (_c = (_b = (_a = tooltipRef.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef) == null ? void 0 : _c.querySelector) == null ? void 0 : _d.call(_c, `.${ns.be("dropdown", "wrap")}`);
        if (menu) {
          scrollIntoView(menu, target);
        }
      }
      (_e = scrollbar.value) == null ? void 0 : _e.handleScroll();
    };
    const onOptionCreate = (vm) => {
      states.optionsCount++;
      states.filteredOptionsCount++;
      states.options.set(vm.value, vm);
      states.cachedOptions.set(vm.value, vm);
    };
    const onOptionDestroy = (key, vm) => {
      if (states.options.get(key) === vm) {
        states.optionsCount--;
        states.filteredOptionsCount--;
        states.options.delete(key);
      }
    };
    const resetInputState = (e) => {
      if (e.code !== EVENT_CODE.backspace)
        toggleLastOptionHitState(false);
      states.inputLength = input.value.value.length * 15 + 20;
      resetInputHeight();
    };
    const toggleLastOptionHitState = (hit) => {
      if (!Array.isArray(states.selected))
        return;
      const option = states.selected[states.selected.length - 1];
      if (!option)
        return;
      if (hit === true || hit === false) {
        option.hitState = hit;
        return hit;
      }
      option.hitState = !option.hitState;
      return option.hitState;
    };
    const handleComposition = (event) => {
      const text = event.target.value;
      if (event.type === "compositionend") {
        states.isOnComposition = false;
        vue.nextTick(() => handleQueryChange(text));
      } else {
        const lastCharacter = text[text.length - 1] || "";
        states.isOnComposition = !isKorean(lastCharacter);
      }
    };
    const handleMenuEnter = () => {
      vue.nextTick(() => scrollToOption(states.selected));
    };
    const handleFocus = (event) => {
      if (!states.softFocus) {
        if (props.automaticDropdown || props.filterable) {
          if (props.filterable && !states.visible) {
            states.menuVisibleOnFocus = true;
          }
          states.visible = true;
        }
        ctx.emit("focus", event);
      } else {
        states.softFocus = false;
      }
    };
    const blur = () => {
      var _a;
      states.visible = false;
      (_a = reference.value) == null ? void 0 : _a.blur();
    };
    const handleBlur = (event) => {
      vue.nextTick(() => {
        if (states.isSilentBlur) {
          states.isSilentBlur = false;
        } else {
          ctx.emit("blur", event);
        }
      });
      states.softFocus = false;
    };
    const handleClearClick = (event) => {
      deleteSelected(event);
    };
    const handleClose = () => {
      states.visible = false;
    };
    const toggleMenu = () => {
      var _a;
      if (props.automaticDropdown)
        return;
      if (!selectDisabled.value) {
        if (states.menuVisibleOnFocus) {
          states.menuVisibleOnFocus = false;
        } else {
          states.visible = !states.visible;
        }
        if (states.visible) {
          (_a = input.value || reference.value) == null ? void 0 : _a.focus();
        }
      }
    };
    const selectOption = () => {
      if (!states.visible) {
        toggleMenu();
      } else {
        if (optionsArray.value[states.hoverIndex]) {
          handleOptionSelect(optionsArray.value[states.hoverIndex], void 0);
        }
      }
    };
    const getValueKey = (item) => {
      return isObject$1(item.value) ? get(item.value, props.valueKey) : item.value;
    };
    const optionsAllDisabled = vue.computed(() => optionsArray.value.filter((option) => option.visible).every((option) => option.disabled));
    const navigateOptions = (direction) => {
      if (!states.visible) {
        states.visible = true;
        return;
      }
      if (states.options.size === 0 || states.filteredOptionsCount === 0)
        return;
      if (states.isOnComposition)
        return;
      if (!optionsAllDisabled.value) {
        if (direction === "next") {
          states.hoverIndex++;
          if (states.hoverIndex === states.options.size) {
            states.hoverIndex = 0;
          }
        } else if (direction === "prev") {
          states.hoverIndex--;
          if (states.hoverIndex < 0) {
            states.hoverIndex = states.options.size - 1;
          }
        }
        const option = optionsArray.value[states.hoverIndex];
        if (option.disabled === true || option.states.groupDisabled === true || !option.visible) {
          navigateOptions(direction);
        }
        vue.nextTick(() => scrollToOption(hoverOption.value));
      }
    };
    return {
      optionsArray,
      selectSize,
      handleResize,
      debouncedOnInputChange,
      debouncedQueryChange,
      deletePrevTag,
      deleteTag,
      deleteSelected,
      handleOptionSelect,
      scrollToOption,
      readonly,
      resetInputHeight,
      showClose,
      iconComponent,
      iconReverse,
      showNewOption,
      collapseTagSize,
      setSelected,
      managePlaceholder,
      selectDisabled,
      emptyText,
      toggleLastOptionHitState,
      resetInputState,
      handleComposition,
      onOptionCreate,
      onOptionDestroy,
      handleMenuEnter,
      handleFocus,
      blur,
      handleBlur,
      handleClearClick,
      handleClose,
      toggleMenu,
      selectOption,
      getValueKey,
      navigateOptions,
      dropMenuVisible,
      queryChange,
      groupQueryChange,
      reference,
      input,
      tooltipRef,
      tags,
      selectWrapper,
      scrollbar
    };
  };

  const COMPONENT_NAME$7 = "ElSelect";
  const _sfc_main$I = vue.defineComponent({
    name: COMPONENT_NAME$7,
    componentName: COMPONENT_NAME$7,
    components: {
      ElInput,
      ElSelectMenu: ElSelectMenu$1,
      ElOption: Option,
      ElTag,
      ElScrollbar,
      ElTooltip,
      ElIcon
    },
    directives: { ClickOutside },
    props: {
      name: String,
      id: String,
      modelValue: {
        type: [Array, String, Number, Boolean, Object],
        default: void 0
      },
      autocomplete: {
        type: String,
        default: "off"
      },
      automaticDropdown: Boolean,
      size: {
        type: String,
        validator: isValidComponentSize
      },
      effect: {
        type: String,
        default: "light"
      },
      disabled: Boolean,
      clearable: Boolean,
      filterable: Boolean,
      allowCreate: Boolean,
      loading: Boolean,
      popperClass: {
        type: String,
        default: ""
      },
      remote: Boolean,
      loadingText: String,
      noMatchText: String,
      noDataText: String,
      remoteMethod: Function,
      filterMethod: Function,
      multiple: Boolean,
      multipleLimit: {
        type: Number,
        default: 0
      },
      placeholder: {
        type: String
      },
      defaultFirstOption: Boolean,
      reserveKeyword: {
        type: Boolean,
        default: true
      },
      valueKey: {
        type: String,
        default: "value"
      },
      collapseTags: Boolean,
      collapseTagsTooltip: {
        type: Boolean,
        default: false
      },
      popperAppendToBody: {
        type: Boolean,
        default: void 0
      },
      teleported: useTooltipContentProps.teleported,
      persistent: {
        type: Boolean,
        default: true
      },
      clearIcon: {
        type: [String, Object],
        default: circleClose
      },
      fitInputWidth: {
        type: Boolean,
        default: false
      },
      suffixIcon: {
        type: [String, Object],
        default: arrowUp
      },
      tagType: { ...tagProps.type, default: "info" }
    },
    emits: [
      UPDATE_MODEL_EVENT,
      CHANGE_EVENT,
      "remove-tag",
      "clear",
      "visible-change",
      "focus",
      "blur"
    ],
    setup(props, ctx) {
      const nsSelect = useNamespace("select");
      const nsInput = useNamespace("input");
      const { t } = useLocale();
      const states = useSelectStates(props);
      const {
        optionsArray,
        selectSize,
        readonly,
        handleResize,
        collapseTagSize,
        debouncedOnInputChange,
        debouncedQueryChange,
        deletePrevTag,
        deleteTag,
        deleteSelected,
        handleOptionSelect,
        scrollToOption,
        setSelected,
        resetInputHeight,
        managePlaceholder,
        showClose,
        selectDisabled,
        iconComponent,
        iconReverse,
        showNewOption,
        emptyText,
        toggleLastOptionHitState,
        resetInputState,
        handleComposition,
        onOptionCreate,
        onOptionDestroy,
        handleMenuEnter,
        handleFocus,
        blur,
        handleBlur,
        handleClearClick,
        handleClose,
        toggleMenu,
        selectOption,
        getValueKey,
        navigateOptions,
        dropMenuVisible,
        reference,
        input,
        tooltipRef,
        tags,
        selectWrapper,
        scrollbar,
        queryChange,
        groupQueryChange
      } = useSelect$2(props, states, ctx);
      const { focus } = useFocus(reference);
      const {
        inputWidth,
        selected,
        inputLength,
        filteredOptionsCount,
        visible,
        softFocus,
        selectedLabel,
        hoverIndex,
        query,
        inputHovering,
        currentPlaceholder,
        menuVisibleOnFocus,
        isOnComposition,
        isSilentBlur,
        options,
        cachedOptions,
        optionsCount,
        prefixWidth,
        tagInMultiLine
      } = vue.toRefs(states);
      const wrapperKls = vue.computed(() => {
        const classList = [nsSelect.b()];
        const _selectSize = vue.unref(selectSize);
        if (_selectSize) {
          classList.push(nsSelect.m(_selectSize));
        }
        if (props.disabled) {
          classList.push(nsSelect.m("disabled"));
        }
        return classList;
      });
      const selectTagsStyle = vue.computed(() => ({
        maxWidth: `${vue.unref(inputWidth) - 32}px`,
        width: "100%"
      }));
      vue.provide(selectKey, vue.reactive({
        props,
        options,
        optionsArray,
        cachedOptions,
        optionsCount,
        filteredOptionsCount,
        hoverIndex,
        handleOptionSelect,
        onOptionCreate,
        onOptionDestroy,
        selectWrapper,
        selected,
        setSelected,
        queryChange,
        groupQueryChange
      }));
      vue.onMounted(() => {
        states.cachedPlaceHolder = currentPlaceholder.value = props.placeholder || t("el.select.placeholder");
        if (props.multiple && Array.isArray(props.modelValue) && props.modelValue.length > 0) {
          currentPlaceholder.value = "";
        }
        addResizeListener(selectWrapper.value, handleResize);
        if (reference.value && reference.value.$el) {
          const sizeMap = {
            large: 36,
            default: 32,
            small: 28
          };
          const input2 = reference.value.input;
          states.initialInputHeight = input2.getBoundingClientRect().height || sizeMap[selectSize.value];
        }
        if (props.remote && props.multiple) {
          resetInputHeight();
        }
        vue.nextTick(() => {
          if (!reference.value)
            return;
          if (reference.value.$el) {
            inputWidth.value = reference.value.$el.getBoundingClientRect().width;
          }
          if (ctx.slots.prefix) {
            const inputChildNodes = reference.value.$el.childNodes;
            const input2 = Array.from(inputChildNodes).find((item) => item.tagName === "INPUT");
            const prefix = reference.value.$el.querySelector(`.${nsInput.e("prefix")}`);
            prefixWidth.value = Math.max(prefix.getBoundingClientRect().width + 5, 30);
            if (states.prefixWidth) {
              input2.style.paddingLeft = `${Math.max(states.prefixWidth, 30)}px`;
            }
          }
        });
        setSelected();
      });
      vue.onBeforeUnmount(() => {
        removeResizeListener(selectWrapper.value, handleResize);
      });
      if (props.multiple && !Array.isArray(props.modelValue)) {
        ctx.emit(UPDATE_MODEL_EVENT, []);
      }
      if (!props.multiple && Array.isArray(props.modelValue)) {
        ctx.emit(UPDATE_MODEL_EVENT, "");
      }
      const popperPaneRef = vue.computed(() => {
        var _a, _b;
        return (_b = (_a = tooltipRef.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef;
      });
      const { compatTeleported } = useDeprecateAppendToBody(COMPONENT_NAME$7, "popperAppendToBody");
      return {
        tagInMultiLine,
        prefixWidth,
        selectSize,
        readonly,
        handleResize,
        collapseTagSize,
        debouncedOnInputChange,
        debouncedQueryChange,
        deletePrevTag,
        deleteTag,
        deleteSelected,
        handleOptionSelect,
        scrollToOption,
        inputWidth,
        selected,
        inputLength,
        filteredOptionsCount,
        visible,
        softFocus,
        selectedLabel,
        hoverIndex,
        query,
        inputHovering,
        currentPlaceholder,
        menuVisibleOnFocus,
        isOnComposition,
        isSilentBlur,
        options,
        resetInputHeight,
        managePlaceholder,
        showClose,
        selectDisabled,
        iconComponent,
        iconReverse,
        showNewOption,
        emptyText,
        toggleLastOptionHitState,
        resetInputState,
        handleComposition,
        handleMenuEnter,
        handleFocus,
        blur,
        handleBlur,
        handleClearClick,
        handleClose,
        toggleMenu,
        selectOption,
        getValueKey,
        navigateOptions,
        dropMenuVisible,
        focus,
        reference,
        input,
        tooltipRef,
        popperPaneRef,
        tags,
        selectWrapper,
        scrollbar,
        wrapperKls,
        selectTagsStyle,
        compatTeleported,
        nsSelect
      };
    }
  });
  const _hoisted_1$m = { class: "select-trigger" };
  const _hoisted_2$g = ["disabled", "autocomplete"];
  const _hoisted_3$9 = { style: { "height": "100%", "display": "flex", "justify-content": "center", "align-items": "center" } };
  function _sfc_render$B(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_tag = vue.resolveComponent("el-tag");
    const _component_el_tooltip = vue.resolveComponent("el-tooltip");
    const _component_el_icon = vue.resolveComponent("el-icon");
    const _component_el_input = vue.resolveComponent("el-input");
    const _component_el_option = vue.resolveComponent("el-option");
    const _component_el_scrollbar = vue.resolveComponent("el-scrollbar");
    const _component_el_select_menu = vue.resolveComponent("el-select-menu");
    const _directive_click_outside = vue.resolveDirective("click-outside");
    return vue.withDirectives((vue.openBlock(), vue.createElementBlock("div", {
      ref: "selectWrapper",
      class: vue.normalizeClass(_ctx.wrapperKls),
      onClick: _cache[24] || (_cache[24] = vue.withModifiers((...args) => _ctx.toggleMenu && _ctx.toggleMenu(...args), ["stop"]))
    }, [
      vue.createVNode(_component_el_tooltip, {
        ref: "tooltipRef",
        visible: _ctx.dropMenuVisible,
        "onUpdate:visible": _cache[23] || (_cache[23] = ($event) => _ctx.dropMenuVisible = $event),
        placement: "bottom-start",
        teleported: _ctx.compatTeleported,
        "popper-class": [_ctx.nsSelect.e("popper"), _ctx.popperClass],
        "fallback-placements": ["bottom-start", "top-start", "right", "left"],
        effect: _ctx.effect,
        pure: "",
        trigger: "click",
        transition: `${_ctx.nsSelect.namespace.value}-zoom-in-top`,
        "stop-popper-mouse-event": false,
        "gpu-acceleration": false,
        persistent: _ctx.persistent,
        onShow: _ctx.handleMenuEnter
      }, {
        default: vue.withCtx(() => [
          vue.createElementVNode("div", _hoisted_1$m, [
            _ctx.multiple ? (vue.openBlock(), vue.createElementBlock("div", {
              key: 0,
              ref: "tags",
              class: vue.normalizeClass(_ctx.nsSelect.e("tags")),
              style: vue.normalizeStyle(_ctx.selectTagsStyle)
            }, [
              _ctx.collapseTags && _ctx.selected.length ? (vue.openBlock(), vue.createElementBlock("span", {
                key: 0,
                class: vue.normalizeClass([
                  _ctx.nsSelect.b("tags-wrapper"),
                  { "has-prefix": _ctx.prefixWidth && _ctx.selected.length }
                ])
              }, [
                vue.createVNode(_component_el_tag, {
                  closable: !_ctx.selectDisabled && !_ctx.selected[0].isDisabled,
                  size: _ctx.collapseTagSize,
                  hit: _ctx.selected[0].hitState,
                  type: _ctx.tagType,
                  "disable-transitions": "",
                  onClose: _cache[0] || (_cache[0] = ($event) => _ctx.deleteTag($event, _ctx.selected[0]))
                }, {
                  default: vue.withCtx(() => [
                    vue.createElementVNode("span", {
                      class: vue.normalizeClass(_ctx.nsSelect.e("tags-text")),
                      style: vue.normalizeStyle({ maxWidth: _ctx.inputWidth - 123 + "px" })
                    }, vue.toDisplayString(_ctx.selected[0].currentLabel), 7)
                  ]),
                  _: 1
                }, 8, ["closable", "size", "hit", "type"]),
                _ctx.selected.length > 1 ? (vue.openBlock(), vue.createBlock(_component_el_tag, {
                  key: 0,
                  closable: false,
                  size: _ctx.collapseTagSize,
                  type: _ctx.tagType,
                  "disable-transitions": ""
                }, {
                  default: vue.withCtx(() => [
                    _ctx.collapseTagsTooltip ? (vue.openBlock(), vue.createBlock(_component_el_tooltip, {
                      key: 0,
                      disabled: _ctx.dropMenuVisible,
                      "fallback-placements": ["bottom", "top", "right", "left"],
                      effect: _ctx.effect,
                      placement: "bottom",
                      teleported: false
                    }, {
                      default: vue.withCtx(() => [
                        vue.createElementVNode("span", {
                          class: vue.normalizeClass(_ctx.nsSelect.e("tags-text"))
                        }, "+ " + vue.toDisplayString(_ctx.selected.length - 1), 3)
                      ]),
                      content: vue.withCtx(() => [
                        vue.createElementVNode("div", {
                          class: vue.normalizeClass(_ctx.nsSelect.e("collapse-tags"))
                        }, [
                          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.selected, (item, idx) => {
                            return vue.openBlock(), vue.createElementBlock("div", {
                              key: idx,
                              class: vue.normalizeClass(_ctx.nsSelect.e("collapse-tag"))
                            }, [
                              (vue.openBlock(), vue.createBlock(_component_el_tag, {
                                key: _ctx.getValueKey(item),
                                class: "in-tooltip",
                                closable: !_ctx.selectDisabled && !item.isDisabled,
                                size: _ctx.collapseTagSize,
                                hit: item.hitState,
                                type: _ctx.tagType,
                                "disable-transitions": "",
                                style: { margin: "2px" },
                                onClose: ($event) => _ctx.deleteTag($event, item)
                              }, {
                                default: vue.withCtx(() => [
                                  vue.createElementVNode("span", {
                                    class: vue.normalizeClass(_ctx.nsSelect.e("tags-text")),
                                    style: vue.normalizeStyle({
                                      maxWidth: _ctx.inputWidth - 75 + "px"
                                    })
                                  }, vue.toDisplayString(item.currentLabel), 7)
                                ]),
                                _: 2
                              }, 1032, ["closable", "size", "hit", "type", "onClose"]))
                            ], 2);
                          }), 128))
                        ], 2)
                      ]),
                      _: 1
                    }, 8, ["disabled", "effect"])) : (vue.openBlock(), vue.createElementBlock("span", {
                      key: 1,
                      class: vue.normalizeClass(_ctx.nsSelect.e("tags-text"))
                    }, "+ " + vue.toDisplayString(_ctx.selected.length - 1), 3))
                  ]),
                  _: 1
                }, 8, ["size", "type"])) : vue.createCommentVNode("v-if", true)
              ], 2)) : vue.createCommentVNode("v-if", true),
              vue.createCommentVNode(" <div> "),
              !_ctx.collapseTags ? (vue.openBlock(), vue.createBlock(vue.Transition, {
                key: 1,
                onAfterLeave: _ctx.resetInputHeight
              }, {
                default: vue.withCtx(() => [
                  vue.createElementVNode("span", {
                    class: vue.normalizeClass([
                      _ctx.nsSelect.b("tags-wrapper"),
                      { "has-prefix": _ctx.prefixWidth && _ctx.selected.length }
                    ])
                  }, [
                    (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.selected, (item) => {
                      return vue.openBlock(), vue.createBlock(_component_el_tag, {
                        key: _ctx.getValueKey(item),
                        closable: !_ctx.selectDisabled && !item.isDisabled,
                        size: _ctx.collapseTagSize,
                        hit: item.hitState,
                        type: _ctx.tagType,
                        "disable-transitions": "",
                        onClose: ($event) => _ctx.deleteTag($event, item)
                      }, {
                        default: vue.withCtx(() => [
                          vue.createElementVNode("span", {
                            class: vue.normalizeClass(_ctx.nsSelect.e("tags-text")),
                            style: vue.normalizeStyle({ maxWidth: _ctx.inputWidth - 75 + "px" })
                          }, vue.toDisplayString(item.currentLabel), 7)
                        ]),
                        _: 2
                      }, 1032, ["closable", "size", "hit", "type", "onClose"]);
                    }), 128))
                  ], 2)
                ]),
                _: 1
              }, 8, ["onAfterLeave"])) : vue.createCommentVNode("v-if", true),
              vue.createCommentVNode(" </div> "),
              _ctx.filterable ? vue.withDirectives((vue.openBlock(), vue.createElementBlock("input", {
                key: 2,
                ref: "input",
                "onUpdate:modelValue": _cache[1] || (_cache[1] = ($event) => _ctx.query = $event),
                type: "text",
                class: vue.normalizeClass([_ctx.nsSelect.e("input"), _ctx.nsSelect.is(_ctx.selectSize)]),
                disabled: _ctx.selectDisabled,
                autocomplete: _ctx.autocomplete,
                style: vue.normalizeStyle({
                  marginLeft: _ctx.prefixWidth && !_ctx.selected.length || _ctx.tagInMultiLine ? `${_ctx.prefixWidth}px` : "",
                  flexGrow: 1,
                  width: `${_ctx.inputLength / (_ctx.inputWidth - 32)}%`,
                  maxWidth: `${_ctx.inputWidth - 42}px`
                }),
                onFocus: _cache[2] || (_cache[2] = (...args) => _ctx.handleFocus && _ctx.handleFocus(...args)),
                onBlur: _cache[3] || (_cache[3] = (...args) => _ctx.handleBlur && _ctx.handleBlur(...args)),
                onKeyup: _cache[4] || (_cache[4] = (...args) => _ctx.managePlaceholder && _ctx.managePlaceholder(...args)),
                onKeydown: [
                  _cache[5] || (_cache[5] = (...args) => _ctx.resetInputState && _ctx.resetInputState(...args)),
                  _cache[6] || (_cache[6] = vue.withKeys(vue.withModifiers(($event) => _ctx.navigateOptions("next"), ["prevent"]), ["down"])),
                  _cache[7] || (_cache[7] = vue.withKeys(vue.withModifiers(($event) => _ctx.navigateOptions("prev"), ["prevent"]), ["up"])),
                  _cache[8] || (_cache[8] = vue.withKeys(vue.withModifiers(($event) => _ctx.visible = false, ["stop", "prevent"]), ["esc"])),
                  _cache[9] || (_cache[9] = vue.withKeys(vue.withModifiers((...args) => _ctx.selectOption && _ctx.selectOption(...args), ["stop", "prevent"]), ["enter"])),
                  _cache[10] || (_cache[10] = vue.withKeys((...args) => _ctx.deletePrevTag && _ctx.deletePrevTag(...args), ["delete"])),
                  _cache[11] || (_cache[11] = vue.withKeys(($event) => _ctx.visible = false, ["tab"]))
                ],
                onCompositionstart: _cache[12] || (_cache[12] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
                onCompositionupdate: _cache[13] || (_cache[13] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
                onCompositionend: _cache[14] || (_cache[14] = (...args) => _ctx.handleComposition && _ctx.handleComposition(...args)),
                onInput: _cache[15] || (_cache[15] = (...args) => _ctx.debouncedQueryChange && _ctx.debouncedQueryChange(...args))
              }, null, 46, _hoisted_2$g)), [
                [vue.vModelText, _ctx.query]
              ]) : vue.createCommentVNode("v-if", true)
            ], 6)) : vue.createCommentVNode("v-if", true),
            vue.createVNode(_component_el_input, {
              id: _ctx.id,
              ref: "reference",
              modelValue: _ctx.selectedLabel,
              "onUpdate:modelValue": _cache[16] || (_cache[16] = ($event) => _ctx.selectedLabel = $event),
              type: "text",
              placeholder: _ctx.currentPlaceholder,
              name: _ctx.name,
              autocomplete: _ctx.autocomplete,
              size: _ctx.selectSize,
              disabled: _ctx.selectDisabled,
              readonly: _ctx.readonly,
              "validate-event": false,
              class: vue.normalizeClass([_ctx.nsSelect.is("focus", _ctx.visible)]),
              tabindex: _ctx.multiple && _ctx.filterable ? -1 : void 0,
              onFocus: _ctx.handleFocus,
              onBlur: _ctx.handleBlur,
              onInput: _ctx.debouncedOnInputChange,
              onPaste: _ctx.debouncedOnInputChange,
              onCompositionstart: _ctx.handleComposition,
              onCompositionupdate: _ctx.handleComposition,
              onCompositionend: _ctx.handleComposition,
              onKeydown: [
                _cache[17] || (_cache[17] = vue.withKeys(vue.withModifiers(($event) => _ctx.navigateOptions("next"), ["stop", "prevent"]), ["down"])),
                _cache[18] || (_cache[18] = vue.withKeys(vue.withModifiers(($event) => _ctx.navigateOptions("prev"), ["stop", "prevent"]), ["up"])),
                vue.withKeys(vue.withModifiers(_ctx.selectOption, ["stop", "prevent"]), ["enter"]),
                _cache[19] || (_cache[19] = vue.withKeys(vue.withModifiers(($event) => _ctx.visible = false, ["stop", "prevent"]), ["esc"])),
                _cache[20] || (_cache[20] = vue.withKeys(($event) => _ctx.visible = false, ["tab"]))
              ],
              onMouseenter: _cache[21] || (_cache[21] = ($event) => _ctx.inputHovering = true),
              onMouseleave: _cache[22] || (_cache[22] = ($event) => _ctx.inputHovering = false)
            }, vue.createSlots({
              suffix: vue.withCtx(() => [
                _ctx.iconComponent ? vue.withDirectives((vue.openBlock(), vue.createBlock(_component_el_icon, {
                  key: 0,
                  class: vue.normalizeClass([_ctx.nsSelect.e("caret"), _ctx.nsSelect.e("icon"), _ctx.iconReverse])
                }, {
                  default: vue.withCtx(() => [
                    (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.iconComponent)))
                  ]),
                  _: 1
                }, 8, ["class"])), [
                  [vue.vShow, !_ctx.showClose]
                ]) : vue.createCommentVNode("v-if", true),
                _ctx.showClose && _ctx.clearIcon ? (vue.openBlock(), vue.createBlock(_component_el_icon, {
                  key: 1,
                  class: vue.normalizeClass([_ctx.nsSelect.e("caret"), _ctx.nsSelect.e("icon")]),
                  onClick: _ctx.handleClearClick
                }, {
                  default: vue.withCtx(() => [
                    (vue.openBlock(), vue.createBlock(vue.resolveDynamicComponent(_ctx.clearIcon)))
                  ]),
                  _: 1
                }, 8, ["class", "onClick"])) : vue.createCommentVNode("v-if", true)
              ]),
              _: 2
            }, [
              _ctx.$slots.prefix ? {
                name: "prefix",
                fn: vue.withCtx(() => [
                  vue.createElementVNode("div", _hoisted_3$9, [
                    vue.renderSlot(_ctx.$slots, "prefix")
                  ])
                ])
              } : void 0
            ]), 1032, ["id", "modelValue", "placeholder", "name", "autocomplete", "size", "disabled", "readonly", "class", "tabindex", "onFocus", "onBlur", "onInput", "onPaste", "onCompositionstart", "onCompositionupdate", "onCompositionend", "onKeydown"])
          ])
        ]),
        content: vue.withCtx(() => [
          vue.createVNode(_component_el_select_menu, null, {
            default: vue.withCtx(() => [
              vue.withDirectives(vue.createVNode(_component_el_scrollbar, {
                ref: "scrollbar",
                tag: "ul",
                "wrap-class": _ctx.nsSelect.be("dropdown", "wrap"),
                "view-class": _ctx.nsSelect.be("dropdown", "list"),
                class: vue.normalizeClass([
                  _ctx.nsSelect.is("empty", !_ctx.allowCreate && _ctx.query && _ctx.filteredOptionsCount === 0)
                ])
              }, {
                default: vue.withCtx(() => [
                  _ctx.showNewOption ? (vue.openBlock(), vue.createBlock(_component_el_option, {
                    key: 0,
                    value: _ctx.query,
                    created: true
                  }, null, 8, ["value"])) : vue.createCommentVNode("v-if", true),
                  vue.renderSlot(_ctx.$slots, "default")
                ]),
                _: 3
              }, 8, ["wrap-class", "view-class", "class"]), [
                [vue.vShow, _ctx.options.size > 0 && !_ctx.loading]
              ]),
              _ctx.emptyText && (!_ctx.allowCreate || _ctx.loading || _ctx.allowCreate && _ctx.options.size === 0) ? (vue.openBlock(), vue.createElementBlock(vue.Fragment, { key: 0 }, [
                _ctx.$slots.empty ? vue.renderSlot(_ctx.$slots, "empty", { key: 0 }) : (vue.openBlock(), vue.createElementBlock("p", {
                  key: 1,
                  class: vue.normalizeClass(_ctx.nsSelect.be("dropdown", "empty"))
                }, vue.toDisplayString(_ctx.emptyText), 3))
              ], 2112)) : vue.createCommentVNode("v-if", true)
            ]),
            _: 3
          })
        ]),
        _: 3
      }, 8, ["visible", "teleported", "popper-class", "effect", "transition", "persistent", "onShow"])
    ], 2)), [
      [_directive_click_outside, _ctx.handleClose, _ctx.popperPaneRef]
    ]);
  }
  var Select$1 = /* @__PURE__ */ _export_sfc(_sfc_main$I, [["render", _sfc_render$B]]);

  const _sfc_main$H = vue.defineComponent({
    name: "ElOptionGroup",
    componentName: "ElOptionGroup",
    props: {
      label: String,
      disabled: {
        type: Boolean,
        default: false
      }
    },
    setup(props) {
      const ns = useNamespace("select");
      const visible = vue.ref(true);
      const instance = vue.getCurrentInstance();
      const children = vue.ref([]);
      vue.provide(selectGroupKey, vue.reactive({
        ...vue.toRefs(props)
      }));
      const select = vue.inject(selectKey);
      vue.onMounted(() => {
        children.value = flattedChildren(instance.subTree);
      });
      const flattedChildren = (node) => {
        const children2 = [];
        if (Array.isArray(node.children)) {
          node.children.forEach((child) => {
            var _a;
            if (child.type && child.type.name === "ElOption" && child.component && child.component.proxy) {
              children2.push(child.component.proxy);
            } else if ((_a = child.children) == null ? void 0 : _a.length) {
              children2.push(...flattedChildren(child));
            }
          });
        }
        return children2;
      };
      const { groupQueryChange } = vue.toRaw(select);
      vue.watch(groupQueryChange, () => {
        visible.value = children.value.some((option) => option.visible === true);
      });
      return {
        visible,
        ns
      };
    }
  });
  function _sfc_render$A(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.withDirectives((vue.openBlock(), vue.createElementBlock("ul", {
      class: vue.normalizeClass(_ctx.ns.be("group", "wrap"))
    }, [
      vue.createElementVNode("li", {
        class: vue.normalizeClass(_ctx.ns.be("group", "title"))
      }, vue.toDisplayString(_ctx.label), 3),
      vue.createElementVNode("li", null, [
        vue.createElementVNode("ul", {
          class: vue.normalizeClass(_ctx.ns.b("group"))
        }, [
          vue.renderSlot(_ctx.$slots, "default")
        ], 2)
      ])
    ], 2)), [
      [vue.vShow, _ctx.visible]
    ]);
  }
  var OptionGroup = /* @__PURE__ */ _export_sfc(_sfc_main$H, [["render", _sfc_render$A]]);

  const ElSelect = withInstall(Select$1, {
    Option,
    OptionGroup
  });
  const ElOption$1 = withNoopInstall(Option);
  const ElOptionGroup = withNoopInstall(OptionGroup);

  const usePagination = () => vue.inject(elPaginationKey, {});

  const paginationSizesProps = buildProps({
    pageSize: {
      type: Number,
      required: true
    },
    pageSizes: {
      type: definePropType(Array),
      default: () => mutable([10, 20, 30, 40, 50, 100])
    },
    popperClass: {
      type: String,
      default: ""
    },
    disabled: Boolean,
    size: {
      type: String,
      default: "default"
    }
  });
  const _sfc_main$G = vue.defineComponent({
    name: "ElPaginationSizes",
    components: {
      ElSelect,
      ElOption: ElOption$1
    },
    props: paginationSizesProps,
    emits: ["page-size-change"],
    setup(props, { emit }) {
      const { t } = useLocale();
      const ns = useNamespace("pagination");
      const pagination = usePagination();
      const innerPageSize = vue.ref(props.pageSize);
      vue.watch(() => props.pageSizes, (newVal, oldVal) => {
        if (isEqual$1(newVal, oldVal))
          return;
        if (Array.isArray(newVal)) {
          const pageSize = newVal.includes(props.pageSize) ? props.pageSize : props.pageSizes[0];
          emit("page-size-change", pageSize);
        }
      });
      vue.watch(() => props.pageSize, (newVal) => {
        innerPageSize.value = newVal;
      });
      const innerPagesizes = vue.computed(() => props.pageSizes);
      function handleChange(val) {
        var _a;
        if (val !== innerPageSize.value) {
          innerPageSize.value = val;
          (_a = pagination.handleSizeChange) == null ? void 0 : _a.call(pagination, Number(val));
        }
      }
      return {
        ns,
        innerPagesizes,
        innerPageSize,
        t,
        handleChange
      };
    }
  });
  function _sfc_render$z(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_option = vue.resolveComponent("el-option");
    const _component_el_select = vue.resolveComponent("el-select");
    return vue.openBlock(), vue.createElementBlock("span", {
      class: vue.normalizeClass(_ctx.ns.e("sizes"))
    }, [
      vue.createVNode(_component_el_select, {
        "model-value": _ctx.innerPageSize,
        disabled: _ctx.disabled,
        "popper-class": _ctx.popperClass,
        size: _ctx.size,
        onChange: _ctx.handleChange
      }, {
        default: vue.withCtx(() => [
          (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.innerPagesizes, (item) => {
            return vue.openBlock(), vue.createBlock(_component_el_option, {
              key: item,
              value: item,
              label: item + _ctx.t("el.pagination.pagesize")
            }, null, 8, ["value", "label"]);
          }), 128))
        ]),
        _: 1
      }, 8, ["model-value", "disabled", "popper-class", "size", "onChange"])
    ], 2);
  }
  var Sizes = /* @__PURE__ */ _export_sfc(_sfc_main$G, [["render", _sfc_render$z]]);

  const _sfc_main$F = vue.defineComponent({
    name: "ElPaginationJumper",
    components: {
      ElInput
    },
    setup() {
      const { t } = useLocale();
      const ns = useNamespace("pagination");
      const { pageCount, disabled, currentPage, changeEvent } = usePagination();
      const userInput = vue.ref();
      const innerValue = vue.computed(() => {
        var _a;
        return (_a = userInput.value) != null ? _a : currentPage == null ? void 0 : currentPage.value;
      });
      function handleInput(val) {
        userInput.value = +val;
      }
      function handleChange(val) {
        val = Math.trunc(+val);
        changeEvent == null ? void 0 : changeEvent(+val);
        userInput.value = void 0;
      }
      return {
        ns,
        pageCount,
        disabled,
        innerValue,
        t,
        handleInput,
        handleChange
      };
    }
  });
  const _hoisted_1$l = ["disabled"];
  function _sfc_render$y(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_el_input = vue.resolveComponent("el-input");
    return vue.openBlock(), vue.createElementBlock("span", {
      class: vue.normalizeClass(_ctx.ns.e("jump")),
      disabled: _ctx.disabled
    }, [
      vue.createTextVNode(vue.toDisplayString(_ctx.t("el.pagination.goto")) + " ", 1),
      vue.createVNode(_component_el_input, {
        size: "small",
        class: vue.normalizeClass([_ctx.ns.e("editor"), _ctx.ns.is("in-pagination")]),
        min: 1,
        max: _ctx.pageCount,
        disabled: _ctx.disabled,
        "model-value": _ctx.innerValue,
        type: "number",
        "onUpdate:modelValue": _ctx.handleInput,
        onChange: _ctx.handleChange
      }, null, 8, ["class", "max", "disabled", "model-value", "onUpdate:modelValue", "onChange"]),
      vue.createTextVNode(" " + vue.toDisplayString(_ctx.t("el.pagination.pageClassifier")), 1)
    ], 10, _hoisted_1$l);
  }
  var Jumper = /* @__PURE__ */ _export_sfc(_sfc_main$F, [["render", _sfc_render$y]]);

  const paginationTotalProps = {
    total: {
      type: Number,
      default: 1e3
    }
  };
  const _sfc_main$E = vue.defineComponent({
    name: "ElPaginationTotal",
    props: paginationTotalProps,
    setup() {
      const { t } = useLocale();
      const ns = useNamespace("pagination");
      const { disabled } = usePagination();
      return {
        t,
        ns,
        disabled
      };
    }
  });
  const _hoisted_1$k = ["disabled"];
  function _sfc_render$x(_ctx, _cache, $props, $setup, $data, $options) {
    return vue.openBlock(), vue.createElementBlock("span", {
      class: vue.normalizeClass(_ctx.ns.e("total")),
      disabled: _ctx.disabled
    }, vue.toDisplayString(_ctx.t("el.pagination.total", {
      total: _ctx.total
    })), 11, _hoisted_1$k);
  }
  var Total = /* @__PURE__ */ _export_sfc(_sfc_main$E, [["render", _sfc_render$x]]);

  const paginationPagerProps = {
    currentPage: {
      type: Number,
      default: 1
    },
    pageCount: {
      type: Number,
      required: true
    },
    pagerCount: {
      type: Number,
      default: 7
    },
    disabled: Boolean
  };
  const _sfc_main$D = vue.defineComponent({
    name: "ElPaginationPager",
    components: {
      DArrowLeft: dArrowLeft,
      DArrowRight: dArrowRight,
      MoreFilled: moreFilled
    },
    props: paginationPagerProps,
    emits: ["change"],
    setup(props, { emit }) {
      const nsPager = useNamespace("pager");
      const nsIcon = useNamespace("icon");
      const showPrevMore = vue.ref(false);
      const showNextMore = vue.ref(false);
      const quickPrevHover = vue.ref(false);
      const quickNextHover = vue.ref(false);
      const pagers = vue.computed(() => {
        const pagerCount = props.pagerCount;
        const halfPagerCount = (pagerCount - 1) / 2;
        const currentPage = Number(props.currentPage);
        const pageCount = Number(props.pageCount);
        let showPrevMore2 = false;
        let showNextMore2 = false;
        if (pageCount > pagerCount) {
          if (currentPage > pagerCount - halfPagerCount) {
            showPrevMore2 = true;
          }
          if (currentPage < pageCount - halfPagerCount) {
            showNextMore2 = true;
          }
        }
        const array = [];
        if (showPrevMore2 && !showNextMore2) {
          const startPage = pageCount - (pagerCount - 2);
          for (let i = startPage; i < pageCount; i++) {
            array.push(i);
          }
        } else if (!showPrevMore2 && showNextMore2) {
          for (let i = 2; i < pagerCount; i++) {
            array.push(i);
          }
        } else if (showPrevMore2 && showNextMore2) {
          const offset = Math.floor(pagerCount / 2) - 1;
          for (let i = currentPage - offset; i <= currentPage + offset; i++) {
            array.push(i);
          }
        } else {
          for (let i = 2; i < pageCount; i++) {
            array.push(i);
          }
        }
        return array;
      });
      vue.watchEffect(() => {
        const halfPagerCount = (props.pagerCount - 1) / 2;
        showPrevMore.value = false;
        showNextMore.value = false;
        if (props.pageCount > props.pagerCount) {
          if (props.currentPage > props.pagerCount - halfPagerCount) {
            showPrevMore.value = true;
          }
          if (props.currentPage < props.pageCount - halfPagerCount) {
            showNextMore.value = true;
          }
        }
      });
      function onMouseenter(direction) {
        if (props.disabled)
          return;
        if (direction === "left") {
          quickPrevHover.value = true;
        } else {
          quickNextHover.value = true;
        }
      }
      function onEnter(e) {
        const target = e.target;
        if (target.tagName.toLowerCase() === "li" && Array.from(target.classList).includes("number")) {
          const newPage = Number(target.textContent);
          if (newPage !== props.currentPage) {
            emit("change", newPage);
          }
        }
      }
      function onPagerClick(event) {
        const target = event.target;
        if (target.tagName.toLowerCase() === "ul" || props.disabled) {
          return;
        }
        let newPage = Number(target.textContent);
        const pageCount = props.pageCount;
        const currentPage = props.currentPage;
        const pagerCountOffset = props.pagerCount - 2;
        if (target.className.includes("more")) {
          if (target.className.includes("quickprev")) {
            newPage = currentPage - pagerCountOffset;
          } else if (target.className.includes("quicknext")) {
            newPage = currentPage + pagerCountOffset;
          }
        }
        if (!Number.isNaN(+newPage)) {
          if (newPage < 1) {
            newPage = 1;
          }
          if (newPage > pageCount) {
            newPage = pageCount;
          }
        }
        if (newPage !== currentPage) {
          emit("change", newPage);
        }
      }
      return {
        showPrevMore,
        showNextMore,
        quickPrevHover,
        quickNextHover,
        pagers,
        nsPager,
        nsIcon,
        onMouseenter,
        onPagerClick,
        onEnter
      };
    }
  });
  const _hoisted_1$j = ["aria-current"];
  const _hoisted_2$f = ["aria-current"];
  const _hoisted_3$8 = ["aria-current"];
  function _sfc_render$w(_ctx, _cache, $props, $setup, $data, $options) {
    const _component_d_arrow_left = vue.resolveComponent("d-arrow-left");
    const _component_more_filled = vue.resolveComponent("more-filled");
    const _component_d_arrow_right = vue.resolveComponent("d-arrow-right");
    return vue.openBlock(), vue.createElementBlock("ul", {
      class: vue.normalizeClass(_ctx.nsPager.b()),
      onClick: _cache[4] || (_cache[4] = (...args) => _ctx.onPagerClick && _ctx.onPagerClick(...args)),
      onKeyup: _cache[5] || (_cache[5] = vue.withKeys((...args) => _ctx.onEnter && _ctx.onEnter(...args), ["enter"]))
    }, [
      _ctx.pageCount > 0 ? (vue.openBlock(), vue.createElementBlock("li", {
        key: 0,
        class: vue.normalizeClass([[
          _ctx.nsPager.is("active", _ctx.currentPage === 1),
          _ctx.nsPager.is("disabled", _ctx.disabled)
        ], "number"]),
        "aria-current": _ctx.currentPage === 1,
        tabindex: "0"
      }, " 1 ", 10, _hoisted_1$j)) : vue.createCommentVNode("v-if", true),
      _ctx.showPrevMore ? (vue.openBlock(), vue.createElementBlock("li", {
        key: 1,
        class: vue.normalizeClass([
          "more",
          "btn-quickprev",
          _ctx.nsIcon.b(),
          _ctx.nsPager.is("disabled", _ctx.disabled)
        ]),
        onMouseenter: _cache[0] || (_cache[0] = ($event) => _ctx.onMouseenter("left")),
        onMouseleave: _cache[1] || (_cache[1] = ($event) => _ctx.quickPrevHover = false)
      }, [
        _ctx.quickPrevHover ? (vue.openBlock(), vue.createBlock(_component_d_arrow_left, { key: 0 })) : (vue.openBlock(), vue.createBlock(_component_more_filled, { key: 1 }))
      ], 34)) : vue.createCommentVNode("v-if", true),
      (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.pagers, (pager) => {
        return vue.openBlock(), vue.createElementBlock("li", {
          key: pager,
          class: vue.normalizeClass([[
            _ctx.nsPager.is("active", _ctx.currentPage === pager),
            _ctx.nsPager.is("disabled", _ctx.disabled)
          ], "number"]),
          "aria-current": _ctx.currentPage === pager,
          tabindex: "0"
        }, vue.toDisplayString(pager), 11, _hoisted_2$f);
      }), 128)),
      _ctx.showNextMore ? (vue.openBlock(), vue.createElementBlock("li", {
        key: 2,
        class: vue.normalizeClass([
          "more",
          "btn-quicknext",
          _ctx.nsIcon.b(),
          _ctx.nsPager.is("disabled", _ctx.disabled)
        ]),
        onMouseenter: _cache[2] || (_cache[2] = ($event) => _ctx.onMouseenter("right")),
        onMouseleave: _cache[3] || (_cache[3] = ($event) => _ctx.quickNextHover = false)
      }, [
        _ctx.quickNextHover ? (vue.openBlock(), vue.createBlock(_component_d_arrow_right, { key: 0 })) : (vue.openBlock(), vue.createBlock(_component_more_filled, { key: 1 }))
      ], 34)) : vue.createCommentVNode("v-if", true),
      _ctx.pageCount > 1 ? (vue.openBlock(), vue.createElementBlock("li", {
        key: 3,
        class: vue.normalizeClass([[
          _ctx.nsPager.is("active", _ctx.currentPage === _ctx.pageCount),
          _ctx.nsPager.is("disabled", _ctx.disabled)
        ], "number"]),
        "aria-current": _ctx.currentPage === _ctx.pageCount,
        tabindex: "0"
      }, vue.toDisplayString(_ctx.pageCount), 11, _hoisted_3$8)) : vue.createCommentVNode("v-if", true)
    ], 34);
  }
  var Pager = /* @__PURE__ */ _export_sfc(_sfc_main$D, [["render", _sfc_render$w]]);

  const isAbsent = (v) => typeof v !== "number";
  const paginationProps = buildProps({
    total: Number,
    pageSize: Number,
    defaultPageSize: Number,
    currentPage: Number,
    defaultCurrentPage: Number,
    pageCount: Number,
    pagerCount: {
      type: Number,
      validator: (value) => {
        return typeof value === "number" && Math.trunc(value) === value && value > 4 && value < 22 && value % 2 === 1;
      },
      default: 7
    },
    layout: {
      type: String,
      default: ["prev", "pager", "next", "jumper", "->", "total"].join(", ")
    },
    pageSizes: {
      type: definePropType(Array),
      default: () => mutable([10, 20, 30, 40, 50, 100])
    },
    popperClass: {
      type: String,
      default: ""
    },
    prevText: {
      type: String,
      default: ""
    },
    nextText: {
      type: String,
      default: ""
    },
    small: Boolean,
    background: Boolean,
    disabled: Boolean,
    hideOnSinglePage: Boolean
  });
  const paginationEmits = {
    "update:current-page": (val) => typeof val === "number",
    "update:page-size": (val) => typeof val === "number",
    "size-change": (val) => typeof val === "number",
    "current-change": (val) => typeof val === "number",
    "prev-click": (val) => typeof val === "number",
    "next-click": (val) => typeof val === "number"
  };
  const componentName = "ElPagination";
  var Pagination = vue.defineComponent({
    name: componentName,
    props: paginationProps,
    emits: paginationEmits,
    setup(props, { emit, slots }) {
      const { t } = useLocale();
      const ns = useNamespace("pagination");
      const vnodeProps = vue.getCurrentInstance().vnode.props || {};
      const hasCurrentPageListener = "onUpdate:currentPage" in vnodeProps || "onUpdate:current-page" in vnodeProps || "onCurrentChange" in vnodeProps;
      const hasPageSizeListener = "onUpdate:pageSize" in vnodeProps || "onUpdate:page-size" in vnodeProps || "onSizeChange" in vnodeProps;
      const assertValidUsage = vue.computed(() => {
        if (isAbsent(props.total) && isAbsent(props.pageCount))
          return false;
        if (!isAbsent(props.currentPage) && !hasCurrentPageListener)
          return false;
        if (props.layout.includes("sizes")) {
          if (!isAbsent(props.pageCount)) {
            if (!hasPageSizeListener)
              return false;
          } else if (!isAbsent(props.total)) {
            if (!isAbsent(props.pageSize)) {
              if (!hasPageSizeListener) {
                return false;
              }
            }
          }
        }
        return true;
      });
      const innerPageSize = vue.ref(isAbsent(props.defaultPageSize) ? 10 : props.defaultPageSize);
      const innerCurrentPage = vue.ref(isAbsent(props.defaultCurrentPage) ? 1 : props.defaultCurrentPage);
      const pageSizeBridge = vue.computed({
        get() {
          return isAbsent(props.pageSize) ? innerPageSize.value : props.pageSize;
        },
        set(v) {
          if (isAbsent(props.pageSize)) {
            innerPageSize.value = v;
          }
          if (hasPageSizeListener) {
            emit("update:page-size", v);
            emit("size-change", v);
          }
        }
      });
      const pageCountBridge = vue.computed(() => {
        let pageCount = 0;
        if (!isAbsent(props.pageCount)) {
          pageCount = props.pageCount;
        } else if (!isAbsent(props.total)) {
          pageCount = Math.max(1, Math.ceil(props.total / pageSizeBridge.value));
        }
        return pageCount;
      });
      const currentPageBridge = vue.computed({
        get() {
          return isAbsent(props.currentPage) ? innerCurrentPage.value : props.currentPage;
        },
        set(v) {
          let newCurrentPage = v;
          if (v < 1) {
            newCurrentPage = 1;
          } else if (v > pageCountBridge.value) {
            newCurrentPage = pageCountBridge.value;
          }
          if (isAbsent(props.currentPage)) {
            innerCurrentPage.value = newCurrentPage;
          }
          if (hasCurrentPageListener) {
            emit("update:current-page", newCurrentPage);
            emit("current-change", newCurrentPage);
          }
        }
      });
      vue.watch(pageCountBridge, (val) => {
        if (currentPageBridge.value > val)
          currentPageBridge.value = val;
      });
      function handleCurrentChange(val) {
        currentPageBridge.value = val;
      }
      function handleSizeChange(val) {
        pageSizeBridge.value = val;
        const newPageCount = pageCountBridge.value;
        if (currentPageBridge.value > newPageCount) {
          currentPageBridge.value = newPageCount;
        }
      }
      function prev() {
        if (props.disabled)
          return;
        currentPageBridge.value -= 1;
        emit("prev-click", currentPageBridge.value);
      }
      function next() {
        if (props.disabled)
          return;
        currentPageBridge.value += 1;
        emit("next-click", currentPageBridge.value);
      }
      function addClass(element, cls) {
        if (element) {
          if (!element.props) {
            element.props = {};
          }
          element.props.class = [element.props.class, cls].join(" ");
        }
      }
      vue.provide(elPaginationKey, {
        pageCount: pageCountBridge,
        disabled: vue.computed(() => props.disabled),
        currentPage: currentPageBridge,
        changeEvent: handleCurrentChange,
        handleSizeChange
      });
      return () => {
        var _a, _b;
        if (!assertValidUsage.value) {
          debugWarn(componentName, t("el.pagination.deprecationWarning"));
          return null;
        }
        if (!props.layout)
          return null;
        if (props.hideOnSinglePage && pageCountBridge.value <= 1)
          return null;
        const rootChildren = [];
        const rightWrapperChildren = [];
        const rightWrapperRoot = vue.h("div", { class: ns.e("rightwrapper") }, rightWrapperChildren);
        const TEMPLATE_MAP = {
          prev: vue.h(Prev, {
            disabled: props.disabled,
            currentPage: currentPageBridge.value,
            prevText: props.prevText,
            onClick: prev
          }),
          jumper: vue.h(Jumper),
          pager: vue.h(Pager, {
            currentPage: currentPageBridge.value,
            pageCount: pageCountBridge.value,
            pagerCount: props.pagerCount,
            onChange: handleCurrentChange,
            disabled: props.disabled
          }),
          next: vue.h(Next, {
            disabled: props.disabled,
            currentPage: currentPageBridge.value,
            pageCount: pageCountBridge.value,
            nextText: props.nextText,
            onClick: next
          }),
          sizes: vue.h(Sizes, {
            pageSize: pageSize