import { defineComponent, provide, reactive, toRef, openBlock, createElementBlock, normalizeClass, unref, renderSlot } from 'vue';
import '../../../tokens/index.mjs';
import '../../../hooks/index.mjs';
import { buttonGroupProps } from './button-group.mjs';
import { buttonGroupContextKey } from '../../../tokens/button.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

const __default__ = {
  name: "ElButtonGroup"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: buttonGroupProps,
  setup(__props) {
    const props = __props;
    provide(buttonGroupContextKey, reactive({
      size: toRef(props, "size"),
      type: toRef(props, "type")
    }));
    const ns = useNamespace("button");
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        class: normalizeClass(`${unref(ns).b("group")}`)
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=button-group2.mjs.map
