import { defineComponent, useSlots, inject, ref, computed, nextTick, watch, reactive, toRefs, provide, onMounted, onBeforeUnmount, openBlock, createElementBlock, normalizeClass, unref, createVNode, withCtx, normalizeStyle, renderSlot, createTextVNode, toDisplayString, createCommentVNode, createElementVNode, Transition } from 'vue';
import AsyncValidator from 'async-validator';
import { castArray, clone } from 'lodash-unified';
import '../../../utils/index.mjs';
import '../../../tokens/index.mjs';
import '../../../hooks/index.mjs';
import { formItemProps } from './form-item.mjs';
import FormLabelWrap from './form-label-wrap.mjs';
import { formContextKey, formItemContextKey } from '../../../tokens/form.mjs';
import { throwError } from '../../../utils/error.mjs';
import { useSize } from '../../../hooks/use-common-props/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import { addUnit } from '../../../utils/vue/style.mjs';
import { isBoolean } from '@vueuse/core';
import { isString } from '@vue/shared';
import { getProp } from '../../../utils/objects.mjs';

const _hoisted_1 = ["for"];
const __default__ = {
  name: "ElFormItem"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: formItemProps,
  setup(__props, { expose }) {
    const props = __props;
    const COMPONENT_NAME = "ElFormItem";
    const slots = useSlots();
    const formContext = inject(formContextKey);
    if (!formContext)
      throwError(COMPONENT_NAME, "usage: <el-form><el-form-item /></el-form>");
    const parentFormItemContext = inject(formItemContextKey, void 0);
    const _size = useSize(void 0, { formItem: false });
    const ns = useNamespace("form-item");
    const validateState = ref("");
    const validateMessage = ref("");
    const formItemRef = ref();
    let initialValue = void 0;
    const labelStyle = computed(() => {
      if (formContext.labelPosition === "top") {
        return {};
      }
      const labelWidth = addUnit(props.labelWidth || formContext.labelWidth || "");
      if (labelWidth)
        return { width: labelWidth };
      return {};
    });
    const contentStyle = computed(() => {
      if (formContext.labelPosition === "top" || formContext.inline) {
        return {};
      }
      if (!props.label && !props.labelWidth && isNested) {
        return {};
      }
      const labelWidth = addUnit(props.labelWidth || formContext.labelWidth || "");
      if (!props.label && !slots.label) {
        return { marginLeft: labelWidth };
      }
      return {};
    });
    const formItemClasses = computed(() => [
      ns.b(),
      ns.m(_size.value),
      ns.is("error", validateState.value === "error"),
      ns.is("validating", validateState.value === "validating"),
      ns.is("success", validateState.value === "success"),
      ns.is("required", isRequired.value || props.required),
      ns.is("no-asterisk", formContext.hideRequiredAsterisk),
      { [ns.m("feedback")]: formContext.statusIcon }
    ]);
    const _inlineMessage = computed(() => isBoolean(props.inlineMessage) ? props.inlineMessage : formContext.inlineMessage || false);
    const validateClasses = computed(() => [
      ns.e("error"),
      { [ns.em("error", "inline")]: _inlineMessage.value }
    ]);
    const propString = computed(() => {
      if (!props.prop)
        return "";
      return isString(props.prop) ? props.prop : props.prop.join(".");
    });
    const labelFor = computed(() => props.for || propString.value);
    const isNested = !!parentFormItemContext;
    const fieldValue = computed(() => {
      const model = formContext.model;
      if (!model || !props.prop) {
        return;
      }
      return getProp(model, props.prop).value;
    });
    const _rules = computed(() => {
      const rules = props.rules ? castArray(props.rules) : [];
      const formRules = formContext.rules;
      if (formRules && props.prop) {
        const _rules2 = getProp(formRules, props.prop).value;
        if (_rules2) {
          rules.push(...castArray(_rules2));
        }
      }
      if (props.required !== void 0) {
        rules.push({ required: !!props.required });
      }
      return rules;
    });
    const validateEnabled = computed(() => _rules.value.length > 0);
    const getFilteredRule = (trigger) => {
      const rules = _rules.value;
      return rules.filter((rule) => {
        if (!rule.trigger || !trigger)
          return true;
        if (Array.isArray(rule.trigger)) {
          return rule.trigger.includes(trigger);
        } else {
          return rule.trigger === trigger;
        }
      }).map(({ trigger: trigger2, ...rule }) => rule);
    };
    const isRequired = computed(() => _rules.value.some((rule) => rule.required === true));
    const shouldShowError = computed(() => validateState.value === "error" && props.showMessage && formContext.showMessage);
    const currentLabel = computed(() => `${props.label || ""}${formContext.labelSuffix || ""}`);
    const validate = async (trigger, callback) => {
      if (callback) {
        try {
          validate(trigger);
          callback(true);
        } catch (err) {
          callback(false, err);
        }
        validate(trigger).then(() => callback(true)).catch((fields) => callback(false, fields));
        return;
      }
      if (!validateEnabled.value) {
        return;
      }
      const rules = getFilteredRule(trigger);
      if (rules.length === 0) {
        return;
      }
      validateState.value = "validating";
      const descriptor = {
        [propString.value]: rules
      };
      const validator = new AsyncValidator(descriptor);
      const model = {
        [propString.value]: fieldValue.value
      };
      return validator.validate(model, { firstFields: true }).then(() => void 0).catch((err) => {
        const { errors, fields } = err;
        if (!errors || !fields)
          console.error(err);
        validateState.value = "error";
        validateMessage.value = errors ? errors[0].message || `${props.prop} is required` : "";
        formContext.emit("validate", props.prop, !errors, validateMessage.value);
        return Promise.reject(fields);
      });
    };
    const clearValidate = () => {
      validateState.value = "";
      validateMessage.value = "";
    };
    const resetField = () => {
      const model = formContext.model;
      if (!model || !props.prop)
        return;
      getProp(model, props.prop).value = initialValue;
      nextTick(() => clearValidate());
    };
    watch(() => props.error, (val) => {
      validateMessage.value = val || "";
      validateState.value = val ? "error" : "";
    }, { immediate: true });
    watch(() => props.validateStatus, (val) => validateState.value = val || "");
    const context = reactive({
      ...toRefs(props),
      $el: formItemRef,
      size: _size,
      validateState,
      resetField,
      clearValidate,
      validate
    });
    provide(formItemContextKey, context);
    onMounted(() => {
      if (props.prop) {
        formContext.addField(context);
        initialValue = clone(fieldValue.value);
      }
    });
    onBeforeUnmount(() => {
      formContext.removeField(context);
    });
    expose({
      size: _size,
      validateMessage,
      validate,
      clearValidate,
      resetField
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "formItemRef",
        ref: formItemRef,
        class: normalizeClass(unref(formItemClasses))
      }, [
        createVNode(unref(FormLabelWrap), {
          "is-auto-width": unref(labelStyle).width === "auto",
          "update-all": unref(formContext).labelWidth === "auto"
        }, {
          default: withCtx(() => [
            _ctx.label || _ctx.$slots.label ? (openBlock(), createElementBlock("label", {
              key: 0,
              for: unref(labelFor),
              class: normalizeClass(unref(ns).e("label")),
              style: normalizeStyle(unref(labelStyle))
            }, [
              renderSlot(_ctx.$slots, "label", { label: unref(currentLabel) }, () => [
                createTextVNode(toDisplayString(unref(currentLabel)), 1)
              ])
            ], 14, _hoisted_1)) : createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 8, ["is-auto-width", "update-all"]),
        createElementVNode("div", {
          class: normalizeClass(unref(ns).e("content")),
          style: normalizeStyle(unref(contentStyle))
        }, [
          renderSlot(_ctx.$slots, "default"),
          createVNode(Transition, {
            name: `${unref(ns).namespace.value}-zoom-in-top`
          }, {
            default: withCtx(() => [
              unref(shouldShowError) ? renderSlot(_ctx.$slots, "error", {
                key: 0,
                error: validateMessage.value
              }, () => [
                createElementVNode("div", {
                  class: normalizeClass(unref(validateClasses))
                }, toDisplayString(validateMessage.value), 3)
              ]) : createCommentVNode("v-if", true)
            ]),
            _: 3
          }, 8, ["name"])
        ], 6)
      ], 2);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=form-item2.mjs.map
