import { defineComponent, computed, watch, provide, reactive, toRefs, openBlock, createElementBlock, normalizeClass, unref, renderSlot } from 'vue';
import '../../../utils/index.mjs';
import '../../../tokens/index.mjs';
import '../../../hooks/index.mjs';
import { formProps, formEmits } from './form.mjs';
import { filterFields, useFormLabelWidth } from './utils.mjs';
import { useSize } from '../../../hooks/use-common-props/index.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import { debugWarn } from '../../../utils/error.mjs';
import { formContextKey } from '../../../tokens/form.mjs';

const __default__ = {
  name: "ElForm"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: formProps,
  emits: formEmits,
  setup(__props, { expose, emit }) {
    const props = __props;
    const COMPONENT_NAME = "ElForm";
    const fields = [];
    const formSize = useSize();
    const ns = useNamespace("form");
    const formClasses = computed(() => {
      const { labelPosition, inline } = props;
      return [
        ns.b(),
        ns.m(formSize.value),
        {
          [ns.m(`label-${labelPosition}`)]: labelPosition,
          [ns.m("inline")]: inline
        }
      ];
    });
    const addField = (field) => {
      fields.push(field);
    };
    const removeField = (field) => {
      if (!field.prop) {
        fields.splice(fields.indexOf(field), 1);
      }
    };
    const resetFields = (properties = []) => {
      if (!props.model) {
        debugWarn(COMPONENT_NAME, "model is required for resetFields to work.");
        return;
      }
      filterFields(fields, properties).forEach((field) => field.resetField());
    };
    const clearValidate = (props2 = []) => {
      filterFields(fields, props2).forEach((field) => field.clearValidate());
    };
    const validate = async (callback) => validateField(void 0, callback);
    const validateField = async (properties = [], callback) => {
      if (callback) {
        validate().then(() => callback(true)).catch((fields2) => callback(false, fields2));
        return;
      }
      const { model, scrollToError } = props;
      if (!model) {
        debugWarn(COMPONENT_NAME, "model is required for form validation!");
        return;
      }
      if (fields.length === 0) {
        return;
      }
      const filteredFields = filterFields(fields, properties);
      if (!filteredFields.length) {
        debugWarn(COMPONENT_NAME, "please pass correct props!");
        return;
      }
      let valid = true;
      let invalidFields = {};
      let firstInvalidFields;
      for (const field of filteredFields) {
        const fieldsError = await field.validate("").catch((fields2) => fields2);
        if (fieldsError) {
          valid = false;
          if (!firstInvalidFields)
            firstInvalidFields = fieldsError;
        }
        invalidFields = { ...invalidFields, ...fieldsError };
      }
      if (!valid) {
        if (scrollToError)
          scrollToField(Object.keys(firstInvalidFields)[0]);
        return Promise.reject(invalidFields);
      }
    };
    const scrollToField = (prop) => {
      var _a;
      const field = filterFields(fields, prop)[0];
      if (field) {
        (_a = field.$el) == null ? void 0 : _a.scrollIntoView();
      }
    };
    watch(() => props.rules, () => {
      if (props.validateOnRuleChange)
        validate();
    }, { deep: true });
    provide(formContextKey, reactive({
      ...toRefs(props),
      emit,
      resetFields,
      clearValidate,
      validateField,
      addField,
      removeField,
      ...useFormLabelWidth()
    }));
    expose({
      validate,
      validateField,
      resetFields,
      clearValidate,
      scrollToField
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("form", {
        class: normalizeClass(unref(formClasses))
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=form2.mjs.map
