import { defineComponent, ref, computed, onMounted, resolveComponent, openBlock, createBlock, Transition, withCtx, withDirectives, createElementVNode, normalizeClass, normalizeStyle, resolveDynamicComponent, createCommentVNode, toDisplayString, renderSlot, createElementBlock, Fragment, vShow, withModifiers, createVNode } from 'vue';
import { useTimeoutFn, useEventListener } from '@vueuse/core';
import '../../../utils/index.mjs';
import '../../../constants/index.mjs';
import { ElIcon } from '../../icon/index.mjs';
import '../../../hooks/index.mjs';
import { notificationProps, notificationEmits } from './notification.mjs';
import _export_sfc from '../../../_virtual/plugin-vue_export-helper.mjs';
import { TypeComponents, TypeComponentsMap } from '../../../utils/vue/icon.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';
import { EVENT_CODE } from '../../../constants/aria.mjs';

const _sfc_main = defineComponent({
  name: "ElNotification",
  components: {
    ElIcon,
    ...TypeComponents
  },
  props: notificationProps,
  emits: notificationEmits,
  setup(props) {
    const ns = useNamespace("notification");
    const visible = ref(false);
    let timer = void 0;
    const typeClass = computed(() => {
      const type = props.type;
      return type && TypeComponentsMap[props.type] ? ns.m(type) : "";
    });
    const iconComponent = computed(() => {
      return TypeComponentsMap[props.type] || props.icon || "";
    });
    const horizontalClass = computed(() => props.position.endsWith("right") ? "right" : "left");
    const verticalProperty = computed(() => props.position.startsWith("top") ? "top" : "bottom");
    const positionStyle = computed(() => {
      return {
        [verticalProperty.value]: `${props.offset}px`,
        zIndex: props.zIndex
      };
    });
    function startTimer() {
      if (props.duration > 0) {
        ;
        ({ stop: timer } = useTimeoutFn(() => {
          if (visible.value)
            close();
        }, props.duration));
      }
    }
    function clearTimer() {
      timer == null ? void 0 : timer();
    }
    function close() {
      visible.value = false;
    }
    function onKeydown({ code }) {
      if (code === EVENT_CODE.delete || code === EVENT_CODE.backspace) {
        clearTimer();
      } else if (code === EVENT_CODE.esc) {
        if (visible.value) {
          close();
        }
      } else {
        startTimer();
      }
    }
    onMounted(() => {
      startTimer();
      visible.value = true;
    });
    useEventListener(document, "keydown", onKeydown);
    return {
      ns,
      horizontalClass,
      typeClass,
      iconComponent,
      positionStyle,
      visible,
      close,
      clearTimer,
      startTimer
    };
  }
});
const _hoisted_1 = ["id"];
const _hoisted_2 = ["textContent"];
const _hoisted_3 = { key: 0 };
const _hoisted_4 = ["innerHTML"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_icon = resolveComponent("el-icon");
  const _component_close = resolveComponent("close");
  return openBlock(), createBlock(Transition, {
    name: _ctx.ns.b("fade"),
    onBeforeLeave: _ctx.onClose,
    onAfterLeave: _cache[3] || (_cache[3] = ($event) => _ctx.$emit("destroy"))
  }, {
    default: withCtx(() => [
      withDirectives(createElementVNode("div", {
        id: _ctx.id,
        class: normalizeClass([_ctx.ns.b(), _ctx.customClass, _ctx.horizontalClass]),
        style: normalizeStyle(_ctx.positionStyle),
        role: "alert",
        onMouseenter: _cache[0] || (_cache[0] = (...args) => _ctx.clearTimer && _ctx.clearTimer(...args)),
        onMouseleave: _cache[1] || (_cache[1] = (...args) => _ctx.startTimer && _ctx.startTimer(...args)),
        onClick: _cache[2] || (_cache[2] = (...args) => _ctx.onClick && _ctx.onClick(...args))
      }, [
        _ctx.iconComponent ? (openBlock(), createBlock(_component_el_icon, {
          key: 0,
          class: normalizeClass([_ctx.ns.e("icon"), _ctx.typeClass])
        }, {
          default: withCtx(() => [
            (openBlock(), createBlock(resolveDynamicComponent(_ctx.iconComponent)))
          ]),
          _: 1
        }, 8, ["class"])) : createCommentVNode("v-if", true),
        createElementVNode("div", {
          class: normalizeClass(_ctx.ns.e("group"))
        }, [
          createElementVNode("h2", {
            class: normalizeClass(_ctx.ns.e("title")),
            textContent: toDisplayString(_ctx.title)
          }, null, 10, _hoisted_2),
          withDirectives(createElementVNode("div", {
            class: normalizeClass(_ctx.ns.e("content")),
            style: normalizeStyle(!!_ctx.title ? void 0 : { margin: 0 })
          }, [
            renderSlot(_ctx.$slots, "default", {}, () => [
              !_ctx.dangerouslyUseHTMLString ? (openBlock(), createElementBlock("p", _hoisted_3, toDisplayString(_ctx.message), 1)) : (openBlock(), createElementBlock(Fragment, { key: 1 }, [
                createCommentVNode(" Caution here, message could've been compromized, nerver use user's input as message "),
                createCommentVNode(" eslint-disable-next-line "),
                createElementVNode("p", { innerHTML: _ctx.message }, null, 8, _hoisted_4)
              ], 2112))
            ])
          ], 6), [
            [vShow, _ctx.message]
          ]),
          _ctx.showClose ? (openBlock(), createBlock(_component_el_icon, {
            key: 0,
            class: normalizeClass(_ctx.ns.e("closeBtn")),
            onClick: withModifiers(_ctx.close, ["stop"])
          }, {
            default: withCtx(() => [
              createVNode(_component_close)
            ]),
            _: 1
          }, 8, ["class", "onClick"])) : createCommentVNode("v-if", true)
        ], 2)
      ], 46, _hoisted_1), [
        [vShow, _ctx.visible]
      ])
    ]),
    _: 3
  }, 8, ["name", "onBeforeLeave"]);
}
var NotificationConstructor = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render]]);

export { NotificationConstructor as default };
//# sourceMappingURL=notification2.mjs.map
