import { defineComponent, ref, computed, openBlock, createBlock, Teleport, createElementVNode, normalizeClass, unref, normalizeStyle, renderSlot, createCommentVNode } from 'vue';
import '../../../hooks/index.mjs';
import { teleportProps } from './teleport.mjs';
import { useNamespace } from '../../../hooks/use-namespace/index.mjs';

const _sfc_main = /* @__PURE__ */ defineComponent({
  props: teleportProps,
  setup(__props, { expose }) {
    const props = __props;
    const ns = useNamespace("teleport");
    const containerRef = ref();
    const containerStyle = computed(() => {
      return props.container === "body" ? [
        props.style,
        {
          position: "absolute",
          top: `0px`,
          left: `0px`,
          zIndex: props.zIndex
        }
      ] : {};
    });
    expose({
      containerRef
    });
    return (_ctx, _cache) => {
      return _ctx.container ? (openBlock(), createBlock(Teleport, {
        key: 0,
        to: _ctx.container,
        disabled: _ctx.disabled
      }, [
        createElementVNode("div", {
          ref_key: "containerRef",
          ref: containerRef,
          class: normalizeClass(unref(ns).b()),
          style: normalizeStyle(unref(containerStyle))
        }, [
          renderSlot(_ctx.$slots, "default")
        ], 6)
      ], 8, ["to", "disabled"])) : createCommentVNode("v-if", true);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=teleport2.mjs.map
