import { defineComponent, shallowRef, computed, onBeforeUnmount, provide, toRef, useSlots, openBlock, createElementBlock, unref, createBlock, createSlots, withCtx, mergeProps, renderSlot, createCommentVNode } from 'vue';
import '../../../tokens/index.mjs';
import '../../../hooks/index.mjs';
import _sfc_main$1 from './upload-list2.mjs';
import _sfc_main$2 from './upload-content2.mjs';
import { useHandlers } from './use-handlers.mjs';
import { uploadProps } from './upload.mjs';
import { useDisabled } from '../../../hooks/use-common-props/index.mjs';
import { uploadContextKey } from '../../../tokens/upload.mjs';

const __default__ = {
  name: "ElUpload"
};
const _sfc_main = /* @__PURE__ */ defineComponent({
  ...__default__,
  props: uploadProps,
  setup(__props, { expose }) {
    const props = __props;
    const disabled = useDisabled();
    const uploadRef = shallowRef();
    const {
      abort,
      submit,
      clearFiles,
      uploadFiles,
      handleStart,
      handleError,
      handleRemove,
      handleSuccess,
      handleProgress
    } = useHandlers(props, uploadRef);
    const isPictureCard = computed(() => props.listType === "picture-card");
    onBeforeUnmount(() => {
      uploadFiles.value.forEach(({ url }) => {
        if (url == null ? void 0 : url.startsWith("blob:"))
          URL.revokeObjectURL(url);
      });
    });
    provide(uploadContextKey, {
      accept: toRef(props, "accept")
    });
    expose({
      abort,
      submit,
      clearFiles,
      handleStart,
      handleRemove
    });
    const slots = useSlots();
    const uploadContentProps = computed(() => ({
      type: props.type,
      drag: props.drag,
      action: props.action,
      multiple: props.multiple,
      withCredentials: props.withCredentials,
      headers: props.headers,
      method: props.method,
      name: props.name,
      data: props.data,
      accept: props.accept,
      autoUpload: props.autoUpload,
      listType: props.listType,
      disabled: props.disabled,
      limit: props.limit,
      fileList: props.fileList,
      showFileList: props.showFileList,
      httpRequest: props.httpRequest,
      beforeUpload: props.beforeUpload,
      onExceed: props.onExceed,
      onStart: handleStart,
      onProgress: handleProgress,
      onSuccess: handleSuccess,
      onError: handleError,
      onRemove: handleRemove
    }));
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", null, [
        unref(isPictureCard) && _ctx.showFileList ? (openBlock(), createBlock(_sfc_main$1, {
          key: 0,
          disabled: unref(disabled),
          "list-type": _ctx.listType,
          files: unref(uploadFiles),
          "handle-preview": _ctx.onPreview,
          onRemove: unref(handleRemove)
        }, createSlots({
          append: withCtx(() => [
            _ctx.listType === "picture-card" ? (openBlock(), createBlock(_sfc_main$2, mergeProps({
              key: 0,
              ref_key: "uploadRef",
              ref: uploadRef
            }, unref(uploadContentProps)), {
              default: withCtx(() => [
                unref(slots).trigger ? renderSlot(_ctx.$slots, "trigger", { key: 0 }) : createCommentVNode("v-if", true),
                !unref(slots).trigger && unref(slots).default ? renderSlot(_ctx.$slots, "default", { key: 1 }) : createCommentVNode("v-if", true)
              ]),
              _: 3
            }, 16)) : createCommentVNode("v-if", true)
          ]),
          _: 2
        }, [
          _ctx.$slots.file ? {
            name: "default",
            fn: withCtx(({ file }) => [
              renderSlot(_ctx.$slots, "file", { file })
            ])
          } : void 0
        ]), 1032, ["disabled", "list-type", "files", "handle-preview", "onRemove"])) : createCommentVNode("v-if", true),
        _ctx.listType !== "picture-card" ? (openBlock(), createBlock(_sfc_main$2, mergeProps({
          key: 1,
          ref_key: "uploadRef",
          ref: uploadRef
        }, unref(uploadContentProps)), {
          default: withCtx(() => [
            unref(slots).trigger ? renderSlot(_ctx.$slots, "trigger", { key: 0 }) : createCommentVNode("v-if", true),
            !unref(slots).trigger && unref(slots).default ? renderSlot(_ctx.$slots, "default", { key: 1 }) : createCommentVNode("v-if", true)
          ]),
          _: 3
        }, 16)) : createCommentVNode("v-if", true),
        _ctx.$slots.trigger ? renderSlot(_ctx.$slots, "default", { key: 2 }) : createCommentVNode("v-if", true),
        renderSlot(_ctx.$slots, "tip"),
        !unref(isPictureCard) && _ctx.showFileList ? (openBlock(), createBlock(_sfc_main$1, {
          key: 3,
          disabled: unref(disabled),
          "list-type": _ctx.listType,
          files: unref(uploadFiles),
          "handle-preview": _ctx.onPreview,
          onRemove: unref(handleRemove)
        }, createSlots({ _: 2 }, [
          _ctx.$slots.file ? {
            name: "default",
            fn: withCtx(({ file }) => [
              renderSlot(_ctx.$slots, "file", { file })
            ])
          } : void 0
        ]), 1032, ["disabled", "list-type", "files", "handle-preview", "onRemove"])) : createCommentVNode("v-if", true)
      ]);
    };
  }
});

export { _sfc_main as default };
//# sourceMappingURL=upload2.mjs.map
