import type { InjectionKey, SetupContext, UnwrapRef } from 'vue';
import type { ComponentSize } from 'element-plus/es/constants';
import type { FormProps, FormEmits, FormItemProp, FormItemProps, FormValidateCallback, FormLabelWidthContext } from 'element-plus/es/components/form';
import type { Arrayable } from 'element-plus/es/utils';
export declare type FormContext = FormProps & UnwrapRef<FormLabelWidthContext> & {
    emit: SetupContext<FormEmits>['emit'];
    addField: (field: FormItemContext) => void;
    removeField: (field: FormItemContext) => void;
    resetFields: (props?: Arrayable<FormItemProp>) => void;
    clearValidate: (props?: Arrayable<FormItemProp>) => void;
    validateField: (props?: Arrayable<FormItemProp>, callback?: FormValidateCallback) => Promise<void>;
};
export interface FormItemContext extends FormItemProps {
    $el: HTMLDivElement | undefined;
    size: ComponentSize;
    validateState: string;
    validate: (trigger: string, callback?: FormValidateCallback) => Promise<void>;
    resetField(): void;
    clearValidate(): void;
}
export declare const formContextKey: InjectionKey<FormContext>;
export declare const formItemContextKey: InjectionKey<FormItemContext>;
