'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../tokens/index.js');
require('../../../hooks/index.js');
var buttonGroup = require('./button-group.js');
var button = require('../../../tokens/button.js');
var index = require('../../../hooks/use-namespace/index.js');

const __default__ = {
  name: "ElButtonGroup"
};
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: buttonGroup.buttonGroupProps,
  setup(__props) {
    const props = __props;
    vue.provide(button.buttonGroupContextKey, vue.reactive({
      size: vue.toRef(props, "size"),
      type: vue.toRef(props, "type")
    }));
    const ns = index.useNamespace("button");
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("div", {
        class: vue.normalizeClass(`${vue.unref(ns).b("group")}`)
      }, [
        vue.renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});

exports["default"] = _sfc_main;
//# sourceMappingURL=button-group2.js.map
