'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
require('../../../hooks/index.js');
var checkTag = require('./check-tag.js');
var index = require('../../../hooks/use-namespace/index.js');

const __default__ = {
  name: "ElCheckTag"
};
const _sfc_main = /* @__PURE__ */ vue.defineComponent({
  ...__default__,
  props: checkTag.checkTagProps,
  emits: checkTag.checkTagEmits,
  setup(__props, { emit }) {
    const props = __props;
    const ns = index.useNamespace("check-tag");
    const handleChange = () => {
      const checked = !props.checked;
      emit("change", checked);
      emit("update:checked", checked);
    };
    return (_ctx, _cache) => {
      return vue.openBlock(), vue.createElementBlock("span", {
        class: vue.normalizeClass([vue.unref(ns).b(), vue.unref(ns).is("checked", _ctx.checked)]),
        onClick: handleChange
      }, [
        vue.renderSlot(_ctx.$slots, "default")
      ], 2);
    };
  }
});

exports["default"] = _sfc_main;
//# sourceMappingURL=check-tag2.js.map
