'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var useOption = require('../useOption.js');
var color = require('../color.js');
var pluginVue_exportHelper = require('../../../../_virtual/plugin-vue_export-helper.js');

const _sfc_main = vue.defineComponent({
  props: {
    colors: { type: Array, required: true },
    color: {
      type: Object,
      required: true
    }
  },
  setup(props) {
    const { currentColor } = useOption.useOptions();
    const rgbaColors = vue.ref(parseColors(props.colors, props.color));
    vue.watch(() => currentColor.value, (val) => {
      const color$1 = new color["default"]();
      color$1.fromString(val);
      rgbaColors.value.forEach((item) => {
        item.selected = color$1.compare(item);
      });
    });
    vue.watchEffect(() => {
      rgbaColors.value = parseColors(props.colors, props.color);
    });
    function handleSelect(index) {
      props.color.fromString(props.colors[index]);
    }
    function parseColors(colors, color$1) {
      return colors.map((value) => {
        const c = new color["default"]();
        c.enableAlpha = true;
        c.format = "rgba";
        c.fromString(value);
        c.selected = c.value === color$1.value;
        return c;
      });
    }
    return {
      rgbaColors,
      handleSelect
    };
  }
});
const _hoisted_1 = { class: "el-color-predefine" };
const _hoisted_2 = { class: "el-color-predefine__colors" };
const _hoisted_3 = ["onClick"];
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createElementBlock("div", _hoisted_1, [
    vue.createElementVNode("div", _hoisted_2, [
      (vue.openBlock(true), vue.createElementBlock(vue.Fragment, null, vue.renderList(_ctx.rgbaColors, (item, index) => {
        return vue.openBlock(), vue.createElementBlock("div", {
          key: _ctx.colors[index],
          class: vue.normalizeClass(["el-color-predefine__color-selector", { selected: item.selected, "is-alpha": item._alpha < 100 }]),
          onClick: ($event) => _ctx.handleSelect(index)
        }, [
          vue.createElementVNode("div", {
            style: vue.normalizeStyle({ backgroundColor: item.value })
          }, null, 4)
        ], 10, _hoisted_3);
      }), 128))
    ])
  ]);
}
var Predefine = /* @__PURE__ */ pluginVue_exportHelper["default"](_sfc_main, [["render", _sfc_render]]);

exports["default"] = Predefine;
//# sourceMappingURL=predefine.js.map
